/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.ChartModel;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Filler;
import com.cisco.dcbu.lib.ui.PrintUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import jclass.chart.ChartDataModelUpdate;
import jclass.chart.ChartDataView;
import jclass.chart.Chartable;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartArea;
import jclass.chart.JCLabelGenerator;

public class ChartDialog
extends JFrame
implements ActionListener,
Printable {
    public static final int LINE = 0;
    public static final int AREA = 8;
    public static final int BAR = 9;
    public static final int PIE = 11;
    public static final Font _AxisFont = new Font(ChangedCellRenderer.getNormalFont().getName(), 0, ChangedCellRenderer.getNormalFont().getSize() - 2);
    static final String[][] _ButtonAttr = new String[][]{{"icons/stacked.gif", "Stacked", "S"}, {"icons/horizontal.gif", "Horizontal", "H"}, {"icons/logscale.gif", "Log Scale", "l"}, {"icons/LineGraph.gif", "Line Chart", "L"}, {"icons/AreaGraph.gif", "Area Chart", "A"}, {"icons/BarGraph.gif", "Bar Chart", "B"}, {"icons/print16.gif", "Print Graph...", "P"}, {"icons/Save16.gif", "Export to Tab-Delimited File...", "E", null}};
    static final int STACKED_BUTTON = 0;
    static final int HORIZONTAL_BUTTON = 1;
    static final int LOG_BUTTON = 2;
    static final int LINE_BUTTON = 3;
    static final int AREA_BUTTON = 4;
    static final int BAR_BUTTON = 5;
    static final int PRINT_BUTTON = 6;
    static final int EXPORT_BUTTON = 7;
    SnmpTableModel _model;
    SnmpKTable _table;
    protected AbstractButton[] _controls;
    protected JCChart _chart;
    protected ChartModel _chartModel;
    protected JComboBox _maxHistory;
    protected NumberGenerator _numberGenerator;
    private boolean _isAllZero;
    Object _threshold;

    public ChartDialog(JFrame frame, int type, SnmpKTable table, int[] selRows, int[] selCols, String title, boolean isSnapshot) throws Exception {
        this(frame, type, table, selRows, selCols, title, isSnapshot, null);
    }

    public ChartDialog(JFrame frame, int type, SnmpKTable table, int[] selRows, int[] selCols, String title, boolean isSnapshot, Object threshold) throws Exception {
        String subtitle;
        int nSel;
        this._threshold = threshold;
        this.setIconImage(Util.loadIcon((String)"icons/LogoIcon.gif").getImage());
        if (selRows.length > 1 && selCols.length > 1 && type == 11) {
            throw new Exception("Pie charts must have single dataset");
        }
        this._table = table;
        this._model = (SnmpTableModel)table.getModel();
        this._chartModel = this.buildModel(table, selRows, selCols, type, isSnapshot);
        this._chart = new JCChart(type);
        JCChartArea ca = this._chart.getChartArea();
        ca.setForeground(Color.white);
        ca.setBackground(Color.black);
        ca.setFont(_AxisFont);
        ca.setBorderWidth(2);
        ChartDataView dataView = this._chart.getDataView(0);
        dataView.setFastUpdate(true);
        JCAxis xaxis = dataView.getXAxis();
        if (!isSnapshot) {
            xaxis.setAnnotationMethod(2);
        }
        xaxis.getGridStyle().getLineStyle().setColor(Color.lightGray);
        xaxis.setGridIsShowing(true);
        JCAxis yaxis = dataView.getYAxis();
        yaxis.setGridIsShowing(true);
        yaxis.getGridStyle().getLineStyle().setColor(Color.lightGray);
        this._numberGenerator = new NumberGenerator();
        yaxis.setLabelGenerator((JCLabelGenerator)this._numberGenerator);
        dataView.setAutoLabel(true);
        this._chart.getLegend().setIsShowing(true);
        int n = nSel = selRows.length > 1 ? selRows.length : selCols.length;
        if (nSel < 5) {
            this._chart.getLegend().setAnchor(32);
            this._chart.getLegend().setOrientation(0);
        }
        dataView.setDataSource((Chartable)this._chartModel);
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(DialogUtil._Margin);
        main.add("Center", (Component)this._chart);
        main.add("North", this.buildControls(type, isSnapshot, selRows));
        this.getContentPane().add(main);
        this.setSize(new Dimension(nSel <= 5 ? 500 : 620, 400));
        this.setDefaultCloseOperation(2);
        if (!isSnapshot && title.indexOf(subtitle = this.getSubTitle(this._model, selRows, selCols)) == -1) {
            title = title + ", " + subtitle;
        }
        this.setTitle(title);
    }

    protected String getSubTitle(SnmpTableModel model, int[] selRows, int[] selCols) {
        return selRows.length > 1 ? this._model.getColumnNameWithoutHtml(selCols[0]) : this._table.getIndexCellString((TableModel)model, selRows[0], 0);
    }

    protected ChartModel buildModel(SnmpKTable table, int[] selRows, int[] selCols, int type, boolean isSnapshot) throws Exception {
        return new ChartModel(table, selRows, selCols, type, isSnapshot, this._threshold);
    }

    protected JPanel buildControls(int type, boolean isSnapshot, int[] selRows) {
        boolean multiRowSelected;
        JPanel controls = new JPanel(new FlowLayout(0, 0, 0));
        this._controls = new AbstractButton[_ButtonAttr.length];
        if (type != 11) {
            for (int i = 0; i <= 2; ++i) {
                this._controls[i] = Util.createToggleButton((String)_ButtonAttr[i][0], (String)_ButtonAttr[i][1], (String)_ButtonAttr[i][2], (ActionListener)this);
                controls.add(this._controls[i]);
            }
            controls.add((Component)new Filler(new Dimension(5, 10)));
            ButtonGroup bg = new ButtonGroup();
            for (int i = 3; i <= 5; ++i) {
                this._controls[i] = Util.createToggleButton((String)_ButtonAttr[i][0], (String)_ButtonAttr[i][1], (String)_ButtonAttr[i][2], (ActionListener)this);
                bg.add(this._controls[i]);
                controls.add(this._controls[i]);
            }
            if (type == 0) {
                this._controls[3].setSelected(true);
                this._controls[0].setEnabled(false);
            } else if (type == 8) {
                this._controls[4].setSelected(true);
            } else {
                this._controls[5].setSelected(true);
            }
            controls.add((Component)new Filler(new Dimension(5, 10)));
        }
        this._controls[6] = Util.createButton((String)_ButtonAttr[6][0], (String)_ButtonAttr[6][1], (String)_ButtonAttr[6][2], (ActionListener)this);
        controls.add(this._controls[6]);
        this._controls[7] = Util.createButton((String)_ButtonAttr[7][0], (String)_ButtonAttr[7][1], (String)_ButtonAttr[7][2], (ActionListener)this);
        controls.add(this._controls[7]);
        if (type != 11) {
            if (!isSnapshot) {
                controls.add(new JLabel(" Max History:"));
                this._maxHistory = new JComboBox<String>(new String[]{"20", "30", "40", "50"});
                this._maxHistory.addActionListener(this);
                controls.add(this._maxHistory);
            }
            controls.add((Component)new Filler(new Dimension(5, 10)));
            JCheckBox fyA = new JCheckBox("Fix YAxis");
            fyA.addActionListener(this);
            controls.add(fyA);
        }
        boolean bl = multiRowSelected = selRows.length > 0;
        if (this._controls[3] != null) {
            this._controls[3].setEnabled(multiRowSelected && !isSnapshot);
        }
        if (this._controls[4] != null) {
            this._controls[4].setEnabled(multiRowSelected && !isSnapshot && this._threshold == null);
        }
        return controls;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._maxHistory) {
            this._chartModel._maxElements = Integer.parseInt(this._maxHistory.getSelectedItem().toString());
            return;
        }
        boolean isSelected = ((AbstractButton)e.getSource()).isSelected();
        ChartDataView dataView = this._chart.getDataView(0);
        switch (((AbstractButton)e.getSource()).getActionCommand().charAt(0)) {
            case 'S': {
                switch (dataView.getChartType()) {
                    case 9: {
                        dataView.setChartType(10);
                        break;
                    }
                    case 10: {
                        dataView.setChartType(9);
                        break;
                    }
                    case 8: {
                        dataView.setChartType(12);
                        break;
                    }
                    case 12: {
                        dataView.setChartType(8);
                    }
                }
                break;
            }
            case 'H': {
                dataView.setIsInverted(isSelected);
                break;
            }
            case 'l': {
                dataView.getYAxis().setIsLogarithmic(isSelected && !this._isAllZero);
                dataView.getYAxis().setLabelGenerator((JCLabelGenerator)(isSelected && !this._isAllZero ? null : this._numberGenerator));
                break;
            }
            case 'F': {
                if (isSelected) {
                    dataView.getYAxis().setMax(dataView.getYAxis().getMax());
                    dataView.getYAxis().setMin(dataView.getYAxis().getMin());
                    break;
                }
                dataView.getYAxis().setMaxIsDefault(true);
                dataView.getYAxis().setMinIsDefault(true);
                break;
            }
            case 'L': {
                dataView.setChartType(0);
                this._controls[0].setEnabled(false);
                break;
            }
            case 'A': {
                this._controls[0].setEnabled(true);
                dataView.setChartType(this._controls[0].isSelected() ? 12 : 8);
                break;
            }
            case 'B': {
                this._controls[0].setEnabled(true);
                dataView.setChartType(this._controls[0].isSelected() ? 10 : 9);
                break;
            }
            case 'P': {
                if (!PrintUtil.getPrintJob().printDialog()) break;
                try {
                    PrintUtil.setPrintable((Printable)this);
                    PrintUtil.getPrintJob().print();
                }
                catch (PrinterException ex) {
                    Util.errorMessage((Component)DeviceManager.getInstance(), (Exception)ex);
                }
                break;
            }
            case 'E': {
                String fName = Util.getFileName((JFrame)this, (String)"*.txt", (int)1);
                if (fName == null) break;
                this._chartModel.export(fName, this);
            }
        }
    }

    @Override
    public int print(Graphics pg, PageFormat pf, int pi) throws PrinterException {
        if (pi > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)pg;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        this._chart.printAll(pg);
        return 0;
    }

    public void addRow() throws Exception {
        this._isAllZero = this._chartModel.isAllZero();
        if (this._isAllZero) {
            this._chart.getDataView(0).getYAxis().setIsLogarithmic(false);
            this._chart.getDataView(0).getYAxis().setLabelGenerator((JCLabelGenerator)this._numberGenerator);
        }
        this._chartModel.addRow(this._chart.getDataView(0).getChartType());
        this._chartModel.notifyObservers(new ChartDataModelUpdate(14, 0, 0));
    }

    static class NumberGenerator
    implements JCLabelGenerator {
        NumberGenerator() {
        }

        public Object makeLabel(double d, int precision) {
            if (precision != 0) {
                if (d >= 1.0E9) {
                    return d / 1.0E9 + "G";
                }
                if (d >= 1000000.0) {
                    return d / 1000000.0 + "M";
                }
                if (d >= 1000.0) {
                    return d / 1000.0 + "K";
                }
            }
            return Double.toString(d);
        }
    }
}

