/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.Controls;
import com.cisco.dcbu.dm.DM;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.LastOpened;
import com.cisco.dcbu.dm.LegendMenuButton;
import com.cisco.dcbu.dm.OpenDialog;
import com.cisco.dcbu.dm.PhysicalStatus;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.PrefDialogEM;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.LogDialog;
import com.cisco.dcbu.lib.jnm.VshLog;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.ColoredSquare;
import com.cisco.dcbu.lib.ui.CommandDispatcher;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.IdleTimeOut;
import com.cisco.dcbu.lib.ui.MnemonicTabbedPane;
import com.cisco.dcbu.lib.ui.PrintUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.PerspectiveUtil;
import com.cisco.dcbu.lib.util.PerspectiveViewMeta;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.DocAttributeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class DeviceManager
extends JFrame
implements ChangeListener {
    public static String _AppName = "Device Manager 6.3(2)";
    static DeviceManager _Instance;
    public CommandDispatcher _listener = new CommandDispatcher((Object)this);
    public JMenuBar _menubar = Controls.buildMenubar((ActionListener)this._listener);
    public JPanel _toolbar;
    private JTextField _status;
    MnemonicTabbedPane _tab;
    public JPanel _summary;
    public JPanel _legend;
    public LegendMenuButton _legendMenuButton;
    public JCheckBox _exportMode;
    boolean _SimpleMode = false;
    PhysicalView _view;
    PrefDialogEM _prefDialog;
    LogDialog _logDialog;
    Dimension _viewSize;
    Dimension _summarySize;
    Dimension _prefSize;
    Dimension _fvSize;
    Dimension _fsSize;
    DialogSeparator _dialogSeparator = null;
    InputStream is = null;
    static boolean _viewsLoaded;
    private static Map<String, PerspectiveViewMeta> _perspectiveMap;

    public static DeviceManager getInstance() {
        if (_Instance == null) {
            _Instance = new DeviceManager();
        }
        return _Instance;
    }

    private DeviceManager() {
        super(_AppName);
        this.setJMenuBar(this._menubar);
        JPanel main = new JPanel(new BorderLayout());
        boolean isMac = System.getProperty("os.name").startsWith("Mac");
        JPanel _toolbarPanel = new JPanel(new BorderLayout(isMac ? 2 : 0, 0));
        this._toolbar = Controls.buildToolbar((ActionListener)this._listener);
        this._exportMode = Controls.buildSimpleMode((ActionListener)this._listener);
        _toolbarPanel.add("Center", this._toolbar);
        _toolbarPanel.add("East", this._exportMode);
        Box box = new Box(1);
        box.add(_toolbarPanel);
        this._dialogSeparator = new DialogSeparator();
        box.add((Component)this._dialogSeparator);
        main.add("North", box);
        this._status = new JTextField();
        this._status.setEditable(false);
        this._status.setBackground(main.getBackground());
        this._status.setForeground(this._menubar.getForeground());
        this._status.setBorder(BorderFactory.createEmptyBorder());
        try {
            PrefDialogEM.load();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            LastOpened.getInstance().load();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (!_viewsLoaded) {
            String parserError = null;
            try {
                _perspectiveMap = PerspectiveUtil.loadPerspectiveViews((int)1);
                _viewsLoaded = true;
            }
            catch (Exception ex) {
                parserError = ex.getMessage();
                String msg = "ERROR: " + parserError;
                DefaultLogger._DefLogger.warn((Object)msg);
            }
            String[] perspectives = new String[]{"advanced", "simple"};
            boolean isMissing = false;
            for (int i = 0; i < perspectives.length; ++i) {
                PerspectiveViewMeta doc = this.getPerspective(perspectives[i]);
                if (doc != null) continue;
                isMissing = true;
            }
            if (isMissing) {
                String msg = "ERROR: Perspective file(s) missing or format error.";
                if (parserError != null) {
                    msg = msg + "\n" + parserError;
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                DefaultLogger._DefLogger.warn((Object)msg);
            }
        }
        this._tab = new MnemonicTabbedPane();
        this._view = new PhysicalView();
        this._tab.add("Device", (Component)new JScrollPane(this._view));
        this._tab.setMnemonicAt(0, 'v');
        this._summary = new JPanel(new BorderLayout());
        this._tab.add("Summary", (Component)this._summary);
        this._tab.addChangeListener((ChangeListener)this);
        this._tab.setMnemonicAt(1, 'u');
        main.add("Center", (Component)this._tab);
        JPanel bottom = new JPanel(new BorderLayout());
        JPanel legendPanel = new JPanel(new BorderLayout());
        this._legend = new JPanel(new FlowLayout(2, 2, 2));
        for (int i = 0; i < AbstractPort._Colors.length; ++i) {
            this._legend.add(new JLabel((Icon)new ColoredSquare(AbstractPort._Colors[i])));
            this._legend.add(new JLabel(AbstractPort._StatusLabel[i]));
        }
        legendPanel.add("Center", this._legend);
        this._legendMenuButton = new LegendMenuButton(null, this._legend);
        this._legendMenuButton.setToolTipText("Legends");
        legendPanel.add("East", (Component)((Object)this._legendMenuButton));
        bottom.add("Center", this._status);
        bottom.add("East", legendPanel);
        main.add("South", bottom);
        this.getContentPane().add(main);
        this.pack();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DeviceManager.this.exitAction();
            }
        });
        this.setIconImage(Util.loadIcon((String)"icons/LogoIcon.gif").getImage());
        this.setLocation((int)(Math.random() * 90.0), (int)(Math.random() * 30.0));
        IdleTimeOut.setParentWindow((Window)this);
        IdleTimeOut.setCloseAction((Runnable)new Runnable(){

            @Override
            public void run() {
                DeviceManager.this.exitAction();
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._prefSize == null) {
            return super.getPreferredSize();
        }
        return this._prefSize;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Dimension d;
        boolean isSummary = false;
        if (this._tab.getSelectedComponent() == this._summary) {
            JMenuItem mi;
            this._fvSize = this.getSize();
            isSummary = true;
            this._prefSize = this._fsSize;
            if (this._viewSize == null) {
                this._viewSize = this._tab.getPreferredSize();
                this._viewSize.width += 3;
            }
            Discover._root.showSummary(this._summary, true);
            if (this._summarySize == null) {
                d = new Dimension(this._summary.getPreferredSize());
                this.offsetViewSizeByTab(d);
                this._prefSize = null;
            } else {
                d = this._summarySize;
            }
            this._legend.setVisible(false);
            this._view.clearSelection();
            PhysicalStatus.getInstance().setStatusTimer(false);
            JMenu helpMenu = DeviceManager.getInstance()._menubar.getMenu(9);
            if (helpMenu != null && (mi = DmSystem.getMenuItem((JMenu)helpMenu, (String)"Contents")) != null) {
                mi.setActionCommand("helpDialog SummView");
            }
        } else {
            JMenuItem mi;
            if (PhysicalStatus._StatusPollTimerEnable) {
                PhysicalStatus.getInstance().setStatusTimer(true);
                PhysicalStatus.getInstance().resetStatusTimerInterval();
            }
            this._fsSize = this.getSize();
            this._prefSize = this._fvSize;
            if (this._summarySize == null) {
                this._summarySize = this._tab.getPreferredSize();
            }
            Discover._root.showSummary(this._summary, false);
            Discover._root.showDeviceView(true);
            if (this._viewSize == null) {
                d = new Dimension(this._view.getPreferredSize());
                this.offsetViewSizeByTab(d);
            } else {
                d = this._viewSize;
            }
            this._legend.setVisible(true);
            JMenu helpMenu = DeviceManager.getInstance()._menubar.getMenu(9);
            if (helpMenu != null && (mi = DmSystem.getMenuItem((JMenu)helpMenu, (String)"Contents")) != null) {
                mi.setActionCommand("helpDialog index");
            }
        }
        this._tab.setPreferredSize(d);
        this._tab.validate();
        this.invalidate();
        this.validate();
        if (isSummary) {
            this._summary.validate();
        }
        this._dialogSeparator.setWidth(this._tab.getWidth());
        this.pack();
    }

    void offsetViewSizeByTab(Dimension d) {
        d.height += this._tab.getBoundsAt((int)0).height + 12;
        d.width += 13;
    }

    public boolean showingPhysicalView() {
        return this._tab.getSelectedIndex() == 0;
    }

    public void showPhysicalView() {
        if (!this.showingPhysicalView()) {
            this._tab.setSelectedIndex(0);
            this._dialogSeparator.setWidth(this._tab.getWidth());
            this._prefSize = null;
            this._viewSize = null;
            this._summarySize = null;
            this._fsSize = null;
            this._fvSize = null;
            this.pack();
        }
    }

    public void showSummaryView() {
        boolean isSummary = true;
        if (!this.showingPhysicalView()) {
            this._fsSize = this.getSize();
        } else {
            this._fvSize = this.getSize();
        }
        Dimension d = new Dimension(this._summary.getPreferredSize());
        this.offsetViewSizeByTab(d);
        this._prefSize = null;
        this._tab.setSelectedIndex(1);
        this._tab.setPreferredSize(d);
        this._tab.validate();
        this.invalidate();
        this.validate();
        if (isSummary) {
            this._summary.validate();
        }
        this._dialogSeparator.setWidth(this._tab.getWidth());
        this.pack();
    }

    public void openAction(String deviceName) {
        OpenDialog d = OpenDialog.getInstance(this, OpenDialog.IsEnablePriavcyInput);
        d.setDeviceName(deviceName);
        d.setVisible(true);
    }

    public void openAction() {
        OpenDialog.getInstance(this, OpenDialog.IsEnablePriavcyInput).setVisible(true);
    }

    public void open(String deviceName, String userName, String authPassword, String privPassword, InetSocketAddress proxyAddr) throws SnmpException, UnknownHostException, Exception {
        this._viewSize = null;
        this._summarySize = null;
        this._prefSize = null;
        this._dialogSeparator.setWidth(this._tab.getWidth());
        Discover.getInstance().open(deviceName, userName, authPassword, privPassword, proxyAddr);
        LastOpened.getInstance().record(deviceName, userName, authPassword, privPassword);
    }

    public void helpDialog(String helpTopic) throws Exception {
        if (helpTopic == null || helpTopic.equals("")) {
            Util.errorMessage((Component)this, (String)("Help on topic " + helpTopic + " can't be found"));
            return;
        }
        helpTopic = helpTopic.toLowerCase();
        String htmlFile = helpTopic + ".html";
        if (SnmpSession.isTrace()) {
            DefaultLogger._DefLogger.debug((Object)("Open: " + ClientCache.getInstallLocation() + File.separator + "help" + File.separator + "fmhelp" + File.separator + htmlFile + "\""));
        }
        ExternalTools.openURL((String)(ClientCache.getInstallLocation() + File.separator + "help" + File.separator + "fmhelp" + File.separator + htmlFile));
    }

    public void propsAction() {
        if (this._prefDialog == null) {
            this._prefDialog = new PrefDialogEM(this, _AppName);
        }
        this._prefDialog.setVisible(true);
    }

    public void printAction() {
        final DocFlavor.BYTE_ARRAY doc = DocFlavor.BYTE_ARRAY.JPEG;
        File file = null;
        try {
            block13: {
                StringBuilder stringBuilder = new StringBuilder().append(ClientCache.getDir()).append(File.separatorChar).append("DM_Print_");
                Discover.getInstance();
                String fName = stringBuilder.append(Discover.getDeviceName()).append(".jpg").toString();
                file = new File(fName);
                file.deleteOnExit();
                try {
                    this.exportJPEG(file);
                }
                catch (Exception ex1) {
                    Util.errorMessage((Component)this, (String)("Can't create output file to print (" + ex1.getMessage() + ")"));
                    if (!SnmpSession.isTrace()) break block13;
                    ex1.printStackTrace();
                }
            }
            this.is = new FileInputStream(file);
        }
        catch (FileNotFoundException ex1) {
            DefaultLogger._DefLogger.warn((Object)ex1.getMessage(), (Throwable)ex1);
            return;
        }
        Doc printDoc = new Doc(){

            @Override
            public Reader getReaderForText() {
                return null;
            }

            @Override
            public DocAttributeSet getAttributes() {
                return null;
            }

            @Override
            public InputStream getStreamForBytes() {
                return DeviceManager.this.is;
            }

            @Override
            public Object getPrintData() {
                return DeviceManager.this.is;
            }

            @Override
            public DocFlavor getDocFlavor() {
                return doc;
            }
        };
        PrintService[] printerSupport = PrintServiceLookup.lookupPrintServices(doc, null);
        if (printerSupport == null || printerSupport.length == 0) {
            return;
        }
        PrinterJob pJob = PrintUtil.getPrintJob();
        if (!pJob.printDialog()) {
            return;
        }
        PrintService pService = pJob.getPrintService();
        PrintService printService = null;
        for (int i = 0; i < printerSupport.length; ++i) {
            if (!printerSupport[i].equals(pService)) continue;
            printService = printerSupport[i];
        }
        if (printService == null) {
            return;
        }
        DocPrintJob printJob = printService.createPrintJob();
        try {
            printJob.print(printDoc, null);
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)ex);
        }
        if (file != null) {
            try {
                file.delete();
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    public void exportAction() {
        DeviceManager deviceManager = this.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        Discover.getInstance();
        String fName = Util.getFileName((JFrame)deviceManager, (String)stringBuilder.append(Discover.getDeviceName()).append(".jpg").toString(), (int)1, (boolean)true);
        if (fName == null) {
            return;
        }
        try {
            this.exportJPEG(new File(fName));
        }
        catch (IOException ex1) {
            Util.errorMessage((Component)this, (Exception)ex1);
            if (SnmpSession.isTrace()) {
                ex1.printStackTrace();
            }
            this.exportAction();
        }
    }

    private void exportJPEG(File f) throws IOException {
        FilterOutputStream fStream = null;
        try {
            fStream = new BufferedOutputStream(new FileOutputStream(f));
            PhysicalView view = this.getView();
            BufferedImage img = new BufferedImage(view.getWidth(), view.getHeight(), 1);
            view.paint(img.getGraphics());
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fStream);
            encoder.encode(img);
        }
        catch (IOException ex1) {
            throw ex1;
        }
        finally {
            if (fStream != null) {
                try {
                    fStream.close();
                }
                catch (IOException ex1) {}
            }
        }
    }

    public void refreshAction() {
        if (Discover.root() != null) {
            if (Discover.getIsReDiscoverInProgress()) {
                DefaultLogger._DefLogger.debug((Object)"Re-discovery is in progress, ignore refresh");
                return;
            }
            this.setStatus(" ");
            PhysicalStatus.getInstance().getStatus();
            Discover._root.refresh();
        }
    }

    public void rediscoverAction() throws SnmpException {
        if (Discover.root() != null) {
            Discover.getInstance().rediscover();
        }
    }

    public void errorLogAction() {
        if (this._logDialog == null) {
            this._logDialog = new LogDialog((JFrame)this, DM._logWriter);
        }
        this._logDialog.setTitle(_AppName + " " + Discover.getDeviceName() + " - Message Log");
        this._logDialog.setVisible(true);
    }

    public void summaryLogAction() {
        try {
            String hostName = Discover.getSystemName().equals("") ? Discover.getDeviceName() : Discover.getSystemName();
            String fileName = ClientCache.getLogsDir() + File.separator + hostName + "_summarylog.txt";
            File logFile = new File(fileName);
            if (!logFile.exists()) {
                throw new Exception();
            }
            DeviceManager.getInstance().urlAction(fileName);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, (String)"Failed to open summary log. (You must check Log in Summary Tab to capture traffic and errors.)");
        }
    }

    public void exitAction() {
        boolean isCancel;
        try {
            DeviceManager deviceManager = this;
            deviceManager._prefDialog.save();
        }
        catch (IOException ex) {
            DefaultLogger._DefLogger.debug((Object)("prefs: " + ex));
        }
        try {
            LastOpened.getInstance().save();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (Discover._root != null && (isCancel = Discover._root.closeDevice())) {
            return;
        }
        System.exit(0);
    }

    public void VSAN() {
    }

    public void PORT_RESERVE() {
    }

    public void dialogAction(String method) throws NoSuchMethodException, IllegalAccessException {
        DialogListener.getInstance().dialogAction(method);
    }

    public void selectAction(String className) throws ClassNotFoundException {
        this._view.selectAll(Class.forName(className));
    }

    public void deviceAction(String method) throws IllegalAccessException {
        StringTokenizer strTok = new StringTokenizer(method, " ");
        String[] methodArgs = new String[strTok.countTokens() - 1];
        method = strTok.nextToken();
        if (methodArgs.length > 0) {
            for (int i = 0; i < methodArgs.length; ++i) {
                methodArgs[i] = strTok.nextToken();
            }
        }
        Discover.getInstance();
        this.action(method, Discover._root.getClass(), methodArgs);
    }

    public void deviceAction(boolean on, String method) throws IllegalAccessException {
        this.deviceAction(method);
    }

    void action(String method, Class c, String[] methodArgs) throws IllegalAccessException {
        try {
            int typesLength = methodArgs.length > 0 ? 3 : 2;
            Class[] types = new Class[typesLength];
            types[0] = JFrame.class;
            types[1] = SnmpPeer.class;
            Object[] args = new Object[typesLength];
            args[0] = this;
            Discover.getInstance();
            args[1] = Discover.getPeer();
            if (types.length == 3) {
                types[2] = String[].class;
                args[2] = methodArgs;
            }
            Method m = c.getMethod(method, types);
            m.invoke((Object)c, args);
        }
        catch (InvocationTargetException ex) {
            Throwable realEx = ex.getCause();
            if (realEx == null) {
                realEx = ex;
            }
            Util.errorMessage((Component)this, (Exception)((Exception)realEx));
            if (SnmpSession.isTrace()) {
                realEx.printStackTrace();
            }
        }
        catch (NoSuchMethodException ex) {
            Util.errorMessage((Component)this, (String)("No such method: " + method));
        }
    }

    public void telnetAction() throws Exception {
        if (Discover.root() != null) {
            int FEATURE_ENABLED = 2;
            SnmpPeer peer = Discover.getPeer();
            VarBindList vbl = new VarBindList();
            int[] serviceActivation = MibNode.get((String)"cssServiceActivation").getOid();
            int[] sysTelnetServiceActivation = MibNode.get((String)"cseSysTelnetServiceActivation").getOid();
            vbl.add(new SnmpVarBind(new SnmpOID(serviceActivation, 0)));
            vbl.add(new SnmpVarBind(new SnmpOID(sysTelnetServiceActivation, 0)));
            if (vbl.size() != 0) {
                SnmpPDU resp = SnmpFetch.get((SnmpPeer)peer, (VarBindList)vbl);
                VarBindList vblResp = resp.getVariables();
                if (vblResp.size() < 2) {
                    Util.errorMessage((Component)this, (String)"Failed to verify telnet and secure shell services on switch.");
                    return;
                }
                int sshStatus = vblResp.intValue(0);
                int telnetStatus = vblResp.intValue(1);
                if (telnetStatus != 1 && sshStatus != 1) {
                    Util.errorMessage((Component)this, (String)"Please enable telnet or secure shell server on switch.");
                    return;
                }
                ExternalTools.setUseSSH((sshStatus == 1 ? 1 : 0) != 0);
            }
            ExternalTools.cli((String)Discover.getLoginDeviceName(), (String)peer.getAddress().getHostAddress(), (String)(peer.isV3() ? peer.getUserName() : null));
        }
    }

    public void aboutAction() {
        StringBuffer sb = new StringBuffer(232);
        sb.append(_AppName);
        sb.append("\n\nJVM: ");
        sb.append(System.getProperty("java.vendor"));
        sb.append(", ");
        sb.append(System.getProperty("java.version"));
        sb.append("\nPath: ");
        sb.append(System.getProperty("java.home"));
        sb.append("\nHome: ");
        sb.append(System.getProperty("user.home"));
        sb.append("\nOS: ");
        sb.append(System.getProperty("os.name"));
        sb.append(", ");
        sb.append(System.getProperty("os.arch"));
        sb.append(", ");
        sb.append(System.getProperty("os.version"));
        sb.append("\n\n(c) 2002-2013 Cisco Systems, Inc");
        JOptionPane.showMessageDialog(this, sb.toString(), "About", 1, Util.loadIcon((String)"icons/logo.gif"));
    }

    public void urlAction(String url) throws Exception {
        ExternalTools.openURL((String)url);
    }

    public void vshAction(String cmd) {
        try {
            String vshcmd;
            int indexOf = cmd.indexOf(" ");
            String clazzname = cmd.substring(0, indexOf);
            int hashIndex = cmd.indexOf("#");
            int titleIndex = cmd.indexOf("!");
            String titleString = null;
            String helpTopic = null;
            if (hashIndex == -1) {
                if (titleIndex == -1) {
                    vshcmd = cmd.substring(indexOf + 1);
                } else {
                    vshcmd = cmd.substring(indexOf + 1, titleIndex);
                    titleString = cmd.substring(titleIndex + 1);
                }
            } else {
                vshcmd = cmd.substring(indexOf + 1, hashIndex);
                if (titleIndex == -1) {
                    helpTopic = cmd.substring(hashIndex + 1);
                } else {
                    helpTopic = cmd.substring(hashIndex + 1, titleIndex - 1);
                    titleString = cmd.substring(titleIndex + 1);
                }
            }
            Class<?> clazz = Class.forName(clazzname);
            Class[] paramTypes = titleString == null ? new Class[]{Class.forName("javax.swing.JFrame"), Class.forName("java.lang.String"), Class.forName("com.cisco.dcbu.lib.snmp.SnmpPeer")} : new Class[]{Class.forName("javax.swing.JFrame"), Class.forName("java.lang.String"), Class.forName("com.cisco.dcbu.lib.snmp.SnmpPeer"), Class.forName("java.lang.String")};
            Constructor<?> constr = clazz.getConstructor(paramTypes);
            VshLog log = titleString == null ? (VshLog)constr.newInstance(this, vshcmd, Discover.getPeer()) : (VshLog)constr.newInstance(this, vshcmd, Discover.getPeer(), titleString);
            log.setVersion(Discover.getSysVersionObject());
            if (helpTopic != null) {
                log.setHelpTopic(helpTopic);
            }
            DmSystem.registerDialogHandler((VshLog)log);
            log.setVisible(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, (Exception)ex);
        }
    }

    public void sysLogAction(String cmd) {
        block21: {
            int hashIndex = cmd.indexOf(35);
            String helpTopic = null;
            if (hashIndex != -1) {
                helpTopic = cmd.substring(hashIndex + 1);
                cmd = cmd.substring(0, hashIndex);
            }
            int indexOf = cmd.indexOf(32);
            String log = cmd.substring(0, indexOf);
            String type = cmd.substring(indexOf + 1);
            String filename = ClientCache.getLogsDir() + File.separator + Discover.getPeer() + File.separator;
            if (type.startsWith("Recent")) {
                filename = filename + log.toLowerCase() + "0.log";
            } else {
                if (!new File(filename).exists()) {
                    Util.errorMessage((Component)this, (String)("The log is empty\n(" + filename + ")"));
                    return;
                }
                String pattern = log.toLowerCase() + "*.log";
                FileDialog f = new FileDialog((Frame)this, this.getTitle(), 0);
                f.setFile(pattern);
                f.setDirectory(filename);
                f.setVisible(true);
                filename = f.getFile();
                if (filename != null) {
                    filename = f.getDirectory() + filename;
                }
            }
            if (filename != null) {
                File file = new File(filename);
                if (!file.exists()) {
                    Util.errorMessage((Component)this, (String)(log + " logs not found locally \n(" + filename + ")."));
                    return;
                }
                if (file.length() == 0L) {
                    Util.errorMessage((Component)this, (String)("The log is empty\n(" + filename + ")."));
                    return;
                }
                try {
                    int start = filename.lastIndexOf(File.separatorChar);
                    int end = -1;
                    if (start != -1) {
                        end = filename.lastIndexOf(File.separatorChar, start - 1);
                    }
                    String title = " ";
                    if (start != -1 && end != -1) {
                        title = filename.substring(end + 1, start) + " - ";
                    }
                    String clazzname = null;
                    if (filename.indexOf("accounting") != -1) {
                        title = title + "Accounting Log";
                        clazzname = "AccountingLog";
                    } else if (filename.indexOf("hardware") != -1) {
                        title = title + "Hardware Log";
                        clazzname = "SysLog";
                    } else if (filename.indexOf("events") != -1) {
                        title = title + "Events Log";
                        clazzname = "SysLog";
                    } else if (filename.indexOf("rlir") != -1) {
                        title = title + "Link Incidents";
                        clazzname = "RlirLog";
                    } else {
                        Util.errorMessage((Component)this, (String)("Unknown log file\n" + filename));
                        return;
                    }
                    Class<?> clazz = Class.forName("com.cisco.dcbu.dmdb.andiamo.dialogs.syslog." + clazzname);
                    Class[] paramTypes = new Class[]{Class.forName("javax.swing.JFrame"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
                    Constructor<?> constr = clazz.getConstructor(paramTypes);
                    VshLog vlog = (VshLog)constr.newInstance(this, title, filename);
                    if (helpTopic != null) {
                        vlog.setHelpTopic(helpTopic);
                    }
                    vlog.setVisible(true);
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, (Exception)ex);
                    if (!SnmpSession.isTrace()) break block21;
                    DefaultLogger._DefLogger.warn((Object)ex.getMessage());
                }
            }
        }
    }

    public final void setStatus(String msg) {
        this._status.setText(msg);
    }

    public final void reSetLogTitle() {
        if (this._logDialog != null) {
            this._logDialog.setTitle(_AppName + " " + Discover.getDeviceName() + " - Message Log");
        }
    }

    public final String getStatus() {
        return this._status.getText();
    }

    public final JTextField getStatusLine() {
        return this._status;
    }

    public final JPanel getLegend() {
        return this._legend;
    }

    public final LegendMenuButton getLegendMenuButton() {
        return this._legendMenuButton;
    }

    public final PhysicalView getView() {
        return this._view;
    }

    public final MnemonicTabbedPane getViewTabs() {
        return this._tab;
    }

    public final PerspectiveViewMeta getPerspective(String viewName) {
        if (_perspectiveMap == null) {
            return null;
        }
        return _perspectiveMap.get(viewName);
    }

    void removeDeviceUI() {
        int i = 1;
        while (i < this._menubar.getMenuCount()) {
            this._menubar.remove(this._menubar.getMenu(i));
        }
        for (i = 0; i < this._toolbar.getComponentCount(); ++i) {
            if (this._toolbar.getComponent(i) != Controls._ViewAttrButton) continue;
            ++i;
            break;
        }
        while (i < this._toolbar.getComponentCount()) {
            Component c = this._toolbar.getComponent(i);
            this._toolbar.remove(c);
        }
    }

    public boolean findDeviceToolvar4Component(Component comp) {
        boolean found = false;
        for (int i = 0; i < this._toolbar.getComponentCount(); ++i) {
            Component c = this._toolbar.getComponent(i);
            if (c != comp) continue;
            found = true;
            break;
        }
        return found;
    }

    public void removeDeviceToolbarComponentAt(Component comp) {
        for (int i = 0; i < this._toolbar.getComponentCount(); ++i) {
            Component c = this._toolbar.getComponent(i);
            if (c != comp) continue;
            this._toolbar.remove(c);
            break;
        }
    }

    public void toggleSimpleMode(ActionEvent e) {
        this.setSimpleMode(!((JCheckBox)e.getSource()).isSelected());
        Discover._root.updateSimpleModeDisplay(((JCheckBox)e.getSource()).isSelected());
    }

    public boolean isSimpleMode() {
        return this._exportMode == null ? this._SimpleMode : !this._exportMode.isSelected();
    }

    public void setSimpleMode(boolean simple) {
        this._SimpleMode = simple;
        if (this._exportMode != null) {
            this._exportMode.setSelected(!simple);
        }
    }

    static {
        _viewsLoaded = false;
        _perspectiveMap = new HashMap<String, PerspectiveViewMeta>();
    }
}

