/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DM;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmPreferences;
import com.cisco.dcbu.dm.OpenDialog;
import com.cisco.dcbu.dm.PhysicalStatus;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Filler;
import com.cisco.dcbu.lib.ui.IdleTimeOut;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.ClientCache;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PrefDialogEM
extends JDialog
implements ActionListener {
    static final int VERSION = 9;
    static final String FILENAME = ClientCache.getLocation() + "dmpref.dat";
    JTextField _cliTimeout;
    protected int _version = 9;
    protected String _fileName;
    protected String _help = "dmPreferences";
    final String[] _Buttons = new String[]{"Apply", "OK", "Help", "Close"};
    protected JCheckBox _enablePoll;
    protected JLabel _pollUnit;
    protected JLabel _retryLabel;
    protected JLabel _timeoutLabel;
    protected JLabel _retryLabel3;
    protected JTextField _pollInterval;
    protected JTextField _retryCount;
    protected JTextField _timeout;
    protected JComponent[] _values;
    protected JPanel _pollingPanel;
    protected JPanel _SnmpPanel;
    static final int SNMP_PANEL = 0;
    static final int POLLING_PANEL = 1;
    static final int COMMON_SEPERATOR = 2;
    static final int TRACE_SNMP = 3;
    static final int TRAP_REGISTER = 4;
    static final int SHOW_WWN = 5;
    static final int WWN_CHOICE = 6;
    static final int SHOW_TIME_DT = 7;
    static final int TELNET_PATH = 8;
    static final int USE_SSH = 9;
    static final int SSH_PATH = 10;
    static final int CLI_SESN_TIMEOUT = 11;
    static final int SHOW_TOOLTIP = 12;
    static final int VIEW_PORT_LABEL = 13;
    static final int EXPORT = 14;
    static final int IDLE_TIME_OUT = 15;
    static final int UNIX_BROWSER = 16;
    int _totalNumFields = DM._IsWindows ? 16 : 17;

    public PrefDialogEM(JFrame parent, String title) {
        super((Frame)parent, title + " - Preferences");
        this._fileName = FILENAME;
        this._pollingPanel = this.buildPollingPanel();
        this._SnmpPanel = this.buildSnmpPanel();
        String[] labels = new String[this._totalNumFields];
        this._values = new JComponent[labels.length];
        this._values[0] = this._SnmpPanel;
        this._values[1] = this._pollingPanel;
        this._values[2] = new DialogSeparator();
        this.buildComponents(this._values);
        JPanel main = DialogUtil.buildPanel((JComponent[])DialogUtil.buildLabels((String[])labels), (JComponent[])this._values);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)main, (AbstractButton[])DialogUtil.buildButtons((String[])this._Buttons, (ActionListener)this));
    }

    protected JPanel buildPollingPanel() {
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        this._enablePoll = new JCheckBox("Enable status polling every");
        this._enablePoll.setActionCommand("E");
        this._enablePoll.addActionListener(this);
        this._pollInterval = new JTextField(5);
        p.add(this._enablePoll);
        p.add(this._pollInterval);
        this._pollUnit = new JLabel(" secs");
        this._pollUnit.setForeground(this._pollInterval.getForeground());
        p.add(this._pollUnit);
        return p;
    }

    protected JPanel buildSnmpPanel() {
        JPanel p1 = new JPanel(new FlowLayout(0, 0, 0));
        this._retryLabel = new JLabel("Retry requests ");
        this._retryLabel.setForeground(this._pollInterval.getForeground());
        p1.add(this._retryLabel);
        this._retryCount = new JTextField(2);
        p1.add(this._retryCount);
        this._timeoutLabel = new JLabel(" time(s) after ");
        this._timeoutLabel.setForeground(this._pollInterval.getForeground());
        p1.add(this._timeoutLabel);
        this._timeout = new JTextField(4);
        p1.add(this._timeout);
        this._retryLabel3 = new JLabel(" sec timeout");
        this._retryLabel3.setForeground(this._pollInterval.getForeground());
        p1.add(this._retryLabel3);
        return p1;
    }

    private void buildComponents(JComponent[] values) {
        this._values[3] = new JCheckBox("Trace SNMP packets in Message Log");
        String trapPort = DM._Port == -1 ? "n/a" : Integer.toString(DM._Port);
        this._values[4] = new JCheckBox("Register for Events after Open, listen on Port " + trapPort);
        this._values[5] = new JCheckBox("Show WorldWideName (WWN) Vendor");
        ((JCheckBox)this._values[5]).setActionCommand("WWN");
        ((JCheckBox)this._values[5]).addActionListener(this);
        this._values[6] = new FieldPanel((JComponent)new JLabel("       "), (JComponent)new RadioButtonPanel((Object[])new String[]{"replace", "prepend"}, 2), 25);
        this._values[7] = new JCheckBox("Show Timestamps as Date/Time");
        JButton browseTelnetPathBtn = new JButton("...");
        browseTelnetPathBtn.setMargin(DialogUtil.getInsets());
        browseTelnetPathBtn.addActionListener(this);
        browseTelnetPathBtn.setActionCommand("T");
        FieldPanel telnetFp = new FieldPanel((JComponent)new JLabel("Telnet Path: "), 25);
        telnetFp.add((Component)new Filler(FieldPanel._FillerSize));
        telnetFp.add((Component)browseTelnetPathBtn);
        this._values[8] = telnetFp;
        ((FieldPanel)this._values[8]).setText(ExternalTools._TelnetClient);
        this._values[9] = new JCheckBox("Use Secure Shell instead of Telnet");
        this._values[9].setVisible(false);
        this._values[10] = new FieldPanel((JComponent)new JLabel("SSH Path: "), 25);
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(new JLabel("CLI Session Timeout: "));
        this._cliTimeout = new JTextField(6);
        p.add(this._cliTimeout);
        p.add(new JLabel(" mins (0=disable)"));
        this._values[11] = p;
        this._values[12] = new JCheckBox("Show Tooltips in Physical View");
        this._values[13] = new FieldPanel((JComponent)new JLabel("Label Physical View Ports With:"), (JComponent)new RadioButtonPanel((Object[])new String[]{"FICON", "Interface"}, 2), 25);
        this._values[14] = new FieldPanel((JComponent)new JLabel("Export Table:"), (JComponent)new RadioButtonPanel((Object[])new String[]{"Tab-Delimited", "XML"}, 2), 25);
        this._values[15] = new FieldPanel((JComponent)new JLabel("Logout after idle (minutes): "), 10);
        if (!DM._IsWindows) {
            this._values[16] = new FieldPanel((JComponent)new JLabel("Browser: "), 25);
            ((FieldPanel)this._values[16]).setText(ExternalTools._UnixBrowser);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this._enablePoll.setSelected(PhysicalStatus._StatusPollTimerEnable);
            this._pollInterval.setText(Integer.toString(PhysicalStatus._StatusPollInterval));
            this._retryCount.setText(Integer.toString(Discover.getPeer().getRetries()));
            this._timeout.setText(Integer.toString(Discover.getPeer().getTimeout() / 1000));
            ((JCheckBox)this._values[3]).setSelected(SnmpSession.isTrace());
            ((JCheckBox)this._values[4]).setSelected(Discover._IsTrapRegisterNeeded);
            ((JCheckBox)this._values[5]).setSelected(WwnDictionary.isEnabled());
            ((RadioButtonPanel)((FieldPanel)this._values[6]).getComponent()).getButton(WwnDictionary.isPrepend() ? 1 : 0).setSelected(true);
            ((FieldPanel)this._values[6]).setEnabled(((JCheckBox)this._values[5]).isSelected());
            ((JCheckBox)this._values[7]).setSelected(SnmpTimeticks._ShowDateTime);
            ((FieldPanel)this._values[8]).setText(ExternalTools._TelnetClient);
            ((FieldPanel)this._values[10]).setText(ExternalTools._SSHPath);
            this._cliTimeout.setText(Integer.toString(Vsh.getTimeout()));
            ((JCheckBox)this._values[12]).setSelected(PhysicalView._EnableTooltips);
            this._values[13].setVisible(Discover.getSysVersionWithMinor().compareTo("1.3(4)") >= 0);
            ((RadioButtonPanel)((FieldPanel)this._values[13]).getComponent()).getButton(PhysicalView._LabelPort).setSelected(true);
            ((RadioButtonPanel)((FieldPanel)this._values[14]).getComponent()).getButton(KTable._ExportAsXML ? 1 : 0).setSelected(true);
            ((FieldPanel)this._values[15]).setText(String.valueOf(IdleTimeOut.getTimeOutInterval()));
            if (!DM._IsWindows) {
                ((FieldPanel)this._values[16]).setText(ExternalTools._UnixBrowser);
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char ch = e.getActionCommand().charAt(0);
        if (ch == 'W') {
            ((FieldPanel)this._values[6]).setEnabled(((JCheckBox)this._values[5]).isSelected());
            return;
        }
        if (ch == 'T') {
            String fName = Util.getFileName((JFrame)DeviceManager.getInstance(), (String)"Browse Telnet Client Path", (String)"", (int)0, null, (boolean)true);
            if (fName != null) {
                if (DM._IsWindows && fName.indexOf(" ") != -1) {
                    fName = "\"" + fName + "\"";
                }
                ((FieldPanel)this._values[8]).setText(fName);
            }
            return;
        }
        if (ch == 'E') {
            this._pollInterval.setEnabled(this._enablePoll.isSelected());
            return;
        }
        if (ch == 'H') {
            this.helpAction();
            return;
        }
        if (ch != 'C') {
            try {
                FieldPanel fp;
                boolean isPolling = this._enablePoll.isSelected();
                int interval = Integer.parseInt(this._pollInterval.getText());
                int retries = Integer.parseInt(this._retryCount.getText());
                int timeout = Integer.parseInt(this._timeout.getText());
                if (timeout < 3 || timeout > 30) {
                    this._timeout.grabFocus();
                    throw new NumberFormatException("Choose a value between 3 and 30 for timeout");
                }
                if (retries < 0 || retries > 5) {
                    this._retryCount.grabFocus();
                    throw new NumberFormatException("Choose a value between 0 and 5 for retries");
                }
                if (interval <= timeout) {
                    this._pollInterval.grabFocus();
                    throw new NumberFormatException("Poll interval must be greater than timeout");
                }
                int vshTimeout = Integer.parseInt(this._cliTimeout.getText());
                if (vshTimeout < 0 || vshTimeout > 525600) {
                    throw new NumberFormatException("CLI session timeout range is 0-525600");
                }
                Discover.getPeer().setTimeout(timeout * 1000);
                Discover.getPeer().setRetries(retries);
                SnmpSession.setTrace((boolean)((JCheckBox)this._values[3]).isSelected());
                Discover._IsTrapRegisterNeeded = ((JCheckBox)this._values[4]).isSelected();
                if (isPolling && interval != PhysicalStatus._StatusPollInterval) {
                    PhysicalStatus._StatusPollInterval = interval;
                    PhysicalStatus.getInstance().resetStatusTimerInterval();
                }
                PhysicalStatus._StatusPollTimerEnable = isPolling;
                PhysicalStatus.getInstance().setStatusTimer(PhysicalStatus._StatusPollTimerEnable);
                WwnDictionary.setEnabled((boolean)((JCheckBox)this._values[5]).isSelected());
                WwnDictionary.setPrepend((((RadioButtonPanel)((FieldPanel)this._values[6]).getComponent()).getSelected() == 1 ? 1 : 0) != 0);
                SnmpTimeticks._ShowDateTime = ((JCheckBox)this._values[7]).isSelected();
                ExternalTools._TelnetClient = ((FieldPanel)this._values[8]).getText();
                ExternalTools._SSHPath = ((FieldPanel)this._values[10]).getText();
                Vsh.setTimeout((int)vshTimeout);
                PhysicalView._EnableTooltips = ((JCheckBox)this._values[12]).isSelected();
                int physicalViewPort = ((RadioButtonPanel)((FieldPanel)this._values[13]).getComponent()).getSelected();
                if (physicalViewPort != PhysicalView._LabelPort) {
                    PhysicalView._LabelPort = physicalViewPort;
                    if (PhysicalView._LabelPort == 1) {
                        DmSystem.showPortLabelsAsIf(null, (SnmpPeer)Discover.getPeer());
                    } else {
                        DmSystem.showPortLabelsAsFICON(null, (SnmpPeer)Discover.getPeer());
                    }
                }
                KTable._ExportAsXML = ((RadioButtonPanel)((FieldPanel)this._values[14]).getComponent()).getSelected() == 1;
                IdleTimeOut.setTimeOutInterval((int)((FieldPanel)this._values[15]).getInt());
                try {
                    Discover._ProxyAddr = OpenDialog.getProxyAddress(true, Discover._ProxyAddrString);
                }
                catch (Exception ex) {
                    Discover._ProxyAddr = null;
                    Discover._UseProxy = false;
                    System.out.println("PrefDialogEM Discover._UseProxy=" + Discover._UseProxy);
                }
                if (!DM._IsWindows && (fp = (FieldPanel)this._values[16]).getText() != null && fp.getText().length() > 0) {
                    ExternalTools._UnixBrowser = fp.getText();
                }
            }
            catch (NumberFormatException ex) {
                Util.errorMessage((Component)this, (String)ex.getMessage());
                return;
            }
        }
        if (ch != 'A') {
            this.setVisible(false);
        }
    }

    protected static void load() throws IOException {
        SwitchVersion dmVersion;
        String NMSVersion = "6.3(2)";
        if (NMSVersion.equals("") || NMSVersion.startsWith("sj")) {
            NMSVersion = "2.1(1)";
        }
        if (!(dmVersion = new SwitchVersion(NMSVersion)).lessThan(new SwitchVersion("2.0(0)"))) {
            DmPreferences.load();
            return;
        }
        try (DataInputStream is = new DataInputStream(new FileInputStream(FILENAME));){
            int version = is.readInt();
            boolean isPolling = is.readBoolean();
            int interval = is.readInt();
            if (isPolling && interval != PhysicalStatus._StatusPollInterval) {
                PhysicalStatus._StatusPollInterval = interval;
            }
            PhysicalStatus._StatusPollTimerEnable = isPolling;
            SnmpPeer._Retries = (short)is.readInt();
            SnmpPeer._Timeout = is.readInt();
            Discover._IsTrapRegisterNeeded = is.readBoolean();
            is.readBoolean();
            WwnDictionary.setEnabled((boolean)is.readBoolean());
            WwnDictionary.setPrepend((boolean)is.readBoolean());
            SnmpTimeticks._ShowDateTime = is.readBoolean();
            ExternalTools._UseSSH = is.readBoolean();
            ExternalTools._SSHPath = is.readUTF();
            PhysicalView._EnableTooltips = is.readBoolean();
            KTable._ExportAsXML = is.readBoolean();
            if (version == 9 || version == 8) {
                Vsh.setTimeout((int)is.readInt());
            }
            if (version == 9) {
                PhysicalView._LabelPort = is.readInt();
            }
        }
    }

    protected static void save() throws IOException {
        SwitchVersion dmVersion;
        String NMSVersion = "6.3(2)";
        if (NMSVersion.equals("") || NMSVersion.startsWith("sj")) {
            NMSVersion = "2.1(1)";
        }
        if (!(dmVersion = new SwitchVersion(NMSVersion)).lessThan(new SwitchVersion("2.0(0)"))) {
            DmPreferences.save();
            return;
        }
        try (DataOutputStream os = new DataOutputStream(new FileOutputStream(FILENAME));){
            os.writeInt(9);
            os.writeBoolean(PhysicalStatus._StatusPollTimerEnable);
            os.writeInt(PhysicalStatus._StatusPollInterval);
            os.writeInt(Discover.getPeer().getRetries());
            os.writeInt(Discover.getPeer().getTimeout());
            os.writeBoolean(Discover._IsTrapRegisterNeeded);
            os.writeBoolean(true);
            os.writeBoolean(WwnDictionary.isEnabled());
            os.writeBoolean(WwnDictionary.isPrepend());
            os.writeBoolean(SnmpTimeticks._ShowDateTime);
            os.writeBoolean(ExternalTools._UseSSH);
            os.writeUTF(ExternalTools._SSHPath);
            os.writeBoolean(PhysicalView._EnableTooltips);
            os.writeBoolean(KTable._ExportAsXML);
            os.writeInt(Vsh.getTimeout());
            os.writeInt(PhysicalView._LabelPort);
            os.close();
        }
    }

    protected void helpAction() {
        try {
            DeviceManager._Instance.helpDialog(this._help);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

