/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import javax.swing.JFrame;

public final class WriteCmtVerify {
    static WriteCmtVerify _Instance;

    private WriteCmtVerify() {
    }

    public static WriteCmtVerify getInstance() {
        if (_Instance == null) {
            _Instance = new WriteCmtVerify();
        }
        return _Instance;
    }

    public void asyncVerification(SnmpPeer peer, JFrame parent) throws SnmpException {
        new WriteCommunityCheck().check(peer, parent);
    }

    final class WriteCommunityCheck
    implements SnmpCallbackIf {
        SnmpPeer _peer;
        JFrame _parent;
        boolean _fetchState;

        WriteCommunityCheck() {
        }

        void check(SnmpPeer peer, JFrame parent) throws SnmpException {
            this._peer = peer;
            this._parent = parent;
            this.fetchSysName();
        }

        void fetchSysName() throws SnmpException {
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
            pdu.setRetries(0);
            pdu.addNull(new SnmpOID(MibNode.get((String)"sysName").getOid(), new int[]{0}));
            this._fetchState = true;
            this._peer.send(pdu, (SnmpCallbackIf)this);
        }

        public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
            if (timedOut || pdu.getError() != 0) {
                DefaultLogger._DefLogger.debug((Object)"Invalid write community; leave blank if unknown.");
                ((DeviceManager)this._parent).setStatus("Invalid write community; leave blank if unknown.");
                return;
            }
            try {
                if (this._fetchState) {
                    if (pdu.getVar(0).getType() == 5) {
                        DefaultLogger._DefLogger.debug((Object)"Invalid write community; leave blank if unknown.");
                        ((DeviceManager)this._parent).setStatus("Invalid write community; leave blank if unknown.");
                        return;
                    }
                    SnmpVar sysName = pdu.getVar(0);
                    SnmpPDU setPdu = new SnmpPDU(-93, new VarBindList(1));
                    setPdu.setRetries(0);
                    setPdu.setTimeout(3000);
                    setPdu.setIgnoreSetCount(true);
                    setPdu.addVar(new SnmpOID(MibNode.get((String)"sysName").getOid(), new int[]{0}), sysName);
                    this._fetchState = false;
                    this._peer.send(setPdu, (SnmpCallbackIf)this);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

