/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.bars;

import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.swing.bars.IlvAbstractConfiguration;
import ilog.views.appframe.swing.bars.IlvDockedComponentConfiguration;
import ilog.views.appframe.swing.bars.IlvDockedConfiguration;
import ilog.views.appframe.swing.bars.IlvSeparatorConfiguration;
import ilog.views.appframe.swing.bars.InsertionPoint;
import ilog.views.appframe.util.logging.IlvLog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;

public class IlvMultiRowPanelConfiguration {
    private int a;
    private Dimension b;
    private ArrayList c;
    private ArrayList d;
    private transient int e;
    private boolean f;
    private Dimension g;
    private boolean h;
    private static final Dimension i = new Dimension(15, 15);
    static final String j = "separator";
    private static final String k = "position";
    private static final String l = "row";

    public IlvMultiRowPanelConfiguration(int n2) {
        this.a = n2;
    }

    public IlvMultiRowPanelConfiguration(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration) {
        this.a = ilvMultiRowPanelConfiguration.a;
        if (ilvMultiRowPanelConfiguration.c == null) {
            this.c = null;
            this.d = null;
        } else {
            this.c = new ArrayList(ilvMultiRowPanelConfiguration.c);
            if (ilvMultiRowPanelConfiguration.d == null) {
                this.d = null;
            } else {
                this.d = new ArrayList(ilvMultiRowPanelConfiguration.d.size());
                for (int i2 = 0; i2 < ilvMultiRowPanelConfiguration.d.size(); ++i2) {
                    Row row = ilvMultiRowPanelConfiguration.b(i2);
                    this.d.add(new Row(row, this));
                }
            }
        }
        this.b = ilvMultiRowPanelConfiguration.b == null ? null : new Dimension(ilvMultiRowPanelConfiguration.b);
    }

    public IlvMultiRowPanelConfiguration(IlvSettingsElement ilvSettingsElement) {
        this.readSettings(ilvSettingsElement);
    }

    public final int getConfigurationCount() {
        return this.c == null ? 0 : this.c.size();
    }

    public final IlvDockedConfiguration getConfiguration(int n2) {
        return (IlvDockedConfiguration)this.c.get(n2);
    }

    public final IlvDockedComponentConfiguration getConfiguration(String string) {
        if (this.c == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            IlvDockedConfiguration ilvDockedConfiguration = (IlvDockedConfiguration)this.c.get(i2);
            if (ilvDockedConfiguration.isSeparator() || !ilvDockedConfiguration.getName().equals(string)) continue;
            return (IlvDockedComponentConfiguration)ilvDockedConfiguration;
        }
        return null;
    }

    public boolean containsConfiguration(String string) {
        return this.getConfiguration(string) != null;
    }

    public void removeConfiguration(IlvDockedConfiguration ilvDockedConfiguration) {
        Row row = this.b(ilvDockedConfiguration.getRow());
        if (row.removeConfiguration(ilvDockedConfiguration)) {
            this.c.remove(ilvDockedConfiguration);
            this.invalidate();
        }
    }

    public void setConfigurationVisible(IlvDockedConfiguration ilvDockedConfiguration, boolean bl) {
        if (ilvDockedConfiguration.isVisible() != bl) {
            ilvDockedConfiguration.setVisible(bl);
            this.invalidate();
        }
    }

    public void resizeConfiguration(IlvDockedConfiguration ilvDockedConfiguration, Dimension dimension) {
        if (!ilvDockedConfiguration.sameSize(dimension)) {
            ilvDockedConfiguration.setSize(dimension);
            this.invalidate();
        }
    }

    public int getOrientation() {
        return this.a;
    }

    public boolean isHorizontal() {
        return this.a == 1 || this.a == 3;
    }

    public boolean isValid() {
        return this.h;
    }

    public void invalidate() {
        this.setValid(false);
    }

    public void setValid(boolean bl) {
        this.h = bl;
    }

    public IlvDockedComponentConfiguration addConfiguration(String string, IlvDockedComponentConfiguration ilvDockedComponentConfiguration) {
        if (ilvDockedComponentConfiguration == null) {
            ilvDockedComponentConfiguration = new IlvDockedComponentConfiguration(string, null);
        } else {
            ilvDockedComponentConfiguration.setRow(this.d == null ? 0 : this.d.size());
        }
        ilvDockedComponentConfiguration.setVisible(true);
        if (this.c == null) {
            this.c = new ArrayList();
        }
        this.c.add(ilvDockedComponentConfiguration);
        Row row = new Row();
        row.addConfiguration(ilvDockedComponentConfiguration);
        if (this.d == null) {
            this.d = new ArrayList();
        }
        this.d.add(row);
        this.invalidate();
        return ilvDockedComponentConfiguration;
    }

    public void readSettings(IlvSettingsElement ilvSettingsElement) {
        this.a = IlvMultiRowPanelConfiguration.a(ilvSettingsElement.getString("orientation", "top"));
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettingsElement.getChildren(k);
        if (ilvSettingsElementArray == null || ilvSettingsElementArray.length == 0) {
            this.a(ilvSettingsElement);
            this.invalidate();
            return;
        }
        this.c = new ArrayList(ilvSettingsElementArray.length);
        this.d = new ArrayList();
        for (int i2 = 0; i2 < ilvSettingsElementArray.length; ++i2) {
            IlvDockedComponentConfiguration ilvDockedComponentConfiguration = new IlvDockedComponentConfiguration(ilvSettingsElementArray[i2]);
            this.c.add(ilvDockedComponentConfiguration);
            int n2 = ilvDockedComponentConfiguration.getRow();
            if (n2 == -1) {
                n2 = this.d.size();
                ilvDockedComponentConfiguration.setRow(n2);
            }
            if (n2 >= this.d.size()) {
                for (int i3 = this.d.size(); i3 <= n2; ++i3) {
                    this.d.add(new Row());
                }
            }
            Row row = this.b(n2);
            row.addConfiguration(ilvDockedComponentConfiguration);
        }
        this.invalidate();
    }

    private void a(IlvSettingsElement ilvSettingsElement) {
        this.f = true;
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettingsElement.getChildren(l);
        if (ilvSettingsElementArray == null || ilvSettingsElementArray.length == 0) {
            this.c = new ArrayList();
            this.d = new ArrayList();
            return;
        }
        this.c = new ArrayList();
        this.d = new ArrayList(ilvSettingsElementArray.length);
        for (int i2 = 0; i2 < ilvSettingsElementArray.length; ++i2) {
            IlvSettingsElement[] ilvSettingsElementArray2 = ilvSettingsElementArray[i2].getChildren();
            if (ilvSettingsElementArray2 == null || ilvSettingsElementArray2.length == 0) {
                this.d.add(new Row());
                continue;
            }
            Row row = new Row(ilvSettingsElementArray2.length);
            for (int i3 = 0; i3 < ilvSettingsElementArray2.length; ++i3) {
                IlvDockedConfiguration ilvDockedConfiguration = null;
                ilvDockedConfiguration = ilvSettingsElementArray2[i3].getType().equals(j) ? new IlvSeparatorConfiguration(ilvSettingsElementArray2[i3]) : new IlvDockedComponentConfiguration(ilvSettingsElementArray2[i3]);
                this.c.add(ilvDockedConfiguration);
                row.addConfiguration(ilvDockedConfiguration);
                ilvDockedConfiguration.setRow(i2);
            }
            this.d.add(row);
        }
    }

    public void writeSettings(IlvSettingsElement ilvSettingsElement) {
        IlvSettings ilvSettings = ilvSettingsElement.getSettings();
        ilvSettingsElement.setString("orientation", IlvMultiRowPanelConfiguration.a(this.a));
        ilvSettingsElement.removeAll(null);
        int n2 = this.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Row row = this.b(i2);
            IlvSettingsElement ilvSettingsElement2 = ilvSettings.createSettingsElement(l);
            for (int i3 = 0; i3 < row.size(); ++i3) {
                IlvDockedConfiguration ilvDockedConfiguration = row.getConfiguration(i3);
                IlvSettingsElement ilvSettingsElement3 = ilvSettings.createSettingsElement(ilvDockedConfiguration.isSeparator() ? j : k);
                ilvDockedConfiguration.writeSettings(ilvSettingsElement3);
                ilvSettingsElement2.add(ilvSettingsElement3);
            }
            ilvSettingsElement.add(ilvSettingsElement2);
        }
    }

    static String a(int n2) {
        switch (n2) {
            case 2: {
                return "left";
            }
            case 4: {
                return "right";
            }
            case 3: {
                return "bottom";
            }
            case 1: {
                return "top";
            }
        }
        return "top";
    }

    static int a(String string) {
        if (string.equals("top")) {
            return 1;
        }
        if (string.equals("left")) {
            return 2;
        }
        if (string.equals("right")) {
            return 4;
        }
        if (string.equals("bottom")) {
            return 3;
        }
        IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, "Unknown orientation " + string + ". Should use 'left', 'top', 'right' or 'bottom' values");
        return 1;
    }

    boolean a() {
        return this.e != 0;
    }

    void b() {
        ++this.e;
    }

    void c() {
        --this.e;
    }

    public Dimension getSize() {
        return this.b;
    }

    public void setSize(Dimension dimension) {
        this.b = dimension == null ? null : new Dimension(dimension);
    }

    public Dimension getComponentInterspaces() {
        return this.g;
    }

    public int getComponentInterspace() {
        return this.g == null ? 0 : (this.isHorizontal() ? this.g.width : this.g.height);
    }

    public void setComponentInterspaces(Dimension dimension) {
        if (dimension == null) {
            if (this.g == null) {
                return;
            }
            if (this.g.width == 0 && this.g.height == 0) {
                return;
            }
            this.g = new Dimension(0, 0);
            this.invalidate();
            return;
        }
        if (this.g != null && dimension.equals(this.g)) {
            return;
        }
        this.g = new Dimension(dimension);
        this.invalidate();
    }

    public int getRowCount() {
        return this.d == null ? 0 : this.d.size();
    }

    public Collection getConfigurations(int n2) {
        if (this.d == null || this.d.size() <= n2) {
            return null;
        }
        return this.b(n2).getConfigurations();
    }

    private final Row b(int n2) {
        if (this.d == null || n2 < 0 || n2 >= this.d.size()) {
            throw new IllegalArgumentException("Try to access to a row in a multi row panel with a bad index:" + n2);
        }
        return (Row)this.d.get(n2);
    }

    private Row c(int n2) {
        Row row = null;
        if (this.d == null || this.d.size() == 0) {
            if (n2 != 0 && n2 != -1) {
                throw new IllegalArgumentException("Bad insertion index for a new row in a multi row panel configuration:" + n2);
            }
            if (this.d == null) {
                this.d = new ArrayList();
            }
            row = new Row();
            this.d.add(row);
        } else {
            if (n2 == -1) {
                n2 = this.d.size();
            }
            if (n2 < 0 || n2 > this.d.size()) {
                throw new IllegalArgumentException("Bad insertion index for a new row in a multi row panel configuration:" + n2);
            }
            row = new Row();
            this.d.add(n2, row);
        }
        for (int i2 = n2 + 1; i2 < this.d.size(); ++i2) {
            Row row2 = this.b(i2);
            for (int i3 = 0; i3 < row2.size(); ++i3) {
                IlvDockedConfiguration ilvDockedConfiguration = row2.getConfiguration(i3);
                ilvDockedConfiguration.setRow(i2);
            }
        }
        return row;
    }

    public void setRowBounds(int n2, Rectangle rectangle) {
        this.b(n2).setBounds(rectangle);
    }

    public Rectangle getRowBounds(int n2) {
        return this.b(n2).getBounds();
    }

    InsertionPoint a(Point point, Dimension dimension) {
        int n2;
        int n3;
        Rectangle rectangle = new Rectangle(0, 0, this.b.width, this.b.height);
        boolean bl = this.isHorizontal();
        int n4 = 0;
        if (bl) {
            if (point.y < rectangle.y) {
                if (point.y < rectangle.y - IlvMultiRowPanelConfiguration.i.height) {
                    return null;
                }
                return new NewRowInsertPoint(this.a(rectangle, point.x, dimension), 0);
            }
            if (point.y > rectangle.y + rectangle.height) {
                if (point.y > rectangle.y + rectangle.height + IlvMultiRowPanelConfiguration.i.height) {
                    return null;
                }
                return new NewRowInsertPoint(this.a(rectangle, point.x, dimension), this.getRowCount());
            }
            if (point.x < rectangle.x - IlvMultiRowPanelConfiguration.i.width) {
                return null;
            }
            if (point.x >= rectangle.x + rectangle.width + IlvMultiRowPanelConfiguration.i.width) {
                return null;
            }
            n4 = this.a(rectangle, point.x, dimension);
        } else {
            if (point.x < rectangle.x) {
                if (point.x < rectangle.x - IlvMultiRowPanelConfiguration.i.width) {
                    return null;
                }
                return new NewRowInsertPoint(this.b(rectangle, point.y, dimension), 0);
            }
            if (point.x > rectangle.x + rectangle.width) {
                if (point.x > rectangle.x + rectangle.width + IlvMultiRowPanelConfiguration.i.width) {
                    return null;
                }
                return new NewRowInsertPoint(this.b(rectangle, point.y, dimension), this.getRowCount());
            }
            if (point.y < rectangle.y - IlvMultiRowPanelConfiguration.i.height) {
                return null;
            }
            if (point.y >= rectangle.y + rectangle.height + IlvMultiRowPanelConfiguration.i.height) {
                return null;
            }
            n4 = this.b(rectangle, point.y, dimension);
        }
        Row row = null;
        for (n3 = 0; n3 < this.d.size(); ++n3) {
            row = this.b(n3);
            Rectangle rectangle2 = row.getBounds();
            if (!bl && point.x >= rectangle2.x && point.x < rectangle2.x + rectangle2.width || bl && point.y >= rectangle2.y && point.y < rectangle2.y + rectangle2.height) break;
        }
        if (n3 == this.d.size()) {
            return null;
        }
        for (n2 = 0; n2 < row.size(); ++n2) {
            IlvDockedConfiguration ilvDockedConfiguration = row.getConfiguration(n2);
            Rectangle rectangle3 = ilvDockedConfiguration.getBounds();
            int n5 = bl ? rectangle3.x : rectangle3.y;
            if (n4 >= n5 + (bl ? rectangle3.width : rectangle3.height)) continue;
            return new InsertInRow(n3, n2, n4 - n5, dimension);
        }
        n2 = row.getConfiguration(row.size() - 1).getRight();
        return new AppendInRow(n3, n4 - n2);
    }

    private int a(Rectangle rectangle, int n2, Dimension dimension) {
        if (n2 < rectangle.x) {
            return 0;
        }
        int n3 = rectangle.x + rectangle.width - dimension.width;
        if (n2 > n3) {
            return n3;
        }
        return n2;
    }

    private int b(Rectangle rectangle, int n2, Dimension dimension) {
        if (n2 < rectangle.y) {
            return 0;
        }
        int n3 = rectangle.y + rectangle.height - dimension.height;
        if (n2 > n3) {
            return n3;
        }
        return n2;
    }

    private static class AppendInRow
    extends InsertionPoint {
        private int a;
        private int b;

        public AppendInRow(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }

        public IlvDockedComponentConfiguration insert(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration, String string) {
            Row row = ilvMultiRowPanelConfiguration.b(this.a);
            ilvMultiRowPanelConfiguration.invalidate();
            if (this.b > ilvMultiRowPanelConfiguration.getComponentInterspace()) {
                row.add(new IlvSeparatorConfiguration(this.b, ilvMultiRowPanelConfiguration.isHorizontal()));
            }
            IlvDockedComponentConfiguration ilvDockedComponentConfiguration = new IlvDockedComponentConfiguration(string, null);
            row.add(ilvDockedComponentConfiguration);
            return ilvDockedComponentConfiguration;
        }

        public String toString() {
            return "Append component in the row [" + this.a + "] after a new separator [" + this.b + "]";
        }
    }

    private static class InsertInRow
    extends InsertionPoint {
        private int a;
        private int b;
        private int c;
        private Dimension d;

        public InsertInRow(int n2, int n3, int n4, Dimension dimension) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
            this.d = dimension;
        }

        /*
         * Enabled aggressive block sorting
         */
        public IlvDockedComponentConfiguration insert(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration, String string) {
            Row row = ilvMultiRowPanelConfiguration.b(this.a);
            ilvMultiRowPanelConfiguration.invalidate();
            int n2 = ilvMultiRowPanelConfiguration.getComponentInterspace();
            IlvDockedComponentConfiguration ilvDockedComponentConfiguration = new IlvDockedComponentConfiguration(string, null);
            int n3 = 0;
            int n4 = 0;
            int n5 = this.b - 1;
            int n6 = this.b + 1;
            boolean bl = ilvMultiRowPanelConfiguration.isHorizontal();
            int n7 = bl ? this.d.width : this.d.height;
            IlvDockedConfiguration ilvDockedConfiguration = row.getConfiguration(this.b);
            if (this.c < 0) {
                if (this.b == 0) {
                    row.addConfiguration(ilvDockedComponentConfiguration, 0);
                    return ilvDockedComponentConfiguration;
                }
                n3 = -this.c;
                n4 = n7 + n2;
                row.addConfiguration(ilvDockedComponentConfiguration, this.b);
            } else if (ilvDockedConfiguration.isSeparator()) {
                IlvSeparatorConfiguration ilvSeparatorConfiguration = (IlvSeparatorConfiguration)ilvDockedConfiguration;
                if (this.c <= n2) {
                    n3 = n2 - this.c;
                    n4 = n7;
                    row.addConfiguration(ilvDockedComponentConfiguration, this.b);
                } else {
                    n3 = 0;
                    n4 = n7 + this.c + n2 - ilvSeparatorConfiguration.getLength(bl);
                    ilvSeparatorConfiguration.setLength(bl, this.c);
                    row.addConfiguration(ilvDockedComponentConfiguration, this.b + 1);
                    if (n4 == 0) {
                        return ilvDockedComponentConfiguration;
                    }
                    if (n4 < 0) {
                        row.addConfiguration(new IlvSeparatorConfiguration(-n4 + n2, bl), this.b + 2);
                        return ilvDockedComponentConfiguration;
                    }
                    n5 = this.b;
                    n6 = this.b + 2;
                }
            } else {
                row.addConfiguration(ilvDockedComponentConfiguration, this.b + 1);
                n5 = this.b;
                n6 = this.b + 2;
                n3 = ilvDockedConfiguration.getLength(bl) - this.c + n2;
                n4 = n7 - ilvDockedConfiguration.getLength(bl) + this.c;
            }
            if (n3 > 0) {
                n3 = row.shrinkSeparators(ilvMultiRowPanelConfiguration, n3, n5, -1);
                n4 += n3;
            }
            if (n4 > 0 && (n4 = row.shrinkSeparators(ilvMultiRowPanelConfiguration, n4, n6, 1)) > 0 && n3 != 0) {
                n4 = row.shrinkSeparators(ilvMultiRowPanelConfiguration, n4, n5, -1);
            }
            return ilvDockedComponentConfiguration;
        }

        public String toString() {
            return "Insert component in the row [" + this.a + "] in the component [" + this.b + "] at the offset [" + this.c + "]";
        }
    }

    private static class NewRowInsertPoint
    extends InsertionPoint {
        private int a;
        private int b;

        public NewRowInsertPoint(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }

        public IlvDockedComponentConfiguration insert(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration, String string) {
            ilvMultiRowPanelConfiguration.c(this.b);
            Row row = ilvMultiRowPanelConfiguration.b(0);
            if (this.a != 0) {
                row.addConfiguration(new IlvSeparatorConfiguration(this.a, ilvMultiRowPanelConfiguration.isHorizontal()));
            }
            IlvDockedComponentConfiguration ilvDockedComponentConfiguration = new IlvDockedComponentConfiguration(string, null);
            row.add(ilvDockedComponentConfiguration);
            ilvMultiRowPanelConfiguration.invalidate();
            return ilvDockedComponentConfiguration;
        }

        public String toString() {
            return "Insert component in a new row at the index " + this.b + " and at the offset " + this.a;
        }
    }

    private static class Row
    extends ArrayList {
        private Rectangle a;

        public Row(int n2) {
            super(n2);
        }

        public Row() {
            super(3);
        }

        public Row(Row row, IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration) {
            super(row.size());
            this.a = row.a == null ? null : new Rectangle(row.a);
            for (int i2 = 0; i2 < row.size(); ++i2) {
                IlvAbstractConfiguration ilvAbstractConfiguration = row.getConfiguration(i2);
                ilvAbstractConfiguration = ilvAbstractConfiguration.cloneConfiguration();
                ilvMultiRowPanelConfiguration.c.add(ilvAbstractConfiguration);
                this.add(ilvAbstractConfiguration);
            }
        }

        public Rectangle getBounds() {
            return this.a;
        }

        public void setBounds(Rectangle rectangle) {
            this.a = new Rectangle(rectangle);
        }

        public final IlvDockedConfiguration getConfiguration(int n2) {
            return (IlvDockedConfiguration)this.get(n2);
        }

        public boolean removeConfiguration(IlvAbstractConfiguration ilvAbstractConfiguration) {
            return this.remove(ilvAbstractConfiguration);
        }

        public void addConfiguration(IlvAbstractConfiguration ilvAbstractConfiguration, int n2) {
            if (n2 == -1) {
                this.add(ilvAbstractConfiguration);
            } else {
                this.add(n2, ilvAbstractConfiguration);
            }
        }

        public void addConfiguration(IlvAbstractConfiguration ilvAbstractConfiguration) {
            this.add(ilvAbstractConfiguration);
        }

        public Collection getConfigurations() {
            return this;
        }

        public int shrinkSeparators(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration, int n2, int n3, int n4) {
            int n5 = ilvMultiRowPanelConfiguration.getComponentInterspace();
            boolean bl = ilvMultiRowPanelConfiguration.isHorizontal();
            int n6 = n3;
            while (n6 >= 0 && n6 < this.size()) {
                int n7;
                IlvDockedConfiguration ilvDockedConfiguration = this.getConfiguration(n6);
                if (!ilvDockedConfiguration.isSeparator()) {
                    n6 += n4;
                    continue;
                }
                if (n6 == 0) {
                    n5 = 0;
                }
                if ((n7 = ilvDockedConfiguration.getLength(bl)) - n5 <= n2) {
                    this.a(ilvMultiRowPanelConfiguration, n7 - n5);
                    this.remove(n6);
                    if ((n2 -= n7 - n5) == 0) {
                        return 0;
                    }
                    if (n4 != -1) continue;
                    --n6;
                    continue;
                }
                this.a(ilvMultiRowPanelConfiguration, n2);
                ilvDockedConfiguration.setLength(bl, n7 - n2);
                return 0;
            }
            return n2;
        }

        private final void a(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration, int n2) {
            if (this.a != null) {
                if (ilvMultiRowPanelConfiguration.isHorizontal()) {
                    this.a.width -= n2;
                } else {
                    this.a.height -= n2;
                }
            }
        }
    }
}

