/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.editor;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.swing.util.IlvButton;
import ilog.views.applications.util.wizard.IlvMessagesSupport;
import ilog.views.builder.docview.IlvBuilderDocument;
import ilog.views.builder.editor.IlvCSSCustomizer;
import ilog.views.builder.editor.IlvCSSMicroCustomizer;
import ilog.views.builder.event.IlvStyleChangeSupport;
import ilog.views.builder.event.StyleChangeListener;
import ilog.views.css.model.IlvRule;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public final class IlvRuleDeclarationEditorSupport {
    private IlvStyleChangeSupport a;
    protected static IlvMessagesSupport MSG_SUPPORT = new IlvMessagesSupport("ilog.views.builder.gui.editors");
    protected HashMap labels = new HashMap();
    protected Map labelButtons = new HashMap();
    protected Map buttons = new HashMap();
    private IlvBuilderDocument b;
    private boolean c = true;
    private IlvRule d;
    public static final String ICON_KEY = "icon";
    public static final String INHERITABLE_PROPERTY = "inheritable";
    private static String e;
    private static String f;
    public static String INHERITED_ICON_TOOLTIPTEXT;

    public IlvRuleDeclarationEditorSupport(Object object) {
        this.a = new IlvStyleChangeSupport(object);
    }

    public static void initToolTipTexts(IlvApplication ilvApplication) {
        INHERITED_ICON_TOOLTIPTEXT = ilvApplication.getString("Builder.PropertySheetView.InheritedToolTip");
        f = ilvApplication.getString("Builder.PropertySheetView.DefaultToolTip");
        e = ilvApplication.getString("Builder.PropertySheetView.LocalToolTip");
    }

    public void clean() {
        this.labels.clear();
        this.labelButtons.clear();
        this.buttons.clear();
    }

    public IlvStyleChangeSupport getStyleChangeSupport() {
        return this.a;
    }

    public void setFiringEvents(boolean bl) {
        this.c = bl;
    }

    public boolean isFiringEvents() {
        return this.c;
    }

    public IlvRule getEventTarget() {
        return this.d;
    }

    public void setEventTarget(IlvRule ilvRule) {
        this.d = ilvRule;
    }

    public IlvBuilderDocument getDocument() {
        return this.b;
    }

    public void setDocument(IlvBuilderDocument ilvBuilderDocument) {
        this.b = ilvBuilderDocument;
    }

    public void addStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.a.addStyleChangeListener(styleChangeListener);
    }

    public void removeStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.a.removeStyleChangeListener(styleChangeListener);
    }

    public void addLabel(String string, JLabel jLabel) {
        Object v2 = this.labels.get(string);
        if (v2 instanceof Collection) {
            ((Collection)v2).add(jLabel);
        } else if (v2 instanceof JLabel) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(v2);
            arrayList.add(jLabel);
            this.labels.put(string, arrayList);
        } else {
            if (v2 != null) {
                throw new RuntimeException("Unexpected value type: " + v2.getClass().getName());
            }
            this.labels.put(string, jLabel);
        }
    }

    public Collection getLabels(String string) {
        Object v2 = this.labels.get(string);
        if (v2 == null) {
            return null;
        }
        if (v2 instanceof Collection) {
            return (Collection)v2;
        }
        if (v2 instanceof JLabel) {
            SingleElementImmutableCollection singleElementImmutableCollection = new SingleElementImmutableCollection(v2);
            return singleElementImmutableCollection;
        }
        throw new RuntimeException("Unexpected value type: " + v2.getClass().getName());
    }

    public void removeLabelsAndInheritanceButtons(String string) {
        Collection collection = this.getLabels(string);
        this.labels.remove(string);
        this.buttons.remove(string);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                this.labelButtons.remove(e2);
            }
        }
    }

    public void updateDeclarationIcons(IlvCSSCustomizer ilvCSSCustomizer, IlvBuilderDocument ilvBuilderDocument) {
        Object object;
        Object object2;
        if (ilvBuilderDocument == null) {
            return;
        }
        this.setDocument(ilvBuilderDocument);
        Iterator<Object> iterator = this.labels.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = ilvCSSCustomizer.getRuleForProperty((String)object2);
            this.a((IlvRule)object, (String)object2);
        }
        iterator = this.buttons.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            object = (String)object2.getKey();
            IlvRule ilvRule = ilvCSSCustomizer.getRuleForProperty((String)object);
            int n2 = ilvBuilderDocument.getDeclarationStatus(ilvRule, (String)object);
            ImageIcon imageIcon = IlvCSSCustomizer.INHERITANCE_ICONS[n2];
            ((JButton)object2.getValue()).setIcon(imageIcon);
        }
    }

    private void a(IlvRule ilvRule, String string) {
        int n2 = this.b.getDeclarationStatus(ilvRule, string);
        this.updateDeclarationLabelIcon(string, n2);
    }

    public void updateDeclarationLabelIcon(String string, int n2) {
        ImageIcon imageIcon = IlvCSSCustomizer.INHERITANCE_ICONS[n2];
        Collection collection = this.getLabels(string);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JLabel jLabel = (JLabel)iterator.next();
                if (jLabel == null) continue;
                String string2 = jLabel.getToolTipText();
                string2 = this.a(string2, n2);
                JButton jButton = (JButton)this.labelButtons.get(jLabel);
                if (jButton != null) {
                    jButton.setIcon(imageIcon);
                } else {
                    Boolean bl = (Boolean)jLabel.getClientProperty(INHERITABLE_PROPERTY);
                    if (bl == null || Boolean.TRUE.equals(bl)) {
                        jLabel.setIcon(imageIcon);
                    }
                }
                jLabel.setToolTipText(string2);
            }
        }
    }

    public JButton createInheritanceButton(String string, final IlvCSSMicroCustomizer ilvCSSMicroCustomizer, JLabel jLabel) {
        final IlvButton ilvButton = new IlvButton();
        ilvButton.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(IlvRuleDeclarationEditorSupport.ICON_KEY)) {
                    Object object = propertyChangeEvent.getNewValue();
                    String string = e;
                    if (object == IlvCSSCustomizer.INHERITANCE_ICONS[3]) {
                        string = f;
                    } else if (object == IlvCSSCustomizer.INHERITANCE_ICONS[2]) {
                        string = INHERITED_ICON_TOOLTIPTEXT;
                    }
                    ((JButton)propertyChangeEvent.getSource()).setToolTipText(string);
                }
            }
        });
        ilvButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IlvRuleDeclarationEditorSupport.this.a(ilvButton, ilvCSSMicroCustomizer);
            }
        });
        ImageIcon imageIcon = null;
        if (this.b != null) {
            int n2 = this.b.getDeclarationStatus(this.getEventTarget(), string);
            imageIcon = IlvCSSCustomizer.INHERITANCE_ICONS[n2];
        } else {
            imageIcon = IlvCSSCustomizer.INHERITANCE_ICONS[3];
        }
        ilvButton.setIcon(imageIcon);
        ilvButton.setMargin(new Insets(0, 0, 0, 0));
        ilvButton.setFocusPainted(false);
        if (jLabel != null) {
            this.labelButtons.put(jLabel, ilvButton);
        } else {
            this.buttons.put(string, ilvButton);
        }
        return ilvButton;
    }

    public JButton getInheritanceButton(String string, JLabel jLabel) {
        JButton jButton = (JButton)(jLabel == null ? this.buttons.get(string) : this.labelButtons.get(jLabel));
        return jButton;
    }

    private void a(JButton jButton, IlvCSSMicroCustomizer ilvCSSMicroCustomizer) {
        boolean bl = true;
        Icon icon = jButton.getIcon();
        if (icon == IlvCSSCustomizer.INHERITANCE_ICONS[0] || icon == IlvCSSCustomizer.INHERITANCE_ICONS[1]) {
            bl = false;
        }
        if (ilvCSSMicroCustomizer != null) {
            ilvCSSMicroCustomizer.fireStyleChangeEvent(bl);
        }
    }

    private String a(String string, int n2) {
        String string2 = this.a(n2);
        String string3 = null;
        String string4 = null;
        if (string != null && string.trim().length() > 0) {
            String string5 = string.toLowerCase();
            int n3 = string5.indexOf("<html>");
            if (n3 >= 0) {
                int n4 = string5.indexOf("</html>");
                if (n4 < 0) {
                    throw new RuntimeException("Expected </html> on tooltip: " + string);
                }
                if (n4 < n3) {
                    throw new RuntimeException("Unexpected: </html> before <html> on tooltip: " + string);
                }
                int n5 = string5.lastIndexOf("<span>");
                if (n5 >= 0) {
                    int n6 = string5.lastIndexOf("</span>");
                    if (n6 < 0) {
                        throw new RuntimeException("Expected </span> on tooltip: " + string);
                    }
                    int n7 = n3 + 6;
                    int n8 = n5;
                    int n9 = n6 + 7;
                    int n10 = n4;
                    string4 = (n8 >= n7 ? string.substring(n7, n8) : "") + (n10 >= n9 ? string.substring(n9, n10) : "");
                } else {
                    string4 = string.substring(n3 + 6, n4);
                }
            } else {
                string4 = string;
            }
        }
        string3 = string4 != null && string4.length() > 0 ? MSG_SUPPORT.formatMessage("XXdeclaration_tooltip2", string4, "<span>", string2, "</span>") : MSG_SUPPORT.formatMessage("XXdeclaration_tooltip1", "<span>" + string2 + "</span>");
        return "<html>" + string3 + "</html>";
    }

    private String a(int n2) {
        String string = null;
        switch (n2) {
            case 3: {
                string = MSG_SUPPORT.getMessage("XXdefault_declaration_tooltip");
                break;
            }
            case 2: {
                string = MSG_SUPPORT.getMessage("XXinherited_declaration_tooltip");
                break;
            }
            case 0: {
                string = MSG_SUPPORT.getMessage("XXlocal_declaration_tooltip");
                break;
            }
            case 1: {
                string = MSG_SUPPORT.getMessage("XXchanged_declaration_tooltip");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported declaration status: " + n2);
            }
        }
        return MSG_SUPPORT.formatMessage("XXdeclaration_status_tooltip", string);
    }

    private static class SingleElementImmutableCollection
    extends AbstractCollection {
        private Object a;

        SingleElementImmutableCollection(Object object) {
            this.a = object;
        }

        public int size() {
            return 1;
        }

        public Iterator iterator() {
            return new Itr();
        }

        private class Itr
        implements Iterator {
            private boolean a = false;

            private Itr() {
            }

            public boolean hasNext() {
                return !this.a;
            }

            public Object next() {
                if (this.a) {
                    throw new NoSuchElementException();
                }
                this.a = true;
                return SingleElementImmutableCollection.this.a;
            }

            public void remove() {
                throw new RuntimeException("Unsupported operation");
            }
        }
    }
}

