/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.wizard;

import ilog.views.applications.util.wizard.IlvWizardPage;
import ilog.views.applications.util.wizard.IlvWizardPanel;
import ilog.views.builder.IlvBuilder;
import ilog.views.builder.IlvBuilderPluginInstaller;
import ilog.views.builder.docview.IlvMessageView;
import ilog.views.builder.wizard.IlvDataSourcePage;
import ilog.views.builder.wizard.IlvEndPage;
import ilog.views.builder.wizard.IlvFromTemplatePage;
import ilog.views.builder.wizard.IlvStartPage;
import ilog.views.builder.wizard.IlvThemePage;
import ilog.views.util.swing.SwingFactories;
import ilog.views.util.swing.layout.IlvTableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class IlvBuilderWizard
extends IlvWizardPanel {
    public static final String TEMPLATE_PAGE = "Wizard_Template_Page";
    public static final String DATASOURCE_PAGE = "Wizard_DataSource_Page";
    public static final String MEMORY_DATASOURCE_PAGE = "Wizard_MemoryDataSource_Page";
    public static final String FLATFILE_PAGE = "Wizard_FlatFile_Page";
    public static final String XML_DATASOURCE_PAGE = "Wizard_XML_Page";
    public static final String JDBC_DATASOURCE_PAGE = "Wizard_JDBC_Page";
    public static final String MAPPING_PAGE = "Wizard_Mapping_Page";
    public static final String READONLY_MAPPING_PAGE = "Wizard_Readonly_Mapping_Page";
    public static final String END_PAGE = "Wizard_End_Page";
    public static final String THEME_PAGE = "Wizard_Theme_Page";
    protected IlvBuilder builder;
    private JCheckBox a;
    private JPanel b;
    private JComponent c;
    private TitledBorder d;

    public IlvBuilderWizard(IlvBuilder ilvBuilder, String string, String string2) {
        this(ilvBuilder, string, string2, true);
    }

    public IlvBuilderWizard(IlvBuilder ilvBuilder, String string, String string2, boolean bl) {
        super(string, string2, false);
        this.builder = ilvBuilder;
        this.setOwner(ilvBuilder.getFrame());
        this.getStatusBar().setLayout(new BoxLayout(this.getStatusBar(), SwingFactories.getBoxLayoutLineAxis()));
        if (bl) {
            this.a = new JCheckBox(IlvWizardPanel.getMessage("BuilderWizard.ShowAtStartup"), this.c());
            this.a.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    IlvBuilderWizard.this.a(itemEvent.getStateChange() == 1);
                }
            });
            this.a.setHorizontalAlignment(10);
            this.a.setOpaque(false);
            this.a.setBorder(new EmptyBorder(15, 5, 15, 5));
            this.getStatusBar().add(this.a);
        }
    }

    protected void initResources() {
        super.initResources();
        IlvWizardPanel.addResourceBundle("ilog.views.builder.wizard.wizard", Locale.getDefault());
    }

    protected void initIconBox(JPanel jPanel) {
        jPanel.setLayout(new IlvTableLayout(new double[][]{{-1.0}, {-1.0, -2.0, -1.0}}));
        jPanel.setBackground(Color.white);
        jPanel.setBorder(null);
        jPanel.add(Box.createVerticalGlue(), "0,0");
        JComponent jComponent = this.createPreviewComponent();
        if (jComponent != null) {
            this.setPreviewComponent(jComponent);
        }
        jPanel.add(Box.createVerticalGlue(), "0,2");
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        LineBorder lineBorder = new LineBorder(IlvWizardPanel.ILOG_DARK_BLUE, 4);
        this.d = new TitledBorder(new EmptyBorder(0, 0, 0, 0), "");
        CompoundBorder compoundBorder = new CompoundBorder(this.d, lineBorder);
        jPanel.setBorder(compoundBorder);
        return jPanel;
    }

    protected JComponent getPreviewComponent() {
        return this.c;
    }

    protected void setPreviewComponent(JComponent jComponent) {
        this.c = jComponent;
        if (jComponent == null) {
            if (this.b != null) {
                this.b.removeAll();
            }
        } else {
            if (this.b == null) {
                this.b = this.b();
                this.getIconBox().add((Component)this.b, "0,1");
            } else {
                this.b.removeAll();
            }
            jComponent.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    long l2 = hierarchyEvent.getChangeFlags();
                    JComponent jComponent = (JComponent)hierarchyEvent.getComponent();
                    if ((l2 & 4L) != 0L && jComponent.isShowing()) {
                        IlvBuilderWizard.this.previewComponentShown();
                        jComponent.removeHierarchyListener(this);
                    }
                }
            });
            this.b.add(jComponent);
        }
    }

    protected void previewComponentShown() {
    }

    public void setPreviewTitle(String string) {
        this.d.setTitle(string);
        this.b.revalidate();
    }

    protected JComponent createPreviewComponent() {
        return null;
    }

    public void setShowAtStartupVisible(boolean bl) {
        if (this.a != null) {
            this.a.setVisible(bl);
        }
    }

    public boolean isShowAtStartupVisible() {
        return this.a != null ? this.a.isVisible() : false;
    }

    public final IlvBuilder getBuilder() {
        return this.builder;
    }

    private void a(boolean bl) {
        IlvBuilderPluginInstaller ilvBuilderPluginInstaller = IlvBuilderPluginInstaller.getInstaller(this.getBuilder());
        ilvBuilderPluginInstaller.setShowWizardAtStartup(bl);
    }

    private boolean c() {
        IlvBuilderPluginInstaller ilvBuilderPluginInstaller = IlvBuilderPluginInstaller.getInstaller(this.getBuilder());
        return ilvBuilderPluginInstaller.isShowWizardAtStartup();
    }

    public boolean edit(Object object) {
        IlvStartPage ilvStartPage = null;
        if (object == null) {
            ilvStartPage = new IlvStartPage();
        }
        this.setFirstPage(ilvStartPage);
        return this.go(true);
    }

    public IlvWizardPage getOrCreatePage(String string) {
        IlvWizardPage ilvWizardPage = this.getPage(string);
        if (ilvWizardPage == null) {
            ilvWizardPage = this.createPage(string);
        }
        if (ilvWizardPage != null) {
            this.addPage(ilvWizardPage);
            return ilvWizardPage;
        }
        return super.getOrCreatePage(string);
    }

    protected IlvWizardPage createPage(String string) {
        if (TEMPLATE_PAGE.equals(string)) {
            return new IlvFromTemplatePage();
        }
        if (DATASOURCE_PAGE.equals(string)) {
            return new IlvDataSourcePage();
        }
        if (THEME_PAGE.equals(string)) {
            return new IlvThemePage();
        }
        if (END_PAGE.equals(string)) {
            return new IlvEndPage();
        }
        if (READONLY_MAPPING_PAGE.equals(string)) {
            return this.createPage(MAPPING_PAGE);
        }
        return null;
    }

    public boolean go(boolean bl) {
        IlvMessageView.setEnabled(this.getBuilder().getApplication(), false);
        boolean bl2 = super.go(bl);
        IlvMessageView.setEnabled(this.getBuilder().getApplication(), true);
        return bl2;
    }

    protected JDialog createDialog(Frame frame, String string, boolean bl) {
        return new JDialog(frame, string, bl){

            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (!bl && !IlvBuilderWizard.this.isDone()) {
                    IlvBuilderWizard.this.cancel();
                    IlvBuilderWizard.this.setCancelled(true);
                    IlvBuilderWizard.this.done();
                }
            }
        };
    }
}

