/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.css.model;

import ilog.views.css.model.AbstractNode;
import ilog.views.css.model.IlvConfigNode;
import ilog.views.css.model.IlvMessagesSupport;
import ilog.views.css.model.IlvNode;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleImpl;
import ilog.views.css.model.IlvRuleModel;
import ilog.views.css.model.IlvRuleModelStrategy;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.css.model.IlvSelector;
import ilog.views.css.model.event.CSSChangeEvent;
import ilog.views.css.model.event.CSSChangeListener;
import ilog.views.css.model.event.IlvCSSChangeSupport;
import ilog.views.css.model.internal.IlvRuleHelper;
import ilog.views.css.model.internal.SubRuleMethods;
import ilog.views.util.css.IlvCSSBeans;
import ilog.views.util.css.IlvCSSEngine;
import ilog.views.util.css.parser.Attribute;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.css.parser.Parser;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.styling.IlvCSSAttributeSelector;
import ilog.views.util.styling.IlvCSSDeclaration;
import ilog.views.util.styling.IlvCSSparseException;
import ilog.views.util.styling.IlvStylingException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class IlvRuleModelImpl
implements IlvRuleModel {
    private IlvRuleModelStrategy a;
    private IlvRule b;
    private IlvConfigNode c;
    private IlvCSSChangeSupport d;
    private int e;
    private boolean f;
    private SharpRuleUsageMap g;
    private boolean h = false;
    private Map i = new HashMap();
    private PropertyChangeSupport j;

    public IlvRuleModelImpl(IlvRuleModelStrategy ilvRuleModelStrategy) {
        this.a = ilvRuleModelStrategy;
        this.j = new PropertyChangeSupport(this);
        this.d = new IlvCSSChangeSupport(this);
    }

    public IlvCSSBeans getCSSBeans() {
        return this.a.getCSSBeans();
    }

    protected IlvCSSEngine getCSSEngine() {
        return this.getCSSBeans().getCSSengine();
    }

    public IlvRule[] getAllRules(boolean bl) {
        Rule[] ruleArray = this.getCSSEngine().getRules(bl);
        IlvRule[] ilvRuleArray = new IlvRule[ruleArray.length];
        for (int i2 = 0; i2 < ruleArray.length; ++i2) {
            ilvRuleArray[i2] = this.getWrappedRule(ruleArray[i2]);
        }
        return ilvRuleArray;
    }

    public IlvRule getWrappedRule(Rule rule) {
        if (rule.getRuleWrapper() == null) {
            IlvRule ilvRule = this.createRule(rule);
            ilvRule.setConfigurationRule(this.a.isConfigurationRule(ilvRule));
            return ilvRule;
        }
        return (IlvRule)rule.getRuleWrapper();
    }

    public IlvRule createRule(Rule rule) {
        return new IlvRuleImpl(rule);
    }

    protected IlvRule[] getRules(boolean bl) {
        IlvRule[] ilvRuleArray = this.getAllRules(bl);
        return this.a.getVisibleRules(ilvRuleArray);
    }

    public synchronized void setRules(IlvRule[] ilvRuleArray) {
        Rule[] ruleArray = new Rule[ilvRuleArray.length];
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            ruleArray[i2] = ((IlvRuleImpl)ilvRuleArray[i2]).getRule();
        }
        this.getCSSEngine().setRules(ruleArray);
    }

    public synchronized void rulesChanged() {
        this.g = null;
    }

    public void buildTree() {
        IlvRule[] ilvRuleArray;
        int n2;
        this.g = this.getSharpRuleUsageMap(this.getAllRules(true));
        this.a();
        IlvRule[] ilvRuleArray2 = this.getRules(true);
        for (n2 = 0; n2 < ilvRuleArray2.length; ++n2) {
            ilvRuleArray2[n2].resetTreeNode();
        }
        ilvRuleArray2 = this.getRootRules(true, false);
        n2 = 0;
        for (int i2 = 0; i2 < ilvRuleArray2.length; ++i2) {
            ilvRuleArray = ilvRuleArray2[i2];
            if (!ilvRuleArray.isConfigurationRule()) continue;
            ++n2;
        }
        IlvRule[] ilvRuleArray3 = new IlvRule[ilvRuleArray2.length - n2];
        ilvRuleArray = new IlvRule[n2];
        int n3 = 0;
        n2 = 0;
        for (int i3 = 0; i3 < ilvRuleArray2.length; ++i3) {
            IlvRule ilvRule = ilvRuleArray2[i3];
            if (ilvRule.isConfigurationRule()) {
                ilvRuleArray[n2++] = ilvRule;
                continue;
            }
            ilvRuleArray3[n3++] = ilvRule;
        }
        ilvRuleArray2 = ilvRuleArray3;
        this.b = (IlvRule)((Object)this.makePartialTree(ilvRuleArray2, new IlvRuleImpl(new Rule())));
        this.c = (IlvConfigNode)this.makePartialTree(ilvRuleArray, new IlvConfigNode());
    }

    protected AbstractNode makePartialTree(IlvRule[] ilvRuleArray, AbstractNode abstractNode) {
        Object object;
        IlvSelector ilvSelector;
        IlvRule ilvRule;
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        arrayList.addAll(Arrays.asList(ilvRuleArray));
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ilvRule = (IlvRule)listIterator.next();
            ilvSelector = ilvRule.getSelector();
            object = (Attribute[])ilvSelector.getAttributes();
            String[] stringArray = ilvSelector.getPseudoClasses();
            if ((object == null || ((Attribute[])object).length <= 0) && (stringArray == null || stringArray.length <= 0)) continue;
            listIterator.remove();
            IlvRule ilvRule2 = this.findParent(arrayList, ilvSelector.getType(), ilvSelector.getID(), ilvSelector.getCSSclasses());
            if (ilvRule2 == null) {
                abstractNode.addChild(ilvRule);
                continue;
            }
            ilvRule2.addChild(ilvRule);
        }
        listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ilvRule = (IlvRule)listIterator.next();
            ilvSelector = ilvRule.getSelector();
            if (this.isEmpty(ilvSelector.getCSSclasses())) continue;
            listIterator.remove();
            object = this.findParent(arrayList, ilvSelector.getType(), ilvSelector.getID(), null);
            if (object == null) {
                abstractNode.addChild(ilvRule);
                continue;
            }
            object.addChild(ilvRule);
        }
        listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ilvRule = (IlvRule)listIterator.next();
            abstractNode.addChild(ilvRule);
        }
        return abstractNode;
    }

    public IlvRule[] getRootRules(boolean bl) {
        return this.getRootRules(bl, true);
    }

    public IlvRule[] getRootRules(boolean bl, boolean bl2) {
        IlvRule[] ilvRuleArray = bl2 ? this.getAllRules(bl) : this.getRules(bl);
        SharpRuleUsageMap sharpRuleUsageMap = this.getSharpRuleUsageMap(ilvRuleArray);
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            if (ilvRuleArray[i2].getSelector() != null && ilvRuleArray[i2].getSelector().getID() != null) {
                if (sharpRuleUsageMap.getUsageCount(ilvRuleArray[i2].getSelector().getID()) != 0) continue;
                arrayList.add(ilvRuleArray[i2]);
                continue;
            }
            arrayList.add(ilvRuleArray[i2]);
        }
        return arrayList.toArray(new IlvRule[arrayList.size()]);
    }

    protected boolean softEquals(String string, String string2) {
        return string != null && string.equals(string2);
    }

    protected boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private boolean a(String[] stringArray, String[] stringArray2) {
        if (this.isEmpty(stringArray2)) {
            return true;
        }
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            String string = stringArray2[i2];
            boolean bl = false;
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                String string2 = stringArray[i3];
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean a(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    protected IlvRule findParent(ArrayList arrayList, String string, String string2, String[] stringArray) {
        IlvSelector ilvSelector;
        IlvRule ilvRule;
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ilvRule = (IlvRule)listIterator.next();
            ilvSelector = ilvRule.getSelector();
            if (!this.isEmpty(ilvSelector.getAttributes()) || !this.a(string, ilvSelector.getType()) || !this.a(string2, ilvSelector.getID()) || !this.a(ilvSelector.getCSSclasses(), stringArray)) continue;
            return ilvRule;
        }
        listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ilvRule = (IlvRule)listIterator.next();
            ilvSelector = ilvRule.getSelector();
            if (!this.isEmpty(ilvSelector.getAttributes()) || !this.a(string, ilvSelector.getType()) || !this.a(string2, ilvSelector.getID())) continue;
            return ilvRule;
        }
        return null;
    }

    public IlvRule getRootRule() {
        return this.b;
    }

    public IlvConfigNode getConfig() {
        return this.c;
    }

    public IlvRuleModelStrategy getCSSStrategy() {
        return this.a;
    }

    public void updateInheritanceIcons(IlvRule ilvRule) {
        this.resetOldIcons(this.getConfig());
        this.resetOldIcons(this.getRootRule());
        Rule[] ruleArray = this.getCSSBeans().getMatchedRules().getRuleFamily(((IlvRuleImpl)ilvRule).getRule());
        for (int i2 = 0; i2 < ruleArray.length; ++i2) {
            IlvRule ilvRule2 = this.getWrappedRule(ruleArray[i2]);
            ilvRule2.setInheritedStatus(4);
        }
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule, false);
        for (int i3 = 0; i3 < ilvRuleArray.length; ++i3) {
            ilvRuleArray[i3].setInheritedStatus(2);
        }
        ilvRule.setInheritedStatus(3);
    }

    public void resetOldIcons(IlvNode ilvNode) {
        if (ilvNode instanceof IlvRule) {
            IlvRule ilvRule = (IlvRule)ilvNode;
            ilvRule.setInheritedStatus(3);
            ilvRule.setUsed(true);
        }
        for (int i2 = 0; i2 < ilvNode.getChildCount(); ++i2) {
            this.resetOldIcons((IlvRule)ilvNode.getChildAt(i2));
        }
    }

    public IlvRule[] getParentRules(IlvRule ilvRule) {
        return this.getParentRules(ilvRule, false);
    }

    public IlvRule[] getParentRules(IlvRule ilvRule, boolean bl) {
        if (ilvRule == null) {
            return new IlvRule[0];
        }
        ArrayList arrayList = this.getRelatedRules(ilvRule);
        int n2 = arrayList.indexOf(ilvRule);
        if (n2 != -1) {
            int n3;
            int n4 = n3 = bl ? n2 + 1 : n2;
            while (n3 < arrayList.size()) {
                arrayList.remove(n3);
            }
        } else if (bl) {
            arrayList.add(ilvRule);
        }
        return arrayList.toArray(new IlvRule[arrayList.size()]);
    }

    public IlvRule getParentRule(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule);
        if (ilvRuleArray.length > 0) {
            return ilvRuleArray[ilvRuleArray.length - 1];
        }
        return null;
    }

    public ArrayList getRelatedRules(IlvRule ilvRule) {
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        if (ilvRule == null) {
            return arrayList;
        }
        boolean bl = true;
        IlvSelector ilvSelector = ilvRule.getSelector();
        IlvRule[] ilvRuleArray = this.getAllRules(false);
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule2 = ilvRuleArray[i2];
            if (ilvRule == ilvRule2) {
                bl = false;
                arrayList.add(ilvRule);
                continue;
            }
            IlvSelector ilvSelector2 = ilvRule2.getSelector();
            if ((!bl || !IlvRuleHelper.selectorIncluded(ilvSelector2, ilvSelector)) && (bl || !IlvRuleHelper.selectorIncluded(ilvSelector, ilvSelector2))) continue;
            arrayList.add(ilvRule2);
        }
        return arrayList;
    }

    public Object[] getMatchingObjects(IlvRule ilvRule) {
        return this.a.getMatchingObjects(ilvRule);
    }

    public HashSet getAdditionalRules(IlvRule ilvRule, IlvRule[] ilvRuleArray, HashSet hashSet, boolean bl) {
        IlvRule[] ilvRuleArray2 = this.getAllRules(false);
        SubRuleMethods subRuleMethods = new SubRuleMethods(ilvRuleArray2);
        IlvRule[] ilvRuleArray3 = subRuleMethods.getLocalRules(ilvRule, ilvRuleArray, bl);
        if (hashSet == null) {
            hashSet = new HashSet<IlvRule>(Arrays.asList(ilvRuleArray3));
        } else {
            hashSet.addAll(Arrays.asList(ilvRuleArray3));
        }
        return hashSet;
    }

    public IlvRule[] getAdditionalRules(IlvRule[] ilvRuleArray) {
        HashSet hashSet = this.getAdditionalRules(ilvRuleArray[ilvRuleArray.length - 1], ilvRuleArray, null, true);
        return hashSet.toArray(new IlvRule[hashSet.size()]);
    }

    public IlvRule getRuleWithDeclaration(IlvRule ilvRule, String string) {
        if (ilvRule.getCSSDeclarations() == null) {
            return null;
        }
        Declaration declaration = (Declaration)ilvRule.getDeclaration(string);
        if (declaration != null) {
            return ilvRule;
        }
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule);
        for (int i2 = ilvRuleArray.length; i2 > 0; --i2) {
            String string2 = ilvRuleArray[i2 - 1].getDeclarationValue(string);
            if (string2 == null) continue;
            return ilvRuleArray[i2 - 1];
        }
        return null;
    }

    public final IlvRule getSameRule(IlvRule ilvRule) {
        return this.getSameRule(ilvRule, false);
    }

    public final IlvRule getSameRule(IlvRule ilvRule, boolean bl) {
        return this.getSameRule(ilvRule, bl, false);
    }

    public IlvRule getSameRule(IlvRule ilvRule, boolean bl, boolean bl2) {
        IlvRule[] ilvRuleArray;
        IlvRule[] ilvRuleArray2 = ilvRuleArray = bl2 ? this.getAllRules(bl) : this.getRules(false);
        if (ilvRule == null || ilvRuleArray == null || ilvRuleArray.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule2 = ilvRuleArray[i2];
            if (!ilvRule.isIdentical(ilvRule2)) continue;
            return ilvRuleArray[i2];
        }
        return null;
    }

    public IlvRule getToplevelRule(IlvRule ilvRule) {
        String string;
        IlvRule[] ilvRuleArray;
        IlvRule[] ilvRuleArray2 = this.getAllRules(false);
        String string2 = ilvRule.toString();
        for (int i2 = 0; i2 < ilvRuleArray2.length; ++i2) {
            ilvRuleArray = ilvRuleArray2[i2];
            if (!string2.equals(ilvRuleArray.getSelectorString())) continue;
            ilvRule = ilvRuleArray;
            break;
        }
        if ((string = ilvRule.getSelector().getID()) != null) {
            ilvRuleArray = this.getRootRules(false, false);
            for (int i3 = 0; i3 < ilvRuleArray.length; ++i3) {
                IlvRule ilvRule2 = ilvRuleArray[i3];
                IlvRule[] ilvRuleArray3 = this.getAdditionalRules(new IlvRule[]{ilvRule2});
                IlvRule[] ilvRuleArray4 = IlvRuleUtils.getRulesFromId(ilvRuleArray3, string);
                for (int i4 = 0; i4 < ilvRuleArray4.length; ++i4) {
                    IlvCSSAttributeSelector[] ilvCSSAttributeSelectorArray;
                    IlvRule ilvRule3 = ilvRuleArray4[i4];
                    if (ilvRule3 != ilvRule || (ilvCSSAttributeSelectorArray = (Attribute[])ilvRule.getSelector().getAttributes()) == null) continue;
                    IlvRule ilvRule4 = ilvRule2.copy();
                    ilvRule4.getSelector().setAttributes(ilvCSSAttributeSelectorArray);
                    IlvRule ilvRule5 = this.getSameRule(ilvRule4);
                    if (ilvRule5 != null) {
                        return ilvRule5;
                    }
                    return ilvRule2;
                }
            }
        }
        return ilvRule;
    }

    public Map getDeclarations(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule, true);
        return IlvRuleUtils.getDeclarationsAsMap(ilvRuleArray, false);
    }

    public String getDeclarationValue(IlvRule ilvRule, String string) {
        if (ilvRule.getCSSDeclarations() == null) {
            return null;
        }
        Declaration declaration = (Declaration)ilvRule.getDeclaration(string);
        if (declaration != null) {
            return declaration.getTarget();
        }
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule);
        for (int i2 = ilvRuleArray.length; i2 > 0; --i2) {
            String string2 = ilvRuleArray[i2 - 1].getDeclarationValue(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeclarationValueAndUpdateUnusedSharpRules(IlvRule ilvRule, String string, String string2) {
        this.setAdjusting(true);
        try {
            if (this.g == null) {
                this.g = this.getSharpRuleUsageMap(this.getAllRules(true));
            }
            this.a(string2, this.g);
            String string3 = ilvRule.getDeclarationValue(string);
            this.a(string3);
            this.setDeclarationValue(ilvRule, string, string2);
        }
        finally {
            this.setAdjusting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeclarationAndUpdateUnusedSharpRules(IlvRule ilvRule, String string) {
        this.setAdjusting(true);
        try {
            String string2 = ilvRule.getDeclarationValue(string);
            this.a(string2);
            this.removeDeclaration(ilvRule, string);
        }
        finally {
            this.setAdjusting(false);
        }
    }

    public void setDeclarationValue(IlvRule ilvRule, String string, String string2) {
        ilvRule.setModified(string);
        ilvRule.setModified(true);
        ilvRule.setDeclaration(string, string2);
        this.validateRules(this.getAllRules(true), !this.isAdjusting());
        Declaration declaration = (Declaration)ilvRule.getDeclaration(string);
        CSSChangeEvent.Add add = new CSSChangeEvent.Add(this, ilvRule, null, new Declaration[]{declaration}, null, this.isAdjusting());
        this.d.fireStyleChangeEvent(add);
    }

    public void removeDeclaration(IlvRule ilvRule, String string) {
        Declaration declaration = (Declaration)ilvRule.getDeclaration(string);
        if (declaration == null) {
            return;
        }
        ilvRule.setModified(true);
        ilvRule.removeDeclaration(string);
        this.validateRules(this.getAllRules(true), !this.isAdjusting());
        CSSChangeEvent.Remove remove = new CSSChangeEvent.Remove(this, ilvRule, null, new Declaration[]{declaration}, null, this.isAdjusting());
        this.d.fireStyleChangeEvent(remove);
    }

    public void removeMetaDeclaration(IlvRule ilvRule, String string) {
        Declaration declaration = (Declaration)ilvRule.getMetaDeclaration(string);
        CSSChangeEvent.Remove remove = new CSSChangeEvent.Remove(this, ilvRule, null, new Declaration[]{declaration}, null, this.isAdjusting());
        this.d.fireStyleChangeEvent(remove);
    }

    public void setSelector(IlvRule ilvRule, IlvSelector ilvSelector) {
        ilvRule.setModified(true);
        IlvSelector ilvSelector2 = ilvRule.getSelector();
        ilvRule.setSelector(ilvSelector);
        this.validateRules(this.getAllRules(true), !this.isAdjusting());
        CSSChangeEvent.SelectorChange selectorChange = new CSSChangeEvent.SelectorChange(this, ilvRule, ilvSelector2, this.isAdjusting());
        this.d.fireStyleChangeEvent(selectorChange);
    }

    public String getDeclarationValue(IlvRule ilvRule, String string, boolean bl) {
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule, true);
        for (int i2 = ilvRuleArray.length; i2 > 0; --i2) {
            String string2 = ilvRuleArray[i2 - 1].getDeclarationValue(string, bl);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public String getLayoutId(IlvRule ilvRule) {
        String string = this.getDeclarationValue(ilvRule, "layout");
        if (string != null) {
            return string.substring(2);
        }
        return null;
    }

    public IlvRule getTopCompositeRule(IlvRule ilvRule) {
        IlvRule ilvRule2 = ilvRule;
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule);
        for (int i2 = ilvRuleArray.length; i2 > 0; --i2) {
            if (!ilvRuleArray[i2 - 1].isCompositeRule(this)) continue;
            ilvRule2 = ilvRuleArray[i2 - 1];
        }
        return ilvRule2;
    }

    public String getAttachmentIdFromIndex(int n2, IlvRule ilvRule) {
        String string = "constraints[" + n2 + "]";
        Map map = this.getDeclarations(ilvRule);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            if (!string2.equals(string)) continue;
            String string3 = (String)entry.getValue();
            return string3.substring(2);
        }
        return null;
    }

    public String getDecoAvailableId() {
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        int n2 = 0;
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            String string;
            int n3;
            int n4;
            int n5;
            IlvRule ilvRule = ilvRuleArray[i2];
            IlvSelector ilvSelector = ilvRule.getSelector();
            String string2 = ilvSelector.getID();
            if (string2 == null || (n5 = string2.lastIndexOf("__child__")) == -1 || (n4 = string2.lastIndexOf("__id__")) == -1 || (n3 = Integer.parseInt(string = string2.substring(n5 += "__child__".length(), n4))) <= n2) continue;
            n2 = n3;
        }
        return "__child__" + (n2 + 1) + "__id__";
    }

    public String getAttachmentAvailableId() {
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        int n2 = 0;
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            String string;
            int n3;
            int n4;
            int n5;
            IlvRule ilvRule = ilvRuleArray[i2];
            IlvSelector ilvSelector = ilvRule.getSelector();
            String string2 = ilvSelector.getID();
            if (string2 == null || (n5 = string2.lastIndexOf("__attachment__")) == -1 || (n4 = string2.lastIndexOf("__id__")) == -1 || (n3 = Integer.parseInt(string = string2.substring(n5 += "__attachment__".length(), n4))) <= n2) continue;
            n2 = n3;
        }
        return "__attachment__" + (n2 + 1) + "__id__";
    }

    public Object makeBeanFromRule(IlvRule ilvRule) {
        return this.a.makeBeanFromRule(this, ilvRule);
    }

    public Collection getMoreSpecificRules(IlvRule ilvRule, boolean bl) {
        ArrayList arrayList = this.getRelatedRules(ilvRule);
        int n2 = arrayList.indexOf(ilvRule);
        if (n2 == -1) {
            arrayList.clear();
            if (bl) {
                arrayList.add(ilvRule);
            }
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.remove(0);
            }
            if (!bl) {
                arrayList.remove(0);
            }
        }
        return arrayList;
    }

    public IlvRule[] withoutOverridingRules(IlvRule ilvRule) {
        Collection collection = this.getMoreSpecificRules(ilvRule, false);
        IlvRule[] ilvRuleArray = this.getAllRules(false);
        if (collection.size() > 0) {
            ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>(Arrays.asList(ilvRuleArray));
            arrayList.removeAll(collection);
            ilvRuleArray = arrayList.toArray(new IlvRule[arrayList.size()]);
        }
        return ilvRuleArray;
    }

    public Object setProperty(String string, Object object) {
        if (string == null) {
            return null;
        }
        Object v2 = this.i.get(string);
        if (object == null) {
            this.i.remove(string);
        } else {
            this.i.put(string, object);
        }
        this.a(string, v2, object);
        return v2;
    }

    public Object getProperty(String string) {
        return this.i.get(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.j.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.j.removePropertyChangeListener(propertyChangeListener);
    }

    public void addStyleChangeListener(CSSChangeListener cSSChangeListener) {
        this.d.addStyleChangeListener(cSSChangeListener);
    }

    public void removeStyleChangeListener(CSSChangeListener cSSChangeListener) {
        this.d.removeStyleChangeListener(cSSChangeListener);
    }

    private void a(String string, Object object, Object object2) {
        this.j.firePropertyChange(string, object, object2);
    }

    public IlvRule[] getMatchedRules(Object object) {
        return this.a.getMatchedRules(this, object);
    }

    private void a() {
        IlvRule ilvRule;
        HashSet hashSet = this.getSharpRules(this.getAllRules(false));
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ilvRule = (IlvRule)iterator.next();
            ilvRule.setMetaDeclaration("_EDITABLE", "true");
        }
        hashSet = this.getSharpRules(this.getRules(false));
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ilvRule = (IlvRule)iterator.next();
            String string = ilvRule.getSelector().getID();
            if (this.getSharpRuleUsageCount(string) != 0) continue;
            ilvRule.setMetaDeclaration("_EDITABLE", "false");
            Object[] objectArray = this.getMatchingObjects(ilvRule);
            if (objectArray == null || objectArray.length <= 0) continue;
            ilvRule.setMetaDeclaration("_EDITABLE", "true");
        }
    }

    public HashSet getSharpRules(Collection collection) {
        HashSet<IlvRule> hashSet = new HashSet<IlvRule>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IlvRule ilvRule = (IlvRule)iterator.next();
            if (ilvRule.getSelector() == null || ilvRule.getSelector().getID() == null) continue;
            String string = ilvRule.getSelector().getID();
            if (hashSet.contains(ilvRule)) continue;
            hashSet.add(ilvRule);
        }
        return hashSet;
    }

    public HashSet getSharpRules(IlvRule[] ilvRuleArray) {
        HashSet<IlvRule> hashSet = new HashSet<IlvRule>();
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule = ilvRuleArray[i2];
            if (ilvRule.getSelector() == null || ilvRule.getSelector().getID() == null) continue;
            String string = ilvRule.getSelector().getID();
            if (hashSet.contains(ilvRule)) continue;
            hashSet.add(ilvRule);
        }
        return hashSet;
    }

    public SharpRuleUsageMap getSharpRuleUsageMap(Collection collection) {
        Object object;
        SharpRuleUsageMap sharpRuleUsageMap = new SharpRuleUsageMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (IlvRule)iterator.next();
            if (this.a((IlvRule)object)) continue;
            this.a((IlvRule)object, sharpRuleUsageMap);
        }
        object = new ArrayList();
        Stack<IlvRule> stack = new Stack<IlvRule>();
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            IlvRule ilvRule = (IlvRule)iterator.next();
            if (!this.a(ilvRule)) continue;
            String string = ilvRule.getSelector().getID();
            if (sharpRuleUsageMap.getUsageCount(string) == 0) {
                ((ArrayList)object).add(ilvRule);
                continue;
            }
            stack.push(ilvRule);
        }
        this.a(sharpRuleUsageMap, stack, (ArrayList)object);
        return sharpRuleUsageMap;
    }

    public SharpRuleUsageMap getSharpRuleUsageMap(IlvRule[] ilvRuleArray) {
        SharpRuleUsageMap sharpRuleUsageMap = new SharpRuleUsageMap();
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            if (this.a(ilvRuleArray[i2])) continue;
            this.a(ilvRuleArray[i2], sharpRuleUsageMap);
        }
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        Stack<IlvRule> stack = new Stack<IlvRule>();
        for (int i3 = 0; i3 < ilvRuleArray.length; ++i3) {
            if (!this.a(ilvRuleArray[i3])) continue;
            String string = ilvRuleArray[i3].getSelector().getID();
            if (sharpRuleUsageMap.getUsageCount(string) == 0) {
                arrayList.add(ilvRuleArray[i3]);
                continue;
            }
            stack.push(ilvRuleArray[i3]);
        }
        this.a(sharpRuleUsageMap, stack, arrayList);
        return sharpRuleUsageMap;
    }

    private void a(SharpRuleUsageMap sharpRuleUsageMap, Stack stack, ArrayList object) {
        while (!stack.isEmpty()) {
            Object object2;
            while (!stack.isEmpty()) {
                object2 = (IlvRule)stack.pop();
                this.a((IlvRule)object2, sharpRuleUsageMap);
            }
            object2 = new ArrayList();
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                IlvRule ilvRule = (IlvRule)iterator.next();
                String string = ilvRule.getSelector().getID();
                if (sharpRuleUsageMap.getUsageCount(string) != 0) {
                    stack.add(ilvRule);
                    continue;
                }
                ((ArrayList)object2).add(ilvRule);
            }
            object = object2;
        }
    }

    private boolean a(IlvRule ilvRule) {
        IlvSelector ilvSelector = ilvRule.getSelector();
        return ilvSelector != null && ilvSelector.getID() != null;
    }

    private void a(IlvRule ilvRule, SharpRuleUsageMap sharpRuleUsageMap) {
        Declaration[] declarationArray = (Declaration[])ilvRule.getCSSDeclarations();
        for (int i2 = 0; i2 < declarationArray.length; ++i2) {
            Declaration declaration = declarationArray[i2];
            this.a(declaration._target, sharpRuleUsageMap);
        }
    }

    private void a(String string, SharpRuleUsageMap sharpRuleUsageMap) {
        ArrayList arrayList = IlvRuleUtils.getSharpRuleReferences(string);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                sharpRuleUsageMap.markUsed(string2);
            }
        }
    }

    public int getSharpRuleUsageCount(String string) {
        if (this.g == null) {
            this.g = this.getSharpRuleUsageMap(this.getAllRules(true));
        }
        return this.g.getUsageCount(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSharpRule(String string) {
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        SharpRuleUsageMap sharpRuleUsageMap = this.g;
        if (sharpRuleUsageMap == null) {
            sharpRuleUsageMap = this.getSharpRuleUsageMap(ilvRuleArray);
        }
        sharpRuleUsageMap.markUnused(string);
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        this.a(string, ilvRuleArray, sharpRuleUsageMap, arrayList, hashSet);
        this.setAdjusting(true);
        try {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                IlvRule ilvRule = (IlvRule)iterator.next();
                this.removeRule(ilvRule);
            }
        }
        finally {
            this.setAdjusting(false);
        }
    }

    private void a(String string) {
        ArrayList arrayList;
        if (string != null && (arrayList = IlvRuleUtils.getSharpRuleReferences(string)) != null) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                String string2 = (String)arrayList.get(i2);
                if (this.getSharpRuleUsageCount(string2) != 1) continue;
                this.removeSharpRule(string2);
            }
        }
    }

    private void a(String string, IlvRule[] ilvRuleArray, SharpRuleUsageMap sharpRuleUsageMap, ArrayList arrayList, HashSet hashSet) {
        ArrayList arrayList2 = IlvRuleUtils.getRulesFromIdAsList(ilvRuleArray, string);
        arrayList.addAll(arrayList2);
        hashSet.add(string);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            IlvRule ilvRule = (IlvRule)iterator.next();
            IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getCSSDeclarations();
            for (int i2 = 0; i2 < ilvCSSDeclarationArray.length; ++i2) {
                ArrayList arrayList3 = IlvRuleUtils.getSharpRuleReferences(ilvCSSDeclarationArray[i2]);
                if (arrayList3 == null) continue;
                Iterator iterator2 = arrayList3.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    sharpRuleUsageMap.markUnused(string2);
                    if (sharpRuleUsageMap.getUsageCount(string2) != 0 || hashSet.contains(string2)) continue;
                    this.a(string2, ilvRuleArray, sharpRuleUsageMap, arrayList, hashSet);
                }
            }
        }
    }

    private void a(String string, IlvRule[] ilvRuleArray, SharpRuleUsageMap sharpRuleUsageMap) {
        ArrayList arrayList = IlvRuleUtils.getRulesFromIdAsList(ilvRuleArray, string);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IlvRule ilvRule = (IlvRule)iterator.next();
            this.removeRule(ilvRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRulesUsingAttributeName(String string) {
        List list = this.getRulesUsingAttributeName(string);
        try {
            this.setAdjusting(true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.removeRule((IlvRule)iterator.next());
            }
        }
        finally {
            this.setAdjusting(false);
        }
    }

    public List getRulesUsingAttributeName(String string) {
        LinkedList<IlvRule> linkedList = new LinkedList<IlvRule>();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        block0: for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule = ilvRuleArray[i2];
            IlvSelector ilvSelector = ilvRule.getSelector();
            IlvCSSAttributeSelector[] ilvCSSAttributeSelectorArray = ilvSelector.getAttributes();
            for (int i3 = 0; i3 < ilvCSSAttributeSelectorArray.length; ++i3) {
                if (!string.equals(ilvCSSAttributeSelectorArray[i3].getAttributeName())) continue;
                linkedList.add(ilvRule);
                continue block0;
            }
        }
        return linkedList;
    }

    public List getDeclarationsUsingAttributeName(String string) {
        LinkedList<IlvCSSDeclaration> linkedList = new LinkedList<IlvCSSDeclaration>();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        block0: for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule = ilvRuleArray[i2];
            IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getCSSDeclarations();
            for (int i3 = 0; i3 < ilvCSSDeclarationArray.length; ++i3) {
                if (!string.equals(ilvCSSDeclarationArray[i3].getValue())) continue;
                linkedList.add(ilvCSSDeclarationArray[i3]);
                continue block0;
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeclarationsUsingAttributeName(String string) {
        this.setAdjusting(true);
        try {
            IlvRule[] ilvRuleArray = this.getAllRules(true);
            block3: for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                IlvRule ilvRule = ilvRuleArray[i2];
                IlvSelector ilvSelector = ilvRule.getSelector();
                IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getCSSDeclarations();
                for (int i3 = 0; i3 < ilvCSSDeclarationArray.length; ++i3) {
                    if (!string.equals(ilvCSSDeclarationArray[i3].getValue())) continue;
                    this.removeDeclaration(ilvRule, ilvCSSDeclarationArray[i3].getProperty());
                    continue block3;
                }
            }
        }
        finally {
            this.setAdjusting(false);
        }
    }

    public void addRule(IlvRule ilvRule) {
        this.getCSSBeans().clear();
        ilvRule.setConfigurationRule(this.a.isConfigurationRule(ilvRule));
        this.addRemoveRuleImpl(ilvRule, true, !this.isAdjusting());
        ilvRule.setModified(true);
        CSSChangeEvent.Add add = new CSSChangeEvent.Add(this, ilvRule, null, null, null, this.isAdjusting());
        this.d.fireStyleChangeEvent(add);
    }

    public void removeRule(IlvRule ilvRule) {
        this.getCSSBeans().clear();
        if (this.addRemoveRuleImpl(ilvRule, false, !this.isAdjusting())) {
            CSSChangeEvent.Remove remove = new CSSChangeEvent.Remove(this, ilvRule, null, null, null, this.isAdjusting());
            this.d.fireStyleChangeEvent(remove);
        }
    }

    protected boolean addRemoveRuleImpl(IlvRule ilvRule, boolean bl, boolean bl2) {
        IlvRule[] ilvRuleArray;
        IlvRule[] ilvRuleArray2 = this.getAllRules(true);
        if (bl) {
            ilvRuleArray = new IlvRule[ilvRuleArray2.length + 1];
            ilvRuleArray[ilvRuleArray2.length] = ilvRule;
            System.arraycopy(ilvRuleArray2, 0, ilvRuleArray, 0, ilvRuleArray2.length);
        } else {
            int n2 = -1;
            for (int i2 = 0; i2 < ilvRuleArray2.length; ++i2) {
                IlvRule ilvRule2 = ilvRuleArray2[i2];
                if (ilvRule2 != ilvRule) continue;
                n2 = i2;
                break;
            }
            if (n2 == -1) {
                return false;
            }
            ilvRuleArray = new IlvRule[ilvRuleArray2.length - 1];
            System.arraycopy(ilvRuleArray2, 0, ilvRuleArray, 0, n2);
            System.arraycopy(ilvRuleArray2, n2 + 1, ilvRuleArray, n2, ilvRuleArray2.length - n2 - 1);
        }
        this.validateRules(ilvRuleArray, bl2);
        return true;
    }

    private void a(IlvRule[] ilvRuleArray, IlvRule ilvRule, IlvRule[] ilvRuleArray2) {
        int n2;
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>(Arrays.asList(ilvRuleArray2));
        for (n2 = 0; n2 < ilvRuleArray.length; ++n2) {
            IlvRule ilvRule2 = ilvRuleArray[n2];
            arrayList.remove(ilvRule2);
        }
        n2 = arrayList.indexOf(ilvRule);
        if (n2 == -1) {
            arrayList.addAll(Arrays.asList(ilvRuleArray));
        } else {
            arrayList.addAll(n2, Arrays.asList(ilvRuleArray));
        }
        ilvRuleArray2 = arrayList.toArray(new IlvRule[arrayList.size()]);
        this.validateRules(ilvRuleArray2, true);
    }

    protected void validateRules(IlvRule[] ilvRuleArray, boolean bl) {
        this.getCSSBeans().clear();
        Rule[] ruleArray = new Rule[ilvRuleArray.length];
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            ruleArray[i2] = ((IlvRuleImpl)ilvRuleArray[i2]).getRule();
        }
        if (bl && this.h) {
            this.debugPrintRules("validateRules(reload=" + bl + ")", ilvRuleArray);
        }
        this.getCSSEngine().setRules(ruleArray);
        if (bl) {
            this.rulesChanged();
        }
    }

    public void setDebugMode(boolean bl) {
        this.h = bl;
    }

    protected void debugPrintRules(String string, IlvRule[] ilvRuleArray) {
        System.err.println("=====================================");
        System.err.println(string);
        PrintWriter printWriter = new PrintWriter(System.err, true);
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            ilvRuleArray[i2].printCSS(printWriter);
        }
    }

    public final IlvRule getRule(String string, boolean bl) throws IlvStylingException {
        return this.getRule(string, false, bl);
    }

    public IlvRule getRule(String string, boolean bl, boolean bl2) throws IlvStylingException {
        String string2 = string + "{}";
        Parser parser = new Parser(new StringReader(string2));
        try {
            Rule[] ruleArray = parser.parse();
            if (ruleArray.length != 1) {
                String string3 = MessageFormat.format(IlvMessagesSupport.getMessage("Exception.NotUniqueRule"), string);
                throw new IlvStylingException(string3);
            }
            IlvRule ilvRule = this.getWrappedRule(ruleArray[0]);
            IlvRule ilvRule2 = this.getSameRule(ilvRule, true, bl);
            if (ilvRule2 == null && bl2) {
                ilvRule2 = ilvRule;
                this.addRule(ilvRule2);
            }
            return ilvRule2;
        }
        catch (IlvCSSparseException ilvCSSparseException) {
            String string4 = MessageFormat.format(IlvMessagesSupport.getMessage("Exception.InvalidSelector"), string);
            throw new IlvStylingException(string4, ilvCSSparseException);
        }
    }

    public void setAdjusting(boolean bl) {
        boolean bl2 = this.isAdjusting();
        this.e = bl ? ++this.e : --this.e;
        if (this.e < 0) {
            this.e = 0;
        }
        if (bl2 && !this.isAdjusting()) {
            if (this.d.wasChangeDuringAdjusting()) {
                this.validateRules(this.getAllRules(true), true);
            }
            this.d.fireStyleChangeAdjustmentEndEventIfNeeded();
        }
    }

    public boolean isAdjusting() {
        return this.e > 0;
    }

    private static class Counter {
        int a = 0;

        private Counter() {
        }
    }

    public static class SharpRuleUsageMap
    extends HashMap {
        SharpRuleUsageMap() {
        }

        public void markUsed(String string) {
            Counter counter = (Counter)this.get(string);
            if (counter == null) {
                counter = new Counter();
                this.put(string, counter);
            }
            ++counter.a;
        }

        public void markUnused(String string) {
            Counter counter = (Counter)this.get(string);
            if (counter == null) {
                return;
            }
            --counter.a;
        }

        public int getUsageCount(String string) {
            Counter counter = (Counter)this.get(string);
            if (counter == null) {
                return 0;
            }
            return counter.a;
        }
    }
}

