/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUnresizeableDrawSelection;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.print.IlvPrintUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;

public class IlvMarker
extends IlvGraphic {
    public static final int IlvMarkerSquare = 1;
    public static final int IlvMarkerDiamond = 2;
    public static final int IlvMarkerCircle = 4;
    public static final int IlvMarkerCross = 8;
    public static final int IlvMarkerPlus = 16;
    public static final int IlvMarkerFilledSquare = 32;
    public static final int IlvMarkerFilledCircle = 64;
    public static final int IlvMarkerFilledDiamond = 128;
    public static final int IlvMarkerTriangle = 256;
    public static final int IlvMarkerFilledTriangle = 512;
    private final IlvPoint a = new IlvPoint();
    private int b = 1;
    private int c = 4;
    private Color d = Color.black;
    private static final int[] e = new int[5];
    private static final int[] f = new int[5];

    public IlvMarker() {
        this(new IlvPoint(0.0f, 0.0f), 1);
    }

    public IlvMarker(IlvPoint ilvPoint, int n2, int n3) {
        this.setPoint(ilvPoint);
        this.setType(n2);
        this.setSize(n3);
    }

    public IlvMarker(IlvPoint ilvPoint, int n2) {
        this(ilvPoint, n2, 4);
    }

    public IlvMarker(IlvMarker ilvMarker) {
        super(ilvMarker);
        this.setPoint(ilvMarker.getPoint());
        this.setType(ilvMarker.getType());
        this.setSize(ilvMarker.getSize());
        this.setForeground(ilvMarker.getForeground());
    }

    public IlvMarker(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        this.setPoint(ilvInputStream.readPoint("point"));
        this.setType(ilvInputStream.readInt("type"));
        this.setSize(ilvInputStream.readInt("size"));
    }

    public IlvGraphic copy() {
        return new IlvMarker(this);
    }

    public IlvPoint getPoint() {
        return new IlvPoint(this.a);
    }

    public void setPoint(IlvPoint ilvPoint) {
        this.a.x = ilvPoint.x;
        this.a.y = ilvPoint.y;
    }

    public int getType() {
        return this.b;
    }

    public void setType(int n2) {
        this.b = n2;
    }

    public int getSize() {
        return this.c;
    }

    public void setSize(int n2) {
        this.c = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = new IlvPoint(this.a);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint);
        }
        graphics.setColor(this.d);
        if (IlvGraphicUtil.isPrinting(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                AffineTransform affineTransform = (AffineTransform)graphics2D.getRenderingHint(IlvPrintUtil.KEY_PRINTING_TRANSFORM);
                if (affineTransform != null) {
                    graphics2D.translate(ilvPoint.x, ilvPoint.y);
                    graphics2D.scale(1.0 / affineTransform.getScaleX(), 1.0 / affineTransform.getScaleY());
                    graphics2D.translate(-ilvPoint.x, -ilvPoint.y);
                }
                IlvMarker.DrawMarker(graphics2D, ilvPoint, this.b, this.c);
            }
            finally {
                graphics2D.dispose();
            }
        } else {
            IlvMarker.DrawMarker(graphics, ilvPoint, this.b, this.c);
        }
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint;
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvPoint = new IlvPoint(this.a);
            ilvTransformer.apply(ilvPoint);
        } else {
            ilvPoint = this.a;
        }
        IlvRect ilvRect = new IlvRect();
        ilvRect.move(ilvPoint.x - (float)this.c, ilvPoint.y - (float)this.c);
        ilvRect.resize(2 * this.c, 2 * this.c);
        return ilvRect;
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null) {
            ilvTransformer.apply(this.a);
        }
    }

    public IlvSelection makeSelection() {
        return new IlvUnresizeableDrawSelection(this);
    }

    public void setForeground(Color color) {
        this.d = color;
    }

    public Color getForeground() {
        return this.d;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("point", this.a);
        ilvOutputStream.write("type", this.b);
        ilvOutputStream.write("size", this.c);
    }

    public boolean zoomable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void DrawMarker(Graphics graphics, IlvPoint ilvPoint, int n2, int n3) {
        int[] nArray;
        if ((n2 & 0x20) != 0) {
            graphics.fillRect((int)Math.floor(ilvPoint.x) - n3, (int)Math.floor(ilvPoint.y) - n3, 2 * n3, 2 * n3);
        }
        if ((n2 & 0x80) != 0) {
            nArray = e;
            // MONITORENTER : e
            IlvMarker.e[0] = (int)Math.floor(ilvPoint.x) - n3;
            IlvMarker.f[0] = (int)Math.floor(ilvPoint.y);
            IlvMarker.e[1] = (int)Math.floor(ilvPoint.x);
            IlvMarker.f[1] = (int)Math.floor(ilvPoint.y) - n3;
            IlvMarker.e[2] = (int)Math.floor(ilvPoint.x) + n3;
            IlvMarker.f[2] = (int)Math.floor(ilvPoint.y);
            IlvMarker.e[3] = (int)Math.floor(ilvPoint.x);
            IlvMarker.f[3] = (int)Math.floor(ilvPoint.y) + n3;
            IlvMarker.e[4] = e[0];
            IlvMarker.f[4] = f[0];
            graphics.fillPolygon(e, f, 5);
            // MONITOREXIT : nArray
        }
        if ((n2 & 2) != 0) {
            nArray = e;
            // MONITORENTER : e
            IlvMarker.e[0] = (int)Math.floor(ilvPoint.x) - n3;
            IlvMarker.f[0] = (int)Math.floor(ilvPoint.y);
            IlvMarker.e[1] = (int)Math.floor(ilvPoint.x);
            IlvMarker.f[1] = (int)Math.floor(ilvPoint.y) - n3;
            IlvMarker.e[2] = (int)Math.floor(ilvPoint.x) + n3;
            IlvMarker.f[2] = (int)Math.floor(ilvPoint.y);
            IlvMarker.e[3] = (int)Math.floor(ilvPoint.x);
            IlvMarker.f[3] = (int)Math.floor(ilvPoint.y) + n3;
            IlvMarker.e[4] = e[0];
            IlvMarker.f[4] = f[0];
            graphics.drawPolyline(e, f, 5);
            // MONITOREXIT : nArray
        }
        if ((n2 & 0x200) != 0) {
            nArray = e;
            // MONITORENTER : e
            IlvMarker.e[0] = (int)Math.floor(ilvPoint.x) - n3;
            IlvMarker.f[0] = (int)Math.floor(ilvPoint.y) + n3;
            IlvMarker.e[1] = (int)Math.floor(ilvPoint.x);
            IlvMarker.f[1] = (int)Math.floor(ilvPoint.y) - n3;
            IlvMarker.e[2] = (int)Math.floor(ilvPoint.x) + n3;
            IlvMarker.f[2] = (int)Math.floor(ilvPoint.y) + n3;
            graphics.fillPolygon(e, f, 3);
            // MONITOREXIT : nArray
        }
        if ((n2 & 0x100) != 0) {
            nArray = e;
            // MONITORENTER : e
            IlvMarker.e[0] = (int)Math.floor(ilvPoint.x) - n3;
            IlvMarker.f[0] = (int)Math.floor(ilvPoint.y) + n3;
            IlvMarker.e[1] = (int)Math.floor(ilvPoint.x);
            IlvMarker.f[1] = (int)Math.floor(ilvPoint.y) - n3;
            IlvMarker.e[2] = (int)Math.floor(ilvPoint.x) + n3;
            IlvMarker.f[2] = (int)Math.floor(ilvPoint.y) + n3;
            IlvMarker.e[3] = e[0];
            IlvMarker.f[3] = f[0];
            graphics.drawPolyline(e, f, 4);
            // MONITOREXIT : nArray
        }
        if ((n2 & 4) != 0) {
            graphics.drawArc((int)Math.floor(ilvPoint.x) - n3, (int)Math.floor(ilvPoint.y) - n3, 2 * n3 - 1, 2 * n3 - 1, 0, 360);
        }
        if ((n2 & 0x40) != 0) {
            graphics.fillArc((int)Math.floor(ilvPoint.x) - n3, (int)Math.floor(ilvPoint.y) - n3, 2 * n3 - 1, 2 * n3 - 1, 0, 360);
        }
        if ((n2 & 8) != 0) {
            graphics.drawLine((int)Math.floor(ilvPoint.x) - n3, (int)Math.floor(ilvPoint.y) - n3, (int)Math.floor(ilvPoint.x) + n3, (int)Math.floor(ilvPoint.y) + n3);
            graphics.drawLine((int)Math.floor(ilvPoint.x) - n3, (int)Math.floor(ilvPoint.y) + n3, (int)Math.floor(ilvPoint.x) + n3, (int)Math.floor(ilvPoint.y) - n3);
        }
        if ((n2 & 0x10) != 0) {
            graphics.drawLine((int)Math.floor(ilvPoint.x), (int)Math.floor(ilvPoint.y) - n3, (int)Math.floor(ilvPoint.x), (int)Math.floor(ilvPoint.y) + n3);
            graphics.drawLine((int)Math.floor(ilvPoint.x) + n3, (int)Math.floor(ilvPoint.y), (int)Math.floor(ilvPoint.x) - n3, (int)Math.floor(ilvPoint.y));
        }
        if ((n2 & 1) == 0) return;
        graphics.drawRect((int)Math.floor(ilvPoint.x) - n3, (int)Math.floor(ilvPoint.y) - n3, 2 * n3, 2 * n3);
    }
}

