/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsSelection;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvPolyPoints;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;

public class IlvPolygon
extends IlvPolyPoints {
    private Color a;
    private Color b;
    private int c = 4;
    private static final int d = 2;
    private static final int e = 4;

    public IlvPolygon(IlvPoint[] ilvPointArray) {
        super(ilvPointArray);
    }

    public IlvPolygon(IlvPoint[] ilvPointArray, boolean bl) {
        super(ilvPointArray, bl);
    }

    public IlvPolygon(IlvPoint[] ilvPointArray, boolean bl, boolean bl2, boolean bl3) {
        super(ilvPointArray, bl);
    }

    public IlvPolygon(IlvPolygon ilvPolygon) {
        super(ilvPolygon);
        this.setForeground(ilvPolygon.getForeground());
        this.setBackground(ilvPolygon.getBackground());
        this.c = ilvPolygon.c;
    }

    public IlvPolygon(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        try {
            this.setBackground(ilvInputStream.readColor("background"));
            this.c = ilvInputStream.readInt("flags");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvGraphic copy() {
        return new IlvPolygon(this);
    }

    public boolean pointsInBBox() {
        return true;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        if (this.isFillOn() && !(ilvRect = this.boundingBox(ilvTransformer)).inside(ilvPoint2.x, ilvPoint2.y)) {
            return false;
        }
        return IlvGraphicUtil.PointInPolygon(ilvPoint2, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, ilvTransformer, this.isFillOn());
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.isFillOn()) {
            if (this.isStrokeOn()) {
                IlvGraphicUtil.FillOutlinedPolygon(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, this.getForeground(), this.getBackground(), ilvTransformer);
            } else {
                graphics.setColor(this.getForeground());
                IlvGraphicUtil.FillPolygon(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, ilvTransformer);
            }
        } else if (this.isStrokeOn()) {
            graphics.setColor(this.getBackground());
            IlvGraphicUtil.DrawPolygon(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, ilvTransformer);
        }
    }

    public void setForeground(Color color) {
        this.a = color;
    }

    public Color getForeground() {
        if (this.a != null) {
            return this.a;
        }
        return Color.black;
    }

    public void setBackground(Color color) {
        this.b = color;
    }

    public Color getBackground() {
        if (this.b == null) {
            return Color.black;
        }
        return this.b;
    }

    public boolean isFillOn() {
        return (this.c & 4) != 0;
    }

    public void setFillOn(boolean bl) {
        this.c = bl ? (this.c |= 4) : (this.c &= 0xFFFFFFFB);
    }

    public boolean isStrokeOn() {
        return (this.c & 2) != 0;
    }

    public void setStrokeOn(boolean bl) {
        this.c = bl ? (this.c |= 2) : (this.c &= 0xFFFFFFFD);
    }

    public IlvSelection makeSelection() {
        IlvPolyPointsSelection ilvPolyPointsSelection = new IlvPolyPointsSelection(this);
        ilvPolyPointsSelection.setClosedMode(true);
        return ilvPolyPointsSelection;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("background", this.getBackground());
        ilvOutputStream.write("flags", this.c);
    }
}

