/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvPolyPoints;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;

public class IlvPolyline
extends IlvPolyPoints {
    private Color a = null;

    public IlvPolyline(IlvPoint[] ilvPointArray) {
        super(ilvPointArray);
    }

    public IlvPolyline(IlvPoint[] ilvPointArray, boolean bl) {
        super(ilvPointArray, bl);
    }

    public IlvPolyline(IlvPolyline ilvPolyline) {
        super(ilvPolyline);
        this.a = ilvPolyline.a;
        this.setLineWidth(ilvPolyline.getLineWidth());
        this.setLineJoin(ilvPolyline.getLineJoin());
        this.setMaximumLineWidth(ilvPolyline.getMaximumLineWidth());
        this.setEndCap(ilvPolyline.getEndCap());
        this.setLineStyle(ilvPolyline.getLineStyle());
    }

    public IlvPolyline(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        try {
            this.setLineWidth(ilvInputStream.readFloat("lineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setMaximumLineWidth(ilvInputStream.readFloat("maximumLineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLineJoin(ilvInputStream.readInt("lineJoin"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setEndCap(ilvInputStream.readInt("endCap"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLineStyle(ilvInputStream.readFloatArray("lineStyle"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvGraphic copy() {
        return new IlvPolyline(this);
    }

    public boolean pointsInBBox() {
        return true;
    }

    public float getLineWidth() {
        return IlvStrokeInfo.GetLineWidth(this);
    }

    public void setLineWidth(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("bad line Width " + f2);
        }
        if (f2 != this.getLineWidth()) {
            IlvStrokeInfo.SetLineWidth(this, f2);
            this.a();
        }
    }

    public int getEndCap() {
        return IlvStrokeInfo.GetEndCap(this);
    }

    public void setEndCap(int n2) {
        if (n2 != 1 && n2 != 2 && n2 != 0) {
            throw new IllegalArgumentException("bad end cap");
        }
        if (n2 != this.getEndCap()) {
            IlvStrokeInfo.SetEndCap(this, n2);
            this.a();
        }
    }

    public int getLineJoin() {
        return IlvStrokeInfo.GetLineJoin(this);
    }

    public void setLineJoin(int n2) {
        if (n2 != 0 && n2 != 2 && n2 != 1) {
            throw new IllegalArgumentException("bad line join");
        }
        if (n2 != this.getLineJoin()) {
            IlvStrokeInfo.SetLineJoin(this, n2);
            this.a();
        }
    }

    public float getMaximumLineWidth() {
        return IlvStrokeInfo.GetMaximumLineWidth(this);
    }

    public void setMaximumLineWidth(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("limit must be greater or equal to 0 " + f2);
        }
        if (f2 != this.getMaximumLineWidth()) {
            IlvStrokeInfo.SetMaximumLineWidth(this, f2);
            this.a();
        }
    }

    public float[] getLineStyle() {
        return IlvStrokeInfo.GetLineStyle(this);
    }

    public void setLineStyle(float[] fArray) {
        IlvStrokeInfo.SetLineStyle(this, fArray);
    }

    protected void computeBBox(IlvRect ilvRect) {
        float f2 = this.getLineWidth();
        if (f2 == 0.0f) {
            super.computeBBox(ilvRect);
        } else {
            f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), null, true);
            IlvPoint[] ilvPointArray = this.getPoints();
            IlvRect ilvRect2 = IlvGraphicUtil.PolylineBBox(ilvPointArray, ilvPointArray.length, f2, this.getLineJoin(), this.getEndCap(), null);
            ilvRect.x = ilvRect2.x;
            ilvRect.y = ilvRect2.y;
            ilvRect.width = ilvRect2.width;
            ilvRect.height = ilvRect2.height;
        }
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        float f2 = this.getLineWidth();
        if (f2 == 0.0f) {
            return super.boundingBox(ilvTransformer);
        }
        f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, true);
        IlvPoint[] ilvPointArray = this.getPoints();
        IlvRect ilvRect = IlvGraphicUtil.PolylineBBox(ilvPointArray, ilvPointArray.length, f2, this.getLineJoin(), this.getEndCap(), ilvTransformer);
        return ilvRect;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        float f2 = this.getLineWidth();
        if (f2 == 0.0f) {
            IlvRect ilvRect = this.boundingBox(ilvTransformer);
            ilvRect.expand(IlvUtil.GetDeltaLine());
            if (!ilvRect.inside(ilvPoint2.x, ilvPoint2.y)) {
                return false;
            }
            return IlvGraphicUtil.PointInPolyline(ilvPoint2, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, 0.0f, 1, 0, ilvTransformer);
        }
        f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, false);
        return IlvGraphicUtil.PointInPolyline(ilvPoint2, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, f2, this.getLineJoin(), this.getEndCap(), ilvTransformer);
    }

    public float getLineWidth(IlvTransformer ilvTransformer) {
        float f2 = this.getLineWidth();
        if (f2 == 0.0f) {
            return 1.0f;
        }
        f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, false);
        double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        return Math.max(1.0f, (float)((double)f2 * d2));
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        graphics.setColor(this.getForeground());
        float f2 = this.getLineWidth();
        float[] fArray = this.getLineStyle();
        if (f2 == 0.0f && fArray == null) {
            IlvGraphicUtil.DrawPolyline(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, 0.0f, 1, 0, null, ilvTransformer);
        } else {
            float f3 = this.getMaximumLineWidth();
            fArray = IlvStrokeInfo.zoomedLineStyle(fArray, f2, f3, ilvTransformer);
            f2 = IlvStrokeInfo.zoomedLineWidth(f2, f3, ilvTransformer, false);
            IlvGraphicUtil.DrawPolyline(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, f2, this.getLineJoin(), this.getEndCap(), fArray, ilvTransformer);
        }
    }

    public void setForeground(Color color) {
        this.a = color;
    }

    public Color getForeground() {
        if (this.a != null) {
            return this.a;
        }
        return Color.black;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float[] fArray;
        int n2;
        int n3;
        float f2;
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        float f3 = this.getLineWidth();
        if (f3 != 0.0f) {
            ilvOutputStream.write("lineWidth", f3);
        }
        if ((f2 = this.getMaximumLineWidth()) != 0.0f) {
            ilvOutputStream.write("maximumLineWidth", f2);
        }
        if ((n3 = this.getLineJoin()) != 1) {
            ilvOutputStream.write("lineJoin", n3);
        }
        if ((n2 = this.getEndCap()) != 2) {
            ilvOutputStream.write("endCap", n2);
        }
        if ((fArray = this.getLineStyle()) != null) {
            ilvOutputStream.write("lineStyle", fArray);
        }
    }

    protected void finalize() throws Throwable {
        IlvStrokeInfo.DisposeStroke(this);
    }
}

