/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvPolyPoints;
import ilog.views.graphic.IlvSplineSelection;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;

public class IlvSpline
extends IlvPolyPoints {
    private float a = -1.0f;
    private Color b;
    private Color c;
    private int d = 2;
    private static final int e = 2;
    private static final int f = 4;
    private static final int g = 8;

    public IlvSpline(IlvPoint[] ilvPointArray) {
        super(ilvPointArray);
    }

    public IlvSpline(IlvPoint[] ilvPointArray, boolean bl) {
        super(ilvPointArray, bl);
    }

    public IlvSpline(IlvPoint[] ilvPointArray, boolean bl, boolean bl2) {
        super(ilvPointArray, bl);
        this.setClosed(bl2);
    }

    public IlvSpline(IlvSpline ilvSpline) {
        super(ilvSpline);
        this.a = ilvSpline.a;
        this.setLineWidth(ilvSpline.getLineWidth());
        this.setMaximumLineWidth(ilvSpline.getMaximumLineWidth());
        this.setEndCap(ilvSpline.getEndCap());
        this.setLineStyle(ilvSpline.getLineStyle());
        this.setForeground(ilvSpline.getForeground());
        this.setBackground(ilvSpline.getBackground());
        this.d = ilvSpline.d;
    }

    public IlvSpline(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        try {
            this.setLineWidth(ilvInputStream.readFloat("lineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setMaximumLineWidth(ilvInputStream.readFloat("maximumLineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setEndCap(ilvInputStream.readInt("endCap"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLineStyle(ilvInputStream.readFloatArray("lineStyle"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setSmoothness(ilvInputStream.readFloat("smoothness"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.setSmoothness(-1.0f);
        }
        try {
            this.setBackground(ilvInputStream.readColor("background"));
            this.d = ilvInputStream.readInt("flags");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvGraphic copy() {
        return new IlvSpline(this);
    }

    protected void computeBBox(IlvRect ilvRect) {
        float f2 = this.getLineWidth();
        if (!this.isClosed()) {
            if (f2 == 0.0f) {
                IlvGraphicUtil.BezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), 0.0f, 0, 0, null);
            } else {
                f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), null, true);
                IlvGraphicUtil.BezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f2, 0, this.getEndCap(), null);
            }
        } else if (f2 == 0.0f) {
            IlvGraphicUtil.ClosedBezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), 0.0f, 0, 0, null);
        } else {
            f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), null, true);
            IlvGraphicUtil.ClosedBezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f2, 0, this.getEndCap(), null);
        }
    }

    public boolean pointsInBBox() {
        return false;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        float f2 = this.getLineWidth();
        if (f2 == 0.0f) {
            return super.boundingBox(ilvTransformer);
        }
        IlvRect ilvRect = new IlvRect();
        f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, true);
        if (!this.isClosed()) {
            IlvGraphicUtil.BezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f2, 0, this.getEndCap(), ilvTransformer);
        } else {
            IlvGraphicUtil.ClosedBezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f2, 0, this.getEndCap(), ilvTransformer);
        }
        return ilvRect;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray;
        if (this.isFillOn() && this.inBBox(ilvPoint) && IlvGraphicUtil.PointInFilledBezier(ilvPoint2, ilvPointArray = this.getPoints(), ilvPointArray.length, false, this.getSmoothness(), ilvTransformer)) {
            return true;
        }
        if (this.isStrokeOn()) {
            float f2 = IlvStrokeInfo.zoomedLineWidth(this.getLineWidth(), this.getMaximumLineWidth(), ilvTransformer, false);
            if (!this.isClosed()) {
                return IlvGraphicUtil.PointInBezier(ilvPoint2, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f2, 0, this.getEndCap(), ilvTransformer);
            }
            return IlvGraphicUtil.PointInClosedBezier(ilvPoint2, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f2, 0, this.getEndCap(), ilvTransformer);
        }
        return false;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (((IlvPolyPoints)this).a.length == 0) {
            return;
        }
        if (this.isFillOn()) {
            graphics.setColor(this.getBackground());
            IlvGraphicUtil.FillBezier(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), ilvTransformer);
        }
        if (this.isStrokeOn()) {
            float f2 = this.getLineWidth();
            float[] fArray = this.getLineStyle();
            graphics.setColor(this.getForeground());
            if (f2 == 0.0f && fArray == null) {
                if (!this.isClosed()) {
                    IlvGraphicUtil.DrawBezier(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), 0.0f, 0, 0, null, ilvTransformer, false);
                } else {
                    IlvGraphicUtil.DrawClosedBezier(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), 0.0f, 0, 0, null, ilvTransformer);
                }
            } else {
                float f3 = this.getMaximumLineWidth();
                fArray = IlvStrokeInfo.zoomedLineStyle(fArray, f2, f3, ilvTransformer);
                f2 = IlvStrokeInfo.zoomedLineWidth(f2, f3, ilvTransformer, false);
                if (!this.isClosed()) {
                    IlvGraphicUtil.DrawBezier(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f2, 0, this.getEndCap(), fArray, ilvTransformer, false);
                } else {
                    IlvGraphicUtil.DrawClosedBezier(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f2, 0, this.getEndCap(), fArray, ilvTransformer);
                }
            }
        }
    }

    public IlvSelection makeSelection() {
        return new IlvSplineSelection(this);
    }

    public void setForeground(Color color) {
        this.b = color;
    }

    public Color getForeground() {
        if (this.b == null) {
            return Color.black;
        }
        return this.b;
    }

    public void setBackground(Color color) {
        this.c = color;
    }

    public Color getBackground() {
        if (this.c == null) {
            return Color.black;
        }
        return this.c;
    }

    public boolean isFillOn() {
        return (this.d & 4) != 0;
    }

    public void setFillOn(boolean bl) {
        this.d = bl ? (this.d |= 4) : (this.d &= 0xFFFFFFFB);
    }

    public boolean isStrokeOn() {
        return (this.d & 2) != 0;
    }

    public void setStrokeOn(boolean bl) {
        this.d = bl ? (this.d |= 2) : (this.d &= 0xFFFFFFFD);
    }

    public void setClosed(boolean bl) {
        this.d = bl ? (this.d |= 8) : (this.d &= 0xFFFFFFF7);
    }

    public boolean isClosed() {
        return (this.d & 8) != 0;
    }

    public float getLineWidth() {
        return IlvStrokeInfo.GetLineWidth(this);
    }

    public void setLineWidth(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("bad line Width " + f2);
        }
        if (f2 != this.getLineWidth()) {
            IlvStrokeInfo.SetLineWidth(this, f2);
            this.a();
        }
    }

    public float getLineWidth(IlvTransformer ilvTransformer) {
        float f2 = this.getLineWidth();
        if (f2 == 0.0f) {
            return 1.0f;
        }
        f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, false);
        double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        return Math.max(1.0f, (float)((double)f2 * d2));
    }

    public int getEndCap() {
        return IlvStrokeInfo.GetEndCap(this);
    }

    public void setEndCap(int n2) {
        if (n2 != 1 && n2 != 2 && n2 != 0) {
            throw new IllegalArgumentException("bad end cap");
        }
        if (n2 != this.getEndCap()) {
            IlvStrokeInfo.SetEndCap(this, n2);
            this.a();
        }
    }

    public float getMaximumLineWidth() {
        return IlvStrokeInfo.GetMaximumLineWidth(this);
    }

    public void setMaximumLineWidth(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("limit must be greater than 0 " + f2);
        }
        if (f2 != this.getMaximumLineWidth()) {
            IlvStrokeInfo.SetMaximumLineWidth(this, f2);
            this.a();
        }
    }

    public float[] getLineStyle() {
        return IlvStrokeInfo.GetLineStyle(this);
    }

    public void setLineStyle(float[] fArray) {
        IlvStrokeInfo.SetLineStyle(this, fArray);
    }

    public void setSmoothness(float f2) {
        if (f2 == -1.0f || f2 >= 0.0f && f2 <= 1.0f) {
            this.a = f2;
            this.a();
        }
    }

    public float getSmoothness() {
        return this.a;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float f2;
        float[] fArray;
        int n2;
        float f3;
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        float f4 = this.getLineWidth();
        if (f4 != 0.0f) {
            ilvOutputStream.write("lineWidth", f4);
        }
        if ((f3 = this.getMaximumLineWidth()) != 0.0f) {
            ilvOutputStream.write("maximumLineWidth", f3);
        }
        if ((n2 = this.getEndCap()) != 2) {
            ilvOutputStream.write("endCap", n2);
        }
        if ((fArray = this.getLineStyle()) != null) {
            ilvOutputStream.write("lineStyle", fArray);
        }
        if ((f2 = this.getSmoothness()) != -1.0f) {
            ilvOutputStream.write("smoothness", f2);
        }
        ilvOutputStream.write("background", this.getBackground());
        ilvOutputStream.write("flags", this.d);
    }

    protected void finalize() throws Throwable {
        IlvStrokeInfo.DisposeStroke(this);
    }
}

