/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.decoration;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;

public class IlvBracket
extends IlvGraphic {
    private IlvRect a = new IlvRect(0.0f, 0.0f, 100.0f, 100.0f);
    private float b = 0.25f;
    private Color c;
    private Color d;
    private IlvPoint e = new IlvPoint();
    private int f = 1;
    private boolean g = false;
    private Shape h;
    private Shape i;
    private Shape j;
    private Stroke k = new BasicStroke(1.0f);

    public IlvBracket() {
        this.e.x = 100.0f;
        this.e.y = 50.0f;
    }

    public IlvBracket(IlvBracket ilvBracket) {
        this.a = ilvBracket.a;
        this.b = ilvBracket.b;
        this.c = ilvBracket.c;
        this.d = ilvBracket.d;
        this.e = ilvBracket.e;
    }

    public IlvBracket(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setBackground(ilvInputStream.readColor("background"));
        this.setForeground(ilvInputStream.readColor("foreground"));
        this.a = ilvInputStream.readRect("drawRect");
        this.b = ilvInputStream.readFloat("ratio");
        this.e.x = ilvInputStream.readFloat("fixedWidth");
        this.f = ilvInputStream.readInt("orientation");
        this.g = ilvInputStream.readBoolean("fillOn");
        try {
            this.setStroke(ilvInputStream.readStroke("stroke"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvGraphic copy() {
        return new IlvBracket(this);
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(this.a);
            this.h = null;
        }
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        Shape shape;
        Cloneable cloneable;
        this.a();
        if (ilvTransformer != null) {
            cloneable = new AffineTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
            shape = ((AffineTransform)cloneable).createTransformedShape(this.i);
        } else {
            shape = this.i;
        }
        cloneable = shape.getBounds2D();
        return new IlvRect((float)((RectangularShape)cloneable).getX(), (float)((RectangularShape)cloneable).getY(), (float)((RectangularShape)cloneable).getWidth(), (float)((RectangularShape)cloneable).getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.a();
        Shape shape = this.h;
        Shape shape2 = this.j;
        AffineTransform affineTransform = ilvTransformer == null ? null : new AffineTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
        AffineTransform affineTransform2 = graphics2D.getTransform();
        Paint paint = graphics2D.getPaint();
        try {
            if (affineTransform != null) {
                graphics2D.transform(affineTransform);
            }
            graphics2D.setStroke(this.k);
            if (this.isFillOn()) {
                graphics2D.setPaint(this.getBackground());
                graphics2D.fill(shape2);
            }
            graphics2D.setPaint(this.getForeground());
            graphics2D.draw(shape);
        }
        finally {
            if (affineTransform != null) {
                graphics2D.setTransform(affineTransform2);
            }
            graphics2D.setPaint(paint);
        }
    }

    private void a() {
        if (this.h != null) {
            return;
        }
        float f2 = this.a.width * this.b;
        if (this.e.x != 0.0f && this.e.x < f2) {
            f2 = this.e.x;
        }
        GeneralPath generalPath = new GeneralPath();
        switch (this.f) {
            default: {
                generalPath.moveTo(this.a.x + f2, this.a.y);
                generalPath.lineTo(this.a.x, this.a.y);
                generalPath.lineTo(this.a.x, this.a.y + this.a.height);
                generalPath.lineTo(this.a.x + f2, this.a.y + this.a.height);
                break;
            }
            case 2: {
                generalPath.moveTo(this.a.x + this.a.width - f2, this.a.y);
                generalPath.lineTo(this.a.x + this.a.width, this.a.y);
                generalPath.lineTo(this.a.x + this.a.width, this.a.y + this.a.height);
                generalPath.lineTo(this.a.x + this.a.width - f2, this.a.y + this.a.height);
            }
        }
        this.h = generalPath;
        this.j = new Rectangle2D.Float(this.a.x, this.a.y, this.a.width, this.a.height);
        this.i = this.k.createStrokedShape(this.j);
    }

    public void setForeground(Color color) {
        this.c = color;
    }

    public Color getForeground() {
        if (this.c == null) {
            return Color.black;
        }
        return this.c;
    }

    public void setBackground(Color color) {
        this.d = color;
    }

    public Color getBackground() {
        if (this.d == null) {
            return Color.white;
        }
        return this.d;
    }

    public void setWidth(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("the width must be greater than zero");
        }
        this.a.width = f2;
    }

    public float getWidth() {
        return this.a.width;
    }

    public void setHeight(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("the height must be greater than zero");
        }
        this.a.height = f2;
        this.h = null;
    }

    public float getHeight() {
        return this.a.height;
    }

    public void setWidthRatio(float f2) {
        if (f2 > 1.0f || f2 < 0.0f) {
            throw new IllegalArgumentException("the ratio value is must be between 0 and 1");
        }
        this.b = f2;
    }

    public float getWidthRatio() {
        return this.b;
    }

    public void setFixedWidth(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("the fixedWidth must be greater than zero");
        }
        this.e.x = f2;
        this.h = null;
    }

    public float getFixedWidth() {
        return this.e.x;
    }

    public int getOrientation() {
        return this.f;
    }

    public void setOrientation(int n2) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("the orientation is either IlvDirection.Left or IlvDirection.Right");
        }
        this.f = n2;
        this.h = null;
    }

    public void setFillOn(boolean bl) {
        this.g = bl;
        this.h = null;
    }

    public void setStroke(Stroke stroke) {
        this.k = stroke;
    }

    public Stroke getStroke() {
        return this.k;
    }

    public boolean isFillOn() {
        return this.g;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("background", this.getBackground());
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("drawRect", this.a);
        ilvOutputStream.write("ratio", this.b);
        ilvOutputStream.write("fixedWidth", this.e.x);
        ilvOutputStream.write("orientation", this.f);
        ilvOutputStream.write("fillOn", this.g);
        if (this.k instanceof BasicStroke) {
            ilvOutputStream.write("stroke", (BasicStroke)this.k);
        }
    }
}

