/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.linkconnector;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;
import java.util.HashMap;

public class IlvFreeLinkConnector
extends IlvLinkConnector {
    private HashMap a;
    private HashMap b;
    private boolean c = false;

    public IlvFreeLinkConnector() {
    }

    public IlvFreeLinkConnector(IlvGraphic ilvGraphic) {
        super(ilvGraphic);
    }

    public IlvFreeLinkConnector(IlvLinkImage ilvLinkImage, boolean bl) {
        super(ilvLinkImage, bl);
    }

    public IlvFreeLinkConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        try {
            this.c = ilvInputStream.readBoolean("connectionPointMoveAllowed");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        if (this.c) {
            ilvOutputStream.write("connectionPointMoveAllowed", this.c);
        }
    }

    public void detach(boolean bl) {
        this.a();
        super.detach(bl);
    }

    public void detach(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        this.b(ilvLinkImage, !bl);
        super.detach(ilvLinkImage, bl, bl2);
    }

    public void write(IlvOutputStream ilvOutputStream, IlvLinkImage ilvLinkImage, boolean bl) throws IOException {
        IlvPoint ilvPoint;
        super.write(ilvOutputStream, ilvLinkImage, bl);
        HashMap hashMap = this.a(ilvLinkImage, bl, false);
        if (hashMap != null && (ilvPoint = (IlvPoint)hashMap.get(ilvLinkImage)) != null) {
            ilvOutputStream.write(bl ? "fromPoint" : "toPoint", ilvPoint);
        }
    }

    public void read(IlvInputStream ilvInputStream, IlvLinkImage ilvLinkImage, boolean bl) throws IlvReadFileException {
        super.read(ilvInputStream, ilvLinkImage, bl);
        try {
            IlvPoint ilvPoint = ilvInputStream.readPoint(bl ? "fromPoint" : "toPoint");
            if (ilvPoint != null) {
                this.a(ilvLinkImage, ilvPoint, bl);
            }
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public boolean isPersistent() {
        return true;
    }

    private final HashMap a(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        if (!bl && IlvLinkConnector.Get(ilvLinkImage, true) == IlvLinkConnector.Get(ilvLinkImage, false)) {
            if (bl2 && this.b == null) {
                this.b = new HashMap(1, 1.0f);
            }
            return this.b;
        }
        if (bl2 && this.a == null) {
            this.a = new HashMap(7);
        }
        return this.a;
    }

    public IlvPoint getConnectionPoint(IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer) {
        boolean bl2;
        IlvPoint ilvPoint;
        IlvGraphic ilvGraphic = this.getNode();
        if (ilvGraphic == null) {
            throw new RuntimeException("the link connector is not attached to a node");
        }
        HashMap hashMap = this.a(ilvLinkImage, bl, false);
        IlvPoint ilvPoint2 = ilvPoint = hashMap != null ? (IlvPoint)hashMap.get(ilvLinkImage) : null;
        if (ilvPoint == null) {
            return null;
        }
        ilvPoint = new IlvPoint(ilvPoint);
        IlvRect ilvRect = this.a(ilvTransformer);
        boolean bl3 = bl2 = ilvTransformer != null && !ilvTransformer.isIdentity() && !ilvTransformer.isTranslation();
        if (bl2) {
            ilvTransformer.inverse(ilvRect);
            ilvPoint.x = ilvRect.x + ilvPoint.x * ilvRect.width;
            ilvPoint.y = ilvRect.y + ilvPoint.y * ilvRect.height;
            ilvTransformer.apply(ilvPoint);
        } else {
            ilvPoint.x = ilvRect.x + ilvPoint.x * ilvRect.width;
            ilvPoint.y = ilvRect.y + ilvPoint.y * ilvRect.height;
        }
        return ilvPoint;
    }

    public void connectLink(IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, boolean bl, IlvTransformer ilvTransformer) {
        boolean bl2;
        if (ilvPoint == null) {
            throw new IllegalArgumentException("point cannot be null");
        }
        IlvGraphic ilvGraphic = this.getNode();
        if (ilvGraphic == null) {
            throw new RuntimeException("the link connector is not attached to a node");
        }
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        IlvRect ilvRect = this.a(ilvTransformer);
        boolean bl3 = bl2 = ilvTransformer != null && !ilvTransformer.isIdentity() && !ilvTransformer.isTranslation();
        if (bl2) {
            ilvTransformer.inverse(ilvRect);
            ilvTransformer.inverse(ilvPoint2);
        }
        ilvPoint2.x = (ilvPoint2.x - ilvRect.x) / ilvRect.width;
        ilvPoint2.y = (ilvPoint2.y - ilvRect.y) / ilvRect.height;
        this.a(ilvLinkImage, ilvPoint2, bl);
    }

    public void disconnectLink(IlvLinkImage ilvLinkImage, boolean bl) {
        this.b(ilvLinkImage, !bl);
    }

    public void disconnectAllLinks() {
        this.a();
    }

    public boolean allowsConnectionPointMove(IlvLinkImage ilvLinkImage, boolean bl) {
        return this.c;
    }

    public void connectionPointMoveAllowed(boolean bl) {
        this.c = bl;
    }

    private void a(IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, boolean bl) {
        HashMap hashMap = this.a(ilvLinkImage, bl, true);
        IlvPoint ilvPoint2 = (IlvPoint)hashMap.get(ilvLinkImage);
        if (ilvPoint2 == null) {
            hashMap.put(ilvLinkImage, ilvPoint);
        } else {
            ilvPoint2.x = ilvPoint.x;
            ilvPoint2.y = ilvPoint.y;
        }
    }

    protected boolean zoomable() {
        return true;
    }

    public IlvPoint getClosestConnectionPoint(IlvPoint ilvPoint, Object object, Object object2, Object object3, boolean bl, IlvTransformer ilvTransformer) {
        return ilvPoint;
    }

    public void linkRemoved(IlvLinkImage ilvLinkImage) {
        this.b(ilvLinkImage, true);
    }

    private void b(IlvLinkImage ilvLinkImage, boolean bl) {
        if (this.a != null) {
            this.a.remove(ilvLinkImage);
            if (this.a.size() == 0) {
                this.a = null;
            }
        }
        if (bl && this.b != null) {
            this.b.remove(ilvLinkImage);
            if (this.b.size() == 0) {
                this.b = null;
            }
        }
    }

    protected void allLinksRemoved() {
        this.disconnectAllLinks();
    }

    private void a() {
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        if (this.b != null) {
            this.b.clear();
            this.b = null;
        }
    }

    protected IlvRect getNodeBoundingBox(IlvTransformer ilvTransformer) {
        return this.getNode().boundingBox(ilvTransformer);
    }

    private IlvRect a(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.getNodeBoundingBox(ilvTransformer);
        if (ilvRect.width < 1.0E-10f) {
            ilvRect.width = 1.0E-10f;
        }
        if (ilvRect.height < 1.0E-10f) {
            ilvRect.height = 1.0E-10f;
        }
        return ilvRect;
    }

    public IlvRect getGhostBoundingBox(IlvTransformer ilvTransformer) {
        return new IlvRect();
    }
}

