/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.svg;

import ilog.views.IlvGraphic;
import ilog.views.IlvTransformer;
import ilog.views.java2d.IlvLinearGradientPaint;
import ilog.views.java2d.IlvRadialGradientPaint;
import ilog.views.svg.SVGDocumentBuilder;
import ilog.views.svg.SVGDocumentBuilderConfigurator;
import ilog.views.svg.svggen.DefaultExtensionHandler;
import ilog.views.svg.svggen.DoubleStringConverter;
import ilog.views.svg.svggen.ImageHandler;
import ilog.views.svg.svggen.ImageHandlerBase64Encoder;
import ilog.views.svg.svggen.SVGGeneratorContext;
import ilog.views.svg.svggen.SVGGraphics2D;
import ilog.views.svg.svggen.SVGPaintDescriptor;
import ilog.views.util.java2d.IlvPattern;
import ilog.views.util.java2d.IlvTexture;
import java.awt.Graphics;
import java.awt.Paint;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GenericGraphicTranslator
implements SVGDocumentBuilderConfigurator.GraphicTranslator {
    private static GenericGraphicTranslator a = null;

    protected GenericGraphicTranslator() {
    }

    public static synchronized GenericGraphicTranslator getInstance() {
        if (a == null) {
            a = new GenericGraphicTranslator();
        }
        return a;
    }

    public Element translate(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer, SVGDocumentBuilder sVGDocumentBuilder) {
        GeneratorContext generatorContext = new GeneratorContext(sVGDocumentBuilder);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D((SVGGeneratorContext)generatorContext, false);
        Element element = sVGDocumentBuilder.getDocument().createElement("g");
        sVGGraphics2D.setTopLevelGroup(element);
        ilvGraphic.draw((Graphics)sVGGraphics2D, ilvTransformer);
        Iterator iterator = sVGGraphics2D.getDefinitionSet().iterator();
        while (iterator.hasNext()) {
            sVGDocumentBuilder.getDefinition().appendChild((Node)((Element)iterator.next()));
        }
        sVGGraphics2D.getDOMTreeManager().applyDefaultRenderingStyle(element);
        return element;
    }

    static class GeneratorContext
    extends SVGGeneratorContext {
        private SVGDocumentBuilder a;

        public GeneratorContext(SVGDocumentBuilder sVGDocumentBuilder) {
            super((Document)sVGDocumentBuilder.getDocument());
            this.setIDGenerator(sVGDocumentBuilder.a());
            this.setExtensionHandler((ilog.views.svg.svggen.ExtensionHandler)new ExtensionHandler());
            this.setImageHandler((ImageHandler)new ImageHandlerBase64Encoder());
            this.setStyleHandler(new StyleHandler());
            this.setDoubleStringConverter(new ConverterWrapper());
            this.a = sVGDocumentBuilder;
        }

        public SVGDocumentBuilder getDocumentBuilder() {
            return this.a;
        }

        private class ConverterWrapper
        implements DoubleStringConverter {
            private ConverterWrapper() {
            }

            public String doubleString(double d2) {
                return GeneratorContext.this.a.getConfigurator().getRealToStringConverter().doubleToString(d2);
            }
        }
    }

    private static class StyleHandler
    implements ilog.views.svg.svggen.StyleHandler {
        private StyleHandler() {
        }

        public void setStyle(Element element, Map map, SVGGeneratorContext sVGGeneratorContext) {
            SVGDocumentBuilder sVGDocumentBuilder = ((GeneratorContext)sVGGeneratorContext).getDocumentBuilder();
            sVGDocumentBuilder.startStylingElement(element, null);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                sVGDocumentBuilder.appendStyle(string, string2);
            }
            sVGDocumentBuilder.endStylingElement();
        }
    }

    private static class ExtensionHandler
    extends DefaultExtensionHandler {
        private ExtensionHandler() {
        }

        public SVGPaintDescriptor handlePaint(Paint paint, SVGGeneratorContext sVGGeneratorContext) {
            if (paint instanceof IlvLinearGradientPaint) {
                IlvLinearGradientPaint ilvLinearGradientPaint = (IlvLinearGradientPaint)paint;
                String string = ((GeneratorContext)sVGGeneratorContext).getDocumentBuilder().a(ilvLinearGradientPaint, null, false);
                return new SVGPaintDescriptor(string, "1", null);
            }
            if (paint instanceof IlvRadialGradientPaint) {
                IlvRadialGradientPaint ilvRadialGradientPaint = (IlvRadialGradientPaint)paint;
                String string = ((GeneratorContext)sVGGeneratorContext).getDocumentBuilder().a(ilvRadialGradientPaint, null, false);
                return new SVGPaintDescriptor(string, "1", null);
            }
            if (paint instanceof IlvTexture) {
                IlvTexture ilvTexture = (IlvTexture)paint;
                String string = ((GeneratorContext)sVGGeneratorContext).getDocumentBuilder().a(ilvTexture, null, null, false, false);
            } else if (paint instanceof IlvPattern) {
                IlvPattern ilvPattern = (IlvPattern)paint;
                String string = ((GeneratorContext)sVGGeneratorContext).getDocumentBuilder().a(ilvPattern, null, null, false, false);
            }
            return null;
        }
    }
}

