/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.builder.docview;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.event.IlvMessageMapper;
import ilog.views.appframe.event.MessageEvent;
import ilog.views.appframe.event.MessageListener;
import ilog.views.appframe.swing.IlvPanelView;
import ilog.views.appframe.swing.IlvPopupMenu;
import ilog.views.builder.IlvBuilder;
import ilog.views.symbology.builder.IlvSymbolDesignerUtilities;
import ilog.views.symbology.builder.docview.IlvSymbolDesignerDocument;
import ilog.views.symbology.builder.docview.IlvSymbolDesignerView;
import ilog.views.symbology.editor.internal.SymbolEditorUtilities;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteCategoryChild;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.event.PaletteEvent;
import ilog.views.symbology.palettes.event.PaletteListener;
import ilog.views.symbology.palettes.event.PaletteManagerEvent;
import ilog.views.symbology.palettes.event.PaletteManagerListener;
import ilog.views.symbology.palettes.swing.IlvPaletteDocumentationDialog;
import ilog.views.symbology.palettes.swing.IlvPaletteTreeViewer;
import ilog.views.util.swing.context.ComponentContext;
import ilog.views.util.swing.context.ComponentContextManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class IlvSymbolPaletteView
extends IlvPanelView {
    private JTabbedPane a;
    private IlvPaletteManager b;
    private IlvPopupMenu c;
    private IlvPopupMenu d;
    private ArrayList e = new ArrayList();
    private ArrayList f = new ArrayList();
    private PaletteListener g;
    private IlvPaletteDocumentationDialog h = null;
    private static int i;

    public IlvSymbolPaletteView() {
        this.a = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add(this.a);
        this.c = new IlvPopupMenu();
        this.c.setSettingsName("symbolPaletteViewPopupMenu");
        this.d = new IlvPopupMenu();
        this.d.setSettingsName("symbolPaletteTabPopupMenu");
        this.a.addMouseListener(new IlvSymbolDesignerUtilities.PopupMenuListener(null){

            protected JPopupMenu getPopupMenu(int n2, int n3) {
                int n4 = IlvSymbolPaletteView.this.a.indexAtLocation(n2, n3);
                if (n4 >= 0) {
                    return IlvSymbolPaletteView.this.d;
                }
                return IlvSymbolPaletteView.this.c;
            }
        });
        this.g = new DragDropPaletteListener();
    }

    public void setApplication(IlvApplication ilvApplication) {
        super.setApplication(ilvApplication);
        this.c.setApplication(ilvApplication);
        this.d.setApplication(ilvApplication);
        this.b = this.a();
        this.b.addPaletteManagerListener(new PaletteViewListener());
        for (int i2 = 0; i2 < this.b.getPaletteCount(); ++i2) {
            this.a(this.b.getPalette(i2));
        }
        this.getApplication().addMessageListener(new MessageListener(){

            public void receiveMessage(MessageEvent messageEvent) {
                if ("SymbolPaletteChanged".equals(messageEvent.getMessageName())) {
                    IlvPalette ilvPalette = (IlvPalette)messageEvent.getMessageParameters()[0];
                    if (ilvPalette != null) {
                        IlvSymbolPaletteView.this.c(ilvPalette);
                    } else {
                        for (int i2 = 0; i2 < IlvSymbolPaletteView.this.b.getPaletteCount(); ++i2) {
                            ilvPalette = IlvSymbolPaletteView.this.b.getPalette(i2);
                            IlvSymbolPaletteView.this.c(ilvPalette);
                        }
                    }
                }
            }
        }, this.getClass().getName() + ++i);
    }

    protected void registerMappings(IlvMessageMapper ilvMessageMapper) {
        super.registerMappings(ilvMessageMapper);
        ilvMessageMapper.registerActionMethod("NewPalette", "newPalette");
        ilvMessageMapper.registerActionMethod("NewCategory", "newCategory");
        ilvMessageMapper.registerActionStateMethod("NewCategory", "newCategoryState");
        ilvMessageMapper.registerActionMethod("NewSymbol", "newSymbol");
        ilvMessageMapper.registerActionStateMethod("NewSymbol", "newSymbolState");
        ilvMessageMapper.registerActionMethod("EditSymbol", "editSymbol");
        ilvMessageMapper.registerActionStateMethod("EditSymbol", "editSymbolState");
        ilvMessageMapper.registerActionMethod("CategoryProperties", "categoryProperties");
        ilvMessageMapper.registerActionStateMethod("CategoryProperties", "categoryPropertiesState");
        ilvMessageMapper.registerActionMethod("PaletteProperties", "paletteProperties");
        ilvMessageMapper.registerActionStateMethod("PaletteProperties", "palettePropertiesState");
        ilvMessageMapper.registerActionMethod("DeletePaletteObject", "deletePaletteObject");
        ilvMessageMapper.registerActionStateMethod("DeletePaletteObject", "deletePaletteObjectState");
        ilvMessageMapper.registerActionMethod("ClosePalette", "closePalette");
        ilvMessageMapper.registerActionStateMethod("ClosePalette", "closePaletteState");
        ilvMessageMapper.registerActionMethod("OpenPalette", "openPalette");
        ilvMessageMapper.registerActionMethod("SavePaletteAs", "savePaletteAs");
        ilvMessageMapper.registerActionStateMethod("SavePaletteAs", "savePaletteAsState");
        ilvMessageMapper.registerActionMethod("Reporting", "reporting");
        ilvMessageMapper.registerActionStateMethod("Reporting", "reportingState");
    }

    public void newPalette() {
        IlvPalette ilvPalette = IlvSymbolDesignerUtilities.newPalette(this.getApplication(), this.a());
        if (ilvPalette != null) {
            this.c(ilvPalette);
        }
    }

    public void newCategory() {
        if (this.h()) {
            String string = this.getApplication().getString("SymbolDesigner.DefaultCategoryName");
            IlvPaletteCategory ilvPaletteCategory = new IlvPaletteCategory(string);
            ilvPaletteCategory.setName(string);
            if (this.a(ilvPaletteCategory)) {
                this.g().add(ilvPaletteCategory);
                this.h();
                this.b(ilvPaletteCategory);
            }
        }
    }

    public void newCategoryState(Action action) {
        action.setEnabled(this.g() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSymbol() {
        IlvSymbolDesignerDocument ilvSymbolDesignerDocument = (IlvSymbolDesignerDocument)this.getApplication().newDocument(this.getApplication().getDocumentTemplate("Symbol"), true, null);
        if (ilvSymbolDesignerDocument != null) {
            IlvPaletteSymbol ilvPaletteSymbol = ilvSymbolDesignerDocument.getEditorDocument().getSymbol();
            this.g().add(ilvPaletteSymbol);
            File file = null;
            try {
                try {
                    file = ilvSymbolDesignerDocument.getEditorDocument().setAutomaticIcon(ilvPaletteSymbol);
                }
                catch (MalformedURLException malformedURLException) {
                    file = null;
                }
                this.h();
                try {
                    ilvSymbolDesignerDocument.setPathName(new URL(IlvSymbolDesignerUtilities.getPaletteObjectURL(this.b().getJarURL(), SymbolEditorUtilities.getPaletteObjectPath(ilvPaletteSymbol))));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException(malformedURLException);
                }
                this.b(ilvPaletteSymbol);
            }
            finally {
                file.delete();
            }
        }
    }

    public void newSymbolState(Action action) {
        action.setEnabled(this.g() != null);
    }

    public void editSymbol() {
        IlvPaletteSymbol[] ilvPaletteSymbolArray = this.f();
        IlvPalette ilvPalette = this.b();
        if (ilvPaletteSymbolArray != null && ilvPalette != null) {
            for (int i2 = 0; i2 < ilvPaletteSymbolArray.length; ++i2) {
                String string = SymbolEditorUtilities.getPaletteObjectPath(ilvPaletteSymbolArray[i2]);
                IlvSymbolDesignerUtilities.openSymbol(this.getApplication(), ilvPalette.getJarURL(), string);
            }
        }
    }

    public void editSymbolState(Action action) {
        action.setEnabled(this.f().length > 0);
    }

    public void categoryProperties() {
        if (this.h() && this.a(this.g())) {
            this.h();
        }
    }

    public void categoryPropertiesState(Action action) {
        action.setEnabled(this.g() != null);
    }

    public void paletteProperties() {
        IlvPalette ilvPalette = this.b();
        if (this.a().isPaletteReadOnly(ilvPalette)) {
            this.a((Object)ilvPalette);
        } else if (this.h() && this.a((Object)ilvPalette)) {
            this.h();
        }
    }

    public void palettePropertiesState(Action action) {
        action.setEnabled(this.b() != null);
    }

    public void deletePaletteObject() {
        IlvPalette ilvPalette = this.b();
        if (ilvPalette != null && this.a().isPaletteReadOnly(ilvPalette)) {
            JOptionPane.showMessageDialog(IlvBuilder.getBuilder(this.getApplication()).getFrame(), this.getApplication().getString("SymbolDesigner.CannotSaveReadOnlyPalette"));
            return;
        }
        IlvPaletteObject[] ilvPaletteObjectArray = this.d();
        for (int i2 = 0; i2 < ilvPaletteObjectArray.length; ++i2) {
            String string;
            IlvPaletteObject ilvPaletteObject = ilvPaletteObjectArray[i2];
            if (ilvPaletteObject == null) continue;
            String string2 = string = ilvPaletteObject instanceof IlvPaletteSymbol ? "Symbol" : "Category";
            if (JOptionPane.showOptionDialog(IlvBuilder.getBuilder(this.getApplication()).getFrame(), this.getApplication().getString("SymbolDesigner.ConfirmDelete" + string + ".Message"), this.getApplication().getString("SymbolDesigner.ConfirmDelete" + string + ".Title"), 0, 3, null, null, null) != 0 || !this.h()) continue;
            ilvPaletteObject.getParent().remove(ilvPaletteObject);
            this.h();
        }
    }

    public void deletePaletteObjectState(Action action) {
        IlvPaletteObject[] ilvPaletteObjectArray = this.d();
        boolean bl = ilvPaletteObjectArray.length > 0;
        for (int i2 = 0; i2 < ilvPaletteObjectArray.length; ++i2) {
            if (ilvPaletteObjectArray[i2].getParent() != null) continue;
            bl = false;
        }
        action.setEnabled(bl);
    }

    public void openPalette(ActionEvent actionEvent) {
        int n2;
        IlvPalette ilvPalette = IlvSymbolDesignerUtilities.openPalette(this.getApplication(), this.a());
        if (ilvPalette != null && (n2 = this.d(ilvPalette)) >= 0) {
            this.a.setSelectedIndex(n2);
        }
    }

    public void savePaletteAs() {
        File file;
        IlvPalette ilvPalette = this.b();
        if (ilvPalette != null && (file = IlvSymbolDesignerUtilities.choosePaletteFile(this.getApplication(), false, new File(ilvPalette.getJarURL().getFile()))) != null) {
            this.a(ilvPalette, file);
        }
    }

    public void savePaletteAsState(Action action) {
        action.setEnabled(this.b() != null);
    }

    public void closePalette() {
        IlvPalette ilvPalette = this.b();
        if (ilvPalette != null) {
            IlvSymbolDesignerView ilvSymbolDesignerView;
            this.b.remove(ilvPalette);
            ComponentContext componentContext = ComponentContextManager.getSingleton().getContext(this);
            if (componentContext != null && (ilvSymbolDesignerView = (IlvSymbolDesignerView)this.getApplication().getActiveView(true)) != null) {
                componentContext.setTarget(ilvSymbolDesignerView.getEditorView());
            }
        }
    }

    public void closePaletteState(Action action) {
        action.setEnabled(this.b() != null);
    }

    public void reporting() {
        if (this.h == null) {
            this.h = new IlvPaletteDocumentationDialog(this.a());
        }
        int n2 = this.d(this.b());
        IlvPaletteTreeViewer ilvPaletteTreeViewer = (IlvPaletteTreeViewer)this.f.get(n2);
        this.h.run(ilvPaletteTreeViewer.getPalette(), ilvPaletteTreeViewer.getSelectedPaletteObjects());
    }

    public void reportingState(Action action) {
        action.setEnabled(this.f().length > 0 || this.b() != null);
    }

    private IlvPaletteManager a() {
        return IlvSymbolDesignerUtilities.getPaletteManager(this.getApplication());
    }

    private void a(IlvPalette ilvPalette) {
        IlvPaletteTreeViewer ilvPaletteTreeViewer = new IlvPaletteTreeViewer();
        ilvPaletteTreeViewer.setEditable(true);
        ilvPaletteTreeViewer.setPalette(ilvPalette);
        IlvSymbolDesignerUtilities.expandAll((JTree)ilvPaletteTreeViewer.getComponent());
        JScrollPane jScrollPane = new JScrollPane(ilvPaletteTreeViewer.getComponent());
        this.a.add((Component)jScrollPane, ilvPalette.getName());
        this.a.setSelectedComponent(jScrollPane);
        this.e.add(ilvPalette);
        this.f.add(ilvPaletteTreeViewer);
        ilvPaletteTreeViewer.getComponent().addMouseListener(new IlvSymbolDesignerUtilities.PopupMenuListener(this.c){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    IlvSymbolPaletteView.this.editSymbol();
                }
            }
        });
        ((JTree)ilvPaletteTreeViewer.getComponent()).getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                String[] stringArray = new String[]{"NewCategory", "NewSymbol", "EditSymbol", "CategoryProperties", "PaletteProperties", "DeletePaletteObject", "SavePaletteAs", "ClosePalette"};
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    Action action = IlvSymbolPaletteView.this.getApplication().getAction(stringArray[i2]);
                    if (action == null) continue;
                    IlvSymbolPaletteView.this.updateAction(action);
                }
            }
        });
        ilvPalette.addPaletteListener(this.g);
    }

    private void b(IlvPalette ilvPalette) {
        int n2 = this.e.indexOf(ilvPalette);
        if (n2 >= 0) {
            this.a.removeTabAt(n2);
            this.e.remove(n2);
            this.f.remove(n2);
            ilvPalette.removePaletteListener(this.g);
        }
    }

    private void c(IlvPalette ilvPalette) {
        int n2 = this.d(ilvPalette);
        if (n2 >= 0) {
            IlvPaletteTreeViewer ilvPaletteTreeViewer = (IlvPaletteTreeViewer)this.f.get(n2);
            JTree jTree = (JTree)ilvPaletteTreeViewer.getComponent();
            TreePath[] treePathArray = jTree.getSelectionPaths();
            Enumeration<TreePath> enumeration = jTree.getExpandedDescendants(new TreePath(jTree.getModel().getRoot()));
            ilvPaletteTreeViewer.setPalette(ilvPalette);
            while (enumeration.hasMoreElements()) {
                jTree.expandPath(enumeration.nextElement());
            }
            jTree.setSelectionPaths(treePathArray);
            this.a.setTitleAt(n2, ilvPalette.getName());
            jTree.repaint();
        }
    }

    private IlvPalette a(int n2) {
        if (n2 >= 0 && n2 < this.e.size()) {
            return (IlvPalette)this.e.get(n2);
        }
        return null;
    }

    private int d(IlvPalette ilvPalette) {
        return this.e.indexOf(ilvPalette);
    }

    private IlvPalette b() {
        int n2 = this.a.getSelectedIndex();
        if (n2 >= 0) {
            return this.a(n2);
        }
        return null;
    }

    private IlvPaletteObject c() {
        TreePath treePath;
        JTree jTree;
        TreePath[] treePathArray;
        Component component;
        if (this.b() != null && (component = this.a.getSelectedComponent()) != null && (treePathArray = (jTree = (JTree)((Container)((Container)component).getComponent(0)).getComponent(0)).getSelectionPaths()) != null && treePathArray.length == 1 && (treePath = treePathArray[0]) != null && treePath.getLastPathComponent() instanceof IlvPaletteObject) {
            return (IlvPaletteObject)treePath.getLastPathComponent();
        }
        return null;
    }

    private IlvPaletteObject[] d() {
        JTree jTree;
        TreePath[] treePathArray;
        Component component;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.b() != null && (component = this.a.getSelectedComponent()) != null && (treePathArray = (jTree = (JTree)((Container)((Container)component).getComponent(0)).getComponent(0)).getSelectionPaths()) != null) {
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                TreePath treePath = treePathArray[i2];
                if (!(treePath.getLastPathComponent() instanceof IlvPaletteObject)) continue;
                arrayList.add(treePath.getLastPathComponent());
            }
        }
        return arrayList.toArray(new IlvPaletteObject[0]);
    }

    private IlvPaletteSymbol e() {
        IlvPaletteObject ilvPaletteObject = this.c();
        if (ilvPaletteObject instanceof IlvPaletteSymbol) {
            return (IlvPaletteSymbol)ilvPaletteObject;
        }
        return null;
    }

    private IlvPaletteSymbol[] f() {
        IlvPaletteObject[] ilvPaletteObjectArray = this.d();
        ArrayList<IlvPaletteObject> arrayList = new ArrayList<IlvPaletteObject>();
        for (int i2 = 0; i2 < ilvPaletteObjectArray.length; ++i2) {
            if (!(ilvPaletteObjectArray[i2] instanceof IlvPaletteSymbol)) continue;
            arrayList.add(ilvPaletteObjectArray[i2]);
        }
        return arrayList.toArray(new IlvPaletteSymbol[0]);
    }

    private IlvPaletteCategory g() {
        IlvPaletteObject ilvPaletteObject = this.c();
        if (ilvPaletteObject instanceof IlvPaletteCategory) {
            return (IlvPaletteCategory)ilvPaletteObject;
        }
        return null;
    }

    private boolean h() {
        IlvPalette ilvPalette = this.b();
        if (ilvPalette != null) {
            if (!this.a().isPaletteReadOnly(ilvPalette)) {
                return this.a(this.b(), new File(ilvPalette.getJarURL().getFile()));
            }
            IlvBuilder.showErrorBox(this.getApplication(), "SymbolDesigner.CannotSaveReadOnlyPalette", null);
            return false;
        }
        return false;
    }

    private boolean a(IlvPalette ilvPalette, File file) {
        if (IlvSymbolDesignerUtilities.savePalette(this.getApplication(), this.a(), ilvPalette, file)) {
            this.c(ilvPalette);
            return true;
        }
        return false;
    }

    private boolean a(Object object) {
        return IlvSymbolDesignerUtilities.showPalettePropertiesForm(this, this.getApplication(), object, false);
    }

    private void b(Object object) {
        int n2 = this.a.getSelectedIndex();
        if (n2 >= 0) {
            JTree jTree = (JTree)((IlvPaletteTreeViewer)this.f.get(n2)).getComponent();
            IlvSymbolDesignerUtilities.expandAll(jTree);
            for (int i2 = 0; i2 < jTree.getRowCount(); ++i2) {
                if (jTree.getPathForRow(i2).getLastPathComponent() != object) continue;
                jTree.setSelectionRow(i2);
                break;
            }
        }
    }

    private class DragDropPaletteListener
    implements PaletteListener {
        private IlvPalette a;
        private IlvPaletteCategoryChild b;

        private DragDropPaletteListener() {
        }

        public void categoryAdded(PaletteEvent paletteEvent) {
            this.a(paletteEvent);
        }

        public void categoryRemoved(PaletteEvent paletteEvent) {
            this.a = paletteEvent.getPalette();
            this.b = paletteEvent.getChild();
        }

        public void symbolAdded(PaletteEvent paletteEvent) {
            this.a(paletteEvent);
        }

        public void symbolRemoved(PaletteEvent paletteEvent) {
            this.a = paletteEvent.getPalette();
            this.b = paletteEvent.getChild();
        }

        public void valueSetAdded(PaletteEvent paletteEvent) {
        }

        public void valueSetRemoved(PaletteEvent paletteEvent) {
        }

        private void a(PaletteEvent paletteEvent) {
            if (paletteEvent.getChild() == this.b) {
                IlvPalette ilvPalette = paletteEvent.getPalette();
                if (IlvSymbolDesignerUtilities.savePalette(IlvSymbolPaletteView.this.getApplication(), IlvSymbolPaletteView.this.a(), ilvPalette, new File(ilvPalette.getJarURL().getFile())) && ilvPalette != this.a) {
                    IlvSymbolDesignerUtilities.savePalette(IlvSymbolPaletteView.this.getApplication(), IlvSymbolPaletteView.this.a(), this.a, new File(this.a.getJarURL().getFile()));
                }
            }
            this.b = null;
        }
    }

    private class PaletteViewListener
    implements PaletteManagerListener {
        private PaletteViewListener() {
        }

        public void paletteAdded(PaletteManagerEvent paletteManagerEvent) {
            IlvSymbolPaletteView.this.a(paletteManagerEvent.getPalette());
        }

        public void paletteRemoved(PaletteManagerEvent paletteManagerEvent) {
            IlvSymbolPaletteView.this.b(paletteManagerEvent.getPalette());
        }
    }
}

