/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.editor;

import ilog.views.IlvGraphic;
import ilog.views.IlvGrid;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.applications.util.eventpanel.IlvSelectable;
import ilog.views.applications.util.eventpanel.event.SelectionEvent;
import ilog.views.applications.util.eventpanel.event.SelectionListener;
import ilog.views.css.model.IlvRule;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvIcon;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.interactor.IlvPermanentInteractorInterface;
import ilog.views.interactor.IlvSelectInteractor;
import ilog.views.interactor.IlvSelectInteractorMoveSelection;
import ilog.views.swing.IlvJManagerViewPanel;
import ilog.views.swing.IlvJScrollManagerView;
import ilog.views.swing.IlvToolTipManager;
import ilog.views.symbology.editor.IlvSymbolEditorDocument;
import ilog.views.symbology.editor.IlvSymbolEditorInteractor;
import ilog.views.symbology.editor.event.SelectionChangedEvent;
import ilog.views.symbology.editor.event.SelectionChangedListener;
import ilog.views.symbology.editor.eventpanel.IlvSymbolEventPanel;
import ilog.views.symbology.editor.eventpanel.IlvSymbolGraphicSelectable;
import ilog.views.symbology.editor.internal.SymbolEditorUtilities;
import ilog.views.symbology.editor.rules.IlvSymbolRuleModel;
import ilog.views.symbology.editor.tree.IlvSymbolTree;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.swing.IlvPaletteDragAndDropData;
import ilog.views.symbology.palettes.swing.IlvPaletteObjectTransferable;
import ilog.views.util.swing.IlvSwingUtil;
import ilog.views.util.swing.context.ComponentContext;
import ilog.views.util.swing.context.ComponentContextManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public class IlvSymbolEditorView
extends JPanel {
    private IlvManagerView a;
    private IlvSymbolEventPanel b;
    private IlvSymbolEditorDocument c;
    private boolean d;
    private static final String e = "SymbolEditorClipboard";
    private double f = 2.0;
    private boolean g = false;
    private boolean h;
    private IlvGrid i;
    private IlvSelectInteractor j;
    private RunModeListener k;
    public static String lastImageFileChooserDirectory;
    public static String lastImageFileChooserFilter;
    private static boolean l;
    private static FileFilter m;
    private static FileFilter n;
    private static FileFilter o;
    private static FileFilter p;

    public IlvSymbolEditorView(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
        this.c = ilvSymbolEditorDocument;
        this.a = new IlvManagerView(ilvSymbolEditorDocument.getManager());
        this.a.setAntialiasing(true);
        this.a.setKeepingAspectRatio(true);
        this.a.setTripleBufferedLayerCount(1);
        IlvToolTipManager.registerView(this.a);
        IlvJScrollManagerView ilvJScrollManagerView = new IlvJScrollManagerView(this.a);
        this.b = new IlvSymbolEventPanel(this.a, ilvJScrollManagerView, ilvSymbolEditorDocument);
        this.setLayout(new BorderLayout());
        this.add((Component)this.b, "Center");
        this.a();
        this.a.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                IlvSymbolEditorView.this.a();
            }
        });
        ComponentContextManager.getSingleton().registerTarget(this);
        this.b.getSelectionManager().addSelectionListener(new SymbolEventPanelSelectionListener());
        ilvSymbolEditorDocument.addSelectionChangedListener(new RuleSelectionListener());
        this.a.addInteractorListener(new InteractorListener(){

            public void interactorChanged(InteractorChangedEvent interactorChangedEvent) {
                if (interactorChangedEvent.getOldValue() == null && interactorChangedEvent.getNewValue() != null && !(interactorChangedEvent.getNewValue() instanceof IlvSelectInteractor)) {
                    IlvSymbolEditorView.this.h = IlvSymbolEditorView.this.isSelectMode();
                    IlvSymbolEditorView.this.setSelectMode(false);
                } else if (interactorChangedEvent.getOldValue() != null && !(interactorChangedEvent.getOldValue() instanceof IlvSelectInteractor) && interactorChangedEvent.getNewValue() == null) {
                    IlvSymbolEditorView.this.setSelectMode(IlvSymbolEditorView.this.h);
                }
            }
        });
        new DropTarget(this, new SymbolDropTargetListener());
        this.j = new IlvSelectInteractor();
        this.j.allowEnsureVisible(true);
        this.k = new RunModeListener();
        this.a.getManager().addManagerSelectionListener(this.k);
        this.a.getManager().addManagerContentChangedListener(this.k);
        this.setGridVisible(true);
    }

    public IlvSymbolEditorDocument getDocument() {
        return this.c;
    }

    public IlvManagerView getManagerView() {
        return this.a;
    }

    public IlvSymbolEventPanel getEventPanel() {
        return this.b;
    }

    public void setSelectMode(boolean bl) {
        if (this.c.a()) {
            this.getEventPanel().trapEvent(false);
            if (bl) {
                if (!(this.a.getInteractor() instanceof IlvSelectInteractor)) {
                    this.a.getManager().deSelectAll(false);
                    this.a.setInteractor(this.j);
                }
            } else {
                if (this.a.getInteractor() instanceof IlvSelectInteractor) {
                    this.a.setInteractor(null);
                }
                this.getDocument().getToplevelGraphic().setObjectInteractor(new IlvSymbolEditorInteractor(this));
            }
        } else {
            this.getEventPanel().trapEvent(bl);
            if (bl) {
                while (this.getManagerView().getInteractor() != null) {
                    this.getManagerView().popInteractor();
                }
            } else {
                this.getDocument().getToplevelGraphic().setObjectInteractor(new IlvSymbolEditorInteractor(this));
            }
        }
    }

    public boolean isSelectMode() {
        if (this.c.a()) {
            return this.a.getInteractor() instanceof IlvSelectInteractor;
        }
        return this.getEventPanel().getGlassPane().isVisible();
    }

    public boolean updateGeometry(IlvGraphic ilvGraphic, boolean bl, IlvPoint ilvPoint) {
        Iterator iterator = this.c.getSelection().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        IlvRule ilvRule = (IlvRule)iterator.next();
        return this.c.getRuleModel().updateGeometry(ilvGraphic, ilvRule, bl, ilvPoint);
    }

    private void a() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IlvTransformer ilvTransformer = IlvSymbolEditorView.this.a.getTransformer();
                ilvTransformer.compose(SymbolEditorUtilities.getRecenterTransformer(IlvSymbolEditorView.this, ilvTransformer));
                IlvSymbolEditorView.this.a.setTransformer(ilvTransformer);
                IlvSymbolEditorView.this.a.repaint();
            }
        });
    }

    public void zoomIn() {
        Dimension dimension = this.getManagerView().getSize();
        this.getManagerView().zoom(new IlvPoint((float)(dimension.getWidth() / 2.0), (float)(dimension.getHeight() / 2.0)), this.f, this.f, true);
    }

    public void zoomOut() {
        Dimension dimension = this.getManagerView().getSize();
        this.getManagerView().zoom(new IlvPoint((float)(dimension.getWidth() / 2.0), (float)(dimension.getHeight() / 2.0)), 1.0 / this.f, 1.0 / this.f, true);
    }

    public void resetZoom() {
        this.getManagerView().setTransformer(SymbolEditorUtilities.getRecenterTransformer(this, null));
        this.repaint();
    }

    public boolean canResetZoom() {
        return !this.getManagerView().getTransformer().equals(SymbolEditorUtilities.getRecenterTransformer(this, null));
    }

    public void fitToContents() {
        this.getManagerView().fitTransformerToContent(new Insets(10, 10, 10, 10));
        this.getManagerView().repaint();
    }

    public boolean isInteractor(IlvManagerViewInteractor ilvManagerViewInteractor) {
        return this.getManagerView().getInteractor() == ilvManagerViewInteractor;
    }

    public void setInteractor(IlvManagerViewInteractor ilvManagerViewInteractor, boolean bl) {
        IlvManagerView ilvManagerView = this.getManagerView();
        if (bl) {
            if (ilvManagerView.getInteractor() != ilvManagerViewInteractor) {
                while (ilvManagerView.getInteractor() != null) {
                    ilvManagerView.popInteractor();
                }
                if (ilvManagerViewInteractor instanceof IlvPermanentInteractorInterface) {
                    ((IlvPermanentInteractorInterface)((Object)ilvManagerViewInteractor)).setPermanent(this.g);
                }
                ilvManagerView.pushInteractor(ilvManagerViewInteractor);
            }
        } else if (ilvManagerView.getInteractor() == ilvManagerViewInteractor) {
            ilvManagerView.popInteractor();
        }
    }

    public void cut() {
        this.getDocument().cut(this.b());
    }

    public void copy() {
        this.getDocument().copy(this.b());
    }

    public void paste() {
        this.getDocument().paste(this.b());
    }

    public boolean canCut() {
        try {
            return this.getDocument().canDelete() && this.b() != null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    public boolean canCopy() {
        return this.getDocument().canCopy() && this.b() != null;
    }

    public boolean canPaste() {
        return this.b() != null && this.getDocument().canPaste(this.b());
    }

    private IlvSymbolEditorDocument.Clipboard b() {
        ComponentContext componentContext = ComponentContextManager.getSingleton().getContext(this);
        if (componentContext != null) {
            IlvSymbolEditorDocument.Clipboard clipboard = (IlvSymbolEditorDocument.Clipboard)componentContext.getProperty(e);
            if (clipboard == null) {
                clipboard = new IlvSymbolEditorDocument.Clipboard();
                componentContext.setProperty(e, clipboard);
            }
            return clipboard;
        }
        return null;
    }

    public void addShape() {
        IlvGraphic ilvGraphic = SymbolEditorUtilities.chooseShape(this);
        if (ilvGraphic != null) {
            IlvGraphic ilvGraphic2 = ilvGraphic.copy();
            ilvGraphic2.setName(ilvGraphic.getName());
            this.getDocument().addGraphic(ilvGraphic2, false, this.a(ilvGraphic2));
        }
    }

    public void addDecoration() {
        IlvGraphic ilvGraphic = SymbolEditorUtilities.chooseDecoration(this);
        if (ilvGraphic != null) {
            IlvGraphic ilvGraphic2 = ilvGraphic.copy();
            ilvGraphic2.setName(ilvGraphic.getName());
            this.getDocument().addGraphic(ilvGraphic2, false, this.a(ilvGraphic2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeShape() {
        IlvGraphic ilvGraphic;
        IlvGraphic ilvGraphic2 = SymbolEditorUtilities.chooseShape(this);
        if (ilvGraphic2 != null && (ilvGraphic = SymbolEditorUtilities.translateGraphic(ilvGraphic2, false)) instanceof IlvGeneralPath) {
            List list = this.getDocument().getSelection();
            IlvSymbolRuleModel ilvSymbolRuleModel = this.getDocument().getRuleModel();
            try {
                ilvSymbolRuleModel.setAdjusting(true);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Object e2 = list.get(i2);
                    if (!(e2 instanceof IlvRule)) continue;
                    IlvGeneralPath ilvGeneralPath = (IlvGeneralPath)this.getDocument().getRuleModel().getGraphicFromRule((IlvRule)e2);
                    GeneralPath generalPath = new GeneralPath(((IlvGeneralPath)ilvGraphic).getShape());
                    IlvRect ilvRect = SymbolEditorUtilities.getAttachmentBounds(ilvGeneralPath);
                    boolean bl = ilvGeneralPath.isTransformedShapeMode();
                    ilvGeneralPath.setTransformedShapeMode(false);
                    ilvGeneralPath.setShape(generalPath);
                    ilvGeneralPath.setShapeBounds(ilvRect);
                    boolean bl2 = ilvGeneralPath.isPointEditionAllowed();
                    ilvGeneralPath.setPointEditionAllowed(true);
                    ilvSymbolRuleModel.updateGeometry(ilvGeneralPath, (IlvRule)e2, false, null);
                    ilvGeneralPath.setPointEditionAllowed(bl2);
                    ilvGeneralPath.setTransformedShapeMode(bl);
                }
            }
            finally {
                ilvSymbolRuleModel.setAdjusting(false);
            }
        }
    }

    public boolean canChangeShape() {
        List list = this.getDocument().getSelection();
        boolean bl = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (e2 instanceof IlvRule) {
                IlvGraphic ilvGraphic = this.getDocument().getRuleModel().getGraphicFromRule((IlvRule)e2);
                if (!(ilvGraphic instanceof IlvGeneralPath)) {
                    return false;
                }
            } else {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public void addImage() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ilog.views.symbology.editor.symboleditor");
        File file = this.c();
        if (file != null) {
            try {
                IlvGraphic ilvGraphic = this.a(file);
                String string = this.b(file) ? "Bitmap" : (this.c(file) ? "SVG" : (this.e(file) ? "DXF" : "IVL"));
                if ((this.c(file) || this.d(file)) && !l) {
                    final JCheckBox jCheckBox = new JCheckBox(resourceBundle.getString("SymbolEditor.AddImage.AddingVectorGraphics.DontShowThisAgain"));
                    jCheckBox.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent itemEvent) {
                            l = jCheckBox.isSelected();
                        }
                    });
                    JOptionPane.showMessageDialog(this, new Object[]{resourceBundle.getString("SymbolEditor.AddImage.AddingVectorGraphics.Message"), jCheckBox}, resourceBundle.getString("SymbolEditor.AddImage.AddingVectorGraphics.Title"), 1);
                }
                this.getDocument().addObject(ilvGraphic, string, this.a(ilvGraphic));
            }
            catch (Exception exception) {
                String string = MessageFormat.format(resourceBundle.getString("SymbolEditor.AddImage.CannotLoadImage.Format"), file);
                IlvSwingUtil.showErrorDialog(this, string, exception);
            }
        }
    }

    private IlvGraphic a(File file) throws InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, MalformedURLException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        IlvGraphic ilvGraphic = null;
        if (this.b(file)) {
            IlvIcon ilvIcon = new IlvIcon();
            ilvIcon.setImageLocation(file.toURL().toExternalForm());
            ilvGraphic = ilvIcon;
        } else if (this.c(file) || this.d(file) || this.e(file)) {
            Class<?> clazz = Class.forName("ilog.views.sdm.graphic.IlvURLGraphic");
            ilvGraphic = (IlvGraphic)clazz.newInstance();
            clazz.getMethod("setURL", String.class).invoke((Object)ilvGraphic, file.toURL().toExternalForm());
        } else {
            throw new RuntimeException("Unexpected file type: " + file);
        }
        return ilvGraphic;
    }

    private File c() {
        Object object;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ilog.views.symbology.editor.symboleditor");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(resourceBundle.getString("SymbolEditor.AddImage.FileChooser.Title"));
        if (m == null) {
            m = new MyFileFilter(new String[]{".png", ".jpg", ".jpeg", ".gif"}, resourceBundle.getString("SymbolEditor.AddImage.FileChooser.BitmapFilesDescription"));
            n = new MyFileFilter(new String[]{".svg", ".svgz"}, resourceBundle.getString("SymbolEditor.AddImage.FileChooser.SVGFilesDescription"));
            o = new MyFileFilter(new String[]{".ivl"}, resourceBundle.getString("SymbolEditor.AddImage.FileChooser.IVLFilesDescription"));
            p = new MyFileFilter(new String[]{".dxf"}, resourceBundle.getString("SymbolEditor.AddImage.FileChooser.DXFFilesDescription"));
        }
        jFileChooser.addChoosableFileFilter(m);
        try {
            Class.forName("ilog.views.sdm.graphic.IlvURLGraphic");
            jFileChooser.addChoosableFileFilter(n);
            jFileChooser.addChoosableFileFilter(o);
            jFileChooser.addChoosableFileFilter(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object2 = null;
        if (lastImageFileChooserFilter != null) {
            object = jFileChooser.getChoosableFileFilters();
            for (int i2 = 0; i2 < ((FileFilter[])object).length; ++i2) {
                if (!(object[i2] instanceof MyFileFilter)) continue;
                for (int i3 = 0; i3 < ((MyFileFilter)object[i2]).a.length; ++i3) {
                    if (!((MyFileFilter)object[i2]).a[i3].equals(lastImageFileChooserFilter)) continue;
                    object2 = object[i2];
                    break;
                }
                if (object2 != null) break;
            }
        }
        if (object2 == null) {
            object2 = m;
        }
        jFileChooser.setFileFilter((FileFilter)object2);
        if (lastImageFileChooserDirectory != null) {
            jFileChooser.setCurrentDirectory(new File(lastImageFileChooserDirectory));
        }
        object = new IlvJManagerViewPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(100, super.getPreferredSize().height);
            }
        };
        ((IlvJManagerViewPanel)object).getManagerView().setKeepingAspectRatio(true);
        ((IlvJManagerViewPanel)object).getManagerView().setMaxZoomXFactor(1.0);
        ((IlvJManagerViewPanel)object).getManagerView().setMaxZoomYFactor(1.0);
        ((JComponent)object).setBorder(BorderFactory.createBevelBorder(1));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = new JLabel(resourceBundle.getString("SymbolEditor.AddImage.FileChooser.Preview"));
        jLabel.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel, "First");
        jPanel.add((Component)object, "Center");
        jFileChooser.setAccessory(jPanel);
        jFileChooser.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener((IlvJManagerViewPanel)object, jFileChooser){
            private final /* synthetic */ IlvJManagerViewPanel a;
            private final /* synthetic */ JFileChooser b;
            {
                this.a = ilvJManagerViewPanel;
                this.b = jFileChooser;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.a.getManagerView().getManager().deleteAll(false);
                try {
                    IlvGraphic ilvGraphic = IlvSymbolEditorView.this.a(this.b.getSelectedFile());
                    this.a.getManagerView().getManager().addObject(ilvGraphic, false);
                    this.a.getManagerView().fitTransformerToContent(new Insets(5, 5, 5, 5));
                }
                catch (Exception exception) {
                }
                finally {
                    this.a.getManagerView().repaint();
                }
            }
        });
        if (jFileChooser.showOpenDialog(this) == 0) {
            lastImageFileChooserDirectory = jFileChooser.getCurrentDirectory().getPath();
            lastImageFileChooserFilter = jFileChooser.getFileFilter() instanceof MyFileFilter ? ((MyFileFilter)jFileChooser.getFileFilter()).a[0] : null;
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private boolean b(File file) {
        return m.accept(file);
    }

    private boolean c(File file) {
        return n.accept(file);
    }

    private boolean d(File file) {
        return o.accept(file);
    }

    private boolean e(File file) {
        return p.accept(file);
    }

    private IlvRect a(IlvGraphic ilvGraphic) {
        int n2 = this.getManagerView().getWidth();
        int n3 = this.getManagerView().getHeight();
        IlvRect ilvRect = ilvGraphic.boundingBox();
        IlvPoint ilvPoint = new IlvPoint(((float)n2 - ilvRect.width) / 2.0f, ((float)n3 - ilvRect.height) / 2.0f);
        IlvTransformer ilvTransformer = this.getManagerView().getTransformer();
        ilvTransformer.inverse(ilvPoint);
        return new IlvRect(ilvPoint.x, ilvPoint.y, 0.0f, 0.0f);
    }

    public void viewCSS() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        IlvRule[] ilvRuleArray = this.getDocument().getRuleModel().getAllRules(true);
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            ilvRuleArray[i2].printCSS(printWriter, null);
        }
        printWriter.flush();
        String string = stringWriter.toString();
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setRows(20);
        jTextArea.setColumns(70);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ilog.views.symbology.editor.symboleditor");
        JOptionPane.showMessageDialog(this, jScrollPane, resourceBundle.getString("SymbolEditor.ViewCSS.Title"), -1);
    }

    public void reparent() {
        final IlvSymbolTree ilvSymbolTree = new IlvSymbolTree(true);
        ilvSymbolTree.setDocument(this.c);
        ilvSymbolTree.clearSelection();
        final IlvRule[] ilvRuleArray = new IlvRule[1];
        ilvSymbolTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                IlvGraphic ilvGraphic;
                IlvRule ilvRule = ilvSymbolTree.getSelectedParentRule();
                if (!(ilvRule == null || (ilvGraphic = IlvSymbolEditorView.this.getDocument().getRuleModel().getGraphicFromRule(ilvRule)) instanceof IlvCompositeGraphic && IlvSymbolEditorView.this.getDocument().canReparent(ilvRule))) {
                    ilvRule = null;
                }
                ilvRuleArray[0] = ilvRule;
                ilvSymbolTree.getRootPane().getDefaultButton().setEnabled(ilvRule != null);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(ilvSymbolTree);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ilog.views.symbology.editor.symboleditor");
        if (SymbolEditorUtilities.showDialog(this, resourceBundle.getString("SymbolEditor.Reparent.Title"), jScrollPane, false) && ilvRuleArray[0] != null) {
            this.getDocument().reparent(ilvRuleArray[0]);
        }
    }

    public boolean canReparent() {
        return this.c.canReparent(null);
    }

    private IlvGrid d() {
        if (this.i == null) {
            this.i = new IlvGrid();
        }
        return this.i;
    }

    public boolean isGridVisible() {
        return this.getManagerView().getGrid() != null;
    }

    public void setGridVisible(boolean bl) {
        IlvManagerView ilvManagerView = this.getManagerView();
        ilvManagerView.setGrid(bl ? this.d() : null);
        ilvManagerView.repaint();
    }

    public void changeGridSpacing() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ilog.views.symbology.editor.symboleditor");
        float f2 = this.d().getHorizontalSpacing();
        Object object = JOptionPane.showInputDialog(this.getManagerView(), resourceBundle.getString("SymbolEditor.GridSpacing.Message"), resourceBundle.getString("SymbolEditor.GridSpacing.Title"), -1, null, null, String.valueOf(f2));
        if (object instanceof String) {
            try {
                f2 = Float.parseFloat((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                f2 = 0.0f;
            }
            if (f2 > 0.0f) {
                this.d().setHorizontalSpacing(f2);
                this.d().setVerticalSpacing(f2);
                this.getManagerView().invalidateTripleBuffer(true);
            } else {
                String string = MessageFormat.format(resourceBundle.getString("SymbolEditor.GridSpacing.InvalidSpacing"), object);
                IlvSwingUtil.showErrorDialog(this, string, null);
            }
        }
    }

    private class SymbolDropTargetListener
    implements DropTargetListener {
        private SymbolDropTargetListener() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                if (dataFlavorArray[i2] != IlvPaletteObjectTransferable.PALETTE_OBJECT_FLAVOR) continue;
                return;
            }
            dropTargetDragEvent.rejectDrag();
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            IlvPaletteSymbol ilvPaletteSymbol = this.a(dropTargetDropEvent.getTransferable());
            if (ilvPaletteSymbol != null) {
                IlvPoint ilvPoint = new IlvPoint(dropTargetDropEvent.getLocation().x, dropTargetDropEvent.getLocation().y);
                IlvTransformer ilvTransformer = IlvSymbolEditorView.this.getManagerView().getTransformer();
                ilvTransformer.inverse(ilvPoint);
                IlvSymbolEditorView.this.getDocument().addSymbol(ilvPaletteSymbol, ilvPoint);
            }
        }

        private IlvPaletteSymbol a(Transferable transferable) {
            if (transferable != null) {
                try {
                    IlvPaletteDragAndDropData ilvPaletteDragAndDropData = (IlvPaletteDragAndDropData)transferable.getTransferData(IlvPaletteObjectTransferable.PALETTE_OBJECT_FLAVOR);
                    if (ilvPaletteDragAndDropData.getPaletteObject() instanceof IlvPaletteSymbol) {
                        return (IlvPaletteSymbol)ilvPaletteDragAndDropData.getPaletteObject();
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class MyFileFilter
    extends FileFilter {
        private String[] a;
        private String b;

        MyFileFilter(String[] stringArray, String string) {
            this.a = stringArray;
            this.b = string;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                if (!file.getName().endsWith(this.a[i2])) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.b;
        }
    }

    private class RuleSelectionListener
    implements SelectionChangedListener {
        private RuleSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            if (IlvSymbolEditorView.this.d) {
                return;
            }
            try {
                IlvSymbolEditorView.this.d = true;
                IlvSymbolEditorDocument ilvSymbolEditorDocument = selectionChangedEvent.getDocument();
                IlvSymbolEventPanel ilvSymbolEventPanel = IlvSymbolEditorView.this.getEventPanel();
                ilvSymbolEventPanel.getSelectionManager().clear();
                List list = ilvSymbolEditorDocument.getSelection();
                if (list != null) {
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        Object e2 = list.get(i2);
                        if (!(e2 instanceof IlvRule)) continue;
                        ilvSymbolEditorDocument.applyChangesIfNecessary();
                        IlvGraphic ilvGraphic = ilvSymbolEditorDocument.getRuleModel().getGraphicFromRule((IlvRule)e2);
                        ilvSymbolEventPanel.select(ilvGraphic, false, true);
                    }
                }
                ilvSymbolEventPanel.repaint();
            }
            finally {
                IlvSymbolEditorView.this.d = false;
            }
        }
    }

    private class SymbolEventPanelSelectionListener
    implements SelectionListener {
        private SymbolEventPanelSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectionChanged(SelectionEvent selectionEvent) {
            if (IlvSymbolEditorView.this.d) {
                return;
            }
            try {
                IlvSymbolEditorView.this.d = true;
                IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorView.this.getDocument().getRuleModel();
                ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
                Iterator iterator = IlvSymbolEditorView.this.getEventPanel().getSelectionManager().getSelectableIterator();
                while (iterator.hasNext()) {
                    IlvSelectable ilvSelectable = (IlvSelectable)iterator.next();
                    IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic(((IlvSymbolGraphicSelectable)ilvSelectable).getGraphic());
                    if (ilvRule == null) continue;
                    arrayList.add(ilvRule);
                }
                IlvSymbolEditorView.this.getDocument().setSelection(arrayList);
            }
            finally {
                IlvSymbolEditorView.this.d = false;
            }
        }
    }

    private class RunModeListener
    implements ManagerSelectionListener,
    ManagerContentChangedListener {
        private RunModeListener() {
        }

        public void selectionChanged(ManagerSelectionChangedEvent managerSelectionChangedEvent) {
            IlvSymbolEditorView.this.c.setSelected(IlvSymbolEditorView.this.a.getManager().isSelected(IlvSymbolEditorView.this.c.getToplevelGraphic()));
        }

        public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
            if (IlvSymbolEditorView.this.c.a() && managerContentChangedEvent.getType() == 4 && (IlvSymbolEditorView.this.isSelectMode() || IlvSymbolEditorView.this.a.getInteractor() instanceof IlvSelectInteractorMoveSelection)) {
                IlvRect ilvRect = ((ObjectBBoxChangedEvent)managerContentChangedEvent).getOldBoundingBox();
                IlvRect ilvRect2 = ((ObjectBBoxChangedEvent)managerContentChangedEvent).getNewBoundingBox();
                if (!ilvRect2.equals(ilvRect)) {
                    IlvSymbolEditorView.this.c.updateBBox();
                    IlvRect ilvRect3 = new IlvRect(ilvRect2);
                    IlvSymbolEditorView.this.a.getTransformer().apply(ilvRect3);
                    IlvSymbolEditorView.this.a.ensureVisible(ilvRect3);
                }
            }
        }
    }
}

