/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.palettes.swing;

import ilog.views.event.IlvListenerList;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteBaseObject;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.event.PaletteViewerEvent;
import ilog.views.symbology.palettes.event.PaletteViewerListener;
import ilog.views.symbology.palettes.swing.IlvPaletteDragAndDropData;
import ilog.views.symbology.palettes.swing.IlvPaletteObjectTransferable;
import ilog.views.symbology.palettes.swing.IlvPaletteTreeCellRenderer;
import ilog.views.symbology.palettes.swing.IlvPaletteTreeModel;
import ilog.views.symbology.palettes.swing.IlvPaletteViewer;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class IlvPaletteTreeViewer
implements IlvPaletteViewer {
    private IlvListenerList a = null;
    private IlvPalette b = null;
    private IlvPaletteTreeModel c = null;
    private IlvPaletteTree d = new IlvPaletteTree(this);
    private boolean e = false;

    public IlvPaletteTreeViewer() {
        IlvPaletteTreeCellRenderer ilvPaletteTreeCellRenderer = new IlvPaletteTreeCellRenderer();
        this.d.setCellRenderer(ilvPaletteTreeCellRenderer);
        this.d.setRowHeight(24);
        new TreeDragSource(this, 3);
        new TreeDropTarget(this);
    }

    public void setPalette(IlvPalette ilvPalette) {
        if (ilvPalette == null) {
            this.d.setModel(null);
            return;
        }
        this.b = ilvPalette;
        this.c = new IlvPaletteTreeModel(ilvPalette);
        this.d.setModel(this.c);
    }

    public IlvPalette getPalette() {
        return this.b;
    }

    public JComponent getComponent() {
        return this.d;
    }

    public void addPaletteViewerListener(PaletteViewerListener paletteViewerListener) {
        if (this.a == null) {
            this.a = new IlvListenerList();
        }
        this.a.add(paletteViewerListener);
    }

    public void removePaletteViewerListener(PaletteViewerListener paletteViewerListener) {
        if (this.a != null) {
            this.a.remove(paletteViewerListener);
            if (this.a.getListenerCount() == 0) {
                this.a = null;
            }
        }
    }

    protected void fireCategorySelected(IlvPalette ilvPalette, IlvPaletteCategory ilvPaletteCategory) {
        if (this.a == null) {
            return;
        }
        Object[] objectArray = this.a.getListenerList();
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        PaletteViewerEvent paletteViewerEvent = new PaletteViewerEvent(this, ilvPalette, ilvPaletteCategory, null);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            PaletteViewerListener paletteViewerListener = (PaletteViewerListener)objectArray[i2];
            paletteViewerListener.categorySelected(paletteViewerEvent);
        }
    }

    protected void fireSymbolSelected(IlvPalette ilvPalette, IlvPaletteSymbol ilvPaletteSymbol) {
        if (this.a == null) {
            return;
        }
        Object[] objectArray = this.a.getListenerList();
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        PaletteViewerEvent paletteViewerEvent = new PaletteViewerEvent(this, ilvPalette, null, ilvPaletteSymbol);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            PaletteViewerListener paletteViewerListener = (PaletteViewerListener)objectArray[i2];
            paletteViewerListener.symbolSelected(paletteViewerEvent);
        }
    }

    public void setEditable(boolean bl) {
        this.e = bl;
    }

    public boolean isEditable() {
        return this.e;
    }

    public void select(IlvPaletteObject ilvPaletteObject) {
        TreePath treePath;
        if (ilvPaletteObject == null) {
            return;
        }
        if (ilvPaletteObject.getPalette() != this.getPalette()) {
            this.setPalette(ilvPaletteObject.getPalette());
        }
        if ((treePath = this.c.a(ilvPaletteObject)) != null) {
            this.d.setExpandsSelectedPaths(true);
            this.d.addSelectionPath(treePath);
            this.d.scrollPathToVisible(treePath);
        }
    }

    public IlvPaletteObject[] getSelectedPaletteObjects() {
        IlvPaletteObject[] ilvPaletteObjectArray = null;
        TreePath[] treePathArray = this.d.getSelectionPaths();
        if (treePathArray != null) {
            ilvPaletteObjectArray = new IlvPaletteObject[treePathArray.length];
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                ilvPaletteObjectArray[i2] = (IlvPaletteObject)treePathArray[i2].getLastPathComponent();
            }
        }
        return ilvPaletteObjectArray;
    }

    class TreeDropTarget
    implements DropTargetListener {
        private IlvPaletteViewer a = null;

        public TreeDropTarget(IlvPaletteViewer ilvPaletteViewer) {
            this.a = ilvPaletteViewer;
            new DropTarget(ilvPaletteViewer.getComponent(), this);
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.a.isEditable()) {
                return;
            }
            Point point = dropTargetDragEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
            if (treePath != null) {
                Object object = treePath.getLastPathComponent();
                if (!this.a.getPalette().isCategory(object)) {
                    object = null;
                }
                ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(object);
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (!this.a.isEditable()) {
                return;
            }
            Point point = dropTargetDropEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
            Object object = treePath.getLastPathComponent();
            if (jTree.getModel().isLeaf(object)) {
                dropTargetDropEvent.rejectDrop();
                ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                return;
            }
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                    if (!transferable.isDataFlavorSupported(dataFlavorArray[i2])) continue;
                    IlvPaletteDragAndDropData ilvPaletteDragAndDropData = (IlvPaletteDragAndDropData)transferable.getTransferData(dataFlavorArray[i2]);
                    IlvPaletteObject ilvPaletteObject = ilvPaletteDragAndDropData.getPaletteObject();
                    TreePath treePath2 = ((IlvPaletteTreeModel)jTree.getModel()).a(ilvPaletteObject);
                    if (!jTree.getModel().isLeaf(object) && treePath2.isDescendant(treePath)) {
                        dropTargetDropEvent.rejectDrop();
                        ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                        return;
                    }
                    if (treePath2.getParentPath().equals(treePath)) {
                        dropTargetDropEvent.rejectDrop();
                        ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                        return;
                    }
                    if (dropTargetDropEvent.getDropAction() == 1) {
                        if (ilvPaletteDragAndDropData.getPaletteViewer().getPalette() != this.a.getPalette()) {
                            dropTargetDropEvent.acceptDrop(1);
                            IlvPaletteObject ilvPaletteObject2 = ilvPaletteObject.copy();
                            IlvPaletteCategory ilvPaletteCategory = IlvPaletteTreeViewer.this.getPalette().getRoot();
                            ilvPaletteCategory.add(ilvPaletteObject2);
                        } else {
                            ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                            dropTargetDropEvent.rejectDrop();
                        }
                    } else {
                        dropTargetDropEvent.acceptDrop(2);
                        IlvPaletteCategory ilvPaletteCategory = ilvPaletteObject.getParent();
                        IlvPaletteCategory ilvPaletteCategory2 = (IlvPaletteCategory)object;
                        if (ilvPaletteCategory != null) {
                            ilvPaletteCategory.remove(ilvPaletteObject);
                        }
                        if (ilvPaletteCategory2 != null) {
                            ilvPaletteCategory2.add(ilvPaletteObject);
                        }
                    }
                    ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
                dropTargetDropEvent.rejectDrop();
                ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
            }
            catch (Exception exception) {
                dropTargetDropEvent.rejectDrop();
                ((IlvPaletteTree)this.a.getComponent()).setDropCandidat(null);
            }
        }
    }

    static class TreeDragSource
    implements DragSourceListener,
    DragGestureListener {
        DragSource a;
        Transferable b;
        Object c;
        IlvPaletteTreeViewer d;
        JTree e;

        public TreeDragSource(IlvPaletteTreeViewer ilvPaletteTreeViewer, int n2) {
            this.d = ilvPaletteTreeViewer;
            this.e = (JTree)ilvPaletteTreeViewer.getComponent();
            this.a = DragSource.getDefaultDragSource();
            this.a.createDefaultDragGestureRecognizer(this.e, n2, this);
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            TreePath treePath = this.e.getSelectionPath();
            if (treePath == null || treePath.getPathCount() <= 1) {
                return;
            }
            this.c = treePath.getLastPathComponent();
            if (this.c.equals(this.e.getModel().getRoot())) {
                return;
            }
            if (this.c instanceof IlvPaletteObject) {
                this.b = new IlvPaletteObjectTransferable((IlvPaletteObject)this.c, this.d);
            }
            Cursor cursor = this.a(dragGestureEvent.getDragAction());
            dragGestureEvent.startDrag(cursor, this.b, this);
        }

        private Cursor a(int n2) {
            return n2 == 1 ? DragSource.DefaultCopyDrop : DragSource.DefaultMoveDrop;
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
            Cursor cursor = this.a(dragSourceDragEvent.getUserAction());
            dragSourceContext.setCursor(cursor);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }
    }

    static class IlvPaletteTree
    extends JTree
    implements TreeSelectionListener {
        private Object a = null;
        private IlvPaletteTreeViewer b = null;

        public IlvPaletteTree(IlvPaletteTreeViewer ilvPaletteTreeViewer) {
            this.b = ilvPaletteTreeViewer;
            this.addTreeSelectionListener(this);
            DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
            defaultTreeSelectionModel.setSelectionMode(4);
            this.setSelectionModel(defaultTreeSelectionModel);
        }

        public Object getDropCandidat() {
            return this.a;
        }

        public void setDropCandidat(Object object) {
            this.a = object;
            this.repaint();
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object = this.getLastSelectedPathComponent();
            if (object instanceof IlvPaletteCategory) {
                this.b.fireCategorySelected(this.b.getPalette(), (IlvPaletteCategory)object);
            } else if (object instanceof IlvPaletteSymbol) {
                this.b.fireSymbolSelected(this.b.getPalette(), (IlvPaletteSymbol)object);
            }
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
            if (object instanceof IlvPaletteBaseObject) {
                return ((IlvPaletteBaseObject)object).getName();
            }
            return super.convertValueToText(object, bl, bl2, bl3, n2, bl4);
        }
    }
}

