/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections;

import java.io.Serializable;

public class IlvDoubleArrayList
implements Cloneable,
Serializable {
    private static double[] a = new double[0];
    private double[] b;
    private int c;

    public IlvDoubleArrayList() {
        this.b = new double[10];
        this.c = 0;
    }

    public IlvDoubleArrayList(int n2) {
        this.b = new double[n2];
        this.c = 0;
    }

    public IlvDoubleArrayList(double[] dArray) {
        int n2 = dArray.length;
        n2 += n2 / 4;
        this.b = new double[n2];
        this.c = dArray.length;
        System.arraycopy(dArray, 0, this.b, 0, this.c);
    }

    public int size() {
        return this.c;
    }

    public boolean isEmpty() {
        return this.c == 0;
    }

    public double get(int n2) {
        if (n2 < this.c) {
            return this.b[n2];
        }
        throw new IndexOutOfBoundsException("index " + n2 + " too large for size " + this.c);
    }

    public double set(int n2, double d2) {
        if (n2 < this.c) {
            double d3 = this.b[n2];
            this.b[n2] = d2;
            return d3;
        }
        throw new IndexOutOfBoundsException("index " + n2 + " too large for size " + this.c);
    }

    public void copyInto(double[] dArray) {
        if (this.c > 0) {
            System.arraycopy(this.b, 0, dArray, 0, this.c);
        }
    }

    public double[] toArray() {
        if (this.c > 0) {
            double[] dArray = new double[this.c];
            System.arraycopy(this.b, 0, dArray, 0, this.c);
            return dArray;
        }
        return a;
    }

    public void add(double d2) {
        this.ensureCapacity(this.c + 1);
        this.b[this.c] = d2;
        ++this.c;
    }

    public void add(int n2, double d2) {
        if (n2 < 0 && n2 > this.c) {
            throw new IndexOutOfBoundsException("index " + n2 + " inappropriate for size " + this.c);
        }
        this.ensureCapacity(this.c + 1);
        if (n2 < this.c) {
            System.arraycopy(this.b, n2, this.b, n2 + 1, this.c - n2);
        }
        this.b[n2] = d2;
        ++this.c;
    }

    public double remove(int n2) {
        if (n2 < 0 && n2 >= this.c) {
            throw new IndexOutOfBoundsException("index " + n2 + " inappropriate for size " + this.c);
        }
        double d2 = this.b[n2];
        if (n2 + 1 < this.c) {
            System.arraycopy(this.b, n2 + 1, this.b, n2, this.c - n2 - 1);
        }
        --this.c;
        return d2;
    }

    public void removeRange(int n2, int n3) {
        if (n2 < 0 || n3 > this.c || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        if (n4 > 0) {
            if (n3 < this.c) {
                System.arraycopy(this.b, n3, this.b, n2, this.c - n3);
            }
            this.c -= n4;
        }
    }

    public void clear() {
        this.c = 0;
    }

    public void trimToSize() {
        if (this.b.length > this.c) {
            if (this.c > 0) {
                double[] dArray = new double[this.c];
                System.arraycopy(this.b, 0, dArray, 0, this.c);
                this.b = dArray;
            } else {
                this.b = a;
            }
        }
    }

    public void ensureCapacity(int n2) {
        if (n2 > this.b.length) {
            int n3 = this.b.length;
            if ((n3 += n3 / 4) < n2) {
                n3 = n2;
            }
            double[] dArray = new double[n3];
            System.arraycopy(this.b, 0, dArray, 0, this.c);
            this.b = dArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.b[i2]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof IlvDoubleArrayList) {
            IlvDoubleArrayList ilvDoubleArrayList = (IlvDoubleArrayList)object;
            if (this.c != ilvDoubleArrayList.c) {
                return false;
            }
            int n2 = this.c;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Double.doubleToRawLongBits(this.b[i2]) == Double.doubleToRawLongBits(ilvDoubleArrayList.b[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        long l2 = this.c + 1;
        for (int i2 = 0; i2 < this.c; ++i2) {
            l2 = 31L * l2 + Double.doubleToRawLongBits(this.b[i2]);
        }
        return (int)(l2 ^ l2 >>> 32);
    }

    public Object clone() {
        try {
            IlvDoubleArrayList ilvDoubleArrayList = (IlvDoubleArrayList)super.clone();
            ilvDoubleArrayList.b = this.toArray();
            return ilvDoubleArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

