/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.psheet;

import ilog.views.util.psheet.CustomPropertyEditor;
import ilog.views.util.psheet.IlvMultipleSelectionPropertyDescriptor;
import ilog.views.util.psheet.IlvPropertyDescriptor;
import ilog.views.util.psheet.IlvPropertySheet;
import ilog.views.util.swing.SwingFactories;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

class PropertyCellEditor
extends ComponentAdapter
implements TableCellEditor,
ActionListener {
    private IlvPropertySheet a;
    protected EventListenerList listenerList = new EventListenerList();
    protected JComponent editorComponent;
    private JComboBox b;
    private JTextField c;
    private JTextArea d;
    private CustomPropertyEditor e;
    protected ChangeEvent changeEvent = null;

    PropertyCellEditor(IlvPropertySheet ilvPropertySheet) {
        this.a = ilvPropertySheet;
    }

    public void cancelCellEditing() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.stopCellEditing();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.a.getTable().removeEditor();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    public Object getCellEditorValue() {
        if (this.editorComponent instanceof JTextField) {
            return ((JTextField)this.editorComponent).getText();
        }
        if (this.editorComponent instanceof JComboBox) {
            return ((JComboBox)this.editorComponent).getSelectedItem().toString();
        }
        if (this.editorComponent instanceof JScrollPane) {
            return this.d.getText();
        }
        return ((CustomPropertyEditor)this.editorComponent).getValue();
    }

    public boolean startCellEditing(EventObject eventObject) {
        if (this.editorComponent instanceof JComboBox) {
            return eventObject instanceof AWTEvent;
        }
        if (this.editorComponent instanceof JTextField || this.editorComponent instanceof JScrollPane) {
            this.editorComponent.requestFocus();
        }
        return true;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() >= 1;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        boolean bl = true;
        if (this.isCellEditable(eventObject) && (eventObject == null || ((MouseEvent)eventObject).getClickCount() >= 1)) {
            bl = this.startCellEditing(eventObject);
        }
        return bl;
    }

    public boolean stopCellEditing() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (f == null ? PropertyCellEditor.class$("javax.swing.event.CellEditorListener") : f)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i2 + 1]).editingStopped(this.changeEvent);
        }
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        PropertyEditor propertyEditor = this.a.getEditors()[n2];
        if (propertyEditor.supportsCustomEditor()) {
            if (this.e == null) {
                this.e = new CustomPropertyEditor(SwingFactories.getFrame(jTable), this.a.getResourceBundle());
            }
            this.e.setEditor(propertyEditor);
            IlvPropertyDescriptor ilvPropertyDescriptor = this.a.getPropertyDescriptors()[n2];
            if (ilvPropertyDescriptor instanceof IlvMultipleSelectionPropertyDescriptor) {
                try {
                    this.e.a(!((IlvMultipleSelectionPropertyDescriptor)ilvPropertyDescriptor).sameValues(this.a.getTarget()));
                }
                catch (Exception exception) {
                    this.e.a(false);
                }
            }
            this.e.a().addPropertyChangeListener(this.a.s);
            this.e.a().addComponentListener(this);
            this.editorComponent = this.e;
        } else if (propertyEditor.getTags() != null) {
            if (this.b == null) {
                this.b = new JComboBox();
                this.b.setBorder(null);
                this.b.setFont(jTable.getFont());
                this.b.addActionListener(this);
            }
            this.editorComponent = this.b;
            String[] stringArray = propertyEditor.getTags();
            if (this.b.getItemCount() > 0) {
                this.b.removeAllItems();
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.b.addItem(stringArray[i2]);
            }
            this.b.setSelectedItem(this.a(propertyEditor));
        } else {
            String string = this.a(propertyEditor);
            if (string.indexOf(10) == -1) {
                if (this.c == null) {
                    this.c = new JTextField(){

                        protected void processComponentKeyEvent(KeyEvent keyEvent) {
                            if (keyEvent.getID() == 401 && (keyEvent.getKeyChar() == 'F' || keyEvent.getKeyChar() == 'Z' || keyEvent.getKeyChar() == 'U' || keyEvent.getKeyChar() == 'I')) {
                                keyEvent.consume();
                            }
                            super.processComponentKeyEvent(keyEvent);
                        }
                    };
                    this.c.setBorder(null);
                    this.c.setFont(jTable.getFont());
                    this.c.addActionListener(this);
                }
                this.c.setText(this.a(propertyEditor));
                this.editorComponent = this.c;
            } else {
                if (this.d == null) {
                    this.d = new JTextArea(){

                        protected void processComponentKeyEvent(KeyEvent keyEvent) {
                            if (keyEvent.getID() == 401 && (keyEvent.getKeyChar() == 'F' || keyEvent.getKeyChar() == 'Z' || keyEvent.getKeyChar() == 'U' || keyEvent.getKeyChar() == 'I')) {
                                keyEvent.consume();
                            }
                            super.processComponentKeyEvent(keyEvent);
                        }
                    };
                    JScrollPane jScrollPane = new JScrollPane(this.d, 21, 31);
                    this.d.setBorder(null);
                    this.d.setFont(jTable.getFont());
                }
                this.d.setText(this.a(propertyEditor));
                this.editorComponent = (JComponent)this.d.getParent().getParent();
            }
        }
        this.editorComponent.setForeground(jTable.getForeground());
        this.editorComponent.setBackground(jTable.getBackground());
        jTable.setRowSelectionInterval(n2, n2);
        return this.editorComponent;
    }

    private String a(PropertyEditor propertyEditor) {
        try {
            return propertyEditor.getAsText();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

