/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.servlet.tiling;

import ilog.views.util.servlet.tiling.IlvTileUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class IlvDefaultFileTileCache {
    private long a;
    private long b;
    private TreeSet c;
    private long d;

    public IlvDefaultFileTileCache() {
        this(0x500000L, 0x100000L);
    }

    public IlvDefaultFileTileCache(long l2, long l3) {
        this.a = l2;
        this.b = 0L;
        this.d = l3;
        FileComparator fileComparator = new FileComparator();
        this.c = new TreeSet(fileComparator);
    }

    public synchronized void objectAdded(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            this.c.add(object);
            this.b += file.length();
            IlvTileUtil.trace("Added to cache " + IlvTileUtil.print(file) + " : Size increased to " + this.b);
            if (this.b > this.a) {
                Iterator iterator = this.c.iterator();
                while (iterator.hasNext()) {
                    file = (File)iterator.next();
                    IlvTileUtil.trace("Remove from cache " + IlvTileUtil.print(file));
                    iterator.remove();
                    IlvTileUtil.trace("Attempt to delete file " + file, true);
                    long l2 = file.length();
                    if (file.delete()) {
                        this.b -= l2;
                        IlvTileUtil.trace(" deleted ok -> size decreased to " + this.b);
                    } else {
                        IlvTileUtil.trace(" delete failed");
                    }
                    if (this.b > this.a - this.d) continue;
                    IlvTileUtil.trace("Cleaning done. Size decreased to " + this.b);
                    break;
                }
            }
        }
    }

    public synchronized void objectAccessed(Object object) {
        if (object instanceof File) {
            boolean bl = this.c.remove(object);
            File file = (File)object;
            file.setLastModified(System.currentTimeMillis());
            IlvTileUtil.trace("Object accessed " + IlvTileUtil.print(file));
            if (bl) {
                this.c.add(object);
            } else {
                IlvTileUtil.trace("Accessed object *not* in cache ! " + IlvTileUtil.print(file));
                this.objectAdded(object);
            }
        }
    }

    public synchronized void stats() {
        IlvTileUtil.trace("Number of files " + this.c.size());
        IlvTileUtil.trace("Size of files / maximum Size " + this.b + " / " + this.a);
        IlvTileUtil.trace("Cache cleaned to " + this.d + " if size >= " + this.a);
    }

    public synchronized void clear() {
        IlvTileUtil.trace("Clearing cache");
        Iterator iterator = this.c.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            iterator.remove();
            IlvTileUtil.trace("Attempt to delete file " + IlvTileUtil.print(file), true);
            long l2 = file.length();
            if (file.delete()) {
                this.b -= l2;
                IlvTileUtil.trace(" deleted ok -> size decreased to " + this.b);
                continue;
            }
            IlvTileUtil.trace(" delete failed");
        }
    }

    public long getCurrentSize() {
        return this.b;
    }

    static class FileComparator
    implements Comparator,
    Serializable {
        FileComparator() {
        }

        public int compare(Object object, Object object2) {
            long l2;
            File file = (File)object;
            File file2 = (File)object2;
            long l3 = file.lastModified();
            if (l3 == (l2 = file2.lastModified())) {
                IlvTileUtil.trace("Same lastModified for " + IlvTileUtil.print(file) + " and " + IlvTileUtil.print(file2), true);
                int n2 = file.compareTo(file2);
                IlvTileUtil.trace(" -> " + n2);
                return n2;
            }
            if (l3 < l2) {
                return -1;
            }
            return 1;
        }
    }
}

