/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.context;

import ilog.views.util.IlvImageUtil;
import ilog.views.util.swing.IlvSwingUtil;
import ilog.views.util.swing.context.ComponentContext;
import ilog.views.util.swing.context.ComponentContextEvent;
import ilog.views.util.swing.context.ComponentContextListener;
import ilog.views.util.swing.context.ComponentContextManager;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalLookAndFeel;

public abstract class ComponentAction
extends AbstractAction {
    private static ResourceBundle a;
    ResourceBundle b;
    String c;
    private boolean d;
    private boolean e;
    private Handler f;
    private static ArrayList g;
    private static List h;
    private static RolloverListener i;
    private static final String j = "Selected";
    private static final int k = 10;
    public static boolean hideToolbarButtonBordersOnOceanTheme;
    private static boolean l;
    private static boolean m;
    private static Border n;
    private static Border o;
    private static int p;
    private WeakHashMap q = new WeakHashMap();
    private static ErrorHandler r;
    private static ArrayList s;
    private static MyComponentContextListener t;

    protected ComponentAction(String string, ResourceBundle resourceBundle) {
        this.setEnabled(false);
        if (a == null) {
            a = ResourceBundle.getBundle("ilog.views.util.swing.context.actions", Locale.getDefault());
        }
        ResourceBundle resourceBundle2 = this.getDefaultResourceBundle();
        this.b = resourceBundle != null ? resourceBundle : resourceBundle2;
        this.c = string;
    }

    protected ComponentAction(String string) {
        this(string, (ResourceBundle)null);
    }

    public Object clone() throws CloneNotSupportedException {
        ComponentAction componentAction = (ComponentAction)super.clone();
        componentAction.changeSupport = null;
        return componentAction;
    }

    protected String getPrefix() {
        return this.c;
    }

    protected ResourceBundle getResourceBundle() {
        return this.b;
    }

    protected ResourceBundle getDefaultResourceBundle() {
        if (a == null) {
            a = ResourceBundle.getBundle("ilog.views.util.swing.context.actions", Locale.getDefault());
        }
        return a;
    }

    protected boolean isSelected() {
        return this.d;
    }

    protected void setSelected(boolean bl) {
        if (bl != this.d) {
            this.d = bl;
            this.firePropertyChange(j, new Boolean(!bl), new Boolean(bl));
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (!this.e) {
            this.init();
            this.e = true;
        }
    }

    private static void b(AbstractButton abstractButton, ComponentAction componentAction) {
        if (!componentAction.isSelectable()) {
            return;
        }
        if (componentAction.q.get(abstractButton) == null) {
            ActionPropertyChangedListener actionPropertyChangedListener = new ActionPropertyChangedListener(abstractButton, componentAction);
            componentAction.q.put(abstractButton, Boolean.TRUE);
            componentAction.addPropertyChangeListener(actionPropertyChangedListener);
            abstractButton.setSelected(componentAction.isSelected());
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        Component component = ComponentContextManager.getSingleton().getCurrentComponent(jComponent, Component.class);
        try {
            ComponentAction.fireActionStarted(this);
            if (this.f != null) {
                this.f.perform(this, component, actionEvent);
            } else {
                this.perform(actionEvent, component);
            }
            ComponentAction.fireActionFinished(this);
            ComponentAction.delayedUpdateActions((JComponent)actionEvent.getSource());
        }
        catch (Exception exception) {
            Throwable throwable;
            ComponentAction.fireActionFinished(this);
            if (exception instanceof SecurityException && "checkPrintJobAccess".equals(exception.getMessage())) {
                return;
            }
            if (exception instanceof InvocationTargetException && (throwable = ((InvocationTargetException)exception).getTargetException()) instanceof SecurityException && "checkPrintJobAccess".equals(throwable.getMessage())) {
                return;
            }
            ComponentAction.error(component, this.b, "ComponentAction.ErrorDuringPerform", new Object[]{this.getValue("Name")}, exception);
        }
    }

    public abstract void perform(ActionEvent var1, Component var2) throws Exception;

    public void call(Component component) {
        Component component2;
        ComponentContext componentContext = ComponentContextManager.getSingleton().getContext(component);
        if (componentContext != null) {
            component2 = componentContext.getTarget();
            componentContext.setTarget(component);
        } else {
            component2 = null;
        }
        ActionEvent actionEvent = new ActionEvent(component, 1001, (String)this.getValue("ActionCommandKey"));
        this.actionPerformed(actionEvent);
        if (componentContext != null) {
            componentContext.setTarget(component2);
        }
    }

    protected abstract boolean isEnabled(Component var1) throws Exception;

    public boolean isSelectable() {
        return false;
    }

    protected boolean isSelected(Component component) throws Exception {
        return false;
    }

    public void init() {
        ComponentAction.a(this, this.b, this.c);
        this.e = true;
    }

    private static void a(Action action, ResourceBundle resourceBundle, String string) {
        ComponentAction.a(action, resourceBundle, string, "Name");
        ComponentAction.a(action, resourceBundle, string, "ShortDescription");
        ComponentAction.a(action, resourceBundle, string, "LongDescription");
        ComponentAction.a(action, resourceBundle, string, "SmallIcon");
        ComponentAction.a(action, resourceBundle, string, "AcceleratorKey");
        ComponentAction.a(action, resourceBundle, string, "MnemonicKey");
        ComponentAction.a(action, resourceBundle, string, "ActionCommandKey");
    }

    private static void a(Action action, ResourceBundle resourceBundle, String string, String string2) {
        block17: {
            try {
                String string3 = ComponentAction.a(resourceBundle, string + "." + string2);
                Object object = string3;
                if (string2 == "SmallIcon") {
                    if (ComponentAction.getSmallIconSize() == 16) {
                        try {
                            string3 = resourceBundle.getString(string + "." + string2 + "16");
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                    }
                    object = null;
                    if (string3 != null) {
                        try {
                            Image image = IlvImageUtil.getImageFromFile(action.getClass(), string3);
                            object = new ImageIcon(image);
                        }
                        catch (IOException iOException) {}
                    }
                } else if (string2 == "AcceleratorKey") {
                    object = null;
                    if (string3 != null && (object = KeyStroke.getKeyStroke(string3)) == null) {
                        System.err.println("Cannot parse accelerator " + string3);
                    }
                } else if (string2 == "MnemonicKey") {
                    object = null;
                    if (string3 != null) {
                        KeyStroke keyStroke = KeyStroke.getKeyStroke(string3);
                        if (keyStroke != null) {
                            object = new Integer(keyStroke.getKeyCode());
                        } else {
                            System.err.println("Cannot parse mnemonic " + string3);
                        }
                    }
                }
                action.putValue(string2, object);
            }
            catch (MissingResourceException missingResourceException) {
                if (string2 != "ActionCommandKey") break block17;
                action.putValue(string2, string);
            }
        }
    }

    public static int getSmallIconSize() {
        return p;
    }

    public static void setSmallIconSize(int n2) {
        p = n2;
    }

    private static String a(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (a != null) {
                return a.getString(string);
            }
            throw missingResourceException;
        }
    }

    protected void update(Component component) {
        try {
            this.setEnabled(this.isEnabled(component));
        }
        catch (Exception exception) {
            this.setEnabled(false);
            throw new RuntimeException("Exception while updating state of action " + this.getValue("Name") + ":\n" + exception);
        }
        try {
            this.setSelected(this.isSelected(component));
        }
        catch (Exception exception) {
            this.setSelected(false);
            throw new RuntimeException("Exception while updating state of action " + this.getValue("Name") + ":\n" + exception);
        }
    }

    public void setHandler(Handler handler) {
        this.f = handler;
    }

    public static void addStatusListener(StatusListener statusListener) {
        if (g == null) {
            g = new ArrayList();
        }
        if (!g.contains(statusListener)) {
            g.add(statusListener);
        }
    }

    public static void removeStatusListener(StatusListener statusListener) {
        if (g != null) {
            g.remove(statusListener);
            if (g.size() == 0) {
                g = null;
            }
        }
    }

    private static void b(Action action) {
        if (g != null) {
            StatusEvent statusEvent = new StatusEvent(action);
            for (int i2 = 0; i2 < g.size(); ++i2) {
                StatusListener statusListener = (StatusListener)g.get(i2);
                statusListener.actionDescribed(statusEvent);
            }
        }
    }

    protected static void fireActionStarted(Action action) {
        if (g != null) {
            StatusEvent statusEvent = new StatusEvent(action);
            for (int i2 = 0; i2 < g.size(); ++i2) {
                StatusListener statusListener = (StatusListener)g.get(i2);
                statusListener.actionStarted(statusEvent);
            }
        }
    }

    protected static void fireActionFinished(Action action) {
        if (g != null) {
            StatusEvent statusEvent = new StatusEvent(action);
            for (int i2 = 0; i2 < g.size(); ++i2) {
                StatusListener statusListener = (StatusListener)g.get(i2);
                statusListener.actionFinished(statusEvent);
            }
        }
    }

    public static ErrorHandler getActionErrorHandler() {
        return r;
    }

    public static void setActionErrorHandler(ErrorHandler errorHandler) {
        r = errorHandler;
    }

    public static void error(Component component, ResourceBundle resourceBundle, String string, Object[] objectArray, Throwable throwable) {
        if (r != null) {
            r.error(component, resourceBundle, string, objectArray, throwable);
        } else {
            ComponentAction.a(component, resourceBundle, string, objectArray, throwable);
        }
    }

    private static void a(Component component, ResourceBundle resourceBundle, String string, Object[] objectArray, Throwable throwable) {
        String string2 = ComponentAction.a(resourceBundle, string);
        if (objectArray != null) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        IlvSwingUtil.showErrorDialog(component, string2, throwable);
    }

    public static AbstractButton createToolBarButton(Action action) {
        AbstractButton abstractButton = action instanceof ComponentAction && ((ComponentAction)action).isSelectable() ? new JToggleButton() : new JButton();
        abstractButton.setAction(action);
        abstractButton.setText(null);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        abstractButton.setFocusPainted(false);
        if (!m) {
            if (UIManager.getLookAndFeel().getName().equals("Metal")) {
                try {
                    Method method = MetalLookAndFeel.class.getMethod("getCurrentTheme", null);
                    Object object = method.invoke(null, null);
                    if (object != null && object.getClass().getName().equals("javax.swing.plaf.metal.OceanTheme")) {
                        l = true;
                        n = BorderFactory.createEmptyBorder(2, 2, 2, 2);
                        o = BorderFactory.createEtchedBorder();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            m = true;
        }
        if (l) {
            abstractButton.setBorder(n);
        }
        abstractButton.addChangeListener(i);
        abstractButton.setMnemonic(0);
        return abstractButton;
    }

    public static JMenuItem createMenuItem(Action action) {
        JMenuItem jMenuItem = action instanceof ComponentAction && ((ComponentAction)action).isSelectable() ? new JCheckBoxMenuItem() : new JMenuItem();
        jMenuItem.setAction(action);
        jMenuItem.setToolTipText(null);
        jMenuItem.addChangeListener(i);
        return jMenuItem;
    }

    protected static void delayedUpdateActions(JComponent jComponent) {
        Component component = ComponentContextManager.getSingleton().getRoot(jComponent);
        if (component != null) {
            Component component2 = ComponentContextManager.getSingleton().getCurrentComponent(component, Component.class);
            for (int i2 = 0; i2 < s.size(); ++i2) {
                UpdateTimer updateTimer = (UpdateTimer)s.get(i2);
                if (updateTimer.getRoot() != component) continue;
                if (component2 != updateTimer.getTarget()) {
                    updateTimer.setTarget(component2);
                }
                return;
            }
            UpdateTimer updateTimer = new UpdateTimer(component2, component);
            updateTimer.setRepeats(false);
            s.add(updateTimer);
            updateTimer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateActions(Component component, final Component component2) {
        ComponentContextManager.getSingleton().traverseHierarchy(component, new ComponentContextManager.Traverser(){

            public void traverse(Component component) {
                Action action;
                if (component instanceof AbstractButton && (action = ((AbstractButton)component).getAction()) instanceof ComponentAction) {
                    Object object;
                    ComponentAction componentAction = (ComponentAction)action;
                    ComponentAction.b((AbstractButton)component, componentAction);
                    ComponentAction.b(componentAction, component2);
                    if (component instanceof JMenuItem && ((JMenuItem)component).getAccelerator() == null && (object = action.getValue("AcceleratorKey")) instanceof KeyStroke) {
                        ((JMenuItem)component).setAccelerator((KeyStroke)object);
                    }
                }
            }
        });
        List list = h;
        synchronized (list) {
            for (int i2 = 0; i2 < h.size(); ++i2) {
                ComponentAction componentAction = (ComponentAction)h.get(i2);
                ComponentAction.b(componentAction, component2);
            }
        }
    }

    private static void b(ComponentAction componentAction, Component component) {
        try {
            if (componentAction.f != null) {
                componentAction.f.update(componentAction, component);
            } else {
                componentAction.update(component);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while updating state of action " + componentAction.getValue("Name") + ":\n" + exception);
        }
    }

    public static void removeActions(Component component) {
        ComponentContextManager.getSingleton().traverseHierarchy(component, new ComponentContextManager.Traverser(){

            public void traverse(Component component) {
                if (component instanceof AbstractButton) {
                    ((AbstractButton)component).setAction(null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addActionToUpdate(ComponentAction componentAction) {
        List list = h;
        synchronized (list) {
            h.add(componentAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeActionToUpdate(ComponentAction componentAction) {
        List list = h;
        synchronized (list) {
            h.remove(componentAction);
        }
    }

    static {
        h = Collections.synchronizedList(new ArrayList());
        i = new RolloverListener();
        hideToolbarButtonBordersOnOceanTheme = true;
        p = 20;
        s = new ArrayList();
        t = new MyComponentContextListener();
        ComponentContextManager.getSingleton().addComponentContextListener(null, t);
    }

    private static class MyComponentContextListener
    implements ComponentContextListener {
        private MyComponentContextListener() {
        }

        public void targetChanged(ComponentContextEvent componentContextEvent) {
            ComponentAction.delayedUpdateActions((JComponent)componentContextEvent.getRoot());
        }
    }

    private static class UpdateTimer
    extends Timer
    implements ActionListener {
        private Component a;
        private Component b;

        public UpdateTimer(Component component, Component component2) {
            super(10, null);
            this.addActionListener(this);
            this.b = component;
            this.a = component2;
        }

        public Component getTarget() {
            return this.b;
        }

        public void setTarget(Component component) {
            this.b = component;
        }

        public Component getRoot() {
            return this.a;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            s.remove(this);
            ComponentAction.updateActions(this.a, this.b);
        }
    }

    private static class RolloverListener
    implements ChangeListener {
        private RolloverListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isArmed() || buttonModel.isRollover()) {
                if (l) {
                    abstractButton.setBorder(o);
                }
                Action action = abstractButton.getAction();
                ComponentAction.b(action);
            } else if (l) {
                abstractButton.setBorder(n);
            }
        }
    }

    public static interface ErrorHandler {
        public void error(Component var1, ResourceBundle var2, String var3, Object[] var4, Throwable var5);
    }

    public static interface StatusListener
    extends EventListener {
        public void actionDescribed(StatusEvent var1);

        public void actionStarted(StatusEvent var1);

        public void actionFinished(StatusEvent var1);
    }

    public static class StatusEvent
    extends EventObject {
        public StatusEvent(Object object) {
            super(object);
        }

        public ComponentAction getComponentAction() {
            return (ComponentAction)this.getSource();
        }
    }

    public static class Handler {
        public void perform(ComponentAction componentAction, Component component, ActionEvent actionEvent) throws Exception {
            componentAction.perform(actionEvent, component);
        }

        public void update(ComponentAction componentAction, Component component) throws Exception {
            componentAction.update(component);
        }
    }

    private static class ActionPropertyChangedListener
    implements PropertyChangeListener {
        private static ReferenceQueue a;
        private WeakReference b;
        private Action c;

        ActionPropertyChangedListener(JComponent jComponent, Action action) {
            this.setTarget(jComponent);
            this.c = action;
        }

        public void setTarget(JComponent jComponent) {
            OwnedWeakReference ownedWeakReference;
            if (a == null) {
                a = new ReferenceQueue();
            }
            while ((ownedWeakReference = (OwnedWeakReference)a.poll()) != null) {
                ActionPropertyChangedListener actionPropertyChangedListener = (ActionPropertyChangedListener)ownedWeakReference.getOwner();
                Action action = actionPropertyChangedListener.getAction();
                if (action == null) continue;
                action.removePropertyChangeListener(actionPropertyChangedListener);
            }
            this.b = new OwnedWeakReference(jComponent, a, this);
        }

        public JComponent getTarget() {
            return (JComponent)this.b.get();
        }

        public Action getAction() {
            return this.c;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JComponent jComponent;
            if (propertyChangeEvent.getSource() instanceof ComponentAction && ComponentAction.j.equals(propertyChangeEvent.getPropertyName()) && (jComponent = this.getTarget()) instanceof AbstractButton) {
                ((AbstractButton)this.getTarget()).setSelected(((ComponentAction)propertyChangeEvent.getSource()).isSelected());
            }
        }

        private static class OwnedWeakReference
        extends WeakReference {
            private Object a;

            OwnedWeakReference(Object object, ReferenceQueue referenceQueue, Object object2) {
                super(object, referenceQueue);
                this.a = object2;
            }

            public Object getOwner() {
                return this.a;
            }
        }
    }
}

