/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.context;

import ilog.views.util.swing.context.ComponentContext;
import ilog.views.util.swing.context.ComponentContextListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JApplet;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ComponentContextManager {
    private static ComponentContextManager a;
    private HashMap b = new HashMap();
    private HashMap c = new HashMap();
    private ArrayList d = new ArrayList();
    private ArrayList e = new ArrayList();
    private boolean f = true;
    DesktopPaneContainerListener g = new DesktopPaneContainerListener();
    private MyInternalFrameListener h = new MyInternalFrameListener();
    private TabbedPaneListener i = new TabbedPaneListener();
    private TargetHierarchyListener j = new TargetHierarchyListener();
    private ClientHierarchyListener k = new ClientHierarchyListener();
    private RootHierarchyListener l = new RootHierarchyListener();

    private ComponentContextManager() {
    }

    public boolean isEnabled() {
        return this.f;
    }

    public void setEnabled(boolean bl) {
        this.f = bl;
    }

    public static ComponentContextManager getSingleton() {
        if (a == null) {
            a = new ComponentContextManager();
        }
        return a;
    }

    public void registerTarget(Component component) {
        component.addHierarchyListener(this.j);
    }

    public void unregisterTarget(Component component) {
        component.removeHierarchyListener(this.j);
    }

    public void addComponentContextListener(Component component, ComponentContextListener componentContextListener) {
        if (component == null) {
            if (!this.e.contains(componentContextListener)) {
                this.e.add(componentContextListener);
            }
            Iterator iterator = this.b.keySet().iterator();
            while (iterator.hasNext()) {
                Component component2 = (Component)iterator.next();
                this.addComponentContextListener(component2, componentContextListener);
            }
        } else {
            ComponentContext componentContext = this.getContext(component);
            if (componentContext != null) {
                componentContext.addComponentContextListener(componentContextListener);
            } else {
                ArrayList<ComponentContextListener> arrayList = (ArrayList<ComponentContextListener>)this.c.get(component);
                if (arrayList == null) {
                    arrayList = new ArrayList<ComponentContextListener>();
                    this.c.put(component, arrayList);
                }
                if (!arrayList.contains(componentContextListener)) {
                    arrayList.add(componentContextListener);
                }
                component.addHierarchyListener(this.k);
            }
        }
    }

    public void removeComponentContextListener(Component component, ComponentContextListener componentContextListener) {
        if (component == null) {
            this.e.remove(componentContextListener);
            Iterator iterator = this.b.keySet().iterator();
            while (iterator.hasNext()) {
                Component component2 = (Component)iterator.next();
                this.removeComponentContextListener(component2, componentContextListener);
            }
        } else {
            ComponentContext componentContext = this.getContext(component);
            if (componentContext != null) {
                componentContext.removeComponentContextListener(componentContextListener);
            } else {
                ArrayList arrayList = (ArrayList)this.c.get(component);
                if (arrayList != null) {
                    arrayList.remove(componentContextListener);
                    if (arrayList.size() == 0) {
                        this.c.remove(component);
                    }
                }
            }
        }
    }

    public ComponentContext getContext(Component component) {
        Component component2 = this.getRoot(component);
        if (component2 != null) {
            return this.b(component2);
        }
        return null;
    }

    public Component getCurrentComponent(Component component, Class clazz) {
        ComponentContext componentContext = this.getContext(component);
        if (componentContext != null) {
            Component component2 = componentContext.getTarget();
            if (component2 != null && clazz.isAssignableFrom(component2.getClass())) {
                return component2;
            }
            return null;
        }
        return null;
    }

    public void setCurrentComponent(Component component, Component component2) {
        ComponentContext componentContext = this.getContext(component);
        if (componentContext != null) {
            componentContext.setTarget(component2);
        }
    }

    private boolean a(Component component, boolean bl) {
        return this.b(component) != null || component instanceof JRootPane && component.getParent() instanceof Window && (bl || ((Window)component.getParent()).getOwner() == null) || component instanceof JRootPane && component.getParent() instanceof JApplet;
    }

    public Component getRoot(Component component) {
        return this.b(component, false);
    }

    private Component b(Component component, boolean bl) {
        Component component2 = component;
        while (component2 != null) {
            if (this.a(component2, bl)) {
                return component2;
            }
            if (component2 instanceof JMenuBar) {
                component2 = ((JMenuBar)component2).getRootPane();
                continue;
            }
            if (component2 instanceof JPopupMenu) {
                component2 = ((JPopupMenu)component2).getInvoker();
                continue;
            }
            if (component2 instanceof JApplet) {
                component2 = ((JApplet)component2).getRootPane();
                continue;
            }
            if (component2 instanceof Window) {
                Window window = ((Window)component2).getOwner();
                if (window instanceof JFrame) {
                    component2 = ((JFrame)window).getRootPane();
                    continue;
                }
                if (window instanceof JDialog) {
                    component2 = ((JDialog)window).getRootPane();
                    continue;
                }
                if (window instanceof Frame) {
                    component2 = this.a(window);
                    continue;
                }
                component2 = null;
                continue;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    private JRootPane a(Component component) {
        if (component instanceof JApplet) {
            return ((JApplet)component).getRootPane();
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                Component component2 = componentArray[i2];
                JRootPane jRootPane = this.a(component2);
                if (jRootPane == null) continue;
                return jRootPane;
            }
        }
        return null;
    }

    public void traverseHierarchy(Component component, Traverser traverser) {
        int n2;
        Component[] componentArray;
        traverser.traverse(component);
        if (component instanceof JRootPane && (componentArray = ((JRootPane)component).getJMenuBar()) != null) {
            this.traverseHierarchy((Component)componentArray, traverser);
        }
        if (component instanceof JMenu && (componentArray = ((JMenu)component).getPopupMenu()) != null) {
            this.traverseHierarchy((Component)componentArray, traverser);
        }
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            n2 = componentArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component2 = componentArray[i2];
                if (this.a(component2, false)) continue;
                this.traverseHierarchy(component2, traverser);
            }
        }
        if (component instanceof JRootPane && component.getParent() instanceof Window) {
            componentArray = ((Window)component.getParent()).getOwnedWindows();
            for (n2 = 0; n2 < componentArray.length; ++n2) {
                this.traverseHierarchy(componentArray[n2], traverser);
            }
        }
        if (component instanceof Window) {
            componentArray = ((Window)component).getOwnedWindows();
            for (n2 = 0; n2 < componentArray.length; ++n2) {
                this.traverseHierarchy(componentArray[n2], traverser);
            }
        }
    }

    private ComponentContext b(Component component) {
        return (ComponentContext)this.b.get(component);
    }

    public void setContextForRoot(final Component component, ComponentContext componentContext) {
        this.b.put(component, componentContext);
        for (int i2 = 0; i2 < this.e.size(); ++i2) {
            ComponentContextListener componentContextListener = (ComponentContextListener)this.e.get(i2);
            componentContext.addComponentContextListener(componentContextListener);
        }
        component.addHierarchyListener(this.l);
        this.c(component);
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null) {
            window.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    ComponentContextManager.this.d(component);
                }
            });
        }
    }

    private void c(Component component) {
        this.traverseHierarchy(component, new Traverser(){

            public void traverse(Component component) {
                if (component instanceof JDesktopPane) {
                    JInternalFrame[] jInternalFrameArray = ((JDesktopPane)component).getAllFrames();
                    for (int i2 = 0; i2 < jInternalFrameArray.length; ++i2) {
                        JInternalFrame jInternalFrame = jInternalFrameArray[i2];
                        jInternalFrame.addInternalFrameListener(ComponentContextManager.this.h);
                    }
                    ((JDesktopPane)component).addContainerListener(ComponentContextManager.this.g);
                }
                if (component instanceof JTabbedPane) {
                    ((JTabbedPane)component).addChangeListener(ComponentContextManager.this.i);
                    component.addHierarchyListener(new HierarchyListener(){

                        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                            Component component;
                            Component component2 = ((JTabbedPane)hierarchyEvent.getComponent()).getSelectedComponent();
                            if (component2 != null && (component = ComponentContextManager.this.e(component2)) != null) {
                                ComponentContextManager.this.a(component2, component);
                                hierarchyEvent.getComponent().removeHierarchyListener(this);
                            }
                        }
                    });
                }
            }
        });
    }

    private void a(Component component, final ComponentContext componentContext) {
        this.traverseHierarchy(component, new Traverser(){

            public void traverse(Component component) {
                ArrayList arrayList = (ArrayList)ComponentContextManager.this.c.get(component);
                if (arrayList != null) {
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        ComponentContextListener componentContextListener = (ComponentContextListener)arrayList.get(i2);
                        componentContext.addComponentContextListener(componentContextListener);
                    }
                    arrayList.clear();
                    ComponentContextManager.this.c.remove(component);
                }
            }
        });
    }

    private void d(Component component) {
        Component component2 = this.e(component);
        if (component2 != null) {
            this.a(component, component2);
        }
    }

    private void a(Component component, Component component2) {
        ComponentContext componentContext;
        if (this.f && (componentContext = this.getContext(component)) != null) {
            componentContext.setTarget(component2);
        }
    }

    private Component e(Component component) {
        if (this.d.contains(component)) {
            return component;
        }
        if (component instanceof Container && !(component instanceof JDesktopPane) && !(component instanceof JTabbedPane)) {
            int n2 = ((Container)component).getComponentCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component2 = ((Container)component).getComponent(i2);
                Component component3 = this.e(component2);
                if (component3 == null) continue;
                return component3;
            }
        }
        return null;
    }

    private class RootHierarchyListener
    implements HierarchyListener {
        private RootHierarchyListener() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 2L) != 0L && !hierarchyEvent.getComponent().isDisplayable()) {
                ComponentContextManager.this.b.remove(hierarchyEvent.getComponent());
            }
        }
    }

    private class ClientHierarchyListener
    implements HierarchyListener {
        private ClientHierarchyListener() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            ComponentContext componentContext;
            Component component = ComponentContextManager.this.getRoot(hierarchyEvent.getComponent());
            if (component != null && (componentContext = ComponentContextManager.this.b(component)) != null) {
                ComponentContextManager.this.a(hierarchyEvent.getComponent(), componentContext);
                ComponentContextManager.this.d(component);
            }
        }
    }

    private class TargetHierarchyListener
    implements HierarchyListener {
        private TargetHierarchyListener() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Component component;
            if ((hierarchyEvent.getChangeFlags() & 2L) != 0L) {
                if (hierarchyEvent.getComponent().isDisplayable()) {
                    if (!ComponentContextManager.this.d.contains(hierarchyEvent.getComponent())) {
                        ComponentContextManager.this.d.add(hierarchyEvent.getComponent());
                    }
                } else {
                    ComponentContextManager.this.d.remove(hierarchyEvent.getComponent());
                }
            }
            if ((component = ComponentContextManager.this.b(hierarchyEvent.getComponent(), true)) != null) {
                ComponentContext componentContext = ComponentContextManager.this.b(component);
                if (componentContext == null) {
                    componentContext = new ComponentContext(component);
                    ComponentContextManager.this.setContextForRoot(component, componentContext);
                    ComponentContextManager.this.a(component, componentContext);
                } else {
                    ComponentContextManager.this.d(component);
                }
            }
        }
    }

    private class TabbedPaneListener
    implements ChangeListener {
        private TabbedPaneListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            Component component = jTabbedPane.getSelectedComponent();
            if (component != null) {
                ComponentContextManager.this.d(component);
            } else {
                ComponentContextManager.this.a((Component)jTabbedPane, null);
            }
        }
    }

    private class MyInternalFrameListener
    extends InternalFrameAdapter {
        private MyInternalFrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            ComponentContextManager.this.d(internalFrameEvent.getInternalFrame());
        }
    }

    private class DesktopPaneContainerListener
    implements ContainerListener {
        private DesktopPaneContainerListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JInternalFrame) {
                ((JInternalFrame)containerEvent.getChild()).addInternalFrameListener(ComponentContextManager.this.h);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JInternalFrame && ((JInternalFrame)containerEvent.getChild()).isClosed()) {
                ((JInternalFrame)containerEvent.getChild()).removeInternalFrameListener(ComponentContextManager.this.h);
                if (ComponentContextManager.this.d.size() == 0) {
                    ComponentContextManager.this.a((Component)containerEvent.getContainer(), null);
                }
            }
        }
    }

    public static interface Traverser {
        public void traverse(Component var1);
    }
}

