/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

public class Range {
    public static final long INDEX_FIRST = 0L;
    public static final long INDEX_LAST = -1L;
    public static final long SIZE_MAX = -1L;
    private volatile long index;
    private volatile long size;

    public Range() {
        this(0L, -1L);
    }

    public Range(long size) {
        this(0L, size);
    }

    public Range(long index, long size) {
        this.index = index;
        this.size = size;
    }

    public boolean equals(Object object) {
        return object instanceof Range && ((Range)object).getIndex() == this.getIndex() && ((Range)object).getSize() == this.getSize();
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isIncluded(long position, long totalSize) {
        boolean result = false;
        if (this.getIndex() == -1L) {
            boolean bl = result = 0L <= position && position < totalSize;
            if (result) {
                result = position >= totalSize - this.getSize();
            }
        } else {
            boolean bl = result = position >= this.getIndex();
            if (result && this.getSize() != -1L) {
                result = position < this.getIndex() + this.getSize();
            }
        }
        return result;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public void setSize(long size) {
        this.size = size;
    }
}

