/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.dmdb.dialogs.security;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.portland.lib.util.CommonRoleExtUtil;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class InsertCommonRoleExt
extends InsertForm
implements ItemListener {
    protected static final int NAME = 0;
    protected static final int DESCRIP = 1;
    protected static final int VSAN_SCOPE_TEXT = 2;
    protected static final int VSAN_ENABLE = 3;
    protected static final int VSAN_SCOPE = 4;
    protected static final int VLAN_SCOPE_TEXT = 5;
    protected static final int VLAN_ENABLE = 6;
    protected static final int VLAN_SCOPE = 7;
    protected static final int INTFACE_SCOPE_TEXT = 8;
    protected static final int INTFACE_ENABLE = 9;
    protected static final int INTFACE_SCOPE = 10;
    protected static final int[] ccreRowStatus = MibNode.get((String)"ccreRoleRowStatus").getOid();
    protected static final int[] ccreRoleDesc = MibNode.get((String)"ccreRoleDescription").getOid();
    protected static final int[] ccreRoleResourceAccess = MibNode.get((String)"ccreRoleResourceAccess").getOid();
    MdsPortChooser interfaces;

    public InsertCommonRoleExt(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    protected void build() {
        super.build();
        this.setEnabled(4, false);
        this.setEnabled(7, false);
        this.setEnabled(10, false);
        this.setComponentVisibleAt(5, false);
        this.setComponentVisibleAt(6, false);
        this.setComponentVisibleAt(7, false);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        switch (index) {
            case 3: 
            case 6: 
            case 9: {
                JCheckBox comp = new JCheckBox("Enable");
                comp.addItemListener(this);
                return comp;
            }
            case 4: 
            case 7: {
                return new KTextField(0);
            }
            case 10: {
                this.interfaces = new MdsPortChooser(Discover.getDeviceName(), 3, false, (IfIndexIf)Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{1}), this.getPeer(), 18);
                return this.interfaces;
            }
        }
        JComponent comp = super.buildComponent(mibVar, mibNode, index);
        return comp;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected;
        boolean bl = isSelected = e.getStateChange() == 1;
        if (e.getSource() == this._values[3]) {
            this.setEnabled(4, isSelected);
        } else if (e.getSource() == this._values[6]) {
            this.setEnabled(7, isSelected);
        } else if (e.getSource() == this._values[9]) {
            this.setEnabled(10, isSelected);
        }
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index > 1) {
            return null;
        }
        return super.getComponentValue(index);
    }

    protected SnmpVar[] getInsertValue() throws Exception {
        if (((JTextField)this._values[0]).getText().equals("")) {
            throw new SnmpException("RoleName cannot be blank");
        }
        return super.getInsertValue();
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        VarBindList vbl = this.buildInsertVarbind(index);
        SnmpPDU pdu = new SnmpPDU(-93, vbl);
        this.tableInsert(pdu, index);
        pdu = new SnmpPDU(-93, new VarBindList());
        this.addScopes(pdu, index);
        this.tableInsert(pdu, index);
        this._table.setCFSPending(this.getPeer());
    }

    protected VarBindList buildInsertVarbind(int[] index) {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(ccreRowStatus, index), (SnmpVar)new SnmpInt(this.getTableInsertValue())));
        vbl.add(new SnmpVarBind(new SnmpOID(ccreRoleDesc, index), (SnmpVar)new SnmpString(this.getComponentText(1))));
        vbl.add(new SnmpVarBind(new SnmpOID(ccreRoleResourceAccess, index), (SnmpVar)this.getUpdatedPolicyString()));
        return vbl;
    }

    private SnmpString getUpdatedPolicyString() {
        byte[] b = new byte[1];
        if (!((JCheckBox)this._values[3]).isSelected()) {
            SnmpString.setBitBase0((byte[])b, (int)0);
        }
        if (!((JCheckBox)this._values[6]).isSelected()) {
            SnmpString.setBitBase0((byte[])b, (int)1);
        }
        if (!((JCheckBox)this._values[9]).isSelected()) {
            SnmpString.setBitBase0((byte[])b, (int)2);
        }
        return new SnmpString(b);
    }

    private void addScopes(SnmpPDU pdu, int[] index) throws Exception {
        int[] lRoleNameIndex = index;
        int[] lScopes = new int[]{4, 7, 10};
        int lCount = 1;
        for (int lScope : lScopes) {
            if (!this._values[lScope].isEnabled()) continue;
            String str = null;
            if (this._values[lScope] instanceof JTextField) {
                str = ((JTextField)this._values[lScope]).getText();
            } else if (this._values[lScope] instanceof MdsPortChooser) {
                str = ((MdsPortChooser)this._values[lScope]).getText();
            }
            if (str == null || str.length() == 0) continue;
            int[] lValues = this.getScopesToBeInserted(str, lScope);
            int rest = this.getRestrictionToBeInserted(lScope);
            if (lValues == null) continue;
            for (int value : lValues) {
                SnmpOID insertIndex = new SnmpOID(lRoleNameIndex, lCount);
                CommonRoleExtUtil.getInstance().createNewScope(pdu, insertIndex.getValue(), new SnmpInt(rest), new SnmpInt(value));
                ++lCount;
            }
        }
    }

    private int[] getScopesToBeInserted(Object o, int col) throws Exception {
        int[] lScopeValues = null;
        if (col == 4 || col == 7) {
            Array ids = StringUtil.tokenize((String)o.toString(), (String)",", (String)"-", (int)10, (boolean)true, (int)1, (int)4096, (boolean)true);
            lScopeValues = new int[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                lScopeValues[i] = (Integer)ids.elementAt(i);
            }
        } else if (col == 10) {
            SnmpIntList intList = new SnmpIntList(o.toString().trim(), (IfIndexIf)Discover.getRoot());
            lScopeValues = SnmpIntList.valueOf((byte[])intList.getValue());
        }
        return lScopeValues;
    }

    private int getRestrictionToBeInserted(int col) {
        switch (col) {
            case 4: {
                return 1;
            }
            case 7: {
                return 2;
            }
            case 10: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Scope Restriction not defined for col" + col);
    }

    protected void insert() throws Exception {
        if (JOptionPane.showConfirmDialog((Component)this.getParent(), "You must add rule 'permit read' to this role to make it effective.  Continue ?", this._parent.getTitle(), 0) != 0) {
            return;
        }
        super.insert();
    }

    public void dispose() {
        if (this.interfaces != null) {
            this.interfaces.dismiss();
        }
        super.dispose();
    }
}

