/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;

public final class SnmpReportException
extends SnmpException {
    static final int[] _SnmpMPDStats = new int[]{1, 3, 6, 1, 6, 3, 11, 2, 1};
    static final int[] _UsmStats = new int[]{1, 3, 6, 1, 6, 3, 15, 1, 1};

    public SnmpReportException(String s) {
        super(s);
    }

    public static String toError(int[] oid) {
        return SnmpException._ErrTypes[SnmpReportException.getError(oid)];
    }

    public static int getError(int[] oid) {
        if (SnmpOID.startsWith(oid, _SnmpMPDStats)) {
            switch (oid[oid.length - 2]) {
                case 1: {
                    return 22;
                }
                case 2: {
                    return 23;
                }
            }
        } else if (SnmpOID.startsWith(oid, _UsmStats)) {
            switch (oid[oid.length - 2]) {
                case 1: {
                    return 24;
                }
                case 2: {
                    return 25;
                }
                case 3: {
                    return 26;
                }
                case 4: {
                    return 27;
                }
                case 5: {
                    return 28;
                }
                case 6: {
                    return 29;
                }
            }
        }
        return 5;
    }

    public static String getError(SnmpPDU pdu) {
        if (pdu.getErrorIndex() > 0) {
            int[] oid = pdu.getVariables().getVb(pdu.getErrorIndex() - 1).getOid().getValue();
            return MibNode.oidToName(oid) + ": " + SnmpException.toError(pdu.getError());
        }
        return SnmpException.toError(pdu.getError());
    }
}

