/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.PacketFilterIf;
import com.cisco.dcbu.lib.snmp.SnmpCounter;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInputStream;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpTrapListenerIf;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.channel.Channel;
import com.cisco.dcbu.lib.util.channel.ChannelImpl;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class SnmpTrapSession
extends Thread {
    public static final int TRAP_PORT = 1162;
    public static final String TRAP_V3_USER = "TrapUserV3";
    static int[] _UsmStatsUnknownEngineIDs = new int[]{1, 3, 6, 1, 6, 3, 15, 1, 1, 4, 0};
    static final int BUF_SIZE = 2000;
    static final int MAX_QSIZE = 1000;
    static int _NTraps;
    static int _NTossedTraps;
    private DatagramSocket _sock;
    private byte[] _responseBuf = new byte[2000];
    private ArrayList<SnmpTrapListenerIf> _trapListeners;
    private ChannelImpl<SnmpPDU> _trapChannel;
    private PacketFilterIf _filter;
    private boolean _enabled = true;
    static Logger _Log;

    public SnmpTrapSession() {
        super("SnmpTrapSession");
    }

    public SnmpTrapSession(ThreadGroup tg) {
        super(tg, "SnmpTrapSession");
    }

    public synchronized void addTrapListener(SnmpTrapListenerIf trapListener) {
        if (this._trapListeners == null) {
            this._trapListeners = new ArrayList();
        }
        this._trapListeners.add(trapListener);
    }

    public synchronized void removeTrapListener(SnmpTrapListenerIf trapListener) {
        if (this._trapListeners != null) {
            this._trapListeners.remove(trapListener);
        }
    }

    public Channel getTrapChannel() {
        if (this._trapChannel == null) {
            this._trapChannel = new ChannelImpl("TrapChannel");
            this._trapChannel.setLogger(_Log);
            if (this._sock != null) {
                this.initChannel();
            }
        }
        return this._trapChannel;
    }

    public synchronized void setTrapFilter(PacketFilterIf filter) {
        this._filter = filter;
    }

    public static String getStatsInfo() {
        return "Traps Rx: " + _NTraps + " (" + _NTossedTraps + " ignored)";
    }

    private void initChannel() {
        Thread t = new Thread((Runnable)this._trapChannel);
        t.setPriority(5);
        t.start();
    }

    private void rebind(int localPort, InetAddress localAddr) throws SocketException {
        DatagramSocket sockToClose = this._sock;
        this._sock = new DatagramSocket(localPort, localAddr);
        this._sock.setReceiveBufferSize(Integer.parseInt(System.getProperty("snmp.udp.recvbuf", "65536")));
        sockToClose.close();
    }

    public void open(InetAddress localAddr, int localPort) throws IOException {
        this._sock = new DatagramSocket(localPort, localAddr);
        this._sock.setReceiveBufferSize(Integer.parseInt(System.getProperty("snmp.udp.recvbuf", "65536")));
        if (!this.isAlive()) {
            this.start();
        }
        if (this._trapChannel != null) {
            this.initChannel();
        }
    }

    public void open(String localHostname, int localPort) throws IOException {
        if (localHostname == null) {
            this.open((InetAddress)null, localPort);
        } else {
            this.open(NetUtil.getLocalAddressByName(localHostname), localPort);
        }
    }

    public void open(int localPort) throws IOException {
        this.open((InetAddress)null, localPort);
    }

    public int getLocalPort() {
        return this._sock != null ? this._sock.getLocalPort() : 0;
    }

    public void setLocalPort(int localPort) throws SocketException {
        if (this._sock != null && this._sock.isBound()) {
            this.rebind(localPort, this._sock.getLocalAddress());
        }
    }

    public InetAddress getLocalAddress() {
        return this._sock != null ? this._sock.getLocalAddress() : null;
    }

    public void setLocalAddress(String localIp) throws UnknownHostException, SocketException {
        if (this._sock != null && this._sock.isBound()) {
            this.rebind(this._sock.getLocalPort(), InetAddress.getByName(localIp));
        }
    }

    public boolean isActive() {
        return this._sock != null && this._sock.isBound() && this.isAlive();
    }

    @Override
    public void run() {
        this.receiver();
    }

    public void close() {
        this._sock.close();
        this._sock = null;
    }

    public synchronized void enableListening(boolean enabled) {
        this._enabled = enabled;
    }

    public synchronized boolean isEnabled() {
        return this._enabled;
    }

    void receiver() {
        DatagramPacket packet = new DatagramPacket(this._responseBuf, this._responseBuf.length);
        while (true) {
            if (this._sock != null) {
                packet.setLength(this._responseBuf.length);
                try {
                    this._sock.receive(packet);
                    if (!this._enabled) continue;
                    this.processPacket(packet);
                }
                catch (Exception ex) {
                    _Log.error((Object)("TrapSession receiver: " + ex));
                }
                continue;
            }
            Thread.yield();
        }
    }

    void processPacket(DatagramPacket packet) {
        if (this._filter != null && !this._filter.validate(packet)) {
            ++_NTossedTraps;
            return;
        }
        SnmpPDU pdu = new SnmpPDU(new VarBindList());
        pdu._timeReceived = System.currentTimeMillis();
        pdu._address = packet.getAddress();
        pdu._port = packet.getPort();
        SnmpPeer peer = SnmpPeer.findPeer(pdu._address);
        if (peer != null) {
            pdu._authProtocol = peer._authProtocol;
            pdu._privKey = peer._privkey;
        }
        try {
            SnmpInputStream is = new SnmpInputStream(packet.getData(), packet.getLength());
            pdu.decode(is);
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)pdu);
            }
            if (this._trapListeners != null && pdu.getCommand() == -96) {
                this.respondToEngine(pdu, true);
                return;
            }
            if (pdu.getCommand() == -90) {
                if (pdu.getVersion() == 3) {
                    this.respondToEngine(pdu, false);
                } else {
                    packet.getData()[pdu._cmdPosition] = -94;
                    this._sock.send(packet);
                }
                pdu._command = (byte)-89;
            }
            if (pdu.getCommand() == -89) {
                if (this._trapChannel != null && this._trapChannel.getSize() >= 1000) {
                    _Log.error((Object)"Trap is tossed due to maximum trap queue size limit.");
                    return;
                }
                ++_NTraps;
                if (this._trapChannel != null) {
                    this._trapChannel.queue((Object)pdu);
                }
                if (this._trapListeners != null) {
                    for (int i = 0; i < this._trapListeners.size(); ++i) {
                        this._trapListeners.get(i).trapReceived(pdu._session, pdu);
                    }
                }
                return;
            }
        }
        catch (Exception ex) {
            _Log.error((Object)("bad packet from " + pdu.getHostAddress() + ", " + pdu._port + ": " + ex.getMessage()));
            return;
        }
    }

    void respondToEngine(SnmpPDU pdu, boolean isDiscovery) throws SnmpException, IOException {
        pdu._command = (byte)-88;
        pdu.setEngineId(SnmpSession.getMyEngineId());
        pdu.setReqid(pdu.getMsgId());
        if (isDiscovery) {
            pdu.addVar(new SnmpOID(_UsmStatsUnknownEngineIDs), new SnmpCounter(1L));
        }
        SnmpOutputStream requestBuf = new SnmpOutputStream(2000);
        pdu.encode(requestBuf);
        DatagramPacket respPacket = new DatagramPacket(requestBuf._buf, requestBuf._pos, pdu._address, pdu._port);
        this._sock.send(respPacket);
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)pdu);
        }
    }

    public static Logger getLogger() {
        return _Log;
    }

    public static boolean isTrace() {
        return _Log.isTraceEnabled();
    }

    public static void setTrace(boolean b) {
        _Log.setLevel(b ? Level.ALL : Level.WARN);
    }

    static {
        _Log = LogManager.getLogger((String)"snmp.trap");
    }
}

