/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.security;

import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.net.InetAddress;

public class Target {
    protected InetAddress _remoteHost;
    protected int _remotePort = 161;
    protected int _retries = SnmpPeer.getClassRetries();
    protected int _timeout = SnmpPeer.getClassTimeout();

    public Target(InetAddress remoteHost, int remotePort) {
        this._remoteHost = remoteHost;
        this._remotePort = remotePort;
    }

    public Target(InetAddress remoteHost) {
        this._remoteHost = remoteHost;
    }

    public InetAddress getAddress() {
        return this._remoteHost;
    }

    public int getPort() {
        return this._remotePort;
    }

    public int getRetries() {
        return this._retries;
    }

    public void setRetries(int retries) {
        this._retries = retries;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public void initPeer(SnmpPeer peer) {
        peer.setAddress(this._remoteHost);
        peer.setPort(this._remotePort);
        peer.setRetries(this._retries);
        peer.setTimeout(this._timeout);
    }

    public SnmpPDU createPDU(int vbsize) {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(vbsize));
        pdu.setAddress(this._remoteHost);
        pdu.setPort(this._remotePort);
        pdu.setRetries(this._retries);
        pdu.setTimeout(this._timeout);
        return pdu;
    }
}

