/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.security;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.util.GenUtil;

public class UsmUser
extends SnmpUser {
    private static final long serialVersionUID = 1L;
    public static final int AUTH_NO = -1;
    public static final int AUTH_MD5 = 0;
    public static final int AUTH_SHA = 1;
    public static final int PRIV_NO = -1;
    public static final int PRIV_DES = 0;
    public static final int PRIV_AES = 1;
    private String _userName;
    private String _authPassword;
    private String _privPassword;
    private int _authProtocol = -1;
    private int _privProtocol = -1;

    public UsmUser(String userName, int authProtocol, String authPassword, int privacyProtocol, String privacyPassword) {
        this._userName = userName;
        this._authProtocol = authProtocol;
        this._authPassword = authPassword;
        this._privProtocol = privacyProtocol;
        this._privPassword = privacyPassword;
    }

    public UsmUser(String userName, int authProtocol, String authPassword) {
        this(userName, authProtocol, authPassword, -1, null);
    }

    @Override
    public int getSecurityModel() {
        return 3;
    }

    public String getUserName() {
        return this._userName;
    }

    public int getAuthProtocol() {
        return this._authProtocol;
    }

    public int getPrivacyProtocol() {
        return this._privProtocol;
    }

    public String getAuthPassword() {
        return this._authPassword;
    }

    public String getPrivacyPassword() {
        return this._privPassword;
    }

    public synchronized void setPrivacy(int privProtocol, String privPassword) {
        this._privProtocol = privProtocol;
        this._privPassword = privPassword;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof UsmUser)) {
            return false;
        }
        UsmUser user = (UsmUser)obj;
        if (user == this) {
            return true;
        }
        return user._userName.equals(this._userName) && GenUtil.equals((Object)user._authPassword, (Object)this._authPassword) && user._authProtocol == this._authProtocol && GenUtil.equals((Object)user._privPassword, (Object)this._privPassword) && user._privProtocol == this._privProtocol;
    }

    @Override
    public SnmpUser cloneUser() {
        return new UsmUser(this._userName, this._authProtocol, this._authPassword, this._privProtocol, this._privPassword);
    }

    @Override
    public synchronized void initPeer(SnmpPeer peer, SnmpSession session) throws SnmpException {
        peer.setCredentials(session, this._userName, this._authPassword, this._authProtocol, this._privPassword, this._privProtocol);
    }

    @Override
    public synchronized void initPeer(SnmpPeer peer, SnmpSession session, boolean usePrefer) throws SnmpException {
        peer.setCredentials(session, this._userName, this._authPassword, this._authProtocol, this._privPassword, this._privProtocol, usePrefer);
    }
}

