/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataReadOnlyException;
import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.column.AbstractColumn;
import java.util.BitSet;

public class BooleanColumn
extends AbstractColumn {
    private BitSet m_bits;
    private int m_size;

    public BooleanColumn() {
        this(0, 10, false);
    }

    public BooleanColumn(int n2) {
        this(n2, n2, false);
    }

    public BooleanColumn(int n2, int n3, boolean bl) {
        super(Boolean.TYPE, new Boolean(bl));
        if (n3 < n2) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_bits = new BitSet(n3);
        this.m_bits.set(0, n3, bl);
        this.m_size = n2;
    }

    public int getRowCount() {
        return this.m_size;
    }

    public void setMaximumRow(int n2) {
        if (n2 > this.m_size) {
            this.m_bits.set(this.m_size, n2, (Boolean)this.m_defaultValue);
        }
        this.m_size = n2;
    }

    public Object get(int n2) {
        return new Boolean(this.getBoolean(n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object object, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Boolean) {
            this.setBoolean((Boolean)object, n2);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n2);
        }
    }

    public boolean getBoolean(int n2) throws DataTypeException {
        if (n2 < 0 || n2 > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        return this.m_bits.get(n2);
    }

    public void setBoolean(boolean bl, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n2 < 0 || n2 >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        boolean bl2 = this.m_bits.get(n2);
        if (bl2 == bl) {
            return;
        }
        this.m_bits.set(n2, bl);
        this.fireColumnEvent(n2, bl2);
    }
}

