/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.LooxUndoableEdit;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxArrowElement;
import com.loox.jloox.LxConstants;
import com.loox.jloox.LxElement;
import com.loox.jloox.Resources;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

class Arrow
implements LxArrowElement,
LxConstants,
Serializable {
    private static final Shape[] NO_ARROWS = new Shape[0];
    private static Shape FILLED_ARROW;
    private static Shape NORMAL_ARROW;
    private static final String TYPE_UNDO = "arrow-typeUndo";
    private LxElement _host;
    private int _type = 0;

    Arrow(LxElement lxElement) {
        this._host = lxElement;
        LxAbstractGraph lxAbstractGraph = this._host.getGraph();
        if (lxAbstractGraph != null) {
            // empty if block
        }
    }

    static Shape[] _getArrows(LxArrowElement lxArrowElement, Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        boolean bl;
        int n = lxArrowElement.getLineArrow();
        if (n == 0) {
            return NO_ARROWS;
        }
        boolean bl2 = bl = (n & 4) != 0;
        if ((n & 1) != 0 && (n & 2) != 0) {
            return new Shape[]{Arrow._getShape(point2D, point2D2, bl), Arrow._getShape(point2D3, point2D4, bl)};
        }
        if ((n & 1) != 0) {
            return new Shape[]{Arrow._getShape(point2D, point2D2, bl)};
        }
        if ((n & 2) != 0) {
            return new Shape[]{Arrow._getShape(point2D3, point2D4, bl)};
        }
        double d = point2D3.getX() + (point2D4.getX() - point2D3.getX()) / 2.0;
        double d2 = point2D3.getY() + (point2D4.getY() - point2D3.getY()) / 2.0;
        return new Shape[]{Arrow._getShape(new Point2D.Double(d, d2), point2D4, bl)};
    }

    private static Shape _getShape(Point2D point2D, Point2D point2D2, boolean bl) {
        Shape shape = bl ? FILLED_ARROW : NORMAL_ARROW;
        double d = Math.atan2(point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(point2D.getX(), point2D.getY());
        affineTransform.rotate(-d);
        return affineTransform.createTransformedShape(shape);
    }

    static void _verifyLineArrow(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 8 && n != 3 && n != 5 && n != 6 && n != 12 && n != 7) {
            throw new IllegalArgumentException("unknown line arrow: " + n);
        }
    }

    private void _setType(int n, boolean bl) {
        int n2 = this._type;
        if (n == n2) {
            return;
        }
        Rectangle2D rectangle2D = this._host.getStrokedBounds2D();
        Arrow._verifyLineArrow(n);
        this._type = n;
        if (bl) {
            this._host.addUndoEdit(new TypeEdit(this, n2));
        }
        this._host.fireComponentMorphed(rectangle2D);
        this._host._firePropertyChanged("arrow", new Integer(n2), new Integer(n));
    }

    public int getLineArrow() {
        return this._type;
    }

    public void setLineArrow(int n) {
        this._setType(n, true);
    }

    static {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(4.0f, -6.0f);
        generalPath.lineTo(-4.0f, -6.0f);
        generalPath.closePath();
        FILLED_ARROW = generalPath;
        generalPath = new GeneralPath(0);
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(4.0f, -6.0f);
        generalPath.lineTo(3.0f, -6.0f);
        generalPath.lineTo(0.0f, -2.0f);
        generalPath.lineTo(-3.0f, -6.0f);
        generalPath.lineTo(-4.0f, -6.0f);
        generalPath.closePath();
        NORMAL_ARROW = generalPath;
    }

    private static final class TypeEdit
    extends LooxUndoableEdit {
        private int _val;

        public TypeEdit(Arrow arrow, int n) {
            super(arrow, Resources.get(Arrow.TYPE_UNDO, "arrow"));
            this._val = n;
        }

        void _undoEdit(boolean bl) {
            Arrow arrow = (Arrow)this._getHost();
            int n = arrow.getLineArrow();
            arrow._setType(this._val, false);
            this._val = n;
        }
    }
}

