/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.Arrow;
import com.loox.jloox.LxAbstractAction;
import com.loox.jloox.LxAbstractReference;
import com.loox.jloox.LxAbstractStyle;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxConstants;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxElement;
import com.loox.jloox.Resources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

public final class Lx
implements LxConstants {
    public static final int BOTTOM_RIGHT_ALIGN = 2;
    public static final int CENTER_ALIGN = 3;
    public static final int NO_ALIGN = 0;
    public static final int SIDE_BY_SIDE_ALIGN = 4;
    public static final int TOP_LEFT_ALIGN = 1;
    public static final int LINE_NORMAL = 0;
    public static final int LINE_DASHED = 1;
    public static final int LINE_DOUBLE_DASHED = 2;
    public static final int LINE_DASH_DOT = 3;
    public static final int LINE_LONG_DASH = 4;
    public static final int LINE_DASH_DOUBLE_DOT = 5;
    public static final int LINE_LINE_TRIPLE_DOT = 6;
    public static final int FILL_EMPTY = 0;
    public static final int FILL_FORE = 1;
    public static final int FILL_BACK = 2;
    public static final int FILL_DITHER25 = 3;
    public static final int FILL_DITHER50 = 4;
    public static final int FILL_DITHER75 = 5;
    public static final int FILL_HATCH1 = 6;
    public static final int FILL_HATCH2 = 7;
    public static final int FILL_HATCH3 = 8;
    public static final int FILL_HATCH4 = 9;
    public static final int FILL_DB_HATCH = 10;
    public static final int FILL_DB_HATCH1 = 11;
    public static final int FILL_DB_GRID = 12;
    public static final int FILL_GRID = 13;
    public static final int FILL_CUSTOM = 14;
    public static final int FILL_GRADIENT = 15;
    private static ActionProcessor _action_processor = null;
    private static boolean _is_inverted = false;
    private static boolean _double_click = true;
    private static double _shadow_thickness = 0.0;
    private static int _line_arrow = 0;
    private static LxAbstractStyle _style = null;
    private static WeakHashMap _images = new WeakHashMap();
    private static int _lastPopupX = 0;
    private static int _lastPopupY = 0;
    private static boolean _useXORForSelection = true;
    static Vector _imageConverters = new Vector();
    private static String _encoding = "UTF8";
    private static Font _defaultFont = new Font("Arial", 0, 12);
    private static final float[][] DASHES = new float[][]{null, {2.0f, 2.0f}, {4.0f, 4.0f}, {12.0f, 4.0f}, {12.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f}, {4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 16.0f}, {12.0f, 4.0f, 4.0f, 4.0f}};
    private static final Image[] PATTERN_IMAGES = new Image[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final String[] PATTERN_NAMES = new String[]{null, "black.gif", "white.gif", "gray0.gif", "gray1.gif", "gray2.gif", "hatch0.gif", "hatch1.gif", "hatch2.gif", "hatch3.gif", "hatch4.gif", "hatch5.gif", "hatch6.gif", "hatch7.gif", null, null};
    private static ArrayList _search_urls = new ArrayList();
    private static final JColorKey _jcolor_key = new JColorKey();
    private static final Hashtable _jcolor_hash = new Hashtable();
    private static final PaintKey _paint_key = new PaintKey();
    private static final Hashtable _paint_hash = new Hashtable();
    private static final ColorKey _color_key = new ColorKey();
    private static final Hashtable _color_hash = new Hashtable();
    private static boolean _styleListenerActivated = true;

    private Lx() {
    }

    public static void alignComponents(LxComponent[] lxComponentArray, int n, double d, int n2, double d2, boolean bl) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = lxComponentArray.length;
        int n4 = 0;
        if (n3 <= 1) {
            return;
        }
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = ((LxComponent)object).getCenterX();
                if (d2 == (d = ((LxComponent)object2).getCenterX())) {
                    return 0;
                }
                if (d2 > d) {
                    return 1;
                }
                return -1;
            }
        };
        Comparator comparator2 = new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = ((LxComponent)object).getCenterY();
                if (d2 == (d = ((LxComponent)object2).getCenterY())) {
                    return 0;
                }
                if (d2 > d) {
                    return 1;
                }
                return -1;
            }
        };
        switch (n) {
            case 3: {
                n4 = 0;
                while (n4 < n3) {
                    d3 += lxComponentArray[n4].getCenterX();
                    ++n4;
                }
                d3 /= (double)n3;
                if (bl && d != 0.0) {
                    Arrays.sort(lxComponentArray, comparator2);
                }
                n4 = 0;
                while (n4 < n3) {
                    lxComponentArray[n4].setCenterX(d3 + (double)n4 * d);
                    ++n4;
                }
                break;
            }
            case 1: {
                d3 = lxComponentArray[0].getX();
                n4 = 1;
                while (n4 < n3) {
                    d5 = lxComponentArray[n4].getX();
                    if (d5 < d3) {
                        d3 = d5;
                    }
                    ++n4;
                }
                if (bl && d != 0.0) {
                    Arrays.sort(lxComponentArray, comparator2);
                }
                n4 = 0;
                while (n4 < n3) {
                    lxComponentArray[n4].setX(d3 + (double)n4 * d);
                    ++n4;
                }
                break;
            }
            case 2: {
                d3 = lxComponentArray[0].getX() + lxComponentArray[0].getWidth();
                n4 = 1;
                while (n4 < n3) {
                    d5 = lxComponentArray[n4].getX() + lxComponentArray[n4].getWidth();
                    if (d5 > d3) {
                        d3 = d5;
                    }
                    ++n4;
                }
                if (bl && d != 0.0) {
                    Arrays.sort(lxComponentArray, comparator2);
                }
                n4 = 0;
                while (n4 < n3) {
                    lxComponentArray[n4].setX(d3 + (double)n4 * d - lxComponentArray[n4].getWidth());
                    ++n4;
                }
                break;
            }
            case 4: {
                if (bl) {
                    Arrays.sort(lxComponentArray, comparator);
                }
                d3 = lxComponentArray[0].getX() + lxComponentArray[0].getWidth() + d;
                n4 = 1;
                while (n4 < n3) {
                    lxComponentArray[n4].setX(d3);
                    d3 += lxComponentArray[n4].getWidth() + d;
                    ++n4;
                }
                break;
            }
        }
        switch (n2) {
            case 3: {
                n4 = 0;
                while (n4 < n3) {
                    d4 += lxComponentArray[n4].getCenterY();
                    ++n4;
                }
                d4 /= (double)n3;
                if (bl && d2 != 0.0) {
                    Arrays.sort(lxComponentArray, comparator);
                }
                n4 = 0;
                while (n4 < n3) {
                    lxComponentArray[n4].setCenterY(d4 + (double)n4 * d2);
                    ++n4;
                }
                break;
            }
            case 1: {
                d4 = lxComponentArray[0].getY();
                n4 = 1;
                while (n4 < n3) {
                    d5 = lxComponentArray[n4].getY();
                    if (d5 < d4) {
                        d4 = d5;
                    }
                    ++n4;
                }
                if (bl && d2 != 0.0) {
                    Arrays.sort(lxComponentArray, comparator);
                }
                n4 = 0;
                while (n4 < n3) {
                    lxComponentArray[n4].setY(d4 + (double)n4 * d2);
                    ++n4;
                }
                break;
            }
            case 2: {
                d4 = lxComponentArray[0].getY() + lxComponentArray[0].getHeight();
                n4 = 1;
                while (n4 < n3) {
                    d5 = lxComponentArray[n4].getY() + lxComponentArray[n4].getHeight();
                    if (d5 > d4) {
                        d4 = d5;
                    }
                    ++n4;
                }
                if (bl && d2 != 0.0) {
                    Arrays.sort(lxComponentArray, comparator);
                }
                n4 = 0;
                while (n4 < n3) {
                    lxComponentArray[n4].setY(d4 + (double)n4 * d2 - lxComponentArray[n4].getHeight());
                    ++n4;
                }
                break;
            }
            case 4: {
                if (bl) {
                    Arrays.sort(lxComponentArray, comparator2);
                }
                d4 = lxComponentArray[0].getY() + lxComponentArray[0].getHeight() + d2;
                n4 = 1;
                while (n4 < n3) {
                    lxComponentArray[n4].setY(d4);
                    d4 += lxComponentArray[n4].getHeight() + d2;
                    ++n4;
                }
                break;
            }
        }
    }

    public static ActionProcessor getActionProcessor() {
        return _action_processor;
    }

    static Color _getColor(int n, int n2, int n3) {
        return Lx._getColor(n, n2, n3, 255);
    }

    static Color _getColor(int n, int n2, int n3, int n4) {
        _color_key.set(n, n2, n3, n4);
        Color color = (Color)_color_hash.get(_color_key);
        if (color != null) {
            return color;
        }
        color = new Color(n, n2, n3, n4);
        _color_hash.put(_color_key.clone(), color);
        return color;
    }

    public static boolean getDefaultDoubleClickActionActive() {
        return _double_click;
    }

    public static int getDefaultLineArrow() {
        return _line_arrow;
    }

    public static double getDefaultShadowThickness() {
        return _shadow_thickness;
    }

    public static boolean getDefaultShadowInversion() {
        return _is_inverted;
    }

    public static LxAbstractStyle getDefaultStyle() {
        return _style;
    }

    public static int getFillPattern(Paint paint) {
        if (paint == null) {
            return 0;
        }
        if (paint instanceof Color) {
            if (paint instanceof JLooxColor) {
                return ((JLooxColor)paint)._fill_pattern;
            }
            return 2;
        }
        if (paint instanceof GradientPaint || paint instanceof JLooxRadialGradientPaint) {
            return 15;
        }
        if (paint instanceof TexturePaint) {
            if (paint instanceof JLooxTexturePaint) {
                return ((JLooxTexturePaint)paint)._fill_pattern;
            }
            return 0;
        }
        return 0;
    }

    public static Color getFillForegroundColor(Paint paint) {
        if (paint == null) {
            return null;
        }
        if (paint instanceof JLooxTexturePaint) {
            return ((JLooxTexturePaint)paint)._fg;
        }
        if (paint instanceof JLooxGradientPaint) {
            return ((JLooxGradientPaint)paint).getColor2();
        }
        if (paint instanceof JLooxRadialGradientPaint) {
            return ((JLooxRadialGradientPaint)paint)._info._line_color;
        }
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return null;
    }

    public static Color getFillBackgroundColor(Paint paint) {
        if (paint == null) {
            return null;
        }
        if (paint instanceof JLooxTexturePaint) {
            return ((JLooxTexturePaint)paint)._bg;
        }
        if (paint instanceof JLooxGradientPaint) {
            return ((JLooxGradientPaint)paint).getColor1();
        }
        if (paint instanceof JLooxRadialGradientPaint) {
            return ((JLooxRadialGradientPaint)paint)._info._fill_color;
        }
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return null;
    }

    public static Image getFillPatternImage(int n) {
        if (n == 15) {
            throw new IllegalArgumentException("gradient fills have no images");
        }
        if (n == 14) {
            throw new IllegalArgumentException("custom fills have no single image");
        }
        if (n < 0 || n >= PATTERN_IMAGES.length) {
            throw new ArrayIndexOutOfBoundsException("No such pattern: " + n);
        }
        if (PATTERN_IMAGES[n] == null) {
            try {
                String string = PATTERN_NAMES[n];
                if (string != null) {
                    Lx.PATTERN_IMAGES[n] = Resources.getImage("com/loox/jloox/images/" + string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PATTERN_IMAGES[n];
    }

    public static Paint getFillPatternPaint(int n, Color color, Color color2) {
        if (n == 1) {
            return JLooxColor.getColor(color, 1, color2);
        }
        if (n == 2) {
            return JLooxColor.getColor(color2, 2, color);
        }
        return Lx.getFillPatternPaint(Lx.getFillPatternImage(n), color, color2);
    }

    public static Paint getFillPatternPaint(Image image, final Color color, Color color2) {
        if (image == null) {
            return null;
        }
        _paint_key.set(image, color, color2);
        Paint paint = (Paint)_paint_hash.get(_paint_key);
        if (paint != null) {
            return paint;
        }
        if (image == PATTERN_IMAGES[1]) {
            return JLooxColor.getColor(color, 1, color2);
        }
        if (image == PATTERN_IMAGES[2]) {
            return JLooxColor.getColor(color2, 2, color);
        }
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new RGBImageFilter(){
            {
                this.canFilterIndexColorModel = true;
            }

            public int filterRGB(int n, int n2, int n3) {
                if (n3 == Color.black.getRGB()) {
                    n3 = color.getRGB();
                }
                return n3;
            }
        });
        Image image2 = new ImageIcon(Toolkit.getDefaultToolkit().createImage(filteredImageSource)).getImage();
        int n = image2.getWidth(null);
        int n2 = image2.getHeight(null);
        if (n == -1 || n2 == -1) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, n, n2);
        }
        graphics2D.drawImage(image2, 0, 0, null);
        paint = new JLooxTexturePaint(bufferedImage, new Rectangle(0, 0, n, n2), image, color, color2);
        _paint_hash.put(_paint_key.clone(), paint);
        return paint;
    }

    static Paint _getGradientPaint(GradientInfo gradientInfo) {
        Color color = gradientInfo._transparent ? new Color(gradientInfo._fill_color.getRed(), gradientInfo._fill_color.getGreen(), gradientInfo._fill_color.getBlue(), 0) : gradientInfo._fill_color;
        Paint paint = Lx.getGradientPaint(gradientInfo._start_x, gradientInfo._start_y, color, gradientInfo._end_x, gradientInfo._end_y, gradientInfo._line_color, gradientInfo._cyclic);
        if (gradientInfo._transparent) {
            ((JLooxGradientPaint)paint)._info._fill_color = gradientInfo._fill_color;
        }
        return paint;
    }

    static Paint _getRadialGradientPaint(GradientInfo gradientInfo) {
        Color color = gradientInfo._transparent ? new Color(gradientInfo._fill_color.getRed(), gradientInfo._fill_color.getGreen(), gradientInfo._fill_color.getBlue(), 0) : gradientInfo._fill_color;
        Paint paint = Lx.getRadialGradientPaint(gradientInfo._start_x, gradientInfo._start_y, color, gradientInfo._end_x, gradientInfo._end_y, gradientInfo._line_color);
        if (gradientInfo._transparent) {
            // empty if block
        }
        return paint;
    }

    public static Paint getGradientPaint(float f, float f2, Color color, float f3, float f4, Color color2, boolean bl) {
        return new JLooxGradientPaint(f, f2, color, f3, f4, color2, bl);
    }

    public static Paint getRadialGradientPaint(float f, float f2, Color color, float f3, float f4, Color color2) {
        return new JLooxRadialGradientPaint(f, f2, color, f3, f4, color2);
    }

    public static Image getImage(String string) {
        return Lx.getImage(string, true);
    }

    public static Image getImage(String string, boolean bl) {
        try {
            return Lx.getImage(new URL("file", null, string), bl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Image getImage(URL uRL) {
        return Lx.getImage(uRL, true);
    }

    public static Image getImage(URL uRL, boolean bl) {
        Object object;
        if (bl && ((AbstractMap)_images).containsValue(uRL)) {
            object = ((AbstractMap)_images).keySet().iterator();
            while (object.hasNext()) {
                Image image = (Image)object.next();
                URL uRL2 = (URL)_images.get(image);
                if (!uRL.equals(uRL2)) continue;
                return image;
            }
        }
        try {
            Object object2;
            object = Lx.createSearchPaths(uRL);
            int n = 0;
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                if (object[n2] == null) break;
                try {
                    object2 = ((URL)object[n2]).openStream();
                    ((InputStream)object2).close();
                    n = n2;
                    break;
                }
                catch (Exception exception) {
                    ++n2;
                }
            }
            object2 = null;
            int n3 = 0;
            while (n3 < _imageConverters.size()) {
                ImageConverter imageConverter = (ImageConverter)_imageConverters.get(n3);
                if (imageConverter != null && imageConverter.accept((URL)object[n])) {
                    object2 = imageConverter.read((URL)object[n]);
                }
                ++n3;
            }
            if (object2 == null) {
                if (bl) {
                    object2 = Toolkit.getDefaultToolkit().getImage((URL)object[n]);
                    Thread.currentThread();
                    Thread.sleep(10L);
                } else {
                    object2 = Toolkit.getDefaultToolkit().createImage((URL)object[n]);
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
            }
            _images.put(object2, object[n]);
            return object2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static float[] getPredefinedDashes(int n) {
        float[] fArray = DASHES[n];
        if (fArray != null) {
            fArray = (float[])fArray.clone();
        }
        return fArray;
    }

    public static int getPredefinedDashesIndex(float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n = 1;
        while (n < DASHES.length) {
            block5: {
                float[] fArray2 = DASHES[n];
                int n2 = fArray2.length;
                if (n2 == fArray.length) {
                    int n3 = 0;
                    while (n3 < n2) {
                        if (fArray2[n3] == fArray[n3]) {
                            ++n3;
                            continue;
                        }
                        break block5;
                    }
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    public static URL getURLFromImage(Image image) {
        return (URL)_images.get(image);
    }

    public static void paintComponentInBox(Graphics2D graphics2D, LxComponent lxComponent, Rectangle2D rectangle2D) {
        if (lxComponent instanceof LxAbstractReference) {
            Lx.paintComponentInBox(graphics2D, ((LxAbstractReference)lxComponent)._ref, rectangle2D);
            return;
        }
        Shape shape = graphics2D.getClip();
        Rectangle2D rectangle2D2 = lxComponent.getBounds2D();
        AffineTransform affineTransform = new AffineTransform();
        double d = 1.0;
        if (lxComponent instanceof LxElement) {
            d = ((LxElement)lxComponent).getLineThickness();
        }
        if (d <= 0.0) {
            d = 1.0;
        }
        double d2 = rectangle2D2.getWidth() + d;
        double d3 = rectangle2D2.getHeight() + d;
        double d4 = rectangle2D.getHeight() / d3;
        double d5 = rectangle2D.getWidth() / d2;
        double d6 = 0.0;
        double d7 = 0.0;
        if (d4 < d5) {
            d6 = 0.5 * (rectangle2D.getWidth() - d2 * d4);
            d5 = d4;
        } else {
            d7 = 0.5 * (rectangle2D.getHeight() - d3 * d5);
            d4 = d5;
        }
        if (lxComponent instanceof LxElement) {
            affineTransform.translate(rectangle2D.getX() + 0.5 * rectangle2D.getWidth(), rectangle2D.getY() + 0.5 * rectangle2D.getHeight());
            affineTransform.scale(d4, d5);
            ((LxElement)lxComponent)._paint(graphics2D, affineTransform, null, 1.0, true);
        } else {
            affineTransform.translate(rectangle2D.getX() + d6, rectangle2D.getY() + d7);
            affineTransform.scale(d4, d5);
            Lx.paintContainerWithTransfrom(graphics2D, (LxContainer)((Object)lxComponent), affineTransform);
        }
        graphics2D.setClip(shape);
    }

    private static void paintContainerWithTransfrom(Graphics2D graphics2D, LxContainer lxContainer, AffineTransform affineTransform) {
        int n = lxContainer.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            LxComponent lxComponent = lxContainer.getComponent(n2);
            AffineTransform affineTransform2 = new AffineTransform(affineTransform);
            if (lxComponent instanceof LxElement) {
                if (lxComponent instanceof LxAbstractReference && ((LxAbstractReference)lxComponent)._ref != null) {
                    LxAbstractReference lxAbstractReference = (LxAbstractReference)lxComponent;
                    if (lxAbstractReference._ref instanceof LxContainer) {
                        affineTransform2.translate(lxComponent.getX(), lxComponent.getY());
                        Lx.paintContainerWithTransfrom(graphics2D, (LxContainer)((Object)lxAbstractReference._ref), affineTransform2);
                    } else {
                        affineTransform2.translate(lxComponent.getCenterX(), lxComponent.getCenterY());
                        lxAbstractReference._ref._paint(graphics2D, affineTransform2, null, 1.0, true);
                    }
                } else {
                    affineTransform2.translate(lxComponent.getCenterX(), lxComponent.getCenterY());
                    ((LxElement)lxComponent)._paint(graphics2D, affineTransform2, null, 1.0, true);
                }
            } else {
                affineTransform2.translate(lxComponent.getX(), lxComponent.getY());
                Lx.paintContainerWithTransfrom(graphics2D, (LxContainer)((Object)lxComponent), affineTransform2);
            }
            ++n2;
        }
    }

    public static ActionProcessor setActionProcessor(ActionProcessor actionProcessor) {
        ActionProcessor actionProcessor2 = _action_processor;
        _action_processor = actionProcessor;
        return actionProcessor2;
    }

    public static void setDefaultDoubleClickActionActive(boolean bl) {
        _double_click = bl;
    }

    public static void setDefaultLineArrow(int n) {
        Arrow._verifyLineArrow(n);
        _line_arrow = n;
    }

    public static void setDefaultShadowInversion(boolean bl) {
        _is_inverted = bl;
    }

    public static void setDefaultShadowThickness(double d) {
        _shadow_thickness = d;
    }

    public static void setDefaultStyle(LxAbstractStyle lxAbstractStyle) {
        _style = lxAbstractStyle;
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        int n = jPopupMenu.getWidth();
        int n2 = jPopupMenu.getHeight();
        jPopupMenu.setInvoker(mouseEvent.getComponent());
        if (n == 0 || n2 == 0) {
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            jPopupMenu.setVisible(false);
            n = jPopupMenu.getWidth();
            n2 = jPopupMenu.getHeight();
        }
        Point point = mouseEvent.getComponent().getLocationOnScreen();
        Dimension dimension = jPopupMenu.getToolkit().getScreenSize();
        int n3 = (int)point.getX() + mouseEvent.getX();
        int n4 = (int)point.getY() + mouseEvent.getY();
        if (n3 + n > (int)dimension.getWidth()) {
            n3 = (int)dimension.getWidth() - n;
        }
        if (n4 + n2 > (int)dimension.getHeight()) {
            n4 = (int)dimension.getHeight() - n2;
        }
        _lastPopupX = mouseEvent.getX();
        _lastPopupY = mouseEvent.getY();
        jPopupMenu.setLocation(n3, n4);
        jPopupMenu.setVisible(true);
    }

    public static void addSearchURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            uRL = null;
            try {
                uRL = new URL("file:" + string);
            }
            catch (Exception exception2) {
                uRL = null;
            }
        }
        if (uRL != null) {
            Lx.addSearchURL(uRL);
        }
    }

    public static void addSearchURL(URL uRL) {
        int n = _search_urls.indexOf(uRL);
        if (n == -1) {
            _search_urls.add(uRL);
        }
    }

    public static void removeSearchURL(URL uRL) {
        int n = _search_urls.indexOf(uRL);
        if (n != -1) {
            _search_urls.remove(n);
        }
    }

    public static void removeSearchURL(String string) {
        int n;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            uRL = null;
            try {
                uRL = new URL("file:" + string);
            }
            catch (Exception exception2) {
                uRL = null;
            }
        }
        if (uRL != null && (n = _search_urls.indexOf(uRL)) != -1) {
            _search_urls.remove(n);
        }
    }

    public static URL[] createSearchPaths(URL uRL) {
        if (_search_urls.size() == 0) {
            URL[] uRLArray = new URL[]{uRL};
            return uRLArray;
        }
        File file = new File(uRL.getFile());
        String string = file.getName();
        String string2 = file.getParent();
        URL[] uRLArray = new URL[3 * _search_urls.size() + 1];
        uRLArray[0] = uRL;
        int n = 1;
        int n2 = 0;
        while (n2 < _search_urls.size()) {
            URL uRL2 = (URL)_search_urls.get(n2);
            String string3 = new File(uRL2.getFile()).getName().toLowerCase();
            String string4 = string3.endsWith(".g") || string3.endsWith(".jlx") || string3.endsWith(".jlz") || string3.endsWith(".ser") || string3.endsWith(".class") ? new File(uRL2.getFile()).getParent() : new File(uRL2.getFile()).getName();
            if (string4 == null) {
                string4 = ".";
            }
            if ("http".equals(uRL2.getProtocol()) || "jar".equals(uRL2.getProtocol()) || "ftp".equals(uRL2.getProtocol())) {
                string4 = string4.replace('\\', '/');
            }
            try {
                if (string4.startsWith("http:/")) {
                    string4 = "http://" + new String(string4.getBytes(), 6, string4.length() - 6);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                uRLArray[n] = new URL(uRL2.getProtocol(), uRL2.getHost(), string4 + "/" + string);
                ++n;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                uRLArray[n] = new URL(uRL2.getProtocol(), uRL2.getHost(), string4 + "/images/" + string);
                ++n;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                uRLArray[n] = new URL(uRL2.getProtocol(), uRL2.getHost(), uRL.getFile());
                ++n;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return uRLArray;
    }

    public static boolean isStyleListenerActivated() {
        return _styleListenerActivated;
    }

    public static void setStyleListenerActivated(boolean bl) {
        _styleListenerActivated = bl;
    }

    static Point getLastPopupClickPosition() {
        return new Point(_lastPopupX, _lastPopupY);
    }

    public static void setXORMode(Graphics graphics, Color color) {
        Color color2 = color;
        int n = color2.getRed();
        int n2 = color2.getGreen();
        int n3 = color2.getBlue();
        if (n < 150 && n2 < 150 && n3 < 150 || n + n2 + n3 < 450) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.setXORMode(color2);
    }

    public static boolean getUseXORForSelection() {
        return _useXORForSelection;
    }

    public static void setUseXORForSelection(boolean bl) {
        _useXORForSelection = bl;
    }

    public static void addImageConverter(ImageConverter imageConverter) {
        if (imageConverter != null) {
            _imageConverters.add(imageConverter);
        }
    }

    public static void setDefaultEncoding(String string) {
        _encoding = string;
    }

    public static String getDefaultEncoding() {
        return _encoding;
    }

    public static Image createImage(LxComponent[] lxComponentArray, int n, int n2, Color color, boolean bl) {
        boolean bl2 = false;
        if (lxComponentArray.length <= 0) {
            return null;
        }
        Rectangle2D rectangle2D = (Rectangle2D)lxComponentArray[0].getBounds2D().clone();
        int n3 = 1;
        while (n3 < lxComponentArray.length) {
            rectangle2D.add(lxComponentArray[n3].getBounds2D());
            ++n3;
        }
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            return null;
        }
        try {
            BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1, 1);
            if (bufferedImage == null) {
                return null;
            }
            Graphics2D graphics2D = bufferedImage.createGraphics();
            if (graphics2D == null) {
                return null;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            int n4 = (int)rectangle2D.getX();
            int n5 = (int)rectangle2D.getY();
            int n6 = (int)rectangle2D.getWidth() + 1;
            int n7 = (int)rectangle2D.getHeight() + 1;
            graphics2D.setClip(0, 0, n6, n7);
            graphics2D.translate(-n4, -n5);
            if (color != null) {
                graphics2D.setPaint(color);
                graphics2D.setColor(color);
                graphics2D.fillRect(n4, n5, n6 + 1, n7 + 1);
            }
            LxAbstractView._paintElements(lxComponentArray, graphics2D, null, 1.0, false, true);
            if (n == -1 && n2 == -1) {
                return bufferedImage;
            }
            return bufferedImage.getScaledInstance(n, n2, 4);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return null;
        }
    }

    public static Font getDefaultFont() {
        return _defaultFont;
    }

    static {
        GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    static final class JLooxTexturePaint
    extends TexturePaint
    implements Externalizable {
        private int _fill_pattern;
        Color _fg;
        Color _bg;
        Image _image;
        private URL _imageURL;

        public JLooxTexturePaint() {
            super(new BufferedImage(1, 1, 1), new Rectangle(0, 0, 1, 1));
            this._fill_pattern = 0;
            this._fg = null;
            this._bg = null;
            this._image = null;
            this._imageURL = null;
        }

        JLooxTexturePaint(BufferedImage bufferedImage, Rectangle rectangle, Image image, Color color, Color color2) {
            super(bufferedImage, rectangle);
            this._fg = color;
            this._bg = color2;
            this._image = image;
            this._imageURL = Lx.getURLFromImage(this._image);
            int n = 0;
            while (n < PATTERN_IMAGES.length) {
                if (image == PATTERN_IMAGES[n]) {
                    this._fill_pattern = n;
                    return;
                }
                ++n;
            }
            this._fill_pattern = 14;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof JLooxTexturePaint) {
                JLooxTexturePaint jLooxTexturePaint = (JLooxTexturePaint)object;
                return this._image == jLooxTexturePaint._image && (this._fg == jLooxTexturePaint._fg || this._fg != null && this._fg.equals(jLooxTexturePaint._fg)) && (this._bg == jLooxTexturePaint._bg || this._bg != null && this._bg.equals(jLooxTexturePaint._bg));
            }
            return false;
        }

        public int hashCode() {
            int n = this._image.hashCode();
            if (this._fg != null) {
                n += this._fg.hashCode() << 4;
            }
            if (this._bg != null) {
                n += this._bg.hashCode() << 8;
            }
            return n;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this._fill_pattern = objectInput.read();
            this._fg = (Color)objectInput.readObject();
            this._bg = (Color)objectInput.readObject();
            this._imageURL = (URL)objectInput.readObject();
        }

        private Object readResolve() throws ObjectStreamException {
            if (this._fill_pattern == 14) {
                if (this._imageURL != null) {
                    Image image = Lx.getImage(this._imageURL);
                    if (image != null) {
                        return Lx.getFillPatternPaint(image, this._fg, this._bg);
                    }
                    throw new ObjectStreamException("Read error: invalid image"){};
                }
                throw new ObjectStreamException(this, "Read error: invalid URL"){
                    private final /* synthetic */ JLooxTexturePaint this$0;
                    {
                        this.this$0 = jLooxTexturePaint;
                    }
                };
            }
            return Lx.getFillPatternPaint(this._fill_pattern, this._fg, this._bg);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.write(this._fill_pattern);
            objectOutput.writeObject(this._fg);
            objectOutput.writeObject(this._bg);
            objectOutput.writeObject(this._imageURL);
        }
    }

    static final class JLooxRadialGradientContext
    implements PaintContext {
        protected Point2D mPoint;
        protected Point2D mRadius;
        protected Color mC1;
        protected Color mC2;

        public JLooxRadialGradientContext(Point2D point2D, Color color, Point2D point2D2, Color color2) {
            this.mPoint = point2D;
            this.mC1 = color;
            this.mRadius = point2D2;
            this.mC2 = color2;
        }

        public void dispose() {
        }

        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        public Raster getRaster(int n, int n2, int n3, int n4) {
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            int[] nArray = new int[n3 * n4 * 4];
            double d = this.mRadius.distance(0.0, 0.0);
            int n5 = this.mC1.getRed();
            int n6 = this.mC1.getGreen();
            int n7 = this.mC1.getBlue();
            int n8 = this.mC1.getAlpha();
            int n9 = this.mC2.getRed() - n5;
            int n10 = this.mC2.getGreen() - n6;
            int n11 = this.mC2.getBlue() - n7;
            int n12 = this.mC2.getAlpha() - n8;
            int n13 = 0;
            while (n13 < n4) {
                int n14 = 0;
                while (n14 < n3) {
                    double d2 = this.mPoint.distance(n + n14, n2 + n13);
                    double d3 = d2 / d;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    int n15 = (n13 * n3 + n14) * 4;
                    nArray[n15 + 0] = (int)((double)n5 + d3 * (double)n9);
                    nArray[n15 + 1] = (int)((double)n6 + d3 * (double)n10);
                    nArray[n15 + 2] = (int)((double)n7 + d3 * (double)n11);
                    nArray[n15 + 3] = (int)((double)n8 + d3 * (double)n12);
                    ++n14;
                }
                ++n13;
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            return writableRaster;
        }
    }

    static final class JLooxRadialGradientPaint
    implements Paint,
    Externalizable {
        GradientInfo _info;

        public JLooxRadialGradientPaint() {
            this._info = new GradientInfo(0.0f, 0.0f, 1.0f, 0.0f, false, Color.black, Color.black, false, 1);
        }

        public JLooxRadialGradientPaint(float f, float f2, Color color, float f3, float f4, Color color2) {
            Point2D.Float float_ = new Point2D.Float(f3, f4);
            if (float_.distance(0.0, 0.0) <= 0.0) {
                throw new IllegalArgumentException("Radius must be greater than 0.");
            }
            this._info = new GradientInfo(f, f2, f3, f4, false, color, color2, color.getAlpha() == 0, 1);
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            Point2D point2D = affineTransform.transform(new Point2D.Float(this._info._start_x, this._info._start_y), null);
            Point2D point2D2 = affineTransform.deltaTransform(new Point2D.Float(this._info._end_x, this._info._end_y), null);
            return new JLooxRadialGradientContext(point2D, this._info._fill_color, point2D2, this._info._line_color);
        }

        public int getTransparency() {
            int n;
            int n2 = this._info._fill_color.getAlpha();
            return (n2 & (n = this._info._line_color.getAlpha())) == 255 ? 1 : 3;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this._info);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this._info = (GradientInfo)objectInput.readObject();
        }

        private Object readResolve() throws ObjectStreamException {
            return Lx._getRadialGradientPaint(this._info);
        }
    }

    static final class JLooxGradientPaint
    extends GradientPaint
    implements Externalizable {
        GradientInfo _info;

        public JLooxGradientPaint() {
            super(0.0f, 0.0f, Color.black, 1.0f, 0.0f, Color.black, false);
            this._info = null;
        }

        JLooxGradientPaint(float f, float f2, Color color, float f3, float f4, Color color2, boolean bl) {
            super(f, f2, color, f3, f4, color2, bl);
            this._info = new GradientInfo(f, f2, f3, f4, bl, color, color2, color.getAlpha() == 0, 0);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this._info);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this._info = (GradientInfo)objectInput.readObject();
        }

        private Object readResolve() throws ObjectStreamException {
            return Lx._getGradientPaint(this._info);
        }
    }

    static final class JLooxColor
    extends Color
    implements Serializable {
        private final int _fill_pattern;
        final Color _other_color;

        private JLooxColor(Color color, int n, Color color2) {
            super(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
            this._fill_pattern = n;
            this._other_color = color2;
        }

        static JLooxColor getColor(Color color, int n, Color color2) {
            _jcolor_key.set(color, n, color2);
            JLooxColor jLooxColor = (JLooxColor)_jcolor_hash.get(_jcolor_key);
            if (jLooxColor != null) {
                return jLooxColor;
            }
            jLooxColor = new JLooxColor(color, n, color2);
            _jcolor_hash.put(_jcolor_key.clone(), jLooxColor);
            return jLooxColor;
        }
    }

    private static final class PaintKey
    implements Cloneable {
        private WeakReference _image;
        private Color _fg;
        private Color _bg;

        private PaintKey() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean equals(Object object) {
            Image image;
            if (this == object) {
                return true;
            }
            if (!(object instanceof PaintKey)) {
                return false;
            }
            PaintKey paintKey = (PaintKey)object;
            Image image2 = (Image)this._image.get();
            return image2 == (image = (Image)paintKey._image.get()) && (this._fg == null && paintKey._fg == null || this._fg.equals(paintKey._fg)) && (this._bg == null && paintKey._bg == null || this._bg.equals(paintKey._bg));
        }

        public PaintKey set(Image image, Color color, Color color2) {
            this._fg = color;
            this._bg = color2;
            this._image = image != null ? new WeakReference<Image>(image) : null;
            return this;
        }

        public int hashCode() {
            Object t = this._image.get();
            int n = t != null ? t.hashCode() : 0;
            n <<= 8;
            n += this._fg != null ? this._fg.hashCode() : 0;
            n <<= 8;
            return n += this._bg != null ? this._bg.hashCode() : 0;
        }
    }

    private static final class ColorKey
    implements Cloneable {
        private int _val;

        private ColorKey() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ColorKey)) {
                return false;
            }
            ColorKey colorKey = (ColorKey)object;
            return this._val == colorKey._val;
        }

        public ColorKey set(int n, int n2, int n3, int n4) {
            this._val = (n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 0;
            return this;
        }

        public int hashCode() {
            return this._val;
        }
    }

    private static final class JColorKey
    implements Cloneable {
        private int _fill;
        private Color _color;
        private Color _other;

        private JColorKey() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof JColorKey)) {
                return false;
            }
            JColorKey jColorKey = (JColorKey)object;
            return this._fill == jColorKey._fill && this._color.equals(jColorKey._color) && (this._other == null && jColorKey._other == null || this._other.equals(jColorKey._other));
        }

        public JColorKey set(Color color, int n, Color color2) {
            this._fill = n;
            this._color = color;
            this._other = color2;
            return this;
        }

        public int hashCode() {
            int n = this._fill;
            n <<= 8;
            n += this._color.hashCode();
            n <<= 8;
            return n += this._other != null ? this._other.hashCode() : 0;
        }
    }

    static final class GradientInfo
    implements Serializable {
        public float _start_x;
        public float _start_y;
        public float _end_x;
        public float _end_y;
        public boolean _cyclic;
        public boolean _transparent;
        public Color _fill_color;
        public Color _line_color;
        public int _type;
        public static final int LINEAR_GRADIENT = 0;
        public static final int RADIAL_GRADIENT = 1;

        public GradientInfo(float f, float f2, float f3, float f4, boolean bl, Color color, Color color2, boolean bl2, int n) {
            this._start_x = f;
            this._start_y = f2;
            this._end_x = f3;
            this._end_y = f4;
            this._cyclic = bl;
            this._fill_color = color;
            this._line_color = color2;
            this._transparent = bl2;
            this._type = n;
        }
    }

    public static interface ActionProcessor {
        public boolean preprocessing(LxAbstractAction var1, Object var2, ActionEvent var3);

        public void postprocessing(LxAbstractAction var1, Object var2, ActionEvent var3);
    }

    public static abstract class ImageConverter
    extends FileFilter {
        public abstract boolean accept(URL var1);

        public abstract Image read(URL var1);

        public boolean accept(File file) {
            try {
                if (file.isDirectory()) {
                    return true;
                }
                return this.accept(file.toURL());
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public String getDescription() {
            return "Image file";
        }
    }
}

