/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.LxAbstractDyno;
import com.loox.jloox.LxAbstractLine;
import com.loox.jloox.LxAbstractPolyline;
import com.loox.jloox.LxAbstractValueDyno;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxContainerAdapter;
import com.loox.jloox.LxContainerEvent;
import com.loox.jloox.LxDouble;
import com.loox.jloox.LxMouseAdapter;
import com.loox.jloox.LxMouseEvent;
import com.loox.jloox.LxMouseMotionListener;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.LxVariableEvent;
import com.loox.jloox.LxVariableListener;
import com.loox.jloox.Point2DDouble;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class LxAbstractDial
extends LxAbstractValueDyno
implements Serializable {
    static final String CLASS_NAME = "LxAbstractDial";
    private Box _box = null;
    private Center _center = null;
    private Indicator _indicator = null;
    private Angles _angles = null;

    public LxAbstractDial() {
        this(CLASS_NAME, null);
    }

    public LxAbstractDial(LxContainer lxContainer) {
        this(CLASS_NAME, lxContainer);
    }

    LxAbstractDial(String string, LxContainer lxContainer) {
        super(string, lxContainer);
        this._initObjectVariables();
        this._postInitialize();
    }

    public Object clone() {
        LxAbstractDial lxAbstractDial = (LxAbstractDial)super.clone();
        if (lxAbstractDial == null) {
            return null;
        }
        lxAbstractDial._initObjectVariables();
        lxAbstractDial.setMaximumAngle(this.getMaximumAngle());
        lxAbstractDial.setMinimumAngle(this.getMinimumAngle());
        lxAbstractDial.setIndicatorRatio(this.getIndicatorRatio());
        return lxAbstractDial;
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        this.setMinimumAngle(LxSaveUtils.readDouble(inputStream));
        this.setMaximumAngle(LxSaveUtils.readDouble(inputStream));
        this.setIndicatorRatio(0.01 * LxSaveUtils.readDouble(inputStream));
        LxSaveUtils.readEndOfPart(inputStream);
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        LxSaveUtils.writeDouble(outputStream, this.getMinimumAngle());
        LxSaveUtils.writeDouble(outputStream, this.getMaximumAngle());
        LxSaveUtils.writeDouble(outputStream, 100.0 * this.getIndicatorRatio());
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    public double getMaximumAngle() {
        return this._angles.getMax();
    }

    public double getMinimumAngle() {
        return this._angles.getMin();
    }

    public void setMaximumAngle(double d) {
        this._angles.setMax(d);
    }

    public void setMinimumAngle(double d) {
        this._angles.setMin(d);
    }

    public void setIndicatorRatio(double d) {
        this._indicator.setRatio(d);
    }

    public double getIndicatorRatio() {
        return this._indicator.getRatio();
    }

    private void _initObjectVariables() {
        this._box = new Box();
        this._center = new Center();
        this._indicator = new Indicator();
        this._angles = new Angles();
        final LxMouseAdapter lxMouseAdapter = new LxMouseAdapter(){

            public void mousePressed(LxMouseEvent lxMouseEvent) {
                if (((LxAbstractView)lxMouseEvent.getSource()).getEditMode() == 1 && LxAbstractDial.this.isInteractive() && (lxMouseEvent.getModifiers() & 0x10) != 0 && (lxMouseEvent.getModifiers() & 8) == 0 && (lxMouseEvent.getModifiers() & 4) == 0 && (lxMouseEvent.getModifiers() & 2) == 0) {
                    LxAbstractDial.this.startUndoEdit("throw me away!");
                    LxAbstractDial.this._variable.set(LxAbstractDial.this._box.locToVal(lxMouseEvent.getX2D() - LxAbstractDial.this.getX(), lxMouseEvent.getY2D() - LxAbstractDial.this.getY()));
                    LxAbstractDial.this.cancelUndoEdit();
                }
            }
        };
        this.addMouseListener(lxMouseAdapter);
        this.addMouseMotionListener(new LxMouseMotionListener(){

            public void mouseDragged(LxMouseEvent lxMouseEvent) {
                lxMouseAdapter.mousePressed(lxMouseEvent);
            }
        });
    }

    private final class Indicator
    implements Serializable {
        private double _ratio = 1.0;

        Indicator() {
            LxAbstractDial.this.addContainerListener(new LxContainerAdapter(this){
                private final /* synthetic */ Indicator this$1;
                {
                    this.this$1 = indicator;
                }

                public void componentAdded(LxContainerEvent lxContainerEvent) {
                    LxComponent lxComponent = lxContainerEvent.getComponent();
                    if (lxComponent.getName().equals(LxAbstractDyno.getPartLabel(2))) {
                        Indicator.access$100(this.this$1, Indicator.access$700((Indicator)this.this$1)._variable.toDouble());
                    }
                }
            });
            LxAbstractDial.this._variable.addVariableListener(new LxVariableListener(this){
                private final /* synthetic */ Indicator this$1;
                {
                    this.this$1 = indicator;
                }

                public void valueChanged(LxVariableEvent lxVariableEvent) {
                    Indicator.access$100(this.this$1, ((LxDouble)lxVariableEvent.getVariable()).toDouble());
                }
            });
        }

        private void _reshape(double d) {
            if (LxAbstractDial.this._box.getBox() == null) {
                return;
            }
            Point2D point2D = LxAbstractDial.this._center.getCenter();
            if (point2D == null) {
                return;
            }
            double d2 = LxAbstractDial.this._box.getBox().getWidth() * this._ratio;
            double d3 = Math.PI * LxAbstractDial.this._box.valToAngle(d) / 180.0;
            LxComponent[] lxComponentArray = LxAbstractDial.this.getChildren(2);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(-d3, point2D.getX(), point2D.getY());
            int n = 0;
            while (n < lxComponentArray.length) {
                if (lxComponentArray[n] instanceof LxAbstractLine) {
                    ((LxAbstractLine)lxComponentArray[n]).setPoint1(point2D);
                    ((LxAbstractLine)lxComponentArray[n]).setPoint2(point2D.getX() + d2 * Math.cos(d3), point2D.getY() - d2 * Math.sin(d3));
                } else if (lxComponentArray[n] instanceof LxAbstractPolyline) {
                    LxAbstractPolyline lxAbstractPolyline = (LxAbstractPolyline)lxComponentArray[n];
                    double[] dArray = new double[8];
                    double[] dArray2 = new double[8];
                    dArray[0] = point2D.getX();
                    dArray[1] = point2D.getY();
                    dArray[2] = point2D.getX() + d2 * 0.2;
                    dArray[3] = point2D.getY() + d2 * 0.1;
                    dArray[4] = point2D.getX() + d2;
                    dArray[5] = point2D.getY();
                    dArray[6] = point2D.getX() + d2 * 0.2;
                    dArray[7] = point2D.getY() - d2 * 0.1;
                    affineTransform.transform(dArray, 0, dArray2, 0, 4);
                    lxAbstractPolyline.setPoints(dArray2);
                    lxAbstractPolyline.setClosed(true);
                } else {
                    lxComponentArray[n].setCenter(point2D.getX() + d2 * Math.cos(d3), point2D.getY() - d2 * Math.sin(d3));
                }
                ++n;
            }
        }

        public void setRatio(double d) {
            if (d != this._ratio) {
                this._ratio = d;
                this._reshape(LxAbstractDial.this._variable.toDouble());
            }
        }

        public double getRatio() {
            return this._ratio;
        }

        static /* synthetic */ LxAbstractDial access$700(Indicator indicator) {
            return indicator.LxAbstractDial.this;
        }
    }

    private final class Center
    implements Serializable {
        Center() {
            LxAbstractDial.this.addContainerListener(new LxContainerAdapter(this){
                private final /* synthetic */ Center this$1;
                {
                    this.this$1 = center;
                }

                public void componentAdded(LxContainerEvent lxContainerEvent) {
                    Point2D point2D = this.this$1.getCenter();
                    if (point2D == null) {
                        return;
                    }
                    LxComponent lxComponent = lxContainerEvent.getComponent();
                    if (lxComponent.getName().equals(LxAbstractDyno.getPartLabel(9))) {
                        Indicator.access$100(LxAbstractDial.access$000(Center.access$500(this.this$1)), Center.access$500((Center)this.this$1)._variable.toDouble());
                    }
                }
            });
        }

        public Point2D getCenter() {
            LxComponent lxComponent = LxAbstractDial.this.getFirstChild(9);
            if (lxComponent != null) {
                return lxComponent.getCenter();
            }
            LxComponent lxComponent2 = LxAbstractDial.this._box.getBox();
            if (lxComponent2 != null) {
                return new Point2DDouble(lxComponent2.getCenterX(), lxComponent2.getY() + lxComponent2.getHeight());
            }
            return null;
        }

        static /* synthetic */ LxAbstractDial access$500(Center center) {
            return center.LxAbstractDial.this;
        }
    }

    private final class Box
    implements Serializable {
        Box() {
            LxAbstractDial.this.addContainerListener(new LxContainerAdapter(){

                public void componentAdded(LxContainerEvent lxContainerEvent) {
                    LxComponent lxComponent = this.getBox();
                    if (lxComponent == null) {
                        return;
                    }
                    LxComponent lxComponent2 = lxContainerEvent.getComponent();
                    if (lxComponent2.getName().equals(LxAbstractDyno.getPartLabel(1))) {
                        LxAbstractDial.this._indicator._reshape(((Box)this).LxAbstractDial.this._variable.toDouble());
                    }
                }
            });
        }

        public LxComponent getBox() {
            return LxAbstractDial.this.getFirstChild(1);
        }

        public double locToVal(double d, double d2) {
            Point2D point2D = LxAbstractDial.this._center.getCenter();
            if (point2D == null) {
                return LxAbstractDial.this._variable.toDouble();
            }
            double d3 = 180.0 * Math.atan2(point2D.getY() - d2 - 1.0E-10, d - point2D.getX()) / Math.PI;
            double d4 = this.angleToVal(d3);
            double d5 = LxAbstractDial.this.getIncrement();
            if (d5 > 0.0) {
                int n = (int)Math.round(d4 / d5);
                return (double)n * d5;
            }
            return d4;
        }

        public double angleToVal(double d) {
            double d2 = LxAbstractDial.this._angles.getMax();
            double d3 = LxAbstractDial.this._angles.getMin();
            double d4 = LxAbstractDial.this._variable.getMinimum();
            double d5 = LxAbstractDial.this._variable.getMaximum();
            double d6 = d;
            if (d < 0.0 && d < Math.min(d3, d2)) {
                d6 = 360.0 + d;
            } else if (d > 0.0 && d > Math.max(d3, d2)) {
                d6 = d - 360.0;
            }
            double d7 = d5 - (d2 - d6) * (d5 - d4) / (d2 - d3);
            if (d7 < d4 || d7 > d5) {
                double d8 = Math.min(Math.abs(d6 - d2), Math.abs(d - d2));
                d8 = Math.min(d8, Math.abs(d2 - d6 - 360.0));
                double d9 = Math.min(Math.abs(d3 - d6), Math.abs(d - d3));
                d7 = (d9 = Math.min(d9, Math.abs(d3 - d6 - 360.0))) < d8 ? d4 : d5;
            }
            return d7;
        }

        public double valToAngle(double d) {
            LxComponent lxComponent = this.getBox();
            if (lxComponent == null) {
                return LxAbstractDial.this._angles.getMin();
            }
            double d2 = LxAbstractDial.this._angles.getMax();
            double d3 = LxAbstractDial.this._angles.getMin();
            double d4 = LxAbstractDial.this._variable.getMinimum();
            double d5 = LxAbstractDial.this._variable.getMaximum();
            double d6 = d;
            if (d < d4) {
                d6 = d4;
            } else if (d > d5) {
                d6 = d5;
            }
            double d7 = d2 - (d2 - d3) * (d5 - d6) / (d5 - d4);
            return d7;
        }
    }

    private final class Angles
    implements Serializable {
        private double _min = 0.0;
        private double _max = 90.0;

        private Angles() {
        }

        public double getMax() {
            return this._max;
        }

        public double getMin() {
            return this._min;
        }

        public void setMax(double d) {
            if (this._max != d) {
                this._max = d;
                LxAbstractDial.this._indicator._reshape(LxAbstractDial.this._variable.toDouble());
            }
        }

        public void setMin(double d) {
            if (this._min != d) {
                this._min = d;
                LxAbstractDial.this._indicator._reshape(LxAbstractDial.this._variable.toDouble());
            }
        }
    }
}

