/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxAbstractToggleAction;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxHandle;
import com.loox.jloox.LxNotResizable;
import com.loox.jloox.LxPathElement;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.Point2DDouble;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;

public abstract class LxAbstractMarker
extends LxPathElement
implements LxNotResizable,
Serializable {
    public static final double MARKER_SIZE = 6.0;
    static final String CLASS_NAME = "LxAbstractMarker";
    private static final int FIRST_MARKER_STYLE = 0;
    public static final int TRIANGLE_UP = 0;
    public static final int TRIANGLE_DOWN = 1;
    public static final int DIAMOND = 2;
    public static final int RECTANGLE = 3;
    private static final int LAST_MARKER_STYLE = 3;
    public static final String DIAMOND_ACTION = "diamond-marker";
    public static final String TRI_DOWN_ACTION = "triangle-down-marker";
    public static final String TRI_UP_ACTION = "triangle-up-marker";
    public static final String RECTANGLE_ACTION = "rectangle-marker";
    private static boolean acions_inited = false;
    private int _style;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractMarker$TriangleUpAction;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractMarker;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractMarker$TriangleDownAction;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractMarker$DiamondAction;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractMarker$RectangleAction;

    public LxAbstractMarker() {
        this(CLASS_NAME, null, null);
    }

    public LxAbstractMarker(LxContainer lxContainer) {
        this(CLASS_NAME, lxContainer, null);
    }

    public LxAbstractMarker(Point2D point2D) {
        this(CLASS_NAME, null, point2D);
    }

    public LxAbstractMarker(LxContainer lxContainer, Point2D point2D) {
        this(CLASS_NAME, lxContainer, point2D);
    }

    LxAbstractMarker(String string, LxContainer lxContainer, Point2D point2D) {
        super(string, lxContainer, false);
        if (!acions_inited) {
            acions_inited = true;
            LxComponent.registerActionClass(TRI_UP_ACTION, class$com$loox$jloox$LxAbstractMarker$TriangleUpAction == null ? (class$com$loox$jloox$LxAbstractMarker$TriangleUpAction = LxAbstractMarker.class$("com.loox.jloox.LxAbstractMarker$TriangleUpAction")) : class$com$loox$jloox$LxAbstractMarker$TriangleUpAction, class$com$loox$jloox$LxAbstractMarker == null ? (class$com$loox$jloox$LxAbstractMarker = LxAbstractMarker.class$("com.loox.jloox.LxAbstractMarker")) : class$com$loox$jloox$LxAbstractMarker);
            LxComponent.registerActionClass(TRI_DOWN_ACTION, class$com$loox$jloox$LxAbstractMarker$TriangleDownAction == null ? (class$com$loox$jloox$LxAbstractMarker$TriangleDownAction = LxAbstractMarker.class$("com.loox.jloox.LxAbstractMarker$TriangleDownAction")) : class$com$loox$jloox$LxAbstractMarker$TriangleDownAction, class$com$loox$jloox$LxAbstractMarker == null ? (class$com$loox$jloox$LxAbstractMarker = LxAbstractMarker.class$("com.loox.jloox.LxAbstractMarker")) : class$com$loox$jloox$LxAbstractMarker);
            LxComponent.registerActionClass(DIAMOND_ACTION, class$com$loox$jloox$LxAbstractMarker$DiamondAction == null ? (class$com$loox$jloox$LxAbstractMarker$DiamondAction = LxAbstractMarker.class$("com.loox.jloox.LxAbstractMarker$DiamondAction")) : class$com$loox$jloox$LxAbstractMarker$DiamondAction, class$com$loox$jloox$LxAbstractMarker == null ? (class$com$loox$jloox$LxAbstractMarker = LxAbstractMarker.class$("com.loox.jloox.LxAbstractMarker")) : class$com$loox$jloox$LxAbstractMarker);
            LxComponent.registerActionClass(RECTANGLE_ACTION, class$com$loox$jloox$LxAbstractMarker$RectangleAction == null ? (class$com$loox$jloox$LxAbstractMarker$RectangleAction = LxAbstractMarker.class$("com.loox.jloox.LxAbstractMarker$RectangleAction")) : class$com$loox$jloox$LxAbstractMarker$RectangleAction, class$com$loox$jloox$LxAbstractMarker == null ? (class$com$loox$jloox$LxAbstractMarker = LxAbstractMarker.class$("com.loox.jloox.LxAbstractMarker")) : class$com$loox$jloox$LxAbstractMarker);
        }
        this._style = -99;
        super.setSize(6.0, 6.0);
        if (point2D != null) {
            this.setLocation(point2D);
        }
        this.setMarkerStyle(0);
        this._postInitialize();
    }

    public Object clone() {
        LxAbstractMarker lxAbstractMarker = (LxAbstractMarker)super.clone();
        if (lxAbstractMarker == null) {
            return null;
        }
        lxAbstractMarker._style = -99;
        lxAbstractMarker.setMarkerStyle(this.getMarkerStyle());
        return lxAbstractMarker;
    }

    void _addHandle(LxHandle lxHandle, boolean bl) {
        if (this.getHandleCount() == 0) {
            LxHandle lxHandle2 = new LxHandle(new Point2DDouble());
            lxHandle2.setResizes(false);
            super._addHandle(lxHandle2, false);
        }
    }

    protected void createHandles() {
        this.addStandardHandles();
    }

    public void removeHandle(LxHandle lxHandle) {
        try {
            super.removeHandle(lxHandle);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        this.setMarkerStyle(LxSaveUtils.readInt(inputStream));
        LxSaveUtils.readEndOfPart(inputStream);
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        LxSaveUtils.writeInt(outputStream, this.getMarkerStyle());
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    public final void setSize(double d, double d2) {
        throw new IllegalArgumentException("marker size cannot be changed");
    }

    protected static void createInteractively(final Class clazz, final LxAbstractView lxAbstractView) {
        lxAbstractView._createInteractively(new LxElement.PointCreation(lxAbstractView){
            static /* synthetic */ Class class$com$loox$jloox$LxContainer;
            static /* synthetic */ Class class$java$awt$geom$Point2D;

            public LxElement create(LxAbstractGraph lxAbstractGraph, Point2D point2D) {
                try {
                    Constructor constructor = clazz.getConstructor(class$com$loox$jloox$LxContainer == null ? (class$com$loox$jloox$LxContainer = 1.class$("com.loox.jloox.LxContainer")) : class$com$loox$jloox$LxContainer, class$java$awt$geom$Point2D == null ? (class$java$awt$geom$Point2D = 1.class$("java.awt.geom.Point2D")) : class$java$awt$geom$Point2D);
                    LxAbstractMarker lxAbstractMarker = (LxAbstractMarker)constructor.newInstance(lxAbstractView.getGraph(), point2D);
                    return lxAbstractMarker;
                }
                catch (Exception exception) {
                    return null;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    public int getMarkerStyle() {
        return this._style;
    }

    public void setMarkerStyle(int n) {
        double[] dArray;
        if (this._style == n) {
            return;
        }
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("unknown marker style");
        }
        double d = this.getCenterX();
        double d2 = this.getCenterY();
        switch (n) {
            case 0: {
                dArray = new double[]{d, d2 - 3.0, d + 3.0, d2 + 3.0, d - 3.0, d2 + 3.0};
                break;
            }
            case 1: {
                dArray = new double[]{d, d2 + 3.0, d + 3.0, d2 - 3.0, d - 3.0, d2 - 3.0};
                break;
            }
            case 2: {
                dArray = new double[]{d, d2 - 3.0, d + 3.0, d2, d, d2 + 3.0, d - 3.0, d2};
                break;
            }
            case 3: {
                dArray = new double[]{d - 3.0, d2 - 3.0, d + 3.0, d2 - 3.0, d + 3.0, d2 + 3.0, d - 3.0, d2 + 3.0};
                break;
            }
            default: {
                return;
            }
        }
        this._style = n;
        this.removeAllPathPoints();
        this.setPath(dArray);
        this.setClosed(true);
        this._setActionState(DIAMOND_ACTION, n == 2);
        this._setActionState(RECTANGLE_ACTION, n == 3);
        this._setActionState(TRI_DOWN_ACTION, n == 1);
        this._setActionState(TRI_UP_ACTION, n == 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class TriangleUpAction
    extends StyleAction {
        TriangleUpAction() {
            super(LxAbstractMarker.TRI_UP_ACTION, "Triangle Up", "Change to triangle-up style", 0);
        }
    }

    private final class TriangleDownAction
    extends StyleAction {
        TriangleDownAction() {
            super(LxAbstractMarker.TRI_DOWN_ACTION, "Triangle Down", "Change to triangle-down style", 1);
        }
    }

    private abstract class StyleAction
    extends LxAbstractToggleAction
    implements Serializable {
        private final int _val;

        StyleAction(String string, String string2, String string3, int n) {
            super(string, string2, string3, null, string2, string3, null, false, true);
            this.setState(n == LxAbstractMarker.this.getMarkerStyle());
            this._val = n;
        }

        public void processAction(ActionEvent actionEvent) {
            LxAbstractMarker.this.setMarkerStyle(this._val);
            this.setState(true);
        }
    }

    private final class RectangleAction
    extends StyleAction {
        RectangleAction() {
            super(LxAbstractMarker.RECTANGLE_ACTION, "Rectangle", "Change to rectangle style", 3);
        }
    }

    private final class DiamondAction
    extends StyleAction {
        DiamondAction() {
            super(LxAbstractMarker.DIAMOND_ACTION, "Diamond", "Change to diamond style", 2);
        }
    }
}

