/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.Cache;
import com.loox.jloox.LooxCollapsableEdit;
import com.loox.jloox.LooxUndoableEdit;
import com.loox.jloox.LxAbstractAction;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxPolyline;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.LxShadowElement;
import com.loox.jloox.LxSymmetrical;
import com.loox.jloox.LxVectorial;
import com.loox.jloox.Resources;
import com.loox.jloox.Shadow;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class LxAbstractRectangle
extends LxVectorial
implements Serializable,
LxShadowElement,
LxSymmetrical {
    static final String CLASS_NAME = "LxAbstractRectangle";
    public static final String PERFECT_SQUARE_ACTION = "perfect-square";
    public static final String POLYGONIZE_RECTANGLE_ACTION = "polygonize-rectangle";
    private static final RectKey _key = new RectKey().set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static boolean actions_inited = false;
    private double _arc_width;
    private double _arc_height;
    private boolean _rounded;
    private Shadow _shadow;
    static /* synthetic */ Class class$com$loox$jloox$LxElement$PerfectSquareAction;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractRectangle;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractRectangle$PolygonizeAction;

    public LxAbstractRectangle() {
        this(CLASS_NAME, null, null);
    }

    public LxAbstractRectangle(LxContainer lxContainer) {
        this(CLASS_NAME, lxContainer, null);
    }

    public LxAbstractRectangle(Rectangle2D rectangle2D) {
        this(CLASS_NAME, null, rectangle2D);
    }

    public LxAbstractRectangle(LxContainer lxContainer, Rectangle2D rectangle2D) {
        this(CLASS_NAME, lxContainer, rectangle2D);
    }

    LxAbstractRectangle(String string, LxContainer lxContainer, Rectangle2D rectangle2D) {
        super(string, lxContainer, rectangle2D, false);
        if (!actions_inited) {
            actions_inited = true;
            LxComponent.registerActionClass(PERFECT_SQUARE_ACTION, class$com$loox$jloox$LxElement$PerfectSquareAction == null ? (class$com$loox$jloox$LxElement$PerfectSquareAction = LxAbstractRectangle.class$("com.loox.jloox.LxElement$PerfectSquareAction")) : class$com$loox$jloox$LxElement$PerfectSquareAction, class$com$loox$jloox$LxAbstractRectangle == null ? (class$com$loox$jloox$LxAbstractRectangle = LxAbstractRectangle.class$("com.loox.jloox.LxAbstractRectangle")) : class$com$loox$jloox$LxAbstractRectangle);
            LxComponent.registerActionClass(POLYGONIZE_RECTANGLE_ACTION, class$com$loox$jloox$LxAbstractRectangle$PolygonizeAction == null ? (class$com$loox$jloox$LxAbstractRectangle$PolygonizeAction = LxAbstractRectangle.class$("com.loox.jloox.LxAbstractRectangle$PolygonizeAction")) : class$com$loox$jloox$LxAbstractRectangle$PolygonizeAction, class$com$loox$jloox$LxAbstractRectangle == null ? (class$com$loox$jloox$LxAbstractRectangle = LxAbstractRectangle.class$("com.loox.jloox.LxAbstractRectangle")) : class$com$loox$jloox$LxAbstractRectangle);
        }
        this._arc_width = 0.0;
        this._arc_height = 0.0;
        this._rounded = false;
        this._shadow = null;
        this._initObjectVariables();
        this._postInitialize();
    }

    public Object clone() {
        LxAbstractRectangle lxAbstractRectangle = (LxAbstractRectangle)super.clone();
        if (lxAbstractRectangle == null) {
            return null;
        }
        lxAbstractRectangle._initObjectVariables();
        lxAbstractRectangle.setShadowThickness(this.getShadowThickness());
        lxAbstractRectangle.setInverted(this.isInverted());
        return lxAbstractRectangle;
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        this.setArcWidth(LxSaveUtils.readDouble(inputStream));
        this.setArcHeight(LxSaveUtils.readDouble(inputStream));
        this.setRounded(LxSaveUtils.readBoolean(inputStream));
        LxSaveUtils.readEndOfPart(inputStream);
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        LxSaveUtils.writeDouble(outputStream, this.getArcWidth());
        LxSaveUtils.writeDouble(outputStream, this.getArcHeight());
        LxSaveUtils.writeBoolean(outputStream, this.isRounded());
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    protected static void createInteractively(Class clazz, LxAbstractView lxAbstractView) {
        lxAbstractView._createInteractively(new LxVectorial.RectangularCreation(clazz, lxAbstractView));
    }

    protected LxVectorial.ShapeData[] getShapeData() {
        LxVectorial.ShapeData[] shapeDataArray;
        double d = -this.getWidth() / 2.0;
        double d2 = -this.getHeight() / 2.0;
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        double d5 = Math.min(this.getArcWidth(), d3);
        double d6 = Math.min(this.getArcHeight(), d4);
        Shape shape = this._getRectangle(d, d2, d3, d4, d5, d6);
        if (this.getShadowThickness() > 0.0) {
            GeneralPath generalPath = new GeneralPath(0);
            GeneralPath generalPath2 = new GeneralPath(0);
            GeneralPath generalPath3 = new GeneralPath(0);
            GeneralPath generalPath4 = new GeneralPath(0);
            if (this.isRounded()) {
                double d7 = d5 / 2.0;
                double d8 = d6 / 2.0;
                double d9 = Math.cos(0.7853981633974483);
                double d10 = Math.min(this.getShadowThickness(), Math.min(d7, d8));
                double d11 = d + d7;
                double d12 = d2 + d8;
                generalPath.append(new Arc2D.Double(d11 - d7, d12 - d8, d5, d6, 135.0, -45.0, 0).getPathIterator(null), false);
                d11 = d + d3 - d7;
                generalPath.append(new Arc2D.Double(d11 - d7, d12 - d8, d5, d6, 90.0, -45.0, 0).getPathIterator(null), true);
                generalPath.append(new Arc2D.Double(d11 - (d7 - d10), d2 + d10, d5 - 2.0 * d10, d6 - 2.0 * d10, 45.0, 45.0, 0).getPathIterator(null), true);
                d11 = d + d7;
                generalPath.append(new Arc2D.Double(d11 - (d7 - d10), d2 + d10, d5 - 2.0 * d10, d6 - 2.0 * d10, 90.0, 45.0, 0).getPathIterator(null), true);
                generalPath.closePath();
                d11 = d + d7;
                d12 = d2 + d4 - d8;
                generalPath2.append(new Arc2D.Double(d11 - d7, d12 - d8, d5, d6, 225.0, 45.0, 0).getPathIterator(null), false);
                d11 = d + d3 - d7;
                generalPath2.append(new Arc2D.Double(d11 - d7, d12 - d8, d5, d6, 270.0, 45.0, 0).getPathIterator(null), true);
                generalPath2.append(new Arc2D.Double(d11 - (d7 - d10), d12 - (d8 - d10), d5 - 2.0 * d10, d6 - 2.0 * d10, 315.0, -45.0, 0).getPathIterator(null), true);
                d11 = d + d7;
                generalPath2.append(new Arc2D.Double(d11 - (d7 - d10), d12 - (d8 - d10), d5 - 2.0 * d10, d6 - 2.0 * d10, 270.0, -45.0, 0).getPathIterator(null), true);
                generalPath2.closePath();
                d12 = d2 + d8;
                generalPath3.append(new Arc2D.Double(d11 - d7, d12 - d8, d5, d6, 135.0, 45.0, 0).getPathIterator(null), false);
                d12 = d2 + d4 - d8;
                generalPath3.append(new Arc2D.Double(d11 - d7, d12 - d8, d5, d6, 180.0, 45.0, 0).getPathIterator(null), true);
                generalPath3.append(new Arc2D.Double(d11 - (d7 - d10), d12 - (d8 - d10), d5 - 2.0 * d10, d6 - 2.0 * d10, 225.0, -45.0, 0).getPathIterator(null), true);
                d12 = d2 + d8;
                generalPath3.append(new Arc2D.Double(d11 - (d7 - d10), d12 - (d8 - d10), d5 - 2.0 * d10, d6 - 2.0 * d10, 180.0, -45.0, 0).getPathIterator(null), true);
                generalPath3.closePath();
                d11 = d + d3 - d7;
                d12 = d2 + d8;
                generalPath4.append(new Arc2D.Double(d11 - d7, d12 - d8, d5, d6, 45.0, -45.0, 0).getPathIterator(null), false);
                d12 = d2 + d4 - d8;
                generalPath4.append(new Arc2D.Double(d11 - d7, d12 - d8, d5, d6, 0.0, -45.0, 0).getPathIterator(null), true);
                generalPath4.append(new Arc2D.Double(d11 - (d7 - d10), d12 - (d8 - d10), d5 - 2.0 * d10, d6 - 2.0 * d10, 315.0, 45.0, 0).getPathIterator(null), true);
                d12 = d2 + d8;
                generalPath4.append(new Arc2D.Double(d11 - (d7 - d10), d12 - (d8 - d10), d5 - 2.0 * d10, d6 - 2.0 * d10, 0.0, 45.0, 0).getPathIterator(null), true);
                generalPath4.closePath();
                shapeDataArray = new LxVectorial.ShapeData[]{new LxVectorial.StandardShapeData(this, shape), new LxVectorial.ShadowShapeData(this, generalPath, false), new LxVectorial.ShadowShapeData(this, generalPath2, true), new LxVectorial.ShadowShapeData(this, generalPath3, false), new LxVectorial.ShadowShapeData(this, generalPath4, true)};
            } else {
                float f = (float)Math.min(this.getShadowThickness(), Math.min(d3 / 2.0, d4 / 2.0));
                float f2 = (float)d;
                float f3 = (float)(d + d3);
                float f4 = f2 + f;
                float f5 = f3 - f;
                float f6 = (float)d2;
                float f7 = (float)(d2 + d4);
                float f8 = f6 + f;
                float f9 = f7 - f;
                generalPath.moveTo(f2, f6);
                generalPath.lineTo(f3, f6);
                generalPath.lineTo(f5, f8);
                generalPath.lineTo(f4, f8);
                generalPath.closePath();
                generalPath3.moveTo(f2, f7);
                generalPath3.lineTo(f2, f6);
                generalPath3.lineTo(f4, f8);
                generalPath3.lineTo(f4, f9);
                generalPath3.closePath();
                generalPath2.moveTo(f2, f7);
                generalPath2.lineTo(f3, f7);
                generalPath2.lineTo(f5, f9);
                generalPath2.lineTo(f4, f9);
                generalPath2.closePath();
                generalPath4.moveTo(f3, f7);
                generalPath4.lineTo(f3, f6);
                generalPath4.lineTo(f5, f8);
                generalPath4.lineTo(f5, f9);
                generalPath4.closePath();
                shapeDataArray = new LxVectorial.ShapeData[]{new LxVectorial.StandardShapeData(this, shape), new LxVectorial.ShadowShapeData(this, generalPath, false), new LxVectorial.ShadowShapeData(this, generalPath2, true), new LxVectorial.ShadowShapeData(this, generalPath3, false), new LxVectorial.ShadowShapeData(this, generalPath4, true)};
            }
        } else {
            shapeDataArray = new LxVectorial.ShapeData[]{new LxVectorial.StandardShapeData(this, shape)};
        }
        return shapeDataArray;
    }

    public double getArcHeight() {
        return this._arc_height;
    }

    public double getArcWidth() {
        return this._arc_width;
    }

    public boolean isRounded() {
        return this._rounded;
    }

    public void setArcHeight(double d) {
        this._setArcHeight(d, true);
    }

    public void setArcWidth(double d) {
        this._setArcWidth(d, true);
    }

    public void setRounded(boolean bl) {
        this._setRounded(bl, true);
    }

    public Shape[] getShape() {
        LxVectorial.ShapeData[] shapeDataArray = this.getShapeData();
        Shape[] shapeArray = new Shape[shapeDataArray.length];
        int n = 0;
        while (n < shapeDataArray.length) {
            shapeArray[n] = shapeDataArray[n].shape;
            ++n;
        }
        return shapeArray;
    }

    private Shape _getRectangle(double d, double d2, double d3, double d4, double d5, double d6) {
        Shape shape;
        if (this.isRounded() && d5 != 0.0 && d6 != 0.0) {
            _key.set(d, d2, d3, d4, d5, d6);
            shape = (Shape)LxVectorial._cache.get(_key);
            if (shape == null) {
                shape = new RoundRectangle2D.Double(d, d2, d3, d4, d5, d6);
            }
            LxVectorial._cache.put(_key.clone(), shape);
        } else {
            shape = new Rectangle2D.Double(d, d2, d3, d4);
        }
        return shape;
    }

    private void _initObjectVariables() {
        this._shadow = null;
    }

    private void _setArcHeight(double d, boolean bl) {
        double d2 = this._arc_height;
        if (d == d2) {
            return;
        }
        Rectangle2D rectangle2D = this.getStrokedBounds2D();
        this._arc_height = d;
        if (bl && this._undoOn()) {
            this.addUndoEdit(new ArcHeightEdit(this, d2));
        }
        if (this.isRounded()) {
            this.fireComponentMorphed(rectangle2D);
        }
    }

    private void _setArcWidth(double d, boolean bl) {
        double d2 = this._arc_width;
        if (d == d2) {
            return;
        }
        Rectangle2D rectangle2D = this.getStrokedBounds2D();
        this._arc_width = d;
        if (bl && this._undoOn()) {
            this.addUndoEdit(new ArcWidthEdit(this, d2));
        }
        if (this.isRounded()) {
            this.fireComponentMorphed(rectangle2D);
        }
    }

    private void _setRounded(boolean bl, boolean bl2) {
        boolean bl3 = this._rounded;
        if (bl == bl3) {
            return;
        }
        Rectangle2D rectangle2D = this.getStrokedBounds2D();
        this._rounded = bl;
        if (bl2 && this._undoOn()) {
            this.addUndoEdit(new RoundedEdit(this, bl3));
        }
        this.fireComponentMorphed(rectangle2D);
    }

    public double getShadowThickness() {
        if (this._shadow == null) {
            return 0.0;
        }
        return this._shadow.getShadowThickness();
    }

    public boolean isInverted() {
        if (this._shadow == null) {
            return false;
        }
        return this._shadow.isInverted();
    }

    public void setInverted(boolean bl) {
        if (bl == this.isInverted()) {
            return;
        }
        if (this._shadow == null) {
            this._shadow = new Shadow(this);
        }
        this._shadow.setInverted(bl);
        if (!this.isInverted() && this.getShadowThickness() == 0.0) {
            this._shadow = null;
        }
    }

    public void setShadowThickness(double d) {
        if (d == this.getShadowThickness()) {
            return;
        }
        if (this._shadow == null) {
            this._shadow = new Shadow(this);
        }
        this._shadow.setShadowThickness(d);
        if (!this.isInverted() && this.getShadowThickness() == 0.0) {
            this._shadow = null;
        }
    }

    public void flip() {
    }

    public void mirror() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class RoundedEdit
    extends LooxUndoableEdit {
        private static final String ROUNDED_UNDO = "rectangle-roundedUndo";

        public RoundedEdit(LxAbstractRectangle lxAbstractRectangle, boolean bl) {
            super(lxAbstractRectangle, Resources.get(ROUNDED_UNDO, "rounded"), bl);
        }

        void _undoEdit(boolean bl) {
            LxAbstractRectangle lxAbstractRectangle = (LxAbstractRectangle)this._getHost();
            lxAbstractRectangle._setRounded(bl, false);
        }
    }

    private static final class RectKey
    implements Cache.Key {
        private double _x;
        private double _y;
        private double _w;
        private double _h;
        private double _aw;
        private double _ah;
        private int _hc;

        private RectKey() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RectKey)) {
                return false;
            }
            RectKey rectKey = (RectKey)object;
            return this._hc == rectKey._hc && this._x == rectKey._x && this._y == rectKey._y && this._w == rectKey._w && this._h == rectKey._h && this._aw == rectKey._aw && this._ah == rectKey._ah;
        }

        public int hashCode() {
            return this._hc;
        }

        public RectKey set(double d, double d2, double d3, double d4, double d5, double d6) {
            if (d == this._x && d2 == this._y && d3 == this._w && d4 == this._h && d5 == this._aw && d6 == this._ah) {
                return this;
            }
            this._x = d;
            this._y = d2;
            this._w = d3;
            this._h = d4;
            this._aw = d5;
            this._ah = d6;
            long l = Double.doubleToLongBits(this._x);
            l <<= 2;
            l += Double.doubleToLongBits(this._y);
            l <<= 2;
            l += Double.doubleToLongBits(this._w);
            l <<= 2;
            l += Double.doubleToLongBits(this._h);
            l <<= 2;
            l += Double.doubleToLongBits(this._aw);
            l <<= 2;
            this._hc = (int)(l += Double.doubleToLongBits(this._ah));
            return this;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    final class PolygonizeAction
    extends LxAbstractAction
    implements Serializable {
        PolygonizeAction() {
            super(LxAbstractRectangle.POLYGONIZE_RECTANGLE_ACTION, "Polygonize", "Creates a polyline object from this rectangle", null, true);
        }

        public void processAction(ActionEvent actionEvent) {
            LxContainer lxContainer = LxAbstractRectangle.this.getParent();
            int n = lxContainer.getComponentIndex(LxAbstractRectangle.this);
            LxPolyline lxPolyline = new LxPolyline((LxContainer)LxAbstractRectangle.this.getGraph(), LxAbstractRectangle.this, 10.0);
            lxPolyline.setSelected(LxAbstractRectangle.this.isSelected());
            lxContainer.remove(LxAbstractRectangle.this);
            lxContainer.add(lxPolyline, n);
        }
    }

    private static final class ArcWidthEdit
    extends LooxCollapsableEdit {
        private static final String ARC_WIDTH_UNDO = "rectangle-arc-widthUndo";
        private double _value;

        public ArcWidthEdit(LxAbstractRectangle lxAbstractRectangle, double d) {
            super(lxAbstractRectangle, Resources.get(ARC_WIDTH_UNDO, "arc width"));
            this._value = d;
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
            this._value = ((ArcWidthEdit)looxCollapsableEdit)._value;
        }

        void _undoEdit(boolean bl) {
            LxAbstractRectangle lxAbstractRectangle = (LxAbstractRectangle)this._getHost();
            double d = lxAbstractRectangle.getArcWidth();
            lxAbstractRectangle._setArcWidth(this._value, false);
            this._value = d;
        }
    }

    private static final class ArcHeightEdit
    extends LooxCollapsableEdit {
        private static final String ARC_HEIGHT_UNDO = "rectangle-arc-heightUndo";
        private double _value;

        public ArcHeightEdit(LxAbstractRectangle lxAbstractRectangle, double d) {
            super(lxAbstractRectangle, Resources.get(ARC_HEIGHT_UNDO, "arc height"));
            this._value = d;
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
            this._value = ((ArcHeightEdit)looxCollapsableEdit)._value;
        }

        void _undoEdit(boolean bl) {
            LxAbstractRectangle lxAbstractRectangle = (LxAbstractRectangle)this._getHost();
            double d = lxAbstractRectangle.getArcHeight();
            lxAbstractRectangle._setArcHeight(this._value, false);
            this._value = d;
        }
    }
}

