/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.Lx;
import com.loox.jloox.LxAbstractDyno;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxContainerAdapter;
import com.loox.jloox.LxContainerEvent;
import com.loox.jloox.LxDouble;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.LxText;
import com.loox.jloox.LxVariable;
import com.loox.jloox.LxVariableBoundsAdapter;
import com.loox.jloox.LxVariableBoundsListener;
import com.loox.jloox.LxVariableEvent;
import com.loox.jloox.LxVariableListener;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;

public abstract class LxAbstractValueDyno
extends LxAbstractDyno
implements Serializable {
    static final String CLASS_NAME = "LxAbstractValueDyno";
    LxDouble _variable = new LxDouble(0.0, 100.0, 0.0);
    private Colors _colors = null;
    private TextPart _min = null;
    private TextPart _max = null;
    private TextPart _value = null;
    private double _increment = 0.0;

    public LxAbstractValueDyno() {
        this(CLASS_NAME, null);
    }

    public LxAbstractValueDyno(LxContainer lxContainer) {
        this(CLASS_NAME, lxContainer);
    }

    LxAbstractValueDyno(String string, LxContainer lxContainer) {
        super(string, lxContainer);
        this._initObjectVariables();
    }

    public Object clone() {
        LxAbstractValueDyno lxAbstractValueDyno = (LxAbstractValueDyno)super.clone();
        if (lxAbstractValueDyno == null) {
            return null;
        }
        lxAbstractValueDyno._variable = new LxDouble(this.getMinimum(), this.getMaximum(), this._variable.toDouble());
        lxAbstractValueDyno._initObjectVariables();
        lxAbstractValueDyno.setMinimumColor(this.getMinimumColor());
        lxAbstractValueDyno.setMaximumColor(this.getMaximumColor());
        lxAbstractValueDyno.setPattern(this.getPattern());
        lxAbstractValueDyno.setThreshold(this.getThreshold());
        lxAbstractValueDyno.setThresholdValue(this.getThresholdValue());
        lxAbstractValueDyno.setColorIndicator(this.getColorIndicator());
        return lxAbstractValueDyno;
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        double d = LxSaveUtils.readDouble(inputStream);
        double d2 = LxSaveUtils.readDouble(inputStream);
        double d3 = LxSaveUtils.readDouble(inputStream);
        this.setAll(d, d2, d3);
        this.setMinimumColor(LxSaveUtils.readColor(inputStream));
        this.setMaximumColor(LxSaveUtils.readColor(inputStream));
        if (string.compareTo("1.1.2") >= 0) {
            this.setColorIndicator(LxSaveUtils.readBoolean(inputStream));
        }
        this.setPattern(LxSaveUtils.readString(inputStream));
        boolean bl = LxSaveUtils.readBoolean(inputStream);
        double d4 = LxSaveUtils.readDouble(inputStream);
        this.setThreshold(bl);
        this.setThresholdValue(d4);
        double d5 = 0.0;
        d5 = string.compareTo("2.0.0") >= 0 ? LxSaveUtils.readDouble(inputStream) : 0.0;
        this.setIncrement(d5);
        LxSaveUtils.readEndOfPart(inputStream);
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        LxSaveUtils.writeDouble(outputStream, this.getMinimum());
        LxSaveUtils.writeDouble(outputStream, this.getMaximum());
        LxSaveUtils.writeDouble(outputStream, this.getValue());
        LxSaveUtils.writeColor(outputStream, this.getMinimumColor());
        LxSaveUtils.writeColor(outputStream, this.getMaximumColor());
        LxSaveUtils.writeBoolean(outputStream, this.getColorIndicator());
        LxSaveUtils.writeString(outputStream, this.getPattern());
        LxSaveUtils.writeBoolean(outputStream, this.getThreshold());
        LxSaveUtils.writeDouble(outputStream, this.getThresholdValue());
        LxSaveUtils.writeDouble(outputStream, this.getIncrement());
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    protected LxVariable getVariable() {
        return this._variable;
    }

    public void valueChanged(LxVariableEvent lxVariableEvent) {
    }

    public double getMaximum() {
        return this._variable.getMaximum();
    }

    public Color getMaximumColor() {
        return this._colors.getMax();
    }

    public double getMinimum() {
        return this._variable.getMinimum();
    }

    public Color getMinimumColor() {
        return this._colors.getMin();
    }

    public String getPattern() {
        return this._value.getPattern();
    }

    public void setAll(double d, double d2, double d3) {
        this._variable.setAll(d, d2, d3);
    }

    public void setMaximum(double d) {
        this._variable.setMaximum(d);
    }

    public void setMaximumColor(Color color) {
        this._colors.setMax(color);
    }

    public void setMinimum(double d) {
        this._variable.setMinimum(d);
    }

    public void setMinimumColor(Color color) {
        this._colors.setMin(color);
    }

    public void setPattern(String string) {
        this._value.setPattern(string);
    }

    public void setValue(double d) {
        this._variable.set(d);
    }

    public double getValue() {
        return this._variable.get();
    }

    public void setThreshold(boolean bl) {
        this._colors.setThreshold(bl);
    }

    public boolean getThreshold() {
        return this._colors.getThreshold();
    }

    public void setThresholdValue(double d) {
        this._colors.setThresholdValue(d);
    }

    public double getThresholdValue() {
        return this._colors.getThresholdValue();
    }

    public void setColorIndicator(boolean bl) {
        this._colors.setColorIndicator(bl);
    }

    public boolean getColorIndicator() {
        return this._colors.getColorIndicator();
    }

    public void setIncrement(double d) {
        this._increment = d;
    }

    public double getIncrement() {
        return this._increment;
    }

    private void _initObjectVariables() {
        this._colors = new Colors();
        this._min = new Min();
        this._max = new Max();
        this._value = new Value();
        this._variable.addVariableListener(this);
    }

    static /* synthetic */ Colors access$300(LxAbstractValueDyno lxAbstractValueDyno) {
        return lxAbstractValueDyno._colors;
    }

    private final class Value
    extends TextPart
    implements Serializable {
        Value() {
            super(6);
            LxAbstractValueDyno.this._variable.addVariableListener(new LxVariableListener(this){
                private final /* synthetic */ Value this$1;
                {
                    this.this$1 = value;
                }

                public void valueChanged(LxVariableEvent lxVariableEvent) {
                    this.this$1._update();
                }
            });
        }

        double _getValue() {
            return LxAbstractValueDyno.this._variable.toDouble();
        }
    }

    private abstract class TextPart
    implements Serializable {
        private final int _part_id;
        private DecimalFormat _format;

        TextPart(int n) {
            this._part_id = n;
            this._format = new DecimalFormat("#0.##");
            LxAbstractValueDyno.this.addContainerListener(new LxContainerAdapter(this){
                private final /* synthetic */ TextPart this$1;
                {
                    this.this$1 = textPart;
                }

                public void componentAdded(LxContainerEvent lxContainerEvent) {
                    LxComponent lxComponent = lxContainerEvent.getComponent();
                    if (lxComponent instanceof LxText && lxComponent.getName().equals(LxAbstractDyno.getPartLabel(TextPart.access$500(this.this$1)))) {
                        ((LxText)lxComponent).setText(TextPart.access$600(this.this$1, this.this$1._getValue()));
                    }
                }
            });
        }

        private String _getText(double d) {
            return this._format.format(d);
        }

        abstract double _getValue();

        void _update() {
            LxComponent[] lxComponentArray = LxAbstractValueDyno.this.getChildren(this._part_id);
            if (lxComponentArray.length > 0) {
                String string = this._getText(this._getValue());
                int n = 0;
                while (n < lxComponentArray.length) {
                    LxComponent lxComponent = lxComponentArray[n];
                    if (lxComponent instanceof LxText) {
                        ((LxText)lxComponent).setText(string);
                    }
                    ++n;
                }
            }
        }

        public String getPattern() {
            return this._format.toPattern();
        }

        public void setPattern(String string) {
            this._format.applyPattern(string);
            this._update();
        }

        static /* synthetic */ int access$500(TextPart textPart) {
            return textPart._part_id;
        }

        static /* synthetic */ String access$600(TextPart textPart, double d) {
            return textPart._getText(d);
        }
    }

    private final class Min
    extends TextPart
    implements Serializable {
        Min() {
            super(4);
            LxAbstractValueDyno.this._variable.addVariableBoundsListener(new LxVariableBoundsAdapter(this){
                private final /* synthetic */ Min this$1;
                {
                    this.this$1 = min;
                }

                public void minimumChanged(LxVariableEvent lxVariableEvent) {
                    this.this$1._update();
                }
            });
        }

        double _getValue() {
            return LxAbstractValueDyno.this._variable.getMinimum();
        }
    }

    private final class Max
    extends TextPart
    implements Serializable {
        Max() {
            super(5);
            LxAbstractValueDyno.this._variable.addVariableBoundsListener(new LxVariableBoundsAdapter(this){
                private final /* synthetic */ Max this$1;
                {
                    this.this$1 = max;
                }

                public void maximumChanged(LxVariableEvent lxVariableEvent) {
                    this.this$1._update();
                }
            });
        }

        double _getValue() {
            return LxAbstractValueDyno.this._variable.getMaximum();
        }
    }

    private final class Colors
    implements Serializable {
        private Color _min = Color.black;
        private Color _max = Color.black;
        private boolean _threshold = false;
        private double _thresholdValue = 0.0;
        private boolean _colorIndicator = false;

        Colors() {
            LxAbstractValueDyno.this._variable.addVariableListener(new LxVariableListener(this){
                private final /* synthetic */ Colors this$1;
                {
                    this.this$1 = colors;
                }

                public void valueChanged(LxVariableEvent lxVariableEvent) {
                    Colors.access$000(this.this$1);
                }
            });
            LxAbstractValueDyno.this._variable.addVariableBoundsListener(new LxVariableBoundsListener(this){
                private final /* synthetic */ Colors this$1;
                {
                    this.this$1 = colors;
                }

                public void maximumChanged(LxVariableEvent lxVariableEvent) {
                    Colors.access$000(this.this$1);
                }

                public void minimumChanged(LxVariableEvent lxVariableEvent) {
                    Colors.access$000(this.this$1);
                }
            });
            LxAbstractValueDyno.this.addContainerListener(new LxContainerAdapter(this){
                private final /* synthetic */ Colors this$1;
                {
                    this.this$1 = colors;
                }

                public void componentAdded(LxContainerEvent lxContainerEvent) {
                    LxComponent lxComponent = lxContainerEvent.getComponent();
                    if (lxComponent instanceof LxElement && lxComponent.getName().equals(LxAbstractDyno.getPartLabel(3))) {
                        Colors.access$400(LxAbstractValueDyno.access$300(Colors.access$200(this.this$1)), (LxElement)lxComponent, Colors.access$100(this.this$1));
                    }
                }
            });
        }

        private Color _getColor() {
            if (this._threshold) {
                if (LxAbstractValueDyno.this._variable.get() >= this._thresholdValue) {
                    return this._max;
                }
                return this._min;
            }
            double d = this._min.getRed();
            double d2 = this._min.getGreen();
            double d3 = this._min.getBlue();
            double d4 = this._max.getRed();
            double d5 = this._max.getGreen();
            double d6 = this._max.getBlue();
            double d7 = LxAbstractValueDyno.this._variable.toPercent();
            return new Color((int)((d4 - d) * d7 + d), (int)((d5 - d2) * d7 + d2), (int)((d6 - d3) * d7 + d3));
        }

        public Color getMax() {
            return this._max;
        }

        public void setMax(Color color) {
            this._max = color;
            this._update();
        }

        public Color getMin() {
            return this._min;
        }

        public void setMin(Color color) {
            this._min = color;
            this._update();
        }

        public void setThreshold(boolean bl) {
            if (this._threshold != bl) {
                this._threshold = bl;
                this._update();
            }
        }

        public boolean getThreshold() {
            return this._threshold;
        }

        public void setThresholdValue(double d) {
            if (this._thresholdValue != d) {
                this._thresholdValue = d;
                this._update();
            }
        }

        public double getThresholdValue() {
            return this._thresholdValue;
        }

        public void setColorIndicator(boolean bl) {
            if (this._colorIndicator != bl) {
                this._colorIndicator = bl;
                this._update();
            }
        }

        public boolean getColorIndicator() {
            return this._colorIndicator;
        }

        private void _update() {
            LxComponent[] lxComponentArray;
            LxComponent[] lxComponentArray2 = LxAbstractValueDyno.this.getChildren(3);
            Color color = this._getColor();
            if (lxComponentArray2.length > 0) {
                int n = 0;
                while (n < lxComponentArray2.length) {
                    LxComponent lxComponent = lxComponentArray2[n];
                    this._apply(lxComponent, color);
                    ++n;
                }
            }
            if (this._colorIndicator && (lxComponentArray = LxAbstractValueDyno.this.getChildren(2)).length > 0) {
                int n = 0;
                while (n < lxComponentArray.length) {
                    LxComponent lxComponent = lxComponentArray[n];
                    this._apply(lxComponent, color);
                    ++n;
                }
            }
        }

        private void _apply(LxComponent lxComponent, Color color) {
            if (lxComponent instanceof LxContainer) {
                int n = 0;
                while (n < ((LxContainer)((Object)lxComponent)).getComponentCount()) {
                    this._apply(((LxContainer)((Object)lxComponent)).getComponent(n), color);
                    ++n;
                }
            } else if (lxComponent instanceof LxElement) {
                Paint paint = ((LxElement)lxComponent).getPaint();
                int n = Lx.getFillPattern(paint);
                Paint paint2 = null;
                if (paint instanceof Color) {
                    paint2 = color;
                } else if (paint instanceof GradientPaint) {
                    Point2D point2D = ((GradientPaint)paint).getPoint1();
                    Point2D point2D2 = ((GradientPaint)paint).getPoint2();
                    Color color2 = ((GradientPaint)paint).getColor1();
                    paint2 = Lx.getGradientPaint((float)point2D.getX(), (float)point2D.getY(), color2, (float)point2D2.getX(), (float)point2D2.getY(), color, ((GradientPaint)paint).isCyclic());
                } else if (paint instanceof Lx.JLooxTexturePaint) {
                    paint2 = Lx.getFillPatternPaint(n, color, ((Lx.JLooxTexturePaint)paint)._bg);
                } else {
                    ((LxElement)lxComponent).setLineColor(color);
                }
                if (paint2 != null) {
                    ((LxElement)lxComponent).setPaint(paint2);
                }
            }
        }

        static /* synthetic */ void access$000(Colors colors) {
            colors._update();
        }

        static /* synthetic */ Color access$100(Colors colors) {
            return colors._getColor();
        }

        static /* synthetic */ LxAbstractValueDyno access$200(Colors colors) {
            return colors.LxAbstractValueDyno.this;
        }

        static /* synthetic */ void access$400(Colors colors, LxComponent lxComponent, Color color) {
            colors._apply(lxComponent, color);
        }
    }
}

