/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.gis.jloox.LxGisLxView;
import com.loox.jloox.BooleanKey;
import com.loox.jloox.DialogFrame;
import com.loox.jloox.Dimension2DDouble;
import com.loox.jloox.ItemListener2;
import com.loox.jloox.Listener;
import com.loox.jloox.Lx;
import com.loox.jloox.LxAbstractAction;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxAbstractGroup;
import com.loox.jloox.LxAbstractLink;
import com.loox.jloox.LxAbstractReference;
import com.loox.jloox.LxAbstractToggleAction;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxAppearanceEvent;
import com.loox.jloox.LxAppearanceListener;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxConstants;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxCreationEvent;
import com.loox.jloox.LxCreationListener;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxEnterLeaveListener;
import com.loox.jloox.LxHandle;
import com.loox.jloox.LxLayers;
import com.loox.jloox.LxLink;
import com.loox.jloox.LxMouseEvent;
import com.loox.jloox.LxNotResizable;
import com.loox.jloox.LxTransferable;
import com.loox.jloox.Point2DDouble;
import com.loox.jloox.PrintDialog;
import com.loox.jloox.Rectangle2DDouble;
import com.loox.jloox.Resources;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Transparency;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class LxAbstractView
extends JComponent
implements LxConstants,
Printable,
Serializable {
    public static final int STANDARD_MODE = 1;
    public static final int EDITOR_MODE = 2;
    public static final int SILENT_MODE = 3;
    public static final int DND_NO_MODES = 0;
    public static final int DND_STANDARD_MODE = 1;
    public static final int DND_EDITOR_MODE = 2;
    public static final int DND_SILENT_MODE = 3;
    public static final int DND_ALL_MODES = 3;
    public static final String ANTIALIAS_ACTION = "toggle-antialiasing";
    public static final String BACKING_STORE_ACTION = "toggle-backing-store";
    public static final String DETACH_ACTION = "detach-view";
    public static final String GRID_DIALOG_ACTION = "grid-dialog";
    public static final String CREATE_ARRAY_ACTION = "create-array";
    public static final String CREATE_CIRCLE_ACTION = "create-circle";
    public static final String CREATE_IMAGE_ACTION = "create-image";
    public static final String CREATE_LINE_ACTION = "create-line";
    public static final String CREATE_LINK_ACTION = "create-link";
    public static final String CREATE_ORTHO_LINK_ACTION = "create-ortho-link";
    public static final String CREATE_MARKER_ACTION = "create-marker";
    public static final String CREATE_PARALLELOGRAM_ACTION = "create-parallelogram";
    public static final String CREATE_POLYLINE_ACTION = "create-polyline";
    public static final String CREATE_GENERALPATH_ACTION = "create-polypath";
    public static final String CREATE_RECTANGLE_ACTION = "create-rectangle";
    public static final String CREATE_TEXT_ACTION = "create-text";
    public static final String CREATE_TEXTAREA_ACTION = "create-text-area";
    public static final String DOUBLE_BUFFER_ACTION = "toggle-double-buffer";
    public static final String LAYER_VISIBILITY_DIALOG_ACTION = "layer-visibility-dialog";
    public static final String PRINT_ACTION = "print-view-dialog";
    public static final String SELECT_ALL_ACTION = "select-all-view";
    public static final String TOGGLE_MODE_ACTION = "toggle-mode";
    public static final String ZOOM_OUT_ACTION = "zoom-out-graph";
    public static final String ZOOM_IN_ACTION = "zoom-in-graph";
    public static final String ZOOM_OUT_12_ACTION = "zoom-graph-12";
    public static final String ZOOM_OUT_25_ACTION = "zoom-graph-25";
    public static final String ZOOM_OUT_50_ACTION = "zoom-graph-50";
    public static final String ZOOM_OUT_75_ACTION = "zoom-graph-75";
    public static final String ZOOM_NORMAL_ACTION = "zoom-graph-100";
    public static final String ZOOM_IN_150_ACTION = "zoom-graph-150";
    public static final String ZOOM_IN_200_ACTION = "zoom-graph-200";
    public static final String ZOOM_IN_400_ACTION = "zoom-graph-400";
    public static final String ZOOM_IN_800_ACTION = "zoom-graph-800";
    public static final String ZOOM_LINES_ACTION = "toggle-zoom-lines";
    public static RenderingHints.Key KEY_ZOOMABLE_LINES = null;
    public static final Object VALUE_ZOOM_LINES_ON = new Boolean(true);
    public static final Object VALUE_ZOOM_LINES_OFF = new Boolean(false);
    public static final int GRID_POINTS = 0;
    public static final int GRID_LINES = 1;
    private static final Insets STD_INSETS = new Insets(3, 3, 3, 3);
    private EditMode _edit_mode = new EditMode();
    private Graph _graph = new Graph();
    private LinkHandles _link_handles = new LinkHandles();
    private Zoom _zoom = new Zoom();
    private SelectionDistance _select_dist = new SelectionDistance();
    private Layers _layers = new Layers();
    private BGPaint _bg_paint = new BGPaint();
    private Lasso _lasso = new Lasso();
    private Popup _popup = new Popup();
    private DropSite _drop_site = new DropSite();
    private DragSite _drag_site = new DragSite();
    private Hints _hints = new Hints();
    private Actions _actions = new Actions();
    private MagneticGrid _grid = new MagneticGrid();
    private PrintData _print_data = null;
    private boolean _refreshEnabled = true;
    private boolean _animationOptimized = true;
    private boolean _selectionDisplayed = true;
    private boolean _printingThreaded = true;
    protected boolean _drawSelection = true;
    private boolean _draggingHandlesVisible = true;
    private boolean _user_modify = true;
    private transient BasicStroke _basicStroke = new BasicStroke();
    private transient boolean _cleanedUp = false;
    private boolean _paletteBehavior = false;
    private boolean _activateEnterLeave = false;
    private MouseMotionListener _enterLeaveListener = null;
    private Vector _enterLeaveListeners = null;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractView;

    public LxAbstractView() {
        this._actions.setEnabled(false);
        this.setDoubleBuffered(true);
        this.setBackground((Color)this.getBackgroundPaint());
        this.setPreferredSize(new Dimension(1280, 1024));
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                Container container = LxAbstractView.this.getParent();
                while (container != null) {
                    if (container instanceof JViewport) {
                        JViewport jViewport = (JViewport)container;
                        jViewport.setBackingStoreEnabled(false);
                        LxAbstractView.this.removeAncestorListener(this);
                        return;
                    }
                    container = container.getParent();
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    public String toString() {
        return "LxAbstractView";
    }

    public Color getBackground() {
        Paint paint = this.getBackgroundPaint();
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return super.getBackground();
    }

    public void setBackground(Color color) {
        this.setBackgroundPaint(color);
    }

    public boolean isOpaque() {
        return true;
    }

    public void paintComponent(Graphics graphics) {
        if (this._cleanedUp) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = this.getZoomFactor();
        AffineTransform affineTransform = null;
        if (d != 1.0) {
            affineTransform = graphics2D.getTransform();
            graphics2D.transform(AffineTransform.getScaleInstance(d, d));
        }
        if (this._lasso._band_lstnr != null && this._lasso._band_lstnr._added && ((Lasso)this._lasso)._band_lstnr._eraseOld) {
            this._lasso._band_lstnr._draw();
            ((Lasso)this._lasso)._band_lstnr._eraseOld = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (LxAbstractView.this._lasso._band_lstnr != null && LxAbstractView.this._lasso._band_lstnr._added && !((Lasso)((LxAbstractView)LxAbstractView.this)._lasso)._band_lstnr._eraseOld) {
                        LxAbstractView.this._lasso._band_lstnr._draw();
                        ((Lasso)((LxAbstractView)LxAbstractView.this)._lasso)._band_lstnr._eraseOld = true;
                    }
                }
            });
        }
        this.paintBackground(graphics2D);
        if (this.getGraph() == null) {
            return;
        }
        if (!this.isRefreshEnabled()) {
            return;
        }
        if (this.getGraph() != null) {
            this.getGraph();
            if (LxAbstractGraph.shouldExit) {
                return;
            }
        }
        if (this._layers._val.isEmpty() && this.getGraph().getSelectedObjectCount() == 0) {
            return;
        }
        graphics2D.setRenderingHints(this._hints._val);
        this.paintLxComponents(graphics2D);
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
        this.paintSelection(graphics2D);
    }

    public void setDoubleBuffered(boolean bl) {
        super.setDoubleBuffered(bl);
        Action action = this.getAction(DOUBLE_BUFFER_ACTION);
        if (action != null) {
            ((LxAbstractToggleAction)action).setState(bl);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addInteractiveCreationListener(LxCreationListener lxCreationListener) {
        this._lasso._lstnrs.add(lxCreationListener);
    }

    public void fireInteractiveCreation(LxElement lxElement) {
        this._lasso._lstnrs.fireCreated(lxElement);
    }

    public Point2D applyMagneticGrid(Point2D point2D) {
        double d = this._grid.applyX(point2D.getX());
        double d2 = this._grid.applyY(point2D.getY());
        return new Point2D.Double(d, d2);
    }

    public void createInteractively(Class clazz) {
        LxAbstractGraph lxAbstractGraph = this.getGraph();
        if (lxAbstractGraph == null) {
            this._lasso._lstnrs.fireCreated(null);
            return;
        }
        try {
            Method method = clazz.getMethod("createInteractively", class$com$loox$jloox$LxAbstractView == null ? (class$com$loox$jloox$LxAbstractView = LxAbstractView.class$("com.loox.jloox.LxAbstractView")) : class$com$loox$jloox$LxAbstractView);
            method.invoke(null, this);
            return;
        }
        catch (Exception exception) {
            this._lasso._lstnrs.fireCreated(null);
            return;
        }
    }

    public Rectangle computeBounds() {
        LxComponent lxComponent;
        LxAbstractGraph lxAbstractGraph = this.getGraph();
        int n = lxAbstractGraph.getComponentCount();
        Rectangle2DDouble rectangle2DDouble = new Rectangle2DDouble();
        Rectangle2DDouble rectangle2DDouble2 = new Rectangle2DDouble();
        double d = this.getZoomFactor();
        if (n > 0) {
            lxComponent = lxAbstractGraph.getComponent(0);
            lxComponent.getBounds2D(rectangle2DDouble);
        }
        int n2 = 1;
        while (n2 < n) {
            lxComponent = lxAbstractGraph.getComponent(n2);
            lxComponent.getBounds2D(rectangle2DDouble2);
            rectangle2DDouble.add(rectangle2DDouble2);
            ++n2;
        }
        return new Rectangle((int)(d * ((RectangularShape)rectangle2DDouble).getX()), (int)(d * ((RectangularShape)rectangle2DDouble).getY()), (int)(d * ((RectangularShape)rectangle2DDouble).getWidth()), (int)(d * ((RectangularShape)rectangle2DDouble).getHeight()));
    }

    public Rectangle2D computeBounds(LxComponent[] lxComponentArray) {
        LxAbstractGraph lxAbstractGraph = this.getGraph();
        int n = lxComponentArray.length;
        Rectangle2DDouble rectangle2DDouble = new Rectangle2DDouble();
        Rectangle2DDouble rectangle2DDouble2 = new Rectangle2DDouble();
        double d = this.getZoomFactor();
        if (n > 0) {
            lxComponentArray[0].getBounds2D(rectangle2DDouble);
        }
        int n2 = 1;
        while (n2 < n) {
            lxComponentArray[n2].getBounds2D(rectangle2DDouble2);
            rectangle2DDouble.add(rectangle2DDouble2);
            ++n2;
        }
        return new Rectangle2D.Double(d * ((RectangularShape)rectangle2DDouble).getX(), d * ((RectangularShape)rectangle2DDouble).getY(), d * ((RectangularShape)rectangle2DDouble).getWidth(), d * ((RectangularShape)rectangle2DDouble).getHeight());
    }

    public void fitToGraph(int n, int n2) {
        Rectangle rectangle = this.computeBounds();
        this.setPreferredSize(new Dimension((int)(rectangle.getX() + rectangle.getWidth() + (double)n), (int)(rectangle.getY() + rectangle.getHeight()) + n2));
    }

    public Action getAction(String string) {
        return this._actions.get(string);
    }

    public Action[] getActions() {
        this._actions.get("create-all-actions-now");
        return this._actions.toArray();
    }

    public Paint getBackgroundPaint() {
        return this._bg_paint._val;
    }

    public int getDragMode() {
        return this._drag_site._mode;
    }

    public int getDropMode() {
        return this._drop_site._mode;
    }

    public int getEditMode() {
        return this._edit_mode._val;
    }

    public LxHandle getHandleAt(int n, int n2) {
        LxAbstractGraph lxAbstractGraph = this.getGraph();
        if (lxAbstractGraph != null) {
            return this._getHandleAt(n, n2, (LxComponent[])lxAbstractGraph.getSelectedObjects());
        }
        return null;
    }

    public boolean getLayer(int n) {
        return this._layers._val.getLayer(n);
    }

    public LxLayers getLayers() {
        return (LxLayers)this._layers._val.clone();
    }

    public LxComponent getLxComponentAt(int n, int n2) {
        LxAbstractGraph lxAbstractGraph = this.getGraph();
        if (lxAbstractGraph == null || this._layers._val.isEmpty()) {
            return null;
        }
        int n3 = lxAbstractGraph.getComponentCount();
        double d = this.getZoomFactor();
        double d2 = d - 1.0;
        double d3 = (double)(this.getSelectionDistance() + 1) / 2.0;
        double d4 = d3 / d;
        double d5 = d3 * 2.0;
        double d6 = d4 * 2.0;
        double d7 = (double)n / d - d4;
        double d8 = (double)n2 / d - d4;
        LxLayers lxLayers = this._layers._val;
        int n4 = n3 - 1;
        while (n4 >= 0) {
            double d9;
            double d10;
            LxComponent lxComponent = lxAbstractGraph.getComponent(n4);
            if ((lxComponent.isVisible() || lxComponent.isBlinkingEnabled()) && this.onVisibleLayer(lxComponent) && (lxComponent.isZoomable() ? lxComponent.intersects(d7, d8, d6, d6, this) : lxComponent.intersects(d10 = (double)n - lxComponent.getCenterX() * d2 - d3, d9 = (double)n2 - lxComponent.getCenterY() * d2 - d3, d5, d5, this))) {
                return lxComponent;
            }
            --n4;
        }
        return null;
    }

    public LxComponent getLxComponentAt(Point point) {
        return this.getLxComponentAt(point.x, point.y);
    }

    public LxAbstractGraph getGraph() {
        return this._graph._val;
    }

    public Color getMagneticGridColor() {
        return this._grid._color;
    }

    public int getMagneticGridWidth() {
        return this._grid._gx;
    }

    public int getMagneticGridHeight() {
        return this._grid._gy;
    }

    public Dimension getMagneticGridSize() {
        return new Dimension(this._grid._gx, this._grid._gy);
    }

    public void setMagneticGridDisplayPolicy(int n) {
        if (n == this.getMagneticGridDisplayPolicy()) {
            return;
        }
        this._grid.setDisplayPolicy(n);
    }

    public int getMagneticGridDisplayPolicy() {
        return this._grid.getDisplayPolicy();
    }

    public JPopupMenu getPopupMenu() {
        return this._popup._val;
    }

    public PrintData getPrintData() {
        return this._print_data;
    }

    public Object getRenderingHint(Object object) {
        return this._hints._val.get(object);
    }

    public RenderingHints getRenderingHints() {
        return (RenderingHints)this._hints._val.clone();
    }

    public boolean getResizeMultiple() {
        return this._lasso._resize_multiple;
    }

    public int getSelectionDistance() {
        return this._select_dist._val;
    }

    public double getZoomFactor() {
        return this._zoom._val;
    }

    public boolean getZoomLines() {
        Object object = this.getRenderingHint(KEY_ZOOMABLE_LINES);
        if (object != null) {
            return object.equals(VALUE_ZOOM_LINES_ON);
        }
        return false;
    }

    public boolean isAntialiasingActivated() {
        return this.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    public boolean isHandlesVisibleOnDrag() {
        return this._draggingHandlesVisible;
    }

    public boolean isInteractivelyCreating() {
        return this._lasso.isCreating();
    }

    public boolean isLinkMode() {
        return this._link_handles._val;
    }

    public boolean isMagneticGridEnabled() {
        return this._grid._enabled;
    }

    public boolean isMagneticGridVisible() {
        return this._grid._visible;
    }

    public boolean isUserModifiable() {
        return this._user_modify;
    }

    public boolean lassoIsDisplayed() {
        return this._lasso.isDisplayed();
    }

    public void lassoSetDisplayed(boolean bl) {
        this._lasso.setDisplayed(bl);
    }

    public boolean onVisibleLayer(LxComponent lxComponent) {
        return this._layers.intersects(lxComponent);
    }

    public void paintMagneticGrid(Graphics2D graphics2D) {
        Paint paint = this.getBackgroundPaint();
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setPaint(paint);
        if (paint instanceof Color) {
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics2D.fill(new Rectangle2DDouble(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight()));
        }
    }

    public void paintBackground(Graphics2D graphics2D) {
        if (!this._grid.isEnabled() || !this.isMagneticGridVisible()) {
            this.paintMagneticGrid(graphics2D);
        } else {
            AffineTransform affineTransform = graphics2D.getTransform();
            if (this.getMagneticGridDisplayPolicy() == 0) {
                graphics2D.transform(AffineTransform.getTranslateInstance(-0.5, -0.5));
            }
            this._grid.draw(graphics2D);
            if (affineTransform != null) {
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    public void paintLxComponents(Graphics2D graphics2D) {
        LxAbstractView._paintElements(this.getGraph(), graphics2D, this._layers._val, this.getZoomFactor(), false, true);
    }

    public void paintSelection(LxComponent lxComponent, Graphics2D graphics2D) {
        this.paintSelection(lxComponent, graphics2D, lxComponent.getCenter(), lxComponent.getSize());
    }

    public void paintSelection(LxComponent lxComponent, Graphics2D graphics2D, Point2D point2D, Dimension2D dimension2D) {
        if (!this._drawSelection || !this.isSelectionDisplayed()) {
            return;
        }
        if (lxComponent.getHandleCount() == 0 || !this.onVisibleLayer(lxComponent)) {
            return;
        }
        double d = this.getZoomFactor();
        double d2 = lxComponent.isZoomable() ? d : 1.0;
        double d3 = point2D.getX() * d;
        double d4 = point2D.getY() * d;
        double d5 = dimension2D.getWidth() * d2;
        double d6 = dimension2D.getHeight() * d2;
        this.setXORMode(graphics2D);
        if (!Lx.getUseXORForSelection()) {
            graphics2D.setPaintMode();
            graphics2D.setStroke(this._basicStroke);
        }
        lxComponent.paintHandles(graphics2D, d3, d4, d5, d6);
        graphics2D.setPaintMode();
    }

    public void paintSelection(Graphics2D graphics2D) {
        if (this.getGraph().getSelectedObjectCount() > 0) {
            Object[] objectArray = this.getGraph().getSelectedObjects();
            int n = 0;
            while (n < objectArray.length) {
                LxComponent lxComponent = (LxComponent)objectArray[n];
                if (this.onVisibleLayer(lxComponent)) {
                    this.paintSelection(lxComponent, graphics2D);
                }
                ++n;
            }
        }
    }

    public void removeInteractiveCreationListener(LxCreationListener lxCreationListener) {
        this._lasso._lstnrs.remove(lxCreationListener);
    }

    public void select(Rectangle rectangle) {
        LxAbstractGraph lxAbstractGraph = this.getGraph();
        if (lxAbstractGraph == null) {
            return;
        }
        int n = lxAbstractGraph.getComponentCount();
        double d = this.getZoomFactor();
        double d2 = rectangle.x;
        double d3 = rectangle.y;
        double d4 = rectangle.width;
        double d5 = rectangle.height;
        int n2 = 0;
        while (n2 < n) {
            LxComponent lxComponent = lxAbstractGraph.getComponent(n2);
            if (this.onVisibleLayer(lxComponent)) {
                double d6 = lxComponent.getWidth();
                double d7 = lxComponent.getHeight();
                if (lxComponent.isZoomable()) {
                    d6 *= d;
                    d7 *= d;
                }
                double d8 = d6 / 2.0;
                double d9 = d7 / 2.0;
                double d10 = lxComponent.getCenterX() * d - d8;
                double d11 = lxComponent.getCenterY() * d - d9;
                if (d10 >= d2 && d11 >= d3 && d10 + d6 <= d2 + d4 && d11 + d7 <= d3 + d5) {
                    lxComponent.setSelected(true);
                }
            }
            ++n2;
        }
    }

    public void setAntialiasingActivated(boolean bl) {
        this.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void setBackgroundPaint(Paint paint) {
        this._bg_paint.set(paint);
        this._grid._paint = null;
        if (paint instanceof Color) {
            super.setBackground((Color)paint);
        }
    }

    public void setHandlesVisibleOnDrag(boolean bl) {
        this._draggingHandlesVisible = bl;
    }

    public void setDragMode(int n) {
        this._drag_site.set(n);
    }

    public void setDropMode(int n) {
        this._drop_site.set(n);
    }

    public void setEditMode(int n) {
        this._edit_mode.set(n);
    }

    public void setGraph(LxAbstractGraph lxAbstractGraph) {
        this._graph.set(lxAbstractGraph, true);
    }

    public void setLayer(int n, boolean bl) {
        this._layers.set(n, bl);
    }

    public void setLayers(LxLayers lxLayers) {
        this._layers.set(lxLayers);
    }

    public void setLinkMode(boolean bl) {
        this._link_handles.set(bl);
    }

    public void setMagneticGridColor(Color color) {
        this._grid.setColor(color);
    }

    public void setMagneticGridEnabled(boolean bl) {
        this._grid.setEnabled(bl);
    }

    public void setMagneticGridSize(int n) {
        this._grid.set(n, n);
    }

    public void setMagneticGridSize(Dimension dimension) {
        this._grid.set((int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public void setMagneticGridSize(int n, int n2) {
        this._grid.set(n, n2);
    }

    public void setMagneticGridVisible(boolean bl) {
        this._grid.setVisible(bl);
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this._popup.set(jPopupMenu);
    }

    public void setPrintData(PrintData printData) {
        this._print_data = printData;
    }

    public void setRefreshEnabled(boolean bl) {
        this._refreshEnabled = bl;
    }

    public void setRecordRegionsEnabled(boolean bl) {
        this._graph.setRecordRegions(bl);
    }

    public boolean isRecordRegionsEnabled() {
        return this._graph._rr;
    }

    public void forceRepaint(LxComponent[] lxComponentArray) {
        this._graph.forceRepaint(lxComponentArray);
    }

    public void forceRepaint(LxComponent lxComponent) {
        this._graph.forceRepaint(lxComponent);
    }

    public boolean isRefreshEnabled() {
        return this._refreshEnabled;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this._hints.set(renderingHints);
    }

    public void setRenderingHint(Object object, Object object2) {
        this._hints.set(object, object2);
    }

    public void setResizeMultiple(boolean bl) {
        this._lasso.setResizeMultiple(bl);
    }

    public void setSelectionDistance(int n) {
        this._select_dist.set(n);
    }

    public void setUserModifiable(boolean bl) {
        this._user_modify = bl;
    }

    public void setZoomFactor(double d) {
        this._zoom.set(d, true);
    }

    public void setZoomLines(boolean bl) {
        this.setRenderingHint(KEY_ZOOMABLE_LINES, bl ? VALUE_ZOOM_LINES_ON : VALUE_ZOOM_LINES_OFF);
    }

    public void setZoomFactor(double d, boolean bl) {
        this._zoom.set(d, bl);
    }

    void _createInteractively(LxElement.InteractiveCreation interactiveCreation) {
        this._lasso.startCreation(interactiveCreation);
    }

    void _finishCreation(LxElement lxElement) {
        this._lasso.stopCreation(lxElement);
    }

    public void stopInteractiveCreation() {
        this._lasso.stopCreation(null);
    }

    static final void _paintElements(LxContainer lxContainer, Graphics2D graphics2D, LxLayers lxLayers, double d, boolean bl, boolean bl2) {
        LxAbstractView._paintElements(lxContainer.getComponents(), graphics2D, lxLayers, d, bl, bl2);
    }

    static final void _paintElements(LxComponent[] lxComponentArray, Graphics2D graphics2D, LxLayers lxLayers, double d, boolean bl, boolean bl2) {
        if (lxComponentArray == null || lxComponentArray.length == 0) {
            return;
        }
        int n = lxComponentArray.length;
        Rectangle rectangle = graphics2D.getClipBounds();
        Rectangle2DDouble rectangle2DDouble = new Rectangle2DDouble();
        AffineTransform affineTransform = new AffineTransform();
        int n2 = 0;
        while (n2 < n) {
            LxComponent lxComponent = lxComponentArray[n2];
            if (lxComponent.isVisible() && (lxLayers == null || lxComponent.isOnLayer(lxLayers))) {
                double d2;
                double d3;
                double d4;
                double d5;
                boolean bl3;
                lxComponent.getStrokedBounds2D(rectangle2DDouble);
                boolean bl4 = bl3 = bl ? bl2 : lxComponent.isZoomable();
                if (!bl3 && d != 1.0) {
                    if (!bl) {
                        d5 = lxComponent.getCenterX() - ((RectangularShape)rectangle2DDouble).getX();
                        d4 = lxComponent.getCenterY() - ((RectangularShape)rectangle2DDouble).getY();
                        ((Rectangle2D)rectangle2DDouble).setRect(lxComponent.getCenterX() - d5 / d, lxComponent.getCenterY() - d4 / d, ((RectangularShape)rectangle2DDouble).getWidth() / d, ((RectangularShape)rectangle2DDouble).getHeight() / d);
                    } else {
                        d5 = (((RectangularShape)rectangle2DDouble).getX() + ((RectangularShape)rectangle2DDouble).getWidth() / 2.0) / d;
                        d4 = (((RectangularShape)rectangle2DDouble).getY() + ((RectangularShape)rectangle2DDouble).getHeight() / 2.0) / d;
                        d3 = ((RectangularShape)rectangle2DDouble).getWidth() / d;
                        d2 = ((RectangularShape)rectangle2DDouble).getHeight() / d;
                        ((Rectangle2D)rectangle2DDouble).setRect(d5 - d3 / 2.0, d4 - d2 / 2.0, d3, d2);
                    }
                }
                if (rectangle2DDouble.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                    d5 = lxComponent.getCenterX();
                    d4 = lxComponent.getCenterY();
                    d3 = d5 * d;
                    d2 = d4 * d;
                    if (bl3) {
                        affineTransform.translate(d5, d4);
                    } else {
                        if (d != 1.0) {
                            affineTransform.scale(1.0 / d, 1.0 / d);
                        }
                        if (bl) {
                            affineTransform.translate(d5, d4);
                        } else {
                            affineTransform.translate(d3, d2);
                        }
                    }
                    lxComponent._paint(graphics2D, affineTransform, lxLayers, d, bl3);
                    affineTransform.setToIdentity();
                }
            }
            ++n2;
        }
    }

    void _setGraph(LxAbstractGraph lxAbstractGraph) {
        this._graph.set(lxAbstractGraph, false);
    }

    protected void dragAndDropComplete(LxComponent[] lxComponentArray) {
        LxAbstractGraph lxAbstractGraph = this.getGraph();
        if (lxComponentArray.length > this.getGraph()._selectingManyObjectsLimit) {
            this.getGraph()._selectingManyObjects = true;
        }
        int n = 0;
        while (n < lxComponentArray.length) {
            if (this.getEditMode() == 2) {
                lxComponentArray[n].setSelected(true);
            }
            ++n;
        }
        this.getGraph()._selectingManyObjects = false;
    }

    private void firePropertyChange2(String string, Object object, Object object2) {
        this.firePropertyChange(string, object, object2);
    }

    private LxHandle _getHandleAt(int n, int n2, LxComponent[] lxComponentArray) {
        double d = this.getZoomFactor();
        double d2 = this.getSelectionDistance();
        double d3 = d2 * 2.0 + 1.0;
        double d4 = (double)n - d2;
        double d5 = (double)n2 - d2;
        Rectangle2DDouble rectangle2DDouble = new Rectangle2DDouble();
        Rectangle2DDouble rectangle2DDouble2 = new Rectangle2DDouble();
        int n3 = lxComponentArray.length - 1;
        while (n3 >= 0) {
            LxComponent lxComponent = lxComponentArray[n3];
            if (this.onVisibleLayer(lxComponent)) {
                lxComponent.getBounds2D(rectangle2DDouble2);
                double d6 = lxComponent.isZoomable() ? d : 1.0;
                double d7 = lxComponent.getWidth() * d6;
                double d8 = lxComponent.getHeight() * d6;
                double d9 = lxComponent.getCenterX() * d;
                double d10 = lxComponent.getCenterY() * d;
                int n4 = lxComponent.getHandleCount();
                int n5 = 0;
                while (n5 < n4) {
                    LxHandle lxHandle = lxComponent.getHandle(n5);
                    double d11 = lxHandle.getSize();
                    if (lxHandle._isCurrentlyVisible()) {
                        ((Rectangle2D)rectangle2DDouble).setRect(d9 + d7 * lxHandle.getCenterX() - d11 / 2.0, d10 + d8 * lxHandle.getCenterY() - d11 / 2.0, d11, d11);
                        rectangle2DDouble2.add(rectangle2DDouble);
                    }
                    ++n5;
                }
                if (rectangle2DDouble2.intersects(d4, d5, d3, d3)) {
                    double d12 = d4 - d9;
                    double d13 = d5 - d10;
                    int n6 = 0;
                    while (n6 < n4) {
                        LxHandle lxHandle = lxComponent.getHandle(n6);
                        if (lxHandle._isCurrentlyVisible() && lxHandle._isCurrentlyVisible() && lxHandle.intersects(d12 - d7 * lxHandle.getCenterX(), d13 - d8 * lxHandle.getCenterY(), d3, d3)) {
                            return lxHandle;
                        }
                        ++n6;
                    }
                }
            }
            --n3;
        }
        return null;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this._print_data == null) {
            if (n >= 1) {
                return 1;
            }
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        } else if (!this._print_data.transformGraphics2DForPage(graphics2D, n)) {
            return 1;
        }
        this.paint(graphics2D);
        return 0;
    }

    public void repaint(Rectangle rectangle) {
        if (this.getVisibleRect().intersects(rectangle)) {
            super.repaint(rectangle);
        }
    }

    public void paintImmediately() {
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        Rectangle rectangle = repaintManager.getDirtyRegion(this);
        this.paintImmediately(rectangle);
        repaintManager.markCompletelyClean(this);
    }

    public void setAnimationOptimized(boolean bl) {
        this._animationOptimized = bl;
    }

    public boolean isAnimationOptimized() {
        return this._animationOptimized;
    }

    public void setXORMode(Graphics graphics) {
        Color color = this.getBackground();
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if (n < 150 && n2 < 150 && n3 < 150 || n + n2 + n3 < 450) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.setXORMode(color);
    }

    public boolean isSelectionDisplayed() {
        return this._selectionDisplayed;
    }

    public void setSelectionDisplayed(boolean bl) {
        if (bl != this._selectionDisplayed) {
            this._selectionDisplayed = bl;
            if (this.getGraph().getSelectedObjectCount() != 0) {
                this.repaint();
            }
        }
    }

    private void setPaletteBehavior(boolean bl) {
        this._paletteBehavior = bl;
    }

    private boolean getPaletteBehavior() {
        return this._paletteBehavior;
    }

    public static final void paintComponents(LxContainer lxContainer, Graphics2D graphics2D, LxLayers lxLayers, double d) {
        LxAbstractView._paintElements(lxContainer, graphics2D, lxLayers, d, false, true);
    }

    public void cleanUp() {
        this._cleanedUp = true;
        this._edit_mode = null;
        if (this._graph != null) {
            this._graph.cleanUp();
        }
        this._graph = null;
        this._user_modify = true;
        this._link_handles = null;
        this._zoom = null;
        this._select_dist = null;
        this._layers = null;
        this._bg_paint = null;
        this._lasso = null;
        this._popup = null;
        if (this._drop_site != null) {
            this._drop_site.cleanUp();
        }
        this._drop_site = null;
        this._drag_site = null;
        this._hints = null;
        this._actions = null;
        this._print_data = null;
        this._grid = null;
        this._basicStroke = null;
    }

    public void addEnterLeaveListener(LxEnterLeaveListener lxEnterLeaveListener) {
        if (this._enterLeaveListeners == null) {
            this._enterLeaveListeners = new Vector();
        }
        this._enterLeaveListeners.add(lxEnterLeaveListener);
    }

    public void removeEnterLeaveListener(LxEnterLeaveListener lxEnterLeaveListener) {
        this._enterLeaveListeners.remove(lxEnterLeaveListener);
        if (this._enterLeaveListeners.size() == 0) {
            this._enterLeaveListeners = null;
        }
    }

    public void fireEntered(LxMouseEvent lxMouseEvent) {
        if (this._enterLeaveListeners == null || this._enterLeaveListeners.size() == 0) {
            return;
        }
        int n = this._enterLeaveListeners.size();
        int n2 = 0;
        while (n2 < n) {
            LxEnterLeaveListener lxEnterLeaveListener = (LxEnterLeaveListener)this._enterLeaveListeners.get(n2);
            lxEnterLeaveListener.mouseEntered(lxMouseEvent);
            ++n2;
        }
    }

    public void fireExited(LxMouseEvent lxMouseEvent) {
        if (this._enterLeaveListeners == null || this._enterLeaveListeners.size() == 0) {
            return;
        }
        int n = this._enterLeaveListeners.size();
        int n2 = 0;
        while (n2 < n) {
            LxEnterLeaveListener lxEnterLeaveListener = (LxEnterLeaveListener)this._enterLeaveListeners.get(n2);
            lxEnterLeaveListener.mouseExited(lxMouseEvent);
            ++n2;
        }
    }

    public void activateEnterLeaveNotification(boolean bl) {
        this._activateEnterLeave = bl;
        if (bl) {
            if (this._enterLeaveListener == null) {
                this._enterLeaveListener = new MouseMotionAdapter(){
                    private LxComponent _enterLeaveComponent;

                    public void mouseMoved(MouseEvent mouseEvent) {
                        int n;
                        int n2 = mouseEvent.getX();
                        LxComponent lxComponent = LxAbstractView.this.getLxComponentAt(n2, n = mouseEvent.getY());
                        if (lxComponent != null && this._enterLeaveComponent == null && lxComponent != this._enterLeaveComponent) {
                            this._enterLeaveComponent = lxComponent;
                            LxMouseEvent lxMouseEvent = new LxMouseEvent(LxAbstractView.this, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n, 0, false, this._enterLeaveComponent, n2, n, 0.0, 0.0);
                            this._enterLeaveComponent.fireEntered(lxMouseEvent);
                            LxAbstractView.this.fireEntered(lxMouseEvent);
                        } else if ((lxComponent == null || lxComponent != this._enterLeaveComponent) && this._enterLeaveComponent != null) {
                            LxMouseEvent lxMouseEvent = new LxMouseEvent(LxAbstractView.this, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n, 0, false, this._enterLeaveComponent, n2, n, 0.0, 0.0);
                            this._enterLeaveComponent.fireExited(lxMouseEvent);
                            LxAbstractView.this.fireExited(lxMouseEvent);
                            this._enterLeaveComponent = null;
                        }
                    }
                };
                this.addMouseMotionListener(this._enterLeaveListener);
            }
        } else {
            this.removeMouseMotionListener(this._enterLeaveListener);
            this._enterLeaveListener = null;
        }
    }

    public boolean isEnterLeaveNotificationActivated() {
        return this._activateEnterLeave;
    }

    public void setPrintingThreaded(boolean bl) {
        this._printingThreaded = bl;
    }

    public boolean isPrintingThreaded() {
        return this._printingThreaded;
    }

    static /* synthetic */ MagneticGrid access$3800(LxAbstractView lxAbstractView) {
        return lxAbstractView._grid;
    }

    static /* synthetic */ boolean access$3900(LxAbstractView lxAbstractView) {
        return lxAbstractView._draggingHandlesVisible;
    }

    static /* synthetic */ Graph access$4000(LxAbstractView lxAbstractView) {
        return lxAbstractView._graph;
    }

    static /* synthetic */ LxHandle access$5000(LxAbstractView lxAbstractView, int n, int n2, LxComponent[] lxComponentArray) {
        return lxAbstractView._getHandleAt(n, n2, lxComponentArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class ZoomRelativeAction
    extends LxAbstractAction {
        private static final String ACTION = "zoom-action";
        private static final String ZOOM_OUT_STR = "zoom-actionZoomOutLabel";
        private static final String ZOOM_IN_STR = "zoom-actionZoomInLabel";
        private static final String ZOOM_FACTOR_TIP = "zoom-actionZoomFactorTooltip";
        final double _factor;

        public ZoomRelativeAction(String string, double d) {
            super(string, null, null, null, true);
            this._factor = d;
            this.setOriginalLabel(d < 1.0 ? Resources.get(ZOOM_OUT_STR, "Zoom out") : Resources.get(ZOOM_IN_STR, "Zoom in"));
            this.setOriginalTooltip(Resources.get(ZOOM_FACTOR_TIP, "Zoom the graph by a factor of") + " " + (int)(d * 100.0) + "%");
            this.setOriginalIcon(d < 1.0 ? Resources.getURL("com/loox/jloox/images/zoomout.gif") : Resources.getURL("com/loox/jloox/images/zoom.gif"));
        }

        public void processAction(ActionEvent actionEvent) {
            double d = LxAbstractView.this.getZoomFactor() * this._factor;
            LxAbstractView.this.setZoomFactor(d);
        }
    }

    private final class ZoomAbsoluteAction
    extends LxAbstractToggleAction {
        private static final String ACTION = "zoom-action";
        private static final String ZOOM_BY_TIP = "zoom-actionZoomByTooltip";
        private static final String ZOOM_OUT_STR = "zoom-actionZoomOutLabel";
        private static final String ZOOM_IN_STR = "zoom-actionZoomInLabel";
        private static final String ZOOM_FACTOR_TIP = "zoom-actionZoomFactorTooltip";
        final double _factor;

        public ZoomAbsoluteAction(String string, double d) {
            super(string, null, null, null, null, null, null, false, true);
            this._factor = d;
            if (d == LxAbstractView.this.getZoomFactor()) {
                this.setState(true);
            }
            String string2 = NumberFormat.getPercentInstance().format(d);
            this.setOriginalLabel(string2);
            this.setOriginalTooltip(Resources.get(ZOOM_BY_TIP, "Zoom the current graph by") + " " + string2);
            this.setToggleLabel(this.getOriginalLabel());
            this.setToggleTooltip(this.getOriginalTooltip());
        }

        public void processAction(ActionEvent actionEvent) {
            double d = this._factor;
            LxAbstractView.this.setZoomFactor(d);
            this.setState(true);
        }
    }

    private final class ZoomLinesAction
    extends LxAbstractToggleAction {
        ZoomLinesAction() {
            super(LxAbstractView.ZOOM_LINES_ACTION, "Zoom lines", "Disables zoom lines", null, "Zoom lines", "Enables zoom lines", null, true, true);
            this.setState(LxAbstractView.this.getZoomLines());
        }

        public void processAction(ActionEvent actionEvent) {
            Object object = LxAbstractView.this.getRenderingHint(KEY_ZOOMABLE_LINES);
            LxAbstractView.this.setRenderingHint(KEY_ZOOMABLE_LINES, object.equals(VALUE_ZOOM_LINES_ON) ? VALUE_ZOOM_LINES_OFF : VALUE_ZOOM_LINES_ON);
        }
    }

    private final class Zoom {
        private double _val = 1.0;

        private Zoom() {
        }

        public void set(double d, boolean bl) {
            if (d == this._val) {
                return;
            }
            if (d <= 0.0) {
                throw new IllegalArgumentException("zoom factor <= 0");
            }
            boolean bl2 = LxAbstractView.this.isRefreshEnabled();
            LxAbstractView.this.setRefreshEnabled(false);
            double d2 = this._val;
            this._val = d;
            Enumeration enumeration = LxAbstractView.this._actions._hash.elements();
            while (enumeration.hasMoreElements()) {
                LxAbstractAction lxAbstractAction = (LxAbstractAction)enumeration.nextElement();
                if (!(lxAbstractAction instanceof ZoomAbsoluteAction)) continue;
                ZoomAbsoluteAction zoomAbsoluteAction = (ZoomAbsoluteAction)lxAbstractAction;
                zoomAbsoluteAction.setState(zoomAbsoluteAction._factor == d);
            }
            if (bl) {
                double d3 = d / d2;
                Dimension dimension = LxAbstractView.this.getPreferredSize();
                dimension.setSize((int)(dimension.getWidth() * d3), (int)(dimension.getHeight() * d3));
                LxAbstractView.this.setPreferredSize(dimension);
                LxAbstractView.this.setMinimumSize(dimension);
                LxAbstractView.this.setMaximumSize(dimension);
                LxAbstractView.this.setSize(dimension);
                if (LxAbstractView.this.getParent() instanceof JViewport) {
                    JViewport jViewport = (JViewport)LxAbstractView.this.getParent();
                    try {
                        ((JViewport)LxAbstractView.this.getParent()).setScrollMode(0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (jViewport.getParent() instanceof JScrollPane) {
                        LxComponent[] lxComponentArray;
                        JScrollPane jScrollPane = (JScrollPane)jViewport.getParent();
                        jScrollPane.doLayout();
                        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                        JScrollBar jScrollBar2 = jScrollPane.getHorizontalScrollBar();
                        if (jScrollBar != null) {
                            jScrollBar.setValueIsAdjusting(true);
                        }
                        if (jScrollBar2 != null) {
                            jScrollBar2.setValueIsAdjusting(true);
                        }
                        if ((lxComponentArray = (LxComponent[])LxAbstractView.this.getGraph().getSelectedObjects()) != null && lxComponentArray.length > 0) {
                            Rectangle2D rectangle2D = lxComponentArray[0].getBounds2D();
                            int n = 1;
                            while (n < lxComponentArray.length) {
                                rectangle2D.add(lxComponentArray[n].getBounds2D());
                                ++n;
                            }
                            Dimension dimension2 = jViewport.getSize();
                            rectangle2D.setRect(d * rectangle2D.getX(), d * rectangle2D.getY(), d * rectangle2D.getWidth(), d * rectangle2D.getHeight());
                            int n2 = (int)(rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - dimension2.getWidth() / 2.0);
                            int n3 = (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - dimension2.getHeight() / 2.0);
                            jViewport.setViewPosition(new Point(n2, n3));
                        } else {
                            Point point = jViewport.getViewPosition();
                            Dimension dimension3 = jViewport.getSize();
                            Rectangle2D.Double double_ = new Rectangle2D.Double();
                            ((Rectangle2D)double_).setRect(point.getX() * d3, point.getY() * d3, dimension3.getWidth() * d3, dimension3.getHeight() * d3);
                            int n = (int)(((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() / 2.0 - dimension3.getWidth() / 2.0);
                            int n4 = (int)(((RectangularShape)double_).getY() + ((RectangularShape)double_).getHeight() / 2.0 - dimension3.getHeight() / 2.0);
                            jViewport.setViewPosition(new Point(n, n4));
                        }
                        if (jScrollBar != null) {
                            jScrollBar.setValueIsAdjusting(false);
                            jScrollBar.setUnitIncrement(10);
                        }
                        if (jScrollBar2 != null) {
                            jScrollBar2.setValueIsAdjusting(false);
                            jScrollBar2.setUnitIncrement(10);
                        }
                    }
                    try {
                        ((JViewport)LxAbstractView.this.getParent()).setScrollMode(1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            LxAbstractView.this.firePropertyChange2("zoom", new Double(d2), new Double(this._val));
            LxAbstractView.this.repaint();
            LxAbstractView.this.setRefreshEnabled(bl2);
        }
    }

    private final class ToggleModeAction
    extends LxAbstractToggleAction {
        ToggleModeAction() {
            super(LxAbstractView.TOGGLE_MODE_ACTION, "Test Mode", "Enter test mode.", "com/loox/jloox/images/test.gif", "Edit Mode", "Enter edit mode.", "com/loox/jloox/images/edit.gif", true, true);
            this.setState(LxAbstractView.this.getEditMode() == 2);
        }

        public void processAction(ActionEvent actionEvent) {
            int n;
            int n2 = n = LxAbstractView.this.getEditMode() == 1 ? 2 : 1;
            if (n == 1) {
                LxAbstractView.this.getGraph().unselectAll();
            }
            LxAbstractView.this.setEditMode(n);
        }
    }

    private final class SelectionDistance {
        private int _val = 2;

        private SelectionDistance() {
        }

        public void set(int n) {
            if (n == this._val) {
                return;
            }
            if (n < 0) {
                throw new IllegalArgumentException("selection distance < 0");
            }
            this._val = n;
        }
    }

    private final class SelectAllAction
    extends LxAbstractAction {
        SelectAllAction() {
            super(LxAbstractView.SELECT_ALL_ACTION, "Select All", "Select all objects in view", null, true);
        }

        public void processAction(ActionEvent actionEvent) {
            LxAbstractView.this.getGraph().selectAll();
        }
    }

    public final class PrintData {
        private AffineTransform _transform;
        private int _nb_page_x;
        private int _nb_page_y;
        private Rectangle2D _view_bounds;
        private Rectangle2D _print_bounds;
        private Rectangle2D _print_clip;
        private PageFormat _page;

        public PrintData(Rectangle2D rectangle2D, PageFormat pageFormat, Rectangle2D rectangle2D2) {
            double d;
            double d2;
            double d3;
            if (rectangle2D == null) {
                this._view_bounds = LxAbstractView.this.computeBounds();
                d3 = LxAbstractView.this.getZoomFactor();
                d2 = this._view_bounds.getX();
                d = this._view_bounds.getY();
                if (d2 >= 0.0) {
                    d2 *= 2.0;
                }
                if (d >= 0.0) {
                    d *= 2.0;
                }
                this._view_bounds.setRect(0.0, 0.0, (this._view_bounds.getWidth() + d2) / d3, (this._view_bounds.getHeight() + d) / d3);
                if (this._view_bounds.isEmpty()) {
                    double d4 = Math.max(this._view_bounds.getWidth(), this._view_bounds.getHeight());
                    if (d4 == 0.0) {
                        d4 = 100.0;
                    }
                    this._view_bounds.setRect(0.0, 0.0, d4, d4);
                }
            } else {
                this._view_bounds = rectangle2D;
            }
            this._page = pageFormat == null ? new PageFormat() : pageFormat;
            this._print_bounds = rectangle2D2 == null ? new Rectangle2DDouble(0.0, 0.0, this._page.getImageableWidth(), this._page.getImageableHeight()) : rectangle2D2;
            if (this._print_bounds.getWidth() * this._view_bounds.getHeight() < this._print_bounds.getHeight() * this._view_bounds.getWidth()) {
                d3 = this._print_bounds.getWidth() / this._view_bounds.getWidth();
                d2 = d3 * this._view_bounds.getHeight();
                d = 0.5 * (this._print_bounds.getHeight() - d2);
                this._print_bounds.setRect(this._print_bounds.getX(), this._print_bounds.getY() + d, this._print_bounds.getWidth(), d2);
            } else {
                d3 = this._print_bounds.getHeight() / this._view_bounds.getHeight();
                d2 = d3 * this._view_bounds.getWidth();
                d = 0.5 * (this._print_bounds.getWidth() - d2);
                this._print_bounds.setRect(this._print_bounds.getX() + d, this._print_bounds.getY(), d2, this._print_bounds.getHeight());
            }
            this._transform = new AffineTransform();
            this._transform.translate(this._page.getImageableX() + this._print_bounds.getX(), this._page.getImageableY() + this._print_bounds.getY());
            this._transform.scale(d3 / LxAbstractView.this.getZoomFactor(), d3 / LxAbstractView.this.getZoomFactor());
            this._transform.translate(-this._view_bounds.getX(), -this._view_bounds.getY());
            this._nb_page_x = (int)Math.ceil((this._print_bounds.getX() + this._print_bounds.getWidth()) / this._page.getImageableWidth() - 0.005);
            this._nb_page_y = (int)Math.ceil((this._print_bounds.getY() + this._print_bounds.getHeight()) / this._page.getImageableHeight() - 0.005);
            if (this._nb_page_x == 0) {
                this._nb_page_x = 1;
            }
            if (this._nb_page_y == 0) {
                this._nb_page_y = 1;
            }
            this._print_clip = new Rectangle2DDouble(this._print_bounds.getX() + this._page.getImageableX(), this._print_bounds.getY() + this._page.getImageableY(), this._print_bounds.getWidth(), this._print_bounds.getHeight());
        }

        public int getPageCount() {
            return this._nb_page_x * this._nb_page_y;
        }

        public int getHorizontalPageCount() {
            return this._nb_page_x;
        }

        public int getVerticalPageCount() {
            return this._nb_page_y;
        }

        public PageFormat getPageFormat() {
            return this._page;
        }

        public Rectangle2D getPrintBounds() {
            return this._print_bounds;
        }

        public Rectangle2D getViewBounds() {
            return this._view_bounds;
        }

        boolean transformGraphics2DForPage(Graphics2D graphics2D, int n) {
            if (n < 0 || n >= this._nb_page_x * this._nb_page_y) {
                return false;
            }
            int n2 = n % this._nb_page_x;
            int n3 = n / this._nb_page_x;
            graphics2D.transform(new AffineTransform(this._page.getMatrix()));
            graphics2D.translate((double)(-n2) * this._page.getImageableWidth(), (double)(-n3) * this._page.getImageableHeight());
            graphics2D.clip(this._print_clip);
            graphics2D.transform(this._transform);
            return true;
        }
    }

    private final class PrintAction
    extends LxAbstractAction
    implements Runnable {
        private PrintDialog _dialog = null;
        private Thread _thread = null;

        PrintAction() {
            super(LxAbstractView.PRINT_ACTION, "Print...", "Print this view", "com/loox/jloox/images/print.gif", true);
        }

        public void processAction(ActionEvent actionEvent) {
            LxAbstractView.this.getGraph().unselectAll();
            if (this._dialog != null) {
                this._dialog.show();
                return;
            }
            this._dialog = new PrintDialog(this, LxAbstractView.this){
                private final /* synthetic */ PrintAction this$1;
                {
                    this.this$1 = printAction;
                }

                public void doPrint() {
                    if (PrintAction.access$5700(this.this$1) == null) {
                        PrintAction.access$5702(this.this$1, new Thread(this.this$1));
                        PrintAction.access$5700(this.this$1).setPriority(1);
                        PrintAction.access$5700(this.this$1).setName("Printing view at " + PrintAction.access$5800(this.this$1).getZoomFactor() + "%");
                        if (PrintAction.access$5800(this.this$1).isPrintingThreaded()) {
                            PrintAction.access$5700(this.this$1).start();
                        } else {
                            PrintAction.access$5700(this.this$1).run();
                        }
                    }
                }
            };
            this._dialog.setLocationRelativeTo(JOptionPane.getFrameForComponent(LxAbstractView.this));
            this._dialog.show();
        }

        public void run() {
            LxAbstractView.this._print_data = this._dialog.getPrintData();
            PageFormat pageFormat = (PageFormat)LxAbstractView.this._print_data.getPageFormat().clone();
            pageFormat.setOrientation(1);
            PrinterJob printerJob = this._dialog.getPrintJob();
            printerJob.setPrintable(LxAbstractView.this, pageFormat);
            if (printerJob.printDialog()) {
                boolean bl = LxAbstractView.this.isDoubleBuffered();
                LxAbstractView.this.setDoubleBuffered(false);
                boolean bl2 = false;
                try {
                    Class.forName("com.loox.gis.jloox.LxGisLxView");
                    if (LxAbstractView.this instanceof LxGisLxView) {
                        bl2 = ((LxGisLxView)LxAbstractView.this).isTripleBuffered();
                        try {
                            ((LxGisLxView)LxAbstractView.this).setTripleBuffered(false);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    printerJob.print();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    Class.forName("com.loox.gis.jloox.LxGisLxView");
                    if (LxAbstractView.this instanceof LxGisLxView) {
                        try {
                            ((LxGisLxView)LxAbstractView.this).setTripleBuffered(bl2);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LxAbstractView.this.setDoubleBuffered(bl);
            }
            this._thread = null;
        }

        static /* synthetic */ Thread access$5700(PrintAction printAction) {
            return printAction._thread;
        }

        static /* synthetic */ Thread access$5702(PrintAction printAction, Thread thread) {
            printAction._thread = thread;
            return printAction._thread;
        }

        static /* synthetic */ LxAbstractView access$5800(PrintAction printAction) {
            return printAction.LxAbstractView.this;
        }
    }

    private final class Popup {
        private JPopupMenu _val = null;

        public Popup() {
            LxAbstractView.this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Popup this$1;
                {
                    this.this$1 = popup;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger() && !Popup.access$5500(this.this$1).isInteractivelyCreating()) {
                        LxComponent lxComponent = Popup.access$5500(this.this$1).getLxComponentAt(mouseEvent.getX(), mouseEvent.getY());
                        if (lxComponent != null) {
                            if (Popup.access$5500(this.this$1).getEditMode() == 2) {
                                Popup.access$5500(this.this$1).getGraph().unselectAll();
                                lxComponent.setSelected(true);
                            }
                            lxComponent._fireMousePopup(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
                        } else if (Popup.access$5600(this.this$1) != null) {
                            Lx.showPopupMenu(Popup.access$5600(this.this$1), mouseEvent);
                        }
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.mousePressed(mouseEvent);
                }
            });
        }

        public void set(JPopupMenu jPopupMenu) {
            if (this._val == jPopupMenu) {
                return;
            }
            this._val = jPopupMenu;
        }

        static /* synthetic */ LxAbstractView access$5500(Popup popup) {
            return popup.LxAbstractView.this;
        }
    }

    private class MouseInput
    extends MouseInputAdapter {
        private boolean _added = false;
        LxComponent _comp = null;
        int _dir = 0;
        int _x = 0;
        int _y = 0;
        int _x0 = 0;
        int _y0 = 0;
        LxHandle _handle = null;
        boolean _eraseOld = true;

        private MouseInput() {
        }

        public void add(int n, int n2, LxHandle lxHandle) {
            this.add(n, n2);
            this._handle = lxHandle;
        }

        public void add(int n, int n2, LxComponent lxComponent) {
            this.add(n, n2);
            this._comp = lxComponent;
        }

        void _draw() {
        }

        public void add(int n, int n2) {
            this._added = true;
            this._x = n;
            this._y = n2;
            this._x0 = n;
            this._y0 = n2;
            this._dir = 0;
            LxAbstractView.this.addMouseListener(this);
            LxAbstractView.this.addMouseMotionListener(this);
        }

        public void remove() {
            if (this._added) {
                this._added = false;
                this._handle = null;
                this._comp = null;
                LxAbstractView.this.removeMouseListener(this);
                LxAbstractView.this.removeMouseMotionListener(this);
            }
        }
    }

    private final class MagneticGrid {
        private int _gx = 4;
        private int _gy = 4;
        private boolean _enabled = false;
        private boolean _visible = true;
        private Color _color = Color.lightGray;
        private Paint _paint = null;
        private int _gridDisplayPolicy = 0;

        private MagneticGrid() {
        }

        public double applyUnzoomedX(double d) {
            if (this.isEnabled() && this._gx > 0) {
                int n = (int)d % this._gx;
                int n2 = (int)d / this._gx;
                if (n >= this._gx / 2) {
                    ++n2;
                }
                return n2 * this._gx;
            }
            return d;
        }

        public double applyUnzoomedY(double d) {
            if (this.isEnabled() && this._gy > 0) {
                int n = (int)d % this._gy;
                int n2 = (int)d / this._gy;
                if (n >= this._gy / 2) {
                    ++n2;
                }
                return n2 * this._gy;
            }
            return d;
        }

        public double applyX(double d) {
            double d2 = LxAbstractView.this.getZoomFactor();
            return d2 * this.applyUnzoomedX(d / d2);
        }

        public double applyY(double d) {
            double d2 = LxAbstractView.this.getZoomFactor();
            return d2 * this.applyUnzoomedY(d / d2);
        }

        private void _createPaint() {
            Object object;
            Transparency transparency;
            int n = Math.max(64 - 64 % this._gx, this._gx);
            int n2 = Math.max(64 - 64 % this._gy, this._gy);
            if (LxAbstractView.this.getBackgroundPaint() != null && LxAbstractView.this.getBackgroundPaint() instanceof TexturePaint) {
                transparency = (TexturePaint)LxAbstractView.this.getBackgroundPaint();
                object = ((TexturePaint)transparency).getImage();
                n = ((BufferedImage)object).getWidth() - ((BufferedImage)object).getWidth() % this._gx;
                n2 = ((BufferedImage)object).getHeight() - ((BufferedImage)object).getHeight() % this._gy;
            }
            transparency = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(n, n2, 1);
            object = ((BufferedImage)transparency).createGraphics();
            ((Graphics2D)object).setPaint(LxAbstractView.this.getBackgroundPaint());
            ((Graphics)object).fillRect(0, 0, n, n2);
            ((Graphics)object).setColor(this._color);
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    ((Graphics)object).drawLine(n3, n4, n3, n4);
                    n4 += this._gy;
                }
                n3 += this._gx;
            }
            ((Graphics)object).dispose();
            this._paint = new TexturePaint((BufferedImage)transparency, new Rectangle(0, 0, n, n2));
        }

        public void draw(Graphics2D graphics2D) {
            if (this._gridDisplayPolicy == 0) {
                if (this._paint == null) {
                    this._createPaint();
                }
                Paint paint = graphics2D.getPaint();
                Rectangle rectangle = graphics2D.getClipBounds();
                graphics2D.setPaint(this._paint);
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
                graphics2D.setPaint(paint);
            } else {
                Paint paint = graphics2D.getPaint();
                Paint paint2 = LxAbstractView.this.getBackgroundPaint();
                Rectangle rectangle = graphics2D.getClipBounds();
                graphics2D.setPaint(paint2);
                if (paint2 instanceof Color) {
                    graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    graphics2D.fill(new Rectangle2DDouble(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight()));
                }
                graphics2D.setPaint(this._color);
                int n = (int)rectangle.getY();
                int n2 = (int)rectangle.getX();
                n2 -= n2 % this._gx;
                while ((double)n2 <= rectangle.getX() + rectangle.getWidth()) {
                    graphics2D.drawLine(n2, n, n2, n + (int)rectangle.getHeight());
                    n2 += this._gx;
                }
                n2 = (int)rectangle.getX();
                n = (int)rectangle.getY();
                n -= n % this._gy;
                while ((double)n <= rectangle.getY() + rectangle.getHeight()) {
                    graphics2D.drawLine(n2, n, n2 + (int)rectangle.getWidth(), n);
                    n += this._gy;
                }
                graphics2D.setPaint(paint);
            }
        }

        public int getDisplayPolicy() {
            return this._gridDisplayPolicy;
        }

        public void setDisplayPolicy(int n) {
            this._gridDisplayPolicy = n;
            if (this.isEnabled() && LxAbstractView.this.isVisible()) {
                LxAbstractView.this.repaint();
            }
        }

        public void set(int n, int n2) {
            if (this._gx == n && this._gy == n2) {
                return;
            }
            this._gx = n;
            this._gy = n2;
            this._paint = null;
            if (this.isEnabled() && this._visible) {
                LxAbstractView.this.repaint();
            }
        }

        public void setEnabled(boolean bl) {
            if (this._enabled == bl) {
                return;
            }
            boolean bl2 = this.isEnabled();
            this._enabled = bl;
            if (this.isEnabled() != bl2 && this._visible) {
                LxAbstractView.this.repaint();
            }
        }

        public void setVisible(boolean bl) {
            if (this._visible == bl) {
                return;
            }
            this._visible = bl;
            if (this.isEnabled()) {
                LxAbstractView.this.repaint();
            }
        }

        public void setColor(Color color) {
            if (color == this._color || this._color.equals(color)) {
                return;
            }
            this._color = color;
            this._paint = null;
            if (this.isEnabled() && this._visible) {
                LxAbstractView.this.repaint();
            }
        }

        public boolean isEnabled() {
            if (this._gx <= 0 && this._gy <= 0) {
                return false;
            }
            return this._enabled;
        }
    }

    private final class LinkHandles {
        private boolean _val = false;

        private LinkHandles() {
        }

        public void set(boolean bl) {
            if (bl == this._val) {
                return;
            }
            LxComponent[] lxComponentArray = LxAbstractView.this.getGraph().getComponents();
            if (bl) {
                int n = 0;
                while (n < lxComponentArray.length) {
                    LxHandle[] lxHandleArray = lxComponentArray[n].getHandles();
                    int n2 = 0;
                    while (n2 < lxHandleArray.length) {
                        LxHandle lxHandle = lxHandleArray[n2];
                        lxHandle._setCurrentlyVisible(lxHandle.isLinkable());
                        ++n2;
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < lxComponentArray.length) {
                    LxHandle[] lxHandleArray = lxComponentArray[n].getHandles();
                    int n3 = 0;
                    while (n3 < lxHandleArray.length) {
                        LxHandle lxHandle = lxHandleArray[n3];
                        lxHandle._setCurrentlyVisible(lxHandle.isVisible());
                        ++n3;
                    }
                    ++n;
                }
            }
            this._val = bl;
        }
    }

    public final class LayerVisDialogAction
    extends LxAbstractAction
    implements LxConstants {
        private static final String ACTION = "layer-visibility-dialog";
        private static final String DIALOG_TITLE = "layer-visibility-dialogTitle";
        private static final String DIALOG_MESSAGE = "layer-visibility-dialogMessage";
        private static final String DIALOG_VISIBILITY_STR = "layer-visibility-dialogVisibilityLabel";
        private static final String DIALOG_SETALL_STR = "layer-visibility-dialogSetallLabel";
        private static final String DIALOG_UNSETALL_STR = "layer-visibility-dialogUnsetallLabel";
        private static final String DIALOG_SETSEL_STR = "layer-visibility-dialogSetselectedLabel";
        private static final String DIALOG_UNSETSEL_STR = "layer-visibility-dialogUnsetselectedLabel";
        private static final String DIALOG_APPLY_STR = "layer-visibility-dialogApplyLabel";
        private static final String DIALOG_CLOSE_STR = "layer-visibility-dialogCloseLabel";
        private static final String DIALOG_HEADER_1 = "layer-visibility-dialogHeader1Label";
        private static final String DIALOG_HEADER_2 = "layer-visibility-dialogHeader2Label";
        private LxLayers _layers;
        private DialogFrame _dialog = null;
        private JButton _focusButton = null;
        private Object[][] data;
        private TableModel dataModel;
        private JTable tableView;

        public LayerVisDialogAction() {
            super("layer-visibility-dialog", "Displayed layers...", "Dialog for controling active layers in view", "com/loox/jloox/images/layer_display.gif", true);
        }

        public void processAction(ActionEvent actionEvent) {
            JButton jButton;
            if (this._dialog != null) {
                this._dialog.show();
                this._focusButton.requestFocus();
                return;
            }
            this._layers = LxAbstractView.this.getLayers();
            String[] stringArray = new String[]{Resources.get(DIALOG_HEADER_1, "Layer name"), Resources.get(DIALOG_HEADER_2, "Visible")};
            this.data = new Object[256][2];
            int n = 0;
            while (n < 256) {
                this.data[n][0] = this._layers.getLayerName(n);
                this.data[n][1] = new Boolean(this._layers.getLayer(n));
                ++n;
            }
            this.dataModel = new AbstractTableModel(this, stringArray){
                static /* synthetic */ Class class$java$lang$String;
                static /* synthetic */ Class class$java$lang$Boolean;
                private final /* synthetic */ String[] val$names;
                private final /* synthetic */ LayerVisDialogAction this$1;
                {
                    this.this$1 = layerVisDialogAction;
                    this.val$names = stringArray;
                }

                public int getColumnCount() {
                    return this.val$names.length;
                }

                public int getRowCount() {
                    return LayerVisDialogAction.access$5100(this.this$1).length;
                }

                public Object getValueAt(int n, int n2) {
                    return LayerVisDialogAction.access$5100(this.this$1)[n][n2];
                }

                public String getColumnName(int n) {
                    return this.val$names[n];
                }

                public Class getColumnClass(int n) {
                    return this.getValueAt(0, n).getClass();
                }

                public boolean isCellEditable(int n, int n2) {
                    return this.getColumnClass(n2) == (class$java$lang$String == null ? (class$java$lang$String = 17.class$("java.lang.String")) : class$java$lang$String) || this.getColumnClass(n2) == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = 17.class$("java.lang.Boolean")) : class$java$lang$Boolean);
                }

                public void setValueAt(Object object, int n, int n2) {
                    LayerVisDialogAction.access$5100((LayerVisDialogAction)this.this$1)[n][n2] = object;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            };
            this.tableView = new JTable(this.dataModel);
            this.tableView.setRowHeight(20);
            this.tableView.getColumnModel().getColumn(1).setResizable(true);
            this.tableView.getColumnModel().getColumn(1).setPreferredWidth(1);
            JScrollPane jScrollPane = new JScrollPane(this.tableView);
            this._dialog = new DialogFrame(LxAbstractView.this, Resources.get(DIALOG_TITLE, "Layer Visibility"), false);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
            jPanel.add((Component)new JLabel(Resources.get(DIALOG_MESSAGE, "Choose visible layers for view:")), "North");
            jPanel.add((Component)jScrollPane, "Center");
            this._dialog.getContentPane().add((Component)jPanel, "Center");
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu(Resources.get(DIALOG_VISIBILITY_STR, "Visibility"));
            jMenuBar.add(jMenu);
            JMenuItem jMenuItem = new JMenuItem(Resources.get(DIALOG_SETSEL_STR, "Set selected"));
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayerVisDialogAction this$1;
                {
                    this.this$1 = layerVisDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 0;
                    while (n < 256) {
                        if (LayerVisDialogAction.access$5200(this.this$1).isCellSelected(n, 1)) {
                            LayerVisDialogAction.access$5300(this.this$1).setValueAt(new Boolean(true), n, 1);
                        }
                        ++n;
                    }
                    LayerVisDialogAction.access$5200(this.this$1).repaint();
                }
            });
            JMenuItem jMenuItem2 = new JMenuItem(Resources.get(DIALOG_UNSETSEL_STR, "Unset selected"));
            jMenu.add(jMenuItem2);
            jMenuItem2.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayerVisDialogAction this$1;
                {
                    this.this$1 = layerVisDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 0;
                    while (n < 256) {
                        if (LayerVisDialogAction.access$5200(this.this$1).isCellSelected(n, 1)) {
                            LayerVisDialogAction.access$5300(this.this$1).setValueAt(new Boolean(false), n, 1);
                        }
                        ++n;
                    }
                    LayerVisDialogAction.access$5200(this.this$1).repaint();
                }
            });
            jMenu.add(new JSeparator());
            JMenuItem jMenuItem3 = new JMenuItem(Resources.get(DIALOG_SETALL_STR, "Set all"));
            jMenu.add(jMenuItem3);
            jMenuItem3.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayerVisDialogAction this$1;
                {
                    this.this$1 = layerVisDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 0;
                    while (n < 256) {
                        LayerVisDialogAction.access$5300(this.this$1).setValueAt(new Boolean(true), n, 1);
                        ++n;
                    }
                    LayerVisDialogAction.access$5200(this.this$1).repaint();
                }
            });
            JMenuItem jMenuItem4 = new JMenuItem(Resources.get(DIALOG_UNSETALL_STR, "Unset all"));
            jMenu.add(jMenuItem4);
            jMenuItem4.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayerVisDialogAction this$1;
                {
                    this.this$1 = layerVisDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 0;
                    while (n < 256) {
                        LayerVisDialogAction.access$5300(this.this$1).setValueAt(new Boolean(false), n, 1);
                        ++n;
                    }
                    LayerVisDialogAction.access$5200(this.this$1).repaint();
                }
            });
            this._dialog.setJMenuBar(jMenuBar);
            JPanel jPanel2 = new JPanel(true);
            JButton jButton2 = new JButton(Resources.get(DIALOG_APPLY_STR, "Apply"));
            jPanel2.add(jButton2);
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayerVisDialogAction this$1;
                {
                    this.this$1 = layerVisDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1._apply();
                }
            });
            this._dialog.getRootPane().setDefaultButton(jButton2);
            this._focusButton = jButton = new JButton(Resources.get(DIALOG_CLOSE_STR, "Close"));
            jPanel2.add(jButton);
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LayerVisDialogAction this$1;
                {
                    this.this$1 = layerVisDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    LayerVisDialogAction.access$5400(this.this$1).setVisible(false);
                    LayerVisDialogAction.access$5402(this.this$1, null);
                }
            });
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ LayerVisDialogAction this$1;
                {
                    this.this$1 = layerVisDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    LayerVisDialogAction.access$5400(this.this$1).setVisible(false);
                    LayerVisDialogAction.access$5402(this.this$1, null);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke('\u001b');
            jPanel.registerKeyboardAction(actionListener, keyStroke, 2);
            this._dialog.getContentPane().add((Component)jPanel2, "South");
            this._dialog.pack();
            this._dialog.setSize(250, 350);
            this._dialog.center();
            this._dialog.show();
            this._focusButton.requestFocus();
        }

        protected void _apply() {
            int n = 0;
            while (n < 256) {
                this._layers.setLayerName(n, (String)this.dataModel.getValueAt(n, 0));
                this._layers.setLayer(n, (Boolean)this.dataModel.getValueAt(n, 1));
                ++n;
            }
            LxAbstractView.this.setLayers(this._layers);
        }

        protected void _update() {
            int n;
            if (LxAbstractView.this.getGraph() == null || this.dataModel == null || this.tableView == null) {
                return;
            }
            LxComponent[] lxComponentArray = LxAbstractView.this.getGraph().getUnlockedSelectedObjects();
            int[] nArray = new int[256];
            int n2 = 0;
            while (n2 < lxComponentArray.length) {
                n = 0;
                while (n < 256) {
                    if (lxComponentArray[n2].getLayer(n)) {
                        int n3 = n;
                        nArray[n3] = nArray[n3] + 1;
                    }
                    ++n;
                }
                ++n2;
            }
            int n4 = lxComponentArray.length;
            n = 0;
            while (n < 256) {
                this.dataModel.setValueAt(this._layers.getLayerName(n), n, 0);
                ++n;
            }
            if (n4 > 0) {
                int n5 = 0;
                while (n5 < 256) {
                    if (nArray[n5] << 1 >= n4) {
                        this.dataModel.setValueAt(new Boolean(true), n5, 1);
                    } else {
                        this.dataModel.setValueAt(new Boolean(false), n5, 1);
                    }
                    ++n5;
                }
            }
            if (this.tableView != null) {
                this.tableView.repaint();
            }
        }

        static /* synthetic */ Object[][] access$5100(LayerVisDialogAction layerVisDialogAction) {
            return layerVisDialogAction.data;
        }

        static /* synthetic */ JTable access$5200(LayerVisDialogAction layerVisDialogAction) {
            return layerVisDialogAction.tableView;
        }

        static /* synthetic */ TableModel access$5300(LayerVisDialogAction layerVisDialogAction) {
            return layerVisDialogAction.dataModel;
        }

        static /* synthetic */ DialogFrame access$5400(LayerVisDialogAction layerVisDialogAction) {
            return layerVisDialogAction._dialog;
        }

        static /* synthetic */ DialogFrame access$5402(LayerVisDialogAction layerVisDialogAction, DialogFrame dialogFrame) {
            layerVisDialogAction._dialog = dialogFrame;
            return layerVisDialogAction._dialog;
        }
    }

    private final class Layers {
        private final LxLayers _val = new LxLayers();

        private Layers() {
        }

        public boolean intersects(LxComponent lxComponent) {
            return lxComponent.isOnLayer(this._val);
        }

        public void set(int n, boolean bl) {
            if (this._val.getLayer(n) == bl) {
                return;
            }
            this._val.setLayer(n, bl);
            LxAbstractView.this.repaint();
        }

        public void set(LxLayers lxLayers) {
            if (this._val.equals(lxLayers)) {
                return;
            }
            this._val.setLayers(lxLayers);
            LxAbstractView.this.repaint();
        }
    }

    private final class Lasso {
        private boolean _displayed = true;
        private boolean _on = false;
        private boolean _resize_multiple = true;
        private Cursor _cursor = null;
        private LxElement.InteractiveCreation _creation_lstnr = null;
        private Rectangle2D _original_size = null;
        private int _x_click = 0;
        private int _y_click = 0;
        private final KeyStroke _esc_key_stroke = KeyStroke.getKeyStroke('\u001b');
        private final ActionListener _esc_key_action = new ActionListener(this){
            private final /* synthetic */ Lasso this$1;
            {
                this.this$1 = lasso;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$1.stopCreation(null);
            }
        };
        private final CreationListeners _lstnrs = new CreationListeners();
        private final MouseInput _band_lstnr = new MouseInput(this){
            private int _last_x;
            private int _last_y;
            private Graphics _graphics;
            private final /* synthetic */ Lasso this$1;
            {
                this.this$1 = lasso;
                this._last_x = 0;
                this._last_y = 0;
                this._graphics = null;
            }

            public void add(int n, int n2) {
                super.add(n, n2);
                this._last_x = n;
                this._last_y = n2;
                this._graphics = null;
                this._draw();
                this._eraseOld = true;
            }

            void _draw() {
                if (!Lasso.access$3700(this.this$1)) {
                    return;
                }
                if (this._graphics == null) {
                    this._graphics = Lasso.access$3600(this.this$1).getGraphics();
                    Lasso.access$3600(this.this$1).setXORMode(this._graphics);
                }
                Rectangle rectangle = this._getBand();
                this._graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }

            private Rectangle _getBand() {
                int n = this._last_x - this._x;
                int n2 = this._last_y - this._y;
                int n3 = n >= 0 ? this._x : this._x + n;
                int n4 = n2 >= 0 ? this._y : this._y + n2;
                return new Rectangle(n3, n4, Math.abs(n), Math.abs(n2));
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                JViewport jViewport;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (Lasso.access$3600(this.this$1).getParent() instanceof JViewport && (jViewport = (JViewport)Lasso.access$3600(this.this$1).getParent()).getParent() instanceof JScrollPane) {
                    Point point = jViewport.getViewPosition();
                    Dimension dimension = jViewport.getExtentSize();
                    Point point2 = new Point(point);
                    Dimension dimension2 = Lasso.access$3600(this.this$1).getSize();
                    if ((double)n < point.getX()) {
                        point2.x = (int)((double)point2.x - (point.getX() - (double)n));
                        if (point2.x < 0) {
                            point2.x = 0;
                        }
                    } else if ((double)n > point.getX() + dimension.getWidth()) {
                        point2.x = (int)((double)point2.x + ((double)n - (point.getX() + dimension.getWidth())));
                        if ((double)point2.x + dimension.getWidth() > dimension2.getWidth()) {
                            point2.x = (int)(dimension2.getWidth() - dimension.getWidth());
                        }
                    }
                    if ((double)n2 < point.getY()) {
                        point2.y = (int)((double)point2.y - (point.getY() - (double)n2));
                        if (point2.y < 0) {
                            point2.y = 0;
                        }
                    } else if ((double)n2 > point.getY() + dimension.getHeight()) {
                        point2.y = (int)((double)point2.y + ((double)n2 - (point.getY() + dimension.getHeight())));
                        if ((double)point2.y + dimension.getHeight() > dimension2.getHeight()) {
                            point2.y = (int)(dimension2.getHeight() - dimension.getHeight());
                        }
                    }
                    if (!point2.equals(point)) {
                        if (this._eraseOld) {
                            // empty if block
                        }
                        jViewport.setViewPosition(point2);
                        this._graphics = null;
                        this._last_x = mouseEvent.getX();
                        this._last_y = mouseEvent.getY();
                        return;
                    }
                }
                if (this._eraseOld) {
                    this._draw();
                }
                this._last_x = mouseEvent.getX();
                this._last_y = mouseEvent.getY();
                this._draw();
                this._eraseOld = true;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (this._eraseOld) {
                    this._draw();
                }
                this.remove();
                if (Lasso.access$3700(this.this$1)) {
                    Lasso.access$3600(this.this$1).select(this._getBand());
                }
                this._graphics = null;
            }
        };
        private final MouseInput _drag_lstnr = new MouseInput(this){
            private final /* synthetic */ Lasso this$1;
            {
                this.this$1 = lasso;
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (mouseEvent.getX() == this._x && mouseEvent.getY() == this._y) {
                    return;
                }
                if ((mouseEvent.getModifiers() & 0x10) == 0 || (mouseEvent.getModifiers() & 2) != 0) {
                    return;
                }
                if (this._comp == null) {
                    return;
                }
                double d = Lasso.access$3600(this.this$1).getZoomFactor();
                double d2 = (double)(mouseEvent.getX() - this._x) / d;
                double d3 = (double)(mouseEvent.getY() - this._y) / d;
                if ((mouseEvent.getModifiers() & 1) != 0) {
                    if (this._dir == 1) {
                        d3 = 0.0;
                    } else if (this._dir == 2) {
                        d2 = 0.0;
                    } else if (Math.abs(mouseEvent.getX() - this._x0) > Math.abs(mouseEvent.getY() - this._y0)) {
                        this._dir = 1;
                        d3 = 0.0;
                    } else {
                        this._dir = 2;
                        d2 = 0.0;
                    }
                }
                if (LxAbstractView.access$3800(Lasso.access$3600(this.this$1)).isEnabled()) {
                    double d4 = LxAbstractView.access$3800(Lasso.access$3600(this.this$1)).applyUnzoomedX(this._comp.getX() + d2);
                    d2 = d4 - this._comp.getX();
                    if (d2 != 0.0) {
                        this._x += (int)(d2 * d);
                    }
                    if ((d3 = (d4 = LxAbstractView.access$3800(Lasso.access$3600(this.this$1)).applyUnzoomedY(this._comp.getY() + d3)) - this._comp.getY()) != 0.0) {
                        this._y += (int)(d3 * d);
                    }
                } else {
                    this._x = mouseEvent.getX();
                    this._y = mouseEvent.getY();
                }
                if (Lasso.access$3600(this.this$1).getEditMode() == 2) {
                    JViewport jViewport;
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    if (!LxAbstractView.access$3900(Lasso.access$3600(this.this$1))) {
                        Lasso.access$3600((Lasso)this.this$1)._drawSelection = false;
                    }
                    Lasso.access$3600(this.this$1).getGraph().dragSelection((double)mouseEvent.getX() / d, (double)mouseEvent.getY() / d, d2, d3);
                    if (Lasso.access$3600(this.this$1).getParent() instanceof JViewport && (jViewport = (JViewport)Lasso.access$3600(this.this$1).getParent()).getParent() instanceof JScrollPane) {
                        Point point = jViewport.getViewPosition();
                        Dimension dimension = jViewport.getExtentSize();
                        Point point2 = new Point(point);
                        Dimension dimension2 = Lasso.access$3600(this.this$1).getSize();
                        if ((double)n < point.getX()) {
                            point2.x = (int)((double)point2.x - (point.getX() - (double)n));
                            if (point2.x < 0) {
                                point2.x = 0;
                            }
                        } else if ((double)n > point.getX() + dimension.getWidth()) {
                            point2.x = (int)((double)point2.x + ((double)n - (point.getX() + dimension.getWidth())));
                            if ((double)point2.x + dimension.getWidth() > dimension2.getWidth()) {
                                point2.x = (int)(dimension2.getWidth() - dimension.getWidth());
                            }
                        }
                        if ((double)n2 < point.getY()) {
                            point2.y = (int)((double)point2.y - (point.getY() - (double)n2));
                            if (point2.y < 0) {
                                point2.y = 0;
                            }
                        } else if ((double)n2 > point.getY() + dimension.getHeight()) {
                            point2.y = (int)((double)point2.y + ((double)n2 - (point.getY() + dimension.getHeight())));
                            if ((double)point2.y + dimension.getHeight() > dimension2.getHeight()) {
                                point2.y = (int)(dimension2.getHeight() - dimension.getHeight());
                            }
                        }
                        if (!point2.equals(point)) {
                            jViewport.setViewPosition(point2);
                        }
                    }
                }
                this._comp._fireMouseDragged(mouseEvent, (double)mouseEvent.getX() / d, (double)mouseEvent.getY() / d, d2, d3);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!LxAbstractView.access$3900(Lasso.access$3600(this.this$1))) {
                    Lasso.access$3600((Lasso)this.this$1)._drawSelection = true;
                    LxAbstractView.access$4000(Lasso.access$3600(this.this$1)).forceRepaint((LxComponent[])Lasso.access$3600(this.this$1).getGraph().getSelectedObjects());
                }
                if (this._comp == null) {
                    return;
                }
                double d = Lasso.access$3600(this.this$1).getZoomFactor();
                this._comp._fireMouseReleased(mouseEvent, (double)mouseEvent.getX() / d, (double)mouseEvent.getY() / d);
                if (mouseEvent.getClickCount() == 2) {
                    this._comp._fireMouseDoubleClicked(mouseEvent, (double)mouseEvent.getX() / d, (double)mouseEvent.getY() / d);
                } else if ((mouseEvent.getModifiers() & 1) != 0 && Lasso.access$4100(this.this$1) == mouseEvent.getX() && Lasso.access$4200(this.this$1) == mouseEvent.getY() && this._comp.isSelected()) {
                    this._comp.setSelected(false);
                }
                if (Lasso.access$4300(this.this$1) != null) {
                    Lasso.access$3600(this.this$1).setCursor(Lasso.access$4300(this.this$1));
                }
                Lasso.access$4302(this.this$1, null);
                this.remove();
            }
        };
        private final MouseInput _resize_lstnr = new MouseInput(this){
            private final /* synthetic */ Lasso this$1;
            {
                this.this$1 = lasso;
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                double d;
                if (mouseEvent.getX() == this._x && mouseEvent.getY() == this._y) {
                    return;
                }
                if (this._handle == null) {
                    return;
                }
                LxComponent lxComponent = this._handle.getComponent();
                double d2 = Lasso.access$3600(this.this$1).getZoomFactor();
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if ((mouseEvent.getModifiers() & 1) != 0) {
                    if (this._dir == 1) {
                        n2 = this._y0;
                    } else if (this._dir == 2) {
                        n = this._x0;
                    } else if (Math.abs(mouseEvent.getX() - this._x0) > Math.abs(mouseEvent.getY() - this._y0)) {
                        this._dir = 1;
                        n2 = this._y0;
                    } else {
                        this._dir = 2;
                        n = this._x0;
                    }
                }
                this._handle._fireDragged(Lasso.access$3600(this.this$1), mouseEvent, LxAbstractView.access$3800(Lasso.access$3600(this.this$1)).applyUnzoomedX((double)n / d2) - (double)this._x / d2, LxAbstractView.access$3800(Lasso.access$3600(this.this$1)).applyUnzoomedY((double)n2 / d2) - (double)this._y / d2);
                double d3 = lxComponent.getCenterX();
                double d4 = lxComponent.getCenterY();
                double d5 = lxComponent.getWidth();
                double d6 = lxComponent.getHeight();
                double d7 = this._handle.getCenterX();
                if (Double.isNaN(d7)) {
                    d7 = 0.0;
                }
                if (Double.isNaN(d = this._handle.getCenterY())) {
                    d = 0.0;
                }
                if (d2 == 1.0 || lxComponent.isZoomable()) {
                    this._x = (int)((d3 + d7 * d5) * d2);
                    this._y = (int)((d4 + d * d6) * d2);
                } else {
                    this._x = (int)(lxComponent.getCenterX() * d2 + this._handle.getCenterX() * lxComponent.getWidth());
                    this._y = (int)(lxComponent.getCenterY() * d2 + this._handle.getCenterY() * lxComponent.getHeight());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (this._handle != null) {
                    this._handle._fireReleased(Lasso.access$3600(this.this$1), mouseEvent);
                    LxComponent lxComponent = this._handle.getComponent();
                    if (lxComponent != null && Lasso.access$4400(this.this$1)) {
                        Rectangle2D rectangle2D = lxComponent.getBounds2D();
                        double d = rectangle2D.getWidth() / Lasso.access$4500(this.this$1).getWidth();
                        double d2 = rectangle2D.getHeight() / Lasso.access$4500(this.this$1).getHeight();
                        double d3 = rectangle2D.getX() - Lasso.access$4500(this.this$1).getX();
                        double d4 = rectangle2D.getY() - Lasso.access$4500(this.this$1).getY();
                        d3 = 0.0;
                        d4 = 0.0;
                        LxComponent[] lxComponentArray = (LxComponent[])Lasso.access$3600(this.this$1).getGraph().getSelectedObjects();
                        int n = 0;
                        while (n < lxComponentArray.length) {
                            LxComponent lxComponent2 = lxComponentArray[n];
                            if (lxComponent2 != lxComponent && !lxComponent2.isLocked() && !(lxComponent2 instanceof LxAbstractLink)) {
                                d3 = Lasso.access$4500(this.this$1).getX() - lxComponent2.getX();
                                d4 = Lasso.access$4500(this.this$1).getY() - lxComponent2.getY();
                                d3 *= d;
                                d4 *= d2;
                                if (lxComponent2.isUserMovable()) {
                                    lxComponent2.setLocation(rectangle2D.getX() - d3, rectangle2D.getY() - d4);
                                }
                                if (lxComponent2.isUserResizable() && !(lxComponent2 instanceof LxNotResizable)) {
                                    lxComponent2.setSize(lxComponent2.getWidth() * d, lxComponent2.getHeight() * d2);
                                }
                            }
                            ++n;
                        }
                        Lasso.access$3600(this.this$1).getGraph().finishUndoEdit();
                    }
                    if (lxComponent != null && mouseEvent.getClickCount() == 2) {
                        double d = Lasso.access$3600(this.this$1).getZoomFactor();
                        lxComponent._fireMouseDoubleClicked(mouseEvent, (double)mouseEvent.getX() / d, (double)mouseEvent.getY() / d);
                    }
                }
                Lasso.access$3600(this.this$1).setCursor(Lasso.access$4300(this.this$1));
                Lasso.access$4302(this.this$1, null);
                this.remove();
            }
        };
        private final MouseAdapter _start_lstnr = new MouseAdapter(this){
            private final /* synthetic */ Lasso this$1;
            {
                this.this$1 = lasso;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (MouseInput.access$4700(Lasso.access$4600(this.this$1)) || MouseInput.access$4700(Lasso.access$4800(this.this$1)) || MouseInput.access$4700(Lasso.access$4900(this.this$1))) {
                    return;
                }
                LxComponent lxComponent = null;
                LxHandle lxHandle = null;
                double d = Lasso.access$3600(this.this$1).getZoomFactor();
                Lasso.access$4102(this.this$1, mouseEvent.getX());
                Lasso.access$4202(this.this$1, mouseEvent.getY());
                if (Lasso.access$3600(this.this$1).getEditMode() == 1) {
                    lxComponent = Lasso.access$3600(this.this$1).getLxComponentAt(mouseEvent.getX(), mouseEvent.getY());
                    if (lxComponent != null && lxComponent.isSensitive()) {
                        lxComponent._fireMousePressed(mouseEvent, (double)mouseEvent.getX() / d, (double)mouseEvent.getY() / d);
                        Lasso.access$4600(this.this$1).add(mouseEvent.getX(), mouseEvent.getY(), lxComponent);
                    }
                    return;
                }
                if ((mouseEvent.getModifiers() & 0x10) == 0 || (mouseEvent.getModifiers() & 2) != 0 && (mouseEvent.getModifiers() & 1) == 0) {
                    return;
                }
                LxComponent[] lxComponentArray = (LxComponent[])Lasso.access$3600(this.this$1).getGraph().getSelectedObjects();
                if (lxComponentArray.length > 0 && (lxHandle = LxAbstractView.access$5000(Lasso.access$3600(this.this$1), mouseEvent.getX(), mouseEvent.getY(), lxComponentArray)) != null) {
                    lxComponent = lxHandle.getComponent();
                    lxHandle._firePressed(Lasso.access$3600(this.this$1), mouseEvent);
                }
                if (lxComponent == null) {
                    lxComponent = Lasso.access$3600(this.this$1).getLxComponentAt(mouseEvent.getX(), mouseEvent.getY());
                }
                if ((mouseEvent.getModifiers() & 1) != 0 && (mouseEvent.getModifiers() & 2) != 0) {
                    Lasso.access$4800(this.this$1).add(mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                if ((mouseEvent.getModifiers() & 1) == 0) {
                    if (lxComponent == null || !lxComponent.isSelected()) {
                        if (lxComponentArray.length > Lasso.access$3600((Lasso)this.this$1).getGraph()._selectingManyObjectsLimit) {
                            Lasso.access$3600((Lasso)this.this$1).getGraph()._selectingManyObjects = true;
                        }
                        int n = 0;
                        while (n < lxComponentArray.length) {
                            LxComponent lxComponent2;
                            lxComponent2.setSelected((lxComponent2 = lxComponentArray[n]) == lxComponent);
                            ++n;
                        }
                        Lasso.access$3600((Lasso)this.this$1).getGraph()._selectingManyObjects = false;
                    }
                    Lasso.access$4102(this.this$1, 0);
                    Lasso.access$4202(this.this$1, 0);
                }
                if (lxComponent != null) {
                    if (!lxComponent.isSelected()) {
                        Lasso.access$4102(this.this$1, 0);
                        Lasso.access$4202(this.this$1, 0);
                    }
                    lxComponent.setSelected(true);
                    if (lxComponent.isLocked() || (mouseEvent.getModifiers() & 2) != 0) {
                        return;
                    }
                    Lasso.access$4302(this.this$1, Lasso.access$3600(this.this$1).getCursor());
                    if (lxHandle != null && lxHandle.isResize() && lxComponent.isUserResizable()) {
                        Cursor cursor = lxHandle.getFlyoverCursor();
                        Lasso.access$3600(this.this$1).setCursor(cursor != null ? cursor : Lasso.access$4300(this.this$1));
                        Lasso.access$3600(this.this$1).getGraph().startUndoEdit(Resources.get("reshapeUndo", "reshape"));
                        Lasso.access$4900(this.this$1).add(mouseEvent.getX(), mouseEvent.getY(), lxHandle);
                        Lasso.access$4502(this.this$1, lxComponent.getBounds2D());
                    } else {
                        if (lxComponent.isUserMovable()) {
                            Lasso.access$3600(this.this$1).setCursor(Cursor.getPredefinedCursor(13));
                        }
                        lxComponent._fireMousePressed(mouseEvent, (double)mouseEvent.getX() / d, (double)mouseEvent.getY() / d);
                        Lasso.access$4600(this.this$1).add(mouseEvent.getX(), mouseEvent.getY(), lxComponent);
                    }
                } else {
                    Lasso.access$4800(this.this$1).add(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };

        private Lasso() {
        }

        public boolean isCreating() {
            return this._creation_lstnr != null;
        }

        public boolean isDisplayed() {
            return this._displayed;
        }

        public void off() {
            if (this._on) {
                LxAbstractView.this.removeMouseListener(this._start_lstnr);
                this._band_lstnr.remove();
                this._drag_lstnr.remove();
                this.stopCreation(null);
                this._on = false;
            }
        }

        public void on() {
            if (LxAbstractView.this.getEditMode() == 3) {
                return;
            }
            if (!this._on) {
                this._on = true;
                LxAbstractView.this.addMouseListener(this._start_lstnr);
            }
        }

        public void setDisplayed(boolean bl) {
            if (this._displayed == bl) {
                return;
            }
            this._displayed = bl;
        }

        public void setResizeMultiple(boolean bl) {
            this._resize_multiple = bl;
        }

        public void startCreation(LxElement.InteractiveCreation interactiveCreation) {
            if (this.isCreating()) {
                this.stopCreation(null);
            }
            if (!this._on || this.isCreating()) {
                this._lstnrs.fireCreated(null);
                return;
            }
            if (this._on) {
                this.off();
            }
            LxAbstractView.this.registerKeyboardAction(this._esc_key_action, this._esc_key_stroke, 2);
            LxAbstractView.this.getGraph().unselectAll();
            this._cursor = LxAbstractView.this.getCursor();
            LxAbstractView.this.setCursor(Cursor.getPredefinedCursor(1));
            this._creation_lstnr = interactiveCreation;
            this._creation_lstnr.start();
        }

        public void stopCreation(LxElement lxElement) {
            if (!this.isCreating()) {
                return;
            }
            this.on();
            this._creation_lstnr.stop();
            this._creation_lstnr = null;
            LxAbstractView.this.setCursor(this._cursor);
            this._cursor = null;
            LxAbstractView.this.unregisterKeyboardAction(this._esc_key_stroke);
            this._lstnrs.fireCreated(lxElement);
            if (lxElement != null) {
                LxLayers lxLayers = LxAbstractView.this._layers._val;
                if (lxLayers != null && !lxLayers.isEmpty()) {
                    lxElement.setLayers(LxAbstractView.this.getLayers());
                }
                lxElement.setSelected(true);
            }
        }

        static /* synthetic */ LxAbstractView access$3600(Lasso lasso) {
            return lasso.LxAbstractView.this;
        }

        static /* synthetic */ boolean access$3700(Lasso lasso) {
            return lasso._displayed;
        }

        static /* synthetic */ int access$4100(Lasso lasso) {
            return lasso._x_click;
        }

        static /* synthetic */ int access$4200(Lasso lasso) {
            return lasso._y_click;
        }

        static /* synthetic */ Cursor access$4300(Lasso lasso) {
            return lasso._cursor;
        }

        static /* synthetic */ Cursor access$4302(Lasso lasso, Cursor cursor) {
            lasso._cursor = cursor;
            return lasso._cursor;
        }

        static /* synthetic */ Rectangle2D access$4500(Lasso lasso) {
            return lasso._original_size;
        }

        static /* synthetic */ MouseInput access$4600(Lasso lasso) {
            return lasso._drag_lstnr;
        }

        static /* synthetic */ MouseInput access$4900(Lasso lasso) {
            return lasso._resize_lstnr;
        }

        static /* synthetic */ int access$4102(Lasso lasso, int n) {
            lasso._x_click = n;
            return lasso._x_click;
        }

        static /* synthetic */ int access$4202(Lasso lasso, int n) {
            lasso._y_click = n;
            return lasso._y_click;
        }

        static /* synthetic */ Rectangle2D access$4502(Lasso lasso, Rectangle2D rectangle2D) {
            lasso._original_size = rectangle2D;
            return lasso._original_size;
        }
    }

    private final class Hints {
        private RenderingHints _val = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);

        Hints() {
            if (KEY_ZOOMABLE_LINES == null) {
                int n = 1000;
                while (n < 10000) {
                    try {
                        KEY_ZOOMABLE_LINES = new BooleanKey(n);
                        break;
                    }
                    catch (Exception exception) {
                        ++n;
                    }
                }
            }
            this._val.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this._val.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            this._val.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this._val.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            this._val.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this._val.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            this._val.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            if (KEY_ZOOMABLE_LINES != null) {
                this._val.put(KEY_ZOOMABLE_LINES, VALUE_ZOOM_LINES_ON);
            }
        }

        public void set(RenderingHints renderingHints) {
            if (!this._val.equals(renderingHints)) {
                this._val = (RenderingHints)renderingHints.clone();
                this._updateActions();
                LxAbstractView.this.repaint();
            }
        }

        public void set(Object object, Object object2) {
            if (this._val.get(object) != object2) {
                this._val.put(object, object2);
                this._updateActions();
                LxAbstractView.this.repaint();
            }
        }

        private void _updateActions() {
            boolean bl;
            Action action = LxAbstractView.this.getAction(LxAbstractView.ANTIALIAS_ACTION);
            if (action != null) {
                bl = LxAbstractView.this.getRenderingHint(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_ON);
                ((LxAbstractToggleAction)action).setState(bl);
            }
            if ((action = LxAbstractView.this.getAction(LxAbstractView.ZOOM_LINES_ACTION)) != null) {
                bl = LxAbstractView.this.getRenderingHint(KEY_ZOOMABLE_LINES).equals(VALUE_ZOOM_LINES_ON);
                ((LxAbstractToggleAction)action).setState(bl);
            }
        }
    }

    public final class GridDialogAction
    extends LxAbstractAction
    implements LxConstants {
        private static final String ACTION = "grid-dialog";
        private static final String DIALOG_TITLE = "grid-dialogTitle";
        private static final String DIALOG_OPTION1_STR = "grid-dialogOption1Label";
        private static final String DIALOG_OPTION2_STR = "grid-dialogOption2Label";
        private static final String DIALOG_OPTION3_STR = "grid-dialogOption3Label";
        private static final String DIALOG_OK_STR = "grid-dialogOKLabel";
        private static final String DIALOG_CANCEL_STR = "grid-dialogCancelLabel";
        private static final String DIALOG_ERROR_STR = "grid-dialogErrorLabel";
        private static final String DIALOG_ERROR_TITLE = "grid-dialogErrorTitle";
        private static final String DIALOG_SPACING_STR = "grid-dialogSpacingLabel";
        private static final String DIALOG_COLOR_STR = "grid-dialogColorLabel";
        private static final String DIALOG_POLICY1_STR = "grid-dialogPolicy1Label";
        private static final String DIALOG_POLICY2_STR = "grid-dialogPolicy2Label";
        private DialogFrame _dialog = null;
        private JButton _focus = null;
        private boolean _activated = false;
        private boolean _visible = true;
        private JTextField text = null;
        private JRadioButton radio1 = null;
        private JRadioButton radio2 = null;
        private JRadioButton radio3 = null;
        private JButton col = null;
        private JRadioButton radioPol1 = null;
        private JRadioButton radioPol2 = null;
        private boolean _pointsPol = true;

        public GridDialogAction() {
            super("grid-dialog", "Magnetic Grid...", "Dialog for configuring view's magnetic grid", "com/loox/jloox/images/grid.gif", true);
        }

        public void processAction(ActionEvent actionEvent) {
            JButton jButton;
            if (this._dialog != null) {
                this._activated = LxAbstractView.this.isMagneticGridEnabled();
                this._visible = LxAbstractView.this.isMagneticGridVisible();
                this.text.setText(Integer.toString(LxAbstractView.this.getMagneticGridWidth()));
                this.radio1.setSelected(!this._activated);
                this.radio2.setSelected(this._activated && !this._visible);
                this.radio3.setSelected(this._activated && this._visible);
                this.col.setBackground(LxAbstractView.this.getMagneticGridColor());
                this._pointsPol = LxAbstractView.this.getMagneticGridDisplayPolicy() == 0;
                this.radioPol1.setSelected(this._pointsPol);
                this.radioPol2.setSelected(!this._pointsPol);
                this._dialog.show();
                this._focus.requestFocus();
                return;
            }
            this._dialog = new DialogFrame(LxAbstractView.this, Resources.get(DIALOG_TITLE, "Magnetic Grid"), true);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
            this._activated = LxAbstractView.this.isMagneticGridEnabled();
            Box box = new Box(0);
            JLabel jLabel = new JLabel(Resources.get(DIALOG_SPACING_STR, "Grid spacing:"));
            this.text = new JTextField(Integer.toString(LxAbstractView.this.getMagneticGridWidth()), 3);
            this.text.setEnabled(this._activated);
            this.text.setMaximumSize(this.text.getPreferredSize());
            box.add(Box.createHorizontalGlue());
            box.add(jLabel);
            box.add(Box.createHorizontalStrut(20));
            box.add(this.text);
            box.add(Box.createHorizontalGlue());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.radio1 = new JRadioButton(Resources.get(DIALOG_OPTION1_STR, "Not activated"), !this._activated);
            this.radio2 = new JRadioButton(Resources.get(DIALOG_OPTION2_STR, "Activated but not visible"), this._activated && !this._visible);
            this.radio3 = new JRadioButton(Resources.get(DIALOG_OPTION3_STR, "Activated and visible"), this._activated && this._visible);
            buttonGroup.add(this.radio1);
            buttonGroup.add(this.radio2);
            buttonGroup.add(this.radio3);
            jPanel.add(this.radio1);
            jPanel.add(this.radio2);
            jPanel.add(this.radio3);
            this.radio1.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ GridDialogAction this$1;
                {
                    this.this$1 = gridDialogAction;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    GridDialogAction.access$2302(this.this$1, !GridDialogAction.access$2400(this.this$1).isSelected());
                    GridDialogAction.access$2500(this.this$1).setEnabled(GridDialogAction.access$2300(this.this$1));
                }
            });
            this.radio2.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ GridDialogAction this$1;
                {
                    this.this$1 = gridDialogAction;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    GridDialogAction.access$2602(this.this$1, !GridDialogAction.access$2700(this.this$1).isSelected());
                }
            });
            jPanel.add(box);
            Box box2 = new Box(0);
            JLabel jLabel2 = new JLabel(Resources.get(DIALOG_COLOR_STR, "Grid color:"));
            this.col = new JButton(" ");
            this.col.setMaximumSize(this.text.getPreferredSize());
            this.col.setSize(this.text.getPreferredSize());
            this.col.setBackground(LxAbstractView.this.getMagneticGridColor());
            box2.add(Box.createHorizontalGlue());
            box2.add(jLabel2);
            box2.add(Box.createHorizontalStrut(20));
            box2.add(this.col);
            box2.add(Box.createHorizontalGlue());
            this.col.addActionListener(new ActionListener(this){
                private final /* synthetic */ GridDialogAction this$1;
                {
                    this.this$1 = gridDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(GridDialogAction.access$2800(this.this$1).getDialog(), "edit grid color", GridDialogAction.access$2900(this.this$1).getBackground());
                    if (color != null) {
                        GridDialogAction.access$2900(this.this$1).setBackground(color);
                    }
                }
            });
            jPanel.add(box2);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            this.radioPol1 = new JRadioButton(Resources.get(DIALOG_POLICY1_STR, "Display Points"), this._pointsPol);
            this.radioPol2 = new JRadioButton(Resources.get(DIALOG_POLICY2_STR, "Display Lines"), !this._pointsPol);
            buttonGroup2.add(this.radioPol1);
            buttonGroup2.add(this.radioPol2);
            jPanel.add(this.radioPol1);
            jPanel.add(this.radioPol2);
            this.radioPol1.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ GridDialogAction this$1;
                {
                    this.this$1 = gridDialogAction;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    GridDialogAction.access$3002(this.this$1, GridDialogAction.access$3100(this.this$1).isSelected());
                }
            });
            this.radioPol2.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ GridDialogAction this$1;
                {
                    this.this$1 = gridDialogAction;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    GridDialogAction.access$3002(this.this$1, !GridDialogAction.access$3200(this.this$1).isSelected());
                }
            });
            this._dialog.getContentPane().add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel(true);
            JButton jButton2 = new JButton(Resources.get(DIALOG_OK_STR, "OK"));
            jPanel2.add(jButton2);
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ GridDialogAction this$1;
                {
                    this.this$1 = gridDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GridDialogAction.access$2300(this.this$1)) {
                        try {
                            int n = Integer.parseInt(GridDialogAction.access$2500(this.this$1).getText());
                            GridDialogAction.access$3300(this.this$1).setMagneticGridSize(n);
                        }
                        catch (Exception exception) {
                            DialogFrame.showConfirmDialog(JOptionPane.getFrameForComponent(GridDialogAction.access$3300(this.this$1)), Resources.get("grid-dialogErrorLabel", "Invalid grid spacing."), Resources.get("grid-dialogErrorTitle", "Magnetic Grid Error"), -1, 0);
                            return;
                        }
                    }
                    GridDialogAction.access$3300(this.this$1).setMagneticGridEnabled(GridDialogAction.access$2300(this.this$1));
                    GridDialogAction.access$3300(this.this$1).setMagneticGridVisible(GridDialogAction.access$2600(this.this$1));
                    GridDialogAction.access$3300(this.this$1).setMagneticGridColor(GridDialogAction.access$2900(this.this$1).getBackground());
                    if (GridDialogAction.access$3000(this.this$1)) {
                        GridDialogAction.access$3300(this.this$1).setMagneticGridDisplayPolicy(0);
                    } else {
                        GridDialogAction.access$3300(this.this$1).setMagneticGridDisplayPolicy(1);
                    }
                }
            });
            this._dialog.getRootPane().setDefaultButton(jButton2);
            this._focus = jButton = new JButton(Resources.get(DIALOG_CANCEL_STR, "Cancel"));
            jPanel2.add(jButton);
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ GridDialogAction this$1;
                {
                    this.this$1 = gridDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GridDialogAction.access$2800(this.this$1).setVisible(false);
                }
            });
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ GridDialogAction this$1;
                {
                    this.this$1 = gridDialogAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GridDialogAction.access$2800(this.this$1).setVisible(false);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke('\u001b');
            jPanel.registerKeyboardAction(actionListener, keyStroke, 2);
            this._dialog.getContentPane().add((Component)jPanel2, "South");
            this._dialog.pack();
            this._dialog.center();
            this._dialog.show();
            this._focus.requestFocus();
        }

        static /* synthetic */ boolean access$2302(GridDialogAction gridDialogAction, boolean bl) {
            gridDialogAction._activated = bl;
            return gridDialogAction._activated;
        }

        static /* synthetic */ JRadioButton access$2400(GridDialogAction gridDialogAction) {
            return gridDialogAction.radio1;
        }

        static /* synthetic */ boolean access$2300(GridDialogAction gridDialogAction) {
            return gridDialogAction._activated;
        }

        static /* synthetic */ JTextField access$2500(GridDialogAction gridDialogAction) {
            return gridDialogAction.text;
        }

        static /* synthetic */ boolean access$2602(GridDialogAction gridDialogAction, boolean bl) {
            gridDialogAction._visible = bl;
            return gridDialogAction._visible;
        }

        static /* synthetic */ JRadioButton access$2700(GridDialogAction gridDialogAction) {
            return gridDialogAction.radio2;
        }

        static /* synthetic */ DialogFrame access$2800(GridDialogAction gridDialogAction) {
            return gridDialogAction._dialog;
        }

        static /* synthetic */ JButton access$2900(GridDialogAction gridDialogAction) {
            return gridDialogAction.col;
        }

        static /* synthetic */ boolean access$3002(GridDialogAction gridDialogAction, boolean bl) {
            gridDialogAction._pointsPol = bl;
            return gridDialogAction._pointsPol;
        }

        static /* synthetic */ JRadioButton access$3100(GridDialogAction gridDialogAction) {
            return gridDialogAction.radioPol1;
        }

        static /* synthetic */ JRadioButton access$3200(GridDialogAction gridDialogAction) {
            return gridDialogAction.radioPol2;
        }

        static /* synthetic */ LxAbstractView access$3300(GridDialogAction gridDialogAction) {
            return gridDialogAction.LxAbstractView.this;
        }

        static /* synthetic */ boolean access$2600(GridDialogAction gridDialogAction) {
            return gridDialogAction._visible;
        }

        static /* synthetic */ boolean access$3000(GridDialogAction gridDialogAction) {
            return gridDialogAction._pointsPol;
        }
    }

    private final class Graph {
        private LxAbstractGraph _val = null;
        private boolean _rr = true;
        private final ItemListener _item_lstnr = new ItemListener2(this){
            private final /* synthetic */ Graph this$1;
            {
                this.this$1 = graph;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!Graph.access$1400(this.this$1)) {
                    return;
                }
                if (!Graph.access$1500((Graph)this.this$1).getGraph()._selectingManyObjects && Lx.getUseXORForSelection()) {
                    if (Graph.access$1500(this.this$1).getGraphics() != null) {
                        Graph.access$1500(this.this$1).paintSelection((LxComponent)itemEvent.getItem(), (Graphics2D)Graph.access$1500(this.this$1).getGraphics());
                    }
                } else {
                    Graph.access$1500(this.this$1).repaint(Graph.access$1600(this.this$1, (LxComponent)itemEvent.getItem()).getBounds());
                }
            }
        };
        private final LxAppearanceListener _appear_lstnr = new LxAppearanceListener(this){
            private final /* synthetic */ Graph this$1;
            {
                this.this$1 = graph;
            }

            public void componentLayerChanged(LxAppearanceEvent lxAppearanceEvent) {
                boolean bl;
                if (!Graph.access$1400(this.this$1)) {
                    return;
                }
                LxComponent lxComponent = lxAppearanceEvent.getComponent();
                boolean bl2 = Layers.access$1800(LxAbstractView.access$1700(Graph.access$1500(this.this$1))).intersects(lxAppearanceEvent._getOldLayers());
                if (bl2 == (bl = Graph.access$1500(this.this$1).onVisibleLayer(lxComponent))) {
                    return;
                }
                Graph.access$1500(this.this$1).repaint(Graph.access$1600(this.this$1, lxComponent).getBounds());
            }

            public void componentLocationChanged(LxAppearanceEvent lxAppearanceEvent) {
                if (!Graph.access$1400(this.this$1)) {
                    return;
                }
                LxComponent lxComponent = lxAppearanceEvent.getComponent();
                if (!lxComponent.isVisible() || !Graph.access$1500(this.this$1).onVisibleLayer(lxComponent)) {
                    if (lxComponent.isSelected()) {
                        if (Lx.getUseXORForSelection()) {
                            Graphics2D graphics2D = (Graphics2D)Graph.access$1500(this.this$1).getGraphics();
                            if (graphics2D != null) {
                                Graph.access$1500(this.this$1).paintSelection(lxComponent, graphics2D, lxAppearanceEvent.getOldCenter(), lxComponent.getSize());
                                Graph.access$1500(this.this$1).paintSelection(lxComponent, graphics2D);
                            }
                            return;
                        }
                    } else {
                        return;
                    }
                }
                Graph.access$1500(this.this$1).repaint(Graph.access$1600(this.this$1, lxComponent).getBounds());
                Point2D point2D = lxAppearanceEvent.getOldCenter();
                Rectangle2D rectangle2D = lxComponent.getStrokedBounds2D();
                rectangle2D.setRect(rectangle2D.getX() + (point2D.getX() - lxComponent.getCenterX()), rectangle2D.getY() + (point2D.getY() - lxComponent.getCenterY()), rectangle2D.getWidth(), rectangle2D.getHeight());
                Graph.access$1500(this.this$1).repaint(Graph.access$1900(this.this$1, rectangle2D, lxComponent, point2D).getBounds());
            }

            public void componentShapeChanged(LxAppearanceEvent lxAppearanceEvent) {
                if (!Graph.access$1400(this.this$1)) {
                    return;
                }
                LxComponent lxComponent = lxAppearanceEvent.getComponent();
                if (!lxComponent.isVisible() || !Graph.access$1500(this.this$1).onVisibleLayer(lxComponent)) {
                    if (lxComponent.isSelected()) {
                        if (Lx.getUseXORForSelection()) {
                            Graphics2D graphics2D = (Graphics2D)Graph.access$1500(this.this$1).getGraphics();
                            if (graphics2D != null) {
                                Rectangle2D rectangle2D = lxAppearanceEvent._getOldBounds2D();
                                Point2DDouble point2DDouble = new Point2DDouble(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
                                Dimension2DDouble dimension2DDouble = new Dimension2DDouble(rectangle2D.getWidth(), rectangle2D.getHeight());
                                Graph.access$1500(this.this$1).paintSelection(lxComponent, graphics2D, point2DDouble, dimension2DDouble);
                                Graph.access$1500(this.this$1).paintSelection(lxComponent, graphics2D);
                            }
                            return;
                        }
                    } else {
                        return;
                    }
                }
                Rectangle2D rectangle2D = (Rectangle2D)lxAppearanceEvent._getOldBounds2D().clone();
                Point2D.Double double_ = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
                rectangle2D.add(lxAppearanceEvent._getOldStrokedBounds2D());
                Rectangle2D rectangle2D2 = lxComponent.getBounds2D();
                rectangle2D2.add(lxComponent.getStrokedBounds2D());
                if (!rectangle2D2.equals(rectangle2D)) {
                    Graph.access$1500(this.this$1).repaint(Graph.access$1900(this.this$1, rectangle2D, lxComponent, double_).getBounds());
                }
                Graph.access$1500(this.this$1).repaint(Graph.access$2000(this.this$1, rectangle2D2, lxComponent).getBounds());
            }

            public void componentVisibilityChanged(LxAppearanceEvent lxAppearanceEvent) {
                if (!Graph.access$1400(this.this$1)) {
                    return;
                }
                LxComponent lxComponent = lxAppearanceEvent.getComponent();
                if (!Graph.access$1500(this.this$1).onVisibleLayer(lxComponent)) {
                    return;
                }
                Graph.access$1500(this.this$1).repaint(Graph.access$1600(this.this$1, lxComponent).getBounds());
            }

            public void componentVisualChanged(LxAppearanceEvent lxAppearanceEvent) {
                if (!Graph.access$1400(this.this$1)) {
                    return;
                }
                LxComponent lxComponent = lxAppearanceEvent.getComponent();
                if (!Graph.access$1500(this.this$1).onVisibleLayer(lxComponent)) {
                    return;
                }
                Graph.access$1500(this.this$1).repaint(Graph.access$1600(this.this$1, lxComponent).getBounds());
            }

            public void componentZoomableChanged(LxAppearanceEvent lxAppearanceEvent) {
                if (!Graph.access$1400(this.this$1)) {
                    return;
                }
                LxComponent lxComponent = lxAppearanceEvent.getComponent();
                if (!(lxComponent.isVisible() && Graph.access$1500(this.this$1).onVisibleLayer(lxComponent) && lxComponent.getParent() instanceof LxAbstractGraph)) {
                    return;
                }
                Graph.access$1500(this.this$1).repaint(Graph.access$2100(this.this$1, !lxComponent.isZoomable(), lxComponent).getBounds());
                Graph.access$1500(this.this$1).repaint(Graph.access$1600(this.this$1, lxComponent).getBounds());
            }
        };

        private Graph() {
        }

        public void cleanUp() {
            if (this._val != null) {
                this._val.cleanUp();
            }
            this._val = null;
        }

        private boolean _isZoomable(LxComponent lxComponent) {
            LxContainer lxContainer = lxComponent.getParent();
            if (lxContainer instanceof LxAbstractGraph) {
                return lxComponent.isZoomable();
            }
            return this._isZoomable((LxComponent)((Object)lxContainer));
        }

        private Rectangle2D _prepBox(LxComponent lxComponent) {
            return this._prepBox(lxComponent.getStrokedBounds2D(), this._isZoomable(lxComponent), lxComponent, null);
        }

        private Rectangle2D _prepBox(boolean bl, LxComponent lxComponent) {
            return this._prepBox(lxComponent.getStrokedBounds2D(), bl, lxComponent, null);
        }

        private Rectangle2D _prepBox(Rectangle2D rectangle2D, LxComponent lxComponent) {
            return this._prepBox(rectangle2D, this._isZoomable(lxComponent), lxComponent, null);
        }

        private Rectangle2D _prepBox(Rectangle2D rectangle2D, LxComponent lxComponent, Point2D point2D) {
            return this._prepBox(rectangle2D, this._isZoomable(lxComponent), lxComponent, point2D);
        }

        private Rectangle2D _prepBox(Rectangle2D rectangle2D, boolean bl, LxComponent lxComponent, Point2D point2D) {
            Object object;
            LxContainer lxContainer = lxComponent.getParent();
            if (bl) {
                while (lxContainer instanceof LxComponent) {
                    object = (LxComponent)((Object)lxContainer);
                    if (!(object instanceof LxAbstractGroup) && !(((LxComponent)object).getParent() instanceof LxComponent)) {
                        Rectangle2D rectangle2D2 = ((LxComponent)object).getStrokedBounds2D();
                        rectangle2D.setRect(((LxComponent)object).getX(), ((LxComponent)object).getY(), ((LxComponent)object).getWidth(), ((LxComponent)object).getHeight());
                        break;
                    }
                    rectangle2D.setRect(rectangle2D.getX() + ((LxComponent)object).getX(), rectangle2D.getY() + ((LxComponent)object).getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                    lxContainer = ((LxComponent)object).getParent();
                }
            } else {
                object = lxComponent.getParent();
                LxAbstractGroup lxAbstractGroup = null;
                while (object instanceof LxAbstractGroup) {
                    lxAbstractGroup = (LxAbstractGroup)object;
                    object = lxAbstractGroup.getParent();
                }
                if (lxAbstractGroup != null) {
                    Rectangle2D rectangle2D3 = lxAbstractGroup.getStrokedBounds2D();
                    rectangle2D.setRect(rectangle2D3.getX(), rectangle2D3.getY(), rectangle2D3.getWidth(), rectangle2D3.getHeight());
                }
            }
            double d = LxAbstractView.this.getZoomFactor();
            if (d != 1.0 && bl) {
                rectangle2D.setRect(rectangle2D.getX() * d, rectangle2D.getY() * d, rectangle2D.getWidth() * d, rectangle2D.getHeight() * d);
            } else if (d != 1.0) {
                double d2 = rectangle2D.getWidth() / 2.0;
                double d3 = rectangle2D.getHeight() / 2.0;
                if (lxComponent.getParent() instanceof LxAbstractGroup) {
                    double d4 = (rectangle2D.getX() + d2) * d;
                    double d5 = (rectangle2D.getY() + d3) * d;
                    rectangle2D.setRect(d4 - d2, d5 - d3, rectangle2D.getWidth(), rectangle2D.getHeight());
                } else if (point2D != null) {
                    double d6 = point2D.getX() - rectangle2D.getX();
                    double d7 = point2D.getY() - rectangle2D.getY();
                    rectangle2D.setRect(point2D.getX() * d - d6, point2D.getY() * d - d7, rectangle2D.getWidth(), rectangle2D.getHeight());
                } else {
                    double d8 = lxComponent.getCenterX() - rectangle2D.getX();
                    double d9 = lxComponent.getCenterY() - rectangle2D.getY();
                    rectangle2D.setRect(lxComponent.getCenterX() * d - d8, lxComponent.getCenterY() * d - d9, rectangle2D.getWidth(), rectangle2D.getHeight());
                }
            }
            rectangle2D = this._addHandles(rectangle2D, lxComponent, d);
            rectangle2D.setRect(rectangle2D.getX() - 2.0, rectangle2D.getY() - 2.0, rectangle2D.getWidth() + 4.0, rectangle2D.getHeight() + 4.0);
            return rectangle2D;
        }

        private Rectangle2D _addHandles(Rectangle2D rectangle2D, LxComponent lxComponent, double d) {
            if (!lxComponent.isSelected() && Lx.getUseXORForSelection()) {
                return rectangle2D;
            }
            double d2 = Lx.getUseXORForSelection() ? (double)(lxComponent.getMaxHandleSize() / 2) : (double)(lxComponent.getMaxHandleSize() / 2);
            double d3 = d2 * 2.0;
            rectangle2D.setRect(rectangle2D.getX() - d2, rectangle2D.getY() - d2, rectangle2D.getWidth() + d3, rectangle2D.getHeight() + d3);
            return rectangle2D;
        }

        public void set(LxAbstractGraph lxAbstractGraph, boolean bl) {
            if (this._val == lxAbstractGraph) {
                return;
            }
            if (this._val != null) {
                this._val._detach(LxAbstractView.this);
                this._val.removeItemListener(this._item_lstnr);
                this._val.removeAppearanceListener(this._appear_lstnr);
                LxAbstractView.this._lasso.off();
            }
            if (lxAbstractGraph != null) {
                lxAbstractGraph._attach(LxAbstractView.this);
                lxAbstractGraph.addItemListener(this._item_lstnr);
                lxAbstractGraph.addAppearanceListener(this._appear_lstnr);
                if (LxAbstractView.this.getEditMode() == 2 || LxAbstractView.this.getEditMode() == 1) {
                    LxAbstractView.this._lasso.on();
                }
            }
            LxAbstractGraph lxAbstractGraph2 = this._val;
            this._val = lxAbstractGraph;
            if (bl) {
                LxAbstractView.this._actions.setEnabled(lxAbstractGraph != null);
                LxAbstractView.this.firePropertyChange2("graph", lxAbstractGraph2, this._val);
            }
            LxAbstractView.this.repaint();
        }

        public void forceRepaint(LxComponent[] lxComponentArray) {
            int n = lxComponentArray.length;
            if (n > 0) {
                Rectangle2D rectangle2D = this._prepBox(lxComponentArray[0]);
                int n2 = 1;
                while (n2 < n) {
                    rectangle2D.add(this._prepBox(lxComponentArray[n2]));
                    ++n2;
                }
                LxAbstractView.this.repaint(rectangle2D.getBounds());
            }
        }

        public void forceRepaint(LxComponent lxComponent) {
            Rectangle2D rectangle2D = this._prepBox(lxComponent);
            LxAbstractView.this.repaint(rectangle2D.getBounds());
        }

        public void setRecordRegions(boolean bl) {
            this._rr = bl;
        }

        static /* synthetic */ LxAbstractView access$1500(Graph graph) {
            return graph.LxAbstractView.this;
        }

        static /* synthetic */ Rectangle2D access$1600(Graph graph, LxComponent lxComponent) {
            return graph._prepBox(lxComponent);
        }

        static /* synthetic */ Rectangle2D access$1900(Graph graph, Rectangle2D rectangle2D, LxComponent lxComponent, Point2D point2D) {
            return graph._prepBox(rectangle2D, lxComponent, point2D);
        }

        static /* synthetic */ Rectangle2D access$2000(Graph graph, Rectangle2D rectangle2D, LxComponent lxComponent) {
            return graph._prepBox(rectangle2D, lxComponent);
        }

        static /* synthetic */ Rectangle2D access$2100(Graph graph, boolean bl, LxComponent lxComponent) {
            return graph._prepBox(bl, lxComponent);
        }
    }

    private final class EditMode {
        private int _val = 1;

        private EditMode() {
        }

        public void set(int n) {
            if (this._val == n) {
                return;
            }
            if (n != 2 && n != 1 && n != 3) {
                throw new IllegalArgumentException("unknown edit mode");
            }
            this._val = n;
            Action action = LxAbstractView.this.getAction(LxAbstractView.TOGGLE_MODE_ACTION);
            ((LxAbstractToggleAction)action).setState(n == 2);
            boolean bl = n == 2 && LxAbstractView.this.getGraph() != null;
            Enumeration enumeration = LxAbstractView.this._actions._hash.elements();
            while (enumeration.hasMoreElements()) {
                LxAbstractAction lxAbstractAction = (LxAbstractAction)enumeration.nextElement();
                if (!(lxAbstractAction instanceof CreateElementAction) && !(lxAbstractAction instanceof SelectAllAction)) continue;
                lxAbstractAction.setEnabled(bl);
            }
            if (this._val == 3) {
                LxAbstractView.this._lasso.off();
            } else {
                LxAbstractView.this._lasso.on();
            }
        }
    }

    private final class DropSite
    implements DropTargetListener {
        private int _mode = 2;
        private DropTarget _droptarget;

        DropSite() {
            this._droptarget = new DropTarget(LxAbstractView.this, this);
            LxAbstractView.this.setDropTarget(this._droptarget);
        }

        public void cleanUp() {
            this._droptarget = null;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(1);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (this._mode == 3 || this._mode == LxAbstractView.this.getEditMode()) {
                dropTargetDragEvent.acceptDrag(1);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (this._mode == 0 || (this._mode & LxAbstractView.this.getEditMode()) == 0) {
                LxAbstractReference._endDnd();
                dropTargetDropEvent.rejectDrop();
                return;
            }
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(LxTransferable.jlooxFlavor)) {
                    dropTargetDropEvent.acceptDrop(3);
                    LxComponent[] lxComponentArray = (LxComponent[])transferable.getTransferData(LxTransferable.jlooxFlavor);
                    LxAbstractGraph lxAbstractGraph = LxAbstractView.this.getGraph();
                    lxAbstractGraph.unselectAll();
                    Point point = dropTargetDropEvent.getLocation();
                    double d = LxAbstractView.this.getZoomFactor();
                    double d2 = 0.0;
                    double d3 = 0.0;
                    d2 = point.getX() / d;
                    d3 = point.getY() / d;
                    int n = 0;
                    while (n < lxComponentArray.length) {
                        LxComponent lxComponent = lxComponentArray[n];
                        lxComponent.setLocation(lxComponent.getX() + d2, lxComponent.getY() + d3);
                        lxAbstractGraph.add(lxComponent);
                        ++n;
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    LxAbstractView.this.dragAndDropComplete(lxComponentArray);
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
            LxAbstractReference._endDnd();
        }

        public void set(int n) {
            if (n == this._mode) {
                return;
            }
            if (n != 0 && n != 1 && n != 2 && n != 3) {
                throw new IllegalArgumentException("unknown drop mode");
            }
            this._mode = n;
        }
    }

    private final class DragSite
    implements DragGestureListener,
    DragSourceListener {
        final DragSource _ds = DragSource.getDefaultDragSource();
        int _mode = 2;

        DragSite() {
            this._ds.createDefaultDragGestureRecognizer(LxAbstractView.this, 1, this);
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            LxComponent[] lxComponentArray;
            Object object;
            LxComponent[] lxComponentArray2;
            if (this._mode == 0 || (this._mode & LxAbstractView.this.getEditMode()) == 0) {
                return;
            }
            if ((dragGestureEvent.getTriggerEvent().getModifiers() & 1) != 0) {
                return;
            }
            if ((dragGestureEvent.getTriggerEvent().getModifiers() & 2) == 0 && !LxAbstractView.this.getPaletteBehavior()) {
                return;
            }
            if (LxAbstractView.this.getEditMode() == 2) {
                lxComponentArray2 = LxTransferable._copyData((LxComponent[])LxAbstractView.this.getGraph().getSelectedObjects(), false);
                if (lxComponentArray2.length == 0) {
                    return;
                }
            } else {
                object = dragGestureEvent.getTriggerEvent();
                if (object instanceof MouseEvent) {
                    lxComponentArray = (LxComponent[])object;
                    LxComponent lxComponent = LxAbstractView.this.getLxComponentAt(lxComponentArray.getX(), lxComponentArray.getY());
                    if (lxComponent == null || lxComponent instanceof LxAbstractLink) {
                        return;
                    }
                    lxComponentArray2 = new LxComponent[]{lxComponent};
                } else {
                    return;
                }
            }
            if (lxComponentArray2.length > 0) {
                try {
                    object = new LxTransferable(lxComponentArray2);
                    lxComponentArray = (LxComponent[])((LxTransferable)object).getTransferData(LxTransferable.jlooxFlavor);
                    int n = 0;
                    while (n < lxComponentArray.length) {
                        LxAbstractReference._prepareDnD(lxComponentArray[n]);
                        ++n;
                    }
                    lxComponentArray2 = (LxComponent[])((LxTransferable)object).getTransferData(LxTransferable.jlooxFlavor);
                    int n2 = lxComponentArray2.length;
                    Point point = dragGestureEvent.getDragOrigin();
                    double d = LxAbstractView.this.getZoomFactor();
                    double d2 = 0.0;
                    double d3 = 0.0;
                    Rectangle rectangle = lxComponentArray2[0].getBounds();
                    int n3 = 0;
                    while (n3 < n2) {
                        if (lxComponentArray2[n3].isZoomable()) {
                            d2 = point.getX() / d;
                            d3 = point.getY() / d;
                            break;
                        }
                        rectangle.add((Rectangle2D)lxComponentArray2[n3].getBounds());
                        d2 = ((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth() / 2.0;
                        d3 = ((RectangularShape)rectangle).getY() + ((RectangularShape)rectangle).getHeight() / 2.0;
                        ++n3;
                    }
                    int n4 = 0;
                    while (n4 < n2) {
                        LxComponent lxComponent = lxComponentArray2[n4];
                        lxComponent.setLocation(lxComponent.getX() - d2, lxComponent.getY() - d3);
                        ++n4;
                    }
                    this._ds.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, (Transferable)object, this);
                }
                catch (Exception exception) {
                    return;
                }
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void set(int n) {
            if (n == this._mode) {
                return;
            }
            if (n != 0 && n != 1 && n != 2 && n != 3) {
                throw new IllegalArgumentException("unknown drag mode");
            }
            this._mode = n;
        }
    }

    private final class DoubleBufferAction
    extends LxAbstractToggleAction {
        DoubleBufferAction() {
            super(LxAbstractView.DOUBLE_BUFFER_ACTION, "Double Buffer", "Stop double buffering", null, "Double Buffer", "Start double buffering", null, true, true);
            this.setState(LxAbstractView.this.isDoubleBuffered());
        }

        public void processAction(ActionEvent actionEvent) {
            boolean bl = !LxAbstractView.this.isDoubleBuffered();
            this._changeBuffer(JOptionPane.getFrameForComponent(LxAbstractView.this), bl);
        }

        private void _changeBuffer(Component component, boolean bl) {
            if (component instanceof JComponent) {
                ((JComponent)component).setDoubleBuffered(bl);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                int n = container.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    this._changeBuffer(container.getComponent(n2), bl);
                    ++n2;
                }
            }
        }
    }

    private final class DetachAction
    extends LxAbstractAction {
        DetachAction() {
            super(LxAbstractView.DETACH_ACTION, "Detach", "Detach this view from the graph.", null, false);
        }

        public void processAction(ActionEvent actionEvent) {
            LxAbstractView.this.setGraph(null);
        }
    }

    private final class CreationListeners
    extends Listener {
        private CreationListeners() {
        }

        public void fireCreated(final LxElement lxElement) {
            this.fire(new Listener.Feeder(){

                public Object getEvent(Object object) {
                    return new LxCreationEvent(LxAbstractView.this, 9123, lxElement);
                }

                public void fire(Object object, Object object2) {
                    ((LxCreationListener)object).elementCreated((LxCreationEvent)object2);
                }
            });
        }
    }

    private final class CreateTextAreaAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxTextArea;

        CreateTextAreaAction() {
            super(class$com$loox$jloox$LxTextArea == null ? (class$com$loox$jloox$LxTextArea = CreateTextAreaAction.class$("com.loox.jloox.LxTextArea")) : class$com$loox$jloox$LxTextArea, LxAbstractView.CREATE_TEXTAREA_ACTION, "Create multiline text area", "Create new multiline text area", "com/loox/jloox/images/textarea.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CreateTextAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxText;

        CreateTextAction() {
            super(class$com$loox$jloox$LxText == null ? (class$com$loox$jloox$LxText = CreateTextAction.class$("com.loox.jloox.LxText")) : class$com$loox$jloox$LxText, LxAbstractView.CREATE_TEXT_ACTION, "Create text", "Create new text entry", "com/loox/jloox/images/text.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CreateRectangleAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxRectangle;

        CreateRectangleAction() {
            super(class$com$loox$jloox$LxRectangle == null ? (class$com$loox$jloox$LxRectangle = CreateRectangleAction.class$("com.loox.jloox.LxRectangle")) : class$com$loox$jloox$LxRectangle, LxAbstractView.CREATE_RECTANGLE_ACTION, "Create rectangle", "Create a new rectangle", "com/loox/jloox/images/rect.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CreateQuadraticAction
    extends CreatePolylineAction {
        CreateQuadraticAction() {
        }
    }

    private final class CreatePolypathAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxGeneralPath;

        CreatePolypathAction() {
            super(class$com$loox$jloox$LxGeneralPath == null ? (class$com$loox$jloox$LxGeneralPath = CreatePolypathAction.class$("com.loox.jloox.LxGeneralPath")) : class$com$loox$jloox$LxGeneralPath, LxAbstractView.CREATE_GENERALPATH_ACTION, "Create path", "Create a new path", "com/loox/jloox/images/polypath.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class CreatePolylineAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxPolyline;

        CreatePolylineAction() {
            this(0, LxAbstractView.CREATE_POLYLINE_ACTION, "Create polyline", "Create a new polyline", "com/loox/jloox/images/polyline.gif");
        }

        CreatePolylineAction(int n, String string, String string2, String string3, String string4) {
            super(class$com$loox$jloox$LxPolyline == null ? (class$com$loox$jloox$LxPolyline = CreatePolylineAction.class$("com.loox.jloox.LxPolyline")) : class$com$loox$jloox$LxPolyline, string, string2, string3, string4);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CreateParallelogramAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxParallelogram;

        CreateParallelogramAction() {
            super(class$com$loox$jloox$LxParallelogram == null ? (class$com$loox$jloox$LxParallelogram = CreateParallelogramAction.class$("com.loox.jloox.LxParallelogram")) : class$com$loox$jloox$LxParallelogram, LxAbstractView.CREATE_PARALLELOGRAM_ACTION, "Create parallelogram", "Create a new parallelogram", "com/loox/jloox/images/paral.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CreateMarkerAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxMarker;

        CreateMarkerAction() {
            super(class$com$loox$jloox$LxMarker == null ? (class$com$loox$jloox$LxMarker = CreateMarkerAction.class$("com.loox.jloox.LxMarker")) : class$com$loox$jloox$LxMarker, LxAbstractView.CREATE_MARKER_ACTION, "Create marker", "Create a new marker", "com/loox/jloox/images/marker.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CreateOrthoLinkAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxLink;

        public CreateOrthoLinkAction() {
            super(class$com$loox$jloox$LxLink == null ? (class$com$loox$jloox$LxLink = CreateOrthoLinkAction.class$("com.loox.jloox.LxLink")) : class$com$loox$jloox$LxLink, LxAbstractView.CREATE_ORTHO_LINK_ACTION, "Create orthogonal link", "Create a new orthogonal link", "com/loox/jloox/images/ortholink.gif");
        }

        public final void processAction(ActionEvent actionEvent) {
            LxAbstractGraph lxAbstractGraph = LxAbstractView.this.getGraph();
            if (lxAbstractGraph != null) {
                lxAbstractGraph.unselectAll();
            }
            LxLink.createInteractively(LxAbstractView.this, 1);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CreateLinkAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxLink;

        CreateLinkAction() {
            super(class$com$loox$jloox$LxLink == null ? (class$com$loox$jloox$LxLink = CreateLinkAction.class$("com.loox.jloox.LxLink")) : class$com$loox$jloox$LxLink, LxAbstractView.CREATE_LINK_ACTION, "Create link", "Create a new link", "com/loox/jloox/images/link.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CreateLineAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxLine;

        CreateLineAction() {
            super(class$com$loox$jloox$LxLine == null ? (class$com$loox$jloox$LxLine = CreateLineAction.class$("com.loox.jloox.LxLine")) : class$com$loox$jloox$LxLine, LxAbstractView.CREATE_LINE_ACTION, "Create line", "Create a new line", "com/loox/jloox/images/line.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CreateImageAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxImage;

        CreateImageAction() {
            super(class$com$loox$jloox$LxImage == null ? (class$com$loox$jloox$LxImage = CreateImageAction.class$("com.loox.jloox.LxImage")) : class$com$loox$jloox$LxImage, LxAbstractView.CREATE_IMAGE_ACTION, "Create image", "Create new image entry", "com/loox/jloox/images/image.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private abstract class CreateElementAction
    extends LxAbstractAction {
        private final Class _target;

        CreateElementAction(Class clazz, String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4, false);
            this.setEnabled(LxAbstractView.this.getEditMode() == 2);
            this._target = clazz;
        }

        public void processAction(ActionEvent actionEvent) {
            LxAbstractGraph lxAbstractGraph = LxAbstractView.this.getGraph();
            if (lxAbstractGraph != null) {
                lxAbstractGraph.unselectAll();
            }
            LxAbstractView.this.createInteractively(this._target);
        }
    }

    private final class CreateCircleAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxCircle;

        CreateCircleAction() {
            super(class$com$loox$jloox$LxCircle == null ? (class$com$loox$jloox$LxCircle = CreateCircleAction.class$("com.loox.jloox.LxCircle")) : class$com$loox$jloox$LxCircle, LxAbstractView.CREATE_CIRCLE_ACTION, "Create circle", "Create a new circle", "com/loox/jloox/images/circle.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CreateBezierAction
    extends CreatePolylineAction {
        CreateBezierAction() {
        }
    }

    private final class CreateArrayAction
    extends CreateElementAction {
        static /* synthetic */ Class class$com$loox$jloox$LxArray;

        CreateArrayAction() {
            super(class$com$loox$jloox$LxArray == null ? (class$com$loox$jloox$LxArray = CreateArrayAction.class$("com.loox.jloox.LxArray")) : class$com$loox$jloox$LxArray, LxAbstractView.CREATE_ARRAY_ACTION, "Create array", "Create a new array", "com/loox/jloox/images/array.gif");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class BGPaint {
        private Paint _val = Color.white;

        private BGPaint() {
        }

        public void set(Paint paint) {
            if (paint == this._val) {
                return;
            }
            this._val = paint;
            LxAbstractView.this.repaint();
        }
    }

    private final class BackingStoreAction
    extends LxAbstractToggleAction {
        BackingStoreAction() {
            super(LxAbstractView.BACKING_STORE_ACTION, "Backing Store", "Remove backing store", null, "Backing Store", "Add backing store", null, true, true);
        }

        public void processAction(ActionEvent actionEvent) {
            Container container = LxAbstractView.this;
            while (container != null) {
                if (container instanceof JViewport) {
                    JViewport jViewport = (JViewport)container;
                    boolean bl = !jViewport.isBackingStoreEnabled();
                    jViewport.setBackingStoreEnabled(bl);
                    this.setState(bl);
                    return;
                }
                container = container.getParent();
            }
            this.setEnabled(false);
        }
    }

    private final class AntialiasAction
    extends LxAbstractToggleAction {
        AntialiasAction() {
            super(LxAbstractView.ANTIALIAS_ACTION, "Antialiasing", "Antialias off", null, "Antialiasing", "Antialias on", null, false, true);
        }

        public void processAction(ActionEvent actionEvent) {
            Object object = LxAbstractView.this.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            LxAbstractView.this.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object.equals(RenderingHints.VALUE_ANTIALIAS_ON) ? RenderingHints.VALUE_ANTIALIAS_OFF : RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    private final class Actions {
        private final Hashtable _hash = new Hashtable();
        private boolean allCreated = false;

        Actions() {
        }

        private boolean shouldCreate(String string, String string2, boolean bl) {
            if (this.allCreated) {
                return false;
            }
            if (bl && this._hash.get(string2) == null) {
                return true;
            }
            return string.equals(string2);
        }

        public LxAbstractAction get(String string) {
            LxAbstractAction lxAbstractAction = (LxAbstractAction)this._hash.get(string);
            if (lxAbstractAction == null) {
                boolean bl = false;
                if (string.equals("create-all-actions-now")) {
                    bl = true;
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_RECTANGLE_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_RECTANGLE_ACTION, new CreateRectangleAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_CIRCLE_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_CIRCLE_ACTION, new CreateCircleAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_LINE_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_LINE_ACTION, new CreateLineAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_POLYLINE_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_POLYLINE_ACTION, new CreatePolylineAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_GENERALPATH_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_GENERALPATH_ACTION, new CreatePolypathAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_TEXT_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_TEXT_ACTION, new CreateTextAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_TEXTAREA_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_TEXTAREA_ACTION, new CreateTextAreaAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_IMAGE_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_IMAGE_ACTION, new CreateImageAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_ARRAY_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_ARRAY_ACTION, new CreateArrayAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_MARKER_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_MARKER_ACTION, new CreateMarkerAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_LINK_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_LINK_ACTION, new CreateLinkAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_ORTHO_LINK_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_ORTHO_LINK_ACTION, new CreateOrthoLinkAction());
                }
                if (this.shouldCreate(string, LxAbstractView.CREATE_PARALLELOGRAM_ACTION, bl)) {
                    this._hash.put(LxAbstractView.CREATE_PARALLELOGRAM_ACTION, new CreateParallelogramAction());
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_OUT_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_OUT_ACTION, new ZoomRelativeAction(LxAbstractView.ZOOM_OUT_ACTION, 0.5));
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_IN_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_IN_ACTION, new ZoomRelativeAction(LxAbstractView.ZOOM_IN_ACTION, 2.0));
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_OUT_12_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_OUT_12_ACTION, new ZoomAbsoluteAction(LxAbstractView.ZOOM_OUT_12_ACTION, 0.125));
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_OUT_25_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_OUT_25_ACTION, new ZoomAbsoluteAction(LxAbstractView.ZOOM_OUT_25_ACTION, 0.25));
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_OUT_50_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_OUT_50_ACTION, new ZoomAbsoluteAction(LxAbstractView.ZOOM_OUT_50_ACTION, 0.5));
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_OUT_75_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_OUT_75_ACTION, new ZoomAbsoluteAction(LxAbstractView.ZOOM_OUT_75_ACTION, 0.75));
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_NORMAL_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_NORMAL_ACTION, new ZoomAbsoluteAction(LxAbstractView.ZOOM_NORMAL_ACTION, 1.0));
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_IN_150_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_IN_150_ACTION, new ZoomAbsoluteAction(LxAbstractView.ZOOM_IN_150_ACTION, 1.5));
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_IN_200_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_IN_200_ACTION, new ZoomAbsoluteAction(LxAbstractView.ZOOM_IN_200_ACTION, 2.0));
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_IN_400_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_IN_400_ACTION, new ZoomAbsoluteAction(LxAbstractView.ZOOM_IN_400_ACTION, 4.0));
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_IN_800_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_IN_800_ACTION, new ZoomAbsoluteAction(LxAbstractView.ZOOM_IN_800_ACTION, 8.0));
                }
                if (this.shouldCreate(string, LxAbstractView.PRINT_ACTION, bl)) {
                    this._hash.put(LxAbstractView.PRINT_ACTION, new PrintAction());
                }
                if (this.shouldCreate(string, LxAbstractView.DOUBLE_BUFFER_ACTION, bl)) {
                    this._hash.put(LxAbstractView.DOUBLE_BUFFER_ACTION, new DoubleBufferAction());
                }
                if (this.shouldCreate(string, LxAbstractView.BACKING_STORE_ACTION, bl)) {
                    this._hash.put(LxAbstractView.BACKING_STORE_ACTION, new BackingStoreAction());
                }
                if (this.shouldCreate(string, LxAbstractView.TOGGLE_MODE_ACTION, bl)) {
                    this._hash.put(LxAbstractView.TOGGLE_MODE_ACTION, new ToggleModeAction());
                }
                if (this.shouldCreate(string, LxAbstractView.ANTIALIAS_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ANTIALIAS_ACTION, new AntialiasAction());
                }
                if (this.shouldCreate(string, LxAbstractView.ZOOM_LINES_ACTION, bl)) {
                    this._hash.put(LxAbstractView.ZOOM_LINES_ACTION, new ZoomLinesAction());
                }
                if (this.shouldCreate(string, LxAbstractView.LAYER_VISIBILITY_DIALOG_ACTION, bl)) {
                    this._hash.put(LxAbstractView.LAYER_VISIBILITY_DIALOG_ACTION, new LayerVisDialogAction());
                }
                if (this.shouldCreate(string, LxAbstractView.DETACH_ACTION, bl)) {
                    this._hash.put(LxAbstractView.DETACH_ACTION, new DetachAction());
                }
                if (this.shouldCreate(string, LxAbstractView.SELECT_ALL_ACTION, bl)) {
                    this._hash.put(LxAbstractView.SELECT_ALL_ACTION, new SelectAllAction());
                }
                if (this.shouldCreate(string, LxAbstractView.GRID_DIALOG_ACTION, bl)) {
                    this._hash.put(LxAbstractView.GRID_DIALOG_ACTION, new GridDialogAction());
                }
                if (bl) {
                    this.allCreated = true;
                }
                lxAbstractAction = (LxAbstractAction)this._hash.get(string);
                return lxAbstractAction;
            }
            return lxAbstractAction;
        }

        public void setEnabled(boolean bl) {
            Enumeration enumeration = this._hash.elements();
            boolean bl2 = bl && LxAbstractView.this.getEditMode() == 2;
            while (enumeration.hasMoreElements()) {
                LxAbstractAction lxAbstractAction = (LxAbstractAction)enumeration.nextElement();
                if (lxAbstractAction instanceof CreateElementAction) {
                    lxAbstractAction.setEnabled(bl2);
                    continue;
                }
                lxAbstractAction.setEnabled(bl);
            }
        }

        public LxAbstractAction[] toArray() {
            LxAbstractAction[] lxAbstractActionArray = new LxAbstractAction[this._hash.size()];
            return this._hash.values().toArray(lxAbstractActionArray);
        }
    }
}

