/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.ChangeListeners;
import com.loox.jloox.LayerListeners;
import com.loox.jloox.LooxUndoableEdit;
import com.loox.jloox.Lx;
import com.loox.jloox.LxAbstractAction;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxAbstractStyle;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxComponentAdapter;
import com.loox.jloox.LxComponentEvent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxLayerListener;
import com.loox.jloox.LxLayers;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.LxShadowElement;
import com.loox.jloox.LxStyle;
import com.loox.jloox.LxStyleEvent;
import com.loox.jloox.LxStyleListener;
import com.loox.jloox.Point2DDouble;
import com.loox.jloox.Resources;
import com.loox.jloox.UndoableEditListener2;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public abstract class LxElement
extends LxComponent
implements Serializable {
    static final String CLASS_NAME = "LxElement";
    static final String PERFECT_SQUARE_ACTION = "perfect-square";
    private Style _style = null;
    private ChangeListeners _visual_lstnrs = null;

    public LxElement() {
        this(CLASS_NAME, null, null, true);
    }

    LxElement(String string, LxContainer lxContainer, Rectangle2D rectangle2D, boolean bl) {
        super(string, lxContainer, rectangle2D, false);
        this._initObjectVariables();
        if (bl) {
            this._postInitialize();
        }
    }

    public Object clone() {
        LxElement lxElement = (LxElement)super.clone();
        if (lxElement == null) {
            return null;
        }
        lxElement._initObjectVariables();
        lxElement.setStyle((LxAbstractStyle)this.getStyle().clone());
        return lxElement;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (this._style._undo_lstnr == null) {
            this._style._undo_lstnr = new UndoableEditListener2(){

                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    LxElement.this.addUndoEdit(undoableEditEvent.getEdit());
                }
            };
            this._style._val.addUndoableEditListener(this._style._undo_lstnr);
        }
        super.addUndoableEditListener(undoableEditListener);
    }

    protected void applyAttributes(LxAbstractGraph lxAbstractGraph) {
        this.setPaint(lxAbstractGraph.getDefaultPaint());
        this.setTransparency(lxAbstractGraph.getDefaultTransparency());
        this.setLineDashes(lxAbstractGraph.getDefaultDashes());
        this.setLineColor(lxAbstractGraph.getDefaultLineColor());
        this.setLineThickness(lxAbstractGraph.getDefaultLineThickness());
    }

    public boolean getLayer(int n) {
        return this._style._val.getLayer(n);
    }

    public LxLayers getLayers() {
        return this._style._val.getLayers();
    }

    public boolean isOnLayer(LxLayers lxLayers) {
        return this._style._val.isOnLayer(lxLayers);
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        this.setStyle(LxSaveUtils.readLxAbstractStyle(inputStream, string));
        double d = LxSaveUtils.readDouble(inputStream);
        if (this instanceof LxShadowElement) {
            LxShadowElement lxShadowElement = (LxShadowElement)((Object)this);
            if (d < 0.0) {
                lxShadowElement.setInverted(true);
                lxShadowElement.setShadowThickness(-d);
            } else {
                lxShadowElement.setInverted(false);
                lxShadowElement.setShadowThickness(d);
            }
        }
        LxSaveUtils.readEndOfPart(inputStream);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        super.removeUndoableEditListener(undoableEditListener);
        if (this._getUndoListenerCount() == 1) {
            this._style._val.addUndoableEditListener(this._style._undo_lstnr);
            this._style._undo_lstnr = null;
        }
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        LxSaveUtils.writeLxAbstractStyle(outputStream, this.getStyle());
        double d = 0.0;
        if (this instanceof LxShadowElement) {
            LxShadowElement lxShadowElement = (LxShadowElement)((Object)this);
            d = lxShadowElement.isInverted() ? -lxShadowElement.getShadowThickness() : lxShadowElement.getShadowThickness();
        }
        LxSaveUtils.writeDouble(outputStream, d);
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    public void setLayer(int n, boolean bl) {
        this._style._val.setLayer(n, bl);
    }

    public void setLayers(LxLayers lxLayers) {
        this._style._val.setLayers(lxLayers);
    }

    public void addLayerListener(LxLayerListener lxLayerListener) {
        this._style._layer_lstnrs.add(lxLayerListener);
    }

    public void addVisualListener(ChangeListener changeListener) {
        this._visual_lstnrs.add(changeListener);
    }

    public LxAbstractStyle getStyle() {
        return this._style._val;
    }

    public Color getLineColor() {
        return this._style._val.getLineColor();
    }

    public float[] getLineDashes() {
        return this._style._val.getLineDashes();
    }

    public float getLineThickness() {
        return this._style._val.getLineThickness();
    }

    public int getLineCap() {
        return this._style._val.getLineCap();
    }

    public int getLineJoin() {
        return this._style._val.getLineJoin();
    }

    public Paint getPaint() {
        return this._style._val.getPaint();
    }

    public float getTransparency() {
        return this._style._val.getTransparency();
    }

    public void removeLayerListener(LxLayerListener lxLayerListener) {
        this._style._layer_lstnrs.remove(lxLayerListener);
    }

    public void removeVisualListener(ChangeListener changeListener) {
        this._visual_lstnrs.remove(changeListener);
    }

    public void setStyle(LxAbstractStyle lxAbstractStyle) {
        this._style.set(lxAbstractStyle);
    }

    public void setLineColor(Color color) {
        this._style._val.setLineColor(color);
    }

    public void setLineDashes(int n) {
        this.setLineDashes(Lx.getPredefinedDashes(n));
    }

    public void setLineDashes(float[] fArray) {
        this._style._val.setLineDashes(fArray);
    }

    public void setLineThickness(float f) {
        this._style._val.setLineThickness(f);
    }

    public void setLineCap(int n) {
        this._style._val.setLineCap(n);
    }

    public void setLineJoin(int n) {
        this._style._val.setLineJoin(n);
    }

    public void setPaint(Paint paint) {
        this._style._val.setPaint(paint);
    }

    public void setTransparency(float f) {
        this._style._val.setTransparency(f);
    }

    protected void fireVisualChanged() {
        this._visual_lstnrs.fireStateChanged(this);
    }

    LxLayers _getLayers() {
        return this._style._val._getLayers();
    }

    abstract void _paint(Graphics2D var1, AffineTransform var2, LxLayers var3, double var4, boolean var6);

    protected Stroke getLineStroke() {
        return this._style._val._getLineStroke();
    }

    protected void paint(Graphics2D graphics2D, AffineTransform affineTransform) {
        System.err.println("LxElement.paint(): this method is no longer valid");
        Thread.dumpStack();
    }

    protected abstract void paintElement(Graphics2D var1);

    private void _initObjectVariables() {
        this._style = new Style();
        this._visual_lstnrs = new ChangeListeners();
    }

    static abstract class PointCreation
    extends MouseAdapter
    implements InteractiveCreation {
        private final LxAbstractView _view;

        PointCreation(LxAbstractView lxAbstractView) {
            this._view = lxAbstractView;
        }

        abstract LxElement create(LxAbstractGraph var1, Point2D var2);

        public void mousePressed(MouseEvent mouseEvent) {
            double d = this._view.getZoomFactor();
            Point point = mouseEvent.getPoint();
            Point2D point2D = this._view.applyMagneticGrid(point);
            Point2DDouble point2DDouble = new Point2DDouble(point2D.getX() / d, point2D.getY() / d);
            this._view._finishCreation(this.create(this._view.getGraph(), point2DDouble));
        }

        public void start() {
            this._view.addMouseListener(this);
        }

        public void stop() {
            this._view.removeMouseListener(this);
        }
    }

    final class PerfectSquareAction
    extends PerfectAction
    implements Serializable {
        PerfectSquareAction() {
            super(LxElement.PERFECT_SQUARE_ACTION, "Square", "make this a perfect square");
        }
    }

    abstract class PerfectAction
    extends LxAbstractAction
    implements Serializable {
        PerfectAction(String string, String string2, String string3) {
            super(string, string2, string3, null, true);
            this._setEnabled();
            LxElement.this.addComponentListener(new LxComponentAdapter(this){
                private final /* synthetic */ PerfectAction this$1;
                {
                    this.this$1 = perfectAction;
                }

                public void componentResized(LxComponentEvent lxComponentEvent) {
                    PerfectAction.access$400(this.this$1);
                }
            });
        }

        public void processAction(ActionEvent actionEvent) {
            LxElement.this.setHeight(LxElement.this.getWidth());
        }

        private void _setEnabled() {
            this.setEnabled(LxElement.this.getWidth() != LxElement.this.getHeight());
        }

        static /* synthetic */ void access$400(PerfectAction perfectAction) {
            perfectAction._setEnabled();
        }
    }

    static interface InteractiveCreation
    extends MouseListener {
        public void start();

        public void stop();
    }

    private static final class StyleEdit
    extends LooxUndoableEdit {
        private static final String STYLE_UNDO = "styleUndo";
        private LxAbstractStyle _value;

        public StyleEdit(LxElement lxElement, LxAbstractStyle lxAbstractStyle) {
            super(lxElement, Resources.get(STYLE_UNDO, "style"));
            this._value = lxAbstractStyle;
        }

        void _undoEdit(boolean bl) {
            LxElement lxElement = (LxElement)this._getHost();
            LxAbstractStyle lxAbstractStyle = lxElement.getStyle();
            lxElement._style.set(this._value, false);
            this._value = lxAbstractStyle;
        }
    }

    private final class Style
    implements Serializable {
        private final LayerListeners _layer_lstnrs = new LayerListeners();
        private final LxStyleListener _bndl_lstnr = new LxStyleListener(this){
            private final /* synthetic */ Style this$1;
            {
                this.this$1 = style;
            }

            public void layersChanged(LxStyleEvent lxStyleEvent) {
                Style.access$100(this.this$1).fireChanged(Style.access$000(this.this$1), lxStyleEvent.getOldLayers());
            }

            public void lineColorChanged(LxStyleEvent lxStyleEvent) {
                LxElement.access$200(Style.access$000(this.this$1)).fireStateChanged(Style.access$000(this.this$1));
            }

            public void paintChanged(LxStyleEvent lxStyleEvent) {
                LxElement.access$200(Style.access$000(this.this$1)).fireStateChanged(Style.access$000(this.this$1));
            }

            public void strokeChanged(LxStyleEvent lxStyleEvent) {
                Style.access$000(this.this$1).fireComponentMorphed(null);
            }

            public void transparencyChanged(LxStyleEvent lxStyleEvent) {
                LxElement.access$200(Style.access$000(this.this$1)).fireStateChanged(Style.access$000(this.this$1));
            }
        };
        private UndoableEditListener _undo_lstnr = null;
        private LxAbstractStyle _val = null;

        Style() {
            LxAbstractStyle lxAbstractStyle = null;
            LxAbstractGraph lxAbstractGraph = LxElement.this.getGraph();
            lxAbstractStyle = lxAbstractGraph != null ? lxAbstractGraph.getDefaultStyle() : Lx.getDefaultStyle();
            this._val = lxAbstractStyle != null ? lxAbstractStyle : new LxStyle(lxAbstractGraph);
            this._val.addStyleListener(this._bndl_lstnr);
        }

        public void set(LxAbstractStyle lxAbstractStyle) {
            this.set(lxAbstractStyle, true);
        }

        public void set(LxAbstractStyle lxAbstractStyle, boolean bl) {
            block15: {
                Rectangle2D rectangle2D;
                block14: {
                    LxAbstractStyle lxAbstractStyle2;
                    block12: {
                        block13: {
                            if (lxAbstractStyle == null) {
                                throw new IllegalArgumentException("null resource style");
                            }
                            lxAbstractStyle2 = this._val;
                            if (lxAbstractStyle == lxAbstractStyle2) {
                                return;
                            }
                            rectangle2D = LxElement.this.getStrokedBounds2D();
                            lxAbstractStyle2.removeStyleListener(this._bndl_lstnr);
                            if (LxElement.this._undoOn()) {
                                lxAbstractStyle2.removeUndoableEditListener(this._undo_lstnr);
                            }
                            this._val = lxAbstractStyle;
                            this._val.addStyleListener(this._bndl_lstnr);
                            if (LxElement.this._undoOn()) {
                                this._val.addUndoableEditListener(this._undo_lstnr);
                            }
                            if (bl && LxElement.this._undoOn()) {
                                LxElement.this.addUndoEdit(new StyleEdit(LxElement.this, lxAbstractStyle2));
                            }
                            if (!lxAbstractStyle._getLayers().equals(lxAbstractStyle2._getLayers())) {
                                this._layer_lstnrs.fireChanged(LxElement.this, lxAbstractStyle2.getLayers());
                            }
                            if (LxElement.this._visual_lstnrs.getSize() <= 0) break block12;
                            if (!lxAbstractStyle.getLineColor().equals(lxAbstractStyle2.getLineColor()) || lxAbstractStyle.getTransparency() != lxAbstractStyle2.getTransparency()) break block13;
                            boolean bl2 = lxAbstractStyle.getPaint() == null ? lxAbstractStyle2.getPaint() != null : !lxAbstractStyle.getPaint().equals(lxAbstractStyle2.getPaint());
                            if (!bl2) break block12;
                        }
                        LxElement.this._visual_lstnrs.fireStateChanged(LxElement.this);
                    }
                    if (lxAbstractStyle.getLineThickness() != lxAbstractStyle2.getLineThickness()) break block14;
                    float[] fArray = lxAbstractStyle.getLineDashes();
                    boolean bl3 = fArray == null ? lxAbstractStyle2.getLineDashes() != null : !fArray.equals(lxAbstractStyle2.getLineDashes());
                    if (!bl3) break block15;
                }
                LxElement.this.fireComponentMorphed(rectangle2D);
            }
        }

        static /* synthetic */ LxElement access$000(Style style) {
            return style.LxElement.this;
        }
    }
}

