/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.LxConstants;
import com.loox.jloox.Resources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LxFontChooser
extends JDialog
implements LxConstants {
    private static final String DEFAULT_TEXT = "_";
    private static final String DIALOG = "choose-font-dialog";
    private static final String DIALOG_TITLE = "choose-font-dialogTitle";
    private static final String DIALOG_FAMILY_STR = "choose-font-dialogFamilyLabel";
    private static final String DIALOG_SIZE_STR = "choose-font-dialogSizeLabel";
    private static final String DIALOG_BOLD_STR = "choose-font-dialogBoldLabel";
    private static final String DIALOG_ITALIC_STR = "choose-font-dialogItalicLabel";
    private static final String DIALOG_OK_STR = "choose-font-dialogOKLabel";
    private static final String DIALOG_CANCEL_STR = "choose-font-dialogCancelLabel";
    private static final String DIALOG_RESET_STR = "choose-font-dialogResetLabel";
    private final Font _default;
    private final JList _names;
    private final JSlider _slider;
    private final JCheckBox _bold;
    private final JCheckBox _italic;
    private String _family;
    private int _size;
    private int _style;

    public LxFontChooser(Component component, Font font, final String string) {
        super(JOptionPane.getFrameForComponent(component), Resources.get(DIALOG_TITLE, "Choose font"), true);
        this._default = font;
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        final JComponent jComponent = new JComponent(){
            final FontRenderContext DEFAULT_CONTEXT = new FontRenderContext(null, true, true);

            public void paint(Graphics graphics) {
                Font font = new Font(LxFontChooser.this._family, LxFontChooser.this._style, LxFontChooser.this._size);
                TextLayout textLayout = string == null || string.length() == 0 ? new TextLayout(LxFontChooser.DEFAULT_TEXT, font, this.DEFAULT_CONTEXT) : new TextLayout(string, font, this.DEFAULT_CONTEXT);
                Rectangle2D rectangle2D = textLayout.getBounds();
                Dimension dimension = this.getSize();
                graphics.setFont(font);
                graphics.setColor(Color.black);
                graphics.drawString(string, (int)(0.5 * (dimension.getWidth() - rectangle2D.getWidth()) - rectangle2D.getX()), (int)(0.5 * (dimension.getHeight() - rectangle2D.getHeight()) - rectangle2D.getY()));
            }
        };
        this._names = new JList();
        this._names.setSelectionMode(0);
        final String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String string2 = font.getFamily();
        this._names.setVisibleRowCount(stringArray.length);
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (!bl && string2.equals(stringArray[n])) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            System.err.println("font name not found!!!");
        }
        this._names.setListData(stringArray);
        this._names.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LxFontChooser.this._family = stringArray[LxFontChooser.this._names.getSelectedIndex()];
                jComponent.repaint();
            }
        });
        jScrollPane.setViewportView(this._names);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel(Resources.get(DIALOG_FAMILY_STR, "Family")), "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setMaximumSize(new Dimension(jPanel2.getMaximumSize().width, jPanel2.getPreferredSize().height));
        this._names.setVisibleRowCount(8);
        this._size = font.getSize();
        final String string3 = Resources.get(DIALOG_SIZE_STR, "Size") + " ";
        final JLabel jLabel = new JLabel(string3 + this._size);
        this._slider = new JSlider(1, Math.max(96, font.getSize()));
        this._slider.setPaintTicks(true);
        this._slider.setMajorTickSpacing(24);
        this._slider.setMinorTickSpacing(12);
        this._slider.setPaintLabels(true);
        this._slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LxFontChooser.this._size = LxFontChooser.this._slider.getValue();
                jLabel.setText(string3 + LxFontChooser.this._size);
                jComponent.repaint();
            }
        });
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jLabel, "North");
        jPanel3.add((Component)this._slider, "Center");
        jPanel3.setMaximumSize(new Dimension(jPanel3.getMaximumSize().width, jPanel3.getPreferredSize().height));
        this._bold = new JCheckBox(Resources.get(DIALOG_BOLD_STR, "Bold"));
        this._italic = new JCheckBox(Resources.get(DIALOG_ITALIC_STR, "Italic"));
        this._bold.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (LxFontChooser.this._bold.isSelected()) {
                    LxFontChooser.this._style = (byte)LxFontChooser.this._style | 1;
                } else {
                    LxFontChooser.this._style = (byte)LxFontChooser.this._style & -2;
                }
                jComponent.repaint();
            }
        });
        this._italic.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (LxFontChooser.this._italic.isSelected()) {
                    LxFontChooser.this._style = (byte)LxFontChooser.this._style | 2;
                } else {
                    LxFontChooser.this._style = (byte)LxFontChooser.this._style & -3;
                }
                jComponent.repaint();
            }
        });
        jPanel6.setBorder(new BevelBorder(1));
        jPanel6.setLayout(new GridLayout(1, 1));
        jPanel6.add(jComponent);
        jPanel6.setPreferredSize(new Dimension(256, 64));
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this._bold);
        jPanel4.add(Box.createHorizontalStrut(6));
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this._italic);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.setMaximumSize(new Dimension(jPanel4.getMaximumSize().width, jPanel4.getPreferredSize().height));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new CompoundBorder(new EmptyBorder(6, 6, 6, 6), new CompoundBorder(new EtchedBorder(), new EmptyBorder(6, 6, 6, 6))));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(6));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(6));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jPanel4);
        jPanel.add(Box.createVerticalStrut(6));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jPanel6);
        jPanel.add(Box.createVerticalGlue());
        this._resetFont();
        jPanel5.setLayout(new FlowLayout(1));
        JButton jButton = new JButton(Resources.get(DIALOG_OK_STR, "OK"));
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)LxFontChooser.this).setVisible(false);
            }
        });
        final JButton jButton2 = new JButton(Resources.get(DIALOG_CANCEL_STR, "Cancel"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton2.doClick();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke('\u001b');
        jButton2.registerKeyboardAction(actionListener, keyStroke, 2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LxFontChooser.this._resetFont();
                ((Component)LxFontChooser.this).setVisible(false);
            }
        });
        JButton jButton3 = new JButton(Resources.get(DIALOG_RESET_STR, "Reset"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LxFontChooser.this._resetFont();
            }
        });
        jPanel5.add(jButton);
        jPanel5.add(jButton2);
        jPanel5.add(jButton3);
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel5, "South");
        this.pack();
        this.setLocationRelativeTo(component);
        jButton.requestFocus();
    }

    public Font getSelectedFont() {
        if (this._family == null) {
            return this._default;
        }
        if (this._family.equals(this._default.getFamily()) && this._size == this._default.getSize() && this._style == this._default.getStyle()) {
            return this._default;
        }
        return new Font(this._family, this._style, this._size);
    }

    private void _resetFont() {
        this._names.setSelectedValue(this._default.getFamily(), true);
        this._names.ensureIndexIsVisible(this._names.getSelectedIndex());
        this._slider.setValue(this._default.getSize());
        int n = this._default.getStyle();
        this._bold.setSelected((n & 1) != 0);
        this._italic.setSelected((n & 2) != 0);
    }

    public static Font showDialog(Component component, Font font, String string) {
        LxFontChooser lxFontChooser = new LxFontChooser(component, font, string);
        lxFontChooser.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)windowEvent.getWindow()).setVisible(false);
            }
        });
        lxFontChooser.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                ((Window)componentEvent.getComponent()).dispose();
            }
        });
        lxFontChooser.show();
        return lxFontChooser.getSelectedFont();
    }
}

