/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.Arrow;
import com.loox.jloox.BasePath;
import com.loox.jloox.LooxCollapsableEdit;
import com.loox.jloox.LooxUndoableEdit;
import com.loox.jloox.LxAbstractToggleAction;
import com.loox.jloox.LxArrowElement;
import com.loox.jloox.LxComponentAdapter;
import com.loox.jloox.LxComponentEvent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxHandle;
import com.loox.jloox.LxHandleAdapter;
import com.loox.jloox.LxHandleEvent;
import com.loox.jloox.LxHandleListener;
import com.loox.jloox.LxRotatable;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.LxShadowElement;
import com.loox.jloox.LxVectorial;
import com.loox.jloox.Point2DDouble;
import com.loox.jloox.Resources;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.undo.UndoableEdit;

public abstract class LxPathElement
extends LxVectorial
implements LxRotatable,
Serializable {
    public static final int CONNECTION_FIRST = 0;
    public static final int CONNECTION_LINE = 0;
    public static final int CONNECTION_QUADRATIC = 1;
    public static final int CONNECTION_BEZIER = 2;
    public static final int CONNECTION_LAST = 2;
    static final String CLASS_NAME = "LxPathElement";
    public static final String OPEN_ACTION = "toggle-open-polyline";
    private static final int INIT_SIZE = 2;
    private static final int EXPAND_MAX = 20;
    public static final byte SEG_MOVETO = 0;
    public static final byte SEG_LINETO = 1;
    public static final byte SEG_QUADTO = 2;
    public static final byte SEG_CUBICTO = 3;
    public static final byte SEG_CLOSE = 4;
    private BasePath _path = new BasePath();
    private boolean _closed = true;
    private double _cx;
    private double _cy;
    private transient LxHandle[] _handles2 = null;
    protected transient LxHandleListener _handles2_lstnr = null;
    boolean _allPointsRemoved = false;
    boolean _doPathUpdated = true;

    public LxPathElement() {
        this(CLASS_NAME, null, true);
    }

    LxPathElement(String string, LxContainer lxContainer, boolean bl) {
        super(string, lxContainer, null, false);
        this._initObjectVariables();
        if (bl) {
            this._postInitialize();
        }
    }

    public Object clone() {
        LxPathElement lxPathElement = (LxPathElement)super.clone();
        if (lxPathElement == null) {
            return null;
        }
        lxPathElement._initObjectVariables();
        lxPathElement._path = (BasePath)this._path.clone();
        lxPathElement._cx = this._cx;
        lxPathElement._cy = this._cy;
        lxPathElement._closed = this._closed;
        return lxPathElement;
    }

    protected void createHandles() {
        int n;
        int n2 = this.getPathPointCount() * 2;
        double d = this.getWidth();
        double d2 = this.getHeight();
        Point2D.Float float_ = new Point2D.Float();
        if (d == 0.0) {
            d = 1.0;
        }
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        this.removeAllHandles();
        if (n2 > 0) {
            n = 0;
            if (this._handles2 != null) {
                n = this._handles2.length;
            }
            if (this.getPathPointCount() != n) {
                this._handles2 = null;
                if (this.getPathPointCount() > 0) {
                    this._handles2 = new LxHandle[this.getPathPointCount()];
                }
            }
        } else {
            this._handles2 = null;
        }
        n = 0;
        int n3 = 0;
        while (n3 < n2) {
            ((Point2D)float_).setLocation((double)this._path.pointCoords[n3] / d, (double)this._path.pointCoords[n3 + 1] / d2);
            int n4 = this.getPathSegmentTypeFromPoint(n3 / 2);
            switch (n4) {
                case 0: {
                    this.createHandle(float_, 0, n3 / 2);
                    n = 0;
                    break;
                }
                case 1: {
                    this.createHandle(float_, 0, n3 / 2);
                    n = 0;
                    break;
                }
                case 2: {
                    if (n == 1) {
                        this.createHandle(float_, 0, n3 / 2);
                        n = 0;
                        break;
                    }
                    this.createHandle(float_, 1, n3 / 2);
                    ++n;
                    break;
                }
                case 3: {
                    if (n == 2) {
                        this.createHandle(float_, 0, n3 / 2);
                        n = 0;
                        break;
                    }
                    this.createHandle(float_, 1, n3 / 2);
                    ++n;
                }
            }
            n3 += 2;
        }
    }

    int _getInitialHandleCount() {
        return this.getPathPointCount();
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        this.removeAllPathPoints();
        double d = 0.0;
        if (this instanceof LxShadowElement) {
            d = ((LxShadowElement)((Object)this)).getShadowThickness();
            ((LxShadowElement)((Object)this)).setShadowThickness(0.0);
        }
        int n = LxSaveUtils.readInt(inputStream);
        LxSaveUtils.readEndOfPart(inputStream);
        double d2 = this.getCenterX();
        double d3 = this.getCenterY();
        this._path.pointCoords = new float[12 * (n + 3)];
        this._path.pointTypes = new byte[n + 3];
        this._path.numTypes = 0;
        this._path.numCoords = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            n2 = -1;
            if (string.compareTo("2.0.0") >= 0) {
                n2 = LxSaveUtils.readInt(inputStream);
            }
            if (n2 == 4) {
                this._path.pointTypes[this._path.numTypes++] = 4;
            } else {
                double[] dArray = LxSaveUtils.readDoubleArray(inputStream, 0);
                LxSaveUtils.readEndOfPart(inputStream);
                if (dArray == null) {
                    dArray = new double[2];
                    dArray[1] = 0.0;
                    dArray[0] = 0.0;
                }
                switch (dArray.length) {
                    case 2: {
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[0];
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[1];
                        if (n3 == 0 || n2 != -1 && n2 == 0) {
                            this._path.pointTypes[this._path.numTypes++] = 0;
                            break;
                        }
                        this._path.pointTypes[this._path.numTypes++] = 1;
                        break;
                    }
                    case 4: {
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[0];
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[1];
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[2];
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[3];
                        this._path.pointTypes[this._path.numTypes++] = 2;
                        break;
                    }
                    case 6: {
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[0];
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[1];
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[2];
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[3];
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[4];
                        this._path.pointCoords[this._path.numCoords++] = (float)dArray[5];
                        this._path.pointTypes[this._path.numTypes++] = 3;
                    }
                }
            }
            ++n3;
        }
        this.resetToCenter(true);
        this._closed = false;
        this.setClosed(LxSaveUtils.readBoolean(inputStream), false);
        int n4 = LxSaveUtils.readInt(inputStream);
        if (this instanceof LxArrowElement) {
            ((LxArrowElement)((Object)this)).setLineArrow(n4);
        }
        LxSaveUtils.readEndOfPart(inputStream);
        if (this instanceof LxShadowElement) {
            ((LxShadowElement)((Object)this)).setShadowThickness(d);
        }
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        double[] dArray = new double[2];
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[6];
        int n = this._path.numTypes;
        int n2 = n--;
        if (this.isClosed()) {
            // empty if block
        }
        LxSaveUtils.writeInt(outputStream, n);
        LxSaveUtils.writeEndOfPart(outputStream);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            LxSaveUtils.writeInt(outputStream, this._path.pointTypes[n4]);
            switch (this._path.pointTypes[n4]) {
                case 0: 
                case 1: {
                    dArray[0] = this._path.pointCoords[n3++];
                    dArray[1] = this._path.pointCoords[n3++];
                    LxSaveUtils.writeDoubleArray(outputStream, dArray);
                    LxSaveUtils.writeEndOfPart(outputStream);
                    break;
                }
                case 2: {
                    dArray2[0] = this._path.pointCoords[n3++];
                    dArray2[1] = this._path.pointCoords[n3++];
                    dArray2[2] = this._path.pointCoords[n3++];
                    dArray2[3] = this._path.pointCoords[n3++];
                    LxSaveUtils.writeDoubleArray(outputStream, dArray2);
                    LxSaveUtils.writeEndOfPart(outputStream);
                    break;
                }
                case 3: {
                    dArray3[0] = this._path.pointCoords[n3++];
                    dArray3[1] = this._path.pointCoords[n3++];
                    dArray3[2] = this._path.pointCoords[n3++];
                    dArray3[3] = this._path.pointCoords[n3++];
                    dArray3[4] = this._path.pointCoords[n3++];
                    dArray3[5] = this._path.pointCoords[n3++];
                    LxSaveUtils.writeDoubleArray(outputStream, dArray3);
                    LxSaveUtils.writeEndOfPart(outputStream);
                    break;
                }
            }
            ++n4;
        }
        LxSaveUtils.writeBoolean(outputStream, this.isClosed());
        int n5 = 0;
        if (this instanceof LxArrowElement) {
            n5 = ((LxArrowElement)((Object)this)).getLineArrow();
        }
        LxSaveUtils.writeInt(outputStream, n5);
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    static void getShadowPoint(double d, double d2, double d3, double d4, double d5, Point2D point2D) {
        double d6 = (Math.PI - (Math.atan2(d4, d3) - Math.atan2(d2, d))) / 2.0;
        double d7 = Math.sqrt(d3 * d3 + d4 * d4);
        double d8 = Math.cos(d6);
        double d9 = Math.sin(d6);
        double d10 = (d3 /= d7) * d8 - (d4 /= d7) * d9;
        double d11 = d3 * d9 + d4 * d8;
        if (d9 >= 0.0 && d9 < 0.1) {
            d9 = 0.1;
        }
        if (d9 < 0.0 && d9 > -0.1) {
            d9 = -0.1;
        }
        point2D.setLocation(d10 * d5 / d9, d11 * d5 / d9);
    }

    static boolean getShadowCriteria(double d, double d2, double d3, double d4) {
        return !(d3 - d > d4 - d2);
    }

    private boolean _contains(double d, double d2) {
        boolean bl = false;
        int n = this._path.numCoords / 2;
        double d3 = this._path.pointCoords[2 * (n - 1)];
        double d4 = this._path.pointCoords[2 * (n - 1) + 1];
        boolean bl2 = d4 >= d2;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            boolean bl3;
            double d5 = this._path.pointCoords[2 * n2];
            double d6 = this._path.pointCoords[2 * n2 + 1];
            boolean bl4 = bl3 = d6 >= d2;
            if (bl2 != bl3 && (d6 - d2) * (d3 - d5) >= (d5 - d) * (d4 - d6) == bl3) {
                bl = !bl;
            }
            bl2 = bl3;
            d3 = d5;
            d4 = d6;
            ++n2;
            ++n3;
        }
        return bl;
    }

    private void _computeShadowPoint(double d, boolean bl, int n, int n2, int n3, double[] dArray, boolean[] blArray) {
        int n4 = this._path.numCoords / 2;
        int n5 = n;
        Point2D.Double double_ = new Point2D.Double();
        double d2 = this._path.pointCoords[n * 2];
        double d3 = this._path.pointCoords[n * 2 + 1];
        double d4 = this._path.pointCoords[n2 * 2];
        double d5 = this._path.pointCoords[n2 * 2 + 1];
        double d6 = this._path.pointCoords[n3 * 2];
        double d7 = this._path.pointCoords[n3 * 2 + 1];
        if (!(this.isClosed() || n != 0 && n != n4 - 1)) {
            ((Point2D)double_).setLocation(0.0, 0.0);
            blArray[n5] = !LxPathElement.getShadowCriteria(d6, d7, d2, d3);
        } else {
            double d8 = d2 - d4;
            double d9 = d3 - d5;
            double d10 = d6 - d2;
            double d11 = d7 - d3;
            if (Math.abs(d8) < 0.001 && Math.abs(d9) < 0.001) {
                return;
            }
            if (Math.abs(d10) < 0.001 && Math.abs(d11) < 0.001) {
                int n6;
                int n7 = n5 + 1;
                if (n7 >= n4) {
                    n7 = 0;
                }
                if ((n6 = (n3 + 1) % n4) == n2) {
                    dArray[2 * n7] = d2;
                    dArray[2 * n7 + 1] = d3;
                    return;
                }
                this._computeShadowPoint(d, bl, n, n2, n6, dArray, blArray);
                dArray[2 * n7] = dArray[2 * n5];
                dArray[2 * n7 + 1] = dArray[2 * n5 + 1];
                blArray[n7] = blArray[n5];
                return;
            }
            LxPathElement.getShadowPoint(d8, d9, d10, d11, d, double_);
            blArray[n5] = !LxPathElement.getShadowCriteria(d6, d7, d2, d3);
        }
        if (bl) {
            if (!this._contains(d2 + ((Point2D)double_).getX(), d3 + ((Point2D)double_).getY())) {
                ((Point2D)double_).setLocation(-((Point2D)double_).getX(), -((Point2D)double_).getY());
                blArray[n5] = !LxPathElement.getShadowCriteria(d2, d3, d6, d7);
            }
        } else if (this._contains(d2 + ((Point2D)double_).getX(), d3 + ((Point2D)double_).getY())) {
            ((Point2D)double_).setLocation(-((Point2D)double_).getX(), -((Point2D)double_).getY());
            blArray[n5] = !LxPathElement.getShadowCriteria(d2, d3, d6, d7);
        }
        dArray[2 * n5] = d2 + ((Point2D)double_).getX();
        dArray[2 * n5 + 1] = d3 + ((Point2D)double_).getY();
    }

    public double[] getShadowPathPoints(double d, boolean bl) {
        return this.getShadowPathPoints(d, bl, null);
    }

    double[] getShadowPathPoints(double d, boolean bl, ArrayList arrayList) {
        int n = this._path.numCoords / 2;
        if (n < 3 || d <= 0.0) {
            return null;
        }
        double[] dArray = new double[2 * n];
        boolean[] blArray = new boolean[n];
        Point2D.Double double_ = new Point2D.Double();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 - 1;
            int n4 = n2 + 1;
            if (n3 < 0) {
                n3 = n - 1;
            }
            if (n2 == n - 1) {
                n4 = 0;
            } else if (n2 == n) {
                n4 = 1;
            }
            this._computeShadowPoint(d, bl, n2, n3, n4, dArray, blArray);
            ++n2;
        }
        if (arrayList != null) {
            arrayList.add(blArray);
        }
        return dArray;
    }

    private LxVectorial.ShadowShapeData[] _getShadowShapeData(Shape shape) {
        if (!(this instanceof LxShadowElement)) {
            return null;
        }
        double d = Math.min(((LxShadowElement)((Object)this)).getShadowThickness(), Math.min(this.getWidth() / 2.0, this.getHeight() / 2.0));
        int n = this._path.numCoords / 2;
        if (n < 3 || d <= 0.0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(2);
        double[] dArray = this.getShadowPathPoints(d, true, arrayList);
        if (dArray != null) {
            int n2 = dArray.length / 2;
            boolean[] blArray = (boolean[])arrayList.get(0);
            if (!this.isClosed()) {
                --n2;
            }
            if (n2 > 0) {
                ArrayList<LxVectorial.ShadowShapeData> arrayList2 = new ArrayList<LxVectorial.ShadowShapeData>(n2);
                Path2D path2D = null;
                int n3 = 0;
                while (n3 < n2) {
                    if (n3 == 0) {
                        path2D = new GeneralPath(0);
                    } else if (blArray[n3] != blArray[n3 - 1]) {
                        path2D.closePath();
                        arrayList2.add(new LxVectorial.ShadowShapeData(this, path2D, blArray[n3 - 1]));
                        path2D = new GeneralPath(0);
                    }
                    int n4 = 2 * n3;
                    if (n3 == 0) {
                        ((Path2D.Float)path2D).moveTo(this._path.pointCoords[0], this._path.pointCoords[1]);
                        ((Path2D.Float)path2D).lineTo((float)dArray[0], (float)dArray[1]);
                        ((Path2D.Float)path2D).lineTo((float)dArray[2], (float)dArray[3]);
                        ((Path2D.Float)path2D).lineTo(this._path.pointCoords[2], this._path.pointCoords[3]);
                    } else if (n3 == n2 - 1) {
                        if (this.isClosed()) {
                            ((Path2D.Float)path2D).moveTo(this._path.pointCoords[n4], this._path.pointCoords[n4 + 1]);
                            ((Path2D.Float)path2D).lineTo((float)dArray[n4], (float)dArray[n4 + 1]);
                            ((Path2D.Float)path2D).lineTo((float)dArray[0], (float)dArray[1]);
                            ((Path2D.Float)path2D).lineTo(this._path.pointCoords[0], this._path.pointCoords[1]);
                        } else {
                            ((Path2D.Float)path2D).moveTo(this._path.pointCoords[2 * (n - 2)], this._path.pointCoords[2 * (n - 2) + 1]);
                            ((Path2D.Float)path2D).lineTo((float)dArray[2 * (n2 - 1)], (float)dArray[2 * (n2 - 1) + 1]);
                            ((Path2D.Float)path2D).lineTo((float)dArray[2 * n2], (float)dArray[2 * n2 + 1]);
                            ((Path2D.Float)path2D).lineTo(this._path.pointCoords[2 * (n - 1)], this._path.pointCoords[2 * (n - 1) + 1]);
                        }
                    } else {
                        ((Path2D.Float)path2D).moveTo(this._path.pointCoords[n4], this._path.pointCoords[n4 + 1]);
                        ((Path2D.Float)path2D).lineTo((float)dArray[n4], (float)dArray[n4 + 1]);
                        ((Path2D.Float)path2D).lineTo((float)dArray[2 * (n3 + 1)], (float)dArray[2 * (n3 + 1) + 1]);
                        ((Path2D.Float)path2D).lineTo(this._path.pointCoords[2 * (n3 + 1)], this._path.pointCoords[2 * (n3 + 1) + 1]);
                    }
                    ++n3;
                }
                if (path2D != null) {
                    path2D.closePath();
                    arrayList2.add(new LxVectorial.ShadowShapeData(this, path2D, blArray[n2 - 1]));
                }
                LxVectorial.ShadowShapeData[] shadowShapeDataArray = new LxVectorial.ShadowShapeData[arrayList2.size()];
                int n5 = 0;
                while (n5 < arrayList2.size()) {
                    shadowShapeDataArray[n5] = (LxVectorial.ShadowShapeData)arrayList2.get(n5);
                    ++n5;
                }
                return shadowShapeDataArray;
            }
        }
        return null;
    }

    protected final LxVectorial.ShapeData[] getShapeData() {
        LxVectorial.ShapeData[] shapeDataArray;
        block20: {
            LxVectorial.ShadowShapeData[] shadowShapeDataArray;
            BasePath basePath;
            block16: {
                Object[] objectArray;
                block17: {
                    Object[] objectArray2;
                    Object[] objectArray3;
                    Shape[] shapeArray;
                    block19: {
                        block18: {
                            int n = this._path.numCoords / 2;
                            basePath = this._path;
                            shadowShapeDataArray = this._getShadowShapeData(basePath);
                            if (!(this instanceof LxArrowElement) || n <= 1 || this.isClosed()) break block16;
                            objectArray = null;
                            int n2 = ((LxArrowElement)((Object)this)).getLineArrow();
                            if (n2 == 0) break block17;
                            if ((n2 & 8) != 0) break block18;
                            shapeArray = Arrow._getArrows((LxArrowElement)((Object)this), new Point2D.Float(this._path.pointCoords[0], this._path.pointCoords[1]), new Point2D.Float(this._path.pointCoords[2], this._path.pointCoords[3]), new Point2D.Float(this._path.pointCoords[this._path.numCoords - 2], this._path.pointCoords[this._path.numCoords - 1]), new Point2D.Float(this._path.pointCoords[this._path.numCoords - 4], this._path.pointCoords[this._path.numCoords - 3]));
                            objectArray = shapeArray;
                            break block17;
                        }
                        if (this.getPathSegmentCount() != 2) break block19;
                        if (this.getPathSegmentType(1) != 1) break block17;
                        shapeArray = (Shape[])this.getPathSegmentData(1);
                        objectArray3 = this.getPathSegmentData(0);
                        double d = Math.sqrt((objectArray3[0] - shapeArray[0]) * (objectArray3[0] - shapeArray[0]) + (objectArray3[1] - shapeArray[1]) * (objectArray3[1] - shapeArray[1]));
                        if (!(d > 14.0)) break block17;
                        objectArray2 = Arrow._getArrows((LxArrowElement)((Object)this), new Point2D.Float(this._path.pointCoords[0], this._path.pointCoords[1]), new Point2D.Float(this._path.pointCoords[2], this._path.pointCoords[3]), new Point2D.Float(this._path.pointCoords[this._path.numCoords - 2], this._path.pointCoords[this._path.numCoords - 1]), new Point2D.Float(this._path.pointCoords[this._path.numCoords - 4], this._path.pointCoords[this._path.numCoords - 3]));
                        objectArray = objectArray2;
                        break block17;
                    }
                    shapeArray = new Vector(5, 2);
                    int n = 1;
                    while (n < this.getPathSegmentCount()) {
                        if (this.getPathSegmentType(n) == 1) {
                            float[] fArray = this.getPathSegmentData(n - 1);
                            objectArray2 = this.getPathSegmentData(n);
                            double d = Math.sqrt((objectArray2[0] - fArray[0]) * (objectArray2[0] - fArray[0]) + (objectArray2[1] - fArray[1]) * (objectArray2[1] - fArray[1]));
                            if (d > 14.0) {
                                objectArray3 = Arrow._getArrows((LxArrowElement)((Object)this), new Point2D.Float(fArray[fArray.length - 2], fArray[fArray.length - 1]), new Point2D.Float(objectArray2[0], objectArray2[1]), new Point2D.Float(objectArray2[0], objectArray2[1]), new Point2D.Float(fArray[fArray.length - 2], fArray[fArray.length - 1]));
                                shapeArray.add(objectArray3[0]);
                            }
                        }
                        ++n;
                    }
                    objectArray = new Shape[shapeArray.size()];
                    int n3 = 0;
                    while (n3 < shapeArray.size()) {
                        objectArray[n3] = (Shape)shapeArray.get(n3);
                        ++n3;
                    }
                }
                if (objectArray != null) {
                    shapeDataArray = new LxVectorial.ShapeData[1 + objectArray.length + (shadowShapeDataArray != null ? shadowShapeDataArray.length : 0)];
                    shapeDataArray[0] = new LxVectorial.StandardShapeData(this, basePath);
                    int n = 0;
                    while (n < objectArray.length) {
                        shapeDataArray[1 + n] = new LxVectorial.LineShapeData(this, objectArray[n]);
                        ++n;
                    }
                    if (shadowShapeDataArray != null) {
                        int n4 = 0;
                        while (n4 < shadowShapeDataArray.length) {
                            shapeDataArray[n4 + 3] = shadowShapeDataArray[n4];
                            ++n4;
                        }
                    }
                } else {
                    shapeDataArray = new LxVectorial.ShapeData[1 + (shadowShapeDataArray != null ? shadowShapeDataArray.length : 0)];
                    shapeDataArray[0] = new LxVectorial.StandardShapeData(this, basePath);
                    if (shadowShapeDataArray != null) {
                        int n = 0;
                        while (n < shadowShapeDataArray.length) {
                            shapeDataArray[n + 1] = shadowShapeDataArray[n];
                            ++n;
                        }
                    }
                }
                break block20;
            }
            if (shadowShapeDataArray != null) {
                shapeDataArray = new LxVectorial.ShapeData[1 + (shadowShapeDataArray != null ? shadowShapeDataArray.length : 0)];
                shapeDataArray[0] = new LxVectorial.StandardShapeData(this, basePath);
                if (shadowShapeDataArray != null) {
                    int n = 0;
                    while (n < shadowShapeDataArray.length) {
                        shapeDataArray[n + 1] = shadowShapeDataArray[n];
                        ++n;
                    }
                }
            } else {
                shapeDataArray = new LxVectorial.ShapeData[]{new LxVectorial.StandardShapeData(this, basePath)};
            }
        }
        int n = 0;
        while (n < shapeDataArray.length) {
            shapeDataArray[n]._setSharable(false);
            ++n;
        }
        return shapeDataArray;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public int getPathSegmentCount() {
        return this._path.numTypes;
    }

    public byte getPathSegmentType(int n) {
        return this._path.pointTypes[n];
    }

    public int getPathSegmentPointsCount(int n) {
        switch (this.getPathSegmentType(n)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public float[] getPathSegmentData(int n) {
        int n2 = this.getPathSegmentPointsCount(n);
        float[] fArray = null;
        int n3 = 0;
        fArray = new float[n2 * 2];
        int n4 = 0;
        while (n4 < n) {
            switch (this._path.pointTypes[n4]) {
                case 0: {
                    n3 += 2;
                    break;
                }
                case 1: {
                    n3 += 2;
                    break;
                }
                case 2: {
                    n3 += 4;
                    break;
                }
                case 3: {
                    n3 += 6;
                }
            }
            ++n4;
        }
        int n5 = 0;
        n4 = n3;
        while (n4 < n3 + n2 * 2) {
            fArray[n5++] = this._path.pointCoords[n4];
            ++n4;
        }
        return fArray;
    }

    public int getPathSegmentTypeFromPoint(int n) {
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        if (n < 0 || n >= this._path.numCoords / 2) {
            return -1;
        }
        if (n == 0) {
            return 0;
        }
        int n5 = 1;
        while (n5 < this._path.numTypes) {
            switch (this._path.pointTypes[n5]) {
                case 0: {
                    n4 = 1;
                    n2 = 0;
                    break;
                }
                case 1: {
                    n4 = 1;
                    n2 = 1;
                    break;
                }
                case 2: {
                    n4 = 2;
                    n2 = 2;
                    break;
                }
                case 3: {
                    n4 = 3;
                    n2 = 3;
                }
            }
            if (n >= n3 && n <= n3 + n4) {
                return n2;
            }
            n3 += n4;
            ++n5;
        }
        return n2;
    }

    public Shape[] getShape() {
        LxVectorial.ShapeData[] shapeDataArray = this.getShapeData();
        Shape[] shapeArray = new Shape[shapeDataArray.length];
        int n = 0;
        while (n < shapeDataArray.length) {
            shapeArray[n] = shapeDataArray[n].shape;
            ++n;
        }
        return shapeArray;
    }

    public void addPath(double d, double d2) {
        this.addPath(d, d2, false);
    }

    public void addPath(double d, double d2, boolean bl) {
        boolean bl2 = this._closed;
        this._setClosed(false, false, false);
        if (this._path.numTypes == 0) {
            this._cx = d;
            this._cy = d2;
            this._needRoom(1, 2, false);
            this._path.pointTypes[this._path.numTypes++] = 0;
            this._path.pointCoords[this._path.numCoords++] = 0.0f;
            this._path.pointCoords[this._path.numCoords++] = 0.0f;
            this.setBounds(new Rectangle2D.Double(this._cx - 1.0, this._cy - 1.0, 2.0, 2.0));
        } else {
            this._needRoom(1, 2, false);
            this._path.pointTypes[this._path.numTypes++] = !bl ? (byte)1 : 0;
            this._path.pointCoords[this._path.numCoords++] = (float)(d - this._cx);
            this._path.pointCoords[this._path.numCoords++] = (float)(d2 - this._cy);
            this.resetToCenter(true);
        }
        this._setClosed(bl2, false, false);
        if (this._handles2 != null) {
            this.createHandles();
        }
        int n = (this._path.numCoords - 1) / 2;
        if (this._doPathUpdated) {
            this.pathUpdated();
        }
    }

    public void addPath(double d, double d2, double d3, double d4) {
        boolean bl = this._closed;
        this._setClosed(false, false, false);
        if (this._path.numTypes == 0) {
            this._cx = d;
            this._cy = d2;
            this._needRoom(1, 4, false);
            this._path.pointTypes[this._path.numTypes++] = 0;
            this._path.pointCoords[this._path.numCoords++] = 0.0f;
            this._path.pointCoords[this._path.numCoords++] = 0.0f;
            this.setBounds(new Rectangle2D.Double(this._cx - 1.0, this._cy - 1.0, 2.0, 2.0));
        } else {
            this._needRoom(1, 4, false);
            this._path.pointTypes[this._path.numTypes++] = 2;
            this._path.pointCoords[this._path.numCoords++] = (float)(d - this._cx);
            this._path.pointCoords[this._path.numCoords++] = (float)(d2 - this._cy);
            this._path.pointCoords[this._path.numCoords++] = (float)(d3 - this._cx);
            this._path.pointCoords[this._path.numCoords++] = (float)(d4 - this._cy);
            this.resetToCenter(true);
        }
        this._setClosed(bl, false, false);
        if (this._handles2 != null) {
            this.createHandles();
        }
        int n = (this._path.numCoords - 3) / 2;
        if (this._doPathUpdated) {
            this.pathUpdated();
        }
    }

    public void addPath(double d, double d2, double d3, double d4, double d5, double d6) {
        boolean bl = this._closed;
        this._setClosed(false, false, false);
        if (this._path.numTypes == 0) {
            this._cx = d;
            this._cy = d2;
            this._needRoom(1, 6, false);
            this._path.pointTypes[this._path.numTypes++] = 0;
            this._path.pointCoords[this._path.numCoords++] = 0.0f;
            this._path.pointCoords[this._path.numCoords++] = 0.0f;
            this.setBounds(new Rectangle2D.Double(this._cx - 1.0, this._cy - 1.0, 2.0, 2.0));
        } else {
            this._needRoom(1, 6, false);
            this._path.pointTypes[this._path.numTypes++] = 3;
            this._path.pointCoords[this._path.numCoords++] = (float)(d - this._cx);
            this._path.pointCoords[this._path.numCoords++] = (float)(d2 - this._cy);
            this._path.pointCoords[this._path.numCoords++] = (float)(d3 - this._cx);
            this._path.pointCoords[this._path.numCoords++] = (float)(d4 - this._cy);
            this._path.pointCoords[this._path.numCoords++] = (float)(d5 - this._cx);
            this._path.pointCoords[this._path.numCoords++] = (float)(d6 - this._cy);
            this.resetToCenter(true);
        }
        this._setClosed(bl, false, false);
        if (this._handles2 != null) {
            this.createHandles();
        }
        int n = (this._path.numCoords - 5) / 2;
        if (this._doPathUpdated) {
            this.pathUpdated();
        }
    }

    protected LxHandle createHandle(Point2D point2D, int n, int n2) {
        final LxPathElement lxPathElement = this;
        LxHandle lxHandle = new LxHandle(point2D);
        if (this._handles2_lstnr == null) {
            this._handles2_lstnr = new LxHandleAdapter(){
                Point2D old;
                int indexPtUndo;

                public void handlePressed(LxHandleEvent lxHandleEvent) {
                    int n = 0;
                    while (n < LxPathElement.this._handles2.length) {
                        if (LxPathElement.this._handles2[n] == lxHandleEvent.getHandle()) {
                            this.old = LxPathElement.this.getPathPoint(n);
                            this.indexPtUndo = n;
                            return;
                        }
                        ++n;
                    }
                }

                public void handleReleased(LxHandleEvent lxHandleEvent) {
                    LxPathElement.this.addUndoEdit(new ReplaceEdit(lxPathElement, this.old, this.indexPtUndo));
                }

                public void handleDragged(LxHandleEvent lxHandleEvent) {
                    if (LxPathElement.this.isGhost()) {
                        return;
                    }
                    Rectangle2D rectangle2D = LxPathElement.this.getStrokedBounds2D();
                    double d = LxPathElement.this.getWidth();
                    double d2 = LxPathElement.this.getHeight();
                    if (d == 0.0) {
                        d = 1.0;
                    }
                    if (d2 == 0.0) {
                        d2 = 1.0;
                    }
                    LxHandle lxHandle = lxHandleEvent.getHandle();
                    int n = this.indexPtUndo * 2;
                    ((LxPathElement)LxPathElement.this)._path.pointCoords[n] = (float)((double)((LxPathElement)LxPathElement.this)._path.pointCoords[n] + lxHandleEvent.getDeltaX());
                    int n2 = this.indexPtUndo * 2 + 1;
                    ((LxPathElement)LxPathElement.this)._path.pointCoords[n2] = (float)((double)((LxPathElement)LxPathElement.this)._path.pointCoords[n2] + lxHandleEvent.getDeltaY());
                    lxHandle.setCenter((double)((LxPathElement)LxPathElement.this)._path.pointCoords[this.indexPtUndo * 2] / d, (double)((LxPathElement)LxPathElement.this)._path.pointCoords[this.indexPtUndo * 2 + 1] / d2);
                    LxPathElement.this.resetToCenter(true);
                    LxPathElement.this.pathUpdated();
                    LxPathElement.this.fireComponentMorphed(rectangle2D);
                }
            };
        }
        this._handles2[n2] = lxHandle;
        lxHandle.setFlyoverCursor(Cursor.getPredefinedCursor(1));
        lxHandle.addHandleListener(this._handles2_lstnr);
        lxHandle.setFilled(n == 0);
        this._addHandle(lxHandle, false);
        return lxHandle;
    }

    public void flip() {
        this.addUndoEdit(new FlipEdit(this));
        Rectangle2D rectangle2D = this.getStrokedBounds2D();
        int n = this.getPathPointCount() * 2;
        int n2 = 0;
        while (n2 < n) {
            this._path.pointCoords[n2 + 1] = -this._path.pointCoords[n2 + 1];
            n2 += 2;
        }
        this.resetToCenter(true);
        this.fireComponentMorphed(rectangle2D);
    }

    public double[] getPath() {
        int n = this.getPathPointCount();
        double[] dArray = new double[2 * n];
        this._cx = this.getCenterX();
        this._cy = this.getCenterY();
        int n2 = 0;
        while (n2 < n) {
            dArray[2 * n2] = (double)this._path.pointCoords[n2 * 2] + this._cx;
            dArray[2 * n2 + 1] = (double)this._path.pointCoords[n2 * 2 + 1] + this._cy;
            ++n2;
        }
        return dArray;
    }

    public Point2D getPathPoint(int n) {
        int n2 = n << 1;
        return new Point2DDouble((double)this._path.pointCoords[n2] + this.getCenterX(), (double)this._path.pointCoords[n2 + 1] + this.getCenterY());
    }

    public int getPathPointCount() {
        int n = this._path.numCoords / 2;
        return n;
    }

    public Point2D[] getPathPoints() {
        int n = this.getPathPointCount();
        Point2D[] point2DArray = new Point2D[n];
        this._cx = this.getCenterX();
        this._cy = this.getCenterY();
        int n2 = 0;
        while (n2 < n) {
            double d = (double)this._path.pointCoords[n2 * 2] + this._cx;
            double d2 = (double)this._path.pointCoords[n2 * 2 + 1] + this._cy;
            point2DArray[n2] = new Point2D.Double(d, d2);
            ++n2;
        }
        return point2DArray;
    }

    protected Point2D[] getPathPoints(int n) {
        return null;
    }

    public void insertPath(double d, double d2, int n) {
        this.insertPath(d, d2, n, false);
    }

    public void insertPath(double d, double d2, int n, boolean bl) {
        int n2 = 2;
        int n3 = 0;
        int n4 = n;
        if (this._path.numCoords == 0) {
            this.addPath(0.0, 0.0);
            this.addPath(d, d2);
            return;
        }
        if (n4 <= 0) {
            n4 = 1;
        } else if (n4 > this._path.numTypes) {
            n4 = this._path.numTypes;
        }
        int n5 = 0;
        while (n5 < n4) {
            switch (this._path.pointTypes[n5]) {
                case 0: {
                    n3 += 2;
                    break;
                }
                case 1: {
                    n3 += 2;
                    break;
                }
                case 2: {
                    n3 += 4;
                    break;
                }
                case 3: {
                    n3 += 6;
                }
            }
            ++n5;
        }
        float[] fArray = new float[this._path.numCoords + n2];
        n5 = 0;
        while (n5 < n3) {
            fArray[n5] = this._path.pointCoords[n5];
            ++n5;
        }
        fArray[n5++] = (float)(d - this.getCenterX());
        fArray[n5++] = (float)(d2 - this.getCenterY());
        int n6 = n3;
        while (n6 < this._path.numCoords) {
            fArray[n5++] = this._path.pointCoords[n6];
            ++n6;
        }
        this._path.pointCoords = null;
        this._path.pointCoords = fArray;
        this._path.numCoords = n5;
        if (n4 == 0) {
            n4 = 1;
        }
        byte[] byArray = new byte[this._path.numTypes + 1];
        n5 = 0;
        while (n5 < n4) {
            byArray[n5] = this._path.pointTypes[n5];
            ++n5;
        }
        byArray[n5++] = !bl ? (byte)1 : 0;
        n6 = n4;
        while (n6 < this._path.numTypes) {
            byArray[n5++] = this._path.pointTypes[n6];
            ++n6;
        }
        this._path.pointTypes = null;
        this._path.pointTypes = byArray;
        this._path.numTypes = n5;
        if (this._handles2 != null) {
            this.createHandles();
        }
        this.resetToCenter(true);
        if (this._doPathUpdated) {
            this.pathUpdated();
        }
    }

    public void insertPath(double d, double d2, double d3, double d4, int n) {
        int n2 = 4;
        int n3 = 0;
        int n4 = n;
        if (this._path.numCoords == 0) {
            this.addPath(0.0, 0.0);
            this.addPath(d, d2, d3, d4);
            return;
        }
        if (n4 <= 0) {
            n4 = 1;
        } else if (n4 > this._path.numTypes) {
            n4 = this._path.numTypes;
        }
        int n5 = 0;
        while (n5 < n4) {
            switch (this._path.pointTypes[n5]) {
                case 0: {
                    n3 += 2;
                    break;
                }
                case 1: {
                    n3 += 2;
                    break;
                }
                case 2: {
                    n3 += 4;
                    break;
                }
                case 3: {
                    n3 += 6;
                }
            }
            ++n5;
        }
        float[] fArray = new float[this._path.numCoords + n2];
        n5 = 0;
        while (n5 < n3) {
            fArray[n5] = this._path.pointCoords[n5];
            ++n5;
        }
        fArray[n5++] = (float)(d - this.getCenterX());
        fArray[n5++] = (float)(d2 - this.getCenterY());
        fArray[n5++] = (float)(d3 - this.getCenterX());
        fArray[n5++] = (float)(d4 - this.getCenterY());
        int n6 = n3;
        while (n6 < this._path.numCoords) {
            fArray[n5++] = this._path.pointCoords[n6];
            ++n6;
        }
        this._path.pointCoords = null;
        this._path.pointCoords = fArray;
        this._path.numCoords = n5;
        if (n4 == 0) {
            n4 = 1;
        }
        byte[] byArray = new byte[this._path.numTypes + 1];
        n5 = 0;
        while (n5 < n4) {
            byArray[n5] = this._path.pointTypes[n5];
            ++n5;
        }
        byArray[n5++] = 2;
        n6 = n4;
        while (n6 < this._path.numTypes) {
            byArray[n5++] = this._path.pointTypes[n6];
            ++n6;
        }
        this._path.pointTypes = null;
        this._path.pointTypes = byArray;
        this._path.numTypes = n5;
        if (this._handles2 != null) {
            this.createHandles();
        }
        this.resetToCenter(true);
        if (this._doPathUpdated) {
            this.pathUpdated();
        }
    }

    public void insertPath(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        int n2 = 6;
        int n3 = 0;
        int n4 = n;
        if (this._path.numCoords == 0) {
            this.addPath(0.0, 0.0);
            this.addPath(d, d2, d3, d4, d5, d6);
            return;
        }
        if (n4 <= 0) {
            n4 = 1;
        } else if (n4 > this._path.numTypes) {
            n4 = this._path.numTypes;
        }
        int n5 = 0;
        while (n5 < n4) {
            switch (this._path.pointTypes[n5]) {
                case 0: {
                    n3 += 2;
                    break;
                }
                case 1: {
                    n3 += 2;
                    break;
                }
                case 2: {
                    n3 += 4;
                    break;
                }
                case 3: {
                    n3 += 6;
                }
            }
            ++n5;
        }
        float[] fArray = new float[this._path.numCoords + n2];
        n5 = 0;
        while (n5 < n3) {
            fArray[n5] = this._path.pointCoords[n5];
            ++n5;
        }
        fArray[n5++] = (float)(d - this.getCenterX());
        fArray[n5++] = (float)(d2 - this.getCenterY());
        fArray[n5++] = (float)(d3 - this.getCenterX());
        fArray[n5++] = (float)(d4 - this.getCenterY());
        fArray[n5++] = (float)(d5 - this.getCenterX());
        fArray[n5++] = (float)(d6 - this.getCenterY());
        int n6 = n3;
        while (n6 < this._path.numCoords) {
            fArray[n5++] = this._path.pointCoords[n6];
            ++n6;
        }
        this._path.pointCoords = null;
        this._path.pointCoords = fArray;
        this._path.numCoords = n5;
        if (n4 == 0) {
            n4 = 1;
        }
        byte[] byArray = new byte[this._path.numTypes + 1];
        n5 = 0;
        while (n5 < n4) {
            byArray[n5] = this._path.pointTypes[n5];
            ++n5;
        }
        byArray[n5++] = 3;
        n6 = n4;
        while (n6 < this._path.numTypes) {
            byArray[n5++] = this._path.pointTypes[n6];
            ++n6;
        }
        this._path.pointTypes = null;
        this._path.pointTypes = byArray;
        this._path.numTypes = n5;
        if (this._handles2 != null) {
            this.createHandles();
        }
        this.resetToCenter(true);
        if (this._doPathUpdated) {
            this.pathUpdated();
        }
    }

    public void mirror() {
        this.addUndoEdit(new MirrorEdit(this));
        Rectangle2D rectangle2D = this.getStrokedBounds2D();
        int n = this.getPathPointCount() * 2;
        int n2 = 0;
        while (n2 < n) {
            this._path.pointCoords[n2] = -this._path.pointCoords[n2];
            n2 += 2;
        }
        this.resetToCenter(true);
        this.fireComponentMorphed(rectangle2D);
    }

    public void removeAllPathPoints() {
        if (this._path.numTypes == 0 && this._path.numCoords == 0) {
            return;
        }
        this._allPointsRemoved = true;
        this._path.pointTypes = new byte[2];
        this._path.pointCoords = new float[4];
        this._path.numTypes = 0;
        this._path.numCoords = 0;
        this.setSelected(false);
        if (this._handles2 != null) {
            LxHandle[] lxHandleArray = this.getHandles();
            int n = 0;
            while (n < lxHandleArray.length) {
                this.removeHandle(lxHandleArray[n]);
                ++n;
            }
            this._handles2 = null;
            this._handles = null;
        }
    }

    protected void removePathPoint(int n) {
    }

    public void removePath(int n) {
        int n2 = 0;
        if (n >= this._path.numTypes) {
            return;
        }
        switch (this._path.pointTypes[n]) {
            case 0: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 6;
            }
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            switch (this._path.pointTypes[n4]) {
                case 0: {
                    n3 += 2;
                    break;
                }
                case 1: {
                    n3 += 2;
                    break;
                }
                case 2: {
                    n3 += 4;
                    break;
                }
                case 3: {
                    n3 += 6;
                }
            }
            ++n4;
        }
        n4 = n;
        while (n4 < this._path.numTypes - 1) {
            this._path.pointTypes[n4] = this._path.pointTypes[n4 + 1];
            ++n4;
        }
        n4 = n3 + n2;
        while (n4 < this._path.numCoords) {
            this._path.pointCoords[n4 - n2] = this._path.pointCoords[n4];
            ++n4;
        }
        --this._path.numTypes;
        this._path.numCoords -= n2;
        if (this._handles2 != null) {
            this.createHandles();
        }
        this.resetToCenter(true);
        if (this._doPathUpdated) {
            this.pathUpdated();
        }
    }

    public void replacePath(double d, double d2, int n) {
        if (this._path.numTypes == 0 || this._path.numCoords == 0 || n >= this._path.numCoords) {
            return;
        }
        int n2 = n * 2;
        this._path.pointCoords[n2] = (float)(d - this.getCenterX());
        this._path.pointCoords[n2 + 1] = (float)(d2 - this.getCenterY());
        this.resetToCenter(true);
        this.pathUpdated();
    }

    public void replacePathWithLine(double d, double d2, int n) {
        if (this._path.numTypes == 0 || this._path.numCoords == 0 || n <= 0 || n >= this._path.numTypes) {
            return;
        }
        this._doPathUpdated = false;
        this.removePath(n);
        this.insertPath(d, d2, n);
        this._doPathUpdated = true;
        if (this._handles2 != null) {
            this.createHandles();
        }
        this.resetToCenter(true);
        this.pathUpdated();
    }

    public void replacePathWithMoveTo(double d, double d2, int n) {
        if (this._path.numTypes == 0 || this._path.numCoords == 0 || n <= 0 || n >= this._path.numTypes) {
            return;
        }
        this._doPathUpdated = false;
        this.removePath(n);
        this.insertPath(d, d2, n, true);
        this._doPathUpdated = true;
        if (this._handles2 != null) {
            this.createHandles();
        }
        this.resetToCenter(true);
        this.pathUpdated();
    }

    public void replacePath(double d, double d2, double d3, double d4, int n) {
        if (this._path.numTypes == 0 || this._path.numCoords == 0 || n <= 0 || n >= this._path.numTypes) {
            return;
        }
        this._doPathUpdated = false;
        this.removePath(n);
        this.insertPath(d, d2, d3, d4, n);
        this._doPathUpdated = true;
        if (this._handles2 != null) {
            this.createHandles();
        }
        this.resetToCenter(true);
        this.pathUpdated();
    }

    public void replacePath(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        if (this._path.numTypes == 0 || this._path.numCoords == 0 || n <= 0 || n >= this._path.numTypes) {
            return;
        }
        this._doPathUpdated = false;
        this.removePath(n);
        this.insertPath(d, d2, d3, d4, d5, d6, n);
        this._doPathUpdated = true;
        if (this._handles2 != null) {
            this.createHandles();
        }
        this.resetToCenter(true);
        this.pathUpdated();
    }

    void setClosed(boolean bl, boolean bl2) {
        this._setClosed(bl, bl2, true);
    }

    void _setClosed(boolean bl, boolean bl2, boolean bl3) {
        if (bl == this._closed) {
            return;
        }
        boolean bl4 = this._closed;
        Rectangle2D rectangle2D = null;
        if (bl2) {
            rectangle2D = this.getStrokedBounds2D();
        }
        if (bl) {
            if (this._path.numTypes == 0 || this._path.pointTypes[this._path.numTypes - 1] != 4) {
                this._needRoom(1, 0, true);
                this._path.pointTypes[this._path.numTypes++] = 4;
            }
        } else {
            int n = this._path.numTypes - 1;
            if (this._path.numTypes > 0 && this._path.pointTypes[n] == 4) {
                --this._path.numTypes;
            }
        }
        this._closed = bl;
        if (bl3 && this._undoOn()) {
            this.addUndoEdit(new CloseEdit(this, bl4));
        }
        if (bl2) {
            this.fireComponentMorphed(rectangle2D);
        }
        this._setActionState(OPEN_ACTION, !this._closed);
    }

    public void setClosed(boolean bl) {
        this._setClosed(bl, true, true);
    }

    public void setPath(double[] dArray) {
        double d;
        double d2;
        int n = dArray.length / 2;
        int n2 = n * 2;
        Rectangle2D rectangle2D = this.getStrokedBounds2D();
        boolean bl = this._closed;
        this._closed = false;
        this._cx = 0.0;
        this._cy = 0.0;
        this._path.pointTypes = new byte[n + 1];
        this._path.pointCoords = new float[n2];
        this._path.numTypes = n;
        this._path.numCoords = n2;
        if (n == 0) {
            return;
        }
        double d3 = d2 = dArray[0];
        double d4 = d = dArray[1];
        int n3 = 0;
        while (n3 < n2) {
            double d5 = dArray[n3];
            double d6 = dArray[n3 + 1];
            d3 = d5 < d3 ? d5 : d3;
            d4 = d6 < d4 ? d6 : d4;
            d2 = d5 > d2 ? d5 : d2;
            d = d6 > d ? d6 : d;
            n3 += 2;
        }
        this._cx = (d3 + d2) / 2.0;
        this._cy = (d4 + d) / 2.0;
        n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            this._path.pointTypes[n4] = 1;
            this._path.pointCoords[n3] = (float)(dArray[n3] - this._cx);
            this._path.pointCoords[n3 + 1] = (float)(dArray[n3 + 1] - this._cy);
            n3 += 2;
            ++n4;
        }
        this._path.pointTypes[0] = 0;
        Object var20_14 = null;
        this.setClosed(bl, false);
        this.setBounds(new Rectangle2D.Double(d3, d4, d2 - d3, d - d4));
        if (this._handles2 != null) {
            this.createHandles();
        }
        this.resetToCenter(true);
        this.pathUpdated();
    }

    public void setPathSegmentTypes(byte[] byArray) {
        this._path.pointTypes = null;
        this._path.pointTypes = byArray;
        this._path.numTypes = byArray.length;
    }

    public void pathUpdated() {
    }

    public Point2D getRotationCenter() {
        int n = this.getPathPointCount() * 2;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += (double)this._path.pointCoords[n2];
            d2 += (double)this._path.pointCoords[n2 + 1];
            n2 += 2;
        }
        return new Point2D.Double((d /= (double)(n / 2)) + this.getCenterX(), (d2 /= (double)(n / 2)) + this.getCenterY());
    }

    private void _needRoom(int n, int n2, boolean bl) {
        Object[] objectArray;
        int n3;
        if (bl && this._path.numTypes == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        int n4 = this._path.pointCoords.length;
        if (this._path.numCoords + n2 > n4) {
            n3 = n4;
            if (n3 > 40) {
                n3 = 40;
            }
            if (n3 < n2) {
                n3 = n2;
            }
            objectArray = new float[n4 + n3];
            System.arraycopy(this._path.pointCoords, 0, objectArray, 0, this._path.numCoords);
            this._path.pointCoords = objectArray;
        }
        if (this._path.numTypes + n > (n4 = this._path.pointTypes.length)) {
            n3 = n4;
            if (n3 > 20) {
                n3 = 20;
            }
            if (n3 < n) {
                n3 = n;
            }
            objectArray = new byte[n4 + n3];
            System.arraycopy(this._path.pointTypes, 0, objectArray, 0, this._path.numTypes);
            this._path.pointTypes = (byte[])objectArray;
        }
    }

    private void resetToCenter(boolean bl) {
        double d;
        double d2;
        int n = this._path.numCoords / 2;
        int n2 = n * 2;
        if (n == 0) {
            return;
        }
        this.startUndoEdit("throw me away!");
        this._cx = this.getCenterX();
        this._cy = this.getCenterY();
        double d3 = d2 = this._cx + (double)this._path.pointCoords[0];
        double d4 = d = this._cy + (double)this._path.pointCoords[1];
        int n3 = 0;
        while (n3 < n2) {
            double d5 = this._cx + (double)this._path.pointCoords[n3];
            double d6 = this._cy + (double)this._path.pointCoords[n3 + 1];
            d3 = d5 < d3 ? d5 : d3;
            d4 = d6 < d4 ? d6 : d4;
            d2 = d5 > d2 ? d5 : d2;
            d = d6 > d ? d6 : d;
            n3 += 2;
        }
        double d7 = (d3 + d2) / 2.0;
        double d8 = (d4 + d) / 2.0;
        double d9 = this._cx - d7;
        double d10 = this._cy - d8;
        n3 = 0;
        while (n3 < n2) {
            this._path.pointCoords[n3] = (float)d9 + this._path.pointCoords[n3];
            this._path.pointCoords[n3 + 1] = (float)d10 + this._path.pointCoords[n3 + 1];
            n3 += 2;
        }
        this._cx = d7;
        this._cy = d8;
        if (this._handles2 != null) {
            int n4 = this._handles2.length;
            double d11 = d2 - d3;
            double d12 = d - d4;
            if (d11 == 0.0) {
                d11 = 1.0;
            }
            if (d12 == 0.0) {
                d12 = 1.0;
            }
            n3 = 0;
            while (n3 < n4) {
                LxHandle lxHandle = this._handles2[n3];
                if (lxHandle != null && n3 * 2 <= this._path.pointCoords.length && n3 * 2 + 1 <= this._path.pointCoords.length) {
                    lxHandle.setCenter((double)this._path.pointCoords[n3 * 2] / d11, (double)this._path.pointCoords[n3 * 2 + 1] / d12);
                }
                ++n3;
            }
        }
        if (bl) {
            this.setBounds(new Rectangle2D.Double(d3, d4, d2 - d3, d - d4));
        }
        Rectangle2D rectangle2D = this.getStrokedBounds2D();
        this.fireComponentMorphed(rectangle2D);
        this.cancelUndoEdit();
    }

    private Shape _getPath(int n) {
        return null;
    }

    private void _initObjectVariables() {
        this._handles2 = null;
        this._handles2_lstnr = null;
        this.addComponentListener(new LxComponentAdapter(){

            public void componentResized(LxComponentEvent lxComponentEvent) {
                if (LxPathElement.this.getPathPointCount() == 0) {
                    return;
                }
                Rectangle2D rectangle2D = LxPathElement.this.getStrokedBounds2D();
                Rectangle2D rectangle2D2 = LxPathElement.this._path.getBounds2D();
                if (rectangle2D2.getWidth() != LxPathElement.this.getWidth() || rectangle2D2.getHeight() != LxPathElement.this.getHeight()) {
                    double d = LxPathElement.this.getWidth() != 0.0 ? LxPathElement.this.getWidth() : 1.0;
                    double d2 = LxPathElement.this.getHeight() != 0.0 ? LxPathElement.this.getHeight() : 1.0;
                    double d3 = rectangle2D2.getWidth() != 0.0 ? d / rectangle2D2.getWidth() : d;
                    double d4 = rectangle2D2.getHeight() != 0.0 ? d2 / rectangle2D2.getHeight() : d2;
                    int n = LxPathElement.this.getPathPointCount() * 2;
                    int n2 = 0;
                    while (n2 < n) {
                        int n3 = n2;
                        ((LxPathElement)LxPathElement.this)._path.pointCoords[n3] = (float)((double)((LxPathElement)LxPathElement.this)._path.pointCoords[n3] * d3);
                        int n4 = n2 + 1;
                        ((LxPathElement)LxPathElement.this)._path.pointCoords[n4] = (float)((double)((LxPathElement)LxPathElement.this)._path.pointCoords[n4] * d4);
                        n2 += 2;
                    }
                    LxPathElement.this.fireComponentMorphed(rectangle2D);
                }
            }
        });
    }

    public void rotate(double d) {
        AffineTransform affineTransform = new AffineTransform();
        Point2D point2D = this.getRotationCenter();
        Rectangle2D rectangle2D = this.getStrokedBounds2D();
        affineTransform.rotate(d, point2D.getX() - this.getCenterX(), point2D.getY() - this.getCenterY());
        affineTransform.transform(this._path.pointCoords, 0, this._path.pointCoords, 0, this._path.numCoords / 2);
        this.resetToCenter(true);
        this.addUndoEdit(new RotateEdit(this, d, point2D.getX(), point2D.getY()));
        this.fireComponentMorphed(rectangle2D);
    }

    public void rotate(double d, double d2, double d3) {
        AffineTransform affineTransform = new AffineTransform();
        this.addUndoEdit(new RotateEdit(this, d, d2, d3));
        Rectangle2D rectangle2D = this.getStrokedBounds2D();
        affineTransform.rotate(d, d2 - this.getCenterX(), d3 - this.getCenterY());
        affineTransform.transform(this._path.pointCoords, 0, this._path.pointCoords, 0, this._path.numCoords / 2);
        this.resetToCenter(true);
        this.fireComponentMorphed(rectangle2D);
    }

    private static final class RotateEdit
    extends LooxCollapsableEdit {
        private static final String ROTATE_UNDO = "rotate-pathUndo";
        private double _val;
        private double _cx;
        private double _cy;

        public RotateEdit(LxPathElement lxPathElement, double d, double d2, double d3) {
            super(lxPathElement, Resources.get(ROTATE_UNDO, "rotate path"));
            this._val = d;
            this._cx = d2;
            this._cy = d3;
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
            RotateEdit rotateEdit = (RotateEdit)looxCollapsableEdit;
            this._val += rotateEdit._val;
        }

        void _undoEdit(boolean bl) {
            LxPathElement lxPathElement = (LxPathElement)this._getHost();
            lxPathElement.startUndoEdit("throw me away!");
            this._val = -1.0 * this._val;
            lxPathElement.rotate(this._val, this._cx, this._cy);
            lxPathElement.cancelUndoEdit();
        }
    }

    private static final class MirrorEdit
    extends LooxCollapsableEdit {
        private static final String MIRROR_UNDO = "mirror-pathUndo";

        public MirrorEdit(LxPathElement lxPathElement) {
            super(lxPathElement, Resources.get(MIRROR_UNDO, "mirror path"));
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
        }

        void _undoEdit(boolean bl) {
            LxPathElement lxPathElement = (LxPathElement)this._getHost();
            lxPathElement.startUndoEdit("throw me away!");
            lxPathElement.mirror();
            lxPathElement.cancelUndoEdit();
        }
    }

    private static final class FlipEdit
    extends LooxCollapsableEdit {
        private static final String FLIP_UNDO = "flip-pathUndo";

        public FlipEdit(LxPathElement lxPathElement) {
            super(lxPathElement, Resources.get(FLIP_UNDO, "flip path"));
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
        }

        void _undoEdit(boolean bl) {
            LxPathElement lxPathElement = (LxPathElement)this._getHost();
            lxPathElement.startUndoEdit("throw me away!");
            lxPathElement.flip();
            lxPathElement.cancelUndoEdit();
        }
    }

    private static final class CloseEdit
    extends LooxUndoableEdit {
        private static final String CLOSE_UNDO = "close-pathUndo";

        public CloseEdit(LxPathElement lxPathElement, boolean bl) {
            super(lxPathElement, Resources.get(CLOSE_UNDO, "close path"), bl);
        }

        void _undoEdit(boolean bl) {
            LxPathElement lxPathElement = (LxPathElement)this._getHost();
            lxPathElement._setClosed(bl, true, false);
        }
    }

    static final class ReplaceMultiEdit
    extends LooxCollapsableEdit {
        private static final String REPLACE_UNDO = "move-pointsUndo";
        private Point2D[] _pts;
        private int[] _indexes;

        public ReplaceMultiEdit(LxPathElement lxPathElement, Point2D[] point2DArray, int[] nArray) {
            super(lxPathElement, Resources.get(REPLACE_UNDO, "drag points"));
            this._pts = point2DArray;
            this._indexes = nArray;
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
            ReplaceMultiEdit replaceMultiEdit = (ReplaceMultiEdit)looxCollapsableEdit;
            this._pts = replaceMultiEdit._pts;
            this._indexes = replaceMultiEdit._indexes;
        }

        void _undoEdit(boolean bl) {
            LxPathElement lxPathElement = (LxPathElement)this._getHost();
            Point2D[] point2DArray = new Point2D[this._pts.length];
            lxPathElement.startUndoEdit("throw me away!");
            double[] dArray = lxPathElement.getPath();
            int n = 0;
            while (n < this._pts.length) {
                point2DArray[n] = lxPathElement.getPathPoint(this._indexes[n]);
                dArray[2 * this._indexes[n]] = this._pts[n].getX();
                dArray[2 * this._indexes[n] + 1] = this._pts[n].getY();
                ++n;
            }
            lxPathElement.setPath(dArray);
            lxPathElement.cancelUndoEdit();
            this._pts = point2DArray;
        }

        public boolean isReplacable(UndoableEdit undoableEdit) {
            if (super.isReplacable(undoableEdit) && undoableEdit instanceof ReplaceMultiEdit && ((ReplaceMultiEdit)undoableEdit)._indexes.length == this._indexes.length) {
                int n = 0;
                while (n < this._indexes.length) {
                    if (this._indexes[n] != ((ReplaceMultiEdit)undoableEdit)._indexes[n]) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            return false;
        }
    }

    private static final class ReplaceEdit
    extends LooxCollapsableEdit {
        private static final String REPLACE_UNDO = "move-pointUndo";
        private Point2D _pts;
        private int _index;

        public ReplaceEdit(LxPathElement lxPathElement, Point2D point2D, int n) {
            super(lxPathElement, Resources.get(REPLACE_UNDO, "drag point"));
            this._pts = point2D;
            this._index = n;
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
            ReplaceEdit replaceEdit = (ReplaceEdit)looxCollapsableEdit;
            this._pts = replaceEdit._pts;
            this._index = replaceEdit._index;
        }

        void _undoEdit(boolean bl) {
            LxPathElement lxPathElement = (LxPathElement)this._getHost();
            Point2D point2D = lxPathElement.getPathPoint(this._index);
            lxPathElement.startUndoEdit("throw me away!");
            lxPathElement.replacePath(this._pts.getX(), this._pts.getY(), this._index);
            lxPathElement.cancelUndoEdit();
            this._pts = point2D;
        }

        public boolean isReplacable(UndoableEdit undoableEdit) {
            if (super.isReplacable(undoableEdit) && undoableEdit instanceof ReplaceEdit) {
                return this._index == ((ReplaceEdit)undoableEdit)._index;
            }
            return false;
        }
    }

    final class OpenCloseAction
    extends LxAbstractToggleAction
    implements Serializable {
        OpenCloseAction() {
            super(LxPathElement.OPEN_ACTION, "Open", "Disconnect first point from last", null, "Open", "Connect first point to last", null, false, true);
            this.setState(!LxPathElement.this.isClosed());
        }

        public void processAction(ActionEvent actionEvent) {
            LxPathElement.this.setClosed(!LxPathElement.this.isClosed());
        }
    }
}

