/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.Lx;
import com.loox.jloox.LxAbstractArray;
import com.loox.jloox.LxAbstractCircle;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxAbstractGroup;
import com.loox.jloox.LxAbstractImage;
import com.loox.jloox.LxAbstractLink;
import com.loox.jloox.LxAbstractPushButton;
import com.loox.jloox.LxAbstractRectangle;
import com.loox.jloox.LxAbstractReference;
import com.loox.jloox.LxAbstractSlider;
import com.loox.jloox.LxAbstractText;
import com.loox.jloox.LxAbstractTextArea;
import com.loox.jloox.LxAbstractToggle;
import com.loox.jloox.LxArrowElement;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxCustomShape;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxHandle;
import com.loox.jloox.LxInteger;
import com.loox.jloox.LxPathElement;
import com.loox.jloox.LxSVGExtraData;
import com.loox.jloox.LxStyle;
import com.loox.jloox.LxText;
import com.loox.jloox.LxVectorial;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class LxSVGGenerator {
    private LxAbstractGraph _graph;
    private File _file;
    private PrintStream _printStream = null;
    private String _styleSection;
    private String _gradientSection;
    private Vector _animationVector = new Vector(100, 100);
    private boolean _trajectory = false;
    private int _precision = 3;
    private DecimalFormat _format = null;
    private int _gradientCount = 0;
    private Vector _styleTable = new Vector(10);
    private int _styleCount = 0;
    private String _idAttribute = "";
    private String _currentObjectName = "";
    private String _geomAttribute = "";
    private String _styleAttribute = "";
    private String _transformAttribute = "";
    private double _x;
    private double _y;
    private double _w;
    private double _h;
    private String _functionCalls = "";
    private Hashtable _nameIndex = new Hashtable();
    private double _Xg = 0.0;
    private double _Yg = 0.0;
    private boolean _xyAnim = false;
    private double _xoffset;
    private double _yoffset;
    private boolean _generateShareStyles = false;
    private boolean _generateScriptSection = false;
    private boolean _generateDynoBehaviourScript = false;
    private boolean _generateHiddenComponents = false;
    private boolean _generateExtraData = true;
    private boolean _generateObjectScript = false;
    private boolean _generateUniqueNames = true;
    private boolean _autoComputeBounds = true;
    private String _xmlVersion = "1.0";
    private String _standAlone = "no";
    private String _dtdPUBLIC = "-//W3C//DTD SVG 20000802//EN";
    private String _dtdURL = "http://www.w3.org/TR/2000/CR-SVG-20000802/DTD/svg-20000802.dtd";
    private double _svgWidth = -1.0;
    private double _svgHeight = -1.0;
    private boolean _existPushButton = false;
    private boolean _existSlider = false;
    private LxSVGExtraData _extraData = null;
    Hashtable _symbolTable = new Hashtable();
    int _nbTab = -1;
    String _tabulation = "";

    public LxSVGGenerator() {
        this._format = new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US));
        this._format.setMaximumFractionDigits(this._precision);
    }

    private String colorToRGBString(Color color) {
        if (color != null) {
            return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        }
        return "none";
    }

    private boolean gradientsEqual(GradientPaint gradientPaint, GradientPaint gradientPaint2) {
        boolean bl = false;
        if (gradientPaint == null && gradientPaint2 == null) {
            return true;
        }
        if (gradientPaint == null && gradientPaint2 != null || gradientPaint != null && gradientPaint2 == null) {
            return false;
        }
        if (gradientPaint.getColor1().getRed() == gradientPaint2.getColor1().getRed() && gradientPaint.getColor1().getGreen() == gradientPaint2.getColor1().getGreen() && gradientPaint.getColor1().getBlue() == gradientPaint2.getColor1().getBlue() && gradientPaint.getColor2().getRed() == gradientPaint2.getColor2().getRed() && gradientPaint.getColor2().getGreen() == gradientPaint2.getColor2().getGreen() && gradientPaint.getColor2().getBlue() == gradientPaint2.getColor2().getBlue() && gradientPaint.getPoint1().getX() == gradientPaint2.getPoint1().getX() && gradientPaint.getPoint1().getY() == gradientPaint2.getPoint1().getY() && gradientPaint.getPoint2().getX() == gradientPaint2.getPoint2().getX() && gradientPaint.getPoint2().getY() == gradientPaint2.getPoint2().getY() && gradientPaint.getTransparency() == gradientPaint2.getTransparency() && gradientPaint.isCyclic() == gradientPaint2.isCyclic()) {
            bl = true;
        }
        return bl;
    }

    private String makeTemplateGradient(LxComponent lxComponent, Object object) {
        String string = "";
        if (object != null) {
            Lx.GradientInfo gradientInfo = null;
            if (object instanceof Lx.JLooxGradientPaint) {
                gradientInfo = ((Lx.JLooxGradientPaint)object)._info;
            } else if (object instanceof Lx.JLooxRadialGradientPaint) {
                gradientInfo = ((Lx.JLooxRadialGradientPaint)object)._info;
            }
            if (gradientInfo == null) {
                return string;
            }
            string = "gradient" + this._gradientCount;
            ++this._gradientCount;
            String string2 = "";
            if (gradientInfo._cyclic) {
                string2 = " spreadMethod=\"reflect\"";
            }
            int n = (int)(lxComponent.getWidth() / 2.0);
            int n2 = (int)(lxComponent.getHeight() / 2.0);
            double d = (double)(gradientInfo._start_x + (float)n) + lxComponent.getX() + this._xoffset;
            double d2 = (double)(gradientInfo._start_y + (float)n2) + lxComponent.getY() + this._yoffset;
            if (gradientInfo._type == 0) {
                double d3 = (double)(gradientInfo._end_x + (float)n) + lxComponent.getX() + this._xoffset;
                double d4 = (double)(gradientInfo._end_y + (float)n2) + lxComponent.getY() + this._yoffset;
                this._gradientSection = this._gradientSection + this._tabulation + "<linearGradient gradientUnits=\"userSpaceOnUse\" id=\"" + string + "\" x1=\"" + this.Precision(d) + "\" y1=\"" + this.Precision(d2) + "\" x2=\"" + this.Precision(d3) + "\" y2=\"" + this.Precision(d4) + "\"" + string2 + ">\n";
                this._gradientSection = this._gradientSection + this._tabulation + "\t<stop offset=\"0%\" style=\"stop-color:" + this.colorToRGBString(gradientInfo._fill_color) + "\" />\n";
                this._gradientSection = this._gradientSection + this._tabulation + "\t<stop offset=\"100%\" style=\"stop-color:" + this.colorToRGBString(gradientInfo._line_color) + "\" />\n";
                this._gradientSection = this._gradientSection + this._tabulation + "</linearGradient>\n";
            } else if (gradientInfo._type == 1) {
                double d5 = gradientInfo._end_x;
                double d6 = gradientInfo._end_y;
                double d7 = Math.sqrt(d5 * d5 + d6 * d6);
                this._gradientSection = this._gradientSection + this._tabulation + "<radialGradient gradientUnits=\"userSpaceOnUse\" id=\"" + string + "\" cx=\"" + this.Precision(d) + "\" cy=\"" + this.Precision(d2) + "\" r=\"" + this.Precision(d7) + "\" " + string2 + ">\n";
                this._gradientSection = this._gradientSection + this._tabulation + "\t<stop offset=\"0%\" style=\"stop-color:" + this.colorToRGBString(gradientInfo._fill_color) + "\" />\n";
                this._gradientSection = this._gradientSection + this._tabulation + "\t<stop offset=\"100%\" style=\"stop-color:" + this.colorToRGBString(gradientInfo._line_color) + "\" />\n";
                this._gradientSection = this._gradientSection + this._tabulation + "</radialGradient>\n";
            }
        }
        return string;
    }

    private boolean dashesEqual(float[] fArray, float[] fArray2) {
        if (fArray == null && fArray2 == null) {
            return true;
        }
        if (fArray == null && fArray2 != null || fArray != null && fArray2 == null) {
            return false;
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        int n = 0;
        while (n < fArray.length) {
            if (fArray[n] != fArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean paintsEqual(Paint paint, Paint paint2) {
        boolean bl = false;
        if (paint == null && paint2 == null) {
            return true;
        }
        if (paint == null && paint2 != null || paint != null && paint2 == null) {
            return false;
        }
        if (paint != null && paint2 != null && paint instanceof Color && paint2 instanceof Color) {
            if (((Color)paint).getRed() == ((Color)paint2).getRed() && ((Color)paint).getGreen() == ((Color)paint2).getGreen() && ((Color)paint).getBlue() == ((Color)paint2).getBlue()) {
                bl = true;
            }
        } else if (paint != null && paint2 != null && paint instanceof GradientPaint && paint2 instanceof GradientPaint) {
            bl = this.gradientsEqual((GradientPaint)paint, (GradientPaint)paint2);
        }
        return bl;
    }

    private boolean stylesEqual(LxElement lxElement, LxElement lxElement2) {
        LxStyle lxStyle;
        boolean bl = false;
        LxStyle lxStyle2 = (LxStyle)lxElement.getStyle();
        if (lxStyle2 == (lxStyle = (LxStyle)lxElement2.getStyle())) {
            return true;
        }
        if (lxStyle2 == null && lxStyle != null || lxStyle2 != null && lxStyle == null) {
            return false;
        }
        boolean bl2 = true;
        if (lxElement instanceof LxAbstractText && lxElement2 instanceof LxAbstractText) {
            LxText lxText = (LxText)lxElement;
            LxText lxText2 = (LxText)lxElement2;
            bl2 = lxText.getFont().getFontName().equals(lxText2.getFont().getFontName()) && lxText.getFont().isItalic() == lxText2.getFont().isItalic() && lxText.getFont().isBold() == lxText2.getFont().isBold() && lxText.getFont().getSize() == lxText2.getFont().getSize();
        }
        if (lxStyle2.getLineColor().getRed() == lxStyle.getLineColor().getRed() && lxStyle2.getLineColor().getGreen() == lxStyle.getLineColor().getGreen() && lxStyle2.getLineColor().getBlue() == lxStyle.getLineColor().getBlue() && this.dashesEqual(lxStyle2.getLineDashes(), lxStyle.getLineDashes()) && lxStyle2.getLineThickness() == lxStyle.getLineThickness() && this.paintsEqual(lxStyle2.getPaint(), lxStyle.getPaint()) && lxStyle2.getTransparency() == lxStyle.getTransparency() && bl2) {
            bl = true;
        }
        return bl;
    }

    private String makeTemplateStyle(LxElement lxElement) {
        String string = "";
        LxStyle lxStyle = (LxStyle)lxElement.getStyle();
        if (lxStyle != null) {
            int n = -1;
            if (this.getShareStyles()) {
                int n2 = 0;
                while (n2 < this._styleTable.size()) {
                    if (this.stylesEqual((LxElement)this._styleTable.get(n2), lxElement)) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
            } else {
                this._styleSection = "";
            }
            if (n >= 0) {
                string = "style" + n;
            } else {
                Object object;
                this._styleTable.add(lxElement);
                string = "style" + this._styleCount;
                ++this._styleCount;
                this._styleSection = this.getShareStyles() ? this._styleSection + this._tabulation + "<style type=\"text/css\"><![CDATA[." + string + "{" : "style=\"";
                Paint paint = lxStyle.getPaint();
                if (paint != null && paint instanceof Color) {
                    this._styleSection = this._styleSection + "fill:" + this.colorToRGBString((Color)paint) + ";";
                } else if (paint != null && (paint instanceof Lx.JLooxGradientPaint || paint instanceof Lx.JLooxRadialGradientPaint)) {
                    object = this.makeTemplateGradient(lxElement, paint);
                    this._styleSection = this._styleSection + "fill:url(#" + (String)object + ");";
                } else {
                    this._styleSection = this._styleSection + "fill:none;";
                }
                if ((double)lxStyle.getTransparency() < 1.0) {
                    this._styleSection = this._styleSection + "opacity:" + lxStyle.getTransparency() + ";";
                }
                if (lxStyle.getLineThickness() > 0.0f) {
                    this._styleSection = this._styleSection + "stroke:" + this.colorToRGBString(lxStyle.getLineColor()) + "; stroke-width:" + lxStyle.getLineThickness() + ";";
                    object = lxStyle.getLineDashes();
                    if (object != null) {
                        int n3 = lxStyle.getLineDashes().length;
                        this._styleSection = this._styleSection + "stroke-dasharray:";
                        int n4 = 0;
                        while (n4 < n3) {
                            this._styleSection = this._styleSection + (float)object[n4] + " ";
                            ++n4;
                        }
                        this._styleSection = this._styleSection + ";";
                    }
                }
                if (lxElement instanceof LxAbstractText) {
                    object = (LxText)lxElement;
                    String string2 = ((LxAbstractText)object).getFont().getFamily();
                    this._styleSection = this._styleSection + "font-family:'" + string2 + "';";
                    String string3 = ((LxAbstractText)object).getFont().isItalic() ? "italic" : "normal";
                    this._styleSection = this._styleSection + "font-style:" + string3 + ";";
                    string3 = ((LxAbstractText)object).getFont().isBold() ? "bold" : "normal";
                    this._styleSection = this._styleSection + "font-weight:" + string3 + ";font-size:" + ((LxAbstractText)object).getFont().getSize() + ";";
                }
                if (this.getShareStyles()) {
                    this._styleSection = this._styleSection + "}]]></style>\n";
                } else {
                    if (!lxElement.isVisible()) {
                        this._styleSection = this._styleSection + "visibility:hidden;";
                    }
                    this._styleSection = this._styleSection + "\"";
                }
            }
        }
        return string;
    }

    private String Precision(double d) {
        String string = this._format.format(d);
        return string;
    }

    private Point2D getAbsoluteCoordinatesFromPoint(Point2D point2D, LxComponent lxComponent) {
        Point2D point2D2 = point2D;
        LxContainer lxContainer = lxComponent.getParent();
        while (lxContainer != null && lxContainer instanceof LxComponent) {
            LxComponent lxComponent2 = (LxComponent)((Object)lxContainer);
            lxContainer = lxComponent2.getParent();
            point2D2.setLocation(point2D2.getX() + lxComponent2.getX(), point2D2.getY() + lxComponent2.getY());
        }
        return point2D2;
    }

    private Point2D getAbsoluteCoordinates(LxComponent lxComponent) {
        Point2D.Double double_ = new Point2D.Double(lxComponent.getX(), lxComponent.getY());
        LxContainer lxContainer = lxComponent.getParent();
        while (lxContainer != null && lxContainer instanceof LxComponent) {
            LxComponent lxComponent2 = (LxComponent)((Object)lxContainer);
            lxContainer = lxComponent2.getParent();
            ((Point2D)double_).setLocation(((Point2D)double_).getX() + lxComponent2.getX(), ((Point2D)double_).getY() + lxComponent2.getY());
        }
        return double_;
    }

    private void getComponentProp(LxComponent lxComponent) {
        Object object;
        Object object2;
        this._idAttribute = "";
        this._geomAttribute = "";
        this._styleAttribute = "";
        this._transformAttribute = "transform=\"";
        this._currentObjectName = lxComponent.getName();
        if (this._currentObjectName != null && this._currentObjectName.length() > 0) {
            if (this.getGenerateUniqueNames()) {
                int n = 0;
                object2 = (LxInteger)this._nameIndex.get(this._currentObjectName);
                if (object2 == null) {
                    this._nameIndex.put(this._currentObjectName, new LxInteger(0, 10000000, 1));
                } else {
                    n = ((LxInteger)object2).get();
                    ((LxInteger)object2).set(n + 1);
                    this._nameIndex.put(this._currentObjectName, object2);
                }
                if (Character.isDigit(this._currentObjectName.charAt(0))) {
                    this._currentObjectName = "_" + this._currentObjectName;
                }
                this._idAttribute = n > 0 ? "id=\"" + this._currentObjectName + n + "\"" : "id=\"" + this._currentObjectName + "\"";
            } else {
                this._idAttribute = "id=\"" + this._currentObjectName + "\"";
            }
        }
        Point2D point2D = this.getAbsoluteCoordinates(lxComponent);
        this._x = point2D.getX();
        this._y = point2D.getY();
        this._w = lxComponent.getWidth();
        this._h = lxComponent.getHeight();
        if (lxComponent instanceof LxAbstractText) {
            object2 = (LxAbstractText)lxComponent;
            object = this.getAbsoluteCoordinatesFromPoint(((LxAbstractText)object2).getBaseLinePoint1(), lxComponent);
            this._x = ((Point2D)object).getX();
            this._y = ((Point2D)object).getY();
            this._transformAttribute = this._transformAttribute + "translate(" + this.Precision(((Point2D)object).getX()) + "," + this.Precision(((Point2D)object).getY()) + ")";
            if (Math.toDegrees(((LxAbstractText)object2).getRotation()) != 0.0) {
                this._transformAttribute = this._transformAttribute + "rotate(" + this.Precision(Math.toDegrees(((LxAbstractText)object2).getRotation())) + ")";
            }
            if (((LxAbstractText)object2).getScaleX() != 1.0 || ((LxAbstractText)object2).getScaleY() != 1.0) {
                double d = ((LxAbstractText)object2).getScaleX();
                double d2 = ((LxAbstractText)object2).getScaleY();
                this._transformAttribute = this._transformAttribute + " scale(" + this.Precision(d) + " " + this.Precision(d2) + ")";
            }
        } else if (lxComponent instanceof LxAbstractImage && (Math.toDegrees(((LxAbstractImage)lxComponent).getRotation()) != 0.0 || ((LxAbstractImage)lxComponent).getScaleX() != 1.0 || ((LxAbstractImage)lxComponent).getScaleY() != 1.0)) {
            object2 = ((LxAbstractImage)lxComponent).getImage();
            int n = ((Image)object2).getWidth(null);
            int n2 = ((Image)object2).getHeight(null);
            this._w = n;
            this._h = n2;
            double d = ((LxAbstractImage)lxComponent).getCenterX() + this._xoffset;
            double d3 = ((LxAbstractImage)lxComponent).getCenterY() + this._yoffset;
            double d4 = ((LxAbstractImage)lxComponent).getScaleX();
            double d5 = ((LxAbstractImage)lxComponent).getScaleY();
            this._x = -n / 2;
            this._y = -n2 / 2;
            this._transformAttribute = this._transformAttribute + "translate(" + this.Precision(d) + "," + this.Precision(d3) + ")";
            this._transformAttribute = this._transformAttribute + "rotate(" + this.Precision(Math.toDegrees(((LxAbstractImage)lxComponent).getRotation())) + ")";
            this._transformAttribute = this._transformAttribute + "scale(" + this.Precision(d4) + " " + this.Precision(d5) + ")";
        }
        this._transformAttribute = this._transformAttribute + "\"";
        if (this._transformAttribute.equals("transform=\"\"")) {
            this._transformAttribute = "";
        }
        object2 = "";
        if (lxComponent instanceof LxAbstractGroup) {
            this._styleAttribute = "style=\"";
            if (!lxComponent.isVisible()) {
                this._styleAttribute = this._styleAttribute + "visibility:hidden;";
            }
            this._styleAttribute = this._styleAttribute + "\"";
            return;
        }
        object = this.makeTemplateStyle((LxElement)lxComponent);
        if (this.getShareStyles()) {
            if (!((String)object).equals("")) {
                object2 = "class=\"" + (String)object + "\"";
            }
            this._styleAttribute = "style=\"";
            if (!lxComponent.isVisible()) {
                this._styleAttribute = this._styleAttribute + "visibility:hidden;";
            }
            this._styleAttribute = this._styleAttribute + "\"";
        } else {
            object2 = "";
            this._styleAttribute = this._styleSection;
        }
        if (this._styleAttribute.equals("style=\"\"")) {
            this._styleAttribute = "";
        }
        this._geomAttribute = this._geomAttribute + "x=\"" + this.Precision(this._x) + "\" y=\"" + this.Precision(this._y) + "\" width=\"" + this.Precision(this._w) + "\" height=\"" + this.Precision(this._h) + "\"";
        this._styleAttribute = (String)object2 + " " + this._styleAttribute;
    }

    private void writeComponent(PrintStream printStream, double d, double d2, LxComponent lxComponent, boolean bl) {
        this._xoffset = d;
        this._yoffset = d2;
        this._x = this._xoffset;
        this._y = this._yoffset;
        this._xyAnim = bl;
        this._functionCalls = " ";
        this.writeComponent(printStream, lxComponent);
    }

    public void writeComponent(PrintStream printStream, LxComponent lxComponent) {
        boolean bl = false;
        if (this.getGenerateExtraData() && this.getExtraData() != null) {
            String string = this._extraData.getObjectLinkUrl(lxComponent);
            String string2 = this._extraData.getObjectLinkTarget(lxComponent);
            if (string != null && !string.equals("")) {
                this.out(printStream, "<a xlink:href=\"" + string + "\" target=\"" + string2 + "\">\n");
                bl = true;
                this.indent();
            }
        }
        if (lxComponent instanceof LxAbstractGroup) {
            this.writeGroup(printStream, lxComponent);
        } else if (lxComponent instanceof LxAbstractRectangle) {
            this.writeRectangle(printStream, lxComponent);
        } else if (lxComponent instanceof LxAbstractArray) {
            this.writeArray(printStream, lxComponent);
        } else if (lxComponent instanceof LxAbstractCircle) {
            if (((LxAbstractCircle)lxComponent).getAngleExtent() != 360.0) {
                this.writePath(printStream, lxComponent);
            } else {
                this.writeEllipse(printStream, lxComponent);
            }
        } else if (lxComponent instanceof LxAbstractText) {
            this.writeText(printStream, lxComponent);
        } else if (lxComponent instanceof LxAbstractTextArea) {
            this.writeTextArea(printStream, lxComponent);
        } else if (lxComponent instanceof LxAbstractImage) {
            this.writeImage(printStream, lxComponent);
        } else if (lxComponent instanceof LxAbstractLink) {
            this.writeLink(printStream, lxComponent);
        } else if (lxComponent instanceof LxCustomShape || lxComponent instanceof LxPathElement) {
            this.writePath(printStream, lxComponent);
        } else if (lxComponent instanceof LxAbstractReference) {
            // empty if block
        }
        if (bl) {
            this.deindent();
            this.out(printStream, "</a>\n");
        }
    }

    public void writeObjectAttributes(PrintStream printStream, LxComponent lxComponent) {
        LxSVGExtraData lxSVGExtraData = this.getExtraData();
        if (lxSVGExtraData != null) {
            lxSVGExtraData.writeObjectAttributes(printStream, lxComponent);
        }
    }

    public void writeObjectChildElements(PrintStream printStream, LxComponent lxComponent) {
        LxSVGExtraData lxSVGExtraData = this.getExtraData();
        if (lxSVGExtraData != null) {
            this.indent();
            lxSVGExtraData.setIndentation(this._tabulation);
            lxSVGExtraData.writeObjectChildElements(printStream, lxComponent);
            lxSVGExtraData.setIndentation("");
            this.deindent();
        }
    }

    public void writeGroup(PrintStream printStream, LxComponent lxComponent) {
        LxAbstractToggle lxAbstractToggle;
        this.getComponentProp(lxComponent);
        LxAbstractGroup lxAbstractGroup = (LxAbstractGroup)lxComponent;
        int n = lxAbstractGroup.getComponentCount();
        double d = lxAbstractGroup.getX() + this._xoffset;
        double d2 = lxAbstractGroup.getY() + this._yoffset;
        this._Xg = lxAbstractGroup.getWidth() / 2.0;
        this._Yg = lxAbstractGroup.getHeight() / 2.0;
        LxComponent[] lxComponentArray = lxAbstractGroup.getComponents();
        boolean bl = false;
        LxComponent lxComponent2 = null;
        LxComponent lxComponent3 = null;
        if (lxComponent instanceof LxAbstractPushButton && ((LxAbstractPushButton)lxComponent).getComponent("ON") != null && ((LxAbstractPushButton)lxComponent).getComponent("OFF") != null) {
            bl = true;
            lxComponent2 = lxAbstractGroup.getComponent("ON");
            lxComponent3 = lxAbstractGroup.getComponent("OFF");
            lxComponent2.setName(this._currentObjectName + "ON");
            lxComponent3.setName(this._currentObjectName + "OFF");
            lxComponent2.setVisible(false);
            lxComponent3.setVisible(true);
        }
        bl = false;
        lxComponent2 = null;
        lxComponent3 = null;
        if (lxComponent instanceof LxAbstractToggle && (lxAbstractToggle = (LxAbstractToggle)lxComponent).getComponent("ON") != null && lxAbstractToggle.getComponent("OFF") != null) {
            bl = true;
            lxComponent2 = lxAbstractGroup.getComponent("ON");
            lxComponent3 = lxAbstractGroup.getComponent("OFF");
            lxComponent2.setName(this._currentObjectName + "ON");
            lxComponent3.setName(this._currentObjectName + "OFF");
            boolean bl2 = lxAbstractToggle.getValue();
            lxComponent2.setVisible(bl2);
            lxComponent3.setVisible(!bl2);
        }
        boolean bl3 = false;
        Object var15_14 = null;
        LxComponent lxComponent4 = null;
        LxComponent lxComponent5 = null;
        LxComponent lxComponent6 = null;
        if (lxComponent instanceof LxAbstractSlider) {
            bl3 = true;
            if (((LxAbstractSlider)lxComponent).getComponent("BOX") != null && ((LxAbstractSlider)lxComponent).getComponent("INDICATOR") != null) {
                lxComponent6 = lxAbstractGroup.getComponent("BOX");
                lxComponent6.setName(lxAbstractGroup.getName() + "BOX");
                lxComponent4 = lxAbstractGroup.getComponent("INDICATOR");
                lxComponent4.setName(lxAbstractGroup.getName() + "INDICATOR");
            }
            if (((LxAbstractSlider)lxComponent).getComponent("VALUE") != null) {
                lxComponent5 = lxAbstractGroup.getComponent("VALUE");
                lxComponent5.setName(lxAbstractGroup.getName() + "VALUE");
            }
            this._functionCalls = this._functionCalls + "";
        }
        this.out(printStream, "<g " + this._idAttribute + " " + this._styleAttribute + " " + this._functionCalls);
        if (this.getGenerateExtraData()) {
            this.writeObjectAttributes(printStream, lxComponent);
        }
        printStream.print(">\n");
        boolean bl4 = false;
        int n2 = 0;
        while (n2 < n) {
            this.indent();
            this.writeComponent(printStream, d, d2, lxComponentArray[n2], bl4);
            this.deindent();
            ++n2;
        }
        if (this.getGenerateExtraData()) {
            this.writeObjectChildElements(printStream, lxComponent);
        }
        this.out(printStream, "</g>\n");
        if (bl && lxComponent2 != null && lxComponent3 != null) {
            lxComponent2.setName("ON");
            lxComponent3.setName("OFF");
        }
        if (bl3 && lxComponent6 != null && lxComponent4 != null && lxComponent5 != null) {
            lxComponent6.setName("BOX");
            lxComponent4.setName("INDICATOR");
            lxComponent5.setName("VALUE");
        }
    }

    public void writeRectangle(PrintStream printStream, LxComponent lxComponent) {
        LxAbstractRectangle lxAbstractRectangle = (LxAbstractRectangle)lxComponent;
        this.getComponentProp(lxAbstractRectangle);
        String string = "";
        if (lxAbstractRectangle.isRounded()) {
            string = " rx=\"" + this.Precision(lxAbstractRectangle.getArcWidth() / 2.0) + "\" ry=\"" + this.Precision(lxAbstractRectangle.getArcHeight() / 2.0) + "\"";
        }
        if (!this._xyAnim) {
            this.out(printStream, "<rect " + this._idAttribute + " " + this._geomAttribute + " " + string + " " + this._styleAttribute + " " + this._transformAttribute + " " + this._functionCalls);
        } else {
            this.out(printStream, "<rect " + this._idAttribute + " x=\"" + this.Precision(lxAbstractRectangle.getX() - this._Xg) + "\" y=\"" + this.Precision(lxAbstractRectangle.getY() - this._Yg) + "\" width=\"" + this.Precision(lxAbstractRectangle.getWidth()) + "\" height=\"" + this.Precision(lxAbstractRectangle.getHeight()) + "\" " + string + " " + this._styleAttribute + " " + this._transformAttribute);
        }
        if (this.getGenerateExtraData()) {
            this.writeObjectAttributes(printStream, lxComponent);
        }
        printStream.print(">\n");
        if (this.getGenerateExtraData()) {
            this.writeObjectChildElements(printStream, lxComponent);
        }
        this.out(printStream, "</rect>\n");
    }

    public void writeArray(PrintStream printStream, LxComponent lxComponent) {
        LxAbstractArray lxAbstractArray = (LxAbstractArray)lxComponent;
        this.getComponentProp(lxAbstractArray);
        this.out(printStream, "<g " + this._idAttribute + " " + this._styleAttribute + " " + this._transformAttribute);
        if (this.getGenerateExtraData()) {
            this.writeObjectAttributes(printStream, lxComponent);
        }
        printStream.print(">\n");
        this.out(printStream, "<rect " + this._geomAttribute + " />\n");
        int n = 1;
        while (n < lxAbstractArray.getColumnCount()) {
            this._geomAttribute = "";
            this._w = lxAbstractArray.getWidth() / (double)lxAbstractArray.getColumnCount();
            this._h = lxAbstractArray.getHeight();
            this._x = lxAbstractArray.getX() + (double)n * this._w + this._xoffset;
            this._y = lxAbstractArray.getY() + this._yoffset;
            double d = this._x;
            double d2 = this._y + this._h;
            this._geomAttribute = this._geomAttribute + "x1=\"" + this.Precision(this._x) + "\" y1=\"" + this.Precision(this._y) + "\" x2=\"" + this.Precision(d) + " \" y2=\"" + this.Precision(d2) + "\" ";
            this.out(printStream, "<line " + this._geomAttribute + " />\n");
            ++n;
        }
        int n2 = 1;
        while (n2 < lxAbstractArray.getRowCount()) {
            this._geomAttribute = "";
            this._w = lxAbstractArray.getWidth();
            this._h = lxAbstractArray.getHeight() / (double)lxAbstractArray.getRowCount();
            this._x = lxAbstractArray.getX() + this._xoffset;
            this._y = lxAbstractArray.getY() + (double)n2 * this._h + this._yoffset;
            double d = this._x + this._w;
            double d3 = this._y;
            this._geomAttribute = this._geomAttribute + "x1=\"" + this.Precision(this._x) + "\" y1=\"" + this.Precision(this._y) + "\" x2=\"" + this.Precision(d) + " \" y2=\"" + this.Precision(d3) + "\" ";
            this.out(printStream, "<line " + this._geomAttribute + " />\n");
            ++n2;
        }
        if (this.getGenerateExtraData()) {
            this.writeObjectChildElements(printStream, lxComponent);
        }
        this.out(printStream, "</g>");
    }

    public void writeEllipse(PrintStream printStream, LxComponent lxComponent) {
        LxAbstractCircle lxAbstractCircle = (LxAbstractCircle)lxComponent;
        this.getComponentProp(lxAbstractCircle);
        this._x += this._w / 2.0;
        this._y += this._h / 2.0;
        if (!this._xyAnim) {
            this.out(printStream, "<ellipse " + this._idAttribute + " cx=\"" + this.Precision(this._x) + "\" cy=\"" + this.Precision(this._y) + "\" rx=\"" + this.Precision(this._w / 2.0) + "\" ry=\"" + this.Precision(this._h / 2.0) + "\" " + this._styleAttribute + " " + this._transformAttribute + " " + this._functionCalls);
        } else {
            this.out(printStream, "<ellipse " + this._idAttribute + " cx=\"" + this.Precision(lxAbstractCircle.getCenterX() - this._Xg) + "\" cy=\"" + this.Precision(lxAbstractCircle.getCenterY() - this._Yg) + "\" rx=\"" + this.Precision(this._w / 2.0) + "\" ry=\"" + this.Precision(this._h / 2.0) + "\"" + this._styleAttribute + this._transformAttribute + " " + this._functionCalls);
        }
        if (this.getGenerateExtraData()) {
            this.writeObjectAttributes(printStream, lxComponent);
        }
        printStream.print(">\n");
        if (this.getGenerateExtraData()) {
            this.writeObjectChildElements(printStream, lxComponent);
        }
        this.out(printStream, "</ellipse>\n");
    }

    public void writeText(PrintStream printStream, LxComponent lxComponent) {
        LxAbstractText lxAbstractText = (LxAbstractText)lxComponent;
        this.getComponentProp(lxAbstractText);
        this.out(printStream, "<text " + this._idAttribute + " " + this._styleAttribute + " " + this._transformAttribute + " " + this._functionCalls);
        if (this.getGenerateExtraData()) {
            this.writeObjectAttributes(printStream, lxComponent);
        }
        printStream.print(">" + this.convertToXMLCharacterData(lxAbstractText.getText()));
        if (this.getGenerateExtraData()) {
            this.writeObjectChildElements(printStream, lxComponent);
        }
        this.out(printStream, "</text>\n");
    }

    private String convertToXMLCharacterData(String string) {
        char[] cArray = string.toCharArray();
        String string2 = "";
        int n = 0;
        while (n < cArray.length) {
            String string3 = cArray[n] == '\"' || cArray[n] == '&' || cArray[n] == '<' || cArray[n] == '>' || cArray[n] >= '\u00a0' && cArray[n] <= '\u00ff' ? "&#" + cArray[n] + ";" : "" + cArray[n];
            string2 = string2 + string3;
            ++n;
        }
        return string2;
    }

    public void writeTextArea(PrintStream printStream, LxComponent lxComponent) {
        Cloneable cloneable;
        Object object;
        LxAbstractTextArea lxAbstractTextArea = (LxAbstractTextArea)lxComponent;
        this.getComponentProp(lxAbstractTextArea);
        this.writePath(printStream, lxComponent);
        this._styleAttribute = "style=\"fill:" + lxAbstractTextArea.getTextColor() + "\"";
        Font font = lxAbstractTextArea.getFont();
        String string = "font-family=\"" + font.getFamily() + "\" font-size=\"" + font.getSize() + "\"";
        string = font.isBold() ? string + " font-weight=\"bold\"" : string + " font-weight=\"normal\"";
        string = font.isItalic() ? string + " font-style=\"italic\"" : string + " font-style=\"normal\"";
        this._idAttribute = this._idAttribute.substring(0, this._idAttribute.length() - 1) + "_TA\"";
        this._styleAttribute = "style=\"fill:" + this.colorToRGBString(lxAbstractTextArea.getTextColor()) + ";stroke:none\" ";
        this.out(printStream, "<g " + this._idAttribute + " " + this._styleAttribute + "  " + string + " " + this._functionCalls);
        if (this.getGenerateExtraData()) {
            this.writeObjectAttributes(printStream, lxComponent);
        }
        printStream.print(">\n");
        String string2 = lxAbstractTextArea.getText();
        BufferedImage bufferedImage = new BufferedImage(2, 2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        double d = lxAbstractTextArea.getFont().getSize();
        boolean bl = true;
        double d2 = Math.toDegrees(lxAbstractTextArea.getAngle());
        double d3 = lxAbstractTextArea.getWidth();
        if (d2 != 0.0) {
            object = lxAbstractTextArea.getPathPoint(0);
            cloneable = new Point2D.Double(0.0, 0.0);
            AffineTransform.getRotateInstance(Math.toRadians(-d2)).transform((Point2D)object, (Point2D)cloneable);
            this._x = ((Point2D)cloneable).getX();
            this._y = ((Point2D)cloneable).getY() + (double)lxAbstractTextArea.getOffsetY() + (double)lxAbstractTextArea.getBorderHeight();
            Point2D point2D = lxAbstractTextArea.getPathPoint(0);
            Point2D point2D2 = lxAbstractTextArea.getPathPoint(1);
            Point2D point2D3 = lxAbstractTextArea.getPathPoint(3);
            d3 = Math.sqrt(Math.pow(point2D2.getY() - point2D.getY(), 2.0) + Math.pow(point2D2.getX() - point2D.getX(), 2.0));
        } else {
            this._x = this._x;
            this._y = this._y + (double)lxAbstractTextArea.getOffsetY() + (double)lxAbstractTextArea.getBorderHeight();
        }
        this._transformAttribute = "transform=\"rotate(" + d2 + ")\"";
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            cloneable = new TextLayout((String)object, font, fontRenderContext);
            double d4 = lxAbstractTextArea.getAlignment() == LxAbstractTextArea.ALIGN_RIGHT ? this._x + d3 - (double)(((TextLayout)cloneable).getVisibleAdvance() + (float)lxAbstractTextArea.getOffsetX() + (float)lxAbstractTextArea.getBorderWidth()) : (lxAbstractTextArea.getAlignment() == LxAbstractTextArea.ALIGN_CENTER ? this._x + d3 / 2.0 - (double)(((TextLayout)cloneable).getAdvance() / 2.0f) : this._x + (double)lxAbstractTextArea.getOffsetX() + (double)lxAbstractTextArea.getBorderWidth());
            if (bl) {
                this._y += (double)((TextLayout)cloneable).getAscent();
                bl = false;
            }
            this.indent();
            this.out(printStream, "<text  x=\"" + this.Precision(d4) + "\" y=\"" + this.Precision(this._y) + "\" " + this._transformAttribute + " >\n");
            this.out(printStream, (String)object + "\n");
            this.out(printStream, "</text>\n");
            this.deindent();
            this._y += (double)(((TextLayout)cloneable).getAscent() + ((TextLayout)cloneable).getDescent() + ((TextLayout)cloneable).getLeading());
        }
        if (this.getGenerateExtraData()) {
            this.writeObjectChildElements(printStream, lxComponent);
        }
        this.out(printStream, "</g>\n");
    }

    public void writeImage(PrintStream printStream, LxComponent lxComponent) {
        LxAbstractImage lxAbstractImage = (LxAbstractImage)lxComponent;
        this.getComponentProp(lxAbstractImage);
        this.out(printStream, "<image " + this._idAttribute + " " + this._geomAttribute + " " + this._styleAttribute + " " + this._transformAttribute + " " + this._functionCalls + " " + " xlink:href=\"" + lxAbstractImage.getImageURL() + "\" ");
        if (this.getGenerateExtraData()) {
            this.writeObjectAttributes(printStream, lxComponent);
        }
        printStream.print(">\n");
        if (this.getGenerateExtraData()) {
            this.writeObjectChildElements(printStream, lxComponent);
        }
        this.out(printStream, "</image>\n");
    }

    public void writeLink(PrintStream printStream, LxComponent lxComponent) {
        int n;
        LxVectorial lxVectorial = (LxVectorial)lxComponent;
        this.getComponentProp(lxVectorial);
        LxAbstractLink lxAbstractLink = (LxAbstractLink)lxComponent;
        String string = lxAbstractLink.getLabel();
        Shape[] shapeArray = lxVectorial.getShape();
        String string2 = this.decodeShape(shapeArray, lxComponent);
        LxHandle lxHandle = lxAbstractLink.getHandle1();
        int n2 = lxAbstractLink.getGraph().getComponentIndex(lxHandle.getComponent());
        int n3 = lxHandle.getComponent().getHandleIndex(lxHandle);
        LxHandle lxHandle2 = lxAbstractLink.getHandle2();
        int n4 = lxAbstractLink.getGraph().getComponentIndex(lxHandle2.getComponent());
        int n5 = lxHandle2.getComponent().getHandleIndex(lxHandle2);
        String string3 = "lxLink=\"" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + lxAbstractLink.getStartOnBorder() + "," + lxAbstractLink.getLinkType() + "\"";
        this.out(printStream, "<path " + this._idAttribute + " " + string3 + " " + this._styleAttribute + " " + this._transformAttribute + "d=\"" + string2 + "\"" + this._functionCalls);
        if (string != null) {
            String string4 = " lxLinklabel=\"";
            string4 = string4 + string + ";";
            string4 = string4 + this.colorToRGBString(lxAbstractLink.getLabelColor()) + ";";
            string4 = string4 + lxAbstractLink.getLabelFont().getFamily() + ";";
            string4 = string4 + lxAbstractLink.getLabelFont().getStyle() + ";";
            string4 = string4 + lxAbstractLink.getLabelFont().getSize() + ";";
            string4 = string4 + lxAbstractLink.getLabelPosition() + ";";
            string4 = string4 + lxAbstractLink.getLabelSegment() + ";";
            string4 = string4 + lxAbstractLink.isLabelVisible() + ";";
            string4 = string4 + lxAbstractLink.getLabelVAlign() + ";";
            string4 = string4 + lxAbstractLink.getLabelHAlign() + ";";
            string4 = string4 + lxAbstractLink.getLabelOffsetY() + ";";
            string4 = string4 + lxAbstractLink.getLabelOffsetX() + ";";
            string4 = string4 + lxAbstractLink.getLabelOrientation() + ";";
            string4 = string4 + lxAbstractLink.isLabelFitToLink() + ";";
            string4 = string4 + "\" ";
            this.out(printStream, string4);
        }
        if ((n = lxAbstractLink.getLineArrow()) != 0) {
            int n6 = lxAbstractLink.getPathSegmentCount();
            int n7 = 1;
            if ((n & 3) >= 3) {
                n7 = 2;
            }
            int n8 = 7;
            if ((n & 4) > 0) {
                n8 = 4;
            }
            int n9 = n7 * n8;
            if ((n & 8) >= 8) {
                n9 *= lxAbstractLink.getPathSegmentCount() - 1;
            }
            this.out(printStream, " lxArrow=\"" + n + "," + n6 + "," + n9 + "\"");
        }
        if (this.getGenerateExtraData()) {
            this.writeObjectAttributes(printStream, lxComponent);
        }
        printStream.print(">\n");
        if (this.getGenerateExtraData()) {
            this.writeObjectChildElements(printStream, lxComponent);
        }
        this.out(printStream, "</path>\n");
        if (string != null) {
            this._idAttribute = "id=\"_lxLinkLabel_" + this._idAttribute.substring(4, this._idAttribute.length() - 1) + "\"";
            this._styleAttribute = "";
            this._transformAttribute = "";
            this._functionCalls = "";
            this._transformAttribute = "transform=\"";
            Point2D point2D = lxAbstractLink._getLabelCoordinates();
            this._x = point2D.getX() + lxAbstractLink.getCenterX();
            this._y = point2D.getY() + lxAbstractLink.getCenterY();
            this._transformAttribute = this._transformAttribute + "translate(" + this.Precision(this._x) + "," + this.Precision(this._y) + ")";
            double d = lxAbstractLink._getLabelAngle();
            if (Math.toDegrees(d) != 0.0) {
                this._transformAttribute = this._transformAttribute + "rotate(" + this.Precision(Math.toDegrees(d)) + ")";
            }
            point2D = lxAbstractLink._getLabelOffsets();
            this._x = point2D.getX();
            this._y = point2D.getY();
            this._transformAttribute = this._transformAttribute + "translate(" + this.Precision(this._x) + "," + this.Precision(this._y) + ")";
            this._transformAttribute = this._transformAttribute + "\"";
            Font font = lxAbstractLink._getLabelCurrentFont();
            this._styleSection = "style=\"";
            this._styleSection = this._styleSection + "stroke:none;fill:" + this.colorToRGBString(lxAbstractLink.getLabelColor()) + ";";
            String string5 = font.getFamily();
            this._styleSection = this._styleSection + "font-family:'" + string5 + "';";
            String string6 = font.isItalic() ? "italic" : "normal";
            this._styleSection = this._styleSection + "font-style:" + string6 + ";";
            string6 = font.isBold() ? "bold" : "normal";
            this._styleSection = this._styleSection + "font-weight:" + string6 + ";font-size:" + font.getSize() + ";";
            this._styleAttribute = this._styleSection = this._styleSection + "\"";
            this.out(printStream, "<text " + this._idAttribute + " " + this._styleAttribute + " " + this._transformAttribute + " " + this._functionCalls);
            printStream.print(">" + this.convertToXMLCharacterData(string));
            this.out(printStream, "</text>\n");
        }
    }

    public void writePath(PrintStream printStream, LxComponent lxComponent) {
        int n;
        LxVectorial lxVectorial = (LxVectorial)lxComponent;
        this.getComponentProp(lxVectorial);
        Shape[] shapeArray = lxVectorial.getShape();
        String string = this.decodeShape(shapeArray, lxComponent);
        this.out(printStream, "<path " + this._idAttribute + " " + this._styleAttribute + " " + this._transformAttribute + "d=\"" + string + "\"" + this._functionCalls);
        if (lxComponent instanceof LxArrowElement && (n = ((LxArrowElement)((Object)lxComponent)).getLineArrow()) != 0) {
            this.out(printStream, " lxArrow=\"" + n + "\" ");
        }
        if (this.getGenerateExtraData()) {
            this.writeObjectAttributes(printStream, lxComponent);
        }
        printStream.print(">\n");
        if (this.getGenerateExtraData()) {
            this.writeObjectChildElements(printStream, lxComponent);
        }
        this.out(printStream, "</path>\n");
    }

    private String decodeShape(Shape[] shapeArray, LxComponent lxComponent) {
        return this.decodeShape(shapeArray, lxComponent, false);
    }

    private String decodeShape(Shape[] shapeArray, LxComponent lxComponent, boolean bl) {
        String string = "";
        int n = 32;
        int n2 = 0;
        while (n2 < shapeArray.length) {
            Shape shape = shapeArray[n2];
            PathIterator pathIterator = shape.getPathIterator(null);
            int n3 = 0;
            double[] dArray = new double[6];
            double d = lxComponent.getCenterX();
            double d2 = lxComponent.getCenterY();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int n4 = 0;
            double d7 = 0.0;
            double d8 = 0.0;
            while (!pathIterator.isDone()) {
                n3 = pathIterator.currentSegment(dArray);
                switch (n3) {
                    case 0: {
                        n4 = 1;
                        n = 77;
                        d3 = 0.0;
                        d4 = 0.0;
                        d7 = dArray[0];
                        d8 = dArray[1];
                        break;
                    }
                    case 1: {
                        n4 = 1;
                        n = 108;
                        break;
                    }
                    case 2: {
                        n4 = 2;
                        n = 113;
                        break;
                    }
                    case 3: {
                        n4 = 3;
                        n = 99;
                        break;
                    }
                    case 4: {
                        if (bl) {
                            n4 = 1;
                            dArray[0] = d7;
                            dArray[1] = d8;
                            n = 108;
                            break;
                        }
                        n4 = 0;
                        n = 122;
                    }
                }
                string = string + (char)n;
                int n5 = 0;
                while (n5 < n4) {
                    if (!this._xyAnim) {
                        d5 = dArray[n5 * 2] + d + this._xoffset - d3;
                        d6 = dArray[n5 * 2 + 1] + d2 + this._yoffset - d4;
                    } else {
                        d5 = dArray[n5 * 2] + d - d3 - this._Xg;
                        d6 = dArray[n5 * 2 + 1] + d2 - d4 - this._Yg;
                    }
                    string = string + this.Precision(d5) + "," + this.Precision(d6) + ",";
                    ++n5;
                }
                d3 = d5 + d3;
                d4 = d6 + d4;
                pathIterator.next();
            }
            ++n2;
        }
        return string;
    }

    public void setShareStyles(boolean bl) {
        this._generateShareStyles = bl;
    }

    public boolean getShareStyles() {
        return this._generateShareStyles;
    }

    public void setGenerateScriptSection(boolean bl) {
        this._generateScriptSection = bl;
    }

    public boolean getGenerateScriptSection() {
        return this._generateScriptSection;
    }

    private void setGenerateDynoScript(boolean bl) {
        this._generateDynoBehaviourScript = bl;
    }

    private boolean getGenerateDynoScript() {
        return this._generateDynoBehaviourScript;
    }

    public void setGenerateHiddenComponents(boolean bl) {
        this._generateHiddenComponents = bl;
    }

    public boolean getGenerateHiddenComponents() {
        return this._generateHiddenComponents;
    }

    public void setGenerateExtraData(boolean bl) {
        this._generateExtraData = bl;
    }

    public boolean getGenerateExtraData() {
        return this._generateExtraData;
    }

    public void setGenerateObjectScript(boolean bl) {
        this._generateObjectScript = bl;
    }

    public boolean getGenerateObjectScript() {
        return this._generateObjectScript;
    }

    public void setGenerateUniqueNames(boolean bl) {
        this._generateUniqueNames = bl;
    }

    public boolean getGenerateUniqueNames() {
        return this._generateUniqueNames;
    }

    public void setAutoComputeBounds(boolean bl) {
        this._autoComputeBounds = bl;
    }

    public boolean getAutoComputeBounds() {
        return this._autoComputeBounds;
    }

    public void setGraph(LxAbstractGraph lxAbstractGraph) {
        this._graph = lxAbstractGraph;
    }

    public LxAbstractGraph getGraph() {
        return this._graph;
    }

    public void setXMLversion(String string) {
        this._xmlVersion = string;
    }

    public String getXMLversion() {
        return this._xmlVersion;
    }

    public void setStandAlone(String string) {
        this._standAlone = string;
    }

    public String getStandAlone() {
        return this._standAlone;
    }

    public void setDTDPublic(String string) {
        this._dtdPUBLIC = string;
    }

    public String getDTDPublic() {
        return this._dtdPUBLIC;
    }

    public void setDTDUrl(String string) {
        this._dtdURL = string;
    }

    public String getDTDUrl() {
        return this._dtdURL;
    }

    public void setSVGBounds(double d, double d2) {
        this._svgWidth = d;
        this._svgHeight = d2;
    }

    public double getSVGWidth() {
        return this._svgWidth;
    }

    public double getSVGHeight() {
        return this._svgHeight;
    }

    public void writeXmlVersion(PrintStream printStream) {
        this.out(printStream, "<?xml version = \"" + this.getXMLversion() + "\" standalone = \"" + this.getStandAlone() + "\"?>\n");
    }

    public void writeDTDDeclaration(PrintStream printStream) {
        this.out(printStream, "<!DOCTYPE svg PUBLIC \"" + this.getDTDPublic() + "\" \"" + this.getDTDUrl() + "\" >\n");
    }

    public void writeSVGStart(PrintStream printStream) {
        if (this.getAutoComputeBounds()) {
            this.setSVGBounds(this._graph.getBounds2D().getWidth() + this._graph.getBounds2D().getX(), this._graph.getBounds2D().getHeight() + this._graph.getBounds2D().getY());
        }
        this.out(printStream, "<svg width = \"" + this.getSVGWidth() + "px\" height=\"" + this.getSVGHeight() + "px\">\n");
    }

    public void writeSVGEnd(PrintStream printStream) {
        this.out(printStream, "</svg>");
    }

    public void writeScript(PrintStream printStream) {
        Object object;
        Object object2;
        if (!this.getGenerateScriptSection()) {
            return;
        }
        this.out(printStream, "<script language=\"JavaScript1.2\"><![CDATA[\n");
        int n = this._graph.getComponentCount();
        LxComponent[] lxComponentArray = this._graph.getComponents();
        int n2 = 0;
        while (n2 < n) {
            object2 = lxComponentArray[n2];
            this._existPushButton = false;
            this._existSlider = false;
            if (object2 instanceof LxAbstractPushButton) {
                this._existPushButton = true;
            } else if (object2 instanceof LxAbstractSlider) {
                this._existSlider = true;
            }
            object = this.getExtraData();
            if (object != null && this.getGenerateObjectScript()) {
                ((LxSVGExtraData)object).writeObjectScript(printStream, (LxComponent)object2);
            }
            ++n2;
        }
        if (this.getGenerateDynoScript()) {
            if (this._existPushButton) {
                object2 = "function onMouseDownPushButton(target_id)\n{\n// get current object\nvar obj = svgdoc.getElementById(target_id+'OFF');\nvar style = obj.getStyle();\nstyle.setProperty('visibility','hidden');\nvar obj = svgdoc.getElementById(target_id+'ON');\nvar style = obj.getStyle();\nstyle.setProperty('visibility','visible');\n}";
                object = "function onMouseUpPushButton(target_id)\n{\n// get current object\nvar obj = svgdoc.getElementById(target_id+'OFF');\nvar style = obj.getStyle();\nstyle.setProperty('visibility','visible');\nvar obj = svgdoc.getElementById(target_id+'ON');\nvar style = obj.getStyle();\nstyle.setProperty('visibility','hidden');\n}";
                this.out(printStream, object2);
                this.out(printStream, object);
            }
            if (this._existSlider) {
                object2 = "function onMouseMouveSlider(target_id,evt)\n{\nvar indicator=svgdoc.getElementById(target_id+'INDICATOR');\nvar x = evt.getClientX();\n ";
                object2 = (String)object2 + "obj=svgdoc.getElementById(target_id+'BOX');\n";
                object2 = (String)object2 + "var style = obj.getStyle();\n";
                object2 = (String)object2 + "style.setProperty('fill','red');\n";
                object2 = (String)object2 + "style.setProperty('visibility','visible');\n";
                object2 = (String)object2 + "style.setProperty('opacity',0.0);\n";
                object2 = (String)object2 + "originX = obj.getAttribute('x');\n";
                object2 = (String)object2 + "var width = obj.getAttribute('width');\n";
                object2 = (String)object2 + "long = width*1+originX*1;\n";
                object2 = (String)object2 + "if (x>=originX && x<=long) {\n";
                object2 = (String)object2 + "indicator.setAttribute('width',x-originX);\n";
                object2 = (String)object2 + "var txt = svgdoc.getElementById(target_id+'VALUE');\n";
                object2 = (String)object2 + "var value = Math.floor( ( (x-originX)*100 ) / width);\n";
                object2 = (String)object2 + "txt.getFirstChild().setData(value + ' %');\n";
                object2 = (String)object2 + "}\n";
                object2 = (String)object2 + "}\n";
                this.out(printStream, object2);
            }
        }
        this.out(printStream, "]]></script>\n");
    }

    private void prepareTemplateStyle(double d, double d2, LxContainer lxContainer) {
        int n = lxContainer.getComponentCount();
        LxComponent[] lxComponentArray = lxContainer.getComponents();
        int n2 = 0;
        while (n2 < n) {
            this._xoffset = d;
            this._yoffset = d2;
            if (lxComponentArray[n2] instanceof LxContainer) {
                LxComponent lxComponent = lxComponentArray[n2];
                this.prepareTemplateStyle(d + lxComponent.getX(), d2 + lxComponent.getY(), (LxContainer)((Object)lxComponent));
            } else {
                this.makeTemplateStyle((LxElement)lxComponentArray[n2]);
            }
            ++n2;
        }
    }

    public void writeStyles(PrintStream printStream) {
        this._styleSection = "";
        this._styleTable.clear();
        this._styleCount = 0;
        this._gradientSection = "";
        this._gradientCount = 0;
        this.prepareTemplateStyle(0.0, 0.0, this._graph);
        this._gradientCount = 0;
        printStream.print(this._gradientSection);
        if (this.getShareStyles()) {
            printStream.print(this._styleSection);
        }
    }

    public void writeDefsSection(PrintStream printStream) {
        this.out(printStream, "<defs>\n");
        this.indent();
        this.writeScript(printStream);
        this.writeStyles(printStream);
        this.writeSymbols(printStream);
        this.deindent();
        this.out(printStream, "</defs>\n");
    }

    public void writeSymbols(PrintStream printStream) {
        Enumeration enumeration = this._symbolTable.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            LxComponent lxComponent = (LxComponent)this._symbolTable.get(clazz);
            this.out(printStream, "<symbol id=\"" + this.getSymbolReference(lxComponent) + "\">\n");
            if (this.getGenerateExtraData()) {
                this.writeObjectChildElements(printStream, lxComponent);
            }
            this.indent();
            this.writeComponent(printStream, 0.0, 0.0, lxComponent, false);
            this.deindent();
            this.out(printStream, "</symbol>\n");
        }
    }

    public void writeObjects(PrintStream printStream) {
        int n = this._graph.getComponentCount();
        LxComponent[] lxComponentArray = this._graph.getComponents();
        int n2 = 0;
        while (n2 < n) {
            if (lxComponentArray[n2].isVisible() || this.getGenerateHiddenComponents()) {
                if (!this.isSymbol(lxComponentArray[n2])) {
                    this.writeComponent(printStream, 0.0, 0.0, lxComponentArray[n2], false);
                } else {
                    this.getComponentProp(lxComponentArray[n2]);
                    this.out(printStream, "<use " + this._idAttribute + " xlink:href=\"#" + this.getSymbolReference(lxComponentArray[n2]) + "\" x=\"" + this.Precision(this._x) + "\" y=\"" + this.Precision(this._y) + "\"");
                    if (this.getGenerateExtraData()) {
                        this.writeObjectAttributes(printStream, lxComponentArray[n2]);
                    }
                    this.out(printStream, ">\n");
                    if (this.getGenerateExtraData()) {
                        this.writeObjectChildElements(printStream, lxComponentArray[n2]);
                    }
                    this.out(printStream, "</use>\n");
                }
            }
            ++n2;
        }
    }

    public void writeHeader(PrintStream printStream) {
        this.indent();
        this.writeXmlVersion(printStream);
        this.writeDTDDeclaration(printStream);
    }

    public void writeBody(PrintStream printStream) {
        this.writeSVGStart(printStream);
        this.indent();
        this.writeDefsSection(printStream);
        this.writeObjects(printStream);
        this.deindent();
        this.writeSVGEnd(printStream);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveAsSVG(LxAbstractGraph lxAbstractGraph, String string) {
        Serializable serializable;
        this._nbTab = -1;
        this._tabulation = "";
        this.setGraph(lxAbstractGraph);
        if (string == null || string.equals("")) {
            return;
        }
        OutputStream outputStream = null;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new IOException("file " + string + " has no extension");
        }
        String string2 = string.substring(1 + n).toUpperCase();
        String string3 = string;
        try {
            serializable = new URL(string);
            string3 = ((URL)serializable).getFile();
        }
        catch (Exception exception) {
            string3 = string;
        }
        serializable = new File(string3);
        if (!string3.toLowerCase().endsWith(".svg")) {
            throw new IOException("unknown file type: " + string3);
        }
        if (((File)serializable).exists() && !((File)serializable).delete()) {
            throw new IOException("cannot rewrite file " + string3);
        }
        outputStream = new FileOutputStream(string3);
        this._printStream = new PrintStream(outputStream);
        this._nameIndex.clear();
        this.writeHeader(this._printStream);
        this.writeBody(this._printStream);
        outputStream.close();
        Object var9_10 = null;
        if (outputStream == null) return;
        try {
            outputStream.flush();
            outputStream.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (IOException iOException) {
                System.err.println("Save error: " + iOException);
                Object var9_11 = null;
                if (outputStream == null) return;
                try {
                    outputStream.flush();
                    outputStream.close();
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.flush();
                outputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setExtraData(LxSVGExtraData lxSVGExtraData) {
        this._extraData = lxSVGExtraData;
    }

    public LxSVGExtraData getExtraData() {
        return this._extraData;
    }

    public void addSymbol(LxComponent lxComponent) {
        if (lxComponent != null) {
            this._symbolTable.put(lxComponent.getClass(), lxComponent);
        }
    }

    public void removeSymbol(LxComponent lxComponent) {
        if (lxComponent != null) {
            this._symbolTable.remove(lxComponent.getClass());
        }
    }

    public void clearSymbols() {
        this._symbolTable.clear();
    }

    public boolean isSymbol(LxComponent lxComponent) {
        return this._symbolTable.containsKey(lxComponent.getClass());
    }

    public String getSymbolReference(LxComponent lxComponent) {
        if (this.isSymbol(lxComponent)) {
            String string = lxComponent.getClass().getName();
            return string.substring(string.lastIndexOf(".") + 1);
        }
        return "";
    }

    private void out(PrintStream printStream, Object object) {
        printStream.print(this._tabulation + object);
    }

    private void indent() {
        ++this._nbTab;
        if (this._nbTab > 0) {
            this._tabulation = this._tabulation + "    ";
        }
    }

    private void deindent() {
        if (this._nbTab > 0) {
            --this._nbTab;
            this._tabulation = "";
            int n = 0;
            while (n < this._nbTab) {
                this._tabulation = this._tabulation + "    ";
                ++n;
            }
        }
    }
}

