/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.Cache;
import com.loox.jloox.Lx;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxAbstractStyle;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxComponentAdapter;
import com.loox.jloox.LxComponentEvent;
import com.loox.jloox.LxComponentListener;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxLayers;
import com.loox.jloox.LxShadowElement;
import com.loox.jloox.Point2DDouble;
import com.loox.jloox.Rectangle2DDouble;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.WeakHashMap;

public abstract class LxVectorial
extends LxElement
implements Serializable {
    static final String CLASS_NAME = "LxVectorial";
    static final Cache _cache = new Cache();
    private static final WeakHashMap _hash = new WeakHashMap();
    private static final LxComponentListener _comp_lstnr = new LxComponentAdapter(){

        public void componentMorphed(LxComponentEvent lxComponentEvent) {
            ((LxVectorial)lxComponentEvent.getComponent())._shape.reset();
        }

        public void componentResized(LxComponentEvent lxComponentEvent) {
            ((LxVectorial)lxComponentEvent.getComponent())._shape.reset();
        }
    };
    private MyShape _shape = null;

    public LxVectorial() {
        this(CLASS_NAME, null, null, true);
    }

    LxVectorial(String string, LxContainer lxContainer, Rectangle2D rectangle2D, boolean bl) {
        super(string, lxContainer, rectangle2D, false);
        this._initObjectVariables();
        if (bl) {
            this._postInitialize();
        }
    }

    public Object clone() {
        LxVectorial lxVectorial = (LxVectorial)super.clone();
        if (lxVectorial == null) {
            return null;
        }
        lxVectorial._initObjectVariables();
        return lxVectorial;
    }

    public Rectangle2D getStrokedBounds2D(Rectangle2D rectangle2D) {
        if (this._shape == null) {
            return null;
        }
        return this._shape.getBounds(rectangle2D);
    }

    Rectangle2D _getStrokedBounds2D() {
        return this._shape.getCurrentBounds();
    }

    protected Shape getTrajectoryShape() {
        return this._shape.get()[0].shape;
    }

    public boolean intersects(double d, double d2, double d3, double d4, LxAbstractView lxAbstractView) {
        LxLayers lxLayers = lxAbstractView != null ? lxAbstractView.getLayers() : null;
        boolean bl = lxAbstractView != null ? lxAbstractView.getZoomLines() : false;
        double d5 = lxAbstractView != null ? lxAbstractView.getZoomFactor() : (double)this.getLineThickness();
        return this._intersects(d, d2, d3, d4, lxLayers, bl, d5);
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
    }

    protected abstract ShapeData[] getShapeData();

    public abstract Shape[] getShape();

    boolean _intersects(double d, double d2, double d3, double d4, LxLayers lxLayers, boolean bl, double d5) {
        Object object;
        if (this.isGhost()) {
            return false;
        }
        if (lxLayers != null && !lxLayers.intersects(this._getLayers())) {
            return false;
        }
        if (super._intersects(d, d2, d3, d4, lxLayers, bl, d5)) {
            return true;
        }
        if (!this.getStrokedBounds2D().intersects(d, d2, d3, d4)) {
            return false;
        }
        ShapeData[] shapeDataArray = this._shape.get();
        double d6 = d - this.getCenterX() + d3 / 2.0;
        double d7 = d2 - this.getCenterY() + d4 / 2.0;
        int n = 0;
        while (n < shapeDataArray.length) {
            object = shapeDataArray[n];
            if (((ShapeData)object).getPaint() != null && ((ShapeData)object).shape.contains(d6, d7)) {
                return true;
            }
            ++n;
        }
        if (this.getLineThickness() > 0.0f) {
            object = shapeDataArray[0].shape.getPathIterator(null);
            double d8 = bl ? (double)(this.getLineThickness() / 2.0f) : (double)(this.getLineThickness() / 2.0f) / d5;
            double[] dArray = new double[6];
            double d9 = d - this.getCenterX() - d8;
            double d10 = d2 - this.getCenterY() - d8;
            double d11 = d3 + d8 + d8;
            double d12 = d4 + d8 + d8;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            CubicCurve2D.Double double_ = null;
            QuadCurve2D.Double double_2 = null;
            Rectangle2D rectangle2D = null;
            while (!object.isDone()) {
                int n2 = object.currentSegment(dArray);
                switch (n2) {
                    case 0: {
                        d13 = d15 = dArray[0];
                        d14 = d16 = dArray[1];
                        break;
                    }
                    case 4: {
                        if (rectangle2D == null) {
                            rectangle2D = new Rectangle2D.Double(d9, d10, d11, d12);
                        }
                        if (rectangle2D.intersectsLine(d15, d16, d13, d14)) {
                            return true;
                        }
                        d15 = dArray[0];
                        d16 = dArray[1];
                        break;
                    }
                    case 1: {
                        if (rectangle2D == null) {
                            rectangle2D = new Rectangle2D.Double(d9, d10, d11, d12);
                        }
                        if (rectangle2D.intersectsLine(d15, d16, dArray[0], dArray[1])) {
                            return true;
                        }
                        d15 = dArray[0];
                        d16 = dArray[1];
                        break;
                    }
                    case 2: {
                        if (double_2 == null) {
                            double_2 = new QuadCurve2D.Double();
                        }
                        ((QuadCurve2D)double_2).setCurve(d15, d16, dArray[0], dArray[1], dArray[2], dArray[3]);
                        if (double_2.intersects(d9, d10, d11, d12)) {
                            return true;
                        }
                        d15 = dArray[2];
                        d16 = dArray[3];
                        break;
                    }
                    case 3: {
                        if (double_ == null) {
                            double_ = new CubicCurve2D.Double();
                        }
                        ((CubicCurve2D)double_).setCurve(d15, d16, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                        if (double_.intersects(d9, d10, d11, d12)) {
                            return true;
                        }
                        d15 = dArray[4];
                        d16 = dArray[5];
                        break;
                    }
                }
                object.next();
            }
        }
        return false;
    }

    void _paint(Graphics2D graphics2D, AffineTransform affineTransform, LxLayers lxLayers, double d, boolean bl) {
        Shape shape;
        Composite composite = graphics2D.getComposite();
        float f = this.getTransparency();
        if (f == 1.0f && this.getPaint() instanceof TexturePaint) {
            f = 0.99f;
        }
        if (f != 1.0f) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        graphics2D.transform(affineTransform);
        if (this.getClipComponent() != null) {
            LxComponent lxComponent = this.getClipComponent();
            Shape shape2 = lxComponent.getTrajectoryShape();
            if (shape2 != null) {
                shape = graphics2D.getClip();
                AffineTransform affineTransform3 = new AffineTransform();
                affineTransform3.translate(lxComponent.getCenterX() - this.getCenterX(), lxComponent.getCenterY() - this.getCenterY());
                graphics2D.clip(affineTransform3.createTransformedShape(shape2));
            } else {
                shape = null;
            }
        } else {
            shape = null;
        }
        if (this.prepaint(graphics2D)) {
            this.paintElement(graphics2D);
        }
        this.postpaint(graphics2D);
        if (shape != null) {
            graphics2D.setClip(shape);
        }
        graphics2D.setTransform(affineTransform2);
        if (f != 1.0f) {
            graphics2D.setComposite(composite);
        }
    }

    protected void paintElement(Graphics2D graphics2D) {
        Object object;
        Object object2;
        ShapeData[] shapeDataArray = this._shape.get();
        int n = 0;
        while (n < shapeDataArray.length) {
            try {
                object2 = shapeDataArray[n];
                object = ((ShapeData)object2).getPaint();
                if (object != null) {
                    graphics2D.setPaint((Paint)object);
                    graphics2D.fill(((ShapeData)object2).shape);
                }
            }
            catch (Exception exception) {
                System.err.println("Paint exception:  " + this + ":  " + exception);
            }
            ++n;
        }
        if (this.getLineThickness() > 0.0f) {
            object2 = graphics2D.getPaint();
            graphics2D.setPaint(this.getLineColor());
            object = graphics2D.getRenderingHint(LxAbstractView.KEY_ZOOMABLE_LINES);
            boolean bl = object != null ? object.equals(LxAbstractView.VALUE_ZOOM_LINES_ON) : false;
            Stroke stroke = graphics2D.getStroke();
            if (bl) {
                graphics2D.setStroke(this.getLineStroke());
            } else {
                double d;
                AffineTransform affineTransform = graphics2D.getTransform();
                BasicStroke basicStroke = (BasicStroke)this.getLineStroke();
                double d2 = Math.abs(affineTransform.getScaleX());
                if (d2 == 0.0) {
                    d2 = Math.abs(affineTransform.getShearX());
                }
                if (d2 == 0.0) {
                    d2 = 1.0;
                }
                if ((d = (double)basicStroke.getLineWidth() / d2) < 0.003) {
                    d = 0.003;
                }
                graphics2D.setStroke(LxAbstractStyle._getStroke((float)d, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
            }
            graphics2D.draw(shapeDataArray[0].shape);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint((Paint)object2);
        }
    }

    private void _initObjectVariables() {
        this._shape = new MyShape();
    }

    protected final class StandardShapeData
    extends ShapeData
    implements Serializable {
        public StandardShapeData(Shape shape) {
            super(shape);
        }

        public Paint getPaint() {
            return LxVectorial.this.getPaint();
        }
    }

    protected abstract class ShapeData
    implements Serializable,
    Cloneable {
        public transient Shape shape;
        private boolean _sharable = true;

        public ShapeData(Shape shape) {
            this.shape = shape;
        }

        public abstract Paint getPaint();

        boolean _isSharable() {
            return this._sharable;
        }

        void _setSharable(boolean bl) {
            this._sharable = bl;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                return null;
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            int n = objectInputStream.readInt();
            if (n == -1) {
                this.shape = null;
                return;
            }
            GeneralPath generalPath = new GeneralPath();
            int n2 = 0;
            while (n2 < n) {
                int n3 = objectInputStream.readInt();
                switch (n3) {
                    case 0: {
                        generalPath.moveTo(objectInputStream.readFloat(), objectInputStream.readFloat());
                        break;
                    }
                    case 1: {
                        generalPath.lineTo(objectInputStream.readFloat(), objectInputStream.readFloat());
                        break;
                    }
                    case 2: {
                        generalPath.quadTo(objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat());
                        break;
                    }
                    case 3: {
                        generalPath.curveTo(objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat());
                        break;
                    }
                    case 4: {
                        generalPath.closePath();
                        break;
                    }
                }
                ++n2;
            }
            this.shape = generalPath;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (this.shape == null) {
                objectOutputStream.writeInt(-1);
                return;
            }
            PathIterator pathIterator = this.shape.getPathIterator(null);
            int n = 0;
            while (!pathIterator.isDone()) {
                ++n;
                pathIterator.next();
            }
            objectOutputStream.writeInt(n);
            pathIterator = this.shape.getPathIterator(null);
            float[] fArray = new float[6];
            while (!pathIterator.isDone()) {
                int n2 = pathIterator.currentSegment(fArray);
                objectOutputStream.writeInt(n2);
                switch (n2) {
                    case 0: 
                    case 1: {
                        int n3 = 0;
                        while (n3 < 2) {
                            objectOutputStream.writeFloat(fArray[n3]);
                            ++n3;
                        }
                        break;
                    }
                    case 2: {
                        int n4 = 0;
                        while (n4 < 4) {
                            objectOutputStream.writeFloat(fArray[n4]);
                            ++n4;
                        }
                        break;
                    }
                    case 3: {
                        int n5 = 0;
                        while (n5 < 6) {
                            objectOutputStream.writeFloat(fArray[n5]);
                            ++n5;
                        }
                        break;
                    }
                }
                pathIterator.next();
            }
        }
    }

    protected final class ShadowShapeData
    extends ShapeData
    implements Serializable {
        private static final int MAX_BYTE = 255;
        private static final double RED_LUMINOSITY = 0.3;
        private static final double GREEN_LUMINOSITY = 0.59;
        private static final double BLUE_LUMINOSITY = 0.11;
        private static final int INTENSITY_FACTOR = 25;
        private static final int LIGHT_FACTOR = 0;
        private static final int LUMINOSITY_FACTOR = 75;
        private static final double COLOR_LITE_THRESHOLD = 196.35;
        private static final double FOREGROUND_THRESHOLD = 89.25;
        private static final double COLOR_DARK_THRESHOLD = 38.25;
        private static final int COLOR_LITE_SEL_FACTOR = 15;
        private static final int COLOR_LITE_BS_FACTOR = 45;
        private static final int COLOR_LITE_TS_FACTOR = 20;
        private static final int COLOR_DARK_SEL_FACTOR = 15;
        private static final int COLOR_DARK_BS_FACTOR = 30;
        private static final int COLOR_DARK_TS_FACTOR = 50;
        private static final int COLOR_HI_SEL_FACTOR = 15;
        private static final int COLOR_HI_BS_FACTOR = 35;
        private static final int COLOR_HI_TS_FACTOR = 70;
        private static final int COLOR_LO_SEL_FACTOR = 15;
        private static final int COLOR_LO_BS_FACTOR = 60;
        private static final int COLOR_LO_TS_FACTOR = 40;
        final boolean _inverted;

        public ShadowShapeData(Shape shape, boolean bl) {
            super(shape);
            this._inverted = bl;
        }

        public int getBrightness(Color color) {
            int n;
            int n2 = color.getRed();
            int n3 = color.getGreen();
            int n4 = color.getBlue();
            int n5 = (n2 + n3 + n4) / 3;
            int n6 = (int)(0.3 * (double)n2 + 0.59 * (double)n3 + 0.11 * (double)n4);
            int n7 = n2 > n3 ? (n2 > n4 ? n2 : n4) : (n = n3 > n4 ? n3 : n4);
            int n8 = n2 < n3 ? (n2 < n4 ? n2 : n4) : (n3 < n4 ? n3 : n4);
            int n9 = (n8 + n) / 2;
            return (n5 * 25 + n9 * 0 + n6 * 75) / 100;
        }

        public Color[] getShadowColors(Color color) {
            Color color2;
            Color color3;
            Color[] colorArray = new Color[2];
            int n = this.getBrightness(color);
            int n2 = color.getRed();
            int n3 = color.getGreen();
            int n4 = color.getBlue();
            if ((double)n > 196.35) {
                color3 = Lx._getColor(n2 - n2 * 20 / 100, n3 - n3 * 20 / 100, n4 - n4 * 20 / 100);
                color2 = Lx._getColor(n2 - n2 * 45 / 100, n3 - n3 * 45 / 100, n4 - n4 * 45 / 100);
            } else if ((double)n < 38.25) {
                color3 = Lx._getColor(n2 + 50 * (255 - n2) / 100, n3 + 50 * (255 - n3) / 100, n4 + 50 * (255 - n4) / 100);
                color2 = Lx._getColor(n2 + 30 * (255 - n2) / 100, n3 + 30 * (255 - n3) / 100, n4 + 30 * (255 - n4) / 100);
            } else {
                int n5 = 40 + n * 30 / 255;
                color3 = Lx._getColor(n2 + n5 * (255 - n2) / 100, n3 + n5 * (255 - n3) / 100, n4 + n5 * (255 - n4) / 100);
                n5 = 60 - n * 25 / 255;
                color2 = Lx._getColor(n2 - n2 * n5 / 100, n3 - n3 * n5 / 100, n4 - n4 * n5 / 100);
            }
            colorArray[0] = color3;
            colorArray[1] = color2;
            return colorArray;
        }

        public Paint getPaint() {
            Color color = LxVectorial.this.getLineColor();
            boolean bl = LxVectorial.this instanceof LxShadowElement ? ((LxShadowElement)((Object)LxVectorial.this)).isInverted() : false;
            Color[] colorArray = this.getShadowColors(color);
            if (this._inverted != bl) {
                return colorArray[1];
            }
            return colorArray[0];
        }
    }

    static class RectangularCreation
    extends MouseAdapter
    implements LxElement.InteractiveCreation {
        private Point _start = null;
        private Point _end = null;
        private MouseListener _current_lstnr = null;
        private MouseMotionListener _motion_lstnr = null;
        private LxAbstractView _view = null;
        public static int USE_SHIFT = 1;
        public static int SQUARE = 2;
        public static int NO_SQUARE = 0;
        private int _square = USE_SHIFT;
        private final Class _target;
        private final MouseListener _stop_lstnr = new MouseAdapter(this){
            private final /* synthetic */ RectangularCreation this$0;
            {
                this.this$0 = rectangularCreation;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.this$0.extend(mouseEvent.getPoint());
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.this$0.acceptExtend(mouseEvent)) {
                    return;
                }
                if (RectangularCreation.access$200(this.this$0) == null) {
                    return;
                }
                double d = RectangularCreation.access$300(this.this$0).getZoomFactor();
                int n = Math.min(RectangularCreation.access$200((RectangularCreation)this.this$0).x, RectangularCreation.access$400((RectangularCreation)this.this$0).x);
                int n2 = Math.min(RectangularCreation.access$200((RectangularCreation)this.this$0).y, RectangularCreation.access$400((RectangularCreation)this.this$0).y);
                int n3 = Math.max(Math.max(RectangularCreation.access$200((RectangularCreation)this.this$0).x, RectangularCreation.access$400((RectangularCreation)this.this$0).x) - n, 2);
                int n4 = Math.max(Math.max(RectangularCreation.access$200((RectangularCreation)this.this$0).y, RectangularCreation.access$400((RectangularCreation)this.this$0).y) - n2, 2);
                LxElement lxElement = this.this$0.create(RectangularCreation.access$300(this.this$0).getGraph(), new Rectangle2DDouble((double)n / d, (double)n2 / d, (double)n3 / d, (double)n4 / d), mouseEvent.getPoint());
                if (lxElement != null) {
                    RectangularCreation.access$500(this.this$0);
                }
                RectangularCreation.access$300(this.this$0)._finishCreation(lxElement);
            }
        };
        private final MouseMotionListener _drag_lstnr = new MouseMotionAdapter(this){
            private final /* synthetic */ RectangularCreation this$0;
            {
                this.this$0 = rectangularCreation;
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                RectangularCreation.access$500(this.this$0);
                Point2D point2D = new Point2DDouble(mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY());
                point2D = RectangularCreation.access$300(this.this$0).applyMagneticGrid(point2D);
                if (RectangularCreation.access$600(this.this$0) == RectangularCreation.SQUARE || RectangularCreation.access$600(this.this$0) == RectangularCreation.USE_SHIFT && (mouseEvent.getModifiers() & 1) != 0) {
                    double d = point2D.getX() - RectangularCreation.access$200(this.this$0).getX();
                    double d2 = point2D.getY() - RectangularCreation.access$200(this.this$0).getY();
                    if (Math.abs(d) > Math.abs(d2)) {
                        d = d2 < 0.0 ? -Math.abs(d) : Math.abs(d);
                        point2D.setLocation(point2D.getX(), RectangularCreation.access$200(this.this$0).getY() + d);
                    } else {
                        d2 = d < 0.0 ? -Math.abs(d2) : Math.abs(d2);
                        point2D.setLocation(RectangularCreation.access$200(this.this$0).getX() + d2, point2D.getY());
                    }
                }
                RectangularCreation.access$402(this.this$0, new Point((int)point2D.getX(), (int)point2D.getY()));
                RectangularCreation.access$500(this.this$0);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                this.mouseDragged(mouseEvent);
            }
        };
        static /* synthetic */ Class class$com$loox$jloox$LxContainer;
        static /* synthetic */ Class class$java$awt$geom$Rectangle2D;

        RectangularCreation(Class clazz, LxAbstractView lxAbstractView) {
            this._target = clazz;
            this._view = lxAbstractView;
        }

        RectangularCreation(Class clazz, LxAbstractView lxAbstractView, int n) {
            this._target = clazz;
            this._view = lxAbstractView;
            this._square = n;
        }

        boolean acceptExtend(MouseEvent mouseEvent) {
            return false;
        }

        public Point getStartPoint() {
            return this._start;
        }

        public Point getEndPoint() {
            return this._end;
        }

        LxElement create(LxAbstractGraph lxAbstractGraph, Rectangle2D rectangle2D, Point point) {
            try {
                Constructor constructor = this._target.getConstructor(class$com$loox$jloox$LxContainer == null ? (class$com$loox$jloox$LxContainer = RectangularCreation.class$("com.loox.jloox.LxContainer")) : class$com$loox$jloox$LxContainer, class$java$awt$geom$Rectangle2D == null ? (class$java$awt$geom$Rectangle2D = RectangularCreation.class$("java.awt.geom.Rectangle2D")) : class$java$awt$geom$Rectangle2D);
                LxElement lxElement = (LxElement)constructor.newInstance(lxAbstractGraph, rectangle2D);
                return lxElement;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        private void _draw() {
            Graphics graphics = this._view.getGraphics();
            int n = Math.min(this._start.x, this._end.x);
            int n2 = Math.min(this._start.y, this._end.y);
            int n3 = Math.max(this._start.x, this._end.x) - n;
            int n4 = Math.max(this._start.y, this._end.y) - n2;
            graphics.setColor(Color.black);
            Lx.setXORMode(graphics, this._view.getBackground());
            this.draw(graphics, n, n2, n3, n4, this._end);
        }

        void draw(Graphics graphics, int n, int n2, int n3, int n4, Point point) {
            graphics.drawRect(n, n2, n3, n4);
        }

        void extend(Point point) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point2D point2D = new Point2DDouble(mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY());
            point2D = this._view.applyMagneticGrid(point2D);
            Point point = new Point((int)point2D.getX(), (int)point2D.getY());
            this._start = this._end = new Point((int)point2D.getX(), (int)point2D.getY());
            this._view.removeMouseListener(this._current_lstnr);
            this._current_lstnr = this._stop_lstnr;
            this._view.addMouseListener(this._current_lstnr);
            this._motion_lstnr = this._drag_lstnr;
            this._view.addMouseMotionListener(this._motion_lstnr);
            this._draw();
        }

        public void start() {
            this._current_lstnr = this;
            this._view.addMouseListener(this._current_lstnr);
        }

        public void stop() {
            this._view.removeMouseListener(this._current_lstnr);
            this._current_lstnr = null;
            if (this._motion_lstnr != null) {
                this._view.removeMouseMotionListener(this._motion_lstnr);
                this._motion_lstnr = null;
            }
            if (this._start != null && this._end != null) {
                this._draw();
            }
            this._end = null;
            this._start = null;
        }

        static /* synthetic */ Point access$200(RectangularCreation rectangularCreation) {
            return rectangularCreation._start;
        }

        static /* synthetic */ LxAbstractView access$300(RectangularCreation rectangularCreation) {
            return rectangularCreation._view;
        }

        static /* synthetic */ Point access$400(RectangularCreation rectangularCreation) {
            return rectangularCreation._end;
        }

        static /* synthetic */ void access$500(RectangularCreation rectangularCreation) {
            rectangularCreation._draw();
        }

        static /* synthetic */ int access$600(RectangularCreation rectangularCreation) {
            return rectangularCreation._square;
        }

        static /* synthetic */ Point access$402(RectangularCreation rectangularCreation, Point point) {
            rectangularCreation._end = point;
            return rectangularCreation._end;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class MyShape
    implements Serializable {
        private ShapeData[] _value = null;
        private transient Rectangle2D _bounds = null;

        MyShape() {
            LxVectorial.this.addComponentListener(_comp_lstnr);
        }

        public void reset() {
            this._value = null;
            this._bounds = null;
        }

        public ShapeData[] get() {
            if (this._value == null) {
                this._value = LxVectorial.this.getShapeData();
            }
            return this._value;
        }

        public Rectangle2D getBounds(Rectangle2D rectangle2D) {
            if (this._bounds == null) {
                this._bounds = this.get()[0].shape.getBounds2D();
                double d = LxVectorial.this.getLineThickness() * 9.0f;
                double d2 = d / 2.0;
                double d3 = this._bounds.getX() - d2;
                double d4 = -this._bounds.getHeight() - this._bounds.getY() - d2;
                this._bounds.setRect(d3, d4, this._bounds.getWidth() + d, this._bounds.getHeight() + d);
                int n = 1;
                while (n < this._value.length) {
                    this._bounds.add(this._value[n].shape.getBounds2D());
                    ++n;
                }
            }
            rectangle2D.setRect(this._bounds.getX() + LxVectorial.this.getCenterX(), this._bounds.getY() + LxVectorial.this.getCenterY(), this._bounds.getWidth(), this._bounds.getHeight());
            return rectangle2D;
        }

        public Rectangle2D getCurrentBounds() {
            if (this._bounds == null) {
                return null;
            }
            return this.getBounds(new Rectangle2DDouble());
        }
    }

    protected final class LineShapeData
    extends ShapeData
    implements Serializable {
        public LineShapeData(Shape shape) {
            super(shape);
        }

        public Paint getPaint() {
            return LxVectorial.this.getLineColor();
        }
    }
}

