/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.LooxUndoableEdit;
import com.loox.jloox.Lx;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxConstants;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxShadowElement;
import com.loox.jloox.Resources;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

class Shadow
implements LxShadowElement,
LxConstants,
Serializable {
    private static final String THICKNESS_UNDO = "shadow-thicknessUndo";
    private static final String INVERTED_UNDO = "shadow-invertedUndo";
    private LxElement _host;
    private boolean _inverted = false;
    private double _thickness = 0.0;

    Shadow(LxElement lxElement) {
        this._host = lxElement;
        LxAbstractGraph lxAbstractGraph = this._host.getGraph();
        if (lxAbstractGraph != null) {
            this._inverted = lxAbstractGraph.getDefaultShadowInversion();
            this._thickness = lxAbstractGraph.getDefaultShadowThickness();
        } else {
            this._inverted = Lx.getDefaultShadowInversion();
            this._thickness = Lx.getDefaultShadowThickness();
        }
    }

    private void _setInverted(boolean bl, boolean bl2) {
        boolean bl3 = this._inverted;
        if (bl == bl3) {
            return;
        }
        Rectangle2D rectangle2D = this._host.getStrokedBounds2D();
        this._inverted = bl;
        if (bl2 && this._host._undoOn()) {
            this._host.addUndoEdit(new InvertedEdit(this, bl3));
        }
        if (this.getShadowThickness() > 0.0) {
            this._host.fireComponentMorphed(rectangle2D);
        }
        this._host._firePropertyChanged("inverted", bl3 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    private void _setThickness(double d, boolean bl) {
        double d2 = this._thickness;
        if (d == d2) {
            return;
        }
        Rectangle2D rectangle2D = this._host.getStrokedBounds2D();
        this._thickness = d;
        if (bl && this._host._undoOn()) {
            this._host.addUndoEdit(new ThicknessEdit(this, d2));
        }
        this._host.fireComponentMorphed(rectangle2D);
        this._host._firePropertyChanged("shadowThickness", new Double(d2), new Double(d));
    }

    public double getShadowThickness() {
        return this._thickness;
    }

    public boolean isInverted() {
        return this._inverted;
    }

    public void setInverted(boolean bl) {
        this._setInverted(bl, true);
    }

    public void setShadowThickness(double d) {
        this._setThickness(d, true);
    }

    private static final class ThicknessEdit
    extends LooxUndoableEdit {
        private double _value;

        public ThicknessEdit(Shadow shadow, double d) {
            super(shadow, Resources.get(Shadow.THICKNESS_UNDO, "shadow thickness"));
            this._value = d;
        }

        void _undoEdit(boolean bl) {
            Shadow shadow = (Shadow)this._getHost();
            double d = shadow.getShadowThickness();
            shadow._setThickness(this._value, false);
            this._value = d;
        }
    }

    private static final class InvertedEdit
    extends LooxUndoableEdit {
        public InvertedEdit(Shadow shadow, boolean bl) {
            super(shadow, Resources.get(Shadow.INVERTED_UNDO, "inverted"), bl);
        }

        void _undoEdit(boolean bl) {
            Shadow shadow = (Shadow)this._getHost();
            shadow._setInverted(bl, false);
        }
    }
}

