/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox.layout;

import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxAbstractLink;
import com.loox.jloox.LxAbstractRectangle;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxLayoutManager;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.layout.LxSpringLinkConstraints;
import com.loox.jloox.layout.LxSpringNodeConstraints;
import com.loox.jloox.layout.Resources;
import com.loox.jloox.layout.Spring;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LxSpringLayout
extends LxLayoutManager {
    static final String CLASS_NAME = "LxSpringLayout";
    private static final String ACTION = "spring-settings-dialog";
    private static final String DIALOG_TITLE = "spring-settings-dialogTitle";
    private static final String DIALOG_EDGE_LENGTH_LABEL = "spring-settings-dialogEdgeLengthLabel";
    private static final String DIALOG_SIZE_LABEL = "spring-settings-dialogSizeLabel";
    private static final String DIALOG_FIX_SELECTED_LABEL = "spring-settings-dialogFixSelectedLabel";
    private static final String DIALOG_AUTO_EDGE_LABEL = "spring-settings-dialogAutomaticEdgeLengthLabel";
    private static final String DIALOG_REPAINT_LABEL = "spring-settings-dialogRepaintPeriodLabel";
    private static final String DIALOG_EPSILON_LABEL = "spring-settings-dialogEpsilonLabel";
    private static final String DIALOG_TOP_ALIGN_LABEL = "spring-settings-dialogTopAlignLabel";
    private static final String DIALOG_HORIZONTAL_SPACING_LABEL = "spring-settings-dialogHorizontalSpacingLabel";
    private static final String DIALOG_VERTICAL_SPACING_LABEL = "spring-settings-dialogVerticalSpacingLabel";
    private static final String DIALOG_FRAME_TITLE_LABEL = "spring-settings-dialogSingleComponentsSettingsLabel";
    private static final String DIALOG_AUTOMATIC_SPACING_LABEL = "spring-settings-dialogAutomaticSingleSpacingLabel";
    private static final String DIALOG_SPECIFY_SIZE_LABEL = "spring-settings-dialogSpecifyManagerSizeLabel";
    private static final String DIALOG_LAYOUT_SIZE_LABEL = "spring-settings-dialogLayoutSizeLabel";
    private static final String DIALOG_ALIGNMENT_LABEL = "spring-settings-dialogAlignmentLabel";
    private static final String DIALOG_RIGHT_LABEL = "spring-settings-dialogRightLabel";
    private static final String DIALOG_LEFT_LABEL = "spring-settings-dialogLeftLabel";
    private static final String DIALOG_CENTER_LABEL = "spring-settings-dialogCenterLabel";
    private static final String DIALOG_TOP_LABEL = "spring-settings-dialogTopLabel";
    private static final String DIALOG_HORIZONTAL_ALIGNMENT_LABEL = "spring-settings-dialogHorizontalAlignmentLabel";
    private static final String DIALOG_VERTICAL_ALIGNMENT_LABEL = "spring-settings-dialogVerticalAlignmentLabel";
    public static final int LEFT_ALIGNMENT = 0;
    public static final int CENTER_ALIGNMENT = 2;
    public static final int RIGHT_ALIGNMENT = 1;
    public static final int TOP_ALIGNMENT = 3;
    public static final int ERROR_NO_COMPONENT = 1;
    public static final int ERROR_NON_CONNECTED_GRAPH = 2;
    public static final int ERROR_ALL_COMPONENTS_FIXED = 3;
    private boolean _autoEdgeLength = true;
    private double _edgeLength = 1000.0;
    private boolean _useObjectsSizes = true;
    private boolean _fixSelected = false;
    private double _XSpacing = 10.0;
    private double _YSpacing = 10.0;
    private boolean _automaticSingleSpacing = true;
    private boolean _specifyLayoutSize = false;
    private double _layoutSize = 500.0;
    private int _horizontalAlignment = 2;
    private int _verticalAlignment = 2;
    private int _repaintPeriod = 0;
    private double _epsilon = 1.5;
    private final HashMap _nodeConstraints = new HashMap();
    private final WeakHashMap _linkConstraints = new WeakHashMap();
    static /* synthetic */ Class class$com$loox$jloox$layout$LxSpringLayout;

    public LxSpringLayout() {
    }

    public LxSpringLayout(LxContainer lxContainer) {
        super(lxContainer);
    }

    public LxSpringLayout(Rectangle2D rectangle2D) {
        super(rectangle2D);
    }

    public LxSpringLayout(LxContainer lxContainer, Rectangle2D rectangle2D) {
        super(lxContainer, rectangle2D);
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        this._autoEdgeLength = LxSaveUtils.readBoolean(inputStream);
        this._edgeLength = LxSaveUtils.readDouble(inputStream);
        this._useObjectsSizes = LxSaveUtils.readBoolean(inputStream);
        this._fixSelected = LxSaveUtils.readBoolean(inputStream);
        this._repaintPeriod = LxSaveUtils.readInt(inputStream);
        this._epsilon = LxSaveUtils.readDouble(inputStream);
        if (this.getFileVersion() != null && this.getFileVersion().compareTo("1.3.0") >= 0) {
            this._XSpacing = LxSaveUtils.readDouble(inputStream);
            this._YSpacing = LxSaveUtils.readDouble(inputStream);
            this._automaticSingleSpacing = LxSaveUtils.readBoolean(inputStream);
            this._specifyLayoutSize = LxSaveUtils.readBoolean(inputStream);
            this._layoutSize = LxSaveUtils.readDouble(inputStream);
            this._horizontalAlignment = LxSaveUtils.readInt(inputStream);
            this._verticalAlignment = LxSaveUtils.readInt(inputStream);
        }
        LxSaveUtils.readEndOfPart(inputStream);
        final int n = LxSaveUtils.readInt(inputStream);
        final String[] stringArray = new String[n];
        final LxSpringNodeConstraints[] lxSpringNodeConstraintsArray = new LxSpringNodeConstraints[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = LxSaveUtils.readReference(inputStream);
            lxSpringNodeConstraintsArray[n2] = new LxSpringNodeConstraints(LxSaveUtils.readBoolean(inputStream), LxSaveUtils.readDouble(inputStream));
            ++n2;
        }
        final int n3 = LxSaveUtils.readInt(inputStream);
        final String[] stringArray2 = new String[n3];
        final LxSpringLinkConstraints[] lxSpringLinkConstraintsArray = new LxSpringLinkConstraints[n3];
        int n4 = 0;
        while (n4 < n3) {
            stringArray2[n4] = LxSaveUtils.readReference(inputStream);
            lxSpringLinkConstraintsArray[n4] = new LxSpringLinkConstraints(LxSaveUtils.readDouble(inputStream));
            ++n4;
        }
        LxSaveUtils.addPostProcessing(new LxSaveUtils.PostProcessing(){
            private final LxSpringLayout layout;
            {
                this.layout = LxSpringLayout.this;
            }

            public void run() throws IOException {
                LxAbstractGraph lxAbstractGraph = this.layout.getGraph();
                int n4 = 0;
                while (n4 < n) {
                    LxSpringLayout.this.setNodeConstraints(LxSaveUtils.getComponentByReference(lxAbstractGraph, stringArray[n4]), lxSpringNodeConstraintsArray[n4]);
                    ++n4;
                }
                int n2 = 0;
                while (n2 < n3) {
                    LxSpringLayout.this.setLinkConstraints((LxAbstractLink)LxSaveUtils.getComponentByReference(lxAbstractGraph, stringArray2[n2]), lxSpringLinkConstraintsArray[n2]);
                    ++n2;
                }
            }
        });
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        Object object;
        super.saveAsJLX(outputStream);
        LxSaveUtils.writeBoolean(outputStream, this._autoEdgeLength);
        LxSaveUtils.writeDouble(outputStream, this._edgeLength);
        LxSaveUtils.writeBoolean(outputStream, this._useObjectsSizes);
        LxSaveUtils.writeBoolean(outputStream, this._fixSelected);
        LxSaveUtils.writeInt(outputStream, this._repaintPeriod);
        LxSaveUtils.writeDouble(outputStream, this._epsilon);
        LxSaveUtils.writeDouble(outputStream, this._XSpacing);
        LxSaveUtils.writeDouble(outputStream, this._YSpacing);
        LxSaveUtils.writeBoolean(outputStream, this._automaticSingleSpacing);
        LxSaveUtils.writeBoolean(outputStream, this._specifyLayoutSize);
        LxSaveUtils.writeDouble(outputStream, this._layoutSize);
        LxSaveUtils.writeInt(outputStream, this._horizontalAlignment);
        LxSaveUtils.writeInt(outputStream, this._verticalAlignment);
        LxSaveUtils.writeEndOfPart(outputStream);
        Object[] objectArray = this._nodeConstraints.keySet().toArray();
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (this._nodeConstraints.get((LxComponent)objectArray[n2]) != null) {
                ++n;
            }
            ++n2;
        }
        LxSaveUtils.writeInt(outputStream, n);
        LxSaveUtils.writeEndOfPart(outputStream);
        int n3 = 0;
        while (n3 < objectArray.length) {
            object = (LxComponent)objectArray[n3];
            LxSpringNodeConstraints lxSpringNodeConstraints = (LxSpringNodeConstraints)this._nodeConstraints.get(object);
            if (lxSpringNodeConstraints != null) {
                LxSaveUtils.writeReference(outputStream, (LxComponent)object);
                LxSaveUtils.writeBoolean(outputStream, lxSpringNodeConstraints.isFixed());
                LxSaveUtils.writeDouble(outputStream, lxSpringNodeConstraints.getWeight());
                LxSaveUtils.writeEndOfPart(outputStream);
            }
            ++n3;
        }
        object = ((AbstractMap)this._linkConstraints).keySet().toArray();
        n = 0;
        int n4 = 0;
        while (n4 < ((Object[])object).length) {
            if (this._linkConstraints.get((LxComponent)object[n4]) != null) {
                ++n;
            }
            ++n4;
        }
        LxSaveUtils.writeInt(outputStream, n);
        LxSaveUtils.writeEndOfPart(outputStream);
        int n5 = 0;
        while (n5 < ((Object[])object).length) {
            LxComponent lxComponent = (LxComponent)object[n5];
            LxSpringLinkConstraints lxSpringLinkConstraints = (LxSpringLinkConstraints)this._linkConstraints.get(lxComponent);
            if (lxSpringLinkConstraints != null) {
                LxSaveUtils.writeReference(outputStream, lxComponent);
                LxSaveUtils.writeDouble(outputStream, lxSpringLinkConstraints.getWeight());
                LxSaveUtils.writeEndOfPart(outputStream);
            }
            ++n5;
        }
    }

    public static void createInteractively(LxAbstractView lxAbstractView) {
        LxAbstractRectangle.createInteractively(class$com$loox$jloox$layout$LxSpringLayout == null ? (class$com$loox$jloox$layout$LxSpringLayout = LxSpringLayout.class$("com.loox.jloox.layout.LxSpringLayout")) : class$com$loox$jloox$layout$LxSpringLayout, lxAbstractView);
    }

    public void add(LxComponent lxComponent) {
        super.add(lxComponent);
        this._nodeConstraints.put(lxComponent, null);
    }

    public void add(LxComponent lxComponent, int n) {
        super.add(lxComponent, n);
        this._nodeConstraints.put(lxComponent, null);
    }

    public void remove(LxComponent lxComponent) {
        super.remove(lxComponent);
        this._nodeConstraints.remove(lxComponent);
    }

    public void remove(int n) {
        LxComponent lxComponent = this.getComponent(n);
        super.remove(n);
        this._nodeConstraints.remove(lxComponent);
    }

    public void removeAll() {
        super.removeAll();
        this._nodeConstraints.clear();
    }

    protected LxLayoutManager.SettingsDialog createSettingsDialog() {
        LxLayoutManager.SettingsDialog settingsDialog = super.createSettingsDialog();
        settingsDialog.setTitle(Resources.get(DIALOG_TITLE, "Spring layout settings"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(LxLayoutManager.SettingsDialog.stdHalfBorder);
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(" " + Resources.get(DIALOG_FRAME_TITLE_LABEL, "Single components settings") + " ");
        titledBorder.setBorder(BorderFactory.createEtchedBorder());
        titledBorder.setTitleColor(Color.black);
        jPanel2.setBorder(titledBorder);
        JPanel jPanel3 = new JPanel();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(" " + Resources.get(DIALOG_ALIGNMENT_LABEL, "Horizontal / vertical  alignment") + " ");
        titledBorder2.setBorder(BorderFactory.createEtchedBorder());
        titledBorder2.setTitleColor(Color.black);
        jPanel3.setBorder(titledBorder2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(LxLayoutManager.SettingsDialog.stdHalfBorder);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = LxLayoutManager.SettingsDialog.stdInsets;
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        JLabel jLabel = new JLabel(Resources.get(DIALOG_EDGE_LENGTH_LABEL, "Edge length constant"));
        JLabel jLabel2 = new JLabel(Resources.get(DIALOG_REPAINT_LABEL, "Repaint period"));
        JLabel jLabel3 = new JLabel(Resources.get(DIALOG_EPSILON_LABEL, "Epsilon"));
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        final JRadioButton jRadioButton = new JRadioButton(" " + Resources.get(DIALOG_LEFT_LABEL, "Left"), this._horizontalAlignment == 0);
        final JRadioButton jRadioButton2 = new JRadioButton(" " + Resources.get(DIALOG_CENTER_LABEL, "Center"), this._horizontalAlignment == 2);
        final JRadioButton jRadioButton3 = new JRadioButton(" " + Resources.get(DIALOG_RIGHT_LABEL, "Right"), this._horizontalAlignment == 1);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        final JRadioButton jRadioButton4 = new JRadioButton(" " + Resources.get(DIALOG_TOP_LABEL, "Top"), this._horizontalAlignment == 3);
        final JRadioButton jRadioButton5 = new JRadioButton(" " + Resources.get(DIALOG_CENTER_LABEL, "Center"), this._horizontalAlignment == 2);
        buttonGroup2.add(jRadioButton4);
        buttonGroup2.add(jRadioButton5);
        JLabel jLabel4 = new JLabel(Resources.get(DIALOG_HORIZONTAL_SPACING_LABEL, "Horizontal spacing"));
        JLabel jLabel5 = new JLabel(Resources.get(DIALOG_VERTICAL_SPACING_LABEL, "Vertical spacing"));
        final JCheckBox jCheckBox = new JCheckBox(" " + Resources.get(DIALOG_AUTOMATIC_SPACING_LABEL, "Automatic horizontal spacing"), this._automaticSingleSpacing);
        final JCheckBox jCheckBox2 = new JCheckBox(" " + Resources.get(DIALOG_SPECIFY_SIZE_LABEL, "Specify layout size") + ": ", this._specifyLayoutSize);
        final JCheckBox jCheckBox3 = new JCheckBox(" " + Resources.get(DIALOG_SIZE_LABEL, "Use objects' sizes"), this._useObjectsSizes);
        final JCheckBox jCheckBox4 = new JCheckBox(" " + Resources.get(DIALOG_FIX_SELECTED_LABEL, "Fix selected objects"), this._fixSelected);
        final JCheckBox jCheckBox5 = new JCheckBox(" " + Resources.get(DIALOG_AUTO_EDGE_LABEL, "Automatic edge length"), this._autoEdgeLength);
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this._edgeLength);
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField2 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, (double)this._repaintPeriod);
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField3 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this._epsilon);
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField4 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this._XSpacing);
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField5 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this._YSpacing);
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField6 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this._layoutSize);
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jCheckBox3, gridBagConstraints);
        jPanel.add(jCheckBox3);
        gridBagLayout.setConstraints(jCheckBox4, gridBagConstraints);
        jPanel.add(jCheckBox4);
        gridBagLayout.setConstraints(jCheckBox5, gridBagConstraints);
        jPanel.add(jCheckBox5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField, gridBagConstraints);
        jPanel.add(jDoubleField);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField2, gridBagConstraints);
        jPanel.add(jDoubleField2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField3, gridBagConstraints);
        jPanel.add(jDoubleField3);
        jPanel2.setLayout(gridBagLayout2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout2.setConstraints(jCheckBox, gridBagConstraints);
        jPanel2.add(jCheckBox);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout2.setConstraints(jLabel4, gridBagConstraints);
        jPanel2.add(jLabel4);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout2.setConstraints(jDoubleField4, gridBagConstraints);
        jPanel2.add(jDoubleField4);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout2.setConstraints(jLabel5, gridBagConstraints);
        jPanel2.add(jLabel5);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout2.setConstraints(jDoubleField5, gridBagConstraints);
        jPanel2.add(jDoubleField5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        jPanel4.setLayout(gridBagLayout3);
        gridBagLayout3.setConstraints(jCheckBox2, gridBagConstraints);
        jPanel4.add(jCheckBox2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout3.setConstraints(jDoubleField6, gridBagConstraints);
        jPanel4.add(jDoubleField6);
        jPanel3.setLayout(gridBagLayout4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout4.setConstraints(jRadioButton, gridBagConstraints);
        jPanel3.add(jRadioButton);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout4.setConstraints(jRadioButton2, gridBagConstraints);
        jPanel3.add(jRadioButton2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout4.setConstraints(jRadioButton3, gridBagConstraints);
        jPanel3.add(jRadioButton3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout4.setConstraints(jRadioButton4, gridBagConstraints);
        jPanel3.add(jRadioButton4);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout4.setConstraints(jRadioButton5, gridBagConstraints);
        jPanel3.add(jRadioButton5);
        jCheckBox5.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jDoubleField.setEnabled(!jCheckBox5.isSelected());
                jCheckBox2.setEnabled(jCheckBox5.isSelected());
                jDoubleField6.setEnabled(jCheckBox5.isSelected() && jCheckBox2.isSelected());
            }
        });
        jCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jDoubleField4.setEnabled(!jCheckBox.isSelected());
            }
        });
        jCheckBox2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jDoubleField6.setEnabled(jCheckBox2.isSelected());
            }
        });
        jDoubleField.setEnabled(!jCheckBox5.isSelected());
        jDoubleField4.setEnabled(!jCheckBox.isSelected());
        jDoubleField6.setEnabled(jCheckBox2.isSelected());
        JPanel jPanel5 = settingsDialog.getMainPanel();
        jPanel5.add(Box.createVerticalGlue());
        jPanel5.add(jPanel4);
        jPanel5.add(Box.createVerticalGlue());
        jPanel5.add(jPanel3);
        jPanel5.add(Box.createVerticalGlue());
        jPanel5.add(jPanel);
        jPanel5.add(Box.createVerticalGlue());
        jPanel5.add(jPanel2);
        jPanel5.add(Box.createVerticalGlue());
        settingsDialog.addApplyListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double d;
                LxSpringLayout.this._useObjectsSizes = jCheckBox3.isSelected();
                LxSpringLayout.this._autoEdgeLength = jCheckBox5.isSelected();
                LxSpringLayout.this._fixSelected = jCheckBox4.isSelected();
                LxSpringLayout.this._automaticSingleSpacing = jCheckBox.isSelected();
                LxSpringLayout.this._specifyLayoutSize = jCheckBox2.isSelected();
                if (jRadioButton4.isSelected()) {
                    LxSpringLayout.this.setVerticalAlignment(3);
                }
                if (jRadioButton5.isSelected()) {
                    LxSpringLayout.this.setVerticalAlignment(2);
                }
                if (jRadioButton2.isSelected()) {
                    LxSpringLayout.this.setHorizontalAlignment(2);
                }
                if (jRadioButton.isSelected()) {
                    LxSpringLayout.this.setHorizontalAlignment(0);
                }
                if (jRadioButton3.isSelected()) {
                    LxSpringLayout.this.setHorizontalAlignment(1);
                }
                if (!LxSpringLayout.this._autoEdgeLength) {
                    d = jDoubleField.getValue();
                    if (Double.isNaN(d)) {
                        return;
                    }
                    LxSpringLayout.this._edgeLength = d;
                }
                if (Double.isNaN(d = jDoubleField2.getValue())) {
                    return;
                }
                LxSpringLayout.this._repaintPeriod = (int)d;
                d = jDoubleField3.getValue();
                if (Double.isNaN(d)) {
                    return;
                }
                LxSpringLayout.this._epsilon = (int)d;
                d = jDoubleField4.getValue();
                if (Double.isNaN(d)) {
                    return;
                }
                LxSpringLayout.this._XSpacing = d;
                d = jDoubleField5.getValue();
                if (Double.isNaN(d)) {
                    return;
                }
                LxSpringLayout.this._YSpacing = d;
                d = jDoubleField6.getValue();
                if (Double.isNaN(d)) {
                    return;
                }
                LxSpringLayout.this._layoutSize = d;
            }
        });
        settingsDialog.pack();
        return settingsDialog;
    }

    public int run() {
        int n = this.run(this.getComponents(), this.getComponentCount(), 0.0, 0.0);
        if (n == 2) {
            int n2;
            Rectangle2D rectangle2D;
            Cloneable cloneable;
            Cloneable cloneable2;
            int n3 = this.getVerticalAlignment();
            this.setVerticalAlignment(3);
            LxAbstractLink[][] lxAbstractLinkArray = null;
            Hashtable<LxComponent, Integer> hashtable = new Hashtable<LxComponent, Integer>();
            LxComponent[] lxComponentArray = this.getComponents();
            LxComponent[] lxComponentArray2 = lxComponentArray[0].getGraph().getComponents();
            int n4 = lxComponentArray.length;
            int n5 = 0;
            while (n5 < n4) {
                hashtable.put(lxComponentArray[n5], new Integer(n5));
                ++n5;
            }
            lxAbstractLinkArray = new LxAbstractLink[n4][n4];
            int n6 = 0;
            while (n6 < lxComponentArray2.length) {
                Object v;
                cloneable2 = lxComponentArray2[n6];
                if (cloneable2 != null && cloneable2 instanceof LxAbstractLink && (v = hashtable.get(((LxAbstractLink)(cloneable = (LxAbstractLink)cloneable2)).getHandle1().getComponent())) != null && (rectangle2D = hashtable.get(((LxAbstractLink)cloneable).getHandle2().getComponent())) != null) {
                    n2 = (Integer)v;
                    int n7 = (Integer)((Object)rectangle2D);
                    lxAbstractLinkArray[n2][n7] = cloneable;
                    lxAbstractLinkArray[n7][n2] = cloneable;
                }
                ++n6;
            }
            cloneable2 = new Vector();
            cloneable = new Vector();
            if (lxAbstractLinkArray != null) {
                int n8 = 0;
                while (n8 < lxAbstractLinkArray.length) {
                    boolean bl = true;
                    n2 = 0;
                    while (n2 < lxAbstractLinkArray.length) {
                        if (lxAbstractLinkArray[n8][n2] != null) {
                            bl = false;
                        }
                        ++n2;
                    }
                    if (bl) {
                        ((Vector)cloneable2).add(lxComponentArray[n8]);
                    } else {
                        ((Vector)cloneable).add(lxComponentArray[n8]);
                    }
                    ++n8;
                }
            }
            rectangle2D = null;
            rectangle2D = ((Vector)cloneable2).size() > 0 ? this.layoutSingleComponents(((Vector)cloneable2).toArray(new LxComponent[1])) : new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            if (((Vector)cloneable).size() > 0) {
                n = this.layoutConnectedComponents((Vector)((Vector)cloneable).clone(), lxAbstractLinkArray, hashtable, rectangle2D);
            }
            this.setVerticalAlignment(n3);
        }
        return n;
    }

    int run(LxComponent[] lxComponentArray, int n, double d, double d2) {
        int n2;
        Spring spring = new Spring();
        if (n == 0) {
            return 0;
        }
        Rectangle2D rectangle2D = this._specifyLayoutSize ? new Rectangle2D.Double(this.getX(), this.getY(), this._layoutSize, this._layoutSize) : this.getBounds2D();
        spring.setRectangle(rectangle2D);
        spring.setAutoEdgeLength(this._autoEdgeLength);
        spring.setEdgeLength(this._edgeLength);
        spring.setWidthIgnored(!this._useObjectsSizes);
        spring.setHeightIgnored(!this._useObjectsSizes);
        spring.setFixSelected(this._fixSelected);
        spring.setRepaintPeriod(this._repaintPeriod);
        spring.setEpsilon(this._epsilon);
        spring.setNodeConstraints(this._nodeConstraints);
        spring.setLinkConstraints(this._linkConstraints);
        String string = spring.compute(lxComponentArray, n);
        boolean bl = false;
        if (this._fixSelected) {
            n2 = 0;
            while (n2 < n) {
                if (lxComponentArray[n2].isSelected()) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < n) {
                LxSpringNodeConstraints lxSpringNodeConstraints = (LxSpringNodeConstraints)this._nodeConstraints.get(lxComponentArray[n2]);
                if (lxSpringNodeConstraints != null && lxSpringNodeConstraints.isFixed()) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        if (bl) {
            n2 = 0;
            while (n2 < n) {
                lxComponentArray[n2].setCenter(spring.centerX[n2], spring.centerY[n2]);
                ++n2;
            }
        } else {
            Cloneable cloneable;
            int n3 = 0;
            while (n3 < n) {
                cloneable = lxComponentArray[n3];
                ((LxComponent)cloneable).setCenter(spring.centerX[n3], spring.centerY[n3]);
                ++n3;
            }
            cloneable = new Rectangle(lxComponentArray[0].getBounds());
            int n4 = 1;
            while (n4 < n) {
                ((Rectangle)cloneable).add(lxComponentArray[n4].getBounds());
                ++n4;
            }
            double d3 = this._horizontalAlignment == 0 ? -d + ((Rectangle)cloneable).getX() - this.getX() : (this._horizontalAlignment == 2 ? -d + ((Rectangle)cloneable).getX() + ((Rectangle)cloneable).getWidth() * 0.5 - this.getCenterX() : -d + ((Rectangle)cloneable).getX() + ((Rectangle)cloneable).getWidth() - this.getX() - this.getWidth());
            double d4 = this._verticalAlignment == 2 ? -d2 + ((Rectangle)cloneable).getY() + ((Rectangle)cloneable).getHeight() * 0.5 - this.getCenterY() : -d2 + ((Rectangle)cloneable).getY() - this.getY();
            int n5 = 0;
            while (n5 < n) {
                LxComponent lxComponent = lxComponentArray[n5];
                lxComponent.setCenter(spring.centerX[n5] - d3, spring.centerY[n5] - d4);
                ++n5;
            }
        }
        if (this.getPropagate()) {
            this.propagate();
        }
        if (string == null) {
            return 0;
        }
        if (string.endsWith("to layout")) {
            return 1;
        }
        if (string.endsWith("non-connected graph!")) {
            return 2;
        }
        return 3;
    }

    private Rectangle2D layoutSingleComponents(LxComponent[] lxComponentArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Vector<Double> vector = new Vector<Double>();
        Vector<Double> vector2 = new Vector<Double>();
        Vector<Integer> vector3 = new Vector<Integer>();
        int n = 0;
        int n2 = 0;
        while (n2 < lxComponentArray.length) {
            if (d + lxComponentArray[n2].getWidth() > this.getWidth()) {
                vector.add(new Double(d3));
                vector2.add(new Double(d));
                vector3.add(new Integer(n));
                d = 0.0;
                d3 = 0.0;
                n = 0;
            }
            d3 = Math.max(d3, lxComponentArray[n2].getHeight());
            d = this._automaticSingleSpacing ? (d += lxComponentArray[n2].getWidth()) : d + lxComponentArray[n2].getWidth() + this._XSpacing;
            ++n;
            ++n2;
        }
        vector.add(new Double(d3));
        vector2.add(new Double(d));
        vector3.add(new Integer(n));
        double d4 = this._XSpacing;
        double d5 = 0.0;
        boolean bl = false;
        d2 = 0.0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < vector3.size()) {
            int n5 = (Integer)vector3.elementAt(n4);
            d3 = (Double)vector.elementAt(n4);
            d5 = (Double)vector2.elementAt(n4);
            if ((n4 < vector3.size() - 1 || vector3.size() == 1) && n5 > 1) {
                d4 = (this.getWidth() - d5) / (double)(n5 - 1);
            }
            d = 0.0;
            int n6 = 0;
            while (n6 < n5) {
                lxComponentArray[n3 + n6].setX(this.getX() + d);
                lxComponentArray[n3 + n6].setCenterY(this.getY() + d2 + d3 / 2.0);
                d = this._automaticSingleSpacing ? d + lxComponentArray[n3 + n6].getWidth() + d4 : d + lxComponentArray[n3 + n6].getWidth() + this._XSpacing;
                ++n6;
            }
            d2 = d2 + d3 + this._YSpacing;
            n3 += n5;
            ++n4;
        }
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), d2);
    }

    private void findConnectedComponents(LxComponent lxComponent, Vector vector, LxAbstractLink[][] lxAbstractLinkArray, Hashtable hashtable, Vector vector2) {
        vector2.add(lxComponent);
        vector.remove(lxComponent);
        Vector<LxAbstractLink> vector3 = new Vector<LxAbstractLink>();
        int n = (Integer)hashtable.get(lxComponent);
        int n2 = 0;
        while (n2 < lxAbstractLinkArray.length) {
            if (lxAbstractLinkArray[n][n2] != null) {
                vector3.add(lxAbstractLinkArray[n][n2]);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector3.size()) {
            LxAbstractLink lxAbstractLink = (LxAbstractLink)vector3.elementAt(n3);
            LxComponent lxComponent2 = lxAbstractLink.getHandle2().getComponent() != lxComponent ? lxAbstractLink.getHandle2().getComponent() : lxAbstractLink.getHandle1().getComponent();
            if (!vector2.contains(lxComponent2)) {
                this.findConnectedComponents(lxComponent2, vector, lxAbstractLinkArray, hashtable, vector2);
            }
            ++n3;
        }
    }

    private int layoutConnectedComponents(Vector vector, LxAbstractLink[][] lxAbstractLinkArray, Hashtable hashtable, Rectangle2D rectangle2D) {
        Object object;
        Vector[] vectorArray;
        int n = 0;
        Vector<Vector[]> vector2 = new Vector<Vector[]>();
        while (vector.size() > 0) {
            vectorArray = new Vector();
            object = (LxComponent)vector.elementAt(0);
            this.findConnectedComponents((LxComponent)object, vector, lxAbstractLinkArray, hashtable, (Vector)vectorArray);
            vector2.add(vectorArray);
        }
        vectorArray = vector2.toArray(new Vector[1]);
        object = new Comparator(){

            public int compare(Object object, Object object2) {
                if (((Vector)object).size() > ((Vector)object2).size()) {
                    return -1;
                }
                if (((Vector)object).size() == ((Vector)object2).size()) {
                    return 0;
                }
                return 1;
            }

            public boolean equals(Object object) {
                return false;
            }
        };
        Arrays.sort(vectorArray, object);
        double d = rectangle2D.getHeight() + 10.0;
        int n2 = 0;
        while (n2 < vectorArray.length) {
            Vector vector3 = vectorArray[n2];
            LxComponent[] lxComponentArray = vector3.toArray(new LxComponent[1]);
            int n3 = this.run(lxComponentArray, lxComponentArray.length, 0.0, d);
            if (n3 != 0) {
                n = n3;
            }
            Rectangle2D rectangle2D2 = lxComponentArray[0].getBounds2D();
            int n4 = 1;
            while (n4 < lxComponentArray.length) {
                rectangle2D2.add(lxComponentArray[n4].getBounds2D());
                ++n4;
            }
            d = rectangle2D2.getY() + rectangle2D2.getHeight() - this.getY() + 10.0;
            ++n2;
        }
        return n;
    }

    public LxSpringNodeConstraints getNodeConstraints(LxComponent lxComponent) {
        if (!this._nodeConstraints.containsKey(lxComponent)) {
            throw new IllegalArgumentException("Component " + lxComponent + " is not managed by this layout");
        }
        return (LxSpringNodeConstraints)this._nodeConstraints.get(lxComponent);
    }

    public void removeNodeConstraints(LxComponent lxComponent) {
        if (!this._nodeConstraints.containsKey(lxComponent)) {
            throw new IllegalArgumentException("Component " + lxComponent + " is not managed by this layout");
        }
        this._nodeConstraints.put(lxComponent, null);
    }

    public void setNodeConstraints(LxComponent lxComponent, LxSpringNodeConstraints lxSpringNodeConstraints) {
        if (!this._nodeConstraints.containsKey(lxComponent)) {
            throw new IllegalArgumentException("Component " + lxComponent + " is not managed by this layout");
        }
        this._nodeConstraints.put(lxComponent, lxSpringNodeConstraints);
    }

    public LxSpringLinkConstraints getLinkConstraints(LxAbstractLink lxAbstractLink) {
        return (LxSpringLinkConstraints)this._linkConstraints.get(lxAbstractLink);
    }

    public void removeLinkConstraints(LxAbstractLink lxAbstractLink) {
        this._linkConstraints.remove(lxAbstractLink);
    }

    public void setLinkConstraints(LxAbstractLink lxAbstractLink, LxSpringLinkConstraints lxSpringLinkConstraints) {
        this._linkConstraints.put(lxAbstractLink, lxSpringLinkConstraints);
    }

    public boolean getAutoEdgeLength() {
        return this._autoEdgeLength;
    }

    public double getEdgeLength() {
        return this._edgeLength;
    }

    public double getEpsilon() {
        return this._epsilon;
    }

    public int getRepaintPeriod() {
        return this._repaintPeriod;
    }

    public boolean getUseObjectsSizes() {
        return this._useObjectsSizes;
    }

    public void setAutoEdgeLength(boolean bl) {
        this._autoEdgeLength = bl;
    }

    public void setEdgeLength(double d) {
        this._edgeLength = d;
    }

    public void setEpsilon(double d) {
        this._epsilon = d;
    }

    public void setRepaintPeriod(int n) {
        this._repaintPeriod = n;
    }

    public void setUseObjectsSizes(boolean bl) {
        this._useObjectsSizes = bl;
    }

    public int getHorizontalAlignment() {
        return this._horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (n <= 2) {
            this._horizontalAlignment = n;
        }
    }

    public int getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (n >= 2) {
            this._verticalAlignment = n;
        }
    }

    public boolean getSpecifyLayoutSize() {
        return this._specifyLayoutSize;
    }

    public void setSpecifyLayoutSize(boolean bl) {
        this._specifyLayoutSize = bl;
    }

    public boolean getAutomaticSingleSpacing() {
        return this._automaticSingleSpacing;
    }

    public void setAutomaticSingleSpacing(boolean bl) {
        this._automaticSingleSpacing = bl;
    }

    public double getLayoutSize() {
        return this._layoutSize;
    }

    public void setLayoutSize(double d) {
        this._layoutSize = d;
    }

    public double getXSpacing() {
        return this._XSpacing;
    }

    public void setXSpacing(double d) {
        this._XSpacing = d;
    }

    public double getYSpacing() {
        return this._YSpacing;
    }

    public void setYSpacing(double d) {
        this._YSpacing = d;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

