/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox.layout;

import com.loox.jloox.LxAbstractLink;
import com.loox.jloox.LxAbstractRectangle;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxLayoutManager;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.layout.Resources;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LxTableLayout
extends LxLayoutManager {
    static final String CLASS_NAME = "LxTableLayout";
    public static final int FILL_X_METHOD = 0;
    public static final int FILL_Y_METHOD = 1;
    public static final int FILL_BEST_METHOD = 2;
    public static final int FILL_BOTH_METHOD = 3;
    public static final int FIXED_SPACING_METHOD = 4;
    public static final int LIST_ORDER = 0;
    public static final int POSITION_ORDER = 1;
    public static final int SELECTED_FIRST_ORDER = 2;
    public static final int ERROR_NOT_ENOUGH_SPACE = 1;
    public static final int ERROR_INTERNAL_ERROR = 2;
    private static final String ACTION = "table-settings-dialog";
    private static final String DIALOG_TITLE = "table-settings-dialogTitle";
    private static final String DIALOG_METHOD_LABEL = "table-settings-dialogMethodLabel";
    private static final String DIALOG_RATIO_LABEL = "table-settings-dialogRatioLabel";
    private static final String DIALOG_FILL_X_LABEL = "table-settings-dialogFillXLabel";
    private static final String DIALOG_FILL_Y_LABEL = "table-settings-dialogFillYLabel";
    private static final String DIALOG_FILL_BEST_LABEL = "table-settings-dialogFillBestLabel";
    private static final String DIALOG_FILL_BOTH_LABEL = "table-settings-dialogFillBothLabel";
    private static final String DIALOG_SIZE_LABEL = "table-settings-dialogSizeLabel";
    private static final String DIALOG_ORDER_LABEL = "table-settings-dialogOrderLabel";
    private static final String DIALOG_LIST_ORDER_LABEL = "table-settings-dialogListOrderLabel";
    private static final String DIALOG_POSITION_ORDER_LABEL = "table-settings-dialogPositionOrderLabel";
    private static final String DIALOG_SELECTED_ORDER_LABEL = "table-settings-dialogSelectedOrderLabel";
    private static final String DIALOG_FIXED_LABEL = "table-settings-dialogFixedLabel";
    private static final String DIALOG_HORI_FIXED_LABEL = "table-settings-dialogHorizontalSpacingLabel";
    private static final String DIALOG_VERT_FIXED_LABEL = "table-settings-dialogVerticalSpacingLabel";
    private int _method = 2;
    private int _order = 2;
    private double _spaceRatio = 1.0;
    private double _fixedXSpacing = 100.0;
    private double _fixedYSpacing = 100.0;
    static /* synthetic */ Class class$com$loox$jloox$layout$LxTableLayout;

    public LxTableLayout() {
    }

    public LxTableLayout(LxContainer lxContainer) {
        super(lxContainer);
    }

    public LxTableLayout(Rectangle2D rectangle2D) {
        super(rectangle2D);
    }

    public LxTableLayout(LxContainer lxContainer, Rectangle2D rectangle2D) {
        super(lxContainer, rectangle2D);
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        this._method = LxSaveUtils.readInt(inputStream);
        this._order = LxSaveUtils.readInt(inputStream);
        this._spaceRatio = LxSaveUtils.readDouble(inputStream);
        this._fixedXSpacing = LxSaveUtils.readDouble(inputStream);
        this._fixedYSpacing = LxSaveUtils.readDouble(inputStream);
        LxSaveUtils.readEndOfPart(inputStream);
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        LxSaveUtils.writeInt(outputStream, this._method);
        LxSaveUtils.writeInt(outputStream, this._order);
        LxSaveUtils.writeDouble(outputStream, this._spaceRatio);
        LxSaveUtils.writeDouble(outputStream, this._fixedXSpacing);
        LxSaveUtils.writeDouble(outputStream, this._fixedYSpacing);
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    public static void createInteractively(LxAbstractView lxAbstractView) {
        LxAbstractRectangle.createInteractively(class$com$loox$jloox$layout$LxTableLayout == null ? (class$com$loox$jloox$layout$LxTableLayout = LxTableLayout.class$("com.loox.jloox.layout.LxTableLayout")) : class$com$loox$jloox$layout$LxTableLayout, lxAbstractView);
    }

    protected LxLayoutManager.SettingsDialog createSettingsDialog() {
        LxLayoutManager.SettingsDialog settingsDialog = super.createSettingsDialog();
        settingsDialog.setTitle(Resources.get(DIALOG_TITLE, "Table layout settings"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(LxLayoutManager.SettingsDialog.stdHalfBorder);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(Resources.get(DIALOG_HORI_FIXED_LABEL, "Horizontal fixed spacing"));
        JLabel jLabel2 = new JLabel(Resources.get(DIALOG_VERT_FIXED_LABEL, "Vertical fixed spacing"));
        JLabel jLabel3 = new JLabel(Resources.get(DIALOG_RATIO_LABEL, "Fill ratio"));
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this._fixedXSpacing);
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField2 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this._fixedYSpacing);
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField3 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this._spaceRatio);
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(LxLayoutManager.SettingsDialog.stdHalfBorder);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = LxLayoutManager.SettingsDialog.stdInsets;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField, gridBagConstraints);
        jPanel.add(jDoubleField);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField2, gridBagConstraints);
        jPanel.add(jDoubleField2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField3, gridBagConstraints);
        jPanel.add(jDoubleField3);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel2.setBorder(LxLayoutManager.SettingsDialog.stdBorder);
        jPanel2.add("North", new JLabel(Resources.get(DIALOG_ORDER_LABEL, "Layout order")));
        jPanel2.add("Center", jPanel3);
        jPanel2.add("West", Box.createHorizontalStrut(20));
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton jRadioButton = new JRadioButton(Resources.get(DIALOG_LIST_ORDER_LABEL, "List Order"), this._order == 0);
        final JRadioButton jRadioButton2 = new JRadioButton(Resources.get(DIALOG_POSITION_ORDER_LABEL, "Closest position"), this._order == 1);
        JRadioButton jRadioButton3 = new JRadioButton(Resources.get(DIALOG_SELECTED_ORDER_LABEL, "Closest position, selected first"), this._order == 2);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jPanel3.add(jRadioButton);
        jPanel3.add(jRadioButton2);
        jPanel3.add(jRadioButton3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel4.setBorder(LxLayoutManager.SettingsDialog.stdBorder);
        jPanel4.add("North", new JLabel(Resources.get(DIALOG_METHOD_LABEL, "Layout method")));
        jPanel4.add("Center", jPanel5);
        jPanel4.add("West", Box.createHorizontalStrut(20));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        final JRadioButton jRadioButton4 = new JRadioButton(Resources.get(DIALOG_FILL_X_LABEL, "Fill horizontally"), this._method == 0);
        final JRadioButton jRadioButton5 = new JRadioButton(Resources.get(DIALOG_FILL_Y_LABEL, "Fill vertically"), this._method == 1);
        final JRadioButton jRadioButton6 = new JRadioButton(Resources.get(DIALOG_FILL_BEST_LABEL, "Fill best direction"), this._method == 2);
        final JRadioButton jRadioButton7 = new JRadioButton(Resources.get(DIALOG_FILL_BOTH_LABEL, "Fill both"), this._method == 3);
        final JRadioButton jRadioButton8 = new JRadioButton(Resources.get(DIALOG_FIXED_LABEL, "Fixed spacing"), this._method == 4);
        buttonGroup2.add(jRadioButton4);
        buttonGroup2.add(jRadioButton5);
        buttonGroup2.add(jRadioButton6);
        buttonGroup2.add(jRadioButton7);
        buttonGroup2.add(jRadioButton8);
        jPanel5.add(jRadioButton4);
        jPanel5.add(jRadioButton5);
        jPanel5.add(jRadioButton6);
        jPanel5.add(jRadioButton7);
        jPanel5.add(jRadioButton8);
        jRadioButton8.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = jRadioButton8.isSelected();
                jDoubleField.setEnabled(bl);
                jDoubleField2.setEnabled(bl);
                jDoubleField3.setEnabled(!bl);
            }
        });
        boolean bl = jRadioButton8.isSelected();
        jDoubleField.setEnabled(bl);
        jDoubleField2.setEnabled(bl);
        jDoubleField3.setEnabled(!bl);
        JPanel jPanel6 = settingsDialog.getMainPanel();
        jPanel6.add(Box.createVerticalGlue());
        jPanel6.add(jPanel2);
        jPanel6.add(Box.createVerticalGlue());
        jPanel6.add(Box.createVerticalStrut(6));
        jPanel6.add(jPanel4);
        jPanel6.add(Box.createVerticalGlue());
        jPanel6.add(Box.createVerticalStrut(6));
        jPanel6.add(jPanel);
        jPanel6.add(Box.createVerticalGlue());
        settingsDialog.addApplyListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButton.isSelected()) {
                    LxTableLayout.this._order = 0;
                } else if (jRadioButton2.isSelected()) {
                    LxTableLayout.this._order = 1;
                } else {
                    LxTableLayout.this._order = 2;
                }
                if (jRadioButton4.isSelected()) {
                    LxTableLayout.this._method = 0;
                } else if (jRadioButton5.isSelected()) {
                    LxTableLayout.this._method = 1;
                } else if (jRadioButton6.isSelected()) {
                    LxTableLayout.this._method = 2;
                } else if (jRadioButton7.isSelected()) {
                    LxTableLayout.this._method = 3;
                } else {
                    LxTableLayout.this._method = 4;
                }
                if (LxTableLayout.this._method == 4) {
                    double d = jDoubleField.getValue();
                    if (Double.isNaN(d)) {
                        return;
                    }
                    LxTableLayout.this._fixedXSpacing = d;
                    d = jDoubleField2.getValue();
                    if (Double.isNaN(d)) {
                        return;
                    }
                    LxTableLayout.this._fixedYSpacing = d;
                } else {
                    double d = jDoubleField3.getValue();
                    if (Double.isNaN(d)) {
                        return;
                    }
                    LxTableLayout.this._spaceRatio = d;
                }
            }
        });
        settingsDialog.pack();
        return settingsDialog;
    }

    public int run() {
        double d;
        double d2;
        int n;
        int n2;
        int n3;
        LxComponent[] lxComponentArray = this.getComponents();
        int n4 = n3 = this.getComponentCount();
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        if (this._method != 4) {
            double d5;
            int n5 = (int)Math.ceil((double)n3 * this._spaceRatio);
            n2 = (int)Math.ceil(Math.sqrt((double)n5 * d3 / d4));
            while (n2 * (int)((double)n2 * d4 / d3) < n5 && n2 <= n5) {
                ++n2;
            }
            n = (int)Math.ceil(Math.sqrt((double)n5 * d4 / d3));
            while (n * (int)((double)n * d3 / d4) < n5 && n <= n5) {
                ++n;
            }
            if (n2 > n5 || n > n5) {
                return 2;
            }
            if (this._method == 0) {
                d5 = d3 / (double)n2;
                n = (int)((double)n2 * d4 / d3);
            } else if (this._method == 1) {
                d5 = d4 / (double)n;
                n2 = (int)((double)n * d3 / d4);
            } else if (d3 / (double)n2 > d4 / (double)n) {
                d5 = d3 / (double)n2;
                n = (int)((double)n2 * d4 / d3);
            } else {
                d5 = d4 / (double)n;
                n2 = (int)((double)n * d3 / d4);
            }
            if (this._method == 3) {
                d2 = d3 / (double)n2;
                d = d4 / (double)n;
            } else {
                d2 = d5;
                d = d5;
            }
        } else {
            d2 = this._fixedXSpacing;
            d = this._fixedYSpacing;
            n2 = (int)(d3 / d2);
            n = (int)(d4 / d);
        }
        if (n2 * n < n3) {
            n4 = n2 * n;
        }
        double d6 = this.getX() + 0.5 * d2;
        double d7 = this.getY() + 0.5 * d;
        if (this._order == 0) {
            int n6 = 0;
            double d8 = d7;
            int n7 = 0;
            while (n7 < n && n6 < n4) {
                double d9 = d6;
                int n8 = 0;
                while (n8 < n2 && n6 < n4) {
                    lxComponentArray[n6].setCenterX(d9);
                    lxComponentArray[n6].setCenterY(d8);
                    d9 += d2;
                    ++n8;
                    ++n6;
                }
                d8 += d;
                ++n7;
            }
        } else {
            int n9;
            boolean[][] blArray = new boolean[n2][n];
            int n10 = 0;
            if (this._order == 2) {
                n9 = 0;
                while (n9 < n3) {
                    if (lxComponentArray[n9].isSelected()) {
                        LxComponent lxComponent = lxComponentArray[n10];
                        lxComponentArray[n10] = lxComponentArray[n9];
                        lxComponentArray[n9] = lxComponent;
                        ++n10;
                    }
                    ++n9;
                }
            }
            n9 = 0;
            while (n9 < n4) {
                int n11 = -1;
                int n12 = -1;
                int n13 = -1;
                double d10 = Double.MAX_VALUE;
                int n14 = n3;
                if (this._order == 2 && n9 < n10) {
                    n14 = n10;
                }
                int n15 = n9;
                while (n15 < n14) {
                    double d11 = lxComponentArray[n15].getCenterX();
                    double d12 = lxComponentArray[n15].getCenterY();
                    double d13 = d7;
                    int n16 = 0;
                    while (n16 < n) {
                        double d14 = d6;
                        int n17 = 0;
                        while (n17 < n2) {
                            double d15;
                            if (!blArray[n17][n16] && (d15 = (d11 - d14) * (d11 - d14) + (d12 - d13) * (d12 - d13)) < d10) {
                                n11 = n15;
                                n12 = n17;
                                n13 = n16;
                                d10 = d15;
                            }
                            d14 += d2;
                            ++n17;
                        }
                        d13 += d;
                        ++n16;
                    }
                    ++n15;
                }
                blArray[n12][n13] = true;
                lxComponentArray[n11].setCenterX(d6 + (double)n12 * d2);
                lxComponentArray[n11].setCenterY(d7 + (double)n13 * d);
                LxComponent lxComponent = lxComponentArray[n11];
                lxComponentArray[n11] = lxComponentArray[n9];
                lxComponentArray[n9] = lxComponent;
                ++n9;
            }
        }
        if (this.getPropagate()) {
            this.propagate();
        }
        if (n4 < n3) {
            return 1;
        }
        return 0;
    }

    public void add(LxComponent lxComponent) {
        if (lxComponent instanceof LxAbstractLink) {
            throw new IllegalArgumentException("Links cannot be added to a table layout.");
        }
        super.add(lxComponent);
    }

    public void add(LxComponent lxComponent, int n) {
        if (lxComponent instanceof LxAbstractLink) {
            throw new IllegalArgumentException("Links cannot be added to a table layout.");
        }
        super.add(lxComponent, n);
    }

    public double getFixedXSpacing() {
        return this._fixedXSpacing;
    }

    public double getFixedYSpacing() {
        return this._fixedYSpacing;
    }

    public int getMethod() {
        return this._method;
    }

    public int getOrder() {
        return this._order;
    }

    public double getSpaceRatio() {
        return this._spaceRatio;
    }

    public void setFixedXSpacing(double d) {
        this._fixedXSpacing = d;
    }

    public void setFixedYSpacing(double d) {
        this._fixedYSpacing = d;
    }

    public void setMethod(int n) {
        this._method = n;
    }

    public void setOrder(int n) {
        this._order = n;
    }

    public double setSpaceRatio(double d) {
        return this._spaceRatio;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

