/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox.layout.hierarchical;

import com.loox.jloox.LxComponent;
import com.loox.jloox.layout.hierarchical.DDimension;
import com.loox.jloox.layout.hierarchical.DDimension3;
import com.loox.jloox.layout.hierarchical.DPoint;
import com.loox.jloox.layout.hierarchical.DPoint3;
import com.loox.jloox.layout.hierarchical.Set;
import java.util.Hashtable;

public class Node
implements Cloneable {
    private Set adjacencies_;
    protected DPoint3 oldpos_ = null;
    protected DPoint3 grouppos_ = null;
    protected DDimension3 oldbox_ = null;
    protected DDimension3 groupbox_ = null;
    protected boolean isDummy_;
    protected int index_;
    private boolean selected_;
    protected int id_;
    protected boolean haveId_;
    protected int groupNodeId_;
    protected Node groupNode_;
    protected boolean isGroup_ = false;
    protected boolean groupActive_ = false;
    protected boolean inActiveGroup_ = false;
    private LxComponent lxcomponent_ = null;
    public double x_ = 0.0;
    public double y_ = 0.0;
    public double width_ = 0.0;
    public double height_ = 0.0;
    public double z_ = 0.0;
    public double depth_ = 0.0;
    public Object data;
    public static String[] defaultDataTypes_ = new String[]{"Data1", "Data2"};
    public Hashtable data_;
    public static Node defaults = new Node(1);

    public int searchNextChild(int n) {
        return this.adjacencies_.searchNext(n);
    }

    private Node(int n) {
        this.setLocation(0.0, 0.0);
        this.setSize(1.0, 1.0);
        this.isDummy_ = false;
        this.selected_ = false;
        this.haveId_ = false;
        this.isGroup_ = false;
        this.inActiveGroup_ = false;
        this.data_ = new Hashtable((int)((double)(defaultDataTypes_.length + 1) * 1.5));
        int n2 = 0;
        while (n2 < defaultDataTypes_.length) {
            this.data_.put(defaultDataTypes_[n2], "");
            ++n2;
        }
    }

    public Node() {
        this.index_ = -1;
        this.copyAttributes(defaults);
        this.adjacencies_ = new Set();
    }

    public Node(boolean bl) {
        this.index_ = -1;
        this.copyAttributes(defaults);
        this.adjacencies_ = new Set();
        this.isDummy_ = bl;
        if (bl) {
            this.setSize(0.0, 0.0);
        }
    }

    public void setId(int n) {
        this.haveId_ = true;
        this.id_ = n;
    }

    public Integer getIdObject() {
        if (!this.haveId_) {
            return null;
        }
        return new Integer(this.id_);
    }

    public int getId() {
        return this.id_;
    }

    public void setPosition(double d, double d2) {
        this.setLocation(d, d2);
    }

    public void setPosition(DPoint dPoint) {
        this.setLocation(dPoint.x, dPoint.y);
    }

    public void setPosition(double d, double d2, double d3) {
        this.setLocation(d, d2);
    }

    public void setPosition(DPoint3 dPoint3) {
        this.setLocation(dPoint3.x, dPoint3.y);
    }

    public DPoint getPosition() {
        DPoint dPoint = new DPoint(this.getX(), this.getY());
        return dPoint;
    }

    public DPoint3 getPosition3() {
        if (this.inActiveGroup_) {
            return this.groupNode_.getPosition3();
        }
        DPoint3 dPoint3 = new DPoint3(this.getX(), this.getY(), 0.0);
        return dPoint3;
    }

    public void setBoundingBox(double d, double d2) {
        this.setSize(d, d2);
    }

    public void setBoundingBox(DDimension dDimension) {
        this.setSize(dDimension.width, dDimension.height);
    }

    public DDimension getBoundingBox() {
        DDimension dDimension = new DDimension(this.getWidth(), this.getHeight());
        return dDimension;
    }

    public void setBoundingBox(double d, double d2, double d3) {
        this.setSize(d, d2);
    }

    public void setBoundingBox(DDimension3 dDimension3) {
        this.setSize(dDimension3.width, dDimension3.height);
    }

    public DDimension3 getBoundingBox3() {
        DDimension3 dDimension3 = new DDimension3(this.getWidth(), this.getHeight(), 0.0);
        return dDimension3;
    }

    public void setSelected(boolean bl) {
        this.selected_ = bl;
    }

    public boolean getSelected() {
        return this.selected_;
    }

    public void setChild(int n) {
        this.adjacencies_.includeElement(n);
    }

    public void clearChild(int n) {
        this.adjacencies_.removeElement(n);
    }

    public Set getChildren() {
        return (Set)this.adjacencies_.clone();
    }

    public int firstChild() {
        return this.adjacencies_.first();
    }

    public int nextChild() {
        return this.adjacencies_.next();
    }

    public int getIndex() {
        return this.index_;
    }

    public boolean hasChild(int n) {
        return this.adjacencies_.isElement(n);
    }

    public boolean hasChild(Node node) {
        return this.adjacencies_.isElement(node.index_);
    }

    public int numberOfChildren() {
        return this.adjacencies_.numberOfElements();
    }

    public void copyAttributes(Node node) {
        this.setLocation(node.getX(), node.getY());
        this.setSize(node.getWidth(), node.getHeight());
        this.isDummy_ = node.isDummy_;
        this.selected_ = node.selected_;
        this.data_ = (Hashtable)node.data_.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        Node node = (Node)super.clone();
        node.adjacencies_ = (Set)this.adjacencies_.clone();
        node.data_ = (Hashtable)this.data_.clone();
        return node;
    }

    public DPoint3 intersectWithLineTo(DPoint3 dPoint3, boolean bl, int n) {
        double d;
        if (this.inActiveGroup_) {
            return this.groupNode_.intersectWithLineTo(dPoint3, bl, n);
        }
        if (this.isDummy_) {
            return new DPoint3(this.getX(), this.getY(), 0.0);
        }
        if (this.getWidth() == 0.0 || this.getHeight() == 0.0) {
            return new DPoint3(this.getX(), this.getY(), 0.0);
        }
        double d2 = dPoint3.y - this.getY();
        double d3 = dPoint3.x - this.getX();
        if (d3 * d3 / (this.getWidth() * this.getWidth()) + d2 * d2 / (this.getHeight() * this.getHeight()) <= 0.25) {
            return new DPoint3(this.getX(), this.getY(), 0.0);
        }
        if (d3 == 0.0) {
            if (d2 > 0.0) {
                return new DPoint3(this.getX(), this.getY() + this.getHeight() / 2.0, 0.0);
            }
            return new DPoint3(this.getX(), this.getY() - this.getHeight() / 2.0, 0.0);
        }
        double d4 = d3 > 0.0 ? this.getX() + this.getWidth() / 2.0 : this.getX() - this.getWidth() / 2.0;
        double d5 = dPoint3.y - (dPoint3.x - d4) * (d = d2 / d3);
        if (Math.abs(d5 - this.getY()) <= this.getHeight() / 2.0) {
            return new DPoint3(d4, d5, 0.0);
        }
        d5 = d2 > 0.0 ? this.getY() + this.getHeight() / 2.0 : this.getY() - this.getHeight() / 2.0;
        d4 = dPoint3.x - (dPoint3.y - d5) / d;
        return new DPoint3(d4, d5, 0.0);
    }

    public void saveState() {
        this.oldpos_ = new DPoint3(this.getX(), this.getY(), 0.0);
        this.oldbox_ = new DDimension3(this.getWidth(), this.getHeight(), 0.0);
    }

    public void scale(double d, double d2, double d3) {
        if (this.oldbox_ == null) {
            return;
        }
        this.setSize(d * this.oldbox_.width, d2 * this.oldbox_.height);
    }

    public boolean inGroup() {
        return this.groupNode_ != null;
    }

    public boolean isGroup() {
        return this.isGroup_;
    }

    public boolean groupActive() {
        return this.groupActive_;
    }

    public boolean isVisible() {
        if (this.inActiveGroup_) {
            return false;
        }
        return !this.isGroup_ || this.groupActive_;
    }

    public Node getVisibleGroupRoot() {
        Node node = this;
        while (node.inActiveGroup_) {
            node = node.groupNode_;
        }
        return node;
    }

    public void setGroup() {
        this.isGroup_ = true;
    }

    public LxComponent getLxComponent() {
        return this.lxcomponent_;
    }

    public double getX() {
        return this.x_;
    }

    public double getY() {
        return this.y_;
    }

    public double getWidth() {
        return this.width_;
    }

    public double getHeight() {
        return this.height_;
    }

    public void setLxComponent(LxComponent lxComponent) {
        this.lxcomponent_ = lxComponent;
    }

    public void initSize(int n) {
        if (this.lxcomponent_ != null) {
            if (n == 0 || n == 1) {
                this.x_ = this.lxcomponent_.getCenterX();
                this.y_ = this.lxcomponent_.getCenterY();
            } else {
                this.x_ = this.lxcomponent_.getCenterY();
                this.y_ = this.lxcomponent_.getCenterX();
            }
            if (n == 0) {
                this.y_ *= -1.0;
            }
            if (n == 3) {
                this.y_ *= -1.0;
            }
            if (n == 2) {
                this.x_ *= -1.0;
                this.y_ *= -1.0;
            }
            if (n == 0 || n == 1) {
                this.width_ = this.lxcomponent_.getWidth();
                this.height_ = this.lxcomponent_.getHeight();
            } else {
                this.height_ = this.lxcomponent_.getWidth();
                this.width_ = this.lxcomponent_.getHeight();
            }
        }
    }

    public void setLocation(double d, double d2) {
        this.x_ = d;
        this.y_ = d2;
    }

    public void setSize(double d, double d2) {
        this.width_ = d;
        this.height_ = d2;
    }
}

