/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.OutputStream;
import java.util.zip.Deflater;
import jclass.chart.Encode;
import jclass.chart.EncoderException;
import jclass.chart.PngEncoderException;

public class EncodePng
extends Encode {
    long[] crc_table = null;

    public EncodePng() {
    }

    public EncodePng(Image image, OutputStream outputStream) throws EncoderException {
        super(image, outputStream);
    }

    public int compress(byte[] byArray, byte[] byArray2, int n, int n2) throws PngEncoderException {
        Deflater deflater = new Deflater(-1);
        byte[] byArray3 = new byte[byArray2.length + n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray3[n3 * (n + 1)] = Encode.byteFromInt(0);
            int n4 = 0;
            while (n4 < n) {
                byArray3[n3 * (n + 1) + n4 + 1] = byArray2[n3 * n + n4];
                ++n4;
            }
            ++n3;
        }
        deflater.setInput(byArray3, 0, byArray3.length);
        deflater.finish();
        deflater.deflate(byArray);
        if (!deflater.finished()) {
            EncodePng.error("PNG encoding error: Deflater could not compress image data.");
        }
        return deflater.getTotalOut();
    }

    public int compress(byte[] byArray, int[] nArray, ColorModel colorModel, int n, int n2) throws PngEncoderException {
        Deflater deflater = new Deflater(-1);
        byte[] byArray2 = new byte[nArray.length * 3 + n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3 * (n * 3 + 1)] = Encode.byteFromInt(0);
            int n4 = 0;
            while (n4 < n * 3) {
                byArray2[n3 * (n * 3 + 1) + n4 + 1] = (byte)colorModel.getRed(nArray[n3 * n + (int)Math.floor(n4 / 3)]);
                byArray2[n3 * (n * 3 + 1) + n4 + 2] = (byte)colorModel.getGreen(nArray[n3 * n + (int)Math.floor(n4 / 3)]);
                byArray2[n3 * (n * 3 + 1) + n4 + 3] = (byte)colorModel.getBlue(nArray[n3 * n + (int)Math.floor(n4 / 3)]);
                n4 += 3;
            }
            ++n3;
        }
        deflater.setInput(byArray2, 0, byArray2.length);
        deflater.finish();
        deflater.deflate(byArray);
        if (!deflater.finished()) {
            EncodePng.error("PNG encoding error: Deflater could not compress image data.");
        }
        byte[] byArray3 = Encode.bytesFromLong(deflater.getAdler());
        return deflater.getTotalOut();
    }

    long end_crc(long l) {
        return l ^ 0xFFFFFFFFL;
    }

    static void error(String string) throws PngEncoderException {
        throw new PngEncoderException(string);
    }

    void make_crc_table() {
        this.crc_table = new long[256];
        int n = 0;
        while (n < 256) {
            long l = n;
            int n2 = 0;
            while (n2 < 8) {
                l = (l & 1L) != 0L ? 0xEDB88320L ^ l >> 1 : (l >>= 1);
                ++n2;
            }
            this.crc_table[n] = l;
            ++n;
        }
    }

    public void saveImage() throws PngEncoderException {
        int n;
        byte by;
        byte by2;
        if (this.img == null) {
            EncodePng.error("PNG encoding error: Image is NULL.");
        }
        PixelGrabber pixelGrabber = new PixelGrabber(this.img, 0, 0, this.img.getWidth(null), this.img.getHeight(null), false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            EncodePng.error("PNG encoding error: Unable to retrieve pixels from image.");
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n2 = colorModel.getPixelSize();
        int n3 = (int)Math.pow(2.0, n2);
        if (n2 < 8 || n2 > 32) {
            EncodePng.error("PNG encoding error: PNG method needs color mode to be between 8 and 32 bits.");
        }
        int[] nArray = null;
        byte[] byArray = null;
        if (n2 > 8) {
            nArray = (int[])pixelGrabber.getPixels();
        } else {
            byArray = (byte[])pixelGrabber.getPixels();
        }
        try {
            this.ofile.write(Encode.byteFromInt(137));
            this.ofile.write(Encode.byteFromInt(80));
            this.ofile.write(Encode.byteFromInt(78));
            this.ofile.write(Encode.byteFromInt(71));
            this.ofile.write(Encode.byteFromInt(13));
            this.ofile.write(Encode.byteFromInt(10));
            this.ofile.write(Encode.byteFromInt(26));
            this.ofile.write(Encode.byteFromInt(10));
        }
        catch (Exception exception) {
            EncodePng.error("Error writing to file.");
        }
        long l = this.start_crc();
        try {
            this.ofile.write(Encode.bytesFromLong(13L));
            this.ofile.write(Encode.byteFromChar('I'));
            this.ofile.write(Encode.byteFromChar('H'));
            this.ofile.write(Encode.byteFromChar('D'));
            this.ofile.write(Encode.byteFromChar('R'));
        }
        catch (Exception exception) {
            EncodePng.error("Error writing to file.");
        }
        l = this.update_crc(l, Encode.byteFromChar('I'));
        l = this.update_crc(l, Encode.byteFromChar('H'));
        l = this.update_crc(l, Encode.byteFromChar('D'));
        l = this.update_crc(l, Encode.byteFromChar('R'));
        int n4 = this.img.getWidth(null);
        int n5 = this.img.getHeight(null);
        l = this.update_crc(l, Encode.bytesFromLong(n4));
        l = this.update_crc(l, Encode.bytesFromLong(n5));
        l = this.update_crc(l, Encode.byteFromInt(8));
        l = n2 > 8 ? this.update_crc(l, Encode.byteFromInt(2)) : this.update_crc(l, Encode.byteFromInt(3));
        l = this.update_crc(l, Encode.byteFromInt(0));
        l = this.update_crc(l, Encode.byteFromInt(0));
        l = this.update_crc(l, Encode.byteFromInt(0));
        try {
            this.ofile.write(Encode.bytesFromLong(n4));
            this.ofile.write(Encode.bytesFromLong(n5));
            this.ofile.write(Encode.byteFromInt(8));
            if (n2 > 8) {
                this.ofile.write(Encode.byteFromInt(2));
            } else {
                this.ofile.write(Encode.byteFromInt(3));
            }
            this.ofile.write(Encode.byteFromInt(0));
            this.ofile.write(Encode.byteFromInt(0));
            this.ofile.write(Encode.byteFromInt(0));
            this.ofile.write(Encode.bytesFromLong(this.end_crc(l)));
        }
        catch (Exception exception) {
            EncodePng.error("Error writing to file.");
        }
        if (n2 == 8) {
            l = this.start_crc();
            try {
                this.ofile.write(Encode.bytesFromLong(n3 * 3));
                this.ofile.write(Encode.byteFromChar('P'));
                this.ofile.write(Encode.byteFromChar('L'));
                this.ofile.write(Encode.byteFromChar('T'));
                this.ofile.write(Encode.byteFromChar('E'));
            }
            catch (Exception exception) {
                EncodePng.error("Error writing to file.");
            }
            l = this.update_crc(l, Encode.byteFromChar('P'));
            l = this.update_crc(l, Encode.byteFromChar('L'));
            l = this.update_crc(l, Encode.byteFromChar('T'));
            l = this.update_crc(l, Encode.byteFromChar('E'));
            try {
                int n6 = 0;
                while (n6 < n3) {
                    by2 = Encode.byteFromInt(colorModel.getRed(n6));
                    by = Encode.byteFromInt(colorModel.getGreen(n6));
                    n = Encode.byteFromInt(colorModel.getBlue(n6));
                    l = this.update_crc(l, by2);
                    l = this.update_crc(l, by);
                    l = this.update_crc(l, (byte)n);
                    this.ofile.write(by2);
                    this.ofile.write(by);
                    this.ofile.write(n);
                    ++n6;
                }
                this.ofile.write(Encode.bytesFromLong(this.end_crc(l)));
            }
            catch (Exception exception) {
                EncodePng.error("Error writing to file.");
            }
        }
        byte[] byArray2 = null;
        byArray2 = n2 == 8 ? new byte[byArray.length + n5] : new byte[nArray.length * 3 + n5];
        by2 = 0;
        while (by2 < byArray2.length) {
            byArray2[by2] = 0;
            ++by2;
        }
        by = 0;
        by = n2 > 8 ? this.compress(byArray2, nArray, colorModel, n4, n5) : this.compress(byArray2, byArray, n4, n5);
        l = this.start_crc();
        try {
            this.ofile.write(Encode.bytesFromLong(by));
            this.ofile.write(Encode.byteFromChar('I'));
            this.ofile.write(Encode.byteFromChar('D'));
            this.ofile.write(Encode.byteFromChar('A'));
            this.ofile.write(Encode.byteFromChar('T'));
        }
        catch (Exception exception) {
            EncodePng.error("Error writing to file.");
        }
        l = this.update_crc(l, Encode.byteFromChar('I'));
        l = this.update_crc(l, Encode.byteFromChar('D'));
        l = this.update_crc(l, Encode.byteFromChar('A'));
        l = this.update_crc(l, Encode.byteFromChar('T'));
        try {
            this.ofile.write(byArray2, 0, by);
        }
        catch (Exception exception) {
            EncodePng.error("Error writing to file.");
        }
        n = 0;
        while (n < by) {
            l = this.update_crc(l, byArray2[n]);
            ++n;
        }
        try {
            this.ofile.write(Encode.bytesFromLong(this.end_crc(l)));
        }
        catch (Exception exception) {
            EncodePng.error("Error writing to file.");
        }
        l = this.start_crc();
        try {
            this.ofile.write(Encode.bytesFromLong(0L));
            this.ofile.write(Encode.byteFromChar('I'));
            this.ofile.write(Encode.byteFromChar('E'));
            this.ofile.write(Encode.byteFromChar('N'));
            this.ofile.write(Encode.byteFromChar('D'));
        }
        catch (Exception exception) {
            EncodePng.error("Error writing to file.");
        }
        l = this.update_crc(l, Encode.byteFromChar('I'));
        l = this.update_crc(l, Encode.byteFromChar('E'));
        l = this.update_crc(l, Encode.byteFromChar('N'));
        l = this.update_crc(l, Encode.byteFromChar('D'));
        try {
            this.ofile.write(Encode.bytesFromLong(this.end_crc(l)));
        }
        catch (Exception exception) {
            EncodePng.error("Error writing to file.");
        }
        try {
            this.ofile.close();
        }
        catch (Exception exception) {
            EncodePng.error("Error closing file.");
        }
    }

    long start_crc() {
        return 0xFFFFFFFFL;
    }

    long update_crc(long l, byte by) {
        if (this.crc_table == null) {
            this.make_crc_table();
        }
        return this.crc_table[(int)((l ^ (long)by) & 0xFFL)] ^ l >> 8;
    }

    long update_crc(long l, byte[] byArray) {
        long l2 = l;
        int n = 0;
        while (n < byArray.length) {
            l2 = this.update_crc(l2, byArray[n]);
            ++n;
        }
        return l2;
    }
}

