/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import jclass.chart.AnnotationHandler;
import jclass.chart.AxisHandler;
import jclass.chart.ChartDataView;
import jclass.chart.ChartRegion;
import jclass.chart.ChartText;
import jclass.chart.DerivedDouble;
import jclass.chart.DerivedInt;
import jclass.chart.DerivedString;
import jclass.chart.ErrorDialog;
import jclass.chart.Extents;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCAxisFormula;
import jclass.chart.JCAxisTitle;
import jclass.chart.JCChart;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartConverter;
import jclass.chart.JCChartDateFormat;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLabelGenerator;
import jclass.chart.JCLineStyle;
import jclass.chart.JCValueLabel;
import jclass.chart.MinMax;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

public class JCAxis
extends ChartRegion
implements Serializable,
HTMLHandler {
    int gap = 3;
    protected JCAxisTitle title = null;
    protected DerivedDouble min = new DerivedDouble(0.0, true);
    protected DerivedDouble max = new DerivedDouble(0.0, true);
    protected DerivedDouble origin = new DerivedDouble(0.0, true);
    protected DerivedInt originPlacement = new DerivedInt(0, true);
    protected DerivedInt placement = new DerivedInt(0, true);
    protected JCChartStyle gridStyle;
    protected DerivedDouble gridSpacing = new DerivedDouble(0.0, true);
    protected boolean gridIsShowing = false;
    protected JCAxisFormula formula = null;
    protected boolean isEditable = true;
    protected boolean isLogarithmic = false;
    protected boolean isReversed = false;
    protected boolean isVertical = false;
    protected int annotationRotation = 0;
    protected JCAxis placementAxis = null;
    protected double placementLocation = 0.0;
    protected JCLabelGenerator labelGenerator = null;
    private boolean axisDrawn = false;
    protected boolean isDecimalPadded = true;
    int savedXAxisAnnotationMethod;
    protected long timeUnit = 1000L;
    protected Date timeBase = null;
    protected DerivedString timeFormat = new DerivedString("", true);
    protected DerivedString timeFormat11 = new DerivedString("", true);
    protected Polygon sideplane;
    protected int tickLength = 4;
    JCChartArea chartArea = null;
    double step = 1.0;
    private static int axisNum = 0;
    private boolean hasBar = false;
    boolean frontPlane = true;
    public static final long SECONDS = 1000L;
    public static final long MINUTES = 60000L;
    public static final long HOURS = 3600000L;
    public static final long DAYS = 86400000L;
    public static final long WEEKS = 604800000L;
    public static final long MONTHS = 2678400000L;
    public static final long YEARS = 31536000000L;
    MinMax dataLimits = null;
    DerivedInt precision = new DerivedInt(1, true);
    static final int MAX_PRECISION = 14;
    protected int maximumPrecision = 14;
    DerivedDouble numSpacing = new DerivedDouble(0.0, true);
    int logIncrement = 1;
    DerivedDouble tickSpacing = new DerivedDouble(0.0, true);
    public static final int AUTOMATIC = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int ZERO = 3;
    public static final int VALUE_ANCHORED = 4;
    public static final int ORIGIN = 5;
    public static final int VALUE = 0;
    public static final int VALUE_LABELS = 1;
    public static final int TIME_LABELS = 2;
    public static final int POINT_LABELS = 3;
    int annotationMethod = 0;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_270 = 3;
    public static final String[] placement_strings = new String[]{"Automatic", "Origin", "Min", "Max", "Value_Anchored"};
    public static final int[] placement_values;
    public static final String[] annRotation_strings;
    public static final int[] annRotation_values;
    public static final String[] annotationMethod_strings;
    public static final int[] annotationMethod_values;
    public static final String[] timeUnit_strings;
    public static final long[] timeUnit_values;
    public static final String[] originPlacement_strings;
    public static final int[] originPlacement_values;
    transient int chartType;
    transient boolean isPrimary;
    transient JCAxis otherAxis;
    private transient AxisHandler axisHandler = null;
    protected AnnotationHandler annoHandler = new AnnotationHandler(this);
    static final int TROUGH_TOP = 1;
    static final int TROUGH_BOTTOM = 2;
    static final int TROUGH_LEFT = 1;
    static final int TROUGH_RIGHT = 2;

    static {
        int[] nArray = new int[5];
        nArray[1] = 5;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        placement_values = nArray;
        annRotation_strings = new String[]{"None", "90", "180", "270"};
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        annRotation_values = nArray2;
        annotationMethod_strings = new String[]{"Value", "Value_Labels", "Time_Labels", "Point_Labels"};
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        annotationMethod_values = nArray3;
        timeUnit_strings = new String[]{"Seconds", "Minutes", "Hours", "Days", "Weeks", "Months", "Years"};
        timeUnit_values = new long[]{1000L, 60000L, 3600000L, 86400000L, 604800000L, 2678400000L, 31536000000L};
        originPlacement_strings = new String[]{"Automatic", "Zero", "Min", "Max"};
        int[] nArray4 = new int[4];
        nArray4[1] = 3;
        nArray4[2] = 1;
        nArray4[3] = 2;
        originPlacement_values = nArray4;
    }

    public JCAxis() {
        this.init();
    }

    public JCAxis(JCChartArea jCChartArea, boolean bl, int n) {
        this.isVertical = bl;
        this.annotationMethod = n;
        this.chartArea = jCChartArea;
        this.init();
    }

    public void addValueLabel(JCValueLabel jCValueLabel) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.annoHandler.userValueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n3);
            if (jCValueLabel2.value > jCValueLabel.value && n2 < 0) {
                n2 = n3;
                break;
            }
            if (jCValueLabel2.value == jCValueLabel.value) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n >= 0) {
            this.annoHandler.userValueLabels.setElementAt(jCValueLabel, n);
        } else if (n2 >= 0) {
            this.annoHandler.userValueLabels.insertElementAt(jCValueLabel, n2);
        } else {
            this.annoHandler.userValueLabels.addElement(jCValueLabel);
        }
        jCValueLabel.setParent(this);
        this.setChanged(true, 2);
    }

    void adjustForOrthoExtent() {
        if (!this.isShowing) {
            return;
        }
        if (this.annoHandler.realPlacement == 1 || this.annoHandler.realPlacement == 2) {
            return;
        }
        if (this.placementAxis == null) {
            return;
        }
        Rectangle rectangle = this.chartArea.plotRect;
        Rectangle rectangle2 = this.chartArea.chartAreaRect;
        if (this.isVertical) {
            int n = this.annoHandler.realPlacement == 4 ? this.placementAxis.toPixel(this.placementLocation) : this.placementAxis.toPixel(this.placementAxis.origin.value);
            if (n < this.placementAxis.getLeft() || n > this.placementAxis.getLeft() + this.placementAxis.getWidth()) {
                return;
            }
            if (n < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getLeftIsDefault()) {
                    int n2 = this.annoHandler.extents.ortho - n;
                    rectangle.width -= n2;
                    rectangle.x += n2;
                }
                this.resize(this.annoHandler.extents.ortho, this.getHeight());
            } else if (rectangle2.width - n < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getRightIsDefault()) {
                    int n3 = this.annoHandler.extents.ortho - (rectangle2.width - n);
                    rectangle.width -= n3;
                }
                this.resize(this.annoHandler.extents.ortho, this.getHeight());
            }
        } else {
            int n = this.annoHandler.realPlacement == 4 ? this.placementAxis.toPixel(this.placementLocation) : this.placementAxis.toPixel(this.placementAxis.origin.value);
            if (n < this.placementAxis.getTop() || n > this.placementAxis.getTop() + this.placementAxis.getHeight()) {
                return;
            }
            if (rectangle2.height - n < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getBottomIsDefault()) {
                    int n4 = this.annoHandler.extents.ortho - (rectangle2.height - n);
                    rectangle.height -= n4;
                }
                this.resize(this.getWidth(), this.annoHandler.extents.ortho);
            } else if (n < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getTopIsDefault()) {
                    int n5 = this.annoHandler.extents.ortho - n;
                    rectangle.height -= n5;
                    rectangle.y += n5;
                }
                this.resize(this.getWidth(), this.annoHandler.extents.ortho);
            }
        }
    }

    void calcAnchors() {
        if (!this.isShowing) {
            return;
        }
        this.annoHandler.calcAnchor();
        if (this.title.isShowing) {
            this.title.recalc(true);
            this.title.fixPlacement(this);
        }
    }

    void calcAnnotationExtents() {
        this.annoHandler.calcAnnotationExtents();
    }

    void calcAxisParams(boolean bl) {
        boolean bl2;
        this.setInitialSize();
        this.chartType = -1;
        JCAxis jCAxis = this;
        boolean bl3 = bl2 = this.formula != null && this.formula.getOriginator() != null;
        if (bl2) {
            jCAxis = this.formula.getOriginator();
        }
        this.hasBar = false;
        boolean bl4 = false;
        int n = 0;
        while (n < this.getParent().data.size()) {
            int n2;
            ChartDataView chartDataView = (ChartDataView)this.getParent().data.elementAt(n);
            if (chartDataView.xaxis == jCAxis) {
                n2 = chartDataView.getChartType();
                if (!bl4) {
                    this.chartType = n2;
                    this.isPrimary = bl2 ^ true;
                    this.otherAxis = chartDataView.yaxis;
                    bl4 = true;
                }
                if (n2 == 9 || n2 == 10) {
                    this.hasBar = true;
                }
            }
            if (chartDataView.yaxis == jCAxis) {
                n2 = chartDataView.getChartType();
                if (!bl4) {
                    this.chartType = n2;
                    this.isPrimary = false;
                    this.otherAxis = chartDataView.xaxis;
                    bl4 = true;
                }
                if (n2 == 9 || n2 == 10) {
                    this.hasBar = true;
                }
            }
            ++n;
        }
        this.frontPlane = this.hasBar || !this.is3D();
        this.getAxisHandler().calcParams();
        this.recalc();
    }

    void calcTransformation() {
        this.getAxisHandler().calcTransformation();
    }

    void checkAnnotations() {
        if (!this.isShowing) {
            return;
        }
        this.annoHandler.checkAnnotations();
    }

    void clearLimits() {
        this.dataLimits = null;
    }

    private Graphics clipToExtents(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Extents extents = this.getExtents();
        if (this.isVertical) {
            graphics2.clipRect(0, Math.max(0, this.getTop() - extents.minor), this.chartArea.getDrawingArea().width + 1, Math.min(this.chartArea.getDrawingArea().height, this.getHeight() + extents.major + extents.minor) + 1);
        } else {
            graphics2.clipRect(Math.max(0, this.getLeft() - extents.minor), 0, Math.min(this.chartArea.getDrawingArea().width, this.getWidth() + extents.major + extents.minor) + 1, this.chartArea.getDrawingArea().height + 1);
        }
        return graphics2;
    }

    private double dataLength() {
        return this.max.value - this.min.value;
    }

    public double dateToValue(Date date) {
        this.getTimeBase();
        return this.annoHandler.timeToData(date, this.timeUnit);
    }

    public void draw(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        if (graphics == null) {
            return;
        }
        this.axisDrawn = false;
        this.axisDrawn = this.isVertical ? this.drawVertical(graphics) : this.drawHorizontal(graphics);
    }

    void drawAnnotationsAndTitle(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        Graphics graphics2 = this.clipToExtents(graphics);
        if (this.axisDrawn) {
            this.annoHandler.draw(graphics2);
            if (this.title != null) {
                this.title.draw(graphics2);
            }
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
    }

    void drawGrid(Graphics graphics) {
        if (!this.gridIsShowing) {
            return;
        }
        if (this.gridSpacing.isDefault) {
            this.drawGridLinesAtLabels(graphics, false, Double.MAX_VALUE, Double.MAX_VALUE);
        } else {
            this.drawLinearGridLines(graphics, false, Double.MAX_VALUE, Double.MAX_VALUE);
        }
    }

    void drawGridInTrough(Graphics graphics, double d, double d2) {
        if (!this.gridIsShowing) {
            return;
        }
        if (this.gridSpacing.isDefault) {
            this.drawGridLinesAtLabels(graphics, true, d, d2);
        } else {
            this.drawLinearGridLines(graphics, true, d, d2);
        }
    }

    private void drawGridLine(Graphics graphics, JCLineStyle jCLineStyle, double d) {
        int n = this.toPixel(d);
        Rectangle rectangle = this.chartArea.plotRect;
        int n2 = this.chartArea.deltaX;
        int n3 = this.chartArea.deltaY;
        if (this.isVertical) {
            if (this.is3D()) {
                if (!this.frontPlane) {
                    n3 = 0;
                }
                if (n2 < 0) {
                    jCLineStyle.draw(graphics, rectangle.x, n + n3, rectangle.x + rectangle.width + n2, n + n3);
                } else {
                    jCLineStyle.draw(graphics, rectangle.x + n2, n + n3, rectangle.x + rectangle.width, n + n3);
                }
            } else {
                jCLineStyle.draw(graphics, rectangle.x, n, rectangle.x + rectangle.width, n);
            }
        } else if (this.is3D()) {
            if (!this.frontPlane) {
                n2 = 0;
            }
            if (n3 < 0) {
                jCLineStyle.draw(graphics, n2 + n, rectangle.y, n2 + n, rectangle.y + rectangle.height + n3);
            } else {
                jCLineStyle.draw(graphics, n2 + n, rectangle.y + n3, n2 + n, rectangle.y + rectangle.height);
            }
        } else {
            jCLineStyle.draw(graphics, n, rectangle.y, n, rectangle.y + rectangle.height);
        }
    }

    protected void drawGridLineInTrough(Graphics graphics, JCLineStyle jCLineStyle, double d) {
        int n = this.toPixel(d);
        Rectangle rectangle = this.chartArea.plotRect;
        int n2 = this.chartArea.deltaX;
        int n3 = this.chartArea.deltaY;
        if (this.isVertical) {
            if (this.is3D() && this.isBar()) {
                int n4 = this.linePosition();
                jCLineStyle.draw(graphics, n4, n, n4 + n2, n + n3);
            }
        } else if (this.is3D() && this.isBar()) {
            int n5 = this.linePosition();
            jCLineStyle.draw(graphics, n, n5, n + n2, n5 + n3);
        }
    }

    private void drawGridLinesAtLabels(Graphics graphics, boolean bl, double d, double d2) {
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        int n = 0;
        while (n < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
            ChartText chartText = jCValueLabel.getChartText();
            if (chartText.isShowing) {
                if (bl) {
                    if (d == Double.MAX_VALUE || jCValueLabel.value >= d && jCValueLabel.value <= d2) {
                        this.drawGridLineInTrough(graphics, jCLineStyle, jCValueLabel.value);
                    }
                } else {
                    this.drawGridLine(graphics, jCLineStyle, jCValueLabel.value);
                }
            }
            ++n;
        }
    }

    private boolean drawHorizontal(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getLeft();
        int n3 = this.linePosition();
        if (!(this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4 || n3 <= this.chartArea.plotRect.y + this.chartArea.plotRect.height && n3 >= this.chartArea.plotRect.y)) {
            return false;
        }
        if (graphics.getColor() != this.getForeground()) {
            graphics.setColor(this.getForeground());
        }
        graphics.drawLine(n2, n3, n2 + n, n3);
        this.getAxisHandler().drawTicks(graphics);
        return true;
    }

    private void drawLinearGridLines(Graphics graphics, boolean bl, double d, double d2) {
        double d3 = this.gridSpacing.value;
        int n = this.pixelLength();
        double d4 = this.dataLength();
        double d5 = d3 / 2.0;
        if (d5 < 0.0) {
            d5 = -d5;
        }
        if (d3 * (double)n / d4 + 0.5 < 2.0) {
            if (d3 <= 0.0) {
                this.setGridIsShowing(false);
                this.setGridSpacingIsDefault(true);
            } else {
                ErrorDialog.raise(this, JCChartBundle.string("jclass.chart.Key123"));
            }
            return;
        }
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        double d6 = this.firstInc(d3);
        while (d6 < this.max.value + d5) {
            if (bl) {
                if (d == Double.MAX_VALUE || d6 >= d && d6 <= d2) {
                    this.drawGridLineInTrough(graphics, jCLineStyle, d6);
                }
            } else {
                this.drawGridLine(graphics, jCLineStyle, d6);
            }
            d6 += d3;
        }
    }

    private boolean drawVertical(Graphics graphics) {
        int n = this.getHeight();
        int n2 = this.getTop();
        int n3 = this.linePosition();
        if (!(this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4 || n3 <= this.chartArea.plotRect.x + this.chartArea.plotRect.width && n3 >= this.chartArea.plotRect.x)) {
            return false;
        }
        if (graphics.getColor() != this.getForeground()) {
            graphics.setColor(this.getForeground());
        }
        graphics.drawLine(n3, n2, n3, n2 + n);
        this.getAxisHandler().drawTicks(graphics);
        return true;
    }

    double firstInc(double d) {
        double d2 = this.min.value;
        if (d == 0.0) {
            return d2;
        }
        int n = (int)Math.ceil((this.min.value - (d2 = JCChartUtil.precCorrect(this.precision.value, d2))) / d);
        if (n < 0) {
            return d2;
        }
        double d3 = d2 + d * (double)n;
        if ((d3 = JCChartUtil.precCorrect(this.precision.value, d3)) > this.max.value) {
            return d2;
        }
        return d3;
    }

    int getAdjustedRealPlacement() {
        if (this.otherAxis != null && this.otherAxis.isReversed) {
            if (this.annoHandler.realPlacement == 1) {
                return 2;
            }
            return 1;
        }
        return this.annoHandler.realPlacement;
    }

    int getAnnotationAnchor() {
        return this.annoHandler.anchor;
    }

    public int getAnnotationMethod() {
        return this.annotationMethod;
    }

    public int getAnnotationRotation() {
        return this.annotationRotation;
    }

    JCVector getAnnotations() {
        return this.annoHandler.valueLabels;
    }

    AxisHandler getAxisHandler() {
        if (this.axisHandler == null) {
            this.axisHandler = AxisHandler.makeAxisHandler(this);
        }
        return this.axisHandler;
    }

    public Color getBackground() {
        return this.chartArea == null ? (this.parent == null ? null : this.parent.getBackground()) : this.chartArea.getBackground();
    }

    Extents getExtents() {
        return this.annoHandler.extents;
    }

    public Font getFont() {
        return this.font == null ? (this.chartArea == null ? (this.parent == null ? null : this.parent.getFont()) : this.chartArea.getFont()) : this.font;
    }

    public Color getForeground() {
        return this.foreground == null ? (this.chartArea == null ? (this.parent == null ? null : this.parent.getForeground()) : this.chartArea.getForeground()) : this.foreground;
    }

    public JCAxisFormula getFormula() {
        if (this.formula == null) {
            this.formula = new JCAxisFormula(this);
        }
        return this.formula;
    }

    public int getGap() {
        return this.gap;
    }

    public JCValueLabel getGeneratedValueLabel(double d) {
        JCValueLabel jCValueLabel = null;
        int n = 0;
        while (n < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
            if (d == jCValueLabel2.value) {
                jCValueLabel = jCValueLabel2;
                break;
            }
            ++n;
        }
        return jCValueLabel;
    }

    public JCValueLabel[] getGeneratedValueLabels() {
        if (this.annoHandler.valueLabels == null || this.annoHandler.valueLabels.size() == 0) {
            return null;
        }
        JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.annoHandler.valueLabels.size()];
        int n = 0;
        while (n < jCValueLabelArray.length) {
            jCValueLabelArray[n] = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
            ++n;
        }
        return jCValueLabelArray;
    }

    public JCValueLabel getGeneratedValueLabels(int n) {
        if (this.annoHandler.valueLabels == null || this.annoHandler.valueLabels.size() == 0) {
            return null;
        }
        JCValueLabel jCValueLabel = null;
        try {
            jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
        }
        catch (Exception exception) {}
        return jCValueLabel;
    }

    public boolean getGridIsShowing() {
        return this.gridIsShowing;
    }

    protected double[] getGridLineList() {
        if (!this.gridIsShowing) {
            return null;
        }
        if (this.gridSpacing.isDefault) {
            return this.getGridLinesAtLabelsList();
        }
        return this.getLinearGridLinesList();
    }

    private double[] getGridLinesAtLabelsList() {
        double[] dArray = new double[this.annoHandler.valueLabels.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n2);
            ChartText chartText = jCValueLabel.getChartText();
            if (chartText.isShowing) {
                dArray[n] = jCValueLabel.value;
                ++n;
            }
            ++n2;
        }
        int n3 = n;
        while (n3 < this.annoHandler.valueLabels.size()) {
            dArray[n3] = Double.MAX_VALUE;
            ++n3;
        }
        return dArray;
    }

    public double getGridSpacing() {
        return this.gridSpacing.value;
    }

    public boolean getGridSpacingIsDefault() {
        return this.gridSpacing.isDefault;
    }

    public JCChartStyle getGridStyle() {
        if (this.gridStyle == null) {
            this.gridStyle = new JCChartStyle();
            this.gridStyle.setLineStyle(new JCLineStyle(1, this.getForeground(), 1));
            this.gridStyle.addParent(this);
        }
        return this.gridStyle;
    }

    public boolean getIsDecimalPadded() {
        return this.isDecimalPadded;
    }

    public boolean getIsEditable() {
        return this.isEditable;
    }

    public boolean getIsLogarithmic() {
        return this.isLogarithmic;
    }

    public boolean getIsReversed() {
        return this.isReversed;
    }

    public boolean getIsVertical() {
        return this.isVertical;
    }

    public JCLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    private double[] getLinearGridLinesList() {
        double d = this.gridSpacing.value;
        int n = this.pixelLength();
        double d2 = this.dataLength();
        double d3 = d / 2.0;
        if (d3 < 0.0) {
            d3 = -d3;
        }
        if (d * (double)n / d2 + 0.5 < 2.0) {
            if (d <= 0.0) {
                this.setGridIsShowing(false);
                this.setGridSpacingIsDefault(true);
            } else {
                ErrorDialog.raise(this, JCChartBundle.string("jclass.chart.Key123"));
            }
            return null;
        }
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        double[] dArray = new double[(int)Math.ceil((this.max.value + d3 - this.min.value) / d)];
        int n2 = 0;
        double d4 = this.firstInc(d);
        while (d4 < this.max.value + d3) {
            dArray[n2] = d4;
            ++n2;
            d4 += d;
        }
        return dArray;
    }

    public double getMax() {
        return this.max.value;
    }

    public boolean getMaxIsDefault() {
        return this.max.isDefault;
    }

    public int getMaxPrecision() {
        return this.maximumPrecision;
    }

    public double getMin() {
        return this.min.value;
    }

    public boolean getMinIsDefault() {
        return this.min.isDefault;
    }

    public double getNumSpacing() {
        return this.numSpacing.value;
    }

    public boolean getNumSpacingIsDefault() {
        return this.numSpacing.isDefault;
    }

    public double getOrigin() {
        return this.origin.value;
    }

    public boolean getOriginIsDefault() {
        return this.origin.isDefault;
    }

    public int getOriginPlacement() {
        return this.originPlacement.value;
    }

    public boolean getOriginPlacementIsDefault() {
        return this.originPlacement.isDefault;
    }

    public int getPlacement() {
        return this.placement.value;
    }

    public JCAxis getPlacementAxis() {
        return this.placementAxis;
    }

    public boolean getPlacementIsDefault() {
        return this.placement.isDefault;
    }

    public double getPlacementLocation() {
        return this.placementLocation;
    }

    public int getPrecision() {
        return this.precision.value;
    }

    public boolean getPrecisionIsDefault() {
        return this.precision.isDefault;
    }

    double getRealPlacementLocation() {
        switch (this.annoHandler.realPlacement) {
            case 1: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getMin();
            }
            case 2: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getMax();
            }
            case 5: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getOrigin();
            }
            case 4: {
                return this.getPlacementLocation();
            }
        }
        return Double.MAX_VALUE;
    }

    public double getTickSpacing() {
        return this.tickSpacing.value;
    }

    public boolean getTickSpacingIsDefault() {
        return this.tickSpacing.isDefault;
    }

    public Date getTimeBase() {
        if (this.timeBase == null) {
            this.timeBase = new Date();
        }
        return this.timeBase;
    }

    public String getTimeFormat() {
        return this.timeFormat.value;
    }

    public String getTimeFormat11() {
        return this.timeFormat11.value;
    }

    public boolean getTimeFormat11IsDefault() {
        return this.timeFormat11.isDefault;
    }

    public boolean getTimeFormatIsDefault() {
        return this.timeFormat.isDefault;
    }

    public long getTimeUnit() {
        return this.timeUnit;
    }

    public JCAxisTitle getTitle() {
        if (this.title == null) {
            this.title = new JCAxisTitle();
            this.title.setParentAxis(this);
            this.title.setParent(this.parent);
            this.title.setParentRegion(this.chartArea);
        }
        return this.title;
    }

    public JCValueLabel getValueLabel(double d) {
        JCValueLabel jCValueLabel = null;
        int n = 0;
        while (n < this.annoHandler.userValueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n);
            if (d == jCValueLabel2.value) {
                jCValueLabel = jCValueLabel2;
                break;
            }
            ++n;
        }
        return jCValueLabel;
    }

    public JCValueLabel[] getValueLabels() {
        if (this.annoHandler.userValueLabels == null || this.annoHandler.userValueLabels.size() == 0) {
            return null;
        }
        JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.annoHandler.userValueLabels.size()];
        int n = 0;
        while (n < jCValueLabelArray.length) {
            jCValueLabelArray[n] = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n);
            ++n;
        }
        return jCValueLabelArray;
    }

    public JCValueLabel getValueLabels(int n) {
        if (this.annoHandler.userValueLabels == null || this.annoHandler.userValueLabels.size() == 0) {
            return null;
        }
        JCValueLabel jCValueLabel = null;
        try {
            jCValueLabel = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n);
        }
        catch (Exception exception) {}
        return jCValueLabel;
    }

    private void init() {
        this.setTitle(new JCAxisTitle());
        this.setName(String.valueOf(JCChartBundle.string("jclass.chart.Key6")) + " " + ++axisNum);
    }

    private boolean is3D() {
        return this.chartArea != null && this.chartArea.draw3D;
    }

    protected boolean isBar() {
        return this.hasBar;
    }

    protected boolean isBottomSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.isReversed;
        }
        return !this.isVertical && (this.annoHandler.realPlacement == 1 && !bl || this.annoHandler.realPlacement == 2 && bl);
    }

    protected boolean isLeftSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.isReversed;
        }
        return this.isVertical && (this.annoHandler.realPlacement == 1 && !bl || this.annoHandler.realPlacement == 2 && bl);
    }

    protected boolean isRightSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.isReversed;
        }
        return this.isVertical && (this.annoHandler.realPlacement == 2 && !bl || this.annoHandler.realPlacement == 1 && bl);
    }

    protected boolean isTopSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.isReversed;
        }
        return !this.isVertical && (this.annoHandler.realPlacement == 2 && !bl || this.annoHandler.realPlacement == 1 && bl);
    }

    void layoutAnnotations() {
        if (!this.isShowing) {
            return;
        }
        this.annoHandler.layout();
        if (this.title != null) {
            this.title.layout();
        }
    }

    void layoutAxis(boolean bl) {
        int n;
        int n2 = Math.max(-this.chartArea.deltaX, 0);
        int n3 = Math.max(-this.chartArea.deltaY, 0);
        int n4 = this.chartArea.deltaX;
        int n5 = this.chartArea.deltaY;
        int n6 = n = bl ? 1 : 0;
        if (this.isVertical) {
            if (!this.is3D()) {
                this.reshape(this.getLeft(), this.chartArea.plotRect.y, this.getWidth(), this.chartArea.plotRect.height);
            } else if (this.isBar()) {
                if (this.getLeft() < this.chartArea.plotRect.x) {
                    this.reshape(this.getLeft() + n2 * n, this.chartArea.plotRect.y + n3, this.getWidth(), this.chartArea.plotRect.height - JCChartUtil.abs(n5));
                } else {
                    n2 = Math.max(this.chartArea.deltaX, 0);
                    this.reshape(this.getLeft() - n2 * n, this.chartArea.plotRect.y + n3, this.getWidth(), this.chartArea.plotRect.height - JCChartUtil.abs(n5));
                }
            } else {
                n3 = Math.max(this.chartArea.deltaY, 0);
                if (this.getLeft() <= this.chartArea.plotRect.x) {
                    n2 = Math.max(this.chartArea.deltaX, 0);
                    this.reshape(this.chartArea.plotRect.x + n2 * n - this.getWidth(), this.chartArea.plotRect.y + n3, this.getWidth(), this.chartArea.plotRect.height - JCChartUtil.abs(n5));
                } else {
                    this.reshape(this.chartArea.plotRect.x + this.chartArea.plotRect.width - n2 * n, this.chartArea.plotRect.y + n3, this.getWidth(), this.chartArea.plotRect.height - JCChartUtil.abs(n5));
                }
            }
        } else if (!this.is3D()) {
            this.reshape(this.chartArea.plotRect.x, this.getTop(), this.chartArea.plotRect.width, this.getHeight());
        } else if (this.isBar()) {
            if (this.getTop() <= this.chartArea.plotRect.y) {
                this.reshape(this.chartArea.plotRect.x + n2, this.getTop() + n3 * n, this.chartArea.plotRect.width - JCChartUtil.abs(n4), this.getHeight());
            } else {
                n3 = Math.max(this.chartArea.deltaY, 0);
                this.reshape(this.chartArea.plotRect.x + n2, this.getTop() - n3 * n, this.chartArea.plotRect.width - JCChartUtil.abs(n4), this.getHeight());
            }
        } else {
            n2 = Math.max(this.chartArea.deltaX, 0);
            if (this.getTop() <= this.chartArea.plotRect.y) {
                n3 = Math.max(this.chartArea.deltaY, 0);
                this.reshape(this.chartArea.plotRect.x + n2, this.chartArea.plotRect.y + n3 * n - this.getHeight(), this.chartArea.plotRect.width - JCChartUtil.abs(n4), this.getHeight());
            } else {
                this.reshape(this.chartArea.plotRect.x + n2, this.chartArea.plotRect.y + this.chartArea.plotRect.height - n3 * n, this.chartArea.plotRect.width - JCChartUtil.abs(n4), this.getHeight());
            }
        }
    }

    void layoutOrigin() {
        if (this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4) {
            return;
        }
        if (this.placementAxis == null) {
            this.placementAxis = this.otherAxis;
        }
        if (this.placementAxis == null) {
            return;
        }
        double d = this.annoHandler.realPlacement == 4 ? this.placementLocation : this.placementAxis.origin.value;
        int n = this.placementAxis.toPixel(d);
        if (this.isVertical) {
            if (this.annoHandler.anchor == 1) {
                this.move(n, this.getTop());
            } else {
                this.move(n - this.getWidth(), this.getTop());
            }
        } else if (this.annoHandler.anchor == 16) {
            this.move(this.getLeft(), n - this.getHeight());
        } else {
            this.move(this.getLeft(), n);
        }
    }

    int linePosition() {
        int n = this.isVertical ? (this.annoHandler.anchor == 2 ? this.getLeft() + this.getWidth() : (this.annoHandler.anchor == 1 ? this.getLeft() : this.getLeft() + this.getWidth() / 2)) : (this.annoHandler.anchor == 16 ? this.getTop() + this.getHeight() : (this.annoHandler.anchor == 32 ? this.getTop() : this.getTop() + this.getHeight() / 2));
        return n;
    }

    public void loadParams(String string, JCChart jCChart) {
        super.loadParams(string, jCChart);
        this.setIsVertical(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isVertical"), this.getIsVertical()));
        this.setIsLogarithmic(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isLogarithmic"), this.getIsLogarithmic()));
        this.setAnnotationRotation(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".annotationRotation"), String.valueOf(string) + " annotation rotation", annRotation_strings, annRotation_values, this.getAnnotationRotation()));
        this.setAnnotationMethod(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".annotationMethod"), String.valueOf(string) + " annotation method", annotationMethod_strings, annotationMethod_values, this.getAnnotationMethod()));
        this.setPlacement(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".placement"), String.valueOf(string) + " placement", placement_strings, placement_values, this.getPlacement()));
        JCChartConverter jCChartConverter = new JCChartConverter();
        this.setPlacementAxis(jCChartConverter.toAxis(jCChart, jCChart.getParam(String.valueOf(string) + ".placementAxis"), this.getPlacementAxis()));
        this.setIsReversed(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isReversed"), this.getIsReversed()));
        this.setPlacementLocation(JCChart.getConverter().toDouble(jCChart.getParam(String.valueOf(string) + ".placementLocation"), this.getPlacementLocation()));
        this.setGap(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".gap"), this.getGap()));
        this.setTimeBase(JCChart.getConverter().toDate(jCChart.getParam(String.valueOf(string) + ".timeBase"), this.getTimeBase()));
        this.setTimeUnit(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".timeUnit"), String.valueOf(string) + " time unit", timeUnit_strings, timeUnit_values, this.getTimeUnit()));
        String string2 = jCChart.getParam(String.valueOf(string) + ".timeFormat11");
        if (string2 != null) {
            this.setTimeFormat11(string2);
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".timeFormat")) != null) {
            this.setTimeFormat(string2);
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".min")) != null) {
            this.setMin(JCChart.getConverter().toDouble(string2, this.getMin()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".max")) != null) {
            this.setMax(JCChart.getConverter().toDouble(string2, this.getMax()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".precision")) != null) {
            this.setPrecision(JCChart.getConverter().toInt(string2, this.getPrecision()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".tickSpacing")) != null) {
            this.setTickSpacing(JCChart.getConverter().toDouble(string2, this.getTickSpacing()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".numSpacing")) != null) {
            this.setNumSpacing(JCChart.getConverter().toDouble(string2, this.getNumSpacing()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".origin")) != null) {
            this.setOrigin(JCChart.getConverter().toDouble(string2, this.getOrigin()));
        }
        this.setOriginPlacement(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".originPlacement"), String.valueOf(string) + " origin placement", originPlacement_strings, originPlacement_values, this.getOriginPlacement()));
        this.setGridIsShowing(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".gridIsShowing"), this.getGridIsShowing()));
        string2 = jCChart.getParam(String.valueOf(string) + ".gridSpacing");
        if (string2 != null) {
            this.setGridSpacing(JCChart.getConverter().toDouble(string2, this.getGridSpacing()));
        }
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        jCLineStyle.setColor(JCChart.getConverter().toColor(jCChart.getParam(String.valueOf(string) + ".gridColor"), jCLineStyle.getColor()));
        string2 = jCChart.getParam(String.valueOf(string) + ".valueLabels");
        if (string2 != null) {
            String[] stringArray = JCUtilConverter.toStringList(string2, ';');
            int n = 0;
            while (n < stringArray.length) {
                this.addValueLabel(new JCValueLabel(JCChart.getConverter().toDouble(stringArray[n], 0.0), stringArray[n + 1]));
                n += 2;
            }
        }
        this.isEditable = JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isEditable"), this.isEditable);
        this.getTitle().loadParams(String.valueOf(string) + ".title", jCChart);
        this.getFormula().loadParams(String.valueOf(string) + ".formula", jCChart);
    }

    void makeAnnotations() {
        this.annoHandler.makeAnnotations();
    }

    int pixelLength() {
        return this.isVertical ? this.getHeight() : this.getWidth();
    }

    int pixelStart() {
        return this.isVertical ? -this.getTop() : this.getLeft();
    }

    void postDrawOutlineTrough(Graphics graphics, int n) {
        if (!this.isShowing) {
            return;
        }
        if (this.isBar() && this.is3D() && this.sideplane != null) {
            boolean bl;
            JCFillStyle jCFillStyle = new JCFillStyle(this.chartArea.getPlotArea().getBackground(), 1);
            boolean bl2 = bl = this.isPrimary && this.isVertical || !this.isPrimary && !this.isVertical;
            if (!bl && !this.isReversed && (n & 1) != 0 || !bl && this.isReversed && (n & 2) != 0 || bl && !this.isReversed && (n & 2) != 0 || bl && this.isReversed && (n & 1) != 0) {
                jCFillStyle.drawOutlineLine(graphics, this.sideplane, 1, 2, this.getForeground());
            }
            if (!bl && !this.isReversed && (n & 2) != 0 || !bl && this.isReversed && (n & 1) != 0 || bl && !this.isReversed && (n & 1) != 0 || bl && this.isReversed && (n & 2) != 0) {
                jCFillStyle.drawOutlineLine(graphics, this.sideplane, 3, 4, this.getForeground());
            }
        }
    }

    void preDraw(Graphics graphics, boolean bl, boolean bl2) {
        if (!this.isShowing) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            boolean bl3;
            JCFillStyle jCFillStyle = new JCFillStyle(this.chartArea.getPlotArea().getBackground(), 1);
            boolean bl4 = bl3 = this.isPrimary && this.isVertical || !this.isPrimary && !this.isVertical;
            if (bl) {
                if (!this.isVertical && this.chartArea.deltaY <= 0 || this.isVertical && this.chartArea.deltaX <= 0) {
                    jCFillStyle.fillPolygonHighlight(graphics, this.sideplane);
                } else {
                    jCFillStyle.fillPolygonShadow(graphics, this.sideplane);
                }
            } else {
                int n = this.otherAxis.linePosition();
                if (bl2) {
                    Polygon polygon = new Polygon(this.sideplane.xpoints, this.sideplane.ypoints, this.sideplane.npoints);
                    if (this.isVertical) {
                        polygon.ypoints[1] = n;
                        polygon.ypoints[2] = n + this.chartArea.deltaY;
                    } else {
                        polygon.xpoints[0] = n;
                        polygon.xpoints[4] = n;
                        polygon.xpoints[3] = n + this.chartArea.deltaX;
                    }
                    if (!this.isVertical && this.chartArea.deltaY <= 0 || this.isVertical && this.chartArea.deltaX <= 0) {
                        jCFillStyle.fillPolygonHighlight(graphics, polygon);
                    } else {
                        jCFillStyle.fillPolygonShadow(graphics, polygon);
                    }
                } else {
                    Polygon polygon = new Polygon(this.sideplane.xpoints, this.sideplane.ypoints, this.sideplane.npoints);
                    if (this.isVertical) {
                        polygon.ypoints[0] = n;
                        polygon.ypoints[4] = n;
                        polygon.ypoints[3] = n + this.chartArea.deltaY;
                    } else {
                        polygon.xpoints[1] = n;
                        polygon.xpoints[2] = n + this.chartArea.deltaX;
                    }
                    if (!this.isVertical && this.chartArea.deltaY <= 0 || this.isVertical && this.chartArea.deltaX <= 0) {
                        jCFillStyle.fillPolygonHighlight(graphics, polygon);
                    } else {
                        jCFillStyle.fillPolygonShadow(graphics, polygon);
                    }
                }
            }
        }
    }

    void preDrawCalc() {
        if (!this.isShowing) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            int[] nArray = new int[5];
            int[] nArray2 = new int[5];
            if (this.isVertical) {
                nArray[0] = nArray[1] = this.linePosition();
                nArray2[0] = this.getTop() + this.getHeight();
                nArray2[1] = this.getTop();
                nArray[3] = nArray[2] = nArray[1] + this.chartArea.deltaX;
                nArray2[2] = nArray2[1] + this.chartArea.deltaY;
                nArray2[3] = nArray2[0] + this.chartArea.deltaY;
            } else {
                nArray[0] = this.getLeft() + this.getWidth();
                nArray[1] = this.getLeft();
                nArray2[0] = nArray2[1] = this.linePosition();
                nArray[2] = nArray[1] + this.chartArea.deltaX;
                nArray2[2] = nArray2[3] = nArray2[1] + this.chartArea.deltaY;
                nArray[3] = nArray[0] + this.chartArea.deltaX;
            }
            nArray[4] = nArray[0];
            nArray2[4] = nArray2[0];
            this.sideplane = new Polygon();
            int n = 0;
            while (n < 5) {
                this.sideplane.addPoint(nArray[n], nArray2[n]);
                ++n;
            }
        }
    }

    void preDrawOutlineTrough(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            JCFillStyle jCFillStyle = new JCFillStyle(this.chartArea.getPlotArea().getBackground(), 1);
            jCFillStyle.drawOutlinePolygon(graphics, this.sideplane, this.getForeground());
        }
    }

    double range() {
        return this.getAxisHandler().range();
    }

    public void recalc() {
        this.setChanged(false, 0, false);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.getLeft() == n && this.getTop() == n2 && this.getWidth() == n3 && this.getHeight() == n4) {
            return;
        }
        super.reshape(n, n2, n3, n4);
        this.setChanged(true, 2, false);
        this.calcTransformation();
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        Object object;
        boolean bl = string.indexOf("yaxis") >= 0;
        JCAxis jCAxis = new JCAxis();
        super.saveParams(string, hTMLSaveDriver);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isLogarithmic", jCAxis.getIsLogarithmic(), this.getIsLogarithmic());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".annotationRotation", JCUtilConverter.fromEnum(jCAxis.getAnnotationRotation(), annRotation_strings, annRotation_values), JCUtilConverter.fromEnum(this.getAnnotationRotation(), annRotation_strings, annRotation_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".annotationMethod", JCUtilConverter.fromEnum(jCAxis.getAnnotationMethod(), annotationMethod_strings, annotationMethod_values), JCUtilConverter.fromEnum(this.getAnnotationMethod(), annotationMethod_strings, annotationMethod_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".placement", JCUtilConverter.fromEnum(jCAxis.getPlacement(), placement_strings, placement_values), JCUtilConverter.fromEnum(this.getPlacement(), placement_strings, placement_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".placementAxis", jCAxis.getPlacementAxis(), this.getPlacementAxis());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isReversed", jCAxis.getIsReversed(), this.getIsReversed());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".placementLocation", jCAxis.getPlacementLocation(), this.getPlacementLocation());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".gap", jCAxis.getGap(), this.getGap());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isVertical", bl, this.getIsVertical());
        if (this.annotationMethod == 2) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".timeBase", this.timeBase);
        }
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".timeUnit", JCUtilConverter.fromEnum(jCAxis.getTimeUnit(), timeUnit_strings, timeUnit_values), JCUtilConverter.fromEnum(this.getTimeUnit(), timeUnit_strings, timeUnit_values));
        if (!this.timeFormat.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".timeFormat", this.timeFormat.value);
        }
        if (!this.timeFormat11.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".timeFormat11", this.timeFormat11.value);
        }
        if (!this.min.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".min", this.min.value);
        }
        if (!this.max.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".max", this.max.value);
        }
        if (!this.precision.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".precision", this.precision.value);
        }
        if (!this.tickSpacing.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".tickSpacing", this.tickSpacing.value);
        }
        if (!this.numSpacing.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".numSpacing", this.numSpacing.value);
        }
        if (!this.origin.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".origin", this.origin.value);
        }
        if (!this.originPlacement.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".originPlacement", JCUtilConverter.fromEnum(this.originPlacement.value, originPlacement_strings, originPlacement_values));
        }
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".gridIsShowing", jCAxis.getGridIsShowing(), this.getGridIsShowing());
        if (!this.gridSpacing.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".gridSpacing", this.gridSpacing.value);
        }
        if (this.gridStyle != null) {
            object = this.gridStyle.getLineStyle();
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".gridColor", ((JCLineStyle)object).getColor());
        }
        object = "";
        JCVector jCVector = this.annoHandler.userValueLabels;
        int n = 0;
        while (n < jCVector.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)jCVector.elementAt(n);
            object = String.valueOf(object) + jCValueLabel.getValue() + "; " + jCValueLabel.getText();
            if (n + 1 != jCVector.size()) {
                object = String.valueOf(object) + "; ";
            }
            ++n;
        }
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".valueLabels", (String)object);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isEditable", jCAxis.getIsEditable(), this.isEditable);
        this.getTitle().saveParams(String.valueOf(string) + ".title", hTMLSaveDriver);
        this.getFormula().saveParams(String.valueOf(string) + ".formula", hTMLSaveDriver);
    }

    public void setAnnotationMethod(int n) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (n == this.annotationMethod) {
                this.savedXAxisAnnotationMethod = this.annotationMethod;
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 3: {
                    if (this.chartArea != null && !this.chartArea.isXAxis(this)) {
                        throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key119"));
                    }
                }
                case 0: 
                case 1: 
                case 2: {
                    this.savedXAxisAnnotationMethod = this.annotationMethod = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key50"));
                }
            }
        }
        this.setChanged(true, 2);
    }

    public void setAnnotationRotation(int n) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (n == this.annotationRotation) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.annotationRotation = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key51"));
                }
            }
        }
        this.setChanged(true, 2);
    }

    public void setGap(int n) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.gap == n) {
                Object var3_3 = null;
                return;
            }
            this.gap = n;
        }
        this.setChanged(true, 2);
    }

    public void setGridIsShowing(boolean bl) {
        if (bl == this.gridIsShowing) {
            return;
        }
        this.gridIsShowing = bl;
        this.setChanged(true, 1);
    }

    public void setGridSpacing(double d) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.gridSpacing.value = d;
            this.gridSpacing.isDefault = false;
        }
        this.setChanged(true, 1);
    }

    public void setGridSpacingIsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.gridSpacing.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.gridSpacing.isDefault = bl;
        }
        if (bl) {
            this.setChanged(true, 2);
        } else {
            this.setChanged(true, 1);
        }
    }

    public void setGridStyle(JCChartStyle jCChartStyle) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (jCChartStyle == this.gridStyle) {
                Object var3_3 = null;
                return;
            }
            this.gridStyle = jCChartStyle;
        }
        this.setChanged(true, 1);
    }

    void setInitialSize() {
        if (this.isVertical) {
            this.reshape(0, 0, 30, this.chartArea.size().height);
        } else {
            this.reshape(0, this.chartArea.size().height - 30, this.chartArea.size().width, 30);
        }
    }

    public void setIsDecimalPadded(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.isDecimalPadded = bl;
        }
    }

    public void setIsEditable(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.isEditable = bl;
        }
    }

    public void setIsLogarithmic(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.isLogarithmic == bl) {
                Object var3_3 = null;
                return;
            }
            this.isLogarithmic = bl;
            this.axisHandler = null;
        }
        this.setChanged(true, 2);
    }

    public void setIsReversed(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.isReversed = bl;
        }
        this.setChanged(true, 2);
    }

    public void setIsVertical(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.isVertical == bl) {
                Object var3_3 = null;
                return;
            }
            this.isVertical = bl;
        }
        this.setChanged(true, 2);
    }

    public void setLabelGenerator(JCLabelGenerator jCLabelGenerator) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.labelGenerator == jCLabelGenerator) {
                Object var3_3 = null;
                return;
            }
            this.labelGenerator = jCLabelGenerator;
            this.numberLocalization = false;
        }
        this.setChanged(true, 2);
    }

    void setLimits(MinMax minMax) {
        if (this.dataLimits == null) {
            this.dataLimits = new MinMax();
        }
        this.dataLimits.union(minMax);
        if (this.dataLimits.min > this.dataLimits.max) {
            this.dataLimits = null;
        }
    }

    public void setMax(double d) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.max.value = d;
            this.max.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public void setMaxIsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.max.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.max.isDefault = bl;
        }
        this.setChanged(true, 2);
    }

    public void setMaxPrecision(int n) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.maximumPrecision = n;
        }
        this.setChanged(true, 2);
    }

    public void setMin(double d) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.min.value = d;
            this.min.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public void setMinIsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.min.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.min.isDefault = bl;
        }
        this.setChanged(true, 2);
    }

    public void setNumSpacing(double d) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.numSpacing.value = d;
            this.numSpacing.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public void setNumSpacingIsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.numSpacing.isDefault = bl;
        }
        this.setChanged(true, 2);
    }

    public void setOrigin(double d) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.origin.value = d;
            this.origin.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public void setOriginIsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.origin.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.origin.isDefault = bl;
        }
        this.setChanged(true, 2);
    }

    public void setOriginPlacement(int n) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.originPlacement.value == n) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.originPlacement.value = n;
                    this.originPlacement.isDefault = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key63"));
                }
            }
        }
        this.setChanged(true, 2);
    }

    public void setOriginPlacementIsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.originPlacement.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.originPlacement.isDefault = bl;
            if (bl) {
                this.originPlacement.value = 0;
            }
        }
        this.setChanged(true, 2);
    }

    public void setParent(JCChart jCChart) {
        if (this.parent == jCChart) {
            return;
        }
        super.setParent(jCChart);
        if (jCChart != null) {
            this.chartArea = jCChart.chartArea;
        }
        this.setParentRegion(this.chartArea);
        if (this.title != null) {
            this.title.setParentAxis(this);
            this.title.setParent(jCChart);
            this.title.setParentRegion(this.chartArea);
        }
        if (this.annoHandler != null) {
            this.annoHandler.setValueLabelParent(jCChart);
        }
    }

    public void setPlacement(int n) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.placement.value == n) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    this.placement.value = n;
                    this.placement.isDefault = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key64"));
                }
            }
        }
        this.setChanged(true, 2);
    }

    public void setPlacement(JCAxis jCAxis) {
        JCAxis jCAxis2 = this;
        synchronized (jCAxis2) {
            this.placementAxis = jCAxis;
        }
        this.setPlacement(5);
    }

    public void setPlacement(JCAxis jCAxis, double d) {
        JCAxis jCAxis2 = this;
        synchronized (jCAxis2) {
            this.placementAxis = jCAxis;
            this.placementLocation = d;
        }
        this.setPlacement(4);
    }

    public void setPlacementAxis(JCAxis jCAxis) {
        JCAxis jCAxis2 = this;
        synchronized (jCAxis2) {
            this.placementAxis = jCAxis;
        }
        this.setChanged(true, 2);
    }

    public void setPlacementIsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.placement.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.placement.isDefault = bl;
            if (bl) {
                this.placement.value = 0;
            }
        }
        this.setChanged(true, 2);
    }

    public void setPlacementLocation(double d) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.placementLocation = d;
        }
        this.setChanged(true, 2);
    }

    public void setPrecision(int n) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.precision.value = n;
            this.precision.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public void setPrecisionIsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.precision.isDefault = bl;
        }
        this.setChanged(true, 2);
    }

    public void setTickSpacing(double d) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.tickSpacing.value = d;
            this.tickSpacing.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public void setTickSpacingIsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.tickSpacing.isDefault = bl;
        }
        this.setChanged(true, 2);
    }

    public void setTimeAnnotationLocale(Locale locale) {
        if (this.annotationMethod == 2) {
            this.annoHandler.getDateFormatter().setLocale(locale);
            this.setChanged(true, 1);
        }
    }

    public void setTimeBase(Date date) {
        if (date == null) {
            return;
        }
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.timeBase != null && this.timeBase.equals(date)) {
                Object var3_3 = null;
                return;
            }
            this.timeBase = date;
        }
        this.setChanged(true, 2);
    }

    public void setTimeFormat(String string) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.timeFormat.value != null && this.timeFormat.value.equals(string)) {
                Object var3_3 = null;
                return;
            }
            this.timeFormat.value = string;
            this.timeFormat.isDefault = false;
            this.timeFormat11.value = JCChartDateFormat.oldFormat2NewPattern(this.timeFormat.value);
            this.timeFormat11.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public void setTimeFormat11(String string) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.timeFormat11.value != null && this.timeFormat11.value.equals(string)) {
                Object var3_3 = null;
                return;
            }
            this.timeFormat11.value = string;
            this.timeFormat11.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public void setTimeFormat11IsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.timeFormat11.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.timeFormat11.isDefault = bl;
        }
        this.setChanged(true, 2);
    }

    public void setTimeFormatIsDefault(boolean bl) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.timeFormat.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.timeFormat.isDefault = bl;
            this.timeFormat11.isDefault = bl;
        }
        this.setChanged(true, 2);
    }

    public void setTimeUnit(long l) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.timeUnit == l) {
                Object var4_3 = null;
                return;
            }
            if (l != 1000L && l != 60000L && l != 3600000L && l != 86400000L && l != 604800000L && l != 2678400000L && l != 31536000000L) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key66"));
            }
            this.timeUnit = l;
        }
        this.setChanged(true, 2);
    }

    public void setTitle(JCAxisTitle jCAxisTitle) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (jCAxisTitle == null) {
                Object var3_3 = null;
                return;
            }
            this.title = jCAxisTitle;
            this.title.setParentAxis(this);
            this.title.setParent(this.parent);
            this.title.setParentRegion(this.chartArea);
        }
        this.setChanged(true, 2);
    }

    public void setValueLabels(int n, JCValueLabel jCValueLabel) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            if (this.annoHandler.userValueLabels == null) {
                this.annoHandler.userValueLabels = new JCVector();
            }
            if (n < 0 || n > this.annoHandler.userValueLabels.size()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key80"));
            }
            if (jCValueLabel != null) {
                jCValueLabel.setParent(this);
            }
            if (n < this.annoHandler.userValueLabels.size()) {
                this.annoHandler.userValueLabels.setElementAt(jCValueLabel, n);
            } else {
                this.annoHandler.userValueLabels.insertElementAt(jCValueLabel, n);
            }
        }
        this.setChanged(true, 2);
    }

    public void setValueLabels(JCValueLabel[] jCValueLabelArray) {
        this.annoHandler.userValueLabels = new JCVector();
        if (jCValueLabelArray == null) {
            return;
        }
        int n = 0;
        while (n < jCValueLabelArray.length) {
            if (jCValueLabelArray[n] != null) {
                jCValueLabelArray[n].setParent(this);
            }
            this.annoHandler.userValueLabels.setElementAt(n, jCValueLabelArray[n]);
            ++n;
        }
        this.annoHandler.sortValueLabels();
        this.setChanged(true, 2);
    }

    public String timeBaseToString(boolean bl) {
        return bl ? this.annoHandler.getDateFormatter().timeLabel(this.timeFormat11.value, this.getTimeBase()) : this.annoHandler.getDateFormatter().timeLabel(this.getTimeBase());
    }

    public double toData(int n) {
        return this.getAxisHandler().toData(n);
    }

    public double toData(int n, boolean bl) {
        if (this.frontPlane && !bl) {
            return this.toData(n - (this.isVertical ? this.chartArea.deltaY : this.parent.chartArea.deltaX));
        }
        if (!this.frontPlane && bl) {
            return this.toData(n + (this.isVertical ? this.chartArea.deltaY : this.parent.chartArea.deltaX));
        }
        return this.toData(n);
    }

    public int toPixel(double d) {
        return this.getAxisHandler().toPixel(d);
    }

    public int toPixel(double d, boolean bl) {
        if (this.frontPlane && !bl) {
            return this.toPixel(d) + (this.isVertical ? this.chartArea.deltaY : this.parent.chartArea.deltaX);
        }
        if (!this.frontPlane && bl) {
            return this.toPixel(d) - (this.isVertical ? this.chartArea.deltaY : this.parent.chartArea.deltaX);
        }
        return this.toPixel(d);
    }

    public String toString() {
        String string = this.getName();
        return string == null ? String.valueOf(JCChartBundle.string("jclass.chart.Key141")) + (this.isVertical ? JCChartBundle.string("jclass.chart.Key147") : JCChartBundle.string("jclass.chart.Key44")) + " " + JCChartBundle.string("jclass.chart.Key6") : string;
    }

    void translate(double d) {
        this.getAxisHandler().translate(d);
        this.setChanged(true, 2, false);
    }

    public Date valueToDate(double d) {
        this.getTimeBase();
        return this.annoHandler.dataToTime(d, this.timeUnit);
    }
}

