/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.io.Serializable;
import jclass.chart.ChartDataView;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCChart;
import jclass.chart.JCChartStyle;

public class JCCandleChartFormat
implements Serializable,
HTMLHandler {
    static final int RISING_CANDLE_INDEX = 1;
    static final int FALLING_CANDLE_INDEX = 2;
    static final int CANDLE_OUTLINE_INDEX = 3;
    boolean isComplex = false;
    ChartDataView parent = null;

    public JCCandleChartFormat() {
    }

    public JCCandleChartFormat(ChartDataView chartDataView) {
        this.parent = chartDataView;
    }

    public JCChartStyle getCandleOutlineStyle(int n) {
        JCChartStyle jCChartStyle = null;
        if (this.parent != null) {
            jCChartStyle = this.parent.getChartStyle(n * this.parent.getNumSeriesPerData() + 3);
        }
        return jCChartStyle;
    }

    public JCChartStyle getFallingCandleStyle(int n) {
        JCChartStyle jCChartStyle = null;
        if (this.parent != null) {
            jCChartStyle = this.parent.getChartStyle(n * this.parent.getNumSeriesPerData() + 2);
        }
        return jCChartStyle;
    }

    public JCChartStyle getHiloStyle(int n) {
        JCChartStyle jCChartStyle = null;
        if (this.parent != null) {
            jCChartStyle = this.parent.getChartStyle(n * this.parent.getNumSeriesPerData());
        }
        return jCChartStyle;
    }

    public boolean getIsComplex() {
        return this.isComplex;
    }

    public JCChartStyle getRisingCandleStyle(int n) {
        JCChartStyle jCChartStyle = null;
        if (this.parent != null) {
            jCChartStyle = this.parent.getChartStyle(n * this.parent.getNumSeriesPerData() + 1);
        }
        return jCChartStyle;
    }

    public void loadParams(String string, JCChart jCChart) {
        int n = this.parent.getNumSeriesPerData();
        int n2 = 0;
        while (n2 < this.parent.getNumSeries()) {
            this.getCandleOutlineStyle(n2 / n).loadParams(String.valueOf(string) + ".series" + (n2 / n + 1) + ".outline", jCChart);
            this.getRisingCandleStyle(n2 / n).loadParams(String.valueOf(string) + ".series" + (n2 / n + 1) + ".rising", jCChart);
            this.getFallingCandleStyle(n2 / n).loadParams(String.valueOf(string) + ".series" + (n2 / n + 1) + ".falling", jCChart);
            this.getHiloStyle(n2 / n).loadParams(String.valueOf(string) + ".series" + (n2 / n + 1) + ".hilo", jCChart);
            n2 += n;
        }
        this.setIsComplex(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isComplex"), this.getIsComplex()));
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        JCCandleChartFormat jCCandleChartFormat = new JCCandleChartFormat();
        int n = this.parent.getNumSeriesPerData();
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isComplex", jCCandleChartFormat.isComplex, this.isComplex);
    }

    public void setCandleOutlineStyle(int n, JCChartStyle jCChartStyle) {
        if (this.parent != null) {
            this.parent.setChartStyle(n * this.parent.getNumSeriesPerData() + 3, jCChartStyle);
        }
    }

    public void setFallingCandleStyle(int n, JCChartStyle jCChartStyle) {
        if (this.parent != null) {
            this.parent.setChartStyle(n * this.parent.getNumSeriesPerData() + 2, jCChartStyle);
        }
    }

    public void setHiloStyle(int n, JCChartStyle jCChartStyle) {
        if (this.parent != null) {
            this.parent.setChartStyle(n * this.parent.getNumSeriesPerData(), jCChartStyle);
        }
    }

    public void setIsComplex(boolean bl) {
        JCCandleChartFormat jCCandleChartFormat = this;
        synchronized (jCCandleChartFormat) {
            if (this.isComplex == bl) {
                Object var3_3 = null;
                return;
            }
            this.isComplex = bl;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public void setRisingCandleStyle(int n, JCChartStyle jCChartStyle) {
        if (this.parent != null) {
            this.parent.setChartStyle(n * this.parent.getNumSeriesPerData() + 1, jCChartStyle);
        }
    }
}

