/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jclass.chart.JCChartBundle;
import jclass.util.JCUtilConverter;

public class RadioButtonImageEditor
extends JPanel
implements PropertyEditor,
ItemListener {
    transient Image[] images;
    String[] strings;
    int[] values;
    String prepend = "";
    int rows;
    int cols;
    int numImages;
    boolean upperCaseEnum = true;
    private JPanel orientPanel = null;
    private Object[] radioButtons = null;
    private JRadioButton currentButton = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public String getAsText() {
        return this.getValueAsText();
    }

    protected int getButtonIndex(JRadioButton jRadioButton) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.radioButtons.length) {
            if (this.radioButtons[n2] == jRadioButton) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public Component getCustomEditor() {
        return this;
    }

    public String getJavaInitializationString() {
        if (this.getValue() == null) {
            return "NULL";
        }
        if (this.upperCaseEnum) {
            return String.valueOf(this.prepend) + this.getValueAsText().toUpperCase();
        }
        return String.valueOf(this.prepend) + this.getValueAsText();
    }

    protected JRadioButton getRadioButton(int n) {
        JRadioButton jRadioButton = null;
        int n2 = 0;
        while (n2 < this.radioButtons.length) {
            if (n2 == n) {
                jRadioButton = (JRadioButton)this.radioButtons[n2];
                break;
            }
            ++n2;
        }
        return jRadioButton;
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return new Integer(this.getButtonIndex(this.currentButton));
    }

    protected String getValueAsText() {
        return JCUtilConverter.fromEnum(this.getButtonIndex(this.currentButton), this.strings, this.values);
    }

    protected void init() {
        this.setLayout(new GridLayout(1, 1));
        this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.orientPanel = new JPanel();
        this.orientPanel.setBorder(BorderFactory.createTitledBorder(JCChartBundle.string("jclass.chart.Key174")));
        this.orientPanel.setLayout(new GridLayout(this.rows, this.cols));
        this.radioButtons = new Object[this.numImages];
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < this.numImages) {
            JRadioButton jRadioButton = new JRadioButton(new ImageIcon(this.images[n]));
            this.radioButtons[n] = jRadioButton;
            buttonGroup.add(jRadioButton);
            this.orientPanel.add(jRadioButton);
            jRadioButton.addItemListener(this);
            ++n;
        }
        this.add(this.orientPanel);
    }

    public void init(int n, String[] stringArray, int[] nArray, Image[] imageArray, int n2, int n3, String string) {
        this.numImages = n;
        this.strings = stringArray;
        this.values = nArray;
        this.images = imageArray;
        this.rows = n2;
        this.cols = n3;
        this.prepend = string;
        this.init();
    }

    public boolean isPaintable() {
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            if (jRadioButton == null) {
                return;
            }
            if (jRadioButton == this.currentButton) {
                return;
            }
            boolean bl = jRadioButton.isSelected();
            if (!bl) {
                return;
            }
            this.setCurrentButton(jRadioButton, true);
        }
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBundle.string("jclass.chart.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValueAsText(string);
    }

    protected void setCurrentButton(JRadioButton jRadioButton, boolean bl) {
        if (jRadioButton != null) {
            if (this.currentButton != null) {
                this.currentButton.setBorderPainted(false);
            }
            jRadioButton.setBorderPainted(true);
            this.currentButton = jRadioButton;
            this.currentButton.setSelected(true);
            if (bl) {
                this.support.firePropertyChange(null, null, null);
            }
        }
    }

    public void setValue(Object object) {
        this.setCurrentButton(this.getRadioButton(((Number)object).intValue()), true);
    }

    public void setValueAsText(String string) {
        int n = JCUtilConverter.toEnum(string, "axis orientation", this.strings, this.values, 0);
        this.setCurrentButton(this.getRadioButton(n), true);
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

